;;; @file pet2common.s
;;; Commodore PET II series (model B series) definitions
;;; @author Marko Mkel (msmakela@nic.funet.fi)

;;; start address for the server program (bank $0f)
serverstart = $0400

;;; in the 6522, the interrupt flag has to be reset
clearviaifr = 0
;;; in the 6526, the FLAG line may need debouncing in the C64/C128
ciadebounce = 0

;;; Commodore cassette port definitions
c2nread = $dc0d			; CIA Interrupt Control Register
c2nrdval = $10			; FLAG (cassette read)
c2nwrite = $de01		; TPI1 port register B
c2nwrval = $20			; PB5 (cassette write)

;;; 6551 ACIA definitions
acia = $dd00
r6551dt = acia			; transmit/receive data
r6551sr = acia + 1		; programmed reset/status register
r6551cm = acia + 2		; command register
r6551ct = acia + 3		; control register

;;; memory locations
stemp	= $d8	; memory place that may hold the byte being received

start	= $99	; start address of the transfer area
end	= $96	; end address of the transfer
cinv	= $300	; interrupt vector

bstart	= $2d	; start of basic program text
bend	= $2f	; end of basic program text
crsw	= $d0

stack	= $104	; offset to the stack while in interrupt

	;; program header
#define header

	;; exit from an interrupt
#define irqexit pla:tay:pla:tax:pla:rti
	;; store the speed settings and enable fast speed
#define phfast
	;; restore original speed from fast speed
#define plfast
	;; store the speed settings and enable slow speed (no badlines)
#define phslow
	;; restore original speed from slow speed
#define plslow
	;; disable timer interrupts
#define deactirq sei
	;; re-enable timer interrupts
#define reactirq
