# The CPROVER Manual

1. [Introduction](introduction/)

2. [Installation](installation/)

3. CBMC &ndash; Bounded Model Checking

   * [A Short Tutorial](cbmc/tutorial/)
   * [Loop Unwinding](cbmc/unwinding/)
   * [Assertion Checking](cbmc/assertions/)

4. [Goto-Analyzer &ndash; Abstract Interpretation](goto-analyzer/)

5. [Test Suite Generation](test-suite/)

6. [Program Properties](properties/)

7. Modeling

   * [Nondeterminism](modeling/nondeterminism/)
   * [Assumptions](modeling/assumptions/)
   * [Pointers](modeling/pointers/)
   * [Floating Point](modeling/floating-point/)
   * [Generating Environments](goto-harness/)
   * [Memory-mapped I/O](modeling/mmio/)

8. Build Systems

   * [Integration into Build Systems with goto-cc](goto-cc/)
   * [Integration with Visual Studio builds](visual-studio/)

9. [The CPROVER API Reference](api/)

10. Background Information on selected Command-line Options

   * [Incremental SMT solver](smt2-incr/)
   * [Unsound options](unsound_options/)
