/**
 * Copyright (C) 2009-2013 Paul Fretwell - aka 'Footleg' (drfootleg@gmail.com)
 * 
 * This file is part of Cave Converter.
 * 
 * Cave Converter is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Cave Converter is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Cave Converter.  If not, see <http://www.gnu.org/licenses/>.
 */
package cavesurvey.tools;

import footleg.cavesurvey.data.model.SurveyLeg;
import footleg.cavesurvey.data.model.SurveyStation;

public final class TestHelper {

	public static SurveyLeg createTestLeg(int from, int to, double tape, double compass, double clino) {
		SurveyLeg leg = new SurveyLeg();
		leg.setFromStn(new SurveyStation(from));
		leg.setToStn(new SurveyStation(to));
		leg.setLength(tape);
		leg.setCompass(compass);
		leg.setClino(clino);
		
		return leg;
	}
	
}
