/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.jasper.compiler.JavaCompiler;

public class JikesJavaCompiler
implements JavaCompiler {
    static final int OUTPUT_BUFFER_SIZE = 1024;
    static final int BUFFER_SIZE = 512;
    static final String q = "\\".equals(System.getProperty("file.separator")) ? "\"" : "";
    static StringBuffer MicrosoftClasspath = null;
    String encoding;
    String classpath;
    String compilerPath = "jikes";
    String outdir;
    OutputStream out;
    boolean classDebugInfo = false;

    public void setCompilerPath(String compilerPath) {
        this.compilerPath = compilerPath;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setOutputDir(String outdir) {
        this.outdir = outdir;
    }

    public void setMsgOutput(OutputStream out) {
        this.out = out;
    }

    public void setClassDebugInfo(boolean classDebugInfo) {
        this.classDebugInfo = classDebugInfo;
    }

    public boolean compile(String source) {
        boolean isOkay;
        int exitValue = -1;
        if (MicrosoftClasspath == null) {
            MicrosoftClasspath = new StringBuffer(200);
            if (System.getProperty("java.vendor").startsWith("Microsoft")) {
                String javaHome = System.getProperty("java.home") + "\\Packages";
                File libDir = new File(javaHome);
                String[] zips = libDir.list();
                for (int i = 0; i < zips.length; ++i) {
                    MicrosoftClasspath.append(";" + javaHome + "\\" + zips[i]);
                }
            }
        }
        String[] compilerCmd = this.classDebugInfo ? new String[]{q + this.compilerPath + q, "-g", "-classpath", q + this.classpath + MicrosoftClasspath + q, "-d", q + this.outdir + q, "-nowarn", q + source + q} : new String[]{q + this.compilerPath + q, "-classpath", q + this.classpath + MicrosoftClasspath + q, "-d", q + this.outdir + q, "-nowarn", q + source + q};
        ByteArrayOutputStream tmpErr = new ByteArrayOutputStream(1024);
        try {
            Process p = Runtime.getRuntime().exec(compilerCmd);
            BufferedInputStream compilerErr = new BufferedInputStream(p.getErrorStream());
            StreamPumper errPumper = new StreamPumper(compilerErr, tmpErr);
            errPumper.start();
            p.waitFor();
            exitValue = p.exitValue();
            errPumper.join();
            compilerErr.close();
            p.destroy();
            tmpErr.close();
            tmpErr.writeTo(this.out);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
        boolean bl = isOkay = exitValue == 0;
        if (tmpErr.size() > 0) {
            isOkay = false;
        }
        return isOkay;
    }

    class StreamPumper
    extends Thread {
        private BufferedInputStream stream;
        private boolean endOfStream = false;
        private boolean stopSignal = false;
        private int SLEEP_TIME = 5;
        private OutputStream out;

        public StreamPumper(BufferedInputStream is, OutputStream out) {
            this.stream = is;
            this.out = out;
        }

        public void pumpStream() throws IOException {
            byte[] buf = new byte[512];
            if (!this.endOfStream) {
                int bytesRead = this.stream.read(buf, 0, 512);
                if (bytesRead > 0) {
                    this.out.write(buf, 0, bytesRead);
                } else if (bytesRead == -1) {
                    this.endOfStream = true;
                }
            }
        }

        public void run() {
            try {
                while (!this.endOfStream) {
                    this.pumpStream();
                    StreamPumper.sleep(this.SLEEP_TIME);
                }
            }
            catch (InterruptedException ie) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

