/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import org.apache.jasper.CommandLineContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.Mangler;

public class CommandLineCompiler
extends Compiler
implements Mangler {
    String javaFileName;
    String classFileName;
    String pkgName;
    String className;
    File jsp;
    String outputDir;
    public static String[] keywords = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public CommandLineCompiler(CommandLineContext ctxt) {
        super(ctxt);
        this.jsp = new File(ctxt.getJspFile());
        this.outputDir = ctxt.getOptions().getScratchDir().getAbsolutePath();
        this.setMangler(this);
        this.computePackageName();
        ctxt.setServletPackageName(this.pkgName);
        this.className = this.getBaseClassName();
        if (ctxt.isOutputInDirs()) {
            String tmpDir;
            File f;
            String pkgName = ctxt.getServletPackageName();
            if (pkgName == null) {
                pkgName = "";
            }
            if (!(f = new File(tmpDir = this.outputDir + File.separatorChar + pkgName.replace('.', File.separatorChar))).exists()) {
                if (f.mkdirs()) {
                    this.outputDir = tmpDir;
                }
            } else {
                this.outputDir = tmpDir;
            }
        }
        this.computeClassFileName();
        this.computeJavaFileName();
    }

    public boolean isOutDated() {
        return true;
    }

    public final void computeJavaFileName() {
        this.javaFileName = this.ctxt.getServletClassName() + ".java";
        if ("null.java".equals(this.javaFileName)) {
            this.javaFileName = this.getBaseClassName() + ".java";
        }
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.javaFileName = this.outputDir + File.separatorChar + this.javaFileName;
        }
    }

    void computeClassFileName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        this.classFileName = prefix + this.getBaseClassName() + ".class";
        if (this.outputDir != null && !this.outputDir.equals("")) {
            this.classFileName = this.outputDir + File.separatorChar + this.classFileName;
        }
    }

    void computePackageName() {
        String pathName = this.jsp.getPath();
        StringBuffer modifiedpkgName = new StringBuffer();
        int indexOfSepChar = pathName.lastIndexOf(File.separatorChar);
        if ("".equals(this.ctxt.getServletPackageName()) || indexOfSepChar == -1 || indexOfSepChar == 0) {
            this.pkgName = null;
        } else {
            int i;
            for (i = 0; i < keywords.length; ++i) {
                char fs = File.separatorChar;
                int index = pathName.startsWith(keywords[i] + fs) ? 0 : pathName.indexOf(fs + keywords[i] + fs);
                while (index != -1) {
                    String tmpathName = pathName.substring(0, index + 1) + '%';
                    pathName = tmpathName + pathName.substring(index + 2);
                    index = pathName.indexOf(fs + keywords[i] + fs);
                }
            }
            pathName = pathName.replace('.', '_');
            this.pkgName = pathName.substring(0, pathName.lastIndexOf(File.separatorChar)).replace(File.separatorChar, '.');
            if (this.ctxt.getServletPackageName() != null) {
                this.pkgName = this.ctxt.getServletPackageName();
            }
            for (i = 0; i < this.pkgName.length(); ++i) {
                if (Character.isLetter(this.pkgName.charAt(i)) || this.pkgName.charAt(i) == '.') {
                    modifiedpkgName.append(this.pkgName.substring(i, i + 1));
                    continue;
                }
                modifiedpkgName.append(CommandLineCompiler.mangleChar(this.pkgName.charAt(i)));
            }
            if (modifiedpkgName.charAt(0) == '.') {
                String modifiedpkgNameString = modifiedpkgName.toString();
                this.pkgName = modifiedpkgNameString.substring(1, modifiedpkgName.length());
            } else {
                this.pkgName = modifiedpkgName.toString();
            }
        }
    }

    private final String getInitialClassName() {
        String prefix = this.getPrefix(this.jsp.getPath());
        return prefix + this.getBaseClassName() + "_jsp_" + "0";
    }

    private final String getBaseClassName() {
        String className = this.ctxt.getServletClassName();
        if (className == null) {
            className = this.jsp.getName().endsWith(".jsp") ? this.jsp.getName().substring(0, this.jsp.getName().length() - 4) : this.jsp.getName();
        }
        for (int i = 0; i < keywords.length; ++i) {
            if (!className.equals(keywords[i])) continue;
            className = className + "%";
        }
        StringBuffer modifiedClassName = new StringBuffer();
        char c = '/';
        if (Character.isDigit(className.charAt(0))) {
            className = "_" + className;
        }
        for (int i = 0; i < className.length(); ++i) {
            char prev = c;
            c = className.charAt(i);
            if (prev == '/' && c == '/') continue;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '/') {
                modifiedClassName.append(className.substring(i, i + 1));
                continue;
            }
            modifiedClassName.append(CommandLineCompiler.mangleChar(className.charAt(i)));
        }
        return modifiedClassName.toString();
    }

    private final String getPrefix(String pathName) {
        if (pathName != null) {
            StringBuffer modifiedName = new StringBuffer();
            for (int i = 0; i < pathName.length(); ++i) {
                if (Character.isLetter(pathName.charAt(i))) {
                    modifiedName.append(pathName.substring(i, i + 1));
                    continue;
                }
                modifiedName.append(CommandLineCompiler.mangleChar(pathName.charAt(i)));
            }
            return modifiedName.toString();
        }
        return "";
    }

    private static final String mangleChar(char ch) {
        int i;
        if (ch == File.separatorChar) {
            ch = (char)47;
        }
        String s = Integer.toHexString(ch);
        int nzeros = 5 - s.length();
        char[] result = new char[6];
        result[0] = 95;
        for (i = 1; i <= nzeros; ++i) {
            result[i] = 48;
        }
        i = nzeros + 1;
        int j = 0;
        while (i < 6) {
            result[i] = s.charAt(j);
            ++i;
            ++j;
        }
        return new String(result);
    }

    public final String getPackageName() {
        return this.pkgName;
    }

    public final String getClassName() {
        return this.className;
    }

    public final String getJavaFileName() {
        return this.javaFileName;
    }

    public final String getClassFileName() {
        return this.classFileName;
    }
}

