/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.CommandLineCompiler;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.servlet.JasperLoader;

public class CommandLineContext
implements JspCompilationContext {
    String classPath;
    JspReader reader;
    ServletWriter writer;
    JasperLoader loader;
    boolean errPage;
    String jspFile;
    String servletClassName;
    String servletPackageName;
    String servletJavaFileName;
    String contentType;
    Options options;
    String uriBase;
    File uriRoot;
    boolean packageNameLocked;
    boolean classNameLocked;
    boolean outputInDirs;

    public CommandLineContext(JasperLoader newLoader, String newClassPath, String newJspFile, String newUriBase, String newUriRoot, boolean newErrPage, Options newOptions) throws JasperException {
        this.loader = newLoader;
        this.classPath = newClassPath;
        this.uriBase = newUriBase;
        String tUriRoot = newUriRoot;
        this.jspFile = newJspFile;
        this.errPage = newErrPage;
        this.options = newOptions;
        if (this.uriBase == null) {
            this.uriBase = "/";
        } else if (this.uriBase.charAt(0) != '/') {
            this.uriBase = "/" + this.uriBase;
        }
        if (this.uriBase.charAt(this.uriBase.length() - 1) != '/') {
            this.uriBase = this.uriBase + '/';
        }
        if (tUriRoot == null) {
            this.uriRoot = new File("");
        } else {
            this.uriRoot = new File(tUriRoot);
            if (!this.uriRoot.exists() || !this.uriRoot.isDirectory()) {
                throw new JasperException(Constants.getString("jsp.error.jspc.uriroot_not_dir"));
            }
        }
    }

    public String getClassPath() {
        return this.classPath;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public void addJar(String jar) throws IOException {
        this.loader.addJar(jar);
    }

    public boolean isErrorPage() {
        return this.errPage;
    }

    public String getOutputDir() {
        return this.options.getScratchDir().toString();
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String getFullClassName() {
        String pkg = this.getServletPackageName();
        pkg = pkg != null ? pkg + "." : "";
        return pkg + this.getServletClassName();
    }

    public String getServletJavaFileName() {
        if (this.outputInDirs) {
            return this.getServletPackageName().replace('.', File.separatorChar) + this.servletJavaFileName;
        }
        return this.servletJavaFileName;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String getContentType() {
        return this.contentType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }

    public void setServletClassName(String servletClassName) {
        if (!this.classNameLocked) {
            this.servletClassName = servletClassName;
        }
    }

    public void setServletPackageName(String servletPackageName) {
        if (!this.packageNameLocked) {
            this.servletPackageName = servletPackageName;
        }
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setErrorPage(boolean isErrPage) {
        this.errPage = isErrPage;
    }

    public void lockPackageName() {
        this.packageNameLocked = true;
    }

    public void lockClassName() {
        this.classNameLocked = true;
    }

    public void setOutputInDirs(boolean newValue) {
        this.outputInDirs = true;
    }

    public boolean isOutputInDirs() {
        return this.outputInDirs;
    }

    public Compiler createCompiler() throws JasperException {
        return new CommandLineCompiler(this);
    }

    public String resolveRelativeUri(String uri) {
        if (uri.startsWith("/")) {
            return uri;
        }
        return this.uriBase + uri;
    }

    public InputStream getResourceAsStream(String res) {
        InputStream in;
        try {
            in = new FileInputStream(this.getRealPath(res));
        }
        catch (IOException ioe) {
            in = null;
        }
        if (in == null) {
            try {
                in = new FileInputStream(res);
            }
            catch (IOException ioe) {
                in = null;
            }
        }
        if (in == null) {
            in = this.loader.getResourceAsStream(res);
        }
        return in;
    }

    public String getRealPath(String path) {
        int i;
        if ((path = this.resolveRelativeUri(path)).startsWith("/")) {
            path = path.substring(1);
        }
        if (!path.startsWith(File.separator) && !this.jspFile.endsWith(path) && (i = this.jspFile.lastIndexOf(File.separatorChar)) >= 0) {
            path = this.jspFile.substring(0, i + 1) + path;
        }
        File f = new File(this.uriRoot, path.replace('/', File.separatorChar));
        return f.getAbsolutePath();
    }
}

