/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FilteredTermEnum;

public class WildcardTermEnum
extends FilteredTermEnum {
    Term searchTerm;
    String field = "";
    String text = "";
    String pre = "";
    int preLen = 0;
    boolean fieldMatch = false;
    boolean endEnum = false;
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';

    public WildcardTermEnum(IndexReader indexReader, Term term) throws IOException {
        super(indexReader, term);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        this.text = this.searchTerm.text();
        int n = this.text.indexOf(42);
        int n2 = this.text.indexOf(63);
        int n3 = n;
        if (n3 == -1) {
            n3 = n2;
        } else if (n2 >= 0) {
            n3 = Math.min(n3, n2);
        }
        this.pre = this.searchTerm.text().substring(0, n3);
        this.preLen = this.pre.length();
        this.text = this.text.substring(this.preLen);
        this.setEnum(indexReader.terms(new Term(this.searchTerm.field(), this.pre)));
    }

    protected final boolean termCompare(Term term) {
        String string;
        if (this.field == term.field() && (string = term.text()).startsWith(this.pre)) {
            return WildcardTermEnum.wildcardEquals(this.text, 0, string, this.preLen);
        }
        this.endEnum = true;
        return false;
    }

    public final float difference() {
        return 1.0f;
    }

    public final boolean endEnum() {
        return this.endEnum;
    }

    public static final boolean wildcardEquals(String string, int n, String string2, int n2) {
        int n3 = n;
        int n4 = n2;
        while (true) {
            int n5;
            boolean bl;
            boolean bl2 = n4 >= string2.length();
            boolean bl3 = bl = n3 >= string.length();
            if (bl2) {
                n5 = 1;
                int n6 = n3;
                while (n6 < string.length() && n5 != 0) {
                    char c = string.charAt(n6);
                    if (c != '?' && c != '*') {
                        n5 = 0;
                        continue;
                    }
                    ++n6;
                }
                if (n5 != 0) {
                    return true;
                }
            }
            if (bl2 || bl) break;
            if (string.charAt(n3) != '?') {
                if (string.charAt(n3) == '*') {
                    ++n3;
                    n5 = string2.length();
                    while (n5 >= n4) {
                        if (WildcardTermEnum.wildcardEquals(string, n3, string2, n5)) {
                            return true;
                        }
                        --n5;
                    }
                    break;
                }
                if (string.charAt(n3) != string2.charAt(n4)) break;
            }
            ++n3;
            ++n4;
        }
        return false;
    }

    public void close() throws IOException {
        super.close();
        this.searchTerm = null;
        this.field = null;
        this.text = null;
    }
}

