/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Searcher;

public final class Similarity {
    static final float[] NORM_TABLE = Similarity.makeNormTable();

    private Similarity() {
    }

    public static final byte norm(int n) {
        return (byte)Math.ceil(255.0 / Math.sqrt(n));
    }

    private static final float[] makeNormTable() {
        float[] fArray = new float[256];
        int n = 0;
        while (n < 256) {
            fArray[n] = (float)n / 255.0f;
            ++n;
        }
        return fArray;
    }

    static final float norm(byte by) {
        return NORM_TABLE[by & 0xFF];
    }

    static final float tf(int n) {
        return (float)Math.sqrt(n);
    }

    static final float tf(float f) {
        return (float)Math.sqrt(f);
    }

    static final float idf(Term term, Searcher searcher) throws IOException {
        return Similarity.idf(searcher.docFreq(term), searcher.maxDoc());
    }

    static final float idf(int n, int n2) {
        return (float)(Math.log((double)n2 / (double)(n + 1)) + 1.0);
    }

    static final float coord(int n, int n2) {
        return (float)n / (float)n2;
    }
}

