/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Filter;

public final class DateFilter
extends Filter {
    String field;
    String start = DateField.MIN_DATE_STRING();
    String end = DateField.MAX_DATE_STRING();

    private DateFilter(String string) {
        this.field = string;
    }

    public DateFilter(String string, Date date, Date date2) {
        this.field = string;
        this.start = DateField.dateToString(date);
        this.end = DateField.dateToString(date2);
    }

    public DateFilter(String string, long l, long l2) {
        this.field = string;
        this.start = DateField.timeToString(l);
        this.end = DateField.timeToString(l2);
    }

    public static DateFilter Before(String string, Date date) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.end = DateField.dateToString(date);
        return dateFilter;
    }

    public static DateFilter Before(String string, long l) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.end = DateField.timeToString(l);
        return dateFilter;
    }

    public static DateFilter After(String string, Date date) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.start = DateField.dateToString(date);
        return dateFilter;
    }

    public static DateFilter After(String string, long l) {
        DateFilter dateFilter = new DateFilter(string);
        dateFilter.start = DateField.timeToString(l);
        return dateFilter;
    }

    public final BitSet bits(IndexReader indexReader) throws IOException {
        BitSet bitSet = new BitSet(indexReader.maxDoc());
        TermEnum termEnum = indexReader.terms(new Term(this.field, this.start));
        TermDocs termDocs = indexReader.termDocs();
        if (termEnum.term() == null) {
            return bitSet;
        }
        try {
            Term term = new Term(this.field, this.end);
            while (termEnum.term().compareTo(term) <= 0) {
                Object var7_6;
                termDocs.seek(termEnum.term());
                try {
                    while (termDocs.next()) {
                        bitSet.set(termDocs.doc());
                    }
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    termDocs.close();
                    throw throwable;
                }
                termDocs.close();
                if (termEnum.next()) continue;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            termEnum.close();
            throw throwable;
        }
        termEnum.close();
        return bitSet;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.field);
        stringBuffer.append(":");
        stringBuffer.append(DateField.stringToDate(this.start).toString());
        stringBuffer.append("-");
        stringBuffer.append(DateField.stringToDate(this.end).toString());
        return stringBuffer.toString();
    }
}

