/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryParser.CharStream;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.queryParser.QueryParserTokenManager;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public class MultiFieldQueryParser
extends QueryParser {
    public static final int NORMAL_FIELD = 0;
    public static final int REQUIRED_FIELD = 1;
    public static final int PROHIBITED_FIELD = 2;

    public MultiFieldQueryParser(QueryParserTokenManager queryParserTokenManager) {
        super(queryParserTokenManager);
    }

    public MultiFieldQueryParser(CharStream charStream) {
        super(charStream);
    }

    public MultiFieldQueryParser(String string, Analyzer analyzer) {
        super(string, analyzer);
    }

    public static Query parse(String string, String[] stringArray, Analyzer analyzer) throws ParseException {
        BooleanQuery booleanQuery = new BooleanQuery();
        int n = 0;
        while (n < stringArray.length) {
            Query query = QueryParser.parse(string, stringArray[n], analyzer);
            booleanQuery.add(query, false, false);
            ++n;
        }
        return booleanQuery;
    }

    public static Query parse(String string, String[] stringArray, int[] nArray, Analyzer analyzer) throws ParseException {
        BooleanQuery booleanQuery = new BooleanQuery();
        int n = 0;
        while (n < stringArray.length) {
            Query query = QueryParser.parse(string, stringArray[n], analyzer);
            int n2 = nArray[n];
            switch (n2) {
                case 1: {
                    booleanQuery.add(query, true, false);
                    break;
                }
                case 2: {
                    booleanQuery.add(query, false, true);
                    break;
                }
                default: {
                    booleanQuery.add(query, false, false);
                }
            }
            ++n;
        }
        return booleanQuery;
    }
}

