/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.Reader;
import java.util.Hashtable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class StandardAnalyzer
extends Analyzer {
    private Hashtable stopTable;
    public static final String[] STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};

    public StandardAnalyzer() {
        this(STOP_WORDS);
    }

    public StandardAnalyzer(String[] stringArray) {
        this.stopTable = StopFilter.makeStopTable(stringArray);
    }

    public final TokenStream tokenStream(String string, Reader reader) {
        TokenStream tokenStream = new StandardTokenizer(reader);
        tokenStream = new StandardFilter(tokenStream);
        tokenStream = new LowerCaseFilter(tokenStream);
        tokenStream = new StopFilter(tokenStream, this.stopTable);
        return tokenStream;
    }
}

