/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.caudium.servlet.CaudiumServletContext;
import net.caudium.servlet.HTTPOutputStream;
import net.caudium.servlet.HeaderTokenizer;

class ServletResponse
implements HttpServletResponse {
    int contentLength = -1;
    String contentType = null;
    String encoding = null;
    HTTPOutputStream pikeStream;
    ServletOutputStream outputStream = null;
    PrintWriter writer = null;
    Dictionary headers = null;
    int status = 200;
    String statusmsg = null;
    Locale locale = Locale.getDefault();
    static Dictionary statusTexts = new Hashtable();

    public void setContentLength(int n) {
        this.contentLength = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentType(String string) {
        if (this.contentType != null) return;
        this.contentType = string;
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
        try {
            headerTokenizer.getValue();
            headerTokenizer.discard('/');
            headerTokenizer.getValue();
            if (!headerTokenizer.more()) return;
            while (true) {
                if (!headerTokenizer.lookingAt(';')) {
                    if (headerTokenizer.more()) {
                        headerTokenizer.getValue();
                        continue;
                    }
                }
                headerTokenizer.discard(';');
                if (!headerTokenizer.more()) return;
                if ("charset".equalsIgnoreCase(headerTokenizer.getValue())) break;
            }
            headerTokenizer.discard('=');
            this.encoding = headerTokenizer.getValue();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.outputStream == null) {
            if (this.writer != null) {
                throw new IllegalStateException();
            }
            this.outputStream = this.pikeStream;
        }
        return this.outputStream;
    }

    void commitRequest(ServletOutputStream servletOutputStream) throws IOException {
        Object v;
        servletOutputStream.println("HTTP/1.0 " + this.status + " " + ((v = statusTexts.get(new Integer(this.status))) == null ? "Foo" : (String)v));
        if (!this.containsHeader("Content-Type")) {
            servletOutputStream.println("Content-Type: " + this.contentType);
        }
        if (this.contentLength != -1 && !this.containsHeader("Content-Length")) {
            servletOutputStream.println("Content-Length: " + this.contentLength);
        }
        if (this.headers != null) {
            Enumeration enumeration = this.headers.elements();
            while (enumeration.hasMoreElements()) {
                Object v2 = enumeration.nextElement();
                if (v2 instanceof String) {
                    servletOutputStream.println((String)v2);
                    continue;
                }
                Iterator iterator = ((List)v2).iterator();
                while (iterator.hasNext()) {
                    servletOutputStream.println((String)iterator.next());
                }
            }
        }
        servletOutputStream.println();
        if (this.statusmsg != null) {
            servletOutputStream.print(this.statusmsg);
        }
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            if (this.outputStream != null) {
                throw new IllegalStateException();
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.pikeStream), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public String getCharacterEncoding() {
        if (this.encoding == null) {
            if (this.contentType == null) {
                this.contentType = "text/plain";
            }
            this.encoding = System.getProperty("file.encoding", "iso-8859-1");
            this.contentType = this.contentType + "; charset=" + ServletResponse.encodeValue(this.encoding);
        }
        return this.encoding;
    }

    public void addCookie(Cookie cookie) {
        int n;
        String string;
        String string2 = null;
        if (this.headers != null) {
            string2 = (String)this.headers.get("set-cookie");
        }
        if (string2 != null && string2 instanceof String) {
            string = (String)string2 + ",\r\n\t";
            string2 = null;
        } else {
            string = "Set-Cookie: ";
        }
        string = string + ServletResponse.encodeValue(cookie.getName()) + "=" + ServletResponse.encodeValue(cookie.getValue());
        String string3 = cookie.getComment();
        if (string3 != null) {
            string = string + "; Comment=" + ServletResponse.encodeValue(string3);
        }
        if ((string3 = cookie.getDomain()) != null) {
            string = string + "; Domain=" + ServletResponse.encodeValue(string3);
        }
        if ((n = cookie.getMaxAge()) != -1) {
            string = string + "; Max-Age=" + n;
        }
        if ((string3 = cookie.getPath()) != null) {
            string = string + "; Path=" + ServletResponse.encodeValue(string3);
        }
        if (cookie.getSecure()) {
            string = string + "; Secure";
        }
        if ((n = cookie.getVersion()) != 0) {
            string = string + "; Version=" + n;
        }
        if (string2 == null) {
            string2 = string;
        } else {
            ((List)((Object)string2)).add(string);
        }
        this.setHeader("set-cookie", (Object)string2);
    }

    void setSessionId(HttpSession httpSession) {
        Cookie cookie = new Cookie("JSESSIONID", httpSession.getId());
        int n = httpSession.getMaxInactiveInterval();
        if (n >= 0) {
            cookie.setMaxAge(n);
        }
        cookie.setComment("servlet session tracking");
        this.addCookie(cookie);
    }

    protected static final boolean badAtomChar(char c) {
        return c <= ' ' || c >= '\u007f' || c == '(' || c == ')' || c == '[' || c == ']' || c == '\"' || c == ',' || c == '\\' || c == '/' || c == '{' || c == '}' || c >= ':' && c <= '@';
    }

    protected static final String encodeValue(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        int n = 0;
        while (n < string.length()) {
            if (ServletResponse.badAtomChar(string.charAt(n))) {
                int n2 = 0;
                while ((n2 = string.indexOf(92, n2)) >= 0) {
                    string = string.substring(0, n2) + '\\' + string.substring(n2);
                    n2 += 2;
                }
                int n3 = 0;
                while ((n3 = string.indexOf(34, n3)) >= 0) {
                    string = string.substring(0, n3) + '\\' + string.substring(n3);
                    n3 += 2;
                }
                return '\"' + string + '\"';
            }
            ++n;
        }
        return string;
    }

    public boolean containsHeader(String string) {
        return this.headers != null && this.headers.get(string.toLowerCase()) != null;
    }

    public void setStatus(int n, String string) {
        this.statusmsg = "<body>" + string + "</body>\r\n";
        this.setContentType("text/html");
        this.setContentLength(this.statusmsg.length());
        this.setStatus(n);
    }

    public void setStatus(int n) {
        this.status = n;
    }

    private void setHeader(String string, Object object) {
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(string, object);
    }

    public void setHeader(String string, String string2) {
        this.setHeader(string.toLowerCase(), (Object)(string + ": " + string2));
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, Integer.toString(n));
    }

    public void setDateHeader(String string, long l) {
        this.setHeader(string, CaudiumServletContext.dateformat.format(new Date(l)));
    }

    public void sendError(int n, String string) throws IOException {
        this.statusmsg = "<body>" + string + "</body>\r\n";
        this.sendError(n);
    }

    public void sendError(int n) throws IOException {
        this.reset();
        this.outputStream = null;
        this.setContentType("text/html");
        this.setContentLength(this.statusmsg == null ? 0 : this.statusmsg.length());
        this.setStatus(n);
        this.getWriter().close();
    }

    public void sendRedirect(String string) throws IOException {
        this.setHeader("Location", string);
        this.sendError(302);
    }

    public String encodeUrl(String string) {
        return this.encodeURL(string);
    }

    public String encodeRedirectUrl(String string) {
        return this.encodeRedirectURL(string);
    }

    public String encodeURL(String string) {
        return string;
    }

    public String encodeRedirectURL(String string) {
        return string;
    }

    void wrapUp() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.pikeStream.close();
    }

    ServletResponse(HTTPOutputStream hTTPOutputStream) {
        this.pikeStream = hTTPOutputStream;
        this.pikeStream.setResponse(this);
    }

    public void setBufferSize(int n) {
        this.pikeStream.setBufferSize(n);
    }

    public int getBufferSize() {
        return this.pikeStream.getBufferSize();
    }

    public void reset() {
        this.pikeStream.reset();
    }

    public boolean isCommitted() {
        return this.pikeStream.isCommitted();
    }

    public void flushBuffer() throws IOException {
        this.pikeStream.flush();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setHeader("Content-Language", this.locale.getLanguage());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void addHeader(String string, String string2) {
        Object object;
        Object object2 = object = this.headers != null ? (Object)this.headers.get(string.toLowerCase()) : null;
        if (object == null) {
            object = string + ": " + string2;
        } else if (object instanceof String) {
            Vector<String> vector = new Vector<String>(2);
            vector.add((String)object);
            vector.add(string + ": " + string2);
            object = vector;
        } else {
            ((List)object).add(string + ": " + string2);
        }
        this.setHeader(string.toLowerCase(), object);
    }

    public void addDateHeader(String string, long l) {
        this.addHeader(string, CaudiumServletContext.dateformat.format(new Date(l)));
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, Integer.toString(n));
    }

    static {
        statusTexts.put(new Integer(200), "OK");
        statusTexts.put(new Integer(201), "Created");
        statusTexts.put(new Integer(202), "Accepted");
        statusTexts.put(new Integer(203), "Provisional Information");
        statusTexts.put(new Integer(204), "No Content");
        statusTexts.put(new Integer(300), "Moved");
        statusTexts.put(new Integer(301), "Permanent Relocation");
        statusTexts.put(new Integer(302), "Temporary Relocation");
        statusTexts.put(new Integer(303), "See Other");
        statusTexts.put(new Integer(304), "Not Modified");
        statusTexts.put(new Integer(400), "Bad Request");
        statusTexts.put(new Integer(401), "Access denied");
        statusTexts.put(new Integer(402), "Payment Required");
        statusTexts.put(new Integer(403), "Forbidden");
        statusTexts.put(new Integer(404), "No such file or directory");
        statusTexts.put(new Integer(405), "Method not allowed");
        statusTexts.put(new Integer(407), "Proxy authorization needed");
        statusTexts.put(new Integer(408), "Request timeout");
        statusTexts.put(new Integer(409), "Conflict");
        statusTexts.put(new Integer(410), "Gone");
        statusTexts.put(new Integer(500), "Internal Server Error");
        statusTexts.put(new Integer(501), "Not Implemented");
        statusTexts.put(new Integer(502), "Gateway Timeout");
        statusTexts.put(new Integer(503), "Service unavailable");
    }
}

