/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.Principal;
import java.text.ParseException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.caudium.servlet.CaudiumServletContext;
import net.caudium.servlet.CaudiumSessionContext;
import net.caudium.servlet.HTTPInputStream;
import net.caudium.servlet.HeaderTokenizer;
import net.caudium.servlet.ServletResponse;

class ServletRequest
implements HttpServletRequest {
    CaudiumServletContext context;
    CaudiumSessionContext sessioncontext;
    ServletResponse response = null;
    int contentLength;
    String contentType;
    String protocol;
    String scheme;
    String serverName;
    int serverPort;
    String remoteAddr;
    String remoteHost;
    String data;
    String mountpoint;
    String servletPath;
    String pathInfo;
    String method;
    String remuser;
    String requestURI;
    String queryString;
    String pathTranslated;
    Dictionary parameters = new Hashtable();
    Dictionary attributes = new Hashtable();
    Dictionary headers = new Hashtable();
    BufferedReader reader = null;
    ServletInputStream inputStream = null;

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    protected static native String blockingIPToHost(String var0);

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = ServletRequest.blockingIPToHost(this.remoteAddr);
        }
        return this.remoteHost;
    }

    public String getRealPath(String string) {
        return this.context.getRealPath(string);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new HTTPInputStream(this.data);
        }
        return this.inputStream;
    }

    public String getParameter(String string) {
        String[] stringArray = this.getParameterValues(string);
        return stringArray == null || stringArray.length == 0 ? null : stringArray[0];
    }

    public String[] getParameterValues(String string) {
        return (String[])this.parameters.get(string);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), this.getCharacterEncoding()));
        }
        return this.reader;
    }

    public Cookie[] getCookies() {
        Enumeration enumeration = this.getHeaders("Cookie");
        if (enumeration == null) {
            return new Cookie[0];
        }
        Vector<Cookie> vector = new Vector<Cookie>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                HeaderTokenizer headerTokenizer = new HeaderTokenizer(string);
                Cookie cookie = null;
                int n = 0;
                while (headerTokenizer.more()) {
                    String string2 = headerTokenizer.getValue();
                    String string3 = "";
                    if (headerTokenizer.lookingAt('=')) {
                        headerTokenizer.discard('=');
                        string3 = headerTokenizer.getValue();
                    }
                    if (headerTokenizer.more()) {
                        headerTokenizer.discard(headerTokenizer.lookingAt(',') ? (char)',' : ';');
                    }
                    if (string2.startsWith("$")) {
                        if (string2.equals("$version")) {
                            n = Integer.parseInt(string3);
                            continue;
                        }
                        if (cookie == null) continue;
                        if (string2.equals("$domain")) {
                            cookie.setDomain(string3);
                            continue;
                        }
                        if (!string2.equals("$path")) continue;
                        cookie.setPath(string3);
                        continue;
                    }
                    cookie = new Cookie(string2, string3);
                    vector.add(cookie);
                    if (n == 0) continue;
                    cookie.setVersion(n);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return vector.toArray(new Cookie[vector.size()]);
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remuser;
    }

    public String getAuthType() {
        return this.remuser != null ? "Basic" : null;
    }

    public String getHeader(String string) {
        Enumeration enumeration = this.getHeaders(string);
        if (enumeration == null) {
            return null;
        }
        return (String)enumeration.nextElement();
    }

    public int getIntHeader(String string) throws NumberFormatException {
        String string2 = this.getHeader(string);
        return string2 == null ? -1 : Integer.parseInt(string2);
    }

    public long getDateHeader(String string) throws IllegalArgumentException {
        String string2 = this.getHeader(string);
        try {
            return string2 == null ? -1L : CaudiumServletContext.dateformat.parse(string2).getTime();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage());
        }
    }

    public Enumeration getHeaderNames() {
        return this.headers == null ? null : this.headers.keys();
    }

    public String getCharacterEncoding() {
        return "8859_1";
    }

    public HttpSession getSession(boolean bl) {
        String string = this.getRequestedSessionId();
        HttpSession httpSession = this.sessioncontext.getSession(string, bl);
        if (httpSession != null && !httpSession.getId().equals(string) && this.response != null) {
            this.response.setSessionId(httpSession);
        }
        return httpSession;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getRequestedSessionId() {
        Cookie[] cookieArray = this.getCookies();
        int n = 0;
        while (n < cookieArray.length) {
            if ("JSESSIONID".equalsIgnoreCase(cookieArray[n].getName())) {
                return cookieArray[n].getValue();
            }
            ++n;
        }
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession httpSession = this.getSession(false);
        return httpSession != null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequestedSessionId() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    void setResponse(ServletResponse servletResponse) {
        this.response = servletResponse;
    }

    ServletRequest(CaudiumServletContext caudiumServletContext, CaudiumSessionContext caudiumSessionContext, int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15) {
        this.context = caudiumServletContext;
        this.sessioncontext = caudiumSessionContext;
        this.contentLength = n;
        this.contentType = string;
        this.protocol = string2;
        this.scheme = string3;
        this.serverName = string4;
        this.serverPort = n2;
        this.remoteAddr = string5;
        this.remoteHost = string6;
        this.data = string7;
        this.mountpoint = string8;
        this.servletPath = string9;
        this.pathInfo = string10;
        this.method = string11;
        this.remuser = string12;
        this.requestURI = string13;
        this.queryString = string14;
        this.pathTranslated = string15;
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    protected Locale parseLocale(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ";-", true);
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken();
            if (";".equals(string5)) break;
            if ("-".equals(string5)) continue;
            if (string2 == null) {
                string2 = string5.toLowerCase();
                continue;
            }
            if (string3 == null) {
                string3 = string5.toUpperCase();
                continue;
            }
            string4 = string5;
            break;
        }
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            return new Locale(string2, "");
        }
        if (string4 == null) {
            return new Locale(string2, string3);
        }
        return new Locale(string2, string3, string4);
    }

    public Locale getLocale() {
        String string = this.getHeader("Accept-Language");
        if (string == null) {
            return Locale.getDefault();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        return this.parseLocale(stringTokenizer.nextToken());
    }

    /*
     * Unable to fully structure code
     */
    public Enumeration getLocales() {
        block2: {
            var1_1 = this.getHeaders("Accept-Language");
            var2_2 = new Vector<Locale>();
            if (var1_1 != null && var1_1.hasMoreElements()) ** GOTO lbl12
            var2_2.add(Locale.getDefault());
            break block2;
lbl-1000:
            // 1 sources

            {
                var3_3 = new StringTokenizer((String)var1_1.nextElement(), ",");
                while (var3_3.hasMoreTokens()) {
                    var2_2.add(this.parseLocale(var3_3.nextToken()));
                }
lbl12:
                // 2 sources

                ** while (var1_1.hasMoreElements())
            }
        }
        return var2_2.elements();
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.protocol);
    }

    public RequestDispatcher getRequestDispatcher(String string) {
        return this.context.getRequestDispatcher(this.servletPath + this.pathInfo + "x/..", string);
    }

    public Enumeration getHeaders(String string) {
        if (this.headers == null) {
            return null;
        }
        Object v = this.headers.get(string.toLowerCase());
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            Vector vector = new Vector(1);
            vector.add(v);
            return vector.elements();
        }
        return ((Vector)v).elements();
    }

    public String getContextPath() {
        return this.mountpoint;
    }

    public boolean isUserInRole(String string) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }
}

