/*
 * Decompiled with CFR 0.152.
 */
package net.caudium.search;

import java.io.File;
import java.io.IOException;
import net.caudium.search.URLSummary;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;

public class Indexer {
    private String indexDir;
    private IndexWriter index;
    private int bytes;

    public Indexer(String string, String[] stringArray, boolean bl) throws IOException {
        this.index = new IndexWriter(new File(string), (Analyzer)new StandardAnalyzer(stringArray), !bl);
    }

    public void close() throws IOException {
        this.index.optimize();
        this.index.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(URLSummary uRLSummary) throws IOException {
        Document document = new Document();
        document.add(Field.UnIndexed((String)"url", (String)uRLSummary.url));
        document.add(Field.Text((String)"title", (String)uRLSummary.title));
        document.add(Field.UnIndexed((String)"type", (String)uRLSummary.type));
        document.add(Field.UnIndexed((String)"date", (String)uRLSummary.date));
        document.add(Field.UnIndexed((String)"desc", (String)uRLSummary.desc));
        document.add(Field.UnStored((String)"body", (String)uRLSummary.body));
        Indexer indexer = this;
        synchronized (indexer) {
            this.bytes += uRLSummary.body.length();
            this.index.addDocument(document);
        }
    }
}

