// $Id: syslog.h,v 1.1.4.1 2005/07/22 14:15:26 kiwi Exp $
// This file define syslog definitions

// It has been inspired from FreeBSD syslog.h and written by kiwi
// I don't know why this is not inside Pike... (IDA ? any clues ?)


#ifndef _SYSLOG_H
#define _SYSLOG_H

/*
 * Priority / facilitues are encoded into a single 32-bit quantity, where
 * the bottom 3 bits are the priority (0-7) and the top 28 bits are the
 * facility (0-big number).
 */

/*
 * priorities (ordered)
 */
#define	LOG_EMERG	0	/* system is unusable */
#define	LOG_ALERT	1	/* action must be taken immediately */
#define	LOG_CRIT	2	/* critical conditions */
#define	LOG_ERR		3	/* error conditions */
#define	LOG_WARNING	4	/* warning conditions */
#define	LOG_NOTICE	5	/* normal but significant condition */
#define	LOG_INFO	6	/* informational */
#define	LOG_DEBUG	7	/* debug-level messages */

/*
 * facility codes
 */
#define LOG_KERN        (0<<3)  /* kernel messages */
#define LOG_USER        (1<<3)  /* random user-level messages */
#define LOG_MAIL        (2<<3)  /* mail system */
#define LOG_DAEMON      (3<<3)  /* system daemons */
#define LOG_AUTH        (4<<3)  /* authorization messages */
#define LOG_SYSLOG      (5<<3)  /* messages generated internally by syslogd */
#define LOG_LPR         (6<<3)  /* line printer subsystem */
#define LOG_NEWS        (7<<3)  /* network news subsystem */
#define LOG_UUCP        (8<<3)  /* UUCP subsystem */
#define LOG_CRON        (9<<3)  /* clock daemon */
#define LOG_AUTHPRIV    (10<<3) /* authorization messages (private) */
                                /* Facility #10 clashes in DEC UNIX, where */
                                /* it's defined as LOG_MEGASAFE for AdvFS  */
                                /* event logging.                          */
#define LOG_FTP         (11<<3) /* ftp daemon */
#define LOG_NTP         (12<<3) /* NTP subsystem */
#define LOG_SECURITY    (13<<3) /* security subsystems (firewalling, etc.) */
#define LOG_CONSOLE     (14<<3) /* /dev/console output */

#define LOG_LOCAL       (15<<6)	/* For compat with pike */
        /* other codes through 15 reserved for system use */
#define LOG_LOCAL0      (16<<3) /* reserved for local use */
#define LOG_LOCAL1      (17<<3) /* reserved for local use */
#define LOG_LOCAL2      (18<<3) /* reserved for local use */
#define LOG_LOCAL3      (19<<3) /* reserved for local use */
#define LOG_LOCAL4      (20<<3) /* reserved for local use */
#define LOG_LOCAL5      (21<<3) /* reserved for local use */
#define LOG_LOCAL6      (22<<3) /* reserved for local use */
#define LOG_LOCAL7      (23<<3) /* reserved for local use */

/*
 * Options for openlog
 */
/*
 * LOG_ODELAY no longer does anything.
 * LOG_NDELAY is the inverse of what it used to be.
 */
#define LOG_PID         0x01    /* log the pid with each message */
#define LOG_CONS        0x02    /* log on the console if errors in sending */
#define LOG_ODELAY      0x04    /* delay open until first syslog() (default) */
#define LOG_NDELAY      0x08    /* don't delay open */
#define LOG_NOWAIT      0x10    /* don't wait for console forks: DEPRECATED */
#define LOG_PERROR      0x20    /* log to stderr as well */

#endif /* _SYSLOG_H */
