{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetCrossSectionCurve: TAbstractNurbsControlCurveNode;
    procedure SetCrossSectionCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetTrajectoryCurve: TNurbsCurveNode;
    procedure SetTrajectoryCurve(const Value: TNurbsCurveNode);
    function GetCcw: boolean;
    procedure SetCcw(const Value: boolean);
  public
    property CrossSectionCurve: TAbstractNurbsControlCurveNode read GetCrossSectionCurve write SetCrossSectionCurve;
    property TrajectoryCurve: TNurbsCurveNode read GetTrajectoryCurve write SetTrajectoryCurve;
    property Ccw: boolean read GetCcw write SetCcw;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSweptSurfaceNode ----------------------------------------------- }

function TNurbsSweptSurfaceNode.GetCrossSectionCurve: TAbstractNurbsControlCurveNode;
begin
  if FdCrossSectionCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdCrossSectionCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSweptSurfaceNode.SetCrossSectionCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdCrossSectionCurve.Send(Value);
end;

function TNurbsSweptSurfaceNode.GetTrajectoryCurve: TNurbsCurveNode;
begin
  if FdTrajectoryCurve.Value is TNurbsCurveNode then
    Result := TNurbsCurveNode(FdTrajectoryCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSweptSurfaceNode.SetTrajectoryCurve(const Value: TNurbsCurveNode);
begin
  FdTrajectoryCurve.Send(Value);
end;

function TNurbsSweptSurfaceNode.GetCcw: boolean;
begin
  Result := FdCcw.Value;
end;

procedure TNurbsSweptSurfaceNode.SetCcw(const Value: boolean);
begin
  FdCcw.Send(Value);
end;

{$endif read_implementation}
