{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetUDimension: Integer;
    procedure SetUDimension(const Value: Integer);
    function GetUOrder: Integer;
    procedure SetUOrder(const Value: Integer);
    function GetVDimension: Integer;
    procedure SetVDimension(const Value: Integer);
    function GetVOrder: Integer;
    procedure SetVOrder(const Value: Integer);
  public
    property UDimension: Integer read GetUDimension write SetUDimension;
    property UOrder: Integer read GetUOrder write SetUOrder;
    property VDimension: Integer read GetVDimension write SetVDimension;
    property VOrder: Integer read GetVOrder write SetVOrder;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSurfaceInterpolatorNode ----------------------------------------------- }

function TNurbsSurfaceInterpolatorNode.GetUDimension: Integer;
begin
  Result := FdUDimension.Value;
end;

procedure TNurbsSurfaceInterpolatorNode.SetUDimension(const Value: Integer);
begin
  FdUDimension.Send(Value);
end;

function TNurbsSurfaceInterpolatorNode.GetUOrder: Integer;
begin
  Result := FdUOrder.Value;
end;

procedure TNurbsSurfaceInterpolatorNode.SetUOrder(const Value: Integer);
begin
  FdUOrder.Send(Value);
end;

function TNurbsSurfaceInterpolatorNode.GetVDimension: Integer;
begin
  Result := FdVDimension.Value;
end;

procedure TNurbsSurfaceInterpolatorNode.SetVDimension(const Value: Integer);
begin
  FdVDimension.Send(Value);
end;

function TNurbsSurfaceInterpolatorNode.GetVOrder: Integer;
begin
  Result := FdVOrder.Value;
end;

procedure TNurbsSurfaceInterpolatorNode.SetVOrder(const Value: Integer);
begin
  FdVOrder.Send(Value);
end;

{$endif read_implementation}
