{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetAmbientIntensity: Single;
    procedure SetAmbientIntensity(const Value: Single);
    function GetAttenuation: TVector3Single;
    procedure SetAttenuation(const Value: TVector3Single);
    function GetColor: TCastleColorRGB;
    procedure SetColor(const Value: TCastleColorRGB);
    function GetIntensity: Single;
    procedure SetIntensity(const Value: Single);
    function GetSpot: boolean;
    procedure SetSpot(const Value: boolean);
    function GetSpotDropOffRate: Single;
    procedure SetSpotDropOffRate(const Value: Single);
    function GetSpotCutOffAngle: Single;
    procedure SetSpotCutOffAngle(const Value: Single);
  public
    property AmbientIntensity: Single read GetAmbientIntensity write SetAmbientIntensity;
    property Attenuation: TVector3Single read GetAttenuation write SetAttenuation;
    property Color: TCastleColorRGB read GetColor write SetColor;
    property Intensity: Single read GetIntensity write SetIntensity;
    property Spot: boolean read GetSpot write SetSpot;
    property SpotDropOffRate: Single read GetSpotDropOffRate write SetSpotDropOffRate;
    property SpotCutOffAngle: Single read GetSpotCutOffAngle write SetSpotCutOffAngle;

{$endif read_interface}

{$ifdef read_implementation}

{ TKambiHeadLightNode ----------------------------------------------- }

function TKambiHeadLightNode.GetAmbientIntensity: Single;
begin
  Result := FdAmbientIntensity.Value;
end;

procedure TKambiHeadLightNode.SetAmbientIntensity(const Value: Single);
begin
  FdAmbientIntensity.Send(Value);
end;

function TKambiHeadLightNode.GetAttenuation: TVector3Single;
begin
  Result := FdAttenuation.Value;
end;

procedure TKambiHeadLightNode.SetAttenuation(const Value: TVector3Single);
begin
  FdAttenuation.Send(Value);
end;

function TKambiHeadLightNode.GetColor: TCastleColorRGB;
begin
  Result := FdColor.Value;
end;

procedure TKambiHeadLightNode.SetColor(const Value: TCastleColorRGB);
begin
  FdColor.Send(Value);
end;

function TKambiHeadLightNode.GetIntensity: Single;
begin
  Result := FdIntensity.Value;
end;

procedure TKambiHeadLightNode.SetIntensity(const Value: Single);
begin
  FdIntensity.Send(Value);
end;

function TKambiHeadLightNode.GetSpot: boolean;
begin
  Result := FdSpot.Value;
end;

procedure TKambiHeadLightNode.SetSpot(const Value: boolean);
begin
  FdSpot.Send(Value);
end;

function TKambiHeadLightNode.GetSpotDropOffRate: Single;
begin
  Result := FdSpotDropOffRate.Value;
end;

procedure TKambiHeadLightNode.SetSpotDropOffRate(const Value: Single);
begin
  FdSpotDropOffRate.Send(Value);
end;

function TKambiHeadLightNode.GetSpotCutOffAngle: Single;
begin
  Result := FdSpotCutOffAngle.Value;
end;

procedure TKambiHeadLightNode.SetSpotCutOffAngle(const Value: Single);
begin
  FdSpotCutOffAngle.Send(Value);
end;

{$endif read_implementation}
