{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetAnchorPoint: TVector3Single;
    procedure SetAnchorPoint(const Value: TVector3Single);
    function GetAxis1: TVector3Single;
    procedure SetAxis1(const Value: TVector3Single);
    function GetAxis2: TVector3Single;
    procedure SetAxis2(const Value: TVector3Single);
    function GetDesiredAngularVelocity1: Single;
    procedure SetDesiredAngularVelocity1(const Value: Single);
    function GetDesiredAngularVelocity2: Single;
    procedure SetDesiredAngularVelocity2(const Value: Single);
    function GetMaxAngle1: Single;
    procedure SetMaxAngle1(const Value: Single);
    function GetMaxTorque1: Single;
    procedure SetMaxTorque1(const Value: Single);
    function GetMaxTorque2: Single;
    procedure SetMaxTorque2(const Value: Single);
    function GetMinAngle1: Single;
    procedure SetMinAngle1(const Value: Single);
    function GetStopBounce1: Single;
    procedure SetStopBounce1(const Value: Single);
    function GetStopConstantForceMix1: Single;
    procedure SetStopConstantForceMix1(const Value: Single);
    function GetStopErrorCorrection1: Single;
    procedure SetStopErrorCorrection1(const Value: Single);
    function GetSuspensionErrorCorrection: Single;
    procedure SetSuspensionErrorCorrection(const Value: Single);
    function GetSuspensionForce: Single;
    procedure SetSuspensionForce(const Value: Single);
  public
    property AnchorPoint: TVector3Single read GetAnchorPoint write SetAnchorPoint;
    property Axis1: TVector3Single read GetAxis1 write SetAxis1;
    property Axis2: TVector3Single read GetAxis2 write SetAxis2;
    property DesiredAngularVelocity1: Single read GetDesiredAngularVelocity1 write SetDesiredAngularVelocity1;
    property DesiredAngularVelocity2: Single read GetDesiredAngularVelocity2 write SetDesiredAngularVelocity2;
    property MaxAngle1: Single read GetMaxAngle1 write SetMaxAngle1;
    property MaxTorque1: Single read GetMaxTorque1 write SetMaxTorque1;
    property MaxTorque2: Single read GetMaxTorque2 write SetMaxTorque2;
    property MinAngle1: Single read GetMinAngle1 write SetMinAngle1;
    property StopBounce1: Single read GetStopBounce1 write SetStopBounce1;
    property StopConstantForceMix1: Single read GetStopConstantForceMix1 write SetStopConstantForceMix1;
    property StopErrorCorrection1: Single read GetStopErrorCorrection1 write SetStopErrorCorrection1;
    property SuspensionErrorCorrection: Single read GetSuspensionErrorCorrection write SetSuspensionErrorCorrection;
    property SuspensionForce: Single read GetSuspensionForce write SetSuspensionForce;

{$endif read_interface}

{$ifdef read_implementation}

{ TDoubleAxisHingeJointNode ----------------------------------------------- }

function TDoubleAxisHingeJointNode.GetAnchorPoint: TVector3Single;
begin
  Result := FdAnchorPoint.Value;
end;

procedure TDoubleAxisHingeJointNode.SetAnchorPoint(const Value: TVector3Single);
begin
  FdAnchorPoint.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetAxis1: TVector3Single;
begin
  Result := FdAxis1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetAxis1(const Value: TVector3Single);
begin
  FdAxis1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetAxis2: TVector3Single;
begin
  Result := FdAxis2.Value;
end;

procedure TDoubleAxisHingeJointNode.SetAxis2(const Value: TVector3Single);
begin
  FdAxis2.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetDesiredAngularVelocity1: Single;
begin
  Result := FdDesiredAngularVelocity1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetDesiredAngularVelocity1(const Value: Single);
begin
  FdDesiredAngularVelocity1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetDesiredAngularVelocity2: Single;
begin
  Result := FdDesiredAngularVelocity2.Value;
end;

procedure TDoubleAxisHingeJointNode.SetDesiredAngularVelocity2(const Value: Single);
begin
  FdDesiredAngularVelocity2.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetMaxAngle1: Single;
begin
  Result := FdMaxAngle1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetMaxAngle1(const Value: Single);
begin
  FdMaxAngle1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetMaxTorque1: Single;
begin
  Result := FdMaxTorque1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetMaxTorque1(const Value: Single);
begin
  FdMaxTorque1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetMaxTorque2: Single;
begin
  Result := FdMaxTorque2.Value;
end;

procedure TDoubleAxisHingeJointNode.SetMaxTorque2(const Value: Single);
begin
  FdMaxTorque2.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetMinAngle1: Single;
begin
  Result := FdMinAngle1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetMinAngle1(const Value: Single);
begin
  FdMinAngle1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetStopBounce1: Single;
begin
  Result := FdStopBounce1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetStopBounce1(const Value: Single);
begin
  FdStopBounce1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetStopConstantForceMix1: Single;
begin
  Result := FdStopConstantForceMix1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetStopConstantForceMix1(const Value: Single);
begin
  FdStopConstantForceMix1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetStopErrorCorrection1: Single;
begin
  Result := FdStopErrorCorrection1.Value;
end;

procedure TDoubleAxisHingeJointNode.SetStopErrorCorrection1(const Value: Single);
begin
  FdStopErrorCorrection1.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetSuspensionErrorCorrection: Single;
begin
  Result := FdSuspensionErrorCorrection.Value;
end;

procedure TDoubleAxisHingeJointNode.SetSuspensionErrorCorrection(const Value: Single);
begin
  FdSuspensionErrorCorrection.Send(Value);
end;

function TDoubleAxisHingeJointNode.GetSuspensionForce: Single;
begin
  Result := FdSuspensionForce.Value;
end;

procedure TDoubleAxisHingeJointNode.SetSuspensionForce(const Value: Single);
begin
  FdSuspensionForce.Send(Value);
end;

{$endif read_implementation}
