{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetAngle: Single;
    procedure SetAngle(const Value: Single);
    function GetDirection: TVector3Single;
    procedure SetDirection(const Value: TVector3Single);
    function GetPosition: TVector3Single;
    procedure SetPosition(const Value: TVector3Single);
  public
    property Angle: Single read GetAngle write SetAngle;
    property Direction: TVector3Single read GetDirection write SetDirection;
    property Position: TVector3Single read GetPosition write SetPosition;

{$endif read_interface}

{$ifdef read_implementation}

{ TConeEmitterNode ----------------------------------------------- }

function TConeEmitterNode.GetAngle: Single;
begin
  Result := FdAngle.Value;
end;

procedure TConeEmitterNode.SetAngle(const Value: Single);
begin
  FdAngle.Send(Value);
end;

function TConeEmitterNode.GetDirection: TVector3Single;
begin
  Result := FdDirection.Value;
end;

procedure TConeEmitterNode.SetDirection(const Value: TVector3Single);
begin
  FdDirection.Send(Value);
end;

function TConeEmitterNode.GetPosition: TVector3Single;
begin
  Result := FdPosition.Value;
end;

procedure TConeEmitterNode.SetPosition(const Value: TVector3Single);
begin
  FdPosition.Send(Value);
end;

{$endif read_implementation}
