{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetProxy: TAbstractChildNode;
    procedure SetProxy(const Value: TAbstractChildNode);
  public
    property Enabled: boolean read GetEnabled write SetEnabled;
    property Proxy: TAbstractChildNode read GetProxy write SetProxy;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionNode ----------------------------------------------- }

function TCollisionNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TCollisionNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TCollisionNode.GetProxy: TAbstractChildNode;
begin
  if FdProxy.Value is TAbstractChildNode then
    Result := TAbstractChildNode(FdProxy.Value)
  else
    Result := nil;
end;

procedure TCollisionNode.SetProxy(const Value: TAbstractChildNode);
begin
  FdProxy.Send(Value);
end;

{$endif read_implementation}
