{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetCenterOfMass: TVector3Single;
    procedure SetCenterOfMass(const Value: TVector3Single);
    function GetMass: Single;
    procedure SetMass(const Value: Single);
    function GetNameField: string;
    procedure SetNameField(const Value: string);
  public
    property CenterOfMass: TVector3Single read GetCenterOfMass write SetCenterOfMass;
    property Mass: Single read GetMass write SetMass;
    property NameField: string read GetNameField write SetNameField;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimSegmentNode ----------------------------------------------- }

function THAnimSegmentNode.GetCenterOfMass: TVector3Single;
begin
  Result := FdCenterOfMass.Value;
end;

procedure THAnimSegmentNode.SetCenterOfMass(const Value: TVector3Single);
begin
  FdCenterOfMass.Send(Value);
end;

function THAnimSegmentNode.GetMass: Single;
begin
  Result := FdMass.Value;
end;

procedure THAnimSegmentNode.SetMass(const Value: Single);
begin
  FdMass.Send(Value);
end;

function THAnimSegmentNode.GetNameField: string;
begin
  Result := FdName.Value;
end;

procedure THAnimSegmentNode.SetNameField(const Value: string);
begin
  FdName.Send(Value);
end;

{$endif read_implementation}
