{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetBounce: Single;
    procedure SetBounce(const Value: Single);
    function GetContactNormal: TVector3Single;
    procedure SetContactNormal(const Value: TVector3Single);
    function GetDepth: Single;
    procedure SetDepth(const Value: Single);
    function GetFrictionCoefficients: TVector2Single;
    procedure SetFrictionCoefficients(const Value: TVector2Single);
    function GetFrictionDirection: TVector3Single;
    procedure SetFrictionDirection(const Value: TVector3Single);
    function GetMinbounceSpeed: Single;
    procedure SetMinbounceSpeed(const Value: Single);
    function GetPosition: TVector3Single;
    procedure SetPosition(const Value: TVector3Single);
    function GetSlipCoefficients: TVector2Single;
    procedure SetSlipCoefficients(const Value: TVector2Single);
    function GetSoftnessConstantForceMix: Single;
    procedure SetSoftnessConstantForceMix(const Value: Single);
    function GetSoftnessErrorCorrection: Single;
    procedure SetSoftnessErrorCorrection(const Value: Single);
    function GetSurfaceSpeed: TVector2Single;
    procedure SetSurfaceSpeed(const Value: TVector2Single);
  public
    property Bounce: Single read GetBounce write SetBounce;
    property ContactNormal: TVector3Single read GetContactNormal write SetContactNormal;
    property Depth: Single read GetDepth write SetDepth;
    property FrictionCoefficients: TVector2Single read GetFrictionCoefficients write SetFrictionCoefficients;
    property FrictionDirection: TVector3Single read GetFrictionDirection write SetFrictionDirection;
    property MinbounceSpeed: Single read GetMinbounceSpeed write SetMinbounceSpeed;
    property Position: TVector3Single read GetPosition write SetPosition;
    property SlipCoefficients: TVector2Single read GetSlipCoefficients write SetSlipCoefficients;
    property SoftnessConstantForceMix: Single read GetSoftnessConstantForceMix write SetSoftnessConstantForceMix;
    property SoftnessErrorCorrection: Single read GetSoftnessErrorCorrection write SetSoftnessErrorCorrection;
    property SurfaceSpeed: TVector2Single read GetSurfaceSpeed write SetSurfaceSpeed;

{$endif read_interface}

{$ifdef read_implementation}

{ TContactNode ----------------------------------------------- }

function TContactNode.GetBounce: Single;
begin
  Result := FdBounce.Value;
end;

procedure TContactNode.SetBounce(const Value: Single);
begin
  FdBounce.Send(Value);
end;

function TContactNode.GetContactNormal: TVector3Single;
begin
  Result := FdContactNormal.Value;
end;

procedure TContactNode.SetContactNormal(const Value: TVector3Single);
begin
  FdContactNormal.Send(Value);
end;

function TContactNode.GetDepth: Single;
begin
  Result := FdDepth.Value;
end;

procedure TContactNode.SetDepth(const Value: Single);
begin
  FdDepth.Send(Value);
end;

function TContactNode.GetFrictionCoefficients: TVector2Single;
begin
  Result := FdFrictionCoefficients.Value;
end;

procedure TContactNode.SetFrictionCoefficients(const Value: TVector2Single);
begin
  FdFrictionCoefficients.Send(Value);
end;

function TContactNode.GetFrictionDirection: TVector3Single;
begin
  Result := FdFrictionDirection.Value;
end;

procedure TContactNode.SetFrictionDirection(const Value: TVector3Single);
begin
  FdFrictionDirection.Send(Value);
end;

function TContactNode.GetMinbounceSpeed: Single;
begin
  Result := FdMinbounceSpeed.Value;
end;

procedure TContactNode.SetMinbounceSpeed(const Value: Single);
begin
  FdMinbounceSpeed.Send(Value);
end;

function TContactNode.GetPosition: TVector3Single;
begin
  Result := FdPosition.Value;
end;

procedure TContactNode.SetPosition(const Value: TVector3Single);
begin
  FdPosition.Send(Value);
end;

function TContactNode.GetSlipCoefficients: TVector2Single;
begin
  Result := FdSlipCoefficients.Value;
end;

procedure TContactNode.SetSlipCoefficients(const Value: TVector2Single);
begin
  FdSlipCoefficients.Send(Value);
end;

function TContactNode.GetSoftnessConstantForceMix: Single;
begin
  Result := FdSoftnessConstantForceMix.Value;
end;

procedure TContactNode.SetSoftnessConstantForceMix(const Value: Single);
begin
  FdSoftnessConstantForceMix.Send(Value);
end;

function TContactNode.GetSoftnessErrorCorrection: Single;
begin
  Result := FdSoftnessErrorCorrection.Value;
end;

procedure TContactNode.SetSoftnessErrorCorrection(const Value: Single);
begin
  FdSoftnessErrorCorrection.Send(Value);
end;

function TContactNode.GetSurfaceSpeed: TVector2Single;
begin
  Result := FdSurfaceSpeed.Value;
end;

procedure TContactNode.SetSurfaceSpeed(const Value: TVector2Single);
begin
  FdSurfaceSpeed.Send(Value);
end;

{$endif read_implementation}
