{ -*- buffer-read-only: t -*-

  Copyright 2015-2017 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties, add them to text files in nodes_specification/components/ ,
  and regenerate include files by running
  nodes_specification/generate_x3d_nodes_to_pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  private
    function GetBounce: Single;
    procedure SetBounce(const Value: Single);
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetFrictionCoefficients: TVector2Single;
    procedure SetFrictionCoefficients(const Value: TVector2Single);
    function GetMinBounceSpeed: Single;
    procedure SetMinBounceSpeed(const Value: Single);
    function GetSlipFactors: TVector2Single;
    procedure SetSlipFactors(const Value: TVector2Single);
    function GetSoftnessConstantForceMix: Single;
    procedure SetSoftnessConstantForceMix(const Value: Single);
    function GetSoftnessErrorCorrection: Single;
    procedure SetSoftnessErrorCorrection(const Value: Single);
    function GetSurfaceSpeed: TVector2Single;
    procedure SetSurfaceSpeed(const Value: TVector2Single);
  public
    property Bounce: Single read GetBounce write SetBounce;
    property Enabled: boolean read GetEnabled write SetEnabled;
    property FrictionCoefficients: TVector2Single read GetFrictionCoefficients write SetFrictionCoefficients;
    property MinBounceSpeed: Single read GetMinBounceSpeed write SetMinBounceSpeed;
    property SlipFactors: TVector2Single read GetSlipFactors write SetSlipFactors;
    property SoftnessConstantForceMix: Single read GetSoftnessConstantForceMix write SetSoftnessConstantForceMix;
    property SoftnessErrorCorrection: Single read GetSoftnessErrorCorrection write SetSoftnessErrorCorrection;
    property SurfaceSpeed: TVector2Single read GetSurfaceSpeed write SetSurfaceSpeed;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollisionCollectionNode ----------------------------------------------- }

function TCollisionCollectionNode.GetBounce: Single;
begin
  Result := FdBounce.Value;
end;

procedure TCollisionCollectionNode.SetBounce(const Value: Single);
begin
  FdBounce.Send(Value);
end;

function TCollisionCollectionNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TCollisionCollectionNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TCollisionCollectionNode.GetFrictionCoefficients: TVector2Single;
begin
  Result := FdFrictionCoefficients.Value;
end;

procedure TCollisionCollectionNode.SetFrictionCoefficients(const Value: TVector2Single);
begin
  FdFrictionCoefficients.Send(Value);
end;

function TCollisionCollectionNode.GetMinBounceSpeed: Single;
begin
  Result := FdMinBounceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetMinBounceSpeed(const Value: Single);
begin
  FdMinBounceSpeed.Send(Value);
end;

function TCollisionCollectionNode.GetSlipFactors: TVector2Single;
begin
  Result := FdSlipFactors.Value;
end;

procedure TCollisionCollectionNode.SetSlipFactors(const Value: TVector2Single);
begin
  FdSlipFactors.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessConstantForceMix: Single;
begin
  Result := FdSoftnessConstantForceMix.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessConstantForceMix(const Value: Single);
begin
  FdSoftnessConstantForceMix.Send(Value);
end;

function TCollisionCollectionNode.GetSoftnessErrorCorrection: Single;
begin
  Result := FdSoftnessErrorCorrection.Value;
end;

procedure TCollisionCollectionNode.SetSoftnessErrorCorrection(const Value: Single);
begin
  FdSoftnessErrorCorrection.Send(Value);
end;

function TCollisionCollectionNode.GetSurfaceSpeed: TVector2Single;
begin
  Result := FdSurfaceSpeed.Value;
end;

procedure TCollisionCollectionNode.SetSurfaceSpeed(const Value: TVector2Single);
begin
  FdSurfaceSpeed.Send(Value);
end;

{$endif read_implementation}
