import pygame
from pygame.locals import *
from Numeric import *
from twisted.spread import pb

import common
import random
from game import get_game

class BasePlayer(pb.Referenceable):

	def call(self, command, *args):
		if get_game().server:
			self.player.remote_call(command, *args)
		else:
			self.player.avatar.callRemote("call", command, *args)

	def handle_build_or_place_event(self, event, buttons, pos):
		if (event.type == KEYDOWN):
			keys = self.player.config.keys
			if event.key == keys.up:
				self.call("move", (0,-1))
			elif event.key == keys.down:
				self.call("move", (0,1))
			elif event.key == keys.left:
				self.call("move", (-1,0))
			elif event.key == keys.right:
				self.call("move", (1,0))
			elif event.key == keys.button[0]:
				buttons[0]()
			elif event.key == keys.button[1]:
				buttons[1]()
			else:
				catched = False
									
			
class Player(pb.Referenceable):

	colors = (Color('red'), Color('green'), Color('blue'), Color('yellow'), Color('brown'), Color('cyan'), Color('black'), Color('white'))
	names = ("Red Player", "Green Player", "Blue Player", "Yellow Player", "Brown Player", "Cyan Player", "Black Player", "White Player")

	wall_pic = common.load_image('wall.png')
	ground_pic = common.load_image('ground.png', alpha=True)

	def __init__(self, player_id):
		self.player_id = player_id
		self.connected = False # for server only
		self.alive = True
		self.secured = zeros(common.field_size)		
		self.local = False
		self.ai = False
		self.center = common.field_size / 2
		
		self.name = self.names[player_id]
		self.color = self.colors[player_id]
		self.wall_pic = common.colorize(self.wall_pic, self.color)
		self.ground_pic = common.colorize(self.ground_pic, self.color)

		import buildplayer
		import placeplayer
		import battleplayer
		import selectplayer
		self.build_player = buildplayer.BuildPlayer(self)
		self.place_player = placeplayer.PlacePlayer(self)
		self.battle_player = battleplayer.BattlePlayer(self)
		self.select_player = selectplayer.SelectPlayer(self)
		
	def set_config(self, config):
		self.config = config
		
	
	def __repr__(self):
		return self.name

	def __getattr__(self, attr):
		'''Delegates calls to the player of the current phase'''
		assert attr[:6] == 'remote' or attr in ('draw_cursor', 'handle_event', 'handle_movement'), 'Player instance has no attribute %s and does not delegate it.' % str(attr)
		return eval("self.phase_player." + attr)
		
	def init_phase(self, phase):
		self.phase_player = eval('self.' + phase + '_player')
		self.phase_player.init()

	def get_center(self):
		return self.get_center_and_field_count()[0]
	
	def get_center_and_field_count(self):
		xsum = ysum = counter = 0
		for x in range(common.field_size[0]):
			for y in range(common.field_size[1]):
				if self.secured[x][y]:
					xsum += x
					ysum += y
					counter += 1

		if counter > 0:
			self.center = [xsum / counter, ysum / counter]

		return self.center[:], counter
			
	def die(self):
		self.alive = False
		self.handle_event = self.handle_movement = self.draw_cursor = lambda *args:None

	def remote_call(self, command, *args):
		"""Execute a player action on all Clients
		
		This function gets called on the server whenever a player wishes to execute an action.
		The server tries to execute the action, and sends it to all clients if successful.
		"""
		assert get_game().server, "remote_call may only be called on the server!"
		from server import ClientAvatar
		try:
			eval('self.phase_player.remote_' + command)(*args)
			for client in get_game().server.clients:
				client.remote_players[self.player_id].callRemote(command, *args)
			for ai in get_game().server.ai_players:
				from twisted.internet import reactor
				reactor.callLater(0, lambda: ai.act_on_player_event(command, self))
			print command, 'succeeded for player', self.player_id
		except common.ActionNotPossible:
			if self.ai:
				from twisted.internet import reactor
				reactor.callLater(0, lambda: self.ai.failed_event(command))
			print command, 'failed for player', self.player_id		
		
