/* 

Copyright 2006 Rene Grothmann, modified by Eric Hakenholz

This file is part of C.a.R. software.

C.a.R. is a free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

C.a.R. is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
package rene.zirkel;

// File: Zirkel.java
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Properties;

import javax.swing.JFrame;

import javax.swing.SwingUtilities;
import rene.gui.Global;

public class Zirkel extends Applet implements ActionListener {

    /**
     *
     */
    private static final long serialVersionUID=1L;
    public static final long Version=110;
    public static boolean IsApplet=false;
    static public Rectangle SCREEN=new Rectangle();
    static public int REALHEIGHT=0,REALTOP=0;

    public static void DetectDesktopSize() {

        if (System.getProperty("os.name").equals("Linux")) {
//             Very dirty trick to escape a very dirty bug on linux java :
            final JFrame myframe=new JFrame();
            myframe.setUndecorated(true);
            myframe.pack();
            final int s=JFrame.ICONIFIED;
            myframe.setExtendedState(s);
            myframe.setVisible(true);
            myframe.setExtendedState(JFrame.MAXIMIZED_BOTH);
            while (myframe.getExtendedState()==s) {
            }
            try {
                SwingUtilities.invokeAndWait(new Runnable() {
                    public void run() {
                        SCREEN.x=myframe.getBounds().x;
                        SCREEN.y=myframe.getBounds().y;
                        SCREEN.width=myframe.getBounds().width;
                        SCREEN.height=myframe.getBounds().height;
                        if (SCREEN.x<0) {
                            SCREEN.x=0;
                        }
                        myframe.dispose();
                    }
                });
            } catch (Exception ex) {

            }
        } else {
            // this is much better on mac and windows :
            GraphicsEnvironment GE=GraphicsEnvironment.getLocalGraphicsEnvironment();
            SCREEN=GE.getMaximumWindowBounds();
        }
        REALHEIGHT=SCREEN.height;
        REALTOP=SCREEN.y;
    }

    public static String name(final String tag, final String def) {
        return Global.name(tag, def);
    }

    public static String name(final String tag) {
        return Global.name(tag);
    }

    @Override
    public void init() // zirkel is called as applet
    {
        final String s=getParameter("Language");
        if (s!=null) {
            Locale.setDefault(new Locale(s, ""));
        }
        Global.initBundle("rene/zirkel/docs/ZirkelProperties");
        setLayout(new BorderLayout());
        final Button StartButton=new Button("Start");
        add("Center", StartButton);
        StartButton.addActionListener(this);
        IsApplet=true;
        if (getParameter("oldicons")!=null) {
            Global.setParameter("iconpath", "/rene/zirkel/icons/");
            Global.setParameter("icontype", "gif");
            Global.setParameter("iconsize", 20);
        } else {
            Global.setParameter("iconpath", "/rene/zirkel/newicons/");
            Global.setParameter("icontype", "png");
            if (getParameter("smallicons")!=null) {
                Global.setParameter("iconsize", 24);
            } else {
                Global.setParameter("iconsize", 32);
            }
        }

    }

    public static void main(final String args[]) // zirkel is calles as
    // application
    {
        DetectDesktopSize();

        int i=0;
        String filename="";
        while (i<args.length) {
            if (args[i].startsWith("-l")&&i<args.length-1) {
                Locale.setDefault(new Locale(args[i+1], ""));
                i+=2;
            } else if (args[i].startsWith("-h")&&i<args.length-1) {
                i+=2;
            } else if (args[i].startsWith("-s")) {
                i++;
            } else if (args[i].startsWith("-r")) {
                i++;
            } else if (args[i].startsWith("-d")) {
                final Properties p=System.getProperties();
                try {
                    final PrintStream out=new PrintStream(
                            new FileOutputStream(p.getProperty("user.home")+p.getProperty("file.separator")+"zirkel.log"));
                    System.setErr(out);
                    System.setOut(out);
                } catch (final Exception e) {
                    System.out.println("Could not open log file!");
                }
                i++;
            } else {
                filename=args[i];
                eric.JMacrosTools.StartupFiles.add(filename);
                i++;
            }
        }


        Global.loadProperties(eric.JMacrosTools.getHomeDirectory()+"carmetal_config.txt");
        Global.initBundle("rene/zirkel/docs/ZirkelProperties", true);

        eric.JGlobals.ShowLogoWindow();

        eric.JMacrosTools.initProperties();

        eric.JMacrosTools.createLocalDirectory();
        eric.JGlobalPreferences.initPreferences();

        eric.JMacrosTools.FirstRun();
        eric.JGlobals.CreatePopertiesBar();
        eric.JGlobals.DisposeLogoWindow();
    }

    public void actionPerformed(final ActionEvent e) // the user pressed the
    // start button of the
    // applet
    {
        final ZirkelFrame F=new ZirkelFrame(true);
        F.setVisible(true);
    }
}
