/*

Copyright 2006 Eric Hakenholz

This file is part of C.a.R. software.

C.a.R. is a free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, version 3 of the License.

C.a.R. is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */
package eric.applet.dock;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import rene.zirkel.ZirkelCanvas;

/**
 *
 * @author erichake
 */
public class dock extends JPanel {

    ZirkelCanvas ZC;
    Vector geomGroup=new Vector();
    static int WEST=0,  SOUTH=1,  EAST=2;
    static int IM_HIDDEN_PART=10,D_MARGIN=5;
    int d_orientation=-1, d_top=50, d_left=100, d_width=200, d_height=32;
    int icon_width=32;
    int im_width=0, im_height=0;
    int zc_width=0,zc_height=0;

    public dock(ZirkelCanvas zc) {
        ZC=zc;
        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        add(margin(5));
        add(new dockIcon(this, icon_width, "move", geomGroup));
        add(margin(2));
        add(new dockIcon(this, icon_width, "point", geomGroup));
        add(margin(2));
        add(new dockIcon(this, icon_width, "line", geomGroup));
        add(margin(2));
        add(new dockIcon(this, icon_width, "segment", geomGroup));
        add(margin(5));
        setBounds(d_left, d_top, d_width, d_height);
    }

    public BufferedImage getBufferedImage(int newor) {
        if ((newor!=d_orientation)||(zc_width!=ZC.getSize().width)||(zc_height!=ZC.getSize().height)) {
            zc_width=ZC.getSize().width;
            zc_height=ZC.getSize().height;
            if (newor==SOUTH) {
                setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
                this.revalidate();
                d_width=getPreferredSize().width;
                d_height=icon_width;
                d_left=ZC.getSize().width/2-d_width/2;
                d_top=ZC.getSize().height-icon_width;
                setBounds(d_left, d_top, d_width, d_height);
                im_width=d_width;
                im_height=d_height+IM_HIDDEN_PART+D_MARGIN;
            } else if (newor==WEST) {
                setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
                this.revalidate();
                d_width=icon_width;
                d_height=getPreferredSize().height;
                d_left=0;
                d_top=ZC.getSize().height/2-d_height/2;
                setBounds(d_left, d_top, d_width, d_height);
                im_width=d_width+IM_HIDDEN_PART+D_MARGIN;
                im_height=d_height;
            } else if (newor==EAST) {
                setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
                this.revalidate();
                d_width=icon_width;
                d_height=getPreferredSize().height;
                d_left=ZC.getSize().width-icon_width;
                d_top=ZC.getSize().height/2-d_height/2;
                setBounds(d_left, d_top, d_width, d_height);
                im_width=d_width+IM_HIDDEN_PART+D_MARGIN;
                im_height=d_height;
            }
            d_orientation=newor;
        }
        return new BufferedImage(im_width, im_height, BufferedImage.TYPE_INT_ARGB);
    }

    @Override
    public void paint(Graphics g) {
    }

    static void fixsize(final JComponent cp, final int w, final int h) {
        final Dimension d=new Dimension(w, h);
        cp.setMaximumSize(d);
        cp.setMinimumSize(d);
        cp.setPreferredSize(d);
        cp.setSize(d);
    }

    static JPanel margin(final int w) {
        final JPanel mypan=new JPanel();
        fixsize(mypan, w, w);
        mypan.setLayout(new javax.swing.BoxLayout(mypan,
                javax.swing.BoxLayout.X_AXIS));
        mypan.setAlignmentX(0.5F);
        mypan.setAlignmentY(0.5F);
        mypan.setOpaque(false);
        mypan.setFocusable(false);
        return mypan;
    }

    
    public void paintDock(Graphics g) {
        BufferedImage bar_image=getBufferedImage(WEST);
        if (bar_image!=null) {
            Graphics2D g2D=bar_image.createGraphics();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                    RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,
                    RenderingHints.VALUE_STROKE_PURE);
            int dw=0, dh=0;
            if (d_orientation==SOUTH) {
                dh=IM_HIDDEN_PART+D_MARGIN;
            } else {
                dw=IM_HIDDEN_PART+D_MARGIN;
            }
            RoundRectangle2D r=new RoundRectangle2D.Double(1, 1, d_width-2+dw, d_height-2+dh, 14, 14);
            BasicStroke b=new BasicStroke(3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND);
            g2D.setStroke(b);
            g2D.setColor(new Color(255, 255, 255, 200));
            g2D.draw(r);
            r.setRoundRect(2, 2, d_width*1f-4+dw, d_height*1f-4+dh, 12.0f, 12.0f);
            g2D.setColor(new Color(0, 0, 0, 50));
            g2D.fill(r);
            int left=d_left;int top=d_top;
            if (d_orientation==SOUTH) {
                top-=D_MARGIN;
            } else if (d_orientation==WEST) {
                left-=IM_HIDDEN_PART;
            } else if (d_orientation==EAST) {
                left-=D_MARGIN;
            }
            g.drawImage(bar_image, left, top, this);
        }
        BufferedImage children_image=new BufferedImage(im_width, im_height, BufferedImage.TYPE_INT_ARGB);
        if (bar_image!=null) {
            Graphics2D g2D=children_image.createGraphics();
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                    RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL,
                    RenderingHints.VALUE_STROKE_PURE);
            paintChildren(g2D);
            g.drawImage(children_image, d_left, d_top, this);
        }
    }
}
