// Copyright 2013-2014 Valentin Gosu.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// Generated by make_idna_table.py

use idna::Mapping::*;
use idna::Range;

pub static TABLE: &'static [Range] = &[

    Range { from: '\0', to: ',', mapping: DisallowedStd3Valid },
    Range { from: '-', to: '.', mapping: Valid },
    Range { from: '/', to: '/', mapping: DisallowedStd3Valid },
    Range { from: '0', to: '9', mapping: Valid },
    Range { from: ':', to: '@', mapping: DisallowedStd3Valid },
    Range { from: 'A', to: 'A', mapping: Mapped("a") },
    Range { from: 'B', to: 'B', mapping: Mapped("b") },
    Range { from: 'C', to: 'C', mapping: Mapped("c") },
    Range { from: 'D', to: 'D', mapping: Mapped("d") },
    Range { from: 'E', to: 'E', mapping: Mapped("e") },
    Range { from: 'F', to: 'F', mapping: Mapped("f") },
    Range { from: 'G', to: 'G', mapping: Mapped("g") },
    Range { from: 'H', to: 'H', mapping: Mapped("h") },
    Range { from: 'I', to: 'I', mapping: Mapped("i") },
    Range { from: 'J', to: 'J', mapping: Mapped("j") },
    Range { from: 'K', to: 'K', mapping: Mapped("k") },
    Range { from: 'L', to: 'L', mapping: Mapped("l") },
    Range { from: 'M', to: 'M', mapping: Mapped("m") },
    Range { from: 'N', to: 'N', mapping: Mapped("n") },
    Range { from: 'O', to: 'O', mapping: Mapped("o") },
    Range { from: 'P', to: 'P', mapping: Mapped("p") },
    Range { from: 'Q', to: 'Q', mapping: Mapped("q") },
    Range { from: 'R', to: 'R', mapping: Mapped("r") },
    Range { from: 'S', to: 'S', mapping: Mapped("s") },
    Range { from: 'T', to: 'T', mapping: Mapped("t") },
    Range { from: 'U', to: 'U', mapping: Mapped("u") },
    Range { from: 'V', to: 'V', mapping: Mapped("v") },
    Range { from: 'W', to: 'W', mapping: Mapped("w") },
    Range { from: 'X', to: 'X', mapping: Mapped("x") },
    Range { from: 'Y', to: 'Y', mapping: Mapped("y") },
    Range { from: 'Z', to: 'Z', mapping: Mapped("z") },
    Range { from: '[', to: '`', mapping: DisallowedStd3Valid },
    Range { from: 'a', to: 'z', mapping: Valid },
    Range { from: '{', to: '', mapping: DisallowedStd3Valid },
    Range { from: '', to: '', mapping: Disallowed },
    Range { from: ' ', to: ' ', mapping: DisallowedStd3Mapped(" ") },
    Range { from: '¡', to: '§', mapping: Valid },
    Range { from: '¨', to: '¨', mapping: DisallowedStd3Mapped(" ̈") },
    Range { from: '©', to: '©', mapping: Valid },
    Range { from: 'ª', to: 'ª', mapping: Mapped("a") },
    Range { from: '«', to: '¬', mapping: Valid },
    Range { from: '­', to: '­', mapping: Ignored },
    Range { from: '®', to: '®', mapping: Valid },
    Range { from: '¯', to: '¯', mapping: DisallowedStd3Mapped(" ̄") },
    Range { from: '°', to: '±', mapping: Valid },
    Range { from: '²', to: '²', mapping: Mapped("2") },
    Range { from: '³', to: '³', mapping: Mapped("3") },
    Range { from: '´', to: '´', mapping: DisallowedStd3Mapped(" ́") },
    Range { from: 'µ', to: 'µ', mapping: Mapped("μ") },
    Range { from: '¶', to: '¶', mapping: Valid },
    Range { from: '·', to: '·', mapping: Valid },
    Range { from: '¸', to: '¸', mapping: DisallowedStd3Mapped(" ̧") },
    Range { from: '¹', to: '¹', mapping: Mapped("1") },
    Range { from: 'º', to: 'º', mapping: Mapped("o") },
    Range { from: '»', to: '»', mapping: Valid },
    Range { from: '¼', to: '¼', mapping: Mapped("1⁄4") },
    Range { from: '½', to: '½', mapping: Mapped("1⁄2") },
    Range { from: '¾', to: '¾', mapping: Mapped("3⁄4") },
    Range { from: '¿', to: '¿', mapping: Valid },
    Range { from: 'À', to: 'À', mapping: Mapped("à") },
    Range { from: 'Á', to: 'Á', mapping: Mapped("á") },
    Range { from: 'Â', to: 'Â', mapping: Mapped("â") },
    Range { from: 'Ã', to: 'Ã', mapping: Mapped("ã") },
    Range { from: 'Ä', to: 'Ä', mapping: Mapped("ä") },
    Range { from: 'Å', to: 'Å', mapping: Mapped("å") },
    Range { from: 'Æ', to: 'Æ', mapping: Mapped("æ") },
    Range { from: 'Ç', to: 'Ç', mapping: Mapped("ç") },
    Range { from: 'È', to: 'È', mapping: Mapped("è") },
    Range { from: 'É', to: 'É', mapping: Mapped("é") },
    Range { from: 'Ê', to: 'Ê', mapping: Mapped("ê") },
    Range { from: 'Ë', to: 'Ë', mapping: Mapped("ë") },
    Range { from: 'Ì', to: 'Ì', mapping: Mapped("ì") },
    Range { from: 'Í', to: 'Í', mapping: Mapped("í") },
    Range { from: 'Î', to: 'Î', mapping: Mapped("î") },
    Range { from: 'Ï', to: 'Ï', mapping: Mapped("ï") },
    Range { from: 'Ð', to: 'Ð', mapping: Mapped("ð") },
    Range { from: 'Ñ', to: 'Ñ', mapping: Mapped("ñ") },
    Range { from: 'Ò', to: 'Ò', mapping: Mapped("ò") },
    Range { from: 'Ó', to: 'Ó', mapping: Mapped("ó") },
    Range { from: 'Ô', to: 'Ô', mapping: Mapped("ô") },
    Range { from: 'Õ', to: 'Õ', mapping: Mapped("õ") },
    Range { from: 'Ö', to: 'Ö', mapping: Mapped("ö") },
    Range { from: '×', to: '×', mapping: Valid },
    Range { from: 'Ø', to: 'Ø', mapping: Mapped("ø") },
    Range { from: 'Ù', to: 'Ù', mapping: Mapped("ù") },
    Range { from: 'Ú', to: 'Ú', mapping: Mapped("ú") },
    Range { from: 'Û', to: 'Û', mapping: Mapped("û") },
    Range { from: 'Ü', to: 'Ü', mapping: Mapped("ü") },
    Range { from: 'Ý', to: 'Ý', mapping: Mapped("ý") },
    Range { from: 'Þ', to: 'Þ', mapping: Mapped("þ") },
    Range { from: 'ß', to: 'ß', mapping: Deviation("ss") },
    Range { from: 'à', to: 'ö', mapping: Valid },
    Range { from: '÷', to: '÷', mapping: Valid },
    Range { from: 'ø', to: 'ÿ', mapping: Valid },
    Range { from: 'Ā', to: 'Ā', mapping: Mapped("ā") },
    Range { from: 'ā', to: 'ā', mapping: Valid },
    Range { from: 'Ă', to: 'Ă', mapping: Mapped("ă") },
    Range { from: 'ă', to: 'ă', mapping: Valid },
    Range { from: 'Ą', to: 'Ą', mapping: Mapped("ą") },
    Range { from: 'ą', to: 'ą', mapping: Valid },
    Range { from: 'Ć', to: 'Ć', mapping: Mapped("ć") },
    Range { from: 'ć', to: 'ć', mapping: Valid },
    Range { from: 'Ĉ', to: 'Ĉ', mapping: Mapped("ĉ") },
    Range { from: 'ĉ', to: 'ĉ', mapping: Valid },
    Range { from: 'Ċ', to: 'Ċ', mapping: Mapped("ċ") },
    Range { from: 'ċ', to: 'ċ', mapping: Valid },
    Range { from: 'Č', to: 'Č', mapping: Mapped("č") },
    Range { from: 'č', to: 'č', mapping: Valid },
    Range { from: 'Ď', to: 'Ď', mapping: Mapped("ď") },
    Range { from: 'ď', to: 'ď', mapping: Valid },
    Range { from: 'Đ', to: 'Đ', mapping: Mapped("đ") },
    Range { from: 'đ', to: 'đ', mapping: Valid },
    Range { from: 'Ē', to: 'Ē', mapping: Mapped("ē") },
    Range { from: 'ē', to: 'ē', mapping: Valid },
    Range { from: 'Ĕ', to: 'Ĕ', mapping: Mapped("ĕ") },
    Range { from: 'ĕ', to: 'ĕ', mapping: Valid },
    Range { from: 'Ė', to: 'Ė', mapping: Mapped("ė") },
    Range { from: 'ė', to: 'ė', mapping: Valid },
    Range { from: 'Ę', to: 'Ę', mapping: Mapped("ę") },
    Range { from: 'ę', to: 'ę', mapping: Valid },
    Range { from: 'Ě', to: 'Ě', mapping: Mapped("ě") },
    Range { from: 'ě', to: 'ě', mapping: Valid },
    Range { from: 'Ĝ', to: 'Ĝ', mapping: Mapped("ĝ") },
    Range { from: 'ĝ', to: 'ĝ', mapping: Valid },
    Range { from: 'Ğ', to: 'Ğ', mapping: Mapped("ğ") },
    Range { from: 'ğ', to: 'ğ', mapping: Valid },
    Range { from: 'Ġ', to: 'Ġ', mapping: Mapped("ġ") },
    Range { from: 'ġ', to: 'ġ', mapping: Valid },
    Range { from: 'Ģ', to: 'Ģ', mapping: Mapped("ģ") },
    Range { from: 'ģ', to: 'ģ', mapping: Valid },
    Range { from: 'Ĥ', to: 'Ĥ', mapping: Mapped("ĥ") },
    Range { from: 'ĥ', to: 'ĥ', mapping: Valid },
    Range { from: 'Ħ', to: 'Ħ', mapping: Mapped("ħ") },
    Range { from: 'ħ', to: 'ħ', mapping: Valid },
    Range { from: 'Ĩ', to: 'Ĩ', mapping: Mapped("ĩ") },
    Range { from: 'ĩ', to: 'ĩ', mapping: Valid },
    Range { from: 'Ī', to: 'Ī', mapping: Mapped("ī") },
    Range { from: 'ī', to: 'ī', mapping: Valid },
    Range { from: 'Ĭ', to: 'Ĭ', mapping: Mapped("ĭ") },
    Range { from: 'ĭ', to: 'ĭ', mapping: Valid },
    Range { from: 'Į', to: 'Į', mapping: Mapped("į") },
    Range { from: 'į', to: 'į', mapping: Valid },
    Range { from: 'İ', to: 'İ', mapping: Mapped("i̇") },
    Range { from: 'ı', to: 'ı', mapping: Valid },
    Range { from: 'Ĳ', to: 'ĳ', mapping: Mapped("ij") },
    Range { from: 'Ĵ', to: 'Ĵ', mapping: Mapped("ĵ") },
    Range { from: 'ĵ', to: 'ĵ', mapping: Valid },
    Range { from: 'Ķ', to: 'Ķ', mapping: Mapped("ķ") },
    Range { from: 'ķ', to: 'ĸ', mapping: Valid },
    Range { from: 'Ĺ', to: 'Ĺ', mapping: Mapped("ĺ") },
    Range { from: 'ĺ', to: 'ĺ', mapping: Valid },
    Range { from: 'Ļ', to: 'Ļ', mapping: Mapped("ļ") },
    Range { from: 'ļ', to: 'ļ', mapping: Valid },
    Range { from: 'Ľ', to: 'Ľ', mapping: Mapped("ľ") },
    Range { from: 'ľ', to: 'ľ', mapping: Valid },
    Range { from: 'Ŀ', to: 'ŀ', mapping: Mapped("l·") },
    Range { from: 'Ł', to: 'Ł', mapping: Mapped("ł") },
    Range { from: 'ł', to: 'ł', mapping: Valid },
    Range { from: 'Ń', to: 'Ń', mapping: Mapped("ń") },
    Range { from: 'ń', to: 'ń', mapping: Valid },
    Range { from: 'Ņ', to: 'Ņ', mapping: Mapped("ņ") },
    Range { from: 'ņ', to: 'ņ', mapping: Valid },
    Range { from: 'Ň', to: 'Ň', mapping: Mapped("ň") },
    Range { from: 'ň', to: 'ň', mapping: Valid },
    Range { from: 'ŉ', to: 'ŉ', mapping: Mapped("ʼn") },
    Range { from: 'Ŋ', to: 'Ŋ', mapping: Mapped("ŋ") },
    Range { from: 'ŋ', to: 'ŋ', mapping: Valid },
    Range { from: 'Ō', to: 'Ō', mapping: Mapped("ō") },
    Range { from: 'ō', to: 'ō', mapping: Valid },
    Range { from: 'Ŏ', to: 'Ŏ', mapping: Mapped("ŏ") },
    Range { from: 'ŏ', to: 'ŏ', mapping: Valid },
    Range { from: 'Ő', to: 'Ő', mapping: Mapped("ő") },
    Range { from: 'ő', to: 'ő', mapping: Valid },
    Range { from: 'Œ', to: 'Œ', mapping: Mapped("œ") },
    Range { from: 'œ', to: 'œ', mapping: Valid },
    Range { from: 'Ŕ', to: 'Ŕ', mapping: Mapped("ŕ") },
    Range { from: 'ŕ', to: 'ŕ', mapping: Valid },
    Range { from: 'Ŗ', to: 'Ŗ', mapping: Mapped("ŗ") },
    Range { from: 'ŗ', to: 'ŗ', mapping: Valid },
    Range { from: 'Ř', to: 'Ř', mapping: Mapped("ř") },
    Range { from: 'ř', to: 'ř', mapping: Valid },
    Range { from: 'Ś', to: 'Ś', mapping: Mapped("ś") },
    Range { from: 'ś', to: 'ś', mapping: Valid },
    Range { from: 'Ŝ', to: 'Ŝ', mapping: Mapped("ŝ") },
    Range { from: 'ŝ', to: 'ŝ', mapping: Valid },
    Range { from: 'Ş', to: 'Ş', mapping: Mapped("ş") },
    Range { from: 'ş', to: 'ş', mapping: Valid },
    Range { from: 'Š', to: 'Š', mapping: Mapped("š") },
    Range { from: 'š', to: 'š', mapping: Valid },
    Range { from: 'Ţ', to: 'Ţ', mapping: Mapped("ţ") },
    Range { from: 'ţ', to: 'ţ', mapping: Valid },
    Range { from: 'Ť', to: 'Ť', mapping: Mapped("ť") },
    Range { from: 'ť', to: 'ť', mapping: Valid },
    Range { from: 'Ŧ', to: 'Ŧ', mapping: Mapped("ŧ") },
    Range { from: 'ŧ', to: 'ŧ', mapping: Valid },
    Range { from: 'Ũ', to: 'Ũ', mapping: Mapped("ũ") },
    Range { from: 'ũ', to: 'ũ', mapping: Valid },
    Range { from: 'Ū', to: 'Ū', mapping: Mapped("ū") },
    Range { from: 'ū', to: 'ū', mapping: Valid },
    Range { from: 'Ŭ', to: 'Ŭ', mapping: Mapped("ŭ") },
    Range { from: 'ŭ', to: 'ŭ', mapping: Valid },
    Range { from: 'Ů', to: 'Ů', mapping: Mapped("ů") },
    Range { from: 'ů', to: 'ů', mapping: Valid },
    Range { from: 'Ű', to: 'Ű', mapping: Mapped("ű") },
    Range { from: 'ű', to: 'ű', mapping: Valid },
    Range { from: 'Ų', to: 'Ų', mapping: Mapped("ų") },
    Range { from: 'ų', to: 'ų', mapping: Valid },
    Range { from: 'Ŵ', to: 'Ŵ', mapping: Mapped("ŵ") },
    Range { from: 'ŵ', to: 'ŵ', mapping: Valid },
    Range { from: 'Ŷ', to: 'Ŷ', mapping: Mapped("ŷ") },
    Range { from: 'ŷ', to: 'ŷ', mapping: Valid },
    Range { from: 'Ÿ', to: 'Ÿ', mapping: Mapped("ÿ") },
    Range { from: 'Ź', to: 'Ź', mapping: Mapped("ź") },
    Range { from: 'ź', to: 'ź', mapping: Valid },
    Range { from: 'Ż', to: 'Ż', mapping: Mapped("ż") },
    Range { from: 'ż', to: 'ż', mapping: Valid },
    Range { from: 'Ž', to: 'Ž', mapping: Mapped("ž") },
    Range { from: 'ž', to: 'ž', mapping: Valid },
    Range { from: 'ſ', to: 'ſ', mapping: Mapped("s") },
    Range { from: 'ƀ', to: 'ƀ', mapping: Valid },
    Range { from: 'Ɓ', to: 'Ɓ', mapping: Mapped("ɓ") },
    Range { from: 'Ƃ', to: 'Ƃ', mapping: Mapped("ƃ") },
    Range { from: 'ƃ', to: 'ƃ', mapping: Valid },
    Range { from: 'Ƅ', to: 'Ƅ', mapping: Mapped("ƅ") },
    Range { from: 'ƅ', to: 'ƅ', mapping: Valid },
    Range { from: 'Ɔ', to: 'Ɔ', mapping: Mapped("ɔ") },
    Range { from: 'Ƈ', to: 'Ƈ', mapping: Mapped("ƈ") },
    Range { from: 'ƈ', to: 'ƈ', mapping: Valid },
    Range { from: 'Ɖ', to: 'Ɖ', mapping: Mapped("ɖ") },
    Range { from: 'Ɗ', to: 'Ɗ', mapping: Mapped("ɗ") },
    Range { from: 'Ƌ', to: 'Ƌ', mapping: Mapped("ƌ") },
    Range { from: 'ƌ', to: 'ƍ', mapping: Valid },
    Range { from: 'Ǝ', to: 'Ǝ', mapping: Mapped("ǝ") },
    Range { from: 'Ə', to: 'Ə', mapping: Mapped("ə") },
    Range { from: 'Ɛ', to: 'Ɛ', mapping: Mapped("ɛ") },
    Range { from: 'Ƒ', to: 'Ƒ', mapping: Mapped("ƒ") },
    Range { from: 'ƒ', to: 'ƒ', mapping: Valid },
    Range { from: 'Ɠ', to: 'Ɠ', mapping: Mapped("ɠ") },
    Range { from: 'Ɣ', to: 'Ɣ', mapping: Mapped("ɣ") },
    Range { from: 'ƕ', to: 'ƕ', mapping: Valid },
    Range { from: 'Ɩ', to: 'Ɩ', mapping: Mapped("ɩ") },
    Range { from: 'Ɨ', to: 'Ɨ', mapping: Mapped("ɨ") },
    Range { from: 'Ƙ', to: 'Ƙ', mapping: Mapped("ƙ") },
    Range { from: 'ƙ', to: 'ƛ', mapping: Valid },
    Range { from: 'Ɯ', to: 'Ɯ', mapping: Mapped("ɯ") },
    Range { from: 'Ɲ', to: 'Ɲ', mapping: Mapped("ɲ") },
    Range { from: 'ƞ', to: 'ƞ', mapping: Valid },
    Range { from: 'Ɵ', to: 'Ɵ', mapping: Mapped("ɵ") },
    Range { from: 'Ơ', to: 'Ơ', mapping: Mapped("ơ") },
    Range { from: 'ơ', to: 'ơ', mapping: Valid },
    Range { from: 'Ƣ', to: 'Ƣ', mapping: Mapped("ƣ") },
    Range { from: 'ƣ', to: 'ƣ', mapping: Valid },
    Range { from: 'Ƥ', to: 'Ƥ', mapping: Mapped("ƥ") },
    Range { from: 'ƥ', to: 'ƥ', mapping: Valid },
    Range { from: 'Ʀ', to: 'Ʀ', mapping: Mapped("ʀ") },
    Range { from: 'Ƨ', to: 'Ƨ', mapping: Mapped("ƨ") },
    Range { from: 'ƨ', to: 'ƨ', mapping: Valid },
    Range { from: 'Ʃ', to: 'Ʃ', mapping: Mapped("ʃ") },
    Range { from: 'ƪ', to: 'ƫ', mapping: Valid },
    Range { from: 'Ƭ', to: 'Ƭ', mapping: Mapped("ƭ") },
    Range { from: 'ƭ', to: 'ƭ', mapping: Valid },
    Range { from: 'Ʈ', to: 'Ʈ', mapping: Mapped("ʈ") },
    Range { from: 'Ư', to: 'Ư', mapping: Mapped("ư") },
    Range { from: 'ư', to: 'ư', mapping: Valid },
    Range { from: 'Ʊ', to: 'Ʊ', mapping: Mapped("ʊ") },
    Range { from: 'Ʋ', to: 'Ʋ', mapping: Mapped("ʋ") },
    Range { from: 'Ƴ', to: 'Ƴ', mapping: Mapped("ƴ") },
    Range { from: 'ƴ', to: 'ƴ', mapping: Valid },
    Range { from: 'Ƶ', to: 'Ƶ', mapping: Mapped("ƶ") },
    Range { from: 'ƶ', to: 'ƶ', mapping: Valid },
    Range { from: 'Ʒ', to: 'Ʒ', mapping: Mapped("ʒ") },
    Range { from: 'Ƹ', to: 'Ƹ', mapping: Mapped("ƹ") },
    Range { from: 'ƹ', to: 'ƻ', mapping: Valid },
    Range { from: 'Ƽ', to: 'Ƽ', mapping: Mapped("ƽ") },
    Range { from: 'ƽ', to: 'ǃ', mapping: Valid },
    Range { from: 'Ǆ', to: 'ǆ', mapping: Mapped("dž") },
    Range { from: 'Ǉ', to: 'ǉ', mapping: Mapped("lj") },
    Range { from: 'Ǌ', to: 'ǌ', mapping: Mapped("nj") },
    Range { from: 'Ǎ', to: 'Ǎ', mapping: Mapped("ǎ") },
    Range { from: 'ǎ', to: 'ǎ', mapping: Valid },
    Range { from: 'Ǐ', to: 'Ǐ', mapping: Mapped("ǐ") },
    Range { from: 'ǐ', to: 'ǐ', mapping: Valid },
    Range { from: 'Ǒ', to: 'Ǒ', mapping: Mapped("ǒ") },
    Range { from: 'ǒ', to: 'ǒ', mapping: Valid },
    Range { from: 'Ǔ', to: 'Ǔ', mapping: Mapped("ǔ") },
    Range { from: 'ǔ', to: 'ǔ', mapping: Valid },
    Range { from: 'Ǖ', to: 'Ǖ', mapping: Mapped("ǖ") },
    Range { from: 'ǖ', to: 'ǖ', mapping: Valid },
    Range { from: 'Ǘ', to: 'Ǘ', mapping: Mapped("ǘ") },
    Range { from: 'ǘ', to: 'ǘ', mapping: Valid },
    Range { from: 'Ǚ', to: 'Ǚ', mapping: Mapped("ǚ") },
    Range { from: 'ǚ', to: 'ǚ', mapping: Valid },
    Range { from: 'Ǜ', to: 'Ǜ', mapping: Mapped("ǜ") },
    Range { from: 'ǜ', to: 'ǝ', mapping: Valid },
    Range { from: 'Ǟ', to: 'Ǟ', mapping: Mapped("ǟ") },
    Range { from: 'ǟ', to: 'ǟ', mapping: Valid },
    Range { from: 'Ǡ', to: 'Ǡ', mapping: Mapped("ǡ") },
    Range { from: 'ǡ', to: 'ǡ', mapping: Valid },
    Range { from: 'Ǣ', to: 'Ǣ', mapping: Mapped("ǣ") },
    Range { from: 'ǣ', to: 'ǣ', mapping: Valid },
    Range { from: 'Ǥ', to: 'Ǥ', mapping: Mapped("ǥ") },
    Range { from: 'ǥ', to: 'ǥ', mapping: Valid },
    Range { from: 'Ǧ', to: 'Ǧ', mapping: Mapped("ǧ") },
    Range { from: 'ǧ', to: 'ǧ', mapping: Valid },
    Range { from: 'Ǩ', to: 'Ǩ', mapping: Mapped("ǩ") },
    Range { from: 'ǩ', to: 'ǩ', mapping: Valid },
    Range { from: 'Ǫ', to: 'Ǫ', mapping: Mapped("ǫ") },
    Range { from: 'ǫ', to: 'ǫ', mapping: Valid },
    Range { from: 'Ǭ', to: 'Ǭ', mapping: Mapped("ǭ") },
    Range { from: 'ǭ', to: 'ǭ', mapping: Valid },
    Range { from: 'Ǯ', to: 'Ǯ', mapping: Mapped("ǯ") },
    Range { from: 'ǯ', to: 'ǰ', mapping: Valid },
    Range { from: 'Ǳ', to: 'ǳ', mapping: Mapped("dz") },
    Range { from: 'Ǵ', to: 'Ǵ', mapping: Mapped("ǵ") },
    Range { from: 'ǵ', to: 'ǵ', mapping: Valid },
    Range { from: 'Ƕ', to: 'Ƕ', mapping: Mapped("ƕ") },
    Range { from: 'Ƿ', to: 'Ƿ', mapping: Mapped("ƿ") },
    Range { from: 'Ǹ', to: 'Ǹ', mapping: Mapped("ǹ") },
    Range { from: 'ǹ', to: 'ǹ', mapping: Valid },
    Range { from: 'Ǻ', to: 'Ǻ', mapping: Mapped("ǻ") },
    Range { from: 'ǻ', to: 'ǻ', mapping: Valid },
    Range { from: 'Ǽ', to: 'Ǽ', mapping: Mapped("ǽ") },
    Range { from: 'ǽ', to: 'ǽ', mapping: Valid },
    Range { from: 'Ǿ', to: 'Ǿ', mapping: Mapped("ǿ") },
    Range { from: 'ǿ', to: 'ǿ', mapping: Valid },
    Range { from: 'Ȁ', to: 'Ȁ', mapping: Mapped("ȁ") },
    Range { from: 'ȁ', to: 'ȁ', mapping: Valid },
    Range { from: 'Ȃ', to: 'Ȃ', mapping: Mapped("ȃ") },
    Range { from: 'ȃ', to: 'ȃ', mapping: Valid },
    Range { from: 'Ȅ', to: 'Ȅ', mapping: Mapped("ȅ") },
    Range { from: 'ȅ', to: 'ȅ', mapping: Valid },
    Range { from: 'Ȇ', to: 'Ȇ', mapping: Mapped("ȇ") },
    Range { from: 'ȇ', to: 'ȇ', mapping: Valid },
    Range { from: 'Ȉ', to: 'Ȉ', mapping: Mapped("ȉ") },
    Range { from: 'ȉ', to: 'ȉ', mapping: Valid },
    Range { from: 'Ȋ', to: 'Ȋ', mapping: Mapped("ȋ") },
    Range { from: 'ȋ', to: 'ȋ', mapping: Valid },
    Range { from: 'Ȍ', to: 'Ȍ', mapping: Mapped("ȍ") },
    Range { from: 'ȍ', to: 'ȍ', mapping: Valid },
    Range { from: 'Ȏ', to: 'Ȏ', mapping: Mapped("ȏ") },
    Range { from: 'ȏ', to: 'ȏ', mapping: Valid },
    Range { from: 'Ȑ', to: 'Ȑ', mapping: Mapped("ȑ") },
    Range { from: 'ȑ', to: 'ȑ', mapping: Valid },
    Range { from: 'Ȓ', to: 'Ȓ', mapping: Mapped("ȓ") },
    Range { from: 'ȓ', to: 'ȓ', mapping: Valid },
    Range { from: 'Ȕ', to: 'Ȕ', mapping: Mapped("ȕ") },
    Range { from: 'ȕ', to: 'ȕ', mapping: Valid },
    Range { from: 'Ȗ', to: 'Ȗ', mapping: Mapped("ȗ") },
    Range { from: 'ȗ', to: 'ȗ', mapping: Valid },
    Range { from: 'Ș', to: 'Ș', mapping: Mapped("ș") },
    Range { from: 'ș', to: 'ș', mapping: Valid },
    Range { from: 'Ț', to: 'Ț', mapping: Mapped("ț") },
    Range { from: 'ț', to: 'ț', mapping: Valid },
    Range { from: 'Ȝ', to: 'Ȝ', mapping: Mapped("ȝ") },
    Range { from: 'ȝ', to: 'ȝ', mapping: Valid },
    Range { from: 'Ȟ', to: 'Ȟ', mapping: Mapped("ȟ") },
    Range { from: 'ȟ', to: 'ȟ', mapping: Valid },
    Range { from: 'Ƞ', to: 'Ƞ', mapping: Mapped("ƞ") },
    Range { from: 'ȡ', to: 'ȡ', mapping: Valid },
    Range { from: 'Ȣ', to: 'Ȣ', mapping: Mapped("ȣ") },
    Range { from: 'ȣ', to: 'ȣ', mapping: Valid },
    Range { from: 'Ȥ', to: 'Ȥ', mapping: Mapped("ȥ") },
    Range { from: 'ȥ', to: 'ȥ', mapping: Valid },
    Range { from: 'Ȧ', to: 'Ȧ', mapping: Mapped("ȧ") },
    Range { from: 'ȧ', to: 'ȧ', mapping: Valid },
    Range { from: 'Ȩ', to: 'Ȩ', mapping: Mapped("ȩ") },
    Range { from: 'ȩ', to: 'ȩ', mapping: Valid },
    Range { from: 'Ȫ', to: 'Ȫ', mapping: Mapped("ȫ") },
    Range { from: 'ȫ', to: 'ȫ', mapping: Valid },
    Range { from: 'Ȭ', to: 'Ȭ', mapping: Mapped("ȭ") },
    Range { from: 'ȭ', to: 'ȭ', mapping: Valid },
    Range { from: 'Ȯ', to: 'Ȯ', mapping: Mapped("ȯ") },
    Range { from: 'ȯ', to: 'ȯ', mapping: Valid },
    Range { from: 'Ȱ', to: 'Ȱ', mapping: Mapped("ȱ") },
    Range { from: 'ȱ', to: 'ȱ', mapping: Valid },
    Range { from: 'Ȳ', to: 'Ȳ', mapping: Mapped("ȳ") },
    Range { from: 'ȳ', to: 'ȳ', mapping: Valid },
    Range { from: 'ȴ', to: 'ȶ', mapping: Valid },
    Range { from: 'ȷ', to: 'ȹ', mapping: Valid },
    Range { from: 'Ⱥ', to: 'Ⱥ', mapping: Mapped("ⱥ") },
    Range { from: 'Ȼ', to: 'Ȼ', mapping: Mapped("ȼ") },
    Range { from: 'ȼ', to: 'ȼ', mapping: Valid },
    Range { from: 'Ƚ', to: 'Ƚ', mapping: Mapped("ƚ") },
    Range { from: 'Ⱦ', to: 'Ⱦ', mapping: Mapped("ⱦ") },
    Range { from: 'ȿ', to: 'ɀ', mapping: Valid },
    Range { from: 'Ɂ', to: 'Ɂ', mapping: Mapped("ɂ") },
    Range { from: 'ɂ', to: 'ɂ', mapping: Valid },
    Range { from: 'Ƀ', to: 'Ƀ', mapping: Mapped("ƀ") },
    Range { from: 'Ʉ', to: 'Ʉ', mapping: Mapped("ʉ") },
    Range { from: 'Ʌ', to: 'Ʌ', mapping: Mapped("ʌ") },
    Range { from: 'Ɇ', to: 'Ɇ', mapping: Mapped("ɇ") },
    Range { from: 'ɇ', to: 'ɇ', mapping: Valid },
    Range { from: 'Ɉ', to: 'Ɉ', mapping: Mapped("ɉ") },
    Range { from: 'ɉ', to: 'ɉ', mapping: Valid },
    Range { from: 'Ɋ', to: 'Ɋ', mapping: Mapped("ɋ") },
    Range { from: 'ɋ', to: 'ɋ', mapping: Valid },
    Range { from: 'Ɍ', to: 'Ɍ', mapping: Mapped("ɍ") },
    Range { from: 'ɍ', to: 'ɍ', mapping: Valid },
    Range { from: 'Ɏ', to: 'Ɏ', mapping: Mapped("ɏ") },
    Range { from: 'ɏ', to: 'ɏ', mapping: Valid },
    Range { from: 'ɐ', to: 'ʨ', mapping: Valid },
    Range { from: 'ʩ', to: 'ʭ', mapping: Valid },
    Range { from: 'ʮ', to: 'ʯ', mapping: Valid },
    Range { from: 'ʰ', to: 'ʰ', mapping: Mapped("h") },
    Range { from: 'ʱ', to: 'ʱ', mapping: Mapped("ɦ") },
    Range { from: 'ʲ', to: 'ʲ', mapping: Mapped("j") },
    Range { from: 'ʳ', to: 'ʳ', mapping: Mapped("r") },
    Range { from: 'ʴ', to: 'ʴ', mapping: Mapped("ɹ") },
    Range { from: 'ʵ', to: 'ʵ', mapping: Mapped("ɻ") },
    Range { from: 'ʶ', to: 'ʶ', mapping: Mapped("ʁ") },
    Range { from: 'ʷ', to: 'ʷ', mapping: Mapped("w") },
    Range { from: 'ʸ', to: 'ʸ', mapping: Mapped("y") },
    Range { from: 'ʹ', to: 'ˁ', mapping: Valid },
    Range { from: '˂', to: '˅', mapping: Valid },
    Range { from: 'ˆ', to: 'ˑ', mapping: Valid },
    Range { from: '˒', to: '˗', mapping: Valid },
    Range { from: '˘', to: '˘', mapping: DisallowedStd3Mapped(" ̆") },
    Range { from: '˙', to: '˙', mapping: DisallowedStd3Mapped(" ̇") },
    Range { from: '˚', to: '˚', mapping: DisallowedStd3Mapped(" ̊") },
    Range { from: '˛', to: '˛', mapping: DisallowedStd3Mapped(" ̨") },
    Range { from: '˜', to: '˜', mapping: DisallowedStd3Mapped(" ̃") },
    Range { from: '˝', to: '˝', mapping: DisallowedStd3Mapped(" ̋") },
    Range { from: '˞', to: '˞', mapping: Valid },
    Range { from: '˟', to: '˟', mapping: Valid },
    Range { from: 'ˠ', to: 'ˠ', mapping: Mapped("ɣ") },
    Range { from: 'ˡ', to: 'ˡ', mapping: Mapped("l") },
    Range { from: 'ˢ', to: 'ˢ', mapping: Mapped("s") },
    Range { from: 'ˣ', to: 'ˣ', mapping: Mapped("x") },
    Range { from: 'ˤ', to: 'ˤ', mapping: Mapped("ʕ") },
    Range { from: '˥', to: '˩', mapping: Valid },
    Range { from: '˪', to: '˫', mapping: Valid },
    Range { from: 'ˬ', to: 'ˬ', mapping: Valid },
    Range { from: '˭', to: '˭', mapping: Valid },
    Range { from: 'ˮ', to: 'ˮ', mapping: Valid },
    Range { from: '˯', to: '˿', mapping: Valid },
    Range { from: '̀', to: '̿', mapping: Valid },
    Range { from: '̀', to: '̀', mapping: Mapped("̀") },
    Range { from: '́', to: '́', mapping: Mapped("́") },
    Range { from: '͂', to: '͂', mapping: Valid },
    Range { from: '̓', to: '̓', mapping: Mapped("̓") },
    Range { from: '̈́', to: '̈́', mapping: Mapped("̈́") },
    Range { from: 'ͅ', to: 'ͅ', mapping: Mapped("ι") },
    Range { from: '͆', to: '͎', mapping: Valid },
    Range { from: '͏', to: '͏', mapping: Ignored },
    Range { from: '͐', to: '͗', mapping: Valid },
    Range { from: '͘', to: '͜', mapping: Valid },
    Range { from: '͝', to: '͟', mapping: Valid },
    Range { from: '͠', to: '͡', mapping: Valid },
    Range { from: '͢', to: '͢', mapping: Valid },
    Range { from: 'ͣ', to: 'ͯ', mapping: Valid },
    Range { from: 'Ͱ', to: 'Ͱ', mapping: Mapped("ͱ") },
    Range { from: 'ͱ', to: 'ͱ', mapping: Valid },
    Range { from: 'Ͳ', to: 'Ͳ', mapping: Mapped("ͳ") },
    Range { from: 'ͳ', to: 'ͳ', mapping: Valid },
    Range { from: 'ʹ', to: 'ʹ', mapping: Mapped("ʹ") },
    Range { from: '͵', to: '͵', mapping: Valid },
    Range { from: 'Ͷ', to: 'Ͷ', mapping: Mapped("ͷ") },
    Range { from: 'ͷ', to: 'ͷ', mapping: Valid },
    Range { from: '͸', to: '͹', mapping: Disallowed },
    Range { from: 'ͺ', to: 'ͺ', mapping: DisallowedStd3Mapped(" ι") },
    Range { from: 'ͻ', to: 'ͽ', mapping: Valid },
    Range { from: ';', to: ';', mapping: DisallowedStd3Mapped(";") },
    Range { from: 'Ϳ', to: 'Ϳ', mapping: Mapped("ϳ") },
    Range { from: '΀', to: '΃', mapping: Disallowed },
    Range { from: '΄', to: '΄', mapping: DisallowedStd3Mapped(" ́") },
    Range { from: '΅', to: '΅', mapping: DisallowedStd3Mapped(" ̈́") },
    Range { from: 'Ά', to: 'Ά', mapping: Mapped("ά") },
    Range { from: '·', to: '·', mapping: Mapped("·") },
    Range { from: 'Έ', to: 'Έ', mapping: Mapped("έ") },
    Range { from: 'Ή', to: 'Ή', mapping: Mapped("ή") },
    Range { from: 'Ί', to: 'Ί', mapping: Mapped("ί") },
    Range { from: '΋', to: '΋', mapping: Disallowed },
    Range { from: 'Ό', to: 'Ό', mapping: Mapped("ό") },
    Range { from: '΍', to: '΍', mapping: Disallowed },
    Range { from: 'Ύ', to: 'Ύ', mapping: Mapped("ύ") },
    Range { from: 'Ώ', to: 'Ώ', mapping: Mapped("ώ") },
    Range { from: 'ΐ', to: 'ΐ', mapping: Valid },
    Range { from: 'Α', to: 'Α', mapping: Mapped("α") },
    Range { from: 'Β', to: 'Β', mapping: Mapped("β") },
    Range { from: 'Γ', to: 'Γ', mapping: Mapped("γ") },
    Range { from: 'Δ', to: 'Δ', mapping: Mapped("δ") },
    Range { from: 'Ε', to: 'Ε', mapping: Mapped("ε") },
    Range { from: 'Ζ', to: 'Ζ', mapping: Mapped("ζ") },
    Range { from: 'Η', to: 'Η', mapping: Mapped("η") },
    Range { from: 'Θ', to: 'Θ', mapping: Mapped("θ") },
    Range { from: 'Ι', to: 'Ι', mapping: Mapped("ι") },
    Range { from: 'Κ', to: 'Κ', mapping: Mapped("κ") },
    Range { from: 'Λ', to: 'Λ', mapping: Mapped("λ") },
    Range { from: 'Μ', to: 'Μ', mapping: Mapped("μ") },
    Range { from: 'Ν', to: 'Ν', mapping: Mapped("ν") },
    Range { from: 'Ξ', to: 'Ξ', mapping: Mapped("ξ") },
    Range { from: 'Ο', to: 'Ο', mapping: Mapped("ο") },
    Range { from: 'Π', to: 'Π', mapping: Mapped("π") },
    Range { from: 'Ρ', to: 'Ρ', mapping: Mapped("ρ") },
    Range { from: '΢', to: '΢', mapping: Disallowed },
    Range { from: 'Σ', to: 'Σ', mapping: Mapped("σ") },
    Range { from: 'Τ', to: 'Τ', mapping: Mapped("τ") },
    Range { from: 'Υ', to: 'Υ', mapping: Mapped("υ") },
    Range { from: 'Φ', to: 'Φ', mapping: Mapped("φ") },
    Range { from: 'Χ', to: 'Χ', mapping: Mapped("χ") },
    Range { from: 'Ψ', to: 'Ψ', mapping: Mapped("ψ") },
    Range { from: 'Ω', to: 'Ω', mapping: Mapped("ω") },
    Range { from: 'Ϊ', to: 'Ϊ', mapping: Mapped("ϊ") },
    Range { from: 'Ϋ', to: 'Ϋ', mapping: Mapped("ϋ") },
    Range { from: 'ά', to: 'ρ', mapping: Valid },
    Range { from: 'ς', to: 'ς', mapping: Deviation("σ") },
    Range { from: 'σ', to: 'ώ', mapping: Valid },
    Range { from: 'Ϗ', to: 'Ϗ', mapping: Mapped("ϗ") },
    Range { from: 'ϐ', to: 'ϐ', mapping: Mapped("β") },
    Range { from: 'ϑ', to: 'ϑ', mapping: Mapped("θ") },
    Range { from: 'ϒ', to: 'ϒ', mapping: Mapped("υ") },
    Range { from: 'ϓ', to: 'ϓ', mapping: Mapped("ύ") },
    Range { from: 'ϔ', to: 'ϔ', mapping: Mapped("ϋ") },
    Range { from: 'ϕ', to: 'ϕ', mapping: Mapped("φ") },
    Range { from: 'ϖ', to: 'ϖ', mapping: Mapped("π") },
    Range { from: 'ϗ', to: 'ϗ', mapping: Valid },
    Range { from: 'Ϙ', to: 'Ϙ', mapping: Mapped("ϙ") },
    Range { from: 'ϙ', to: 'ϙ', mapping: Valid },
    Range { from: 'Ϛ', to: 'Ϛ', mapping: Mapped("ϛ") },
    Range { from: 'ϛ', to: 'ϛ', mapping: Valid },
    Range { from: 'Ϝ', to: 'Ϝ', mapping: Mapped("ϝ") },
    Range { from: 'ϝ', to: 'ϝ', mapping: Valid },
    Range { from: 'Ϟ', to: 'Ϟ', mapping: Mapped("ϟ") },
    Range { from: 'ϟ', to: 'ϟ', mapping: Valid },
    Range { from: 'Ϡ', to: 'Ϡ', mapping: Mapped("ϡ") },
    Range { from: 'ϡ', to: 'ϡ', mapping: Valid },
    Range { from: 'Ϣ', to: 'Ϣ', mapping: Mapped("ϣ") },
    Range { from: 'ϣ', to: 'ϣ', mapping: Valid },
    Range { from: 'Ϥ', to: 'Ϥ', mapping: Mapped("ϥ") },
    Range { from: 'ϥ', to: 'ϥ', mapping: Valid },
    Range { from: 'Ϧ', to: 'Ϧ', mapping: Mapped("ϧ") },
    Range { from: 'ϧ', to: 'ϧ', mapping: Valid },
    Range { from: 'Ϩ', to: 'Ϩ', mapping: Mapped("ϩ") },
    Range { from: 'ϩ', to: 'ϩ', mapping: Valid },
    Range { from: 'Ϫ', to: 'Ϫ', mapping: Mapped("ϫ") },
    Range { from: 'ϫ', to: 'ϫ', mapping: Valid },
    Range { from: 'Ϭ', to: 'Ϭ', mapping: Mapped("ϭ") },
    Range { from: 'ϭ', to: 'ϭ', mapping: Valid },
    Range { from: 'Ϯ', to: 'Ϯ', mapping: Mapped("ϯ") },
    Range { from: 'ϯ', to: 'ϯ', mapping: Valid },
    Range { from: 'ϰ', to: 'ϰ', mapping: Mapped("κ") },
    Range { from: 'ϱ', to: 'ϱ', mapping: Mapped("ρ") },
    Range { from: 'ϲ', to: 'ϲ', mapping: Mapped("σ") },
    Range { from: 'ϳ', to: 'ϳ', mapping: Valid },
    Range { from: 'ϴ', to: 'ϴ', mapping: Mapped("θ") },
    Range { from: 'ϵ', to: 'ϵ', mapping: Mapped("ε") },
    Range { from: '϶', to: '϶', mapping: Valid },
    Range { from: 'Ϸ', to: 'Ϸ', mapping: Mapped("ϸ") },
    Range { from: 'ϸ', to: 'ϸ', mapping: Valid },
    Range { from: 'Ϲ', to: 'Ϲ', mapping: Mapped("σ") },
    Range { from: 'Ϻ', to: 'Ϻ', mapping: Mapped("ϻ") },
    Range { from: 'ϻ', to: 'ϻ', mapping: Valid },
    Range { from: 'ϼ', to: 'ϼ', mapping: Valid },
    Range { from: 'Ͻ', to: 'Ͻ', mapping: Mapped("ͻ") },
    Range { from: 'Ͼ', to: 'Ͼ', mapping: Mapped("ͼ") },
    Range { from: 'Ͽ', to: 'Ͽ', mapping: Mapped("ͽ") },
    Range { from: 'Ѐ', to: 'Ѐ', mapping: Mapped("ѐ") },
    Range { from: 'Ё', to: 'Ё', mapping: Mapped("ё") },
    Range { from: 'Ђ', to: 'Ђ', mapping: Mapped("ђ") },
    Range { from: 'Ѓ', to: 'Ѓ', mapping: Mapped("ѓ") },
    Range { from: 'Є', to: 'Є', mapping: Mapped("є") },
    Range { from: 'Ѕ', to: 'Ѕ', mapping: Mapped("ѕ") },
    Range { from: 'І', to: 'І', mapping: Mapped("і") },
    Range { from: 'Ї', to: 'Ї', mapping: Mapped("ї") },
    Range { from: 'Ј', to: 'Ј', mapping: Mapped("ј") },
    Range { from: 'Љ', to: 'Љ', mapping: Mapped("љ") },
    Range { from: 'Њ', to: 'Њ', mapping: Mapped("њ") },
    Range { from: 'Ћ', to: 'Ћ', mapping: Mapped("ћ") },
    Range { from: 'Ќ', to: 'Ќ', mapping: Mapped("ќ") },
    Range { from: 'Ѝ', to: 'Ѝ', mapping: Mapped("ѝ") },
    Range { from: 'Ў', to: 'Ў', mapping: Mapped("ў") },
    Range { from: 'Џ', to: 'Џ', mapping: Mapped("џ") },
    Range { from: 'А', to: 'А', mapping: Mapped("а") },
    Range { from: 'Б', to: 'Б', mapping: Mapped("б") },
    Range { from: 'В', to: 'В', mapping: Mapped("в") },
    Range { from: 'Г', to: 'Г', mapping: Mapped("г") },
    Range { from: 'Д', to: 'Д', mapping: Mapped("д") },
    Range { from: 'Е', to: 'Е', mapping: Mapped("е") },
    Range { from: 'Ж', to: 'Ж', mapping: Mapped("ж") },
    Range { from: 'З', to: 'З', mapping: Mapped("з") },
    Range { from: 'И', to: 'И', mapping: Mapped("и") },
    Range { from: 'Й', to: 'Й', mapping: Mapped("й") },
    Range { from: 'К', to: 'К', mapping: Mapped("к") },
    Range { from: 'Л', to: 'Л', mapping: Mapped("л") },
    Range { from: 'М', to: 'М', mapping: Mapped("м") },
    Range { from: 'Н', to: 'Н', mapping: Mapped("н") },
    Range { from: 'О', to: 'О', mapping: Mapped("о") },
    Range { from: 'П', to: 'П', mapping: Mapped("п") },
    Range { from: 'Р', to: 'Р', mapping: Mapped("р") },
    Range { from: 'С', to: 'С', mapping: Mapped("с") },
    Range { from: 'Т', to: 'Т', mapping: Mapped("т") },
    Range { from: 'У', to: 'У', mapping: Mapped("у") },
    Range { from: 'Ф', to: 'Ф', mapping: Mapped("ф") },
    Range { from: 'Х', to: 'Х', mapping: Mapped("х") },
    Range { from: 'Ц', to: 'Ц', mapping: Mapped("ц") },
    Range { from: 'Ч', to: 'Ч', mapping: Mapped("ч") },
    Range { from: 'Ш', to: 'Ш', mapping: Mapped("ш") },
    Range { from: 'Щ', to: 'Щ', mapping: Mapped("щ") },
    Range { from: 'Ъ', to: 'Ъ', mapping: Mapped("ъ") },
    Range { from: 'Ы', to: 'Ы', mapping: Mapped("ы") },
    Range { from: 'Ь', to: 'Ь', mapping: Mapped("ь") },
    Range { from: 'Э', to: 'Э', mapping: Mapped("э") },
    Range { from: 'Ю', to: 'Ю', mapping: Mapped("ю") },
    Range { from: 'Я', to: 'Я', mapping: Mapped("я") },
    Range { from: 'а', to: 'я', mapping: Valid },
    Range { from: 'ѐ', to: 'ѐ', mapping: Valid },
    Range { from: 'ё', to: 'ќ', mapping: Valid },
    Range { from: 'ѝ', to: 'ѝ', mapping: Valid },
    Range { from: 'ў', to: 'џ', mapping: Valid },
    Range { from: 'Ѡ', to: 'Ѡ', mapping: Mapped("ѡ") },
    Range { from: 'ѡ', to: 'ѡ', mapping: Valid },
    Range { from: 'Ѣ', to: 'Ѣ', mapping: Mapped("ѣ") },
    Range { from: 'ѣ', to: 'ѣ', mapping: Valid },
    Range { from: 'Ѥ', to: 'Ѥ', mapping: Mapped("ѥ") },
    Range { from: 'ѥ', to: 'ѥ', mapping: Valid },
    Range { from: 'Ѧ', to: 'Ѧ', mapping: Mapped("ѧ") },
    Range { from: 'ѧ', to: 'ѧ', mapping: Valid },
    Range { from: 'Ѩ', to: 'Ѩ', mapping: Mapped("ѩ") },
    Range { from: 'ѩ', to: 'ѩ', mapping: Valid },
    Range { from: 'Ѫ', to: 'Ѫ', mapping: Mapped("ѫ") },
    Range { from: 'ѫ', to: 'ѫ', mapping: Valid },
    Range { from: 'Ѭ', to: 'Ѭ', mapping: Mapped("ѭ") },
    Range { from: 'ѭ', to: 'ѭ', mapping: Valid },
    Range { from: 'Ѯ', to: 'Ѯ', mapping: Mapped("ѯ") },
    Range { from: 'ѯ', to: 'ѯ', mapping: Valid },
    Range { from: 'Ѱ', to: 'Ѱ', mapping: Mapped("ѱ") },
    Range { from: 'ѱ', to: 'ѱ', mapping: Valid },
    Range { from: 'Ѳ', to: 'Ѳ', mapping: Mapped("ѳ") },
    Range { from: 'ѳ', to: 'ѳ', mapping: Valid },
    Range { from: 'Ѵ', to: 'Ѵ', mapping: Mapped("ѵ") },
    Range { from: 'ѵ', to: 'ѵ', mapping: Valid },
    Range { from: 'Ѷ', to: 'Ѷ', mapping: Mapped("ѷ") },
    Range { from: 'ѷ', to: 'ѷ', mapping: Valid },
    Range { from: 'Ѹ', to: 'Ѹ', mapping: Mapped("ѹ") },
    Range { from: 'ѹ', to: 'ѹ', mapping: Valid },
    Range { from: 'Ѻ', to: 'Ѻ', mapping: Mapped("ѻ") },
    Range { from: 'ѻ', to: 'ѻ', mapping: Valid },
    Range { from: 'Ѽ', to: 'Ѽ', mapping: Mapped("ѽ") },
    Range { from: 'ѽ', to: 'ѽ', mapping: Valid },
    Range { from: 'Ѿ', to: 'Ѿ', mapping: Mapped("ѿ") },
    Range { from: 'ѿ', to: 'ѿ', mapping: Valid },
    Range { from: 'Ҁ', to: 'Ҁ', mapping: Mapped("ҁ") },
    Range { from: 'ҁ', to: 'ҁ', mapping: Valid },
    Range { from: '҂', to: '҂', mapping: Valid },
    Range { from: '҃', to: '҆', mapping: Valid },
    Range { from: '҇', to: '҇', mapping: Valid },
    Range { from: '҈', to: '҉', mapping: Valid },
    Range { from: 'Ҋ', to: 'Ҋ', mapping: Mapped("ҋ") },
    Range { from: 'ҋ', to: 'ҋ', mapping: Valid },
    Range { from: 'Ҍ', to: 'Ҍ', mapping: Mapped("ҍ") },
    Range { from: 'ҍ', to: 'ҍ', mapping: Valid },
    Range { from: 'Ҏ', to: 'Ҏ', mapping: Mapped("ҏ") },
    Range { from: 'ҏ', to: 'ҏ', mapping: Valid },
    Range { from: 'Ґ', to: 'Ґ', mapping: Mapped("ґ") },
    Range { from: 'ґ', to: 'ґ', mapping: Valid },
    Range { from: 'Ғ', to: 'Ғ', mapping: Mapped("ғ") },
    Range { from: 'ғ', to: 'ғ', mapping: Valid },
    Range { from: 'Ҕ', to: 'Ҕ', mapping: Mapped("ҕ") },
    Range { from: 'ҕ', to: 'ҕ', mapping: Valid },
    Range { from: 'Җ', to: 'Җ', mapping: Mapped("җ") },
    Range { from: 'җ', to: 'җ', mapping: Valid },
    Range { from: 'Ҙ', to: 'Ҙ', mapping: Mapped("ҙ") },
    Range { from: 'ҙ', to: 'ҙ', mapping: Valid },
    Range { from: 'Қ', to: 'Қ', mapping: Mapped("қ") },
    Range { from: 'қ', to: 'қ', mapping: Valid },
    Range { from: 'Ҝ', to: 'Ҝ', mapping: Mapped("ҝ") },
    Range { from: 'ҝ', to: 'ҝ', mapping: Valid },
    Range { from: 'Ҟ', to: 'Ҟ', mapping: Mapped("ҟ") },
    Range { from: 'ҟ', to: 'ҟ', mapping: Valid },
    Range { from: 'Ҡ', to: 'Ҡ', mapping: Mapped("ҡ") },
    Range { from: 'ҡ', to: 'ҡ', mapping: Valid },
    Range { from: 'Ң', to: 'Ң', mapping: Mapped("ң") },
    Range { from: 'ң', to: 'ң', mapping: Valid },
    Range { from: 'Ҥ', to: 'Ҥ', mapping: Mapped("ҥ") },
    Range { from: 'ҥ', to: 'ҥ', mapping: Valid },
    Range { from: 'Ҧ', to: 'Ҧ', mapping: Mapped("ҧ") },
    Range { from: 'ҧ', to: 'ҧ', mapping: Valid },
    Range { from: 'Ҩ', to: 'Ҩ', mapping: Mapped("ҩ") },
    Range { from: 'ҩ', to: 'ҩ', mapping: Valid },
    Range { from: 'Ҫ', to: 'Ҫ', mapping: Mapped("ҫ") },
    Range { from: 'ҫ', to: 'ҫ', mapping: Valid },
    Range { from: 'Ҭ', to: 'Ҭ', mapping: Mapped("ҭ") },
    Range { from: 'ҭ', to: 'ҭ', mapping: Valid },
    Range { from: 'Ү', to: 'Ү', mapping: Mapped("ү") },
    Range { from: 'ү', to: 'ү', mapping: Valid },
    Range { from: 'Ұ', to: 'Ұ', mapping: Mapped("ұ") },
    Range { from: 'ұ', to: 'ұ', mapping: Valid },
    Range { from: 'Ҳ', to: 'Ҳ', mapping: Mapped("ҳ") },
    Range { from: 'ҳ', to: 'ҳ', mapping: Valid },
    Range { from: 'Ҵ', to: 'Ҵ', mapping: Mapped("ҵ") },
    Range { from: 'ҵ', to: 'ҵ', mapping: Valid },
    Range { from: 'Ҷ', to: 'Ҷ', mapping: Mapped("ҷ") },
    Range { from: 'ҷ', to: 'ҷ', mapping: Valid },
    Range { from: 'Ҹ', to: 'Ҹ', mapping: Mapped("ҹ") },
    Range { from: 'ҹ', to: 'ҹ', mapping: Valid },
    Range { from: 'Һ', to: 'Һ', mapping: Mapped("һ") },
    Range { from: 'һ', to: 'һ', mapping: Valid },
    Range { from: 'Ҽ', to: 'Ҽ', mapping: Mapped("ҽ") },
    Range { from: 'ҽ', to: 'ҽ', mapping: Valid },
    Range { from: 'Ҿ', to: 'Ҿ', mapping: Mapped("ҿ") },
    Range { from: 'ҿ', to: 'ҿ', mapping: Valid },
    Range { from: 'Ӏ', to: 'Ӏ', mapping: Disallowed },
    Range { from: 'Ӂ', to: 'Ӂ', mapping: Mapped("ӂ") },
    Range { from: 'ӂ', to: 'ӂ', mapping: Valid },
    Range { from: 'Ӄ', to: 'Ӄ', mapping: Mapped("ӄ") },
    Range { from: 'ӄ', to: 'ӄ', mapping: Valid },
    Range { from: 'Ӆ', to: 'Ӆ', mapping: Mapped("ӆ") },
    Range { from: 'ӆ', to: 'ӆ', mapping: Valid },
    Range { from: 'Ӈ', to: 'Ӈ', mapping: Mapped("ӈ") },
    Range { from: 'ӈ', to: 'ӈ', mapping: Valid },
    Range { from: 'Ӊ', to: 'Ӊ', mapping: Mapped("ӊ") },
    Range { from: 'ӊ', to: 'ӊ', mapping: Valid },
    Range { from: 'Ӌ', to: 'Ӌ', mapping: Mapped("ӌ") },
    Range { from: 'ӌ', to: 'ӌ', mapping: Valid },
    Range { from: 'Ӎ', to: 'Ӎ', mapping: Mapped("ӎ") },
    Range { from: 'ӎ', to: 'ӎ', mapping: Valid },
    Range { from: 'ӏ', to: 'ӏ', mapping: Valid },
    Range { from: 'Ӑ', to: 'Ӑ', mapping: Mapped("ӑ") },
    Range { from: 'ӑ', to: 'ӑ', mapping: Valid },
    Range { from: 'Ӓ', to: 'Ӓ', mapping: Mapped("ӓ") },
    Range { from: 'ӓ', to: 'ӓ', mapping: Valid },
    Range { from: 'Ӕ', to: 'Ӕ', mapping: Mapped("ӕ") },
    Range { from: 'ӕ', to: 'ӕ', mapping: Valid },
    Range { from: 'Ӗ', to: 'Ӗ', mapping: Mapped("ӗ") },
    Range { from: 'ӗ', to: 'ӗ', mapping: Valid },
    Range { from: 'Ә', to: 'Ә', mapping: Mapped("ә") },
    Range { from: 'ә', to: 'ә', mapping: Valid },
    Range { from: 'Ӛ', to: 'Ӛ', mapping: Mapped("ӛ") },
    Range { from: 'ӛ', to: 'ӛ', mapping: Valid },
    Range { from: 'Ӝ', to: 'Ӝ', mapping: Mapped("ӝ") },
    Range { from: 'ӝ', to: 'ӝ', mapping: Valid },
    Range { from: 'Ӟ', to: 'Ӟ', mapping: Mapped("ӟ") },
    Range { from: 'ӟ', to: 'ӟ', mapping: Valid },
    Range { from: 'Ӡ', to: 'Ӡ', mapping: Mapped("ӡ") },
    Range { from: 'ӡ', to: 'ӡ', mapping: Valid },
    Range { from: 'Ӣ', to: 'Ӣ', mapping: Mapped("ӣ") },
    Range { from: 'ӣ', to: 'ӣ', mapping: Valid },
    Range { from: 'Ӥ', to: 'Ӥ', mapping: Mapped("ӥ") },
    Range { from: 'ӥ', to: 'ӥ', mapping: Valid },
    Range { from: 'Ӧ', to: 'Ӧ', mapping: Mapped("ӧ") },
    Range { from: 'ӧ', to: 'ӧ', mapping: Valid },
    Range { from: 'Ө', to: 'Ө', mapping: Mapped("ө") },
    Range { from: 'ө', to: 'ө', mapping: Valid },
    Range { from: 'Ӫ', to: 'Ӫ', mapping: Mapped("ӫ") },
    Range { from: 'ӫ', to: 'ӫ', mapping: Valid },
    Range { from: 'Ӭ', to: 'Ӭ', mapping: Mapped("ӭ") },
    Range { from: 'ӭ', to: 'ӭ', mapping: Valid },
    Range { from: 'Ӯ', to: 'Ӯ', mapping: Mapped("ӯ") },
    Range { from: 'ӯ', to: 'ӯ', mapping: Valid },
    Range { from: 'Ӱ', to: 'Ӱ', mapping: Mapped("ӱ") },
    Range { from: 'ӱ', to: 'ӱ', mapping: Valid },
    Range { from: 'Ӳ', to: 'Ӳ', mapping: Mapped("ӳ") },
    Range { from: 'ӳ', to: 'ӳ', mapping: Valid },
    Range { from: 'Ӵ', to: 'Ӵ', mapping: Mapped("ӵ") },
    Range { from: 'ӵ', to: 'ӵ', mapping: Valid },
    Range { from: 'Ӷ', to: 'Ӷ', mapping: Mapped("ӷ") },
    Range { from: 'ӷ', to: 'ӷ', mapping: Valid },
    Range { from: 'Ӹ', to: 'Ӹ', mapping: Mapped("ӹ") },
    Range { from: 'ӹ', to: 'ӹ', mapping: Valid },
    Range { from: 'Ӻ', to: 'Ӻ', mapping: Mapped("ӻ") },
    Range { from: 'ӻ', to: 'ӻ', mapping: Valid },
    Range { from: 'Ӽ', to: 'Ӽ', mapping: Mapped("ӽ") },
    Range { from: 'ӽ', to: 'ӽ', mapping: Valid },
    Range { from: 'Ӿ', to: 'Ӿ', mapping: Mapped("ӿ") },
    Range { from: 'ӿ', to: 'ӿ', mapping: Valid },
    Range { from: 'Ԁ', to: 'Ԁ', mapping: Mapped("ԁ") },
    Range { from: 'ԁ', to: 'ԁ', mapping: Valid },
    Range { from: 'Ԃ', to: 'Ԃ', mapping: Mapped("ԃ") },
    Range { from: 'ԃ', to: 'ԃ', mapping: Valid },
    Range { from: 'Ԅ', to: 'Ԅ', mapping: Mapped("ԅ") },
    Range { from: 'ԅ', to: 'ԅ', mapping: Valid },
    Range { from: 'Ԇ', to: 'Ԇ', mapping: Mapped("ԇ") },
    Range { from: 'ԇ', to: 'ԇ', mapping: Valid },
    Range { from: 'Ԉ', to: 'Ԉ', mapping: Mapped("ԉ") },
    Range { from: 'ԉ', to: 'ԉ', mapping: Valid },
    Range { from: 'Ԋ', to: 'Ԋ', mapping: Mapped("ԋ") },
    Range { from: 'ԋ', to: 'ԋ', mapping: Valid },
    Range { from: 'Ԍ', to: 'Ԍ', mapping: Mapped("ԍ") },
    Range { from: 'ԍ', to: 'ԍ', mapping: Valid },
    Range { from: 'Ԏ', to: 'Ԏ', mapping: Mapped("ԏ") },
    Range { from: 'ԏ', to: 'ԏ', mapping: Valid },
    Range { from: 'Ԑ', to: 'Ԑ', mapping: Mapped("ԑ") },
    Range { from: 'ԑ', to: 'ԑ', mapping: Valid },
    Range { from: 'Ԓ', to: 'Ԓ', mapping: Mapped("ԓ") },
    Range { from: 'ԓ', to: 'ԓ', mapping: Valid },
    Range { from: 'Ԕ', to: 'Ԕ', mapping: Mapped("ԕ") },
    Range { from: 'ԕ', to: 'ԕ', mapping: Valid },
    Range { from: 'Ԗ', to: 'Ԗ', mapping: Mapped("ԗ") },
    Range { from: 'ԗ', to: 'ԗ', mapping: Valid },
    Range { from: 'Ԙ', to: 'Ԙ', mapping: Mapped("ԙ") },
    Range { from: 'ԙ', to: 'ԙ', mapping: Valid },
    Range { from: 'Ԛ', to: 'Ԛ', mapping: Mapped("ԛ") },
    Range { from: 'ԛ', to: 'ԛ', mapping: Valid },
    Range { from: 'Ԝ', to: 'Ԝ', mapping: Mapped("ԝ") },
    Range { from: 'ԝ', to: 'ԝ', mapping: Valid },
    Range { from: 'Ԟ', to: 'Ԟ', mapping: Mapped("ԟ") },
    Range { from: 'ԟ', to: 'ԟ', mapping: Valid },
    Range { from: 'Ԡ', to: 'Ԡ', mapping: Mapped("ԡ") },
    Range { from: 'ԡ', to: 'ԡ', mapping: Valid },
    Range { from: 'Ԣ', to: 'Ԣ', mapping: Mapped("ԣ") },
    Range { from: 'ԣ', to: 'ԣ', mapping: Valid },
    Range { from: 'Ԥ', to: 'Ԥ', mapping: Mapped("ԥ") },
    Range { from: 'ԥ', to: 'ԥ', mapping: Valid },
    Range { from: 'Ԧ', to: 'Ԧ', mapping: Mapped("ԧ") },
    Range { from: 'ԧ', to: 'ԧ', mapping: Valid },
    Range { from: 'Ԩ', to: 'Ԩ', mapping: Mapped("ԩ") },
    Range { from: 'ԩ', to: 'ԩ', mapping: Valid },
    Range { from: 'Ԫ', to: 'Ԫ', mapping: Mapped("ԫ") },
    Range { from: 'ԫ', to: 'ԫ', mapping: Valid },
    Range { from: 'Ԭ', to: 'Ԭ', mapping: Mapped("ԭ") },
    Range { from: 'ԭ', to: 'ԭ', mapping: Valid },
    Range { from: 'Ԯ', to: 'Ԯ', mapping: Mapped("ԯ") },
    Range { from: 'ԯ', to: 'ԯ', mapping: Valid },
    Range { from: '԰', to: '԰', mapping: Disallowed },
    Range { from: 'Ա', to: 'Ա', mapping: Mapped("ա") },
    Range { from: 'Բ', to: 'Բ', mapping: Mapped("բ") },
    Range { from: 'Գ', to: 'Գ', mapping: Mapped("գ") },
    Range { from: 'Դ', to: 'Դ', mapping: Mapped("դ") },
    Range { from: 'Ե', to: 'Ե', mapping: Mapped("ե") },
    Range { from: 'Զ', to: 'Զ', mapping: Mapped("զ") },
    Range { from: 'Է', to: 'Է', mapping: Mapped("է") },
    Range { from: 'Ը', to: 'Ը', mapping: Mapped("ը") },
    Range { from: 'Թ', to: 'Թ', mapping: Mapped("թ") },
    Range { from: 'Ժ', to: 'Ժ', mapping: Mapped("ժ") },
    Range { from: 'Ի', to: 'Ի', mapping: Mapped("ի") },
    Range { from: 'Լ', to: 'Լ', mapping: Mapped("լ") },
    Range { from: 'Խ', to: 'Խ', mapping: Mapped("խ") },
    Range { from: 'Ծ', to: 'Ծ', mapping: Mapped("ծ") },
    Range { from: 'Կ', to: 'Կ', mapping: Mapped("կ") },
    Range { from: 'Հ', to: 'Հ', mapping: Mapped("հ") },
    Range { from: 'Ձ', to: 'Ձ', mapping: Mapped("ձ") },
    Range { from: 'Ղ', to: 'Ղ', mapping: Mapped("ղ") },
    Range { from: 'Ճ', to: 'Ճ', mapping: Mapped("ճ") },
    Range { from: 'Մ', to: 'Մ', mapping: Mapped("մ") },
    Range { from: 'Յ', to: 'Յ', mapping: Mapped("յ") },
    Range { from: 'Ն', to: 'Ն', mapping: Mapped("ն") },
    Range { from: 'Շ', to: 'Շ', mapping: Mapped("շ") },
    Range { from: 'Ո', to: 'Ո', mapping: Mapped("ո") },
    Range { from: 'Չ', to: 'Չ', mapping: Mapped("չ") },
    Range { from: 'Պ', to: 'Պ', mapping: Mapped("պ") },
    Range { from: 'Ջ', to: 'Ջ', mapping: Mapped("ջ") },
    Range { from: 'Ռ', to: 'Ռ', mapping: Mapped("ռ") },
    Range { from: 'Ս', to: 'Ս', mapping: Mapped("ս") },
    Range { from: 'Վ', to: 'Վ', mapping: Mapped("վ") },
    Range { from: 'Տ', to: 'Տ', mapping: Mapped("տ") },
    Range { from: 'Ր', to: 'Ր', mapping: Mapped("ր") },
    Range { from: 'Ց', to: 'Ց', mapping: Mapped("ց") },
    Range { from: 'Ւ', to: 'Ւ', mapping: Mapped("ւ") },
    Range { from: 'Փ', to: 'Փ', mapping: Mapped("փ") },
    Range { from: 'Ք', to: 'Ք', mapping: Mapped("ք") },
    Range { from: 'Օ', to: 'Օ', mapping: Mapped("օ") },
    Range { from: 'Ֆ', to: 'Ֆ', mapping: Mapped("ֆ") },
    Range { from: '՗', to: '՘', mapping: Disallowed },
    Range { from: 'ՙ', to: 'ՙ', mapping: Valid },
    Range { from: '՚', to: '՟', mapping: Valid },
    Range { from: 'ՠ', to: 'ՠ', mapping: Disallowed },
    Range { from: 'ա', to: 'ֆ', mapping: Valid },
    Range { from: 'և', to: 'և', mapping: Mapped("եւ") },
    Range { from: 'ֈ', to: 'ֈ', mapping: Disallowed },
    Range { from: '։', to: '։', mapping: Valid },
    Range { from: '֊', to: '֊', mapping: Valid },
    Range { from: '֋', to: '֌', mapping: Disallowed },
    Range { from: '֍', to: '֎', mapping: Valid },
    Range { from: '֏', to: '֏', mapping: Valid },
    Range { from: '֐', to: '֐', mapping: Disallowed },
    Range { from: '֑', to: '֡', mapping: Valid },
    Range { from: '֢', to: '֢', mapping: Valid },
    Range { from: '֣', to: '֯', mapping: Valid },
    Range { from: 'ְ', to: 'ֹ', mapping: Valid },
    Range { from: 'ֺ', to: 'ֺ', mapping: Valid },
    Range { from: 'ֻ', to: 'ֽ', mapping: Valid },
    Range { from: '־', to: '־', mapping: Valid },
    Range { from: 'ֿ', to: 'ֿ', mapping: Valid },
    Range { from: '׀', to: '׀', mapping: Valid },
    Range { from: 'ׁ', to: 'ׂ', mapping: Valid },
    Range { from: '׃', to: '׃', mapping: Valid },
    Range { from: 'ׄ', to: 'ׄ', mapping: Valid },
    Range { from: 'ׅ', to: 'ׅ', mapping: Valid },
    Range { from: '׆', to: '׆', mapping: Valid },
    Range { from: 'ׇ', to: 'ׇ', mapping: Valid },
    Range { from: '׈', to: '׏', mapping: Disallowed },
    Range { from: 'א', to: 'ת', mapping: Valid },
    Range { from: '׫', to: 'ׯ', mapping: Disallowed },
    Range { from: 'װ', to: '״', mapping: Valid },
    Range { from: '׵', to: '׿', mapping: Disallowed },
    Range { from: '؀', to: '؃', mapping: Disallowed },
    Range { from: '؄', to: '؄', mapping: Disallowed },
    Range { from: '؅', to: '؅', mapping: Disallowed },
    Range { from: '؆', to: '؊', mapping: Valid },
    Range { from: '؋', to: '؋', mapping: Valid },
    Range { from: '،', to: '،', mapping: Valid },
    Range { from: '؍', to: '؏', mapping: Valid },
    Range { from: 'ؐ', to: 'ؕ', mapping: Valid },
    Range { from: 'ؖ', to: 'ؚ', mapping: Valid },
    Range { from: '؛', to: '؛', mapping: Valid },
    Range { from: '؜', to: '؜', mapping: Disallowed },
    Range { from: '؝', to: '؝', mapping: Disallowed },
    Range { from: '؞', to: '؞', mapping: Valid },
    Range { from: '؟', to: '؟', mapping: Valid },
    Range { from: 'ؠ', to: 'ؠ', mapping: Valid },
    Range { from: 'ء', to: 'غ', mapping: Valid },
    Range { from: 'ػ', to: 'ؿ', mapping: Valid },
    Range { from: 'ـ', to: 'ـ', mapping: Valid },
    Range { from: 'ف', to: 'ْ', mapping: Valid },
    Range { from: 'ٓ', to: 'ٕ', mapping: Valid },
    Range { from: 'ٖ', to: '٘', mapping: Valid },
    Range { from: 'ٙ', to: 'ٞ', mapping: Valid },
    Range { from: 'ٟ', to: 'ٟ', mapping: Valid },
    Range { from: '٠', to: '٩', mapping: Valid },
    Range { from: '٪', to: '٭', mapping: Valid },
    Range { from: 'ٮ', to: 'ٯ', mapping: Valid },
    Range { from: 'ٰ', to: 'ٴ', mapping: Valid },
    Range { from: 'ٵ', to: 'ٵ', mapping: Mapped("اٴ") },
    Range { from: 'ٶ', to: 'ٶ', mapping: Mapped("وٴ") },
    Range { from: 'ٷ', to: 'ٷ', mapping: Mapped("ۇٴ") },
    Range { from: 'ٸ', to: 'ٸ', mapping: Mapped("يٴ") },
    Range { from: 'ٹ', to: 'ڷ', mapping: Valid },
    Range { from: 'ڸ', to: 'ڹ', mapping: Valid },
    Range { from: 'ں', to: 'ھ', mapping: Valid },
    Range { from: 'ڿ', to: 'ڿ', mapping: Valid },
    Range { from: 'ۀ', to: 'ێ', mapping: Valid },
    Range { from: 'ۏ', to: 'ۏ', mapping: Valid },
    Range { from: 'ې', to: 'ۓ', mapping: Valid },
    Range { from: '۔', to: '۔', mapping: Valid },
    Range { from: 'ە', to: 'ۜ', mapping: Valid },
    Range { from: '۝', to: '۝', mapping: Disallowed },
    Range { from: '۞', to: '۞', mapping: Valid },
    Range { from: '۟', to: 'ۨ', mapping: Valid },
    Range { from: '۩', to: '۩', mapping: Valid },
    Range { from: '۪', to: 'ۭ', mapping: Valid },
    Range { from: 'ۮ', to: 'ۯ', mapping: Valid },
    Range { from: '۰', to: '۹', mapping: Valid },
    Range { from: 'ۺ', to: '۾', mapping: Valid },
    Range { from: 'ۿ', to: 'ۿ', mapping: Valid },
    Range { from: '܀', to: '܍', mapping: Valid },
    Range { from: '܎', to: '܎', mapping: Disallowed },
    Range { from: '܏', to: '܏', mapping: Disallowed },
    Range { from: 'ܐ', to: 'ܬ', mapping: Valid },
    Range { from: 'ܭ', to: 'ܯ', mapping: Valid },
    Range { from: 'ܰ', to: '݊', mapping: Valid },
    Range { from: '݋', to: '݌', mapping: Disallowed },
    Range { from: 'ݍ', to: 'ݏ', mapping: Valid },
    Range { from: 'ݐ', to: 'ݭ', mapping: Valid },
    Range { from: 'ݮ', to: 'ݿ', mapping: Valid },
    Range { from: 'ހ', to: 'ް', mapping: Valid },
    Range { from: 'ޱ', to: 'ޱ', mapping: Valid },
    Range { from: '޲', to: '޿', mapping: Disallowed },
    Range { from: '߀', to: 'ߵ', mapping: Valid },
    Range { from: '߶', to: 'ߺ', mapping: Valid },
    Range { from: '߻', to: '߿', mapping: Disallowed },
    Range { from: 'ࠀ', to: '࠭', mapping: Valid },
    Range { from: '࠮', to: '࠯', mapping: Disallowed },
    Range { from: '࠰', to: '࠾', mapping: Valid },
    Range { from: '࠿', to: '࠿', mapping: Disallowed },
    Range { from: 'ࡀ', to: '࡛', mapping: Valid },
    Range { from: '࡜', to: '࡝', mapping: Disallowed },
    Range { from: '࡞', to: '࡞', mapping: Valid },
    Range { from: '࡟', to: '࢟', mapping: Disallowed },
    Range { from: 'ࢠ', to: 'ࢠ', mapping: Valid },
    Range { from: 'ࢡ', to: 'ࢡ', mapping: Valid },
    Range { from: 'ࢢ', to: 'ࢬ', mapping: Valid },
    Range { from: 'ࢭ', to: 'ࢲ', mapping: Valid },
    Range { from: 'ࢳ', to: 'ࢴ', mapping: Valid },
    Range { from: 'ࢵ', to: '࣢', mapping: Disallowed },
    Range { from: 'ࣣ', to: 'ࣣ', mapping: Valid },
    Range { from: 'ࣤ', to: 'ࣾ', mapping: Valid },
    Range { from: 'ࣿ', to: 'ࣿ', mapping: Valid },
    Range { from: 'ऀ', to: 'ऀ', mapping: Valid },
    Range { from: 'ँ', to: 'ः', mapping: Valid },
    Range { from: 'ऄ', to: 'ऄ', mapping: Valid },
    Range { from: 'अ', to: 'ह', mapping: Valid },
    Range { from: 'ऺ', to: 'ऻ', mapping: Valid },
    Range { from: '़', to: '्', mapping: Valid },
    Range { from: 'ॎ', to: 'ॎ', mapping: Valid },
    Range { from: 'ॏ', to: 'ॏ', mapping: Valid },
    Range { from: 'ॐ', to: '॔', mapping: Valid },
    Range { from: 'ॕ', to: 'ॕ', mapping: Valid },
    Range { from: 'ॖ', to: 'ॗ', mapping: Valid },
    Range { from: 'क़', to: 'क़', mapping: Mapped("क़") },
    Range { from: 'ख़', to: 'ख़', mapping: Mapped("ख़") },
    Range { from: 'ग़', to: 'ग़', mapping: Mapped("ग़") },
    Range { from: 'ज़', to: 'ज़', mapping: Mapped("ज़") },
    Range { from: 'ड़', to: 'ड़', mapping: Mapped("ड़") },
    Range { from: 'ढ़', to: 'ढ़', mapping: Mapped("ढ़") },
    Range { from: 'फ़', to: 'फ़', mapping: Mapped("फ़") },
    Range { from: 'य़', to: 'य़', mapping: Mapped("य़") },
    Range { from: 'ॠ', to: 'ॣ', mapping: Valid },
    Range { from: '।', to: '॥', mapping: Valid },
    Range { from: '०', to: '९', mapping: Valid },
    Range { from: '॰', to: '॰', mapping: Valid },
    Range { from: 'ॱ', to: 'ॲ', mapping: Valid },
    Range { from: 'ॳ', to: 'ॷ', mapping: Valid },
    Range { from: 'ॸ', to: 'ॸ', mapping: Valid },
    Range { from: 'ॹ', to: 'ॺ', mapping: Valid },
    Range { from: 'ॻ', to: 'ॼ', mapping: Valid },
    Range { from: 'ॽ', to: 'ॽ', mapping: Valid },
    Range { from: 'ॾ', to: 'ॿ', mapping: Valid },
    Range { from: 'ঀ', to: 'ঀ', mapping: Valid },
    Range { from: 'ঁ', to: 'ঃ', mapping: Valid },
    Range { from: '঄', to: '঄', mapping: Disallowed },
    Range { from: 'অ', to: 'ঌ', mapping: Valid },
    Range { from: '঍', to: '঎', mapping: Disallowed },
    Range { from: 'এ', to: 'ঐ', mapping: Valid },
    Range { from: '঑', to: '঒', mapping: Disallowed },
    Range { from: 'ও', to: 'ন', mapping: Valid },
    Range { from: '঩', to: '঩', mapping: Disallowed },
    Range { from: 'প', to: 'র', mapping: Valid },
    Range { from: '঱', to: '঱', mapping: Disallowed },
    Range { from: 'ল', to: 'ল', mapping: Valid },
    Range { from: '঳', to: '঵', mapping: Disallowed },
    Range { from: 'শ', to: 'হ', mapping: Valid },
    Range { from: '঺', to: '঻', mapping: Disallowed },
    Range { from: '়', to: '়', mapping: Valid },
    Range { from: 'ঽ', to: 'ঽ', mapping: Valid },
    Range { from: 'া', to: 'ৄ', mapping: Valid },
    Range { from: '৅', to: '৆', mapping: Disallowed },
    Range { from: 'ে', to: 'ৈ', mapping: Valid },
    Range { from: '৉', to: '৊', mapping: Disallowed },
    Range { from: 'ো', to: '্', mapping: Valid },
    Range { from: 'ৎ', to: 'ৎ', mapping: Valid },
    Range { from: '৏', to: '৖', mapping: Disallowed },
    Range { from: 'ৗ', to: 'ৗ', mapping: Valid },
    Range { from: '৘', to: '৛', mapping: Disallowed },
    Range { from: 'ড়', to: 'ড়', mapping: Mapped("ড়") },
    Range { from: 'ঢ়', to: 'ঢ়', mapping: Mapped("ঢ়") },
    Range { from: '৞', to: '৞', mapping: Disallowed },
    Range { from: 'য়', to: 'য়', mapping: Mapped("য়") },
    Range { from: 'ৠ', to: 'ৣ', mapping: Valid },
    Range { from: '৤', to: '৥', mapping: Disallowed },
    Range { from: '০', to: 'ৱ', mapping: Valid },
    Range { from: '৲', to: '৺', mapping: Valid },
    Range { from: '৻', to: '৻', mapping: Valid },
    Range { from: 'ৼ', to: '਀', mapping: Disallowed },
    Range { from: 'ਁ', to: 'ਁ', mapping: Valid },
    Range { from: 'ਂ', to: 'ਂ', mapping: Valid },
    Range { from: 'ਃ', to: 'ਃ', mapping: Valid },
    Range { from: '਄', to: '਄', mapping: Disallowed },
    Range { from: 'ਅ', to: 'ਊ', mapping: Valid },
    Range { from: '਋', to: '਎', mapping: Disallowed },
    Range { from: 'ਏ', to: 'ਐ', mapping: Valid },
    Range { from: '਑', to: '਒', mapping: Disallowed },
    Range { from: 'ਓ', to: 'ਨ', mapping: Valid },
    Range { from: '਩', to: '਩', mapping: Disallowed },
    Range { from: 'ਪ', to: 'ਰ', mapping: Valid },
    Range { from: '਱', to: '਱', mapping: Disallowed },
    Range { from: 'ਲ', to: 'ਲ', mapping: Valid },
    Range { from: 'ਲ਼', to: 'ਲ਼', mapping: Mapped("ਲ਼") },
    Range { from: '਴', to: '਴', mapping: Disallowed },
    Range { from: 'ਵ', to: 'ਵ', mapping: Valid },
    Range { from: 'ਸ਼', to: 'ਸ਼', mapping: Mapped("ਸ਼") },
    Range { from: '਷', to: '਷', mapping: Disallowed },
    Range { from: 'ਸ', to: 'ਹ', mapping: Valid },
    Range { from: '਺', to: '਻', mapping: Disallowed },
    Range { from: '਼', to: '਼', mapping: Valid },
    Range { from: '਽', to: '਽', mapping: Disallowed },
    Range { from: 'ਾ', to: 'ੂ', mapping: Valid },
    Range { from: '੃', to: '੆', mapping: Disallowed },
    Range { from: 'ੇ', to: 'ੈ', mapping: Valid },
    Range { from: '੉', to: '੊', mapping: Disallowed },
    Range { from: 'ੋ', to: '੍', mapping: Valid },
    Range { from: '੎', to: '੐', mapping: Disallowed },
    Range { from: 'ੑ', to: 'ੑ', mapping: Valid },
    Range { from: '੒', to: '੘', mapping: Disallowed },
    Range { from: 'ਖ਼', to: 'ਖ਼', mapping: Mapped("ਖ਼") },
    Range { from: 'ਗ਼', to: 'ਗ਼', mapping: Mapped("ਗ਼") },
    Range { from: 'ਜ਼', to: 'ਜ਼', mapping: Mapped("ਜ਼") },
    Range { from: 'ੜ', to: 'ੜ', mapping: Valid },
    Range { from: '੝', to: '੝', mapping: Disallowed },
    Range { from: 'ਫ਼', to: 'ਫ਼', mapping: Mapped("ਫ਼") },
    Range { from: '੟', to: '੥', mapping: Disallowed },
    Range { from: '੦', to: 'ੴ', mapping: Valid },
    Range { from: 'ੵ', to: 'ੵ', mapping: Valid },
    Range { from: '੶', to: '઀', mapping: Disallowed },
    Range { from: 'ઁ', to: 'ઃ', mapping: Valid },
    Range { from: '઄', to: '઄', mapping: Disallowed },
    Range { from: 'અ', to: 'ઋ', mapping: Valid },
    Range { from: 'ઌ', to: 'ઌ', mapping: Valid },
    Range { from: 'ઍ', to: 'ઍ', mapping: Valid },
    Range { from: '઎', to: '઎', mapping: Disallowed },
    Range { from: 'એ', to: 'ઑ', mapping: Valid },
    Range { from: '઒', to: '઒', mapping: Disallowed },
    Range { from: 'ઓ', to: 'ન', mapping: Valid },
    Range { from: '઩', to: '઩', mapping: Disallowed },
    Range { from: 'પ', to: 'ર', mapping: Valid },
    Range { from: '઱', to: '઱', mapping: Disallowed },
    Range { from: 'લ', to: 'ળ', mapping: Valid },
    Range { from: '઴', to: '઴', mapping: Disallowed },
    Range { from: 'વ', to: 'હ', mapping: Valid },
    Range { from: '઺', to: '઻', mapping: Disallowed },
    Range { from: '઼', to: 'ૅ', mapping: Valid },
    Range { from: '૆', to: '૆', mapping: Disallowed },
    Range { from: 'ે', to: 'ૉ', mapping: Valid },
    Range { from: '૊', to: '૊', mapping: Disallowed },
    Range { from: 'ો', to: '્', mapping: Valid },
    Range { from: '૎', to: '૏', mapping: Disallowed },
    Range { from: 'ૐ', to: 'ૐ', mapping: Valid },
    Range { from: '૑', to: '૟', mapping: Disallowed },
    Range { from: 'ૠ', to: 'ૠ', mapping: Valid },
    Range { from: 'ૡ', to: 'ૣ', mapping: Valid },
    Range { from: '૤', to: '૥', mapping: Disallowed },
    Range { from: '૦', to: '૯', mapping: Valid },
    Range { from: '૰', to: '૰', mapping: Valid },
    Range { from: '૱', to: '૱', mapping: Valid },
    Range { from: '૲', to: '૸', mapping: Disallowed },
    Range { from: 'ૹ', to: 'ૹ', mapping: Valid },
    Range { from: 'ૺ', to: '଀', mapping: Disallowed },
    Range { from: 'ଁ', to: 'ଃ', mapping: Valid },
    Range { from: '଄', to: '଄', mapping: Disallowed },
    Range { from: 'ଅ', to: 'ଌ', mapping: Valid },
    Range { from: '଍', to: '଎', mapping: Disallowed },
    Range { from: 'ଏ', to: 'ଐ', mapping: Valid },
    Range { from: '଑', to: '଒', mapping: Disallowed },
    Range { from: 'ଓ', to: 'ନ', mapping: Valid },
    Range { from: '଩', to: '଩', mapping: Disallowed },
    Range { from: 'ପ', to: 'ର', mapping: Valid },
    Range { from: '଱', to: '଱', mapping: Disallowed },
    Range { from: 'ଲ', to: 'ଳ', mapping: Valid },
    Range { from: '଴', to: '଴', mapping: Disallowed },
    Range { from: 'ଵ', to: 'ଵ', mapping: Valid },
    Range { from: 'ଶ', to: 'ହ', mapping: Valid },
    Range { from: '଺', to: '଻', mapping: Disallowed },
    Range { from: '଼', to: 'ୃ', mapping: Valid },
    Range { from: 'ୄ', to: 'ୄ', mapping: Valid },
    Range { from: '୅', to: '୆', mapping: Disallowed },
    Range { from: 'େ', to: 'ୈ', mapping: Valid },
    Range { from: '୉', to: '୊', mapping: Disallowed },
    Range { from: 'ୋ', to: '୍', mapping: Valid },
    Range { from: '୎', to: '୕', mapping: Disallowed },
    Range { from: 'ୖ', to: 'ୗ', mapping: Valid },
    Range { from: '୘', to: '୛', mapping: Disallowed },
    Range { from: 'ଡ଼', to: 'ଡ଼', mapping: Mapped("ଡ଼") },
    Range { from: 'ଢ଼', to: 'ଢ଼', mapping: Mapped("ଢ଼") },
    Range { from: '୞', to: '୞', mapping: Disallowed },
    Range { from: 'ୟ', to: 'ୡ', mapping: Valid },
    Range { from: 'ୢ', to: 'ୣ', mapping: Valid },
    Range { from: '୤', to: '୥', mapping: Disallowed },
    Range { from: '୦', to: '୯', mapping: Valid },
    Range { from: '୰', to: '୰', mapping: Valid },
    Range { from: 'ୱ', to: 'ୱ', mapping: Valid },
    Range { from: '୲', to: '୷', mapping: Valid },
    Range { from: '୸', to: '஁', mapping: Disallowed },
    Range { from: 'ஂ', to: 'ஃ', mapping: Valid },
    Range { from: '஄', to: '஄', mapping: Disallowed },
    Range { from: 'அ', to: 'ஊ', mapping: Valid },
    Range { from: '஋', to: '஍', mapping: Disallowed },
    Range { from: 'எ', to: 'ஐ', mapping: Valid },
    Range { from: '஑', to: '஑', mapping: Disallowed },
    Range { from: 'ஒ', to: 'க', mapping: Valid },
    Range { from: '஖', to: '஘', mapping: Disallowed },
    Range { from: 'ங', to: 'ச', mapping: Valid },
    Range { from: '஛', to: '஛', mapping: Disallowed },
    Range { from: 'ஜ', to: 'ஜ', mapping: Valid },
    Range { from: '஝', to: '஝', mapping: Disallowed },
    Range { from: 'ஞ', to: 'ட', mapping: Valid },
    Range { from: '஠', to: '஢', mapping: Disallowed },
    Range { from: 'ண', to: 'த', mapping: Valid },
    Range { from: '஥', to: '஧', mapping: Disallowed },
    Range { from: 'ந', to: 'ப', mapping: Valid },
    Range { from: '஫', to: '஭', mapping: Disallowed },
    Range { from: 'ம', to: 'வ', mapping: Valid },
    Range { from: 'ஶ', to: 'ஶ', mapping: Valid },
    Range { from: 'ஷ', to: 'ஹ', mapping: Valid },
    Range { from: '஺', to: '஽', mapping: Disallowed },
    Range { from: 'ா', to: 'ூ', mapping: Valid },
    Range { from: '௃', to: '௅', mapping: Disallowed },
    Range { from: 'ெ', to: 'ை', mapping: Valid },
    Range { from: '௉', to: '௉', mapping: Disallowed },
    Range { from: 'ொ', to: '்', mapping: Valid },
    Range { from: '௎', to: '௏', mapping: Disallowed },
    Range { from: 'ௐ', to: 'ௐ', mapping: Valid },
    Range { from: '௑', to: '௖', mapping: Disallowed },
    Range { from: 'ௗ', to: 'ௗ', mapping: Valid },
    Range { from: '௘', to: '௥', mapping: Disallowed },
    Range { from: '௦', to: '௦', mapping: Valid },
    Range { from: '௧', to: '௯', mapping: Valid },
    Range { from: '௰', to: '௲', mapping: Valid },
    Range { from: '௳', to: '௺', mapping: Valid },
    Range { from: '௻', to: '௿', mapping: Disallowed },
    Range { from: 'ఀ', to: 'ఀ', mapping: Valid },
    Range { from: 'ఁ', to: 'ః', mapping: Valid },
    Range { from: 'ఄ', to: 'ఄ', mapping: Disallowed },
    Range { from: 'అ', to: 'ఌ', mapping: Valid },
    Range { from: '఍', to: '఍', mapping: Disallowed },
    Range { from: 'ఎ', to: 'ఐ', mapping: Valid },
    Range { from: '఑', to: '఑', mapping: Disallowed },
    Range { from: 'ఒ', to: 'న', mapping: Valid },
    Range { from: '఩', to: '఩', mapping: Disallowed },
    Range { from: 'ప', to: 'ళ', mapping: Valid },
    Range { from: 'ఴ', to: 'ఴ', mapping: Valid },
    Range { from: 'వ', to: 'హ', mapping: Valid },
    Range { from: '఺', to: '఼', mapping: Disallowed },
    Range { from: 'ఽ', to: 'ఽ', mapping: Valid },
    Range { from: 'ా', to: 'ౄ', mapping: Valid },
    Range { from: '౅', to: '౅', mapping: Disallowed },
    Range { from: 'ె', to: 'ై', mapping: Valid },
    Range { from: '౉', to: '౉', mapping: Disallowed },
    Range { from: 'ొ', to: '్', mapping: Valid },
    Range { from: '౎', to: '౔', mapping: Disallowed },
    Range { from: 'ౕ', to: 'ౖ', mapping: Valid },
    Range { from: '౗', to: '౗', mapping: Disallowed },
    Range { from: 'ౘ', to: 'ౙ', mapping: Valid },
    Range { from: 'ౚ', to: 'ౚ', mapping: Valid },
    Range { from: '౛', to: '౟', mapping: Disallowed },
    Range { from: 'ౠ', to: 'ౡ', mapping: Valid },
    Range { from: 'ౢ', to: 'ౣ', mapping: Valid },
    Range { from: '౤', to: '౥', mapping: Disallowed },
    Range { from: '౦', to: '౯', mapping: Valid },
    Range { from: '౰', to: '౷', mapping: Disallowed },
    Range { from: '౸', to: '౿', mapping: Valid },
    Range { from: 'ಀ', to: 'ಀ', mapping: Disallowed },
    Range { from: 'ಁ', to: 'ಁ', mapping: Valid },
    Range { from: 'ಂ', to: 'ಃ', mapping: Valid },
    Range { from: '಄', to: '಄', mapping: Disallowed },
    Range { from: 'ಅ', to: 'ಌ', mapping: Valid },
    Range { from: '಍', to: '಍', mapping: Disallowed },
    Range { from: 'ಎ', to: 'ಐ', mapping: Valid },
    Range { from: '಑', to: '಑', mapping: Disallowed },
    Range { from: 'ಒ', to: 'ನ', mapping: Valid },
    Range { from: '಩', to: '಩', mapping: Disallowed },
    Range { from: 'ಪ', to: 'ಳ', mapping: Valid },
    Range { from: '಴', to: '಴', mapping: Disallowed },
    Range { from: 'ವ', to: 'ಹ', mapping: Valid },
    Range { from: '಺', to: '಻', mapping: Disallowed },
    Range { from: '಼', to: 'ಽ', mapping: Valid },
    Range { from: 'ಾ', to: 'ೄ', mapping: Valid },
    Range { from: '೅', to: '೅', mapping: Disallowed },
    Range { from: 'ೆ', to: 'ೈ', mapping: Valid },
    Range { from: '೉', to: '೉', mapping: Disallowed },
    Range { from: 'ೊ', to: '್', mapping: Valid },
    Range { from: '೎', to: '೔', mapping: Disallowed },
    Range { from: 'ೕ', to: 'ೖ', mapping: Valid },
    Range { from: '೗', to: 'ೝ', mapping: Disallowed },
    Range { from: 'ೞ', to: 'ೞ', mapping: Valid },
    Range { from: '೟', to: '೟', mapping: Disallowed },
    Range { from: 'ೠ', to: 'ೡ', mapping: Valid },
    Range { from: 'ೢ', to: 'ೣ', mapping: Valid },
    Range { from: '೤', to: '೥', mapping: Disallowed },
    Range { from: '೦', to: '೯', mapping: Valid },
    Range { from: '೰', to: '೰', mapping: Disallowed },
    Range { from: 'ೱ', to: 'ೲ', mapping: Valid },
    Range { from: 'ೳ', to: 'ഀ', mapping: Disallowed },
    Range { from: 'ഁ', to: 'ഁ', mapping: Valid },
    Range { from: 'ം', to: 'ഃ', mapping: Valid },
    Range { from: 'ഄ', to: 'ഄ', mapping: Disallowed },
    Range { from: 'അ', to: 'ഌ', mapping: Valid },
    Range { from: '഍', to: '഍', mapping: Disallowed },
    Range { from: 'എ', to: 'ഐ', mapping: Valid },
    Range { from: '഑', to: '഑', mapping: Disallowed },
    Range { from: 'ഒ', to: 'ന', mapping: Valid },
    Range { from: 'ഩ', to: 'ഩ', mapping: Valid },
    Range { from: 'പ', to: 'ഹ', mapping: Valid },
    Range { from: 'ഺ', to: 'ഺ', mapping: Valid },
    Range { from: '഻', to: '഼', mapping: Disallowed },
    Range { from: 'ഽ', to: 'ഽ', mapping: Valid },
    Range { from: 'ാ', to: 'ൃ', mapping: Valid },
    Range { from: 'ൄ', to: 'ൄ', mapping: Valid },
    Range { from: '൅', to: '൅', mapping: Disallowed },
    Range { from: 'െ', to: 'ൈ', mapping: Valid },
    Range { from: '൉', to: '൉', mapping: Disallowed },
    Range { from: 'ൊ', to: '്', mapping: Valid },
    Range { from: 'ൎ', to: 'ൎ', mapping: Valid },
    Range { from: '൏', to: 'ൖ', mapping: Disallowed },
    Range { from: 'ൗ', to: 'ൗ', mapping: Valid },
    Range { from: '൘', to: '൞', mapping: Disallowed },
    Range { from: 'ൟ', to: 'ൟ', mapping: Valid },
    Range { from: 'ൠ', to: 'ൡ', mapping: Valid },
    Range { from: 'ൢ', to: 'ൣ', mapping: Valid },
    Range { from: '൤', to: '൥', mapping: Disallowed },
    Range { from: '൦', to: '൯', mapping: Valid },
    Range { from: '൰', to: '൵', mapping: Valid },
    Range { from: '൶', to: '൸', mapping: Disallowed },
    Range { from: '൹', to: '൹', mapping: Valid },
    Range { from: 'ൺ', to: 'ൿ', mapping: Valid },
    Range { from: '඀', to: 'ඁ', mapping: Disallowed },
    Range { from: 'ං', to: 'ඃ', mapping: Valid },
    Range { from: '඄', to: '඄', mapping: Disallowed },
    Range { from: 'අ', to: 'ඖ', mapping: Valid },
    Range { from: '඗', to: '඙', mapping: Disallowed },
    Range { from: 'ක', to: 'න', mapping: Valid },
    Range { from: '඲', to: '඲', mapping: Disallowed },
    Range { from: 'ඳ', to: 'ර', mapping: Valid },
    Range { from: '඼', to: '඼', mapping: Disallowed },
    Range { from: 'ල', to: 'ල', mapping: Valid },
    Range { from: '඾', to: '඿', mapping: Disallowed },
    Range { from: 'ව', to: 'ෆ', mapping: Valid },
    Range { from: '෇', to: '෉', mapping: Disallowed },
    Range { from: '්', to: '්', mapping: Valid },
    Range { from: '෋', to: '෎', mapping: Disallowed },
    Range { from: 'ා', to: 'ු', mapping: Valid },
    Range { from: '෕', to: '෕', mapping: Disallowed },
    Range { from: 'ූ', to: 'ූ', mapping: Valid },
    Range { from: '෗', to: '෗', mapping: Disallowed },
    Range { from: 'ෘ', to: 'ෟ', mapping: Valid },
    Range { from: '෠', to: '෥', mapping: Disallowed },
    Range { from: '෦', to: '෯', mapping: Valid },
    Range { from: '෰', to: '෱', mapping: Disallowed },
    Range { from: 'ෲ', to: 'ෳ', mapping: Valid },
    Range { from: '෴', to: '෴', mapping: Valid },
    Range { from: '෵', to: '฀', mapping: Disallowed },
    Range { from: 'ก', to: 'า', mapping: Valid },
    Range { from: 'ำ', to: 'ำ', mapping: Mapped("ํา") },
    Range { from: 'ิ', to: 'ฺ', mapping: Valid },
    Range { from: '฻', to: '฾', mapping: Disallowed },
    Range { from: '฿', to: '฿', mapping: Valid },
    Range { from: 'เ', to: '๎', mapping: Valid },
    Range { from: '๏', to: '๏', mapping: Valid },
    Range { from: '๐', to: '๙', mapping: Valid },
    Range { from: '๚', to: '๛', mapping: Valid },
    Range { from: '๜', to: '຀', mapping: Disallowed },
    Range { from: 'ກ', to: 'ຂ', mapping: Valid },
    Range { from: '຃', to: '຃', mapping: Disallowed },
    Range { from: 'ຄ', to: 'ຄ', mapping: Valid },
    Range { from: '຅', to: 'ຆ', mapping: Disallowed },
    Range { from: 'ງ', to: 'ຈ', mapping: Valid },
    Range { from: 'ຉ', to: 'ຉ', mapping: Disallowed },
    Range { from: 'ຊ', to: 'ຊ', mapping: Valid },
    Range { from: '຋', to: 'ຌ', mapping: Disallowed },
    Range { from: 'ຍ', to: 'ຍ', mapping: Valid },
    Range { from: 'ຎ', to: 'ຓ', mapping: Disallowed },
    Range { from: 'ດ', to: 'ທ', mapping: Valid },
    Range { from: 'ຘ', to: 'ຘ', mapping: Disallowed },
    Range { from: 'ນ', to: 'ຟ', mapping: Valid },
    Range { from: 'ຠ', to: 'ຠ', mapping: Disallowed },
    Range { from: 'ມ', to: 'ຣ', mapping: Valid },
    Range { from: '຤', to: '຤', mapping: Disallowed },
    Range { from: 'ລ', to: 'ລ', mapping: Valid },
    Range { from: '຦', to: '຦', mapping: Disallowed },
    Range { from: 'ວ', to: 'ວ', mapping: Valid },
    Range { from: 'ຨ', to: 'ຩ', mapping: Disallowed },
    Range { from: 'ສ', to: 'ຫ', mapping: Valid },
    Range { from: 'ຬ', to: 'ຬ', mapping: Disallowed },
    Range { from: 'ອ', to: 'າ', mapping: Valid },
    Range { from: 'ຳ', to: 'ຳ', mapping: Mapped("ໍາ") },
    Range { from: 'ິ', to: 'ູ', mapping: Valid },
    Range { from: '຺', to: '຺', mapping: Disallowed },
    Range { from: 'ົ', to: 'ຽ', mapping: Valid },
    Range { from: '຾', to: '຿', mapping: Disallowed },
    Range { from: 'ເ', to: 'ໄ', mapping: Valid },
    Range { from: '໅', to: '໅', mapping: Disallowed },
    Range { from: 'ໆ', to: 'ໆ', mapping: Valid },
    Range { from: '໇', to: '໇', mapping: Disallowed },
    Range { from: '່', to: 'ໍ', mapping: Valid },
    Range { from: '໎', to: '໏', mapping: Disallowed },
    Range { from: '໐', to: '໙', mapping: Valid },
    Range { from: '໚', to: '໛', mapping: Disallowed },
    Range { from: 'ໜ', to: 'ໜ', mapping: Mapped("ຫນ") },
    Range { from: 'ໝ', to: 'ໝ', mapping: Mapped("ຫມ") },
    Range { from: 'ໞ', to: 'ໟ', mapping: Valid },
    Range { from: '໠', to: '໿', mapping: Disallowed },
    Range { from: 'ༀ', to: 'ༀ', mapping: Valid },
    Range { from: '༁', to: '༊', mapping: Valid },
    Range { from: '་', to: '་', mapping: Valid },
    Range { from: '༌', to: '༌', mapping: Mapped("་") },
    Range { from: '།', to: '༗', mapping: Valid },
    Range { from: '༘', to: '༙', mapping: Valid },
    Range { from: '༚', to: '༟', mapping: Valid },
    Range { from: '༠', to: '༩', mapping: Valid },
    Range { from: '༪', to: '༴', mapping: Valid },
    Range { from: '༵', to: '༵', mapping: Valid },
    Range { from: '༶', to: '༶', mapping: Valid },
    Range { from: '༷', to: '༷', mapping: Valid },
    Range { from: '༸', to: '༸', mapping: Valid },
    Range { from: '༹', to: '༹', mapping: Valid },
    Range { from: '༺', to: '༽', mapping: Valid },
    Range { from: '༾', to: 'ག', mapping: Valid },
    Range { from: 'གྷ', to: 'གྷ', mapping: Mapped("གྷ") },
    Range { from: 'ང', to: 'ཇ', mapping: Valid },
    Range { from: '཈', to: '཈', mapping: Disallowed },
    Range { from: 'ཉ', to: 'ཌ', mapping: Valid },
    Range { from: 'ཌྷ', to: 'ཌྷ', mapping: Mapped("ཌྷ") },
    Range { from: 'ཎ', to: 'ད', mapping: Valid },
    Range { from: 'དྷ', to: 'དྷ', mapping: Mapped("དྷ") },
    Range { from: 'ན', to: 'བ', mapping: Valid },
    Range { from: 'བྷ', to: 'བྷ', mapping: Mapped("བྷ") },
    Range { from: 'མ', to: 'ཛ', mapping: Valid },
    Range { from: 'ཛྷ', to: 'ཛྷ', mapping: Mapped("ཛྷ") },
    Range { from: 'ཝ', to: 'ཨ', mapping: Valid },
    Range { from: 'ཀྵ', to: 'ཀྵ', mapping: Mapped("ཀྵ") },
    Range { from: 'ཪ', to: 'ཪ', mapping: Valid },
    Range { from: 'ཫ', to: 'ཬ', mapping: Valid },
    Range { from: '཭', to: '཰', mapping: Disallowed },
    Range { from: 'ཱ', to: 'ི', mapping: Valid },
    Range { from: 'ཱི', to: 'ཱི', mapping: Mapped("ཱི") },
    Range { from: 'ུ', to: 'ུ', mapping: Valid },
    Range { from: 'ཱུ', to: 'ཱུ', mapping: Mapped("ཱུ") },
    Range { from: 'ྲྀ', to: 'ྲྀ', mapping: Mapped("ྲྀ") },
    Range { from: 'ཷ', to: 'ཷ', mapping: Mapped("ྲཱྀ") },
    Range { from: 'ླྀ', to: 'ླྀ', mapping: Mapped("ླྀ") },
    Range { from: 'ཹ', to: 'ཹ', mapping: Mapped("ླཱྀ") },
    Range { from: 'ེ', to: 'ྀ', mapping: Valid },
    Range { from: 'ཱྀ', to: 'ཱྀ', mapping: Mapped("ཱྀ") },
    Range { from: 'ྂ', to: '྄', mapping: Valid },
    Range { from: '྅', to: '྅', mapping: Valid },
    Range { from: '྆', to: 'ྋ', mapping: Valid },
    Range { from: 'ྌ', to: 'ྏ', mapping: Valid },
    Range { from: 'ྐ', to: 'ྒ', mapping: Valid },
    Range { from: 'ྒྷ', to: 'ྒྷ', mapping: Mapped("ྒྷ") },
    Range { from: 'ྔ', to: 'ྕ', mapping: Valid },
    Range { from: 'ྖ', to: 'ྖ', mapping: Valid },
    Range { from: 'ྗ', to: 'ྗ', mapping: Valid },
    Range { from: '྘', to: '྘', mapping: Disallowed },
    Range { from: 'ྙ', to: 'ྜ', mapping: Valid },
    Range { from: 'ྜྷ', to: 'ྜྷ', mapping: Mapped("ྜྷ") },
    Range { from: 'ྞ', to: 'ྡ', mapping: Valid },
    Range { from: 'ྡྷ', to: 'ྡྷ', mapping: Mapped("ྡྷ") },
    Range { from: 'ྣ', to: 'ྦ', mapping: Valid },
    Range { from: 'ྦྷ', to: 'ྦྷ', mapping: Mapped("ྦྷ") },
    Range { from: 'ྨ', to: 'ྫ', mapping: Valid },
    Range { from: 'ྫྷ', to: 'ྫྷ', mapping: Mapped("ྫྷ") },
    Range { from: 'ྭ', to: 'ྭ', mapping: Valid },
    Range { from: 'ྮ', to: 'ྰ', mapping: Valid },
    Range { from: 'ྱ', to: 'ྷ', mapping: Valid },
    Range { from: 'ྸ', to: 'ྸ', mapping: Valid },
    Range { from: 'ྐྵ', to: 'ྐྵ', mapping: Mapped("ྐྵ") },
    Range { from: 'ྺ', to: 'ྼ', mapping: Valid },
    Range { from: '྽', to: '྽', mapping: Disallowed },
    Range { from: '྾', to: '࿅', mapping: Valid },
    Range { from: '࿆', to: '࿆', mapping: Valid },
    Range { from: '࿇', to: '࿌', mapping: Valid },
    Range { from: '࿍', to: '࿍', mapping: Disallowed },
    Range { from: '࿎', to: '࿎', mapping: Valid },
    Range { from: '࿏', to: '࿏', mapping: Valid },
    Range { from: '࿐', to: '࿑', mapping: Valid },
    Range { from: '࿒', to: '࿔', mapping: Valid },
    Range { from: '࿕', to: '࿘', mapping: Valid },
    Range { from: '࿙', to: '࿚', mapping: Valid },
    Range { from: '࿛', to: '࿿', mapping: Disallowed },
    Range { from: 'က', to: 'အ', mapping: Valid },
    Range { from: 'ဢ', to: 'ဢ', mapping: Valid },
    Range { from: 'ဣ', to: 'ဧ', mapping: Valid },
    Range { from: 'ဨ', to: 'ဨ', mapping: Valid },
    Range { from: 'ဩ', to: 'ဪ', mapping: Valid },
    Range { from: 'ါ', to: 'ါ', mapping: Valid },
    Range { from: 'ာ', to: 'ဲ', mapping: Valid },
    Range { from: 'ဳ', to: 'ဵ', mapping: Valid },
    Range { from: 'ံ', to: '္', mapping: Valid },
    Range { from: '်', to: 'ဿ', mapping: Valid },
    Range { from: '၀', to: '၉', mapping: Valid },
    Range { from: '၊', to: '၏', mapping: Valid },
    Range { from: 'ၐ', to: 'ၙ', mapping: Valid },
    Range { from: 'ၚ', to: '႙', mapping: Valid },
    Range { from: 'ႚ', to: 'ႝ', mapping: Valid },
    Range { from: '႞', to: '႟', mapping: Valid },
    Range { from: 'Ⴀ', to: 'Ⴥ', mapping: Disallowed },
    Range { from: '჆', to: '჆', mapping: Disallowed },
    Range { from: 'Ⴧ', to: 'Ⴧ', mapping: Mapped("ⴧ") },
    Range { from: '჈', to: '჌', mapping: Disallowed },
    Range { from: 'Ⴭ', to: 'Ⴭ', mapping: Mapped("ⴭ") },
    Range { from: '჎', to: '჏', mapping: Disallowed },
    Range { from: 'ა', to: 'ჶ', mapping: Valid },
    Range { from: 'ჷ', to: 'ჸ', mapping: Valid },
    Range { from: 'ჹ', to: 'ჺ', mapping: Valid },
    Range { from: '჻', to: '჻', mapping: Valid },
    Range { from: 'ჼ', to: 'ჼ', mapping: Mapped("ნ") },
    Range { from: 'ჽ', to: 'ჿ', mapping: Valid },
    Range { from: 'ᄀ', to: 'ᅙ', mapping: Valid },
    Range { from: 'ᅚ', to: 'ᅞ', mapping: Valid },
    Range { from: 'ᅟ', to: 'ᅠ', mapping: Disallowed },
    Range { from: 'ᅡ', to: 'ᆢ', mapping: Valid },
    Range { from: 'ᆣ', to: 'ᆧ', mapping: Valid },
    Range { from: 'ᆨ', to: 'ᇹ', mapping: Valid },
    Range { from: 'ᇺ', to: 'ᇿ', mapping: Valid },
    Range { from: 'ሀ', to: 'ሆ', mapping: Valid },
    Range { from: 'ሇ', to: 'ሇ', mapping: Valid },
    Range { from: 'ለ', to: 'ቆ', mapping: Valid },
    Range { from: 'ቇ', to: 'ቇ', mapping: Valid },
    Range { from: 'ቈ', to: 'ቈ', mapping: Valid },
    Range { from: '቉', to: '቉', mapping: Disallowed },
    Range { from: 'ቊ', to: 'ቍ', mapping: Valid },
    Range { from: '቎', to: '቏', mapping: Disallowed },
    Range { from: 'ቐ', to: 'ቖ', mapping: Valid },
    Range { from: '቗', to: '቗', mapping: Disallowed },
    Range { from: 'ቘ', to: 'ቘ', mapping: Valid },
    Range { from: '቙', to: '቙', mapping: Disallowed },
    Range { from: 'ቚ', to: 'ቝ', mapping: Valid },
    Range { from: '቞', to: '቟', mapping: Disallowed },
    Range { from: 'በ', to: 'ኆ', mapping: Valid },
    Range { from: 'ኇ', to: 'ኇ', mapping: Valid },
    Range { from: 'ኈ', to: 'ኈ', mapping: Valid },
    Range { from: '኉', to: '኉', mapping: Disallowed },
    Range { from: 'ኊ', to: 'ኍ', mapping: Valid },
    Range { from: '኎', to: '኏', mapping: Disallowed },
    Range { from: 'ነ', to: 'ኮ', mapping: Valid },
    Range { from: 'ኯ', to: 'ኯ', mapping: Valid },
    Range { from: 'ኰ', to: 'ኰ', mapping: Valid },
    Range { from: '኱', to: '኱', mapping: Disallowed },
    Range { from: 'ኲ', to: 'ኵ', mapping: Valid },
    Range { from: '኶', to: '኷', mapping: Disallowed },
    Range { from: 'ኸ', to: 'ኾ', mapping: Valid },
    Range { from: '኿', to: '኿', mapping: Disallowed },
    Range { from: 'ዀ', to: 'ዀ', mapping: Valid },
    Range { from: '዁', to: '዁', mapping: Disallowed },
    Range { from: 'ዂ', to: 'ዅ', mapping: Valid },
    Range { from: '዆', to: '዇', mapping: Disallowed },
    Range { from: 'ወ', to: 'ዎ', mapping: Valid },
    Range { from: 'ዏ', to: 'ዏ', mapping: Valid },
    Range { from: 'ዐ', to: 'ዖ', mapping: Valid },
    Range { from: '዗', to: '዗', mapping: Disallowed },
    Range { from: 'ዘ', to: 'ዮ', mapping: Valid },
    Range { from: 'ዯ', to: 'ዯ', mapping: Valid },
    Range { from: 'ደ', to: 'ጎ', mapping: Valid },
    Range { from: 'ጏ', to: 'ጏ', mapping: Valid },
    Range { from: 'ጐ', to: 'ጐ', mapping: Valid },
    Range { from: '጑', to: '጑', mapping: Disallowed },
    Range { from: 'ጒ', to: 'ጕ', mapping: Valid },
    Range { from: '጖', to: '጗', mapping: Disallowed },
    Range { from: 'ጘ', to: 'ጞ', mapping: Valid },
    Range { from: 'ጟ', to: 'ጟ', mapping: Valid },
    Range { from: 'ጠ', to: 'ፆ', mapping: Valid },
    Range { from: 'ፇ', to: 'ፇ', mapping: Valid },
    Range { from: 'ፈ', to: 'ፚ', mapping: Valid },
    Range { from: '፛', to: '፜', mapping: Disallowed },
    Range { from: '፝', to: '፞', mapping: Valid },
    Range { from: '፟', to: '፟', mapping: Valid },
    Range { from: '፠', to: '፠', mapping: Valid },
    Range { from: '፡', to: '፼', mapping: Valid },
    Range { from: '፽', to: '፿', mapping: Disallowed },
    Range { from: 'ᎀ', to: 'ᎏ', mapping: Valid },
    Range { from: '᎐', to: '᎙', mapping: Valid },
    Range { from: '᎚', to: '᎟', mapping: Disallowed },
    Range { from: 'Ꭰ', to: 'Ᏼ', mapping: Valid },
    Range { from: 'Ᏽ', to: 'Ᏽ', mapping: Valid },
    Range { from: '᏶', to: '᏷', mapping: Disallowed },
    Range { from: 'ᏸ', to: 'ᏸ', mapping: Mapped("Ᏸ") },
    Range { from: 'ᏹ', to: 'ᏹ', mapping: Mapped("Ᏹ") },
    Range { from: 'ᏺ', to: 'ᏺ', mapping: Mapped("Ᏺ") },
    Range { from: 'ᏻ', to: 'ᏻ', mapping: Mapped("Ᏻ") },
    Range { from: 'ᏼ', to: 'ᏼ', mapping: Mapped("Ᏼ") },
    Range { from: 'ᏽ', to: 'ᏽ', mapping: Mapped("Ᏽ") },
    Range { from: '᏾', to: '᏿', mapping: Disallowed },
    Range { from: '᐀', to: '᐀', mapping: Valid },
    Range { from: 'ᐁ', to: 'ᙬ', mapping: Valid },
    Range { from: '᙭', to: '᙮', mapping: Valid },
    Range { from: 'ᙯ', to: 'ᙶ', mapping: Valid },
    Range { from: 'ᙷ', to: 'ᙿ', mapping: Valid },
    Range { from: ' ', to: ' ', mapping: Disallowed },
    Range { from: 'ᚁ', to: 'ᚚ', mapping: Valid },
    Range { from: '᚛', to: '᚜', mapping: Valid },
    Range { from: '᚝', to: '᚟', mapping: Disallowed },
    Range { from: 'ᚠ', to: 'ᛪ', mapping: Valid },
    Range { from: '᛫', to: 'ᛰ', mapping: Valid },
    Range { from: 'ᛱ', to: 'ᛸ', mapping: Valid },
    Range { from: '᛹', to: '᛿', mapping: Disallowed },
    Range { from: 'ᜀ', to: 'ᜌ', mapping: Valid },
    Range { from: 'ᜍ', to: 'ᜍ', mapping: Disallowed },
    Range { from: 'ᜎ', to: '᜔', mapping: Valid },
    Range { from: '᜕', to: 'ᜟ', mapping: Disallowed },
    Range { from: 'ᜠ', to: '᜴', mapping: Valid },
    Range { from: '᜵', to: '᜶', mapping: Valid },
    Range { from: '᜷', to: '᜿', mapping: Disallowed },
    Range { from: 'ᝀ', to: 'ᝓ', mapping: Valid },
    Range { from: '᝔', to: '᝟', mapping: Disallowed },
    Range { from: 'ᝠ', to: 'ᝬ', mapping: Valid },
    Range { from: '᝭', to: '᝭', mapping: Disallowed },
    Range { from: 'ᝮ', to: 'ᝰ', mapping: Valid },
    Range { from: '᝱', to: '᝱', mapping: Disallowed },
    Range { from: 'ᝲ', to: 'ᝳ', mapping: Valid },
    Range { from: '᝴', to: '᝿', mapping: Disallowed },
    Range { from: 'ក', to: 'ឳ', mapping: Valid },
    Range { from: '឴', to: '឵', mapping: Disallowed },
    Range { from: 'ា', to: '៓', mapping: Valid },
    Range { from: '។', to: '៖', mapping: Valid },
    Range { from: 'ៗ', to: 'ៗ', mapping: Valid },
    Range { from: '៘', to: '៛', mapping: Valid },
    Range { from: 'ៜ', to: 'ៜ', mapping: Valid },
    Range { from: '៝', to: '៝', mapping: Valid },
    Range { from: '៞', to: '៟', mapping: Disallowed },
    Range { from: '០', to: '៩', mapping: Valid },
    Range { from: '៪', to: '៯', mapping: Disallowed },
    Range { from: '៰', to: '៹', mapping: Valid },
    Range { from: '៺', to: '៿', mapping: Disallowed },
    Range { from: '᠀', to: '᠅', mapping: Valid },
    Range { from: '᠆', to: '᠆', mapping: Disallowed },
    Range { from: '᠇', to: '᠊', mapping: Valid },
    Range { from: '᠋', to: '᠍', mapping: Ignored },
    Range { from: '᠎', to: '᠎', mapping: Disallowed },
    Range { from: '᠏', to: '᠏', mapping: Disallowed },
    Range { from: '᠐', to: '᠙', mapping: Valid },
    Range { from: '᠚', to: '᠟', mapping: Disallowed },
    Range { from: 'ᠠ', to: 'ᡷ', mapping: Valid },
    Range { from: 'ᡸ', to: '᡿', mapping: Disallowed },
    Range { from: 'ᢀ', to: 'ᢩ', mapping: Valid },
    Range { from: 'ᢪ', to: 'ᢪ', mapping: Valid },
    Range { from: '᢫', to: '᢯', mapping: Disallowed },
    Range { from: 'ᢰ', to: 'ᣵ', mapping: Valid },
    Range { from: '᣶', to: '᣿', mapping: Disallowed },
    Range { from: 'ᤀ', to: 'ᤜ', mapping: Valid },
    Range { from: 'ᤝ', to: 'ᤞ', mapping: Valid },
    Range { from: '᤟', to: '᤟', mapping: Disallowed },
    Range { from: 'ᤠ', to: 'ᤫ', mapping: Valid },
    Range { from: '᤬', to: '᤯', mapping: Disallowed },
    Range { from: 'ᤰ', to: '᤻', mapping: Valid },
    Range { from: '᤼', to: '᤿', mapping: Disallowed },
    Range { from: '᥀', to: '᥀', mapping: Valid },
    Range { from: '᥁', to: '᥃', mapping: Disallowed },
    Range { from: '᥄', to: '᥅', mapping: Valid },
    Range { from: '᥆', to: 'ᥭ', mapping: Valid },
    Range { from: '᥮', to: '᥯', mapping: Disallowed },
    Range { from: 'ᥰ', to: 'ᥴ', mapping: Valid },
    Range { from: '᥵', to: '᥿', mapping: Disallowed },
    Range { from: 'ᦀ', to: 'ᦩ', mapping: Valid },
    Range { from: 'ᦪ', to: 'ᦫ', mapping: Valid },
    Range { from: '᦬', to: '᦯', mapping: Disallowed },
    Range { from: 'ᦰ', to: 'ᧉ', mapping: Valid },
    Range { from: '᧊', to: '᧏', mapping: Disallowed },
    Range { from: '᧐', to: '᧙', mapping: Valid },
    Range { from: '᧚', to: '᧚', mapping: Valid },
    Range { from: '᧛', to: '᧝', mapping: Disallowed },
    Range { from: '᧞', to: '᧟', mapping: Valid },
    Range { from: '᧠', to: '᧿', mapping: Valid },
    Range { from: 'ᨀ', to: 'ᨛ', mapping: Valid },
    Range { from: '᨜', to: '᨝', mapping: Disallowed },
    Range { from: '᨞', to: '᨟', mapping: Valid },
    Range { from: 'ᨠ', to: 'ᩞ', mapping: Valid },
    Range { from: '᩟', to: '᩟', mapping: Disallowed },
    Range { from: '᩠', to: '᩼', mapping: Valid },
    Range { from: '᩽', to: '᩾', mapping: Disallowed },
    Range { from: '᩿', to: '᪉', mapping: Valid },
    Range { from: '᪊', to: '᪏', mapping: Disallowed },
    Range { from: '᪐', to: '᪙', mapping: Valid },
    Range { from: '᪚', to: '᪟', mapping: Disallowed },
    Range { from: '᪠', to: '᪦', mapping: Valid },
    Range { from: 'ᪧ', to: 'ᪧ', mapping: Valid },
    Range { from: '᪨', to: '᪭', mapping: Valid },
    Range { from: '᪮', to: '᪯', mapping: Disallowed },
    Range { from: '᪰', to: '᪽', mapping: Valid },
    Range { from: '᪾', to: '᪾', mapping: Valid },
    Range { from: 'ᪿ', to: '᫿', mapping: Disallowed },
    Range { from: 'ᬀ', to: 'ᭋ', mapping: Valid },
    Range { from: 'ᭌ', to: '᭏', mapping: Disallowed },
    Range { from: '᭐', to: '᭙', mapping: Valid },
    Range { from: '᭚', to: '᭪', mapping: Valid },
    Range { from: '᭫', to: '᭳', mapping: Valid },
    Range { from: '᭴', to: '᭼', mapping: Valid },
    Range { from: '᭽', to: '᭿', mapping: Disallowed },
    Range { from: 'ᮀ', to: '᮪', mapping: Valid },
    Range { from: '᮫', to: 'ᮭ', mapping: Valid },
    Range { from: 'ᮮ', to: '᮹', mapping: Valid },
    Range { from: 'ᮺ', to: 'ᮿ', mapping: Valid },
    Range { from: 'ᯀ', to: '᯳', mapping: Valid },
    Range { from: '᯴', to: '᯻', mapping: Disallowed },
    Range { from: '᯼', to: '᯿', mapping: Valid },
    Range { from: 'ᰀ', to: '᰷', mapping: Valid },
    Range { from: '᰸', to: '᰺', mapping: Disallowed },
    Range { from: '᰻', to: '᰿', mapping: Valid },
    Range { from: '᱀', to: '᱉', mapping: Valid },
    Range { from: '᱊', to: '᱌', mapping: Disallowed },
    Range { from: 'ᱍ', to: 'ᱽ', mapping: Valid },
    Range { from: '᱾', to: '᱿', mapping: Valid },
    Range { from: 'ᲀ', to: 'Ჿ', mapping: Disallowed },
    Range { from: '᳀', to: '᳇', mapping: Valid },
    Range { from: '᳈', to: '᳏', mapping: Disallowed },
    Range { from: '᳐', to: '᳒', mapping: Valid },
    Range { from: '᳓', to: '᳓', mapping: Valid },
    Range { from: '᳔', to: 'ᳲ', mapping: Valid },
    Range { from: 'ᳳ', to: 'ᳶ', mapping: Valid },
    Range { from: '᳷', to: '᳷', mapping: Disallowed },
    Range { from: '᳸', to: '᳹', mapping: Valid },
    Range { from: 'ᳺ', to: '᳿', mapping: Disallowed },
    Range { from: 'ᴀ', to: 'ᴫ', mapping: Valid },
    Range { from: 'ᴬ', to: 'ᴬ', mapping: Mapped("a") },
    Range { from: 'ᴭ', to: 'ᴭ', mapping: Mapped("æ") },
    Range { from: 'ᴮ', to: 'ᴮ', mapping: Mapped("b") },
    Range { from: 'ᴯ', to: 'ᴯ', mapping: Valid },
    Range { from: 'ᴰ', to: 'ᴰ', mapping: Mapped("d") },
    Range { from: 'ᴱ', to: 'ᴱ', mapping: Mapped("e") },
    Range { from: 'ᴲ', to: 'ᴲ', mapping: Mapped("ǝ") },
    Range { from: 'ᴳ', to: 'ᴳ', mapping: Mapped("g") },
    Range { from: 'ᴴ', to: 'ᴴ', mapping: Mapped("h") },
    Range { from: 'ᴵ', to: 'ᴵ', mapping: Mapped("i") },
    Range { from: 'ᴶ', to: 'ᴶ', mapping: Mapped("j") },
    Range { from: 'ᴷ', to: 'ᴷ', mapping: Mapped("k") },
    Range { from: 'ᴸ', to: 'ᴸ', mapping: Mapped("l") },
    Range { from: 'ᴹ', to: 'ᴹ', mapping: Mapped("m") },
    Range { from: 'ᴺ', to: 'ᴺ', mapping: Mapped("n") },
    Range { from: 'ᴻ', to: 'ᴻ', mapping: Valid },
    Range { from: 'ᴼ', to: 'ᴼ', mapping: Mapped("o") },
    Range { from: 'ᴽ', to: 'ᴽ', mapping: Mapped("ȣ") },
    Range { from: 'ᴾ', to: 'ᴾ', mapping: Mapped("p") },
    Range { from: 'ᴿ', to: 'ᴿ', mapping: Mapped("r") },
    Range { from: 'ᵀ', to: 'ᵀ', mapping: Mapped("t") },
    Range { from: 'ᵁ', to: 'ᵁ', mapping: Mapped("u") },
    Range { from: 'ᵂ', to: 'ᵂ', mapping: Mapped("w") },
    Range { from: 'ᵃ', to: 'ᵃ', mapping: Mapped("a") },
    Range { from: 'ᵄ', to: 'ᵄ', mapping: Mapped("ɐ") },
    Range { from: 'ᵅ', to: 'ᵅ', mapping: Mapped("ɑ") },
    Range { from: 'ᵆ', to: 'ᵆ', mapping: Mapped("ᴂ") },
    Range { from: 'ᵇ', to: 'ᵇ', mapping: Mapped("b") },
    Range { from: 'ᵈ', to: 'ᵈ', mapping: Mapped("d") },
    Range { from: 'ᵉ', to: 'ᵉ', mapping: Mapped("e") },
    Range { from: 'ᵊ', to: 'ᵊ', mapping: Mapped("ə") },
    Range { from: 'ᵋ', to: 'ᵋ', mapping: Mapped("ɛ") },
    Range { from: 'ᵌ', to: 'ᵌ', mapping: Mapped("ɜ") },
    Range { from: 'ᵍ', to: 'ᵍ', mapping: Mapped("g") },
    Range { from: 'ᵎ', to: 'ᵎ', mapping: Valid },
    Range { from: 'ᵏ', to: 'ᵏ', mapping: Mapped("k") },
    Range { from: 'ᵐ', to: 'ᵐ', mapping: Mapped("m") },
    Range { from: 'ᵑ', to: 'ᵑ', mapping: Mapped("ŋ") },
    Range { from: 'ᵒ', to: 'ᵒ', mapping: Mapped("o") },
    Range { from: 'ᵓ', to: 'ᵓ', mapping: Mapped("ɔ") },
    Range { from: 'ᵔ', to: 'ᵔ', mapping: Mapped("ᴖ") },
    Range { from: 'ᵕ', to: 'ᵕ', mapping: Mapped("ᴗ") },
    Range { from: 'ᵖ', to: 'ᵖ', mapping: Mapped("p") },
    Range { from: 'ᵗ', to: 'ᵗ', mapping: Mapped("t") },
    Range { from: 'ᵘ', to: 'ᵘ', mapping: Mapped("u") },
    Range { from: 'ᵙ', to: 'ᵙ', mapping: Mapped("ᴝ") },
    Range { from: 'ᵚ', to: 'ᵚ', mapping: Mapped("ɯ") },
    Range { from: 'ᵛ', to: 'ᵛ', mapping: Mapped("v") },
    Range { from: 'ᵜ', to: 'ᵜ', mapping: Mapped("ᴥ") },
    Range { from: 'ᵝ', to: 'ᵝ', mapping: Mapped("β") },
    Range { from: 'ᵞ', to: 'ᵞ', mapping: Mapped("γ") },
    Range { from: 'ᵟ', to: 'ᵟ', mapping: Mapped("δ") },
    Range { from: 'ᵠ', to: 'ᵠ', mapping: Mapped("φ") },
    Range { from: 'ᵡ', to: 'ᵡ', mapping: Mapped("χ") },
    Range { from: 'ᵢ', to: 'ᵢ', mapping: Mapped("i") },
    Range { from: 'ᵣ', to: 'ᵣ', mapping: Mapped("r") },
    Range { from: 'ᵤ', to: 'ᵤ', mapping: Mapped("u") },
    Range { from: 'ᵥ', to: 'ᵥ', mapping: Mapped("v") },
    Range { from: 'ᵦ', to: 'ᵦ', mapping: Mapped("β") },
    Range { from: 'ᵧ', to: 'ᵧ', mapping: Mapped("γ") },
    Range { from: 'ᵨ', to: 'ᵨ', mapping: Mapped("ρ") },
    Range { from: 'ᵩ', to: 'ᵩ', mapping: Mapped("φ") },
    Range { from: 'ᵪ', to: 'ᵪ', mapping: Mapped("χ") },
    Range { from: 'ᵫ', to: 'ᵫ', mapping: Valid },
    Range { from: 'ᵬ', to: 'ᵷ', mapping: Valid },
    Range { from: 'ᵸ', to: 'ᵸ', mapping: Mapped("н") },
    Range { from: 'ᵹ', to: 'ᶚ', mapping: Valid },
    Range { from: 'ᶛ', to: 'ᶛ', mapping: Mapped("ɒ") },
    Range { from: 'ᶜ', to: 'ᶜ', mapping: Mapped("c") },
    Range { from: 'ᶝ', to: 'ᶝ', mapping: Mapped("ɕ") },
    Range { from: 'ᶞ', to: 'ᶞ', mapping: Mapped("ð") },
    Range { from: 'ᶟ', to: 'ᶟ', mapping: Mapped("ɜ") },
    Range { from: 'ᶠ', to: 'ᶠ', mapping: Mapped("f") },
    Range { from: 'ᶡ', to: 'ᶡ', mapping: Mapped("ɟ") },
    Range { from: 'ᶢ', to: 'ᶢ', mapping: Mapped("ɡ") },
    Range { from: 'ᶣ', to: 'ᶣ', mapping: Mapped("ɥ") },
    Range { from: 'ᶤ', to: 'ᶤ', mapping: Mapped("ɨ") },
    Range { from: 'ᶥ', to: 'ᶥ', mapping: Mapped("ɩ") },
    Range { from: 'ᶦ', to: 'ᶦ', mapping: Mapped("ɪ") },
    Range { from: 'ᶧ', to: 'ᶧ', mapping: Mapped("ᵻ") },
    Range { from: 'ᶨ', to: 'ᶨ', mapping: Mapped("ʝ") },
    Range { from: 'ᶩ', to: 'ᶩ', mapping: Mapped("ɭ") },
    Range { from: 'ᶪ', to: 'ᶪ', mapping: Mapped("ᶅ") },
    Range { from: 'ᶫ', to: 'ᶫ', mapping: Mapped("ʟ") },
    Range { from: 'ᶬ', to: 'ᶬ', mapping: Mapped("ɱ") },
    Range { from: 'ᶭ', to: 'ᶭ', mapping: Mapped("ɰ") },
    Range { from: 'ᶮ', to: 'ᶮ', mapping: Mapped("ɲ") },
    Range { from: 'ᶯ', to: 'ᶯ', mapping: Mapped("ɳ") },
    Range { from: 'ᶰ', to: 'ᶰ', mapping: Mapped("ɴ") },
    Range { from: 'ᶱ', to: 'ᶱ', mapping: Mapped("ɵ") },
    Range { from: 'ᶲ', to: 'ᶲ', mapping: Mapped("ɸ") },
    Range { from: 'ᶳ', to: 'ᶳ', mapping: Mapped("ʂ") },
    Range { from: 'ᶴ', to: 'ᶴ', mapping: Mapped("ʃ") },
    Range { from: 'ᶵ', to: 'ᶵ', mapping: Mapped("ƫ") },
    Range { from: 'ᶶ', to: 'ᶶ', mapping: Mapped("ʉ") },
    Range { from: 'ᶷ', to: 'ᶷ', mapping: Mapped("ʊ") },
    Range { from: 'ᶸ', to: 'ᶸ', mapping: Mapped("ᴜ") },
    Range { from: 'ᶹ', to: 'ᶹ', mapping: Mapped("ʋ") },
    Range { from: 'ᶺ', to: 'ᶺ', mapping: Mapped("ʌ") },
    Range { from: 'ᶻ', to: 'ᶻ', mapping: Mapped("z") },
    Range { from: 'ᶼ', to: 'ᶼ', mapping: Mapped("ʐ") },
    Range { from: 'ᶽ', to: 'ᶽ', mapping: Mapped("ʑ") },
    Range { from: 'ᶾ', to: 'ᶾ', mapping: Mapped("ʒ") },
    Range { from: 'ᶿ', to: 'ᶿ', mapping: Mapped("θ") },
    Range { from: '᷀', to: '᷃', mapping: Valid },
    Range { from: '᷄', to: '᷊', mapping: Valid },
    Range { from: '᷋', to: 'ᷦ', mapping: Valid },
    Range { from: 'ᷧ', to: '᷵', mapping: Valid },
    Range { from: '᷶', to: '᷻', mapping: Disallowed },
    Range { from: '᷼', to: '᷼', mapping: Valid },
    Range { from: '᷽', to: '᷽', mapping: Valid },
    Range { from: '᷾', to: '᷿', mapping: Valid },
    Range { from: 'Ḁ', to: 'Ḁ', mapping: Mapped("ḁ") },
    Range { from: 'ḁ', to: 'ḁ', mapping: Valid },
    Range { from: 'Ḃ', to: 'Ḃ', mapping: Mapped("ḃ") },
    Range { from: 'ḃ', to: 'ḃ', mapping: Valid },
    Range { from: 'Ḅ', to: 'Ḅ', mapping: Mapped("ḅ") },
    Range { from: 'ḅ', to: 'ḅ', mapping: Valid },
    Range { from: 'Ḇ', to: 'Ḇ', mapping: Mapped("ḇ") },
    Range { from: 'ḇ', to: 'ḇ', mapping: Valid },
    Range { from: 'Ḉ', to: 'Ḉ', mapping: Mapped("ḉ") },
    Range { from: 'ḉ', to: 'ḉ', mapping: Valid },
    Range { from: 'Ḋ', to: 'Ḋ', mapping: Mapped("ḋ") },
    Range { from: 'ḋ', to: 'ḋ', mapping: Valid },
    Range { from: 'Ḍ', to: 'Ḍ', mapping: Mapped("ḍ") },
    Range { from: 'ḍ', to: 'ḍ', mapping: Valid },
    Range { from: 'Ḏ', to: 'Ḏ', mapping: Mapped("ḏ") },
    Range { from: 'ḏ', to: 'ḏ', mapping: Valid },
    Range { from: 'Ḑ', to: 'Ḑ', mapping: Mapped("ḑ") },
    Range { from: 'ḑ', to: 'ḑ', mapping: Valid },
    Range { from: 'Ḓ', to: 'Ḓ', mapping: Mapped("ḓ") },
    Range { from: 'ḓ', to: 'ḓ', mapping: Valid },
    Range { from: 'Ḕ', to: 'Ḕ', mapping: Mapped("ḕ") },
    Range { from: 'ḕ', to: 'ḕ', mapping: Valid },
    Range { from: 'Ḗ', to: 'Ḗ', mapping: Mapped("ḗ") },
    Range { from: 'ḗ', to: 'ḗ', mapping: Valid },
    Range { from: 'Ḙ', to: 'Ḙ', mapping: Mapped("ḙ") },
    Range { from: 'ḙ', to: 'ḙ', mapping: Valid },
    Range { from: 'Ḛ', to: 'Ḛ', mapping: Mapped("ḛ") },
    Range { from: 'ḛ', to: 'ḛ', mapping: Valid },
    Range { from: 'Ḝ', to: 'Ḝ', mapping: Mapped("ḝ") },
    Range { from: 'ḝ', to: 'ḝ', mapping: Valid },
    Range { from: 'Ḟ', to: 'Ḟ', mapping: Mapped("ḟ") },
    Range { from: 'ḟ', to: 'ḟ', mapping: Valid },
    Range { from: 'Ḡ', to: 'Ḡ', mapping: Mapped("ḡ") },
    Range { from: 'ḡ', to: 'ḡ', mapping: Valid },
    Range { from: 'Ḣ', to: 'Ḣ', mapping: Mapped("ḣ") },
    Range { from: 'ḣ', to: 'ḣ', mapping: Valid },
    Range { from: 'Ḥ', to: 'Ḥ', mapping: Mapped("ḥ") },
    Range { from: 'ḥ', to: 'ḥ', mapping: Valid },
    Range { from: 'Ḧ', to: 'Ḧ', mapping: Mapped("ḧ") },
    Range { from: 'ḧ', to: 'ḧ', mapping: Valid },
    Range { from: 'Ḩ', to: 'Ḩ', mapping: Mapped("ḩ") },
    Range { from: 'ḩ', to: 'ḩ', mapping: Valid },
    Range { from: 'Ḫ', to: 'Ḫ', mapping: Mapped("ḫ") },
    Range { from: 'ḫ', to: 'ḫ', mapping: Valid },
    Range { from: 'Ḭ', to: 'Ḭ', mapping: Mapped("ḭ") },
    Range { from: 'ḭ', to: 'ḭ', mapping: Valid },
    Range { from: 'Ḯ', to: 'Ḯ', mapping: Mapped("ḯ") },
    Range { from: 'ḯ', to: 'ḯ', mapping: Valid },
    Range { from: 'Ḱ', to: 'Ḱ', mapping: Mapped("ḱ") },
    Range { from: 'ḱ', to: 'ḱ', mapping: Valid },
    Range { from: 'Ḳ', to: 'Ḳ', mapping: Mapped("ḳ") },
    Range { from: 'ḳ', to: 'ḳ', mapping: Valid },
    Range { from: 'Ḵ', to: 'Ḵ', mapping: Mapped("ḵ") },
    Range { from: 'ḵ', to: 'ḵ', mapping: Valid },
    Range { from: 'Ḷ', to: 'Ḷ', mapping: Mapped("ḷ") },
    Range { from: 'ḷ', to: 'ḷ', mapping: Valid },
    Range { from: 'Ḹ', to: 'Ḹ', mapping: Mapped("ḹ") },
    Range { from: 'ḹ', to: 'ḹ', mapping: Valid },
    Range { from: 'Ḻ', to: 'Ḻ', mapping: Mapped("ḻ") },
    Range { from: 'ḻ', to: 'ḻ', mapping: Valid },
    Range { from: 'Ḽ', to: 'Ḽ', mapping: Mapped("ḽ") },
    Range { from: 'ḽ', to: 'ḽ', mapping: Valid },
    Range { from: 'Ḿ', to: 'Ḿ', mapping: Mapped("ḿ") },
    Range { from: 'ḿ', to: 'ḿ', mapping: Valid },
    Range { from: 'Ṁ', to: 'Ṁ', mapping: Mapped("ṁ") },
    Range { from: 'ṁ', to: 'ṁ', mapping: Valid },
    Range { from: 'Ṃ', to: 'Ṃ', mapping: Mapped("ṃ") },
    Range { from: 'ṃ', to: 'ṃ', mapping: Valid },
    Range { from: 'Ṅ', to: 'Ṅ', mapping: Mapped("ṅ") },
    Range { from: 'ṅ', to: 'ṅ', mapping: Valid },
    Range { from: 'Ṇ', to: 'Ṇ', mapping: Mapped("ṇ") },
    Range { from: 'ṇ', to: 'ṇ', mapping: Valid },
    Range { from: 'Ṉ', to: 'Ṉ', mapping: Mapped("ṉ") },
    Range { from: 'ṉ', to: 'ṉ', mapping: Valid },
    Range { from: 'Ṋ', to: 'Ṋ', mapping: Mapped("ṋ") },
    Range { from: 'ṋ', to: 'ṋ', mapping: Valid },
    Range { from: 'Ṍ', to: 'Ṍ', mapping: Mapped("ṍ") },
    Range { from: 'ṍ', to: 'ṍ', mapping: Valid },
    Range { from: 'Ṏ', to: 'Ṏ', mapping: Mapped("ṏ") },
    Range { from: 'ṏ', to: 'ṏ', mapping: Valid },
    Range { from: 'Ṑ', to: 'Ṑ', mapping: Mapped("ṑ") },
    Range { from: 'ṑ', to: 'ṑ', mapping: Valid },
    Range { from: 'Ṓ', to: 'Ṓ', mapping: Mapped("ṓ") },
    Range { from: 'ṓ', to: 'ṓ', mapping: Valid },
    Range { from: 'Ṕ', to: 'Ṕ', mapping: Mapped("ṕ") },
    Range { from: 'ṕ', to: 'ṕ', mapping: Valid },
    Range { from: 'Ṗ', to: 'Ṗ', mapping: Mapped("ṗ") },
    Range { from: 'ṗ', to: 'ṗ', mapping: Valid },
    Range { from: 'Ṙ', to: 'Ṙ', mapping: Mapped("ṙ") },
    Range { from: 'ṙ', to: 'ṙ', mapping: Valid },
    Range { from: 'Ṛ', to: 'Ṛ', mapping: Mapped("ṛ") },
    Range { from: 'ṛ', to: 'ṛ', mapping: Valid },
    Range { from: 'Ṝ', to: 'Ṝ', mapping: Mapped("ṝ") },
    Range { from: 'ṝ', to: 'ṝ', mapping: Valid },
    Range { from: 'Ṟ', to: 'Ṟ', mapping: Mapped("ṟ") },
    Range { from: 'ṟ', to: 'ṟ', mapping: Valid },
    Range { from: 'Ṡ', to: 'Ṡ', mapping: Mapped("ṡ") },
    Range { from: 'ṡ', to: 'ṡ', mapping: Valid },
    Range { from: 'Ṣ', to: 'Ṣ', mapping: Mapped("ṣ") },
    Range { from: 'ṣ', to: 'ṣ', mapping: Valid },
    Range { from: 'Ṥ', to: 'Ṥ', mapping: Mapped("ṥ") },
    Range { from: 'ṥ', to: 'ṥ', mapping: Valid },
    Range { from: 'Ṧ', to: 'Ṧ', mapping: Mapped("ṧ") },
    Range { from: 'ṧ', to: 'ṧ', mapping: Valid },
    Range { from: 'Ṩ', to: 'Ṩ', mapping: Mapped("ṩ") },
    Range { from: 'ṩ', to: 'ṩ', mapping: Valid },
    Range { from: 'Ṫ', to: 'Ṫ', mapping: Mapped("ṫ") },
    Range { from: 'ṫ', to: 'ṫ', mapping: Valid },
    Range { from: 'Ṭ', to: 'Ṭ', mapping: Mapped("ṭ") },
    Range { from: 'ṭ', to: 'ṭ', mapping: Valid },
    Range { from: 'Ṯ', to: 'Ṯ', mapping: Mapped("ṯ") },
    Range { from: 'ṯ', to: 'ṯ', mapping: Valid },
    Range { from: 'Ṱ', to: 'Ṱ', mapping: Mapped("ṱ") },
    Range { from: 'ṱ', to: 'ṱ', mapping: Valid },
    Range { from: 'Ṳ', to: 'Ṳ', mapping: Mapped("ṳ") },
    Range { from: 'ṳ', to: 'ṳ', mapping: Valid },
    Range { from: 'Ṵ', to: 'Ṵ', mapping: Mapped("ṵ") },
    Range { from: 'ṵ', to: 'ṵ', mapping: Valid },
    Range { from: 'Ṷ', to: 'Ṷ', mapping: Mapped("ṷ") },
    Range { from: 'ṷ', to: 'ṷ', mapping: Valid },
    Range { from: 'Ṹ', to: 'Ṹ', mapping: Mapped("ṹ") },
    Range { from: 'ṹ', to: 'ṹ', mapping: Valid },
    Range { from: 'Ṻ', to: 'Ṻ', mapping: Mapped("ṻ") },
    Range { from: 'ṻ', to: 'ṻ', mapping: Valid },
    Range { from: 'Ṽ', to: 'Ṽ', mapping: Mapped("ṽ") },
    Range { from: 'ṽ', to: 'ṽ', mapping: Valid },
    Range { from: 'Ṿ', to: 'Ṿ', mapping: Mapped("ṿ") },
    Range { from: 'ṿ', to: 'ṿ', mapping: Valid },
    Range { from: 'Ẁ', to: 'Ẁ', mapping: Mapped("ẁ") },
    Range { from: 'ẁ', to: 'ẁ', mapping: Valid },
    Range { from: 'Ẃ', to: 'Ẃ', mapping: Mapped("ẃ") },
    Range { from: 'ẃ', to: 'ẃ', mapping: Valid },
    Range { from: 'Ẅ', to: 'Ẅ', mapping: Mapped("ẅ") },
    Range { from: 'ẅ', to: 'ẅ', mapping: Valid },
    Range { from: 'Ẇ', to: 'Ẇ', mapping: Mapped("ẇ") },
    Range { from: 'ẇ', to: 'ẇ', mapping: Valid },
    Range { from: 'Ẉ', to: 'Ẉ', mapping: Mapped("ẉ") },
    Range { from: 'ẉ', to: 'ẉ', mapping: Valid },
    Range { from: 'Ẋ', to: 'Ẋ', mapping: Mapped("ẋ") },
    Range { from: 'ẋ', to: 'ẋ', mapping: Valid },
    Range { from: 'Ẍ', to: 'Ẍ', mapping: Mapped("ẍ") },
    Range { from: 'ẍ', to: 'ẍ', mapping: Valid },
    Range { from: 'Ẏ', to: 'Ẏ', mapping: Mapped("ẏ") },
    Range { from: 'ẏ', to: 'ẏ', mapping: Valid },
    Range { from: 'Ẑ', to: 'Ẑ', mapping: Mapped("ẑ") },
    Range { from: 'ẑ', to: 'ẑ', mapping: Valid },
    Range { from: 'Ẓ', to: 'Ẓ', mapping: Mapped("ẓ") },
    Range { from: 'ẓ', to: 'ẓ', mapping: Valid },
    Range { from: 'Ẕ', to: 'Ẕ', mapping: Mapped("ẕ") },
    Range { from: 'ẕ', to: 'ẙ', mapping: Valid },
    Range { from: 'ẚ', to: 'ẚ', mapping: Mapped("aʾ") },
    Range { from: 'ẛ', to: 'ẛ', mapping: Mapped("ṡ") },
    Range { from: 'ẜ', to: 'ẝ', mapping: Valid },
    Range { from: 'ẞ', to: 'ẞ', mapping: Mapped("ss") },
    Range { from: 'ẟ', to: 'ẟ', mapping: Valid },
    Range { from: 'Ạ', to: 'Ạ', mapping: Mapped("ạ") },
    Range { from: 'ạ', to: 'ạ', mapping: Valid },
    Range { from: 'Ả', to: 'Ả', mapping: Mapped("ả") },
    Range { from: 'ả', to: 'ả', mapping: Valid },
    Range { from: 'Ấ', to: 'Ấ', mapping: Mapped("ấ") },
    Range { from: 'ấ', to: 'ấ', mapping: Valid },
    Range { from: 'Ầ', to: 'Ầ', mapping: Mapped("ầ") },
    Range { from: 'ầ', to: 'ầ', mapping: Valid },
    Range { from: 'Ẩ', to: 'Ẩ', mapping: Mapped("ẩ") },
    Range { from: 'ẩ', to: 'ẩ', mapping: Valid },
    Range { from: 'Ẫ', to: 'Ẫ', mapping: Mapped("ẫ") },
    Range { from: 'ẫ', to: 'ẫ', mapping: Valid },
    Range { from: 'Ậ', to: 'Ậ', mapping: Mapped("ậ") },
    Range { from: 'ậ', to: 'ậ', mapping: Valid },
    Range { from: 'Ắ', to: 'Ắ', mapping: Mapped("ắ") },
    Range { from: 'ắ', to: 'ắ', mapping: Valid },
    Range { from: 'Ằ', to: 'Ằ', mapping: Mapped("ằ") },
    Range { from: 'ằ', to: 'ằ', mapping: Valid },
    Range { from: 'Ẳ', to: 'Ẳ', mapping: Mapped("ẳ") },
    Range { from: 'ẳ', to: 'ẳ', mapping: Valid },
    Range { from: 'Ẵ', to: 'Ẵ', mapping: Mapped("ẵ") },
    Range { from: 'ẵ', to: 'ẵ', mapping: Valid },
    Range { from: 'Ặ', to: 'Ặ', mapping: Mapped("ặ") },
    Range { from: 'ặ', to: 'ặ', mapping: Valid },
    Range { from: 'Ẹ', to: 'Ẹ', mapping: Mapped("ẹ") },
    Range { from: 'ẹ', to: 'ẹ', mapping: Valid },
    Range { from: 'Ẻ', to: 'Ẻ', mapping: Mapped("ẻ") },
    Range { from: 'ẻ', to: 'ẻ', mapping: Valid },
    Range { from: 'Ẽ', to: 'Ẽ', mapping: Mapped("ẽ") },
    Range { from: 'ẽ', to: 'ẽ', mapping: Valid },
    Range { from: 'Ế', to: 'Ế', mapping: Mapped("ế") },
    Range { from: 'ế', to: 'ế', mapping: Valid },
    Range { from: 'Ề', to: 'Ề', mapping: Mapped("ề") },
    Range { from: 'ề', to: 'ề', mapping: Valid },
    Range { from: 'Ể', to: 'Ể', mapping: Mapped("ể") },
    Range { from: 'ể', to: 'ể', mapping: Valid },
    Range { from: 'Ễ', to: 'Ễ', mapping: Mapped("ễ") },
    Range { from: 'ễ', to: 'ễ', mapping: Valid },
    Range { from: 'Ệ', to: 'Ệ', mapping: Mapped("ệ") },
    Range { from: 'ệ', to: 'ệ', mapping: Valid },
    Range { from: 'Ỉ', to: 'Ỉ', mapping: Mapped("ỉ") },
    Range { from: 'ỉ', to: 'ỉ', mapping: Valid },
    Range { from: 'Ị', to: 'Ị', mapping: Mapped("ị") },
    Range { from: 'ị', to: 'ị', mapping: Valid },
    Range { from: 'Ọ', to: 'Ọ', mapping: Mapped("ọ") },
    Range { from: 'ọ', to: 'ọ', mapping: Valid },
    Range { from: 'Ỏ', to: 'Ỏ', mapping: Mapped("ỏ") },
    Range { from: 'ỏ', to: 'ỏ', mapping: Valid },
    Range { from: 'Ố', to: 'Ố', mapping: Mapped("ố") },
    Range { from: 'ố', to: 'ố', mapping: Valid },
    Range { from: 'Ồ', to: 'Ồ', mapping: Mapped("ồ") },
    Range { from: 'ồ', to: 'ồ', mapping: Valid },
    Range { from: 'Ổ', to: 'Ổ', mapping: Mapped("ổ") },
    Range { from: 'ổ', to: 'ổ', mapping: Valid },
    Range { from: 'Ỗ', to: 'Ỗ', mapping: Mapped("ỗ") },
    Range { from: 'ỗ', to: 'ỗ', mapping: Valid },
    Range { from: 'Ộ', to: 'Ộ', mapping: Mapped("ộ") },
    Range { from: 'ộ', to: 'ộ', mapping: Valid },
    Range { from: 'Ớ', to: 'Ớ', mapping: Mapped("ớ") },
    Range { from: 'ớ', to: 'ớ', mapping: Valid },
    Range { from: 'Ờ', to: 'Ờ', mapping: Mapped("ờ") },
    Range { from: 'ờ', to: 'ờ', mapping: Valid },
    Range { from: 'Ở', to: 'Ở', mapping: Mapped("ở") },
    Range { from: 'ở', to: 'ở', mapping: Valid },
    Range { from: 'Ỡ', to: 'Ỡ', mapping: Mapped("ỡ") },
    Range { from: 'ỡ', to: 'ỡ', mapping: Valid },
    Range { from: 'Ợ', to: 'Ợ', mapping: Mapped("ợ") },
    Range { from: 'ợ', to: 'ợ', mapping: Valid },
    Range { from: 'Ụ', to: 'Ụ', mapping: Mapped("ụ") },
    Range { from: 'ụ', to: 'ụ', mapping: Valid },
    Range { from: 'Ủ', to: 'Ủ', mapping: Mapped("ủ") },
    Range { from: 'ủ', to: 'ủ', mapping: Valid },
    Range { from: 'Ứ', to: 'Ứ', mapping: Mapped("ứ") },
    Range { from: 'ứ', to: 'ứ', mapping: Valid },
    Range { from: 'Ừ', to: 'Ừ', mapping: Mapped("ừ") },
    Range { from: 'ừ', to: 'ừ', mapping: Valid },
    Range { from: 'Ử', to: 'Ử', mapping: Mapped("ử") },
    Range { from: 'ử', to: 'ử', mapping: Valid },
    Range { from: 'Ữ', to: 'Ữ', mapping: Mapped("ữ") },
    Range { from: 'ữ', to: 'ữ', mapping: Valid },
    Range { from: 'Ự', to: 'Ự', mapping: Mapped("ự") },
    Range { from: 'ự', to: 'ự', mapping: Valid },
    Range { from: 'Ỳ', to: 'Ỳ', mapping: Mapped("ỳ") },
    Range { from: 'ỳ', to: 'ỳ', mapping: Valid },
    Range { from: 'Ỵ', to: 'Ỵ', mapping: Mapped("ỵ") },
    Range { from: 'ỵ', to: 'ỵ', mapping: Valid },
    Range { from: 'Ỷ', to: 'Ỷ', mapping: Mapped("ỷ") },
    Range { from: 'ỷ', to: 'ỷ', mapping: Valid },
    Range { from: 'Ỹ', to: 'Ỹ', mapping: Mapped("ỹ") },
    Range { from: 'ỹ', to: 'ỹ', mapping: Valid },
    Range { from: 'Ỻ', to: 'Ỻ', mapping: Mapped("ỻ") },
    Range { from: 'ỻ', to: 'ỻ', mapping: Valid },
    Range { from: 'Ỽ', to: 'Ỽ', mapping: Mapped("ỽ") },
    Range { from: 'ỽ', to: 'ỽ', mapping: Valid },
    Range { from: 'Ỿ', to: 'Ỿ', mapping: Mapped("ỿ") },
    Range { from: 'ỿ', to: 'ỿ', mapping: Valid },
    Range { from: 'ἀ', to: 'ἇ', mapping: Valid },
    Range { from: 'Ἀ', to: 'Ἀ', mapping: Mapped("ἀ") },
    Range { from: 'Ἁ', to: 'Ἁ', mapping: Mapped("ἁ") },
    Range { from: 'Ἂ', to: 'Ἂ', mapping: Mapped("ἂ") },
    Range { from: 'Ἃ', to: 'Ἃ', mapping: Mapped("ἃ") },
    Range { from: 'Ἄ', to: 'Ἄ', mapping: Mapped("ἄ") },
    Range { from: 'Ἅ', to: 'Ἅ', mapping: Mapped("ἅ") },
    Range { from: 'Ἆ', to: 'Ἆ', mapping: Mapped("ἆ") },
    Range { from: 'Ἇ', to: 'Ἇ', mapping: Mapped("ἇ") },
    Range { from: 'ἐ', to: 'ἕ', mapping: Valid },
    Range { from: '἖', to: '἗', mapping: Disallowed },
    Range { from: 'Ἐ', to: 'Ἐ', mapping: Mapped("ἐ") },
    Range { from: 'Ἑ', to: 'Ἑ', mapping: Mapped("ἑ") },
    Range { from: 'Ἒ', to: 'Ἒ', mapping: Mapped("ἒ") },
    Range { from: 'Ἓ', to: 'Ἓ', mapping: Mapped("ἓ") },
    Range { from: 'Ἔ', to: 'Ἔ', mapping: Mapped("ἔ") },
    Range { from: 'Ἕ', to: 'Ἕ', mapping: Mapped("ἕ") },
    Range { from: '἞', to: '἟', mapping: Disallowed },
    Range { from: 'ἠ', to: 'ἧ', mapping: Valid },
    Range { from: 'Ἠ', to: 'Ἠ', mapping: Mapped("ἠ") },
    Range { from: 'Ἡ', to: 'Ἡ', mapping: Mapped("ἡ") },
    Range { from: 'Ἢ', to: 'Ἢ', mapping: Mapped("ἢ") },
    Range { from: 'Ἣ', to: 'Ἣ', mapping: Mapped("ἣ") },
    Range { from: 'Ἤ', to: 'Ἤ', mapping: Mapped("ἤ") },
    Range { from: 'Ἥ', to: 'Ἥ', mapping: Mapped("ἥ") },
    Range { from: 'Ἦ', to: 'Ἦ', mapping: Mapped("ἦ") },
    Range { from: 'Ἧ', to: 'Ἧ', mapping: Mapped("ἧ") },
    Range { from: 'ἰ', to: 'ἷ', mapping: Valid },
    Range { from: 'Ἰ', to: 'Ἰ', mapping: Mapped("ἰ") },
    Range { from: 'Ἱ', to: 'Ἱ', mapping: Mapped("ἱ") },
    Range { from: 'Ἲ', to: 'Ἲ', mapping: Mapped("ἲ") },
    Range { from: 'Ἳ', to: 'Ἳ', mapping: Mapped("ἳ") },
    Range { from: 'Ἴ', to: 'Ἴ', mapping: Mapped("ἴ") },
    Range { from: 'Ἵ', to: 'Ἵ', mapping: Mapped("ἵ") },
    Range { from: 'Ἶ', to: 'Ἶ', mapping: Mapped("ἶ") },
    Range { from: 'Ἷ', to: 'Ἷ', mapping: Mapped("ἷ") },
    Range { from: 'ὀ', to: 'ὅ', mapping: Valid },
    Range { from: '὆', to: '὇', mapping: Disallowed },
    Range { from: 'Ὀ', to: 'Ὀ', mapping: Mapped("ὀ") },
    Range { from: 'Ὁ', to: 'Ὁ', mapping: Mapped("ὁ") },
    Range { from: 'Ὂ', to: 'Ὂ', mapping: Mapped("ὂ") },
    Range { from: 'Ὃ', to: 'Ὃ', mapping: Mapped("ὃ") },
    Range { from: 'Ὄ', to: 'Ὄ', mapping: Mapped("ὄ") },
    Range { from: 'Ὅ', to: 'Ὅ', mapping: Mapped("ὅ") },
    Range { from: '὎', to: '὏', mapping: Disallowed },
    Range { from: 'ὐ', to: 'ὗ', mapping: Valid },
    Range { from: '὘', to: '὘', mapping: Disallowed },
    Range { from: 'Ὑ', to: 'Ὑ', mapping: Mapped("ὑ") },
    Range { from: '὚', to: '὚', mapping: Disallowed },
    Range { from: 'Ὓ', to: 'Ὓ', mapping: Mapped("ὓ") },
    Range { from: '὜', to: '὜', mapping: Disallowed },
    Range { from: 'Ὕ', to: 'Ὕ', mapping: Mapped("ὕ") },
    Range { from: '὞', to: '὞', mapping: Disallowed },
    Range { from: 'Ὗ', to: 'Ὗ', mapping: Mapped("ὗ") },
    Range { from: 'ὠ', to: 'ὧ', mapping: Valid },
    Range { from: 'Ὠ', to: 'Ὠ', mapping: Mapped("ὠ") },
    Range { from: 'Ὡ', to: 'Ὡ', mapping: Mapped("ὡ") },
    Range { from: 'Ὢ', to: 'Ὢ', mapping: Mapped("ὢ") },
    Range { from: 'Ὣ', to: 'Ὣ', mapping: Mapped("ὣ") },
    Range { from: 'Ὤ', to: 'Ὤ', mapping: Mapped("ὤ") },
    Range { from: 'Ὥ', to: 'Ὥ', mapping: Mapped("ὥ") },
    Range { from: 'Ὦ', to: 'Ὦ', mapping: Mapped("ὦ") },
    Range { from: 'Ὧ', to: 'Ὧ', mapping: Mapped("ὧ") },
    Range { from: 'ὰ', to: 'ὰ', mapping: Valid },
    Range { from: 'ά', to: 'ά', mapping: Mapped("ά") },
    Range { from: 'ὲ', to: 'ὲ', mapping: Valid },
    Range { from: 'έ', to: 'έ', mapping: Mapped("έ") },
    Range { from: 'ὴ', to: 'ὴ', mapping: Valid },
    Range { from: 'ή', to: 'ή', mapping: Mapped("ή") },
    Range { from: 'ὶ', to: 'ὶ', mapping: Valid },
    Range { from: 'ί', to: 'ί', mapping: Mapped("ί") },
    Range { from: 'ὸ', to: 'ὸ', mapping: Valid },
    Range { from: 'ό', to: 'ό', mapping: Mapped("ό") },
    Range { from: 'ὺ', to: 'ὺ', mapping: Valid },
    Range { from: 'ύ', to: 'ύ', mapping: Mapped("ύ") },
    Range { from: 'ὼ', to: 'ὼ', mapping: Valid },
    Range { from: 'ώ', to: 'ώ', mapping: Mapped("ώ") },
    Range { from: '὾', to: '὿', mapping: Disallowed },
    Range { from: 'ᾀ', to: 'ᾀ', mapping: Mapped("ἀι") },
    Range { from: 'ᾁ', to: 'ᾁ', mapping: Mapped("ἁι") },
    Range { from: 'ᾂ', to: 'ᾂ', mapping: Mapped("ἂι") },
    Range { from: 'ᾃ', to: 'ᾃ', mapping: Mapped("ἃι") },
    Range { from: 'ᾄ', to: 'ᾄ', mapping: Mapped("ἄι") },
    Range { from: 'ᾅ', to: 'ᾅ', mapping: Mapped("ἅι") },
    Range { from: 'ᾆ', to: 'ᾆ', mapping: Mapped("ἆι") },
    Range { from: 'ᾇ', to: 'ᾇ', mapping: Mapped("ἇι") },
    Range { from: 'ᾈ', to: 'ᾈ', mapping: Mapped("ἀι") },
    Range { from: 'ᾉ', to: 'ᾉ', mapping: Mapped("ἁι") },
    Range { from: 'ᾊ', to: 'ᾊ', mapping: Mapped("ἂι") },
    Range { from: 'ᾋ', to: 'ᾋ', mapping: Mapped("ἃι") },
    Range { from: 'ᾌ', to: 'ᾌ', mapping: Mapped("ἄι") },
    Range { from: 'ᾍ', to: 'ᾍ', mapping: Mapped("ἅι") },
    Range { from: 'ᾎ', to: 'ᾎ', mapping: Mapped("ἆι") },
    Range { from: 'ᾏ', to: 'ᾏ', mapping: Mapped("ἇι") },
    Range { from: 'ᾐ', to: 'ᾐ', mapping: Mapped("ἠι") },
    Range { from: 'ᾑ', to: 'ᾑ', mapping: Mapped("ἡι") },
    Range { from: 'ᾒ', to: 'ᾒ', mapping: Mapped("ἢι") },
    Range { from: 'ᾓ', to: 'ᾓ', mapping: Mapped("ἣι") },
    Range { from: 'ᾔ', to: 'ᾔ', mapping: Mapped("ἤι") },
    Range { from: 'ᾕ', to: 'ᾕ', mapping: Mapped("ἥι") },
    Range { from: 'ᾖ', to: 'ᾖ', mapping: Mapped("ἦι") },
    Range { from: 'ᾗ', to: 'ᾗ', mapping: Mapped("ἧι") },
    Range { from: 'ᾘ', to: 'ᾘ', mapping: Mapped("ἠι") },
    Range { from: 'ᾙ', to: 'ᾙ', mapping: Mapped("ἡι") },
    Range { from: 'ᾚ', to: 'ᾚ', mapping: Mapped("ἢι") },
    Range { from: 'ᾛ', to: 'ᾛ', mapping: Mapped("ἣι") },
    Range { from: 'ᾜ', to: 'ᾜ', mapping: Mapped("ἤι") },
    Range { from: 'ᾝ', to: 'ᾝ', mapping: Mapped("ἥι") },
    Range { from: 'ᾞ', to: 'ᾞ', mapping: Mapped("ἦι") },
    Range { from: 'ᾟ', to: 'ᾟ', mapping: Mapped("ἧι") },
    Range { from: 'ᾠ', to: 'ᾠ', mapping: Mapped("ὠι") },
    Range { from: 'ᾡ', to: 'ᾡ', mapping: Mapped("ὡι") },
    Range { from: 'ᾢ', to: 'ᾢ', mapping: Mapped("ὢι") },
    Range { from: 'ᾣ', to: 'ᾣ', mapping: Mapped("ὣι") },
    Range { from: 'ᾤ', to: 'ᾤ', mapping: Mapped("ὤι") },
    Range { from: 'ᾥ', to: 'ᾥ', mapping: Mapped("ὥι") },
    Range { from: 'ᾦ', to: 'ᾦ', mapping: Mapped("ὦι") },
    Range { from: 'ᾧ', to: 'ᾧ', mapping: Mapped("ὧι") },
    Range { from: 'ᾨ', to: 'ᾨ', mapping: Mapped("ὠι") },
    Range { from: 'ᾩ', to: 'ᾩ', mapping: Mapped("ὡι") },
    Range { from: 'ᾪ', to: 'ᾪ', mapping: Mapped("ὢι") },
    Range { from: 'ᾫ', to: 'ᾫ', mapping: Mapped("ὣι") },
    Range { from: 'ᾬ', to: 'ᾬ', mapping: Mapped("ὤι") },
    Range { from: 'ᾭ', to: 'ᾭ', mapping: Mapped("ὥι") },
    Range { from: 'ᾮ', to: 'ᾮ', mapping: Mapped("ὦι") },
    Range { from: 'ᾯ', to: 'ᾯ', mapping: Mapped("ὧι") },
    Range { from: 'ᾰ', to: 'ᾱ', mapping: Valid },
    Range { from: 'ᾲ', to: 'ᾲ', mapping: Mapped("ὰι") },
    Range { from: 'ᾳ', to: 'ᾳ', mapping: Mapped("αι") },
    Range { from: 'ᾴ', to: 'ᾴ', mapping: Mapped("άι") },
    Range { from: '᾵', to: '᾵', mapping: Disallowed },
    Range { from: 'ᾶ', to: 'ᾶ', mapping: Valid },
    Range { from: 'ᾷ', to: 'ᾷ', mapping: Mapped("ᾶι") },
    Range { from: 'Ᾰ', to: 'Ᾰ', mapping: Mapped("ᾰ") },
    Range { from: 'Ᾱ', to: 'Ᾱ', mapping: Mapped("ᾱ") },
    Range { from: 'Ὰ', to: 'Ὰ', mapping: Mapped("ὰ") },
    Range { from: 'Ά', to: 'Ά', mapping: Mapped("ά") },
    Range { from: 'ᾼ', to: 'ᾼ', mapping: Mapped("αι") },
    Range { from: '᾽', to: '᾽', mapping: DisallowedStd3Mapped(" ̓") },
    Range { from: 'ι', to: 'ι', mapping: Mapped("ι") },
    Range { from: '᾿', to: '᾿', mapping: DisallowedStd3Mapped(" ̓") },
    Range { from: '῀', to: '῀', mapping: DisallowedStd3Mapped(" ͂") },
    Range { from: '῁', to: '῁', mapping: DisallowedStd3Mapped(" ̈͂") },
    Range { from: 'ῂ', to: 'ῂ', mapping: Mapped("ὴι") },
    Range { from: 'ῃ', to: 'ῃ', mapping: Mapped("ηι") },
    Range { from: 'ῄ', to: 'ῄ', mapping: Mapped("ήι") },
    Range { from: '῅', to: '῅', mapping: Disallowed },
    Range { from: 'ῆ', to: 'ῆ', mapping: Valid },
    Range { from: 'ῇ', to: 'ῇ', mapping: Mapped("ῆι") },
    Range { from: 'Ὲ', to: 'Ὲ', mapping: Mapped("ὲ") },
    Range { from: 'Έ', to: 'Έ', mapping: Mapped("έ") },
    Range { from: 'Ὴ', to: 'Ὴ', mapping: Mapped("ὴ") },
    Range { from: 'Ή', to: 'Ή', mapping: Mapped("ή") },
    Range { from: 'ῌ', to: 'ῌ', mapping: Mapped("ηι") },
    Range { from: '῍', to: '῍', mapping: DisallowedStd3Mapped(" ̓̀") },
    Range { from: '῎', to: '῎', mapping: DisallowedStd3Mapped(" ̓́") },
    Range { from: '῏', to: '῏', mapping: DisallowedStd3Mapped(" ̓͂") },
    Range { from: 'ῐ', to: 'ῒ', mapping: Valid },
    Range { from: 'ΐ', to: 'ΐ', mapping: Mapped("ΐ") },
    Range { from: '῔', to: '῕', mapping: Disallowed },
    Range { from: 'ῖ', to: 'ῗ', mapping: Valid },
    Range { from: 'Ῐ', to: 'Ῐ', mapping: Mapped("ῐ") },
    Range { from: 'Ῑ', to: 'Ῑ', mapping: Mapped("ῑ") },
    Range { from: 'Ὶ', to: 'Ὶ', mapping: Mapped("ὶ") },
    Range { from: 'Ί', to: 'Ί', mapping: Mapped("ί") },
    Range { from: '῜', to: '῜', mapping: Disallowed },
    Range { from: '῝', to: '῝', mapping: DisallowedStd3Mapped(" ̔̀") },
    Range { from: '῞', to: '῞', mapping: DisallowedStd3Mapped(" ̔́") },
    Range { from: '῟', to: '῟', mapping: DisallowedStd3Mapped(" ̔͂") },
    Range { from: 'ῠ', to: 'ῢ', mapping: Valid },
    Range { from: 'ΰ', to: 'ΰ', mapping: Mapped("ΰ") },
    Range { from: 'ῤ', to: 'ῧ', mapping: Valid },
    Range { from: 'Ῠ', to: 'Ῠ', mapping: Mapped("ῠ") },
    Range { from: 'Ῡ', to: 'Ῡ', mapping: Mapped("ῡ") },
    Range { from: 'Ὺ', to: 'Ὺ', mapping: Mapped("ὺ") },
    Range { from: 'Ύ', to: 'Ύ', mapping: Mapped("ύ") },
    Range { from: 'Ῥ', to: 'Ῥ', mapping: Mapped("ῥ") },
    Range { from: '῭', to: '῭', mapping: DisallowedStd3Mapped(" ̈̀") },
    Range { from: '΅', to: '΅', mapping: DisallowedStd3Mapped(" ̈́") },
    Range { from: '`', to: '`', mapping: DisallowedStd3Mapped("`") },
    Range { from: '῰', to: '῱', mapping: Disallowed },
    Range { from: 'ῲ', to: 'ῲ', mapping: Mapped("ὼι") },
    Range { from: 'ῳ', to: 'ῳ', mapping: Mapped("ωι") },
    Range { from: 'ῴ', to: 'ῴ', mapping: Mapped("ώι") },
    Range { from: '῵', to: '῵', mapping: Disallowed },
    Range { from: 'ῶ', to: 'ῶ', mapping: Valid },
    Range { from: 'ῷ', to: 'ῷ', mapping: Mapped("ῶι") },
    Range { from: 'Ὸ', to: 'Ὸ', mapping: Mapped("ὸ") },
    Range { from: 'Ό', to: 'Ό', mapping: Mapped("ό") },
    Range { from: 'Ὼ', to: 'Ὼ', mapping: Mapped("ὼ") },
    Range { from: 'Ώ', to: 'Ώ', mapping: Mapped("ώ") },
    Range { from: 'ῼ', to: 'ῼ', mapping: Mapped("ωι") },
    Range { from: '´', to: '´', mapping: DisallowedStd3Mapped(" ́") },
    Range { from: '῾', to: '῾', mapping: DisallowedStd3Mapped(" ̔") },
    Range { from: '῿', to: '῿', mapping: Disallowed },
    Range { from: ' ', to: ' ', mapping: DisallowedStd3Mapped(" ") },
    Range { from: '​', to: '​', mapping: Ignored },
    Range { from: '‌', to: '‍', mapping: Deviation("") },
    Range { from: '‎', to: '‏', mapping: Disallowed },
    Range { from: '‐', to: '‐', mapping: Valid },
    Range { from: '‑', to: '‑', mapping: Mapped("‐") },
    Range { from: '‒', to: '‖', mapping: Valid },
    Range { from: '‗', to: '‗', mapping: DisallowedStd3Mapped(" ̳") },
    Range { from: '‘', to: '‣', mapping: Valid },
    Range { from: '․', to: '…', mapping: Disallowed },
    Range { from: '‧', to: '‧', mapping: Valid },
    Range { from: ' ', to: '‮', mapping: Disallowed },
    Range { from: ' ', to: ' ', mapping: DisallowedStd3Mapped(" ") },
    Range { from: '‰', to: '′', mapping: Valid },
    Range { from: '″', to: '″', mapping: Mapped("′′") },
    Range { from: '‴', to: '‴', mapping: Mapped("′′′") },
    Range { from: '‵', to: '‵', mapping: Valid },
    Range { from: '‶', to: '‶', mapping: Mapped("‵‵") },
    Range { from: '‷', to: '‷', mapping: Mapped("‵‵‵") },
    Range { from: '‸', to: '※', mapping: Valid },
    Range { from: '‼', to: '‼', mapping: DisallowedStd3Mapped("!!") },
    Range { from: '‽', to: '‽', mapping: Valid },
    Range { from: '‾', to: '‾', mapping: DisallowedStd3Mapped(" ̅") },
    Range { from: '‿', to: '⁆', mapping: Valid },
    Range { from: '⁇', to: '⁇', mapping: DisallowedStd3Mapped("??") },
    Range { from: '⁈', to: '⁈', mapping: DisallowedStd3Mapped("?!") },
    Range { from: '⁉', to: '⁉', mapping: DisallowedStd3Mapped("!?") },
    Range { from: '⁊', to: '⁍', mapping: Valid },
    Range { from: '⁎', to: '⁒', mapping: Valid },
    Range { from: '⁓', to: '⁔', mapping: Valid },
    Range { from: '⁕', to: '⁖', mapping: Valid },
    Range { from: '⁗', to: '⁗', mapping: Mapped("′′′′") },
    Range { from: '⁘', to: '⁞', mapping: Valid },
    Range { from: ' ', to: ' ', mapping: DisallowedStd3Mapped(" ") },
    Range { from: '⁠', to: '⁠', mapping: Ignored },
    Range { from: '⁡', to: '⁣', mapping: Disallowed },
    Range { from: '⁤', to: '⁤', mapping: Ignored },
    Range { from: '⁥', to: '⁥', mapping: Disallowed },
    Range { from: '⁦', to: '⁩', mapping: Disallowed },
    Range { from: '⁪', to: '⁯', mapping: Disallowed },
    Range { from: '⁰', to: '⁰', mapping: Mapped("0") },
    Range { from: 'ⁱ', to: 'ⁱ', mapping: Mapped("i") },
    Range { from: '⁲', to: '⁳', mapping: Disallowed },
    Range { from: '⁴', to: '⁴', mapping: Mapped("4") },
    Range { from: '⁵', to: '⁵', mapping: Mapped("5") },
    Range { from: '⁶', to: '⁶', mapping: Mapped("6") },
    Range { from: '⁷', to: '⁷', mapping: Mapped("7") },
    Range { from: '⁸', to: '⁸', mapping: Mapped("8") },
    Range { from: '⁹', to: '⁹', mapping: Mapped("9") },
    Range { from: '⁺', to: '⁺', mapping: DisallowedStd3Mapped("+") },
    Range { from: '⁻', to: '⁻', mapping: Mapped("−") },
    Range { from: '⁼', to: '⁼', mapping: DisallowedStd3Mapped("=") },
    Range { from: '⁽', to: '⁽', mapping: DisallowedStd3Mapped("(") },
    Range { from: '⁾', to: '⁾', mapping: DisallowedStd3Mapped(")") },
    Range { from: 'ⁿ', to: 'ⁿ', mapping: Mapped("n") },
    Range { from: '₀', to: '₀', mapping: Mapped("0") },
    Range { from: '₁', to: '₁', mapping: Mapped("1") },
    Range { from: '₂', to: '₂', mapping: Mapped("2") },
    Range { from: '₃', to: '₃', mapping: Mapped("3") },
    Range { from: '₄', to: '₄', mapping: Mapped("4") },
    Range { from: '₅', to: '₅', mapping: Mapped("5") },
    Range { from: '₆', to: '₆', mapping: Mapped("6") },
    Range { from: '₇', to: '₇', mapping: Mapped("7") },
    Range { from: '₈', to: '₈', mapping: Mapped("8") },
    Range { from: '₉', to: '₉', mapping: Mapped("9") },
    Range { from: '₊', to: '₊', mapping: DisallowedStd3Mapped("+") },
    Range { from: '₋', to: '₋', mapping: Mapped("−") },
    Range { from: '₌', to: '₌', mapping: DisallowedStd3Mapped("=") },
    Range { from: '₍', to: '₍', mapping: DisallowedStd3Mapped("(") },
    Range { from: '₎', to: '₎', mapping: DisallowedStd3Mapped(")") },
    Range { from: '₏', to: '₏', mapping: Disallowed },
    Range { from: 'ₐ', to: 'ₐ', mapping: Mapped("a") },
    Range { from: 'ₑ', to: 'ₑ', mapping: Mapped("e") },
    Range { from: 'ₒ', to: 'ₒ', mapping: Mapped("o") },
    Range { from: 'ₓ', to: 'ₓ', mapping: Mapped("x") },
    Range { from: 'ₔ', to: 'ₔ', mapping: Mapped("ə") },
    Range { from: 'ₕ', to: 'ₕ', mapping: Mapped("h") },
    Range { from: 'ₖ', to: 'ₖ', mapping: Mapped("k") },
    Range { from: 'ₗ', to: 'ₗ', mapping: Mapped("l") },
    Range { from: 'ₘ', to: 'ₘ', mapping: Mapped("m") },
    Range { from: 'ₙ', to: 'ₙ', mapping: Mapped("n") },
    Range { from: 'ₚ', to: 'ₚ', mapping: Mapped("p") },
    Range { from: 'ₛ', to: 'ₛ', mapping: Mapped("s") },
    Range { from: 'ₜ', to: 'ₜ', mapping: Mapped("t") },
    Range { from: '₝', to: '₟', mapping: Disallowed },
    Range { from: '₠', to: '₧', mapping: Valid },
    Range { from: '₨', to: '₨', mapping: Mapped("rs") },
    Range { from: '₩', to: '₪', mapping: Valid },
    Range { from: '₫', to: '₫', mapping: Valid },
    Range { from: '€', to: '€', mapping: Valid },
    Range { from: '₭', to: '₯', mapping: Valid },
    Range { from: '₰', to: '₱', mapping: Valid },
    Range { from: '₲', to: '₵', mapping: Valid },
    Range { from: '₶', to: '₸', mapping: Valid },
    Range { from: '₹', to: '₹', mapping: Valid },
    Range { from: '₺', to: '₺', mapping: Valid },
    Range { from: '₻', to: '₽', mapping: Valid },
    Range { from: '₾', to: '₾', mapping: Valid },
    Range { from: '₿', to: '⃏', mapping: Disallowed },
    Range { from: '⃐', to: '⃡', mapping: Valid },
    Range { from: '⃢', to: '⃣', mapping: Valid },
    Range { from: '⃤', to: '⃪', mapping: Valid },
    Range { from: '⃫', to: '⃫', mapping: Valid },
    Range { from: '⃬', to: '⃯', mapping: Valid },
    Range { from: '⃰', to: '⃰', mapping: Valid },
    Range { from: '⃱', to: '⃿', mapping: Disallowed },
    Range { from: '℀', to: '℀', mapping: DisallowedStd3Mapped("a/c") },
    Range { from: '℁', to: '℁', mapping: DisallowedStd3Mapped("a/s") },
    Range { from: 'ℂ', to: 'ℂ', mapping: Mapped("c") },
    Range { from: '℃', to: '℃', mapping: Mapped("°c") },
    Range { from: '℄', to: '℄', mapping: Valid },
    Range { from: '℅', to: '℅', mapping: DisallowedStd3Mapped("c/o") },
    Range { from: '℆', to: '℆', mapping: DisallowedStd3Mapped("c/u") },
    Range { from: 'ℇ', to: 'ℇ', mapping: Mapped("ɛ") },
    Range { from: '℈', to: '℈', mapping: Valid },
    Range { from: '℉', to: '℉', mapping: Mapped("°f") },
    Range { from: 'ℊ', to: 'ℊ', mapping: Mapped("g") },
    Range { from: 'ℋ', to: 'ℎ', mapping: Mapped("h") },
    Range { from: 'ℏ', to: 'ℏ', mapping: Mapped("ħ") },
    Range { from: 'ℐ', to: 'ℑ', mapping: Mapped("i") },
    Range { from: 'ℒ', to: 'ℓ', mapping: Mapped("l") },
    Range { from: '℔', to: '℔', mapping: Valid },
    Range { from: 'ℕ', to: 'ℕ', mapping: Mapped("n") },
    Range { from: '№', to: '№', mapping: Mapped("no") },
    Range { from: '℗', to: '℘', mapping: Valid },
    Range { from: 'ℙ', to: 'ℙ', mapping: Mapped("p") },
    Range { from: 'ℚ', to: 'ℚ', mapping: Mapped("q") },
    Range { from: 'ℛ', to: 'ℝ', mapping: Mapped("r") },
    Range { from: '℞', to: '℟', mapping: Valid },
    Range { from: '℠', to: '℠', mapping: Mapped("sm") },
    Range { from: '℡', to: '℡', mapping: Mapped("tel") },
    Range { from: '™', to: '™', mapping: Mapped("tm") },
    Range { from: '℣', to: '℣', mapping: Valid },
    Range { from: 'ℤ', to: 'ℤ', mapping: Mapped("z") },
    Range { from: '℥', to: '℥', mapping: Valid },
    Range { from: 'Ω', to: 'Ω', mapping: Mapped("ω") },
    Range { from: '℧', to: '℧', mapping: Valid },
    Range { from: 'ℨ', to: 'ℨ', mapping: Mapped("z") },
    Range { from: '℩', to: '℩', mapping: Valid },
    Range { from: 'K', to: 'K', mapping: Mapped("k") },
    Range { from: 'Å', to: 'Å', mapping: Mapped("å") },
    Range { from: 'ℬ', to: 'ℬ', mapping: Mapped("b") },
    Range { from: 'ℭ', to: 'ℭ', mapping: Mapped("c") },
    Range { from: '℮', to: '℮', mapping: Valid },
    Range { from: 'ℯ', to: 'ℰ', mapping: Mapped("e") },
    Range { from: 'ℱ', to: 'ℱ', mapping: Mapped("f") },
    Range { from: 'Ⅎ', to: 'Ⅎ', mapping: Disallowed },
    Range { from: 'ℳ', to: 'ℳ', mapping: Mapped("m") },
    Range { from: 'ℴ', to: 'ℴ', mapping: Mapped("o") },
    Range { from: 'ℵ', to: 'ℵ', mapping: Mapped("א") },
    Range { from: 'ℶ', to: 'ℶ', mapping: Mapped("ב") },
    Range { from: 'ℷ', to: 'ℷ', mapping: Mapped("ג") },
    Range { from: 'ℸ', to: 'ℸ', mapping: Mapped("ד") },
    Range { from: 'ℹ', to: 'ℹ', mapping: Mapped("i") },
    Range { from: '℺', to: '℺', mapping: Valid },
    Range { from: '℻', to: '℻', mapping: Mapped("fax") },
    Range { from: 'ℼ', to: 'ℼ', mapping: Mapped("π") },
    Range { from: 'ℽ', to: 'ℾ', mapping: Mapped("γ") },
    Range { from: 'ℿ', to: 'ℿ', mapping: Mapped("π") },
    Range { from: '⅀', to: '⅀', mapping: Mapped("∑") },
    Range { from: '⅁', to: '⅄', mapping: Valid },
    Range { from: 'ⅅ', to: 'ⅆ', mapping: Mapped("d") },
    Range { from: 'ⅇ', to: 'ⅇ', mapping: Mapped("e") },
    Range { from: 'ⅈ', to: 'ⅈ', mapping: Mapped("i") },
    Range { from: 'ⅉ', to: 'ⅉ', mapping: Mapped("j") },
    Range { from: '⅊', to: '⅋', mapping: Valid },
    Range { from: '⅌', to: '⅌', mapping: Valid },
    Range { from: '⅍', to: '⅍', mapping: Valid },
    Range { from: 'ⅎ', to: 'ⅎ', mapping: Valid },
    Range { from: '⅏', to: '⅏', mapping: Valid },
    Range { from: '⅐', to: '⅐', mapping: Mapped("1⁄7") },
    Range { from: '⅑', to: '⅑', mapping: Mapped("1⁄9") },
    Range { from: '⅒', to: '⅒', mapping: Mapped("1⁄10") },
    Range { from: '⅓', to: '⅓', mapping: Mapped("1⁄3") },
    Range { from: '⅔', to: '⅔', mapping: Mapped("2⁄3") },
    Range { from: '⅕', to: '⅕', mapping: Mapped("1⁄5") },
    Range { from: '⅖', to: '⅖', mapping: Mapped("2⁄5") },
    Range { from: '⅗', to: '⅗', mapping: Mapped("3⁄5") },
    Range { from: '⅘', to: '⅘', mapping: Mapped("4⁄5") },
    Range { from: '⅙', to: '⅙', mapping: Mapped("1⁄6") },
    Range { from: '⅚', to: '⅚', mapping: Mapped("5⁄6") },
    Range { from: '⅛', to: '⅛', mapping: Mapped("1⁄8") },
    Range { from: '⅜', to: '⅜', mapping: Mapped("3⁄8") },
    Range { from: '⅝', to: '⅝', mapping: Mapped("5⁄8") },
    Range { from: '⅞', to: '⅞', mapping: Mapped("7⁄8") },
    Range { from: '⅟', to: '⅟', mapping: Mapped("1⁄") },
    Range { from: 'Ⅰ', to: 'Ⅰ', mapping: Mapped("i") },
    Range { from: 'Ⅱ', to: 'Ⅱ', mapping: Mapped("ii") },
    Range { from: 'Ⅲ', to: 'Ⅲ', mapping: Mapped("iii") },
    Range { from: 'Ⅳ', to: 'Ⅳ', mapping: Mapped("iv") },
    Range { from: 'Ⅴ', to: 'Ⅴ', mapping: Mapped("v") },
    Range { from: 'Ⅵ', to: 'Ⅵ', mapping: Mapped("vi") },
    Range { from: 'Ⅶ', to: 'Ⅶ', mapping: Mapped("vii") },
    Range { from: 'Ⅷ', to: 'Ⅷ', mapping: Mapped("viii") },
    Range { from: 'Ⅸ', to: 'Ⅸ', mapping: Mapped("ix") },
    Range { from: 'Ⅹ', to: 'Ⅹ', mapping: Mapped("x") },
    Range { from: 'Ⅺ', to: 'Ⅺ', mapping: Mapped("xi") },
    Range { from: 'Ⅻ', to: 'Ⅻ', mapping: Mapped("xii") },
    Range { from: 'Ⅼ', to: 'Ⅼ', mapping: Mapped("l") },
    Range { from: 'Ⅽ', to: 'Ⅽ', mapping: Mapped("c") },
    Range { from: 'Ⅾ', to: 'Ⅾ', mapping: Mapped("d") },
    Range { from: 'Ⅿ', to: 'Ⅿ', mapping: Mapped("m") },
    Range { from: 'ⅰ', to: 'ⅰ', mapping: Mapped("i") },
    Range { from: 'ⅱ', to: 'ⅱ', mapping: Mapped("ii") },
    Range { from: 'ⅲ', to: 'ⅲ', mapping: Mapped("iii") },
    Range { from: 'ⅳ', to: 'ⅳ', mapping: Mapped("iv") },
    Range { from: 'ⅴ', to: 'ⅴ', mapping: Mapped("v") },
    Range { from: 'ⅵ', to: 'ⅵ', mapping: Mapped("vi") },
    Range { from: 'ⅶ', to: 'ⅶ', mapping: Mapped("vii") },
    Range { from: 'ⅷ', to: 'ⅷ', mapping: Mapped("viii") },
    Range { from: 'ⅸ', to: 'ⅸ', mapping: Mapped("ix") },
    Range { from: 'ⅹ', to: 'ⅹ', mapping: Mapped("x") },
    Range { from: 'ⅺ', to: 'ⅺ', mapping: Mapped("xi") },
    Range { from: 'ⅻ', to: 'ⅻ', mapping: Mapped("xii") },
    Range { from: 'ⅼ', to: 'ⅼ', mapping: Mapped("l") },
    Range { from: 'ⅽ', to: 'ⅽ', mapping: Mapped("c") },
    Range { from: 'ⅾ', to: 'ⅾ', mapping: Mapped("d") },
    Range { from: 'ⅿ', to: 'ⅿ', mapping: Mapped("m") },
    Range { from: 'ↀ', to: 'ↂ', mapping: Valid },
    Range { from: 'Ↄ', to: 'Ↄ', mapping: Disallowed },
    Range { from: 'ↄ', to: 'ↄ', mapping: Valid },
    Range { from: 'ↅ', to: 'ↈ', mapping: Valid },
    Range { from: '↉', to: '↉', mapping: Mapped("0⁄3") },
    Range { from: '↊', to: '↋', mapping: Valid },
    Range { from: '↌', to: '↏', mapping: Disallowed },
    Range { from: '←', to: '⇪', mapping: Valid },
    Range { from: '⇫', to: '⇳', mapping: Valid },
    Range { from: '⇴', to: '⇿', mapping: Valid },
    Range { from: '∀', to: '∫', mapping: Valid },
    Range { from: '∬', to: '∬', mapping: Mapped("∫∫") },
    Range { from: '∭', to: '∭', mapping: Mapped("∫∫∫") },
    Range { from: '∮', to: '∮', mapping: Valid },
    Range { from: '∯', to: '∯', mapping: Mapped("∮∮") },
    Range { from: '∰', to: '∰', mapping: Mapped("∮∮∮") },
    Range { from: '∱', to: '≟', mapping: Valid },
    Range { from: '≠', to: '≠', mapping: DisallowedStd3Valid },
    Range { from: '≡', to: '≭', mapping: Valid },
    Range { from: '≮', to: '≯', mapping: DisallowedStd3Valid },
    Range { from: '≰', to: '⋱', mapping: Valid },
    Range { from: '⋲', to: '⋿', mapping: Valid },
    Range { from: '⌀', to: '⌀', mapping: Valid },
    Range { from: '⌁', to: '⌁', mapping: Valid },
    Range { from: '⌂', to: '⌨', mapping: Valid },
    Range { from: '〈', to: '〈', mapping: Mapped("〈") },
    Range { from: '〉', to: '〉', mapping: Mapped("〉") },
    Range { from: '⌫', to: '⍺', mapping: Valid },
    Range { from: '⍻', to: '⍻', mapping: Valid },
    Range { from: '⍼', to: '⍼', mapping: Valid },
    Range { from: '⍽', to: '⎚', mapping: Valid },
    Range { from: '⎛', to: '⏎', mapping: Valid },
    Range { from: '⏏', to: '⏐', mapping: Valid },
    Range { from: '⏑', to: '⏛', mapping: Valid },
    Range { from: '⏜', to: '⏧', mapping: Valid },
    Range { from: '⏨', to: '⏨', mapping: Valid },
    Range { from: '⏩', to: '⏳', mapping: Valid },
    Range { from: '⏴', to: '⏺', mapping: Valid },
    Range { from: '⏻', to: '⏿', mapping: Disallowed },
    Range { from: '␀', to: '␤', mapping: Valid },
    Range { from: '␥', to: '␦', mapping: Valid },
    Range { from: '␧', to: '␿', mapping: Disallowed },
    Range { from: '⑀', to: '⑊', mapping: Valid },
    Range { from: '⑋', to: '⑟', mapping: Disallowed },
    Range { from: '①', to: '①', mapping: Mapped("1") },
    Range { from: '②', to: '②', mapping: Mapped("2") },
    Range { from: '③', to: '③', mapping: Mapped("3") },
    Range { from: '④', to: '④', mapping: Mapped("4") },
    Range { from: '⑤', to: '⑤', mapping: Mapped("5") },
    Range { from: '⑥', to: '⑥', mapping: Mapped("6") },
    Range { from: '⑦', to: '⑦', mapping: Mapped("7") },
    Range { from: '⑧', to: '⑧', mapping: Mapped("8") },
    Range { from: '⑨', to: '⑨', mapping: Mapped("9") },
    Range { from: '⑩', to: '⑩', mapping: Mapped("10") },
    Range { from: '⑪', to: '⑪', mapping: Mapped("11") },
    Range { from: '⑫', to: '⑫', mapping: Mapped("12") },
    Range { from: '⑬', to: '⑬', mapping: Mapped("13") },
    Range { from: '⑭', to: '⑭', mapping: Mapped("14") },
    Range { from: '⑮', to: '⑮', mapping: Mapped("15") },
    Range { from: '⑯', to: '⑯', mapping: Mapped("16") },
    Range { from: '⑰', to: '⑰', mapping: Mapped("17") },
    Range { from: '⑱', to: '⑱', mapping: Mapped("18") },
    Range { from: '⑲', to: '⑲', mapping: Mapped("19") },
    Range { from: '⑳', to: '⑳', mapping: Mapped("20") },
    Range { from: '⑴', to: '⑴', mapping: DisallowedStd3Mapped("(1)") },
    Range { from: '⑵', to: '⑵', mapping: DisallowedStd3Mapped("(2)") },
    Range { from: '⑶', to: '⑶', mapping: DisallowedStd3Mapped("(3)") },
    Range { from: '⑷', to: '⑷', mapping: DisallowedStd3Mapped("(4)") },
    Range { from: '⑸', to: '⑸', mapping: DisallowedStd3Mapped("(5)") },
    Range { from: '⑹', to: '⑹', mapping: DisallowedStd3Mapped("(6)") },
    Range { from: '⑺', to: '⑺', mapping: DisallowedStd3Mapped("(7)") },
    Range { from: '⑻', to: '⑻', mapping: DisallowedStd3Mapped("(8)") },
    Range { from: '⑼', to: '⑼', mapping: DisallowedStd3Mapped("(9)") },
    Range { from: '⑽', to: '⑽', mapping: DisallowedStd3Mapped("(10)") },
    Range { from: '⑾', to: '⑾', mapping: DisallowedStd3Mapped("(11)") },
    Range { from: '⑿', to: '⑿', mapping: DisallowedStd3Mapped("(12)") },
    Range { from: '⒀', to: '⒀', mapping: DisallowedStd3Mapped("(13)") },
    Range { from: '⒁', to: '⒁', mapping: DisallowedStd3Mapped("(14)") },
    Range { from: '⒂', to: '⒂', mapping: DisallowedStd3Mapped("(15)") },
    Range { from: '⒃', to: '⒃', mapping: DisallowedStd3Mapped("(16)") },
    Range { from: '⒄', to: '⒄', mapping: DisallowedStd3Mapped("(17)") },
    Range { from: '⒅', to: '⒅', mapping: DisallowedStd3Mapped("(18)") },
    Range { from: '⒆', to: '⒆', mapping: DisallowedStd3Mapped("(19)") },
    Range { from: '⒇', to: '⒇', mapping: DisallowedStd3Mapped("(20)") },
    Range { from: '⒈', to: '⒛', mapping: Disallowed },
    Range { from: '⒜', to: '⒜', mapping: DisallowedStd3Mapped("(a)") },
    Range { from: '⒝', to: '⒝', mapping: DisallowedStd3Mapped("(b)") },
    Range { from: '⒞', to: '⒞', mapping: DisallowedStd3Mapped("(c)") },
    Range { from: '⒟', to: '⒟', mapping: DisallowedStd3Mapped("(d)") },
    Range { from: '⒠', to: '⒠', mapping: DisallowedStd3Mapped("(e)") },
    Range { from: '⒡', to: '⒡', mapping: DisallowedStd3Mapped("(f)") },
    Range { from: '⒢', to: '⒢', mapping: DisallowedStd3Mapped("(g)") },
    Range { from: '⒣', to: '⒣', mapping: DisallowedStd3Mapped("(h)") },
    Range { from: '⒤', to: '⒤', mapping: DisallowedStd3Mapped("(i)") },
    Range { from: '⒥', to: '⒥', mapping: DisallowedStd3Mapped("(j)") },
    Range { from: '⒦', to: '⒦', mapping: DisallowedStd3Mapped("(k)") },
    Range { from: '⒧', to: '⒧', mapping: DisallowedStd3Mapped("(l)") },
    Range { from: '⒨', to: '⒨', mapping: DisallowedStd3Mapped("(m)") },
    Range { from: '⒩', to: '⒩', mapping: DisallowedStd3Mapped("(n)") },
    Range { from: '⒪', to: '⒪', mapping: DisallowedStd3Mapped("(o)") },
    Range { from: '⒫', to: '⒫', mapping: DisallowedStd3Mapped("(p)") },
    Range { from: '⒬', to: '⒬', mapping: DisallowedStd3Mapped("(q)") },
    Range { from: '⒭', to: '⒭', mapping: DisallowedStd3Mapped("(r)") },
    Range { from: '⒮', to: '⒮', mapping: DisallowedStd3Mapped("(s)") },
    Range { from: '⒯', to: '⒯', mapping: DisallowedStd3Mapped("(t)") },
    Range { from: '⒰', to: '⒰', mapping: DisallowedStd3Mapped("(u)") },
    Range { from: '⒱', to: '⒱', mapping: DisallowedStd3Mapped("(v)") },
    Range { from: '⒲', to: '⒲', mapping: DisallowedStd3Mapped("(w)") },
    Range { from: '⒳', to: '⒳', mapping: DisallowedStd3Mapped("(x)") },
    Range { from: '⒴', to: '⒴', mapping: DisallowedStd3Mapped("(y)") },
    Range { from: '⒵', to: '⒵', mapping: DisallowedStd3Mapped("(z)") },
    Range { from: 'Ⓐ', to: 'Ⓐ', mapping: Mapped("a") },
    Range { from: 'Ⓑ', to: 'Ⓑ', mapping: Mapped("b") },
    Range { from: 'Ⓒ', to: 'Ⓒ', mapping: Mapped("c") },
    Range { from: 'Ⓓ', to: 'Ⓓ', mapping: Mapped("d") },
    Range { from: 'Ⓔ', to: 'Ⓔ', mapping: Mapped("e") },
    Range { from: 'Ⓕ', to: 'Ⓕ', mapping: Mapped("f") },
    Range { from: 'Ⓖ', to: 'Ⓖ', mapping: Mapped("g") },
    Range { from: 'Ⓗ', to: 'Ⓗ', mapping: Mapped("h") },
    Range { from: 'Ⓘ', to: 'Ⓘ', mapping: Mapped("i") },
    Range { from: 'Ⓙ', to: 'Ⓙ', mapping: Mapped("j") },
    Range { from: 'Ⓚ', to: 'Ⓚ', mapping: Mapped("k") },
    Range { from: 'Ⓛ', to: 'Ⓛ', mapping: Mapped("l") },
    Range { from: 'Ⓜ', to: 'Ⓜ', mapping: Mapped("m") },
    Range { from: 'Ⓝ', to: 'Ⓝ', mapping: Mapped("n") },
    Range { from: 'Ⓞ', to: 'Ⓞ', mapping: Mapped("o") },
    Range { from: 'Ⓟ', to: 'Ⓟ', mapping: Mapped("p") },
    Range { from: 'Ⓠ', to: 'Ⓠ', mapping: Mapped("q") },
    Range { from: 'Ⓡ', to: 'Ⓡ', mapping: Mapped("r") },
    Range { from: 'Ⓢ', to: 'Ⓢ', mapping: Mapped("s") },
    Range { from: 'Ⓣ', to: 'Ⓣ', mapping: Mapped("t") },
    Range { from: 'Ⓤ', to: 'Ⓤ', mapping: Mapped("u") },
    Range { from: 'Ⓥ', to: 'Ⓥ', mapping: Mapped("v") },
    Range { from: 'Ⓦ', to: 'Ⓦ', mapping: Mapped("w") },
    Range { from: 'Ⓧ', to: 'Ⓧ', mapping: Mapped("x") },
    Range { from: 'Ⓨ', to: 'Ⓨ', mapping: Mapped("y") },
    Range { from: 'Ⓩ', to: 'Ⓩ', mapping: Mapped("z") },
    Range { from: 'ⓐ', to: 'ⓐ', mapping: Mapped("a") },
    Range { from: 'ⓑ', to: 'ⓑ', mapping: Mapped("b") },
    Range { from: 'ⓒ', to: 'ⓒ', mapping: Mapped("c") },
    Range { from: 'ⓓ', to: 'ⓓ', mapping: Mapped("d") },
    Range { from: 'ⓔ', to: 'ⓔ', mapping: Mapped("e") },
    Range { from: 'ⓕ', to: 'ⓕ', mapping: Mapped("f") },
    Range { from: 'ⓖ', to: 'ⓖ', mapping: Mapped("g") },
    Range { from: 'ⓗ', to: 'ⓗ', mapping: Mapped("h") },
    Range { from: 'ⓘ', to: 'ⓘ', mapping: Mapped("i") },
    Range { from: 'ⓙ', to: 'ⓙ', mapping: Mapped("j") },
    Range { from: 'ⓚ', to: 'ⓚ', mapping: Mapped("k") },
    Range { from: 'ⓛ', to: 'ⓛ', mapping: Mapped("l") },
    Range { from: 'ⓜ', to: 'ⓜ', mapping: Mapped("m") },
    Range { from: 'ⓝ', to: 'ⓝ', mapping: Mapped("n") },
    Range { from: 'ⓞ', to: 'ⓞ', mapping: Mapped("o") },
    Range { from: 'ⓟ', to: 'ⓟ', mapping: Mapped("p") },
    Range { from: 'ⓠ', to: 'ⓠ', mapping: Mapped("q") },
    Range { from: 'ⓡ', to: 'ⓡ', mapping: Mapped("r") },
    Range { from: 'ⓢ', to: 'ⓢ', mapping: Mapped("s") },
    Range { from: 'ⓣ', to: 'ⓣ', mapping: Mapped("t") },
    Range { from: 'ⓤ', to: 'ⓤ', mapping: Mapped("u") },
    Range { from: 'ⓥ', to: 'ⓥ', mapping: Mapped("v") },
    Range { from: 'ⓦ', to: 'ⓦ', mapping: Mapped("w") },
    Range { from: 'ⓧ', to: 'ⓧ', mapping: Mapped("x") },
    Range { from: 'ⓨ', to: 'ⓨ', mapping: Mapped("y") },
    Range { from: 'ⓩ', to: 'ⓩ', mapping: Mapped("z") },
    Range { from: '⓪', to: '⓪', mapping: Mapped("0") },
    Range { from: '⓫', to: '⓾', mapping: Valid },
    Range { from: '⓿', to: '⓿', mapping: Valid },
    Range { from: '─', to: '▕', mapping: Valid },
    Range { from: '▖', to: '▟', mapping: Valid },
    Range { from: '■', to: '◯', mapping: Valid },
    Range { from: '◰', to: '◷', mapping: Valid },
    Range { from: '◸', to: '◿', mapping: Valid },
    Range { from: '☀', to: '☓', mapping: Valid },
    Range { from: '☔', to: '☕', mapping: Valid },
    Range { from: '☖', to: '☗', mapping: Valid },
    Range { from: '☘', to: '☘', mapping: Valid },
    Range { from: '☙', to: '☙', mapping: Valid },
    Range { from: '☚', to: '♯', mapping: Valid },
    Range { from: '♰', to: '♱', mapping: Valid },
    Range { from: '♲', to: '♽', mapping: Valid },
    Range { from: '♾', to: '♿', mapping: Valid },
    Range { from: '⚀', to: '⚉', mapping: Valid },
    Range { from: '⚊', to: '⚑', mapping: Valid },
    Range { from: '⚒', to: '⚜', mapping: Valid },
    Range { from: '⚝', to: '⚝', mapping: Valid },
    Range { from: '⚞', to: '⚟', mapping: Valid },
    Range { from: '⚠', to: '⚡', mapping: Valid },
    Range { from: '⚢', to: '⚱', mapping: Valid },
    Range { from: '⚲', to: '⚲', mapping: Valid },
    Range { from: '⚳', to: '⚼', mapping: Valid },
    Range { from: '⚽', to: '⚿', mapping: Valid },
    Range { from: '⛀', to: '⛃', mapping: Valid },
    Range { from: '⛄', to: '⛍', mapping: Valid },
    Range { from: '⛎', to: '⛎', mapping: Valid },
    Range { from: '⛏', to: '⛡', mapping: Valid },
    Range { from: '⛢', to: '⛢', mapping: Valid },
    Range { from: '⛣', to: '⛣', mapping: Valid },
    Range { from: '⛤', to: '⛧', mapping: Valid },
    Range { from: '⛨', to: '⛿', mapping: Valid },
    Range { from: '✀', to: '✀', mapping: Valid },
    Range { from: '✁', to: '✄', mapping: Valid },
    Range { from: '✅', to: '✅', mapping: Valid },
    Range { from: '✆', to: '✉', mapping: Valid },
    Range { from: '✊', to: '✋', mapping: Valid },
    Range { from: '✌', to: '✧', mapping: Valid },
    Range { from: '✨', to: '✨', mapping: Valid },
    Range { from: '✩', to: '❋', mapping: Valid },
    Range { from: '❌', to: '❌', mapping: Valid },
    Range { from: '❍', to: '❍', mapping: Valid },
    Range { from: '❎', to: '❎', mapping: Valid },
    Range { from: '❏', to: '❒', mapping: Valid },
    Range { from: '❓', to: '❕', mapping: Valid },
    Range { from: '❖', to: '❖', mapping: Valid },
    Range { from: '❗', to: '❗', mapping: Valid },
    Range { from: '❘', to: '❞', mapping: Valid },
    Range { from: '❟', to: '❠', mapping: Valid },
    Range { from: '❡', to: '❧', mapping: Valid },
    Range { from: '❨', to: '❵', mapping: Valid },
    Range { from: '❶', to: '➔', mapping: Valid },
    Range { from: '➕', to: '➗', mapping: Valid },
    Range { from: '➘', to: '➯', mapping: Valid },
    Range { from: '➰', to: '➰', mapping: Valid },
    Range { from: '➱', to: '➾', mapping: Valid },
    Range { from: '➿', to: '➿', mapping: Valid },
    Range { from: '⟀', to: '⟆', mapping: Valid },
    Range { from: '⟇', to: '⟊', mapping: Valid },
    Range { from: '⟋', to: '⟋', mapping: Valid },
    Range { from: '⟌', to: '⟌', mapping: Valid },
    Range { from: '⟍', to: '⟍', mapping: Valid },
    Range { from: '⟎', to: '⟏', mapping: Valid },
    Range { from: '⟐', to: '⟫', mapping: Valid },
    Range { from: '⟬', to: '⟯', mapping: Valid },
    Range { from: '⟰', to: '⟿', mapping: Valid },
    Range { from: '⠀', to: '⣿', mapping: Valid },
    Range { from: '⤀', to: '⨋', mapping: Valid },
    Range { from: '⨌', to: '⨌', mapping: Mapped("∫∫∫∫") },
    Range { from: '⨍', to: '⩳', mapping: Valid },
    Range { from: '⩴', to: '⩴', mapping: DisallowedStd3Mapped("::=") },
    Range { from: '⩵', to: '⩵', mapping: DisallowedStd3Mapped("==") },
    Range { from: '⩶', to: '⩶', mapping: DisallowedStd3Mapped("===") },
    Range { from: '⩷', to: '⫛', mapping: Valid },
    Range { from: '⫝̸', to: '⫝̸', mapping: Mapped("⫝̸") },
    Range { from: '⫝', to: '⫿', mapping: Valid },
    Range { from: '⬀', to: '⬍', mapping: Valid },
    Range { from: '⬎', to: '⬓', mapping: Valid },
    Range { from: '⬔', to: '⬚', mapping: Valid },
    Range { from: '⬛', to: '⬟', mapping: Valid },
    Range { from: '⬠', to: '⬣', mapping: Valid },
    Range { from: '⬤', to: '⭌', mapping: Valid },
    Range { from: '⭍', to: '⭏', mapping: Valid },
    Range { from: '⭐', to: '⭔', mapping: Valid },
    Range { from: '⭕', to: '⭙', mapping: Valid },
    Range { from: '⭚', to: '⭳', mapping: Valid },
    Range { from: '⭴', to: '⭵', mapping: Disallowed },
    Range { from: '⭶', to: '⮕', mapping: Valid },
    Range { from: '⮖', to: '⮗', mapping: Disallowed },
    Range { from: '⮘', to: '⮹', mapping: Valid },
    Range { from: '⮺', to: '⮼', mapping: Disallowed },
    Range { from: '⮽', to: '⯈', mapping: Valid },
    Range { from: '⯉', to: '⯉', mapping: Disallowed },
    Range { from: '⯊', to: '⯑', mapping: Valid },
    Range { from: '⯒', to: '⯫', mapping: Disallowed },
    Range { from: '⯬', to: '⯯', mapping: Valid },
    Range { from: '⯰', to: '⯿', mapping: Disallowed },
    Range { from: 'Ⰰ', to: 'Ⰰ', mapping: Mapped("ⰰ") },
    Range { from: 'Ⰱ', to: 'Ⰱ', mapping: Mapped("ⰱ") },
    Range { from: 'Ⰲ', to: 'Ⰲ', mapping: Mapped("ⰲ") },
    Range { from: 'Ⰳ', to: 'Ⰳ', mapping: Mapped("ⰳ") },
    Range { from: 'Ⰴ', to: 'Ⰴ', mapping: Mapped("ⰴ") },
    Range { from: 'Ⰵ', to: 'Ⰵ', mapping: Mapped("ⰵ") },
    Range { from: 'Ⰶ', to: 'Ⰶ', mapping: Mapped("ⰶ") },
    Range { from: 'Ⰷ', to: 'Ⰷ', mapping: Mapped("ⰷ") },
    Range { from: 'Ⰸ', to: 'Ⰸ', mapping: Mapped("ⰸ") },
    Range { from: 'Ⰹ', to: 'Ⰹ', mapping: Mapped("ⰹ") },
    Range { from: 'Ⰺ', to: 'Ⰺ', mapping: Mapped("ⰺ") },
    Range { from: 'Ⰻ', to: 'Ⰻ', mapping: Mapped("ⰻ") },
    Range { from: 'Ⰼ', to: 'Ⰼ', mapping: Mapped("ⰼ") },
    Range { from: 'Ⰽ', to: 'Ⰽ', mapping: Mapped("ⰽ") },
    Range { from: 'Ⰾ', to: 'Ⰾ', mapping: Mapped("ⰾ") },
    Range { from: 'Ⰿ', to: 'Ⰿ', mapping: Mapped("ⰿ") },
    Range { from: 'Ⱀ', to: 'Ⱀ', mapping: Mapped("ⱀ") },
    Range { from: 'Ⱁ', to: 'Ⱁ', mapping: Mapped("ⱁ") },
    Range { from: 'Ⱂ', to: 'Ⱂ', mapping: Mapped("ⱂ") },
    Range { from: 'Ⱃ', to: 'Ⱃ', mapping: Mapped("ⱃ") },
    Range { from: 'Ⱄ', to: 'Ⱄ', mapping: Mapped("ⱄ") },
    Range { from: 'Ⱅ', to: 'Ⱅ', mapping: Mapped("ⱅ") },
    Range { from: 'Ⱆ', to: 'Ⱆ', mapping: Mapped("ⱆ") },
    Range { from: 'Ⱇ', to: 'Ⱇ', mapping: Mapped("ⱇ") },
    Range { from: 'Ⱈ', to: 'Ⱈ', mapping: Mapped("ⱈ") },
    Range { from: 'Ⱉ', to: 'Ⱉ', mapping: Mapped("ⱉ") },
    Range { from: 'Ⱊ', to: 'Ⱊ', mapping: Mapped("ⱊ") },
    Range { from: 'Ⱋ', to: 'Ⱋ', mapping: Mapped("ⱋ") },
    Range { from: 'Ⱌ', to: 'Ⱌ', mapping: Mapped("ⱌ") },
    Range { from: 'Ⱍ', to: 'Ⱍ', mapping: Mapped("ⱍ") },
    Range { from: 'Ⱎ', to: 'Ⱎ', mapping: Mapped("ⱎ") },
    Range { from: 'Ⱏ', to: 'Ⱏ', mapping: Mapped("ⱏ") },
    Range { from: 'Ⱐ', to: 'Ⱐ', mapping: Mapped("ⱐ") },
    Range { from: 'Ⱑ', to: 'Ⱑ', mapping: Mapped("ⱑ") },
    Range { from: 'Ⱒ', to: 'Ⱒ', mapping: Mapped("ⱒ") },
    Range { from: 'Ⱓ', to: 'Ⱓ', mapping: Mapped("ⱓ") },
    Range { from: 'Ⱔ', to: 'Ⱔ', mapping: Mapped("ⱔ") },
    Range { from: 'Ⱕ', to: 'Ⱕ', mapping: Mapped("ⱕ") },
    Range { from: 'Ⱖ', to: 'Ⱖ', mapping: Mapped("ⱖ") },
    Range { from: 'Ⱗ', to: 'Ⱗ', mapping: Mapped("ⱗ") },
    Range { from: 'Ⱘ', to: 'Ⱘ', mapping: Mapped("ⱘ") },
    Range { from: 'Ⱙ', to: 'Ⱙ', mapping: Mapped("ⱙ") },
    Range { from: 'Ⱚ', to: 'Ⱚ', mapping: Mapped("ⱚ") },
    Range { from: 'Ⱛ', to: 'Ⱛ', mapping: Mapped("ⱛ") },
    Range { from: 'Ⱜ', to: 'Ⱜ', mapping: Mapped("ⱜ") },
    Range { from: 'Ⱝ', to: 'Ⱝ', mapping: Mapped("ⱝ") },
    Range { from: 'Ⱞ', to: 'Ⱞ', mapping: Mapped("ⱞ") },
    Range { from: 'Ⱟ', to: 'Ⱟ', mapping: Disallowed },
    Range { from: 'ⰰ', to: 'ⱞ', mapping: Valid },
    Range { from: 'ⱟ', to: 'ⱟ', mapping: Disallowed },
    Range { from: 'Ⱡ', to: 'Ⱡ', mapping: Mapped("ⱡ") },
    Range { from: 'ⱡ', to: 'ⱡ', mapping: Valid },
    Range { from: 'Ɫ', to: 'Ɫ', mapping: Mapped("ɫ") },
    Range { from: 'Ᵽ', to: 'Ᵽ', mapping: Mapped("ᵽ") },
    Range { from: 'Ɽ', to: 'Ɽ', mapping: Mapped("ɽ") },
    Range { from: 'ⱥ', to: 'ⱦ', mapping: Valid },
    Range { from: 'Ⱨ', to: 'Ⱨ', mapping: Mapped("ⱨ") },
    Range { from: 'ⱨ', to: 'ⱨ', mapping: Valid },
    Range { from: 'Ⱪ', to: 'Ⱪ', mapping: Mapped("ⱪ") },
    Range { from: 'ⱪ', to: 'ⱪ', mapping: Valid },
    Range { from: 'Ⱬ', to: 'Ⱬ', mapping: Mapped("ⱬ") },
    Range { from: 'ⱬ', to: 'ⱬ', mapping: Valid },
    Range { from: 'Ɑ', to: 'Ɑ', mapping: Mapped("ɑ") },
    Range { from: 'Ɱ', to: 'Ɱ', mapping: Mapped("ɱ") },
    Range { from: 'Ɐ', to: 'Ɐ', mapping: Mapped("ɐ") },
    Range { from: 'Ɒ', to: 'Ɒ', mapping: Mapped("ɒ") },
    Range { from: 'ⱱ', to: 'ⱱ', mapping: Valid },
    Range { from: 'Ⱳ', to: 'Ⱳ', mapping: Mapped("ⱳ") },
    Range { from: 'ⱳ', to: 'ⱳ', mapping: Valid },
    Range { from: 'ⱴ', to: 'ⱴ', mapping: Valid },
    Range { from: 'Ⱶ', to: 'Ⱶ', mapping: Mapped("ⱶ") },
    Range { from: 'ⱶ', to: 'ⱷ', mapping: Valid },
    Range { from: 'ⱸ', to: 'ⱻ', mapping: Valid },
    Range { from: 'ⱼ', to: 'ⱼ', mapping: Mapped("j") },
    Range { from: 'ⱽ', to: 'ⱽ', mapping: Mapped("v") },
    Range { from: 'Ȿ', to: 'Ȿ', mapping: Mapped("ȿ") },
    Range { from: 'Ɀ', to: 'Ɀ', mapping: Mapped("ɀ") },
    Range { from: 'Ⲁ', to: 'Ⲁ', mapping: Mapped("ⲁ") },
    Range { from: 'ⲁ', to: 'ⲁ', mapping: Valid },
    Range { from: 'Ⲃ', to: 'Ⲃ', mapping: Mapped("ⲃ") },
    Range { from: 'ⲃ', to: 'ⲃ', mapping: Valid },
    Range { from: 'Ⲅ', to: 'Ⲅ', mapping: Mapped("ⲅ") },
    Range { from: 'ⲅ', to: 'ⲅ', mapping: Valid },
    Range { from: 'Ⲇ', to: 'Ⲇ', mapping: Mapped("ⲇ") },
    Range { from: 'ⲇ', to: 'ⲇ', mapping: Valid },
    Range { from: 'Ⲉ', to: 'Ⲉ', mapping: Mapped("ⲉ") },
    Range { from: 'ⲉ', to: 'ⲉ', mapping: Valid },
    Range { from: 'Ⲋ', to: 'Ⲋ', mapping: Mapped("ⲋ") },
    Range { from: 'ⲋ', to: 'ⲋ', mapping: Valid },
    Range { from: 'Ⲍ', to: 'Ⲍ', mapping: Mapped("ⲍ") },
    Range { from: 'ⲍ', to: 'ⲍ', mapping: Valid },
    Range { from: 'Ⲏ', to: 'Ⲏ', mapping: Mapped("ⲏ") },
    Range { from: 'ⲏ', to: 'ⲏ', mapping: Valid },
    Range { from: 'Ⲑ', to: 'Ⲑ', mapping: Mapped("ⲑ") },
    Range { from: 'ⲑ', to: 'ⲑ', mapping: Valid },
    Range { from: 'Ⲓ', to: 'Ⲓ', mapping: Mapped("ⲓ") },
    Range { from: 'ⲓ', to: 'ⲓ', mapping: Valid },
    Range { from: 'Ⲕ', to: 'Ⲕ', mapping: Mapped("ⲕ") },
    Range { from: 'ⲕ', to: 'ⲕ', mapping: Valid },
    Range { from: 'Ⲗ', to: 'Ⲗ', mapping: Mapped("ⲗ") },
    Range { from: 'ⲗ', to: 'ⲗ', mapping: Valid },
    Range { from: 'Ⲙ', to: 'Ⲙ', mapping: Mapped("ⲙ") },
    Range { from: 'ⲙ', to: 'ⲙ', mapping: Valid },
    Range { from: 'Ⲛ', to: 'Ⲛ', mapping: Mapped("ⲛ") },
    Range { from: 'ⲛ', to: 'ⲛ', mapping: Valid },
    Range { from: 'Ⲝ', to: 'Ⲝ', mapping: Mapped("ⲝ") },
    Range { from: 'ⲝ', to: 'ⲝ', mapping: Valid },
    Range { from: 'Ⲟ', to: 'Ⲟ', mapping: Mapped("ⲟ") },
    Range { from: 'ⲟ', to: 'ⲟ', mapping: Valid },
    Range { from: 'Ⲡ', to: 'Ⲡ', mapping: Mapped("ⲡ") },
    Range { from: 'ⲡ', to: 'ⲡ', mapping: Valid },
    Range { from: 'Ⲣ', to: 'Ⲣ', mapping: Mapped("ⲣ") },
    Range { from: 'ⲣ', to: 'ⲣ', mapping: Valid },
    Range { from: 'Ⲥ', to: 'Ⲥ', mapping: Mapped("ⲥ") },
    Range { from: 'ⲥ', to: 'ⲥ', mapping: Valid },
    Range { from: 'Ⲧ', to: 'Ⲧ', mapping: Mapped("ⲧ") },
    Range { from: 'ⲧ', to: 'ⲧ', mapping: Valid },
    Range { from: 'Ⲩ', to: 'Ⲩ', mapping: Mapped("ⲩ") },
    Range { from: 'ⲩ', to: 'ⲩ', mapping: Valid },
    Range { from: 'Ⲫ', to: 'Ⲫ', mapping: Mapped("ⲫ") },
    Range { from: 'ⲫ', to: 'ⲫ', mapping: Valid },
    Range { from: 'Ⲭ', to: 'Ⲭ', mapping: Mapped("ⲭ") },
    Range { from: 'ⲭ', to: 'ⲭ', mapping: Valid },
    Range { from: 'Ⲯ', to: 'Ⲯ', mapping: Mapped("ⲯ") },
    Range { from: 'ⲯ', to: 'ⲯ', mapping: Valid },
    Range { from: 'Ⲱ', to: 'Ⲱ', mapping: Mapped("ⲱ") },
    Range { from: 'ⲱ', to: 'ⲱ', mapping: Valid },
    Range { from: 'Ⲳ', to: 'Ⲳ', mapping: Mapped("ⲳ") },
    Range { from: 'ⲳ', to: 'ⲳ', mapping: Valid },
    Range { from: 'Ⲵ', to: 'Ⲵ', mapping: Mapped("ⲵ") },
    Range { from: 'ⲵ', to: 'ⲵ', mapping: Valid },
    Range { from: 'Ⲷ', to: 'Ⲷ', mapping: Mapped("ⲷ") },
    Range { from: 'ⲷ', to: 'ⲷ', mapping: Valid },
    Range { from: 'Ⲹ', to: 'Ⲹ', mapping: Mapped("ⲹ") },
    Range { from: 'ⲹ', to: 'ⲹ', mapping: Valid },
    Range { from: 'Ⲻ', to: 'Ⲻ', mapping: Mapped("ⲻ") },
    Range { from: 'ⲻ', to: 'ⲻ', mapping: Valid },
    Range { from: 'Ⲽ', to: 'Ⲽ', mapping: Mapped("ⲽ") },
    Range { from: 'ⲽ', to: 'ⲽ', mapping: Valid },
    Range { from: 'Ⲿ', to: 'Ⲿ', mapping: Mapped("ⲿ") },
    Range { from: 'ⲿ', to: 'ⲿ', mapping: Valid },
    Range { from: 'Ⳁ', to: 'Ⳁ', mapping: Mapped("ⳁ") },
    Range { from: 'ⳁ', to: 'ⳁ', mapping: Valid },
    Range { from: 'Ⳃ', to: 'Ⳃ', mapping: Mapped("ⳃ") },
    Range { from: 'ⳃ', to: 'ⳃ', mapping: Valid },
    Range { from: 'Ⳅ', to: 'Ⳅ', mapping: Mapped("ⳅ") },
    Range { from: 'ⳅ', to: 'ⳅ', mapping: Valid },
    Range { from: 'Ⳇ', to: 'Ⳇ', mapping: Mapped("ⳇ") },
    Range { from: 'ⳇ', to: 'ⳇ', mapping: Valid },
    Range { from: 'Ⳉ', to: 'Ⳉ', mapping: Mapped("ⳉ") },
    Range { from: 'ⳉ', to: 'ⳉ', mapping: Valid },
    Range { from: 'Ⳋ', to: 'Ⳋ', mapping: Mapped("ⳋ") },
    Range { from: 'ⳋ', to: 'ⳋ', mapping: Valid },
    Range { from: 'Ⳍ', to: 'Ⳍ', mapping: Mapped("ⳍ") },
    Range { from: 'ⳍ', to: 'ⳍ', mapping: Valid },
    Range { from: 'Ⳏ', to: 'Ⳏ', mapping: Mapped("ⳏ") },
    Range { from: 'ⳏ', to: 'ⳏ', mapping: Valid },
    Range { from: 'Ⳑ', to: 'Ⳑ', mapping: Mapped("ⳑ") },
    Range { from: 'ⳑ', to: 'ⳑ', mapping: Valid },
    Range { from: 'Ⳓ', to: 'Ⳓ', mapping: Mapped("ⳓ") },
    Range { from: 'ⳓ', to: 'ⳓ', mapping: Valid },
    Range { from: 'Ⳕ', to: 'Ⳕ', mapping: Mapped("ⳕ") },
    Range { from: 'ⳕ', to: 'ⳕ', mapping: Valid },
    Range { from: 'Ⳗ', to: 'Ⳗ', mapping: Mapped("ⳗ") },
    Range { from: 'ⳗ', to: 'ⳗ', mapping: Valid },
    Range { from: 'Ⳙ', to: 'Ⳙ', mapping: Mapped("ⳙ") },
    Range { from: 'ⳙ', to: 'ⳙ', mapping: Valid },
    Range { from: 'Ⳛ', to: 'Ⳛ', mapping: Mapped("ⳛ") },
    Range { from: 'ⳛ', to: 'ⳛ', mapping: Valid },
    Range { from: 'Ⳝ', to: 'Ⳝ', mapping: Mapped("ⳝ") },
    Range { from: 'ⳝ', to: 'ⳝ', mapping: Valid },
    Range { from: 'Ⳟ', to: 'Ⳟ', mapping: Mapped("ⳟ") },
    Range { from: 'ⳟ', to: 'ⳟ', mapping: Valid },
    Range { from: 'Ⳡ', to: 'Ⳡ', mapping: Mapped("ⳡ") },
    Range { from: 'ⳡ', to: 'ⳡ', mapping: Valid },
    Range { from: 'Ⳣ', to: 'Ⳣ', mapping: Mapped("ⳣ") },
    Range { from: 'ⳣ', to: 'ⳤ', mapping: Valid },
    Range { from: '⳥', to: '⳪', mapping: Valid },
    Range { from: 'Ⳬ', to: 'Ⳬ', mapping: Mapped("ⳬ") },
    Range { from: 'ⳬ', to: 'ⳬ', mapping: Valid },
    Range { from: 'Ⳮ', to: 'Ⳮ', mapping: Mapped("ⳮ") },
    Range { from: 'ⳮ', to: '⳱', mapping: Valid },
    Range { from: 'Ⳳ', to: 'Ⳳ', mapping: Mapped("ⳳ") },
    Range { from: 'ⳳ', to: 'ⳳ', mapping: Valid },
    Range { from: '⳴', to: '⳸', mapping: Disallowed },
    Range { from: '⳹', to: '⳿', mapping: Valid },
    Range { from: 'ⴀ', to: 'ⴥ', mapping: Valid },
    Range { from: '⴦', to: '⴦', mapping: Disallowed },
    Range { from: 'ⴧ', to: 'ⴧ', mapping: Valid },
    Range { from: '⴨', to: '⴬', mapping: Disallowed },
    Range { from: 'ⴭ', to: 'ⴭ', mapping: Valid },
    Range { from: '⴮', to: '⴯', mapping: Disallowed },
    Range { from: 'ⴰ', to: 'ⵥ', mapping: Valid },
    Range { from: 'ⵦ', to: 'ⵧ', mapping: Valid },
    Range { from: '⵨', to: '⵮', mapping: Disallowed },
    Range { from: 'ⵯ', to: 'ⵯ', mapping: Mapped("ⵡ") },
    Range { from: '⵰', to: '⵰', mapping: Valid },
    Range { from: '⵱', to: '⵾', mapping: Disallowed },
    Range { from: '⵿', to: '⵿', mapping: Valid },
    Range { from: 'ⶀ', to: 'ⶖ', mapping: Valid },
    Range { from: '⶗', to: '⶟', mapping: Disallowed },
    Range { from: 'ⶠ', to: 'ⶦ', mapping: Valid },
    Range { from: '⶧', to: '⶧', mapping: Disallowed },
    Range { from: 'ⶨ', to: 'ⶮ', mapping: Valid },
    Range { from: '⶯', to: '⶯', mapping: Disallowed },
    Range { from: 'ⶰ', to: 'ⶶ', mapping: Valid },
    Range { from: '⶷', to: '⶷', mapping: Disallowed },
    Range { from: 'ⶸ', to: 'ⶾ', mapping: Valid },
    Range { from: '⶿', to: '⶿', mapping: Disallowed },
    Range { from: 'ⷀ', to: 'ⷆ', mapping: Valid },
    Range { from: '⷇', to: '⷇', mapping: Disallowed },
    Range { from: 'ⷈ', to: 'ⷎ', mapping: Valid },
    Range { from: '⷏', to: '⷏', mapping: Disallowed },
    Range { from: 'ⷐ', to: 'ⷖ', mapping: Valid },
    Range { from: '⷗', to: '⷗', mapping: Disallowed },
    Range { from: 'ⷘ', to: 'ⷞ', mapping: Valid },
    Range { from: '⷟', to: '⷟', mapping: Disallowed },
    Range { from: 'ⷠ', to: 'ⷿ', mapping: Valid },
    Range { from: '⸀', to: '⸗', mapping: Valid },
    Range { from: '⸘', to: '⸛', mapping: Valid },
    Range { from: '⸜', to: '⸝', mapping: Valid },
    Range { from: '⸞', to: '⸮', mapping: Valid },
    Range { from: 'ⸯ', to: 'ⸯ', mapping: Valid },
    Range { from: '⸰', to: '⸰', mapping: Valid },
    Range { from: '⸱', to: '⸱', mapping: Valid },
    Range { from: '⸲', to: '⸻', mapping: Valid },
    Range { from: '⸼', to: '⹂', mapping: Valid },
    Range { from: '⹃', to: '⹿', mapping: Disallowed },
    Range { from: '⺀', to: '⺙', mapping: Valid },
    Range { from: '⺚', to: '⺚', mapping: Disallowed },
    Range { from: '⺛', to: '⺞', mapping: Valid },
    Range { from: '⺟', to: '⺟', mapping: Mapped("母") },
    Range { from: '⺠', to: '⻲', mapping: Valid },
    Range { from: '⻳', to: '⻳', mapping: Mapped("龟") },
    Range { from: '⻴', to: '⻿', mapping: Disallowed },
    Range { from: '⼀', to: '⼀', mapping: Mapped("一") },
    Range { from: '⼁', to: '⼁', mapping: Mapped("丨") },
    Range { from: '⼂', to: '⼂', mapping: Mapped("丶") },
    Range { from: '⼃', to: '⼃', mapping: Mapped("丿") },
    Range { from: '⼄', to: '⼄', mapping: Mapped("乙") },
    Range { from: '⼅', to: '⼅', mapping: Mapped("亅") },
    Range { from: '⼆', to: '⼆', mapping: Mapped("二") },
    Range { from: '⼇', to: '⼇', mapping: Mapped("亠") },
    Range { from: '⼈', to: '⼈', mapping: Mapped("人") },
    Range { from: '⼉', to: '⼉', mapping: Mapped("儿") },
    Range { from: '⼊', to: '⼊', mapping: Mapped("入") },
    Range { from: '⼋', to: '⼋', mapping: Mapped("八") },
    Range { from: '⼌', to: '⼌', mapping: Mapped("冂") },
    Range { from: '⼍', to: '⼍', mapping: Mapped("冖") },
    Range { from: '⼎', to: '⼎', mapping: Mapped("冫") },
    Range { from: '⼏', to: '⼏', mapping: Mapped("几") },
    Range { from: '⼐', to: '⼐', mapping: Mapped("凵") },
    Range { from: '⼑', to: '⼑', mapping: Mapped("刀") },
    Range { from: '⼒', to: '⼒', mapping: Mapped("力") },
    Range { from: '⼓', to: '⼓', mapping: Mapped("勹") },
    Range { from: '⼔', to: '⼔', mapping: Mapped("匕") },
    Range { from: '⼕', to: '⼕', mapping: Mapped("匚") },
    Range { from: '⼖', to: '⼖', mapping: Mapped("匸") },
    Range { from: '⼗', to: '⼗', mapping: Mapped("十") },
    Range { from: '⼘', to: '⼘', mapping: Mapped("卜") },
    Range { from: '⼙', to: '⼙', mapping: Mapped("卩") },
    Range { from: '⼚', to: '⼚', mapping: Mapped("厂") },
    Range { from: '⼛', to: '⼛', mapping: Mapped("厶") },
    Range { from: '⼜', to: '⼜', mapping: Mapped("又") },
    Range { from: '⼝', to: '⼝', mapping: Mapped("口") },
    Range { from: '⼞', to: '⼞', mapping: Mapped("囗") },
    Range { from: '⼟', to: '⼟', mapping: Mapped("土") },
    Range { from: '⼠', to: '⼠', mapping: Mapped("士") },
    Range { from: '⼡', to: '⼡', mapping: Mapped("夂") },
    Range { from: '⼢', to: '⼢', mapping: Mapped("夊") },
    Range { from: '⼣', to: '⼣', mapping: Mapped("夕") },
    Range { from: '⼤', to: '⼤', mapping: Mapped("大") },
    Range { from: '⼥', to: '⼥', mapping: Mapped("女") },
    Range { from: '⼦', to: '⼦', mapping: Mapped("子") },
    Range { from: '⼧', to: '⼧', mapping: Mapped("宀") },
    Range { from: '⼨', to: '⼨', mapping: Mapped("寸") },
    Range { from: '⼩', to: '⼩', mapping: Mapped("小") },
    Range { from: '⼪', to: '⼪', mapping: Mapped("尢") },
    Range { from: '⼫', to: '⼫', mapping: Mapped("尸") },
    Range { from: '⼬', to: '⼬', mapping: Mapped("屮") },
    Range { from: '⼭', to: '⼭', mapping: Mapped("山") },
    Range { from: '⼮', to: '⼮', mapping: Mapped("巛") },
    Range { from: '⼯', to: '⼯', mapping: Mapped("工") },
    Range { from: '⼰', to: '⼰', mapping: Mapped("己") },
    Range { from: '⼱', to: '⼱', mapping: Mapped("巾") },
    Range { from: '⼲', to: '⼲', mapping: Mapped("干") },
    Range { from: '⼳', to: '⼳', mapping: Mapped("幺") },
    Range { from: '⼴', to: '⼴', mapping: Mapped("广") },
    Range { from: '⼵', to: '⼵', mapping: Mapped("廴") },
    Range { from: '⼶', to: '⼶', mapping: Mapped("廾") },
    Range { from: '⼷', to: '⼷', mapping: Mapped("弋") },
    Range { from: '⼸', to: '⼸', mapping: Mapped("弓") },
    Range { from: '⼹', to: '⼹', mapping: Mapped("彐") },
    Range { from: '⼺', to: '⼺', mapping: Mapped("彡") },
    Range { from: '⼻', to: '⼻', mapping: Mapped("彳") },
    Range { from: '⼼', to: '⼼', mapping: Mapped("心") },
    Range { from: '⼽', to: '⼽', mapping: Mapped("戈") },
    Range { from: '⼾', to: '⼾', mapping: Mapped("戶") },
    Range { from: '⼿', to: '⼿', mapping: Mapped("手") },
    Range { from: '⽀', to: '⽀', mapping: Mapped("支") },
    Range { from: '⽁', to: '⽁', mapping: Mapped("攴") },
    Range { from: '⽂', to: '⽂', mapping: Mapped("文") },
    Range { from: '⽃', to: '⽃', mapping: Mapped("斗") },
    Range { from: '⽄', to: '⽄', mapping: Mapped("斤") },
    Range { from: '⽅', to: '⽅', mapping: Mapped("方") },
    Range { from: '⽆', to: '⽆', mapping: Mapped("无") },
    Range { from: '⽇', to: '⽇', mapping: Mapped("日") },
    Range { from: '⽈', to: '⽈', mapping: Mapped("曰") },
    Range { from: '⽉', to: '⽉', mapping: Mapped("月") },
    Range { from: '⽊', to: '⽊', mapping: Mapped("木") },
    Range { from: '⽋', to: '⽋', mapping: Mapped("欠") },
    Range { from: '⽌', to: '⽌', mapping: Mapped("止") },
    Range { from: '⽍', to: '⽍', mapping: Mapped("歹") },
    Range { from: '⽎', to: '⽎', mapping: Mapped("殳") },
    Range { from: '⽏', to: '⽏', mapping: Mapped("毋") },
    Range { from: '⽐', to: '⽐', mapping: Mapped("比") },
    Range { from: '⽑', to: '⽑', mapping: Mapped("毛") },
    Range { from: '⽒', to: '⽒', mapping: Mapped("氏") },
    Range { from: '⽓', to: '⽓', mapping: Mapped("气") },
    Range { from: '⽔', to: '⽔', mapping: Mapped("水") },
    Range { from: '⽕', to: '⽕', mapping: Mapped("火") },
    Range { from: '⽖', to: '⽖', mapping: Mapped("爪") },
    Range { from: '⽗', to: '⽗', mapping: Mapped("父") },
    Range { from: '⽘', to: '⽘', mapping: Mapped("爻") },
    Range { from: '⽙', to: '⽙', mapping: Mapped("爿") },
    Range { from: '⽚', to: '⽚', mapping: Mapped("片") },
    Range { from: '⽛', to: '⽛', mapping: Mapped("牙") },
    Range { from: '⽜', to: '⽜', mapping: Mapped("牛") },
    Range { from: '⽝', to: '⽝', mapping: Mapped("犬") },
    Range { from: '⽞', to: '⽞', mapping: Mapped("玄") },
    Range { from: '⽟', to: '⽟', mapping: Mapped("玉") },
    Range { from: '⽠', to: '⽠', mapping: Mapped("瓜") },
    Range { from: '⽡', to: '⽡', mapping: Mapped("瓦") },
    Range { from: '⽢', to: '⽢', mapping: Mapped("甘") },
    Range { from: '⽣', to: '⽣', mapping: Mapped("生") },
    Range { from: '⽤', to: '⽤', mapping: Mapped("用") },
    Range { from: '⽥', to: '⽥', mapping: Mapped("田") },
    Range { from: '⽦', to: '⽦', mapping: Mapped("疋") },
    Range { from: '⽧', to: '⽧', mapping: Mapped("疒") },
    Range { from: '⽨', to: '⽨', mapping: Mapped("癶") },
    Range { from: '⽩', to: '⽩', mapping: Mapped("白") },
    Range { from: '⽪', to: '⽪', mapping: Mapped("皮") },
    Range { from: '⽫', to: '⽫', mapping: Mapped("皿") },
    Range { from: '⽬', to: '⽬', mapping: Mapped("目") },
    Range { from: '⽭', to: '⽭', mapping: Mapped("矛") },
    Range { from: '⽮', to: '⽮', mapping: Mapped("矢") },
    Range { from: '⽯', to: '⽯', mapping: Mapped("石") },
    Range { from: '⽰', to: '⽰', mapping: Mapped("示") },
    Range { from: '⽱', to: '⽱', mapping: Mapped("禸") },
    Range { from: '⽲', to: '⽲', mapping: Mapped("禾") },
    Range { from: '⽳', to: '⽳', mapping: Mapped("穴") },
    Range { from: '⽴', to: '⽴', mapping: Mapped("立") },
    Range { from: '⽵', to: '⽵', mapping: Mapped("竹") },
    Range { from: '⽶', to: '⽶', mapping: Mapped("米") },
    Range { from: '⽷', to: '⽷', mapping: Mapped("糸") },
    Range { from: '⽸', to: '⽸', mapping: Mapped("缶") },
    Range { from: '⽹', to: '⽹', mapping: Mapped("网") },
    Range { from: '⽺', to: '⽺', mapping: Mapped("羊") },
    Range { from: '⽻', to: '⽻', mapping: Mapped("羽") },
    Range { from: '⽼', to: '⽼', mapping: Mapped("老") },
    Range { from: '⽽', to: '⽽', mapping: Mapped("而") },
    Range { from: '⽾', to: '⽾', mapping: Mapped("耒") },
    Range { from: '⽿', to: '⽿', mapping: Mapped("耳") },
    Range { from: '⾀', to: '⾀', mapping: Mapped("聿") },
    Range { from: '⾁', to: '⾁', mapping: Mapped("肉") },
    Range { from: '⾂', to: '⾂', mapping: Mapped("臣") },
    Range { from: '⾃', to: '⾃', mapping: Mapped("自") },
    Range { from: '⾄', to: '⾄', mapping: Mapped("至") },
    Range { from: '⾅', to: '⾅', mapping: Mapped("臼") },
    Range { from: '⾆', to: '⾆', mapping: Mapped("舌") },
    Range { from: '⾇', to: '⾇', mapping: Mapped("舛") },
    Range { from: '⾈', to: '⾈', mapping: Mapped("舟") },
    Range { from: '⾉', to: '⾉', mapping: Mapped("艮") },
    Range { from: '⾊', to: '⾊', mapping: Mapped("色") },
    Range { from: '⾋', to: '⾋', mapping: Mapped("艸") },
    Range { from: '⾌', to: '⾌', mapping: Mapped("虍") },
    Range { from: '⾍', to: '⾍', mapping: Mapped("虫") },
    Range { from: '⾎', to: '⾎', mapping: Mapped("血") },
    Range { from: '⾏', to: '⾏', mapping: Mapped("行") },
    Range { from: '⾐', to: '⾐', mapping: Mapped("衣") },
    Range { from: '⾑', to: '⾑', mapping: Mapped("襾") },
    Range { from: '⾒', to: '⾒', mapping: Mapped("見") },
    Range { from: '⾓', to: '⾓', mapping: Mapped("角") },
    Range { from: '⾔', to: '⾔', mapping: Mapped("言") },
    Range { from: '⾕', to: '⾕', mapping: Mapped("谷") },
    Range { from: '⾖', to: '⾖', mapping: Mapped("豆") },
    Range { from: '⾗', to: '⾗', mapping: Mapped("豕") },
    Range { from: '⾘', to: '⾘', mapping: Mapped("豸") },
    Range { from: '⾙', to: '⾙', mapping: Mapped("貝") },
    Range { from: '⾚', to: '⾚', mapping: Mapped("赤") },
    Range { from: '⾛', to: '⾛', mapping: Mapped("走") },
    Range { from: '⾜', to: '⾜', mapping: Mapped("足") },
    Range { from: '⾝', to: '⾝', mapping: Mapped("身") },
    Range { from: '⾞', to: '⾞', mapping: Mapped("車") },
    Range { from: '⾟', to: '⾟', mapping: Mapped("辛") },
    Range { from: '⾠', to: '⾠', mapping: Mapped("辰") },
    Range { from: '⾡', to: '⾡', mapping: Mapped("辵") },
    Range { from: '⾢', to: '⾢', mapping: Mapped("邑") },
    Range { from: '⾣', to: '⾣', mapping: Mapped("酉") },
    Range { from: '⾤', to: '⾤', mapping: Mapped("釆") },
    Range { from: '⾥', to: '⾥', mapping: Mapped("里") },
    Range { from: '⾦', to: '⾦', mapping: Mapped("金") },
    Range { from: '⾧', to: '⾧', mapping: Mapped("長") },
    Range { from: '⾨', to: '⾨', mapping: Mapped("門") },
    Range { from: '⾩', to: '⾩', mapping: Mapped("阜") },
    Range { from: '⾪', to: '⾪', mapping: Mapped("隶") },
    Range { from: '⾫', to: '⾫', mapping: Mapped("隹") },
    Range { from: '⾬', to: '⾬', mapping: Mapped("雨") },
    Range { from: '⾭', to: '⾭', mapping: Mapped("靑") },
    Range { from: '⾮', to: '⾮', mapping: Mapped("非") },
    Range { from: '⾯', to: '⾯', mapping: Mapped("面") },
    Range { from: '⾰', to: '⾰', mapping: Mapped("革") },
    Range { from: '⾱', to: '⾱', mapping: Mapped("韋") },
    Range { from: '⾲', to: '⾲', mapping: Mapped("韭") },
    Range { from: '⾳', to: '⾳', mapping: Mapped("音") },
    Range { from: '⾴', to: '⾴', mapping: Mapped("頁") },
    Range { from: '⾵', to: '⾵', mapping: Mapped("風") },
    Range { from: '⾶', to: '⾶', mapping: Mapped("飛") },
    Range { from: '⾷', to: '⾷', mapping: Mapped("食") },
    Range { from: '⾸', to: '⾸', mapping: Mapped("首") },
    Range { from: '⾹', to: '⾹', mapping: Mapped("香") },
    Range { from: '⾺', to: '⾺', mapping: Mapped("馬") },
    Range { from: '⾻', to: '⾻', mapping: Mapped("骨") },
    Range { from: '⾼', to: '⾼', mapping: Mapped("高") },
    Range { from: '⾽', to: '⾽', mapping: Mapped("髟") },
    Range { from: '⾾', to: '⾾', mapping: Mapped("鬥") },
    Range { from: '⾿', to: '⾿', mapping: Mapped("鬯") },
    Range { from: '⿀', to: '⿀', mapping: Mapped("鬲") },
    Range { from: '⿁', to: '⿁', mapping: Mapped("鬼") },
    Range { from: '⿂', to: '⿂', mapping: Mapped("魚") },
    Range { from: '⿃', to: '⿃', mapping: Mapped("鳥") },
    Range { from: '⿄', to: '⿄', mapping: Mapped("鹵") },
    Range { from: '⿅', to: '⿅', mapping: Mapped("鹿") },
    Range { from: '⿆', to: '⿆', mapping: Mapped("麥") },
    Range { from: '⿇', to: '⿇', mapping: Mapped("麻") },
    Range { from: '⿈', to: '⿈', mapping: Mapped("黃") },
    Range { from: '⿉', to: '⿉', mapping: Mapped("黍") },
    Range { from: '⿊', to: '⿊', mapping: Mapped("黑") },
    Range { from: '⿋', to: '⿋', mapping: Mapped("黹") },
    Range { from: '⿌', to: '⿌', mapping: Mapped("黽") },
    Range { from: '⿍', to: '⿍', mapping: Mapped("鼎") },
    Range { from: '⿎', to: '⿎', mapping: Mapped("鼓") },
    Range { from: '⿏', to: '⿏', mapping: Mapped("鼠") },
    Range { from: '⿐', to: '⿐', mapping: Mapped("鼻") },
    Range { from: '⿑', to: '⿑', mapping: Mapped("齊") },
    Range { from: '⿒', to: '⿒', mapping: Mapped("齒") },
    Range { from: '⿓', to: '⿓', mapping: Mapped("龍") },
    Range { from: '⿔', to: '⿔', mapping: Mapped("龜") },
    Range { from: '⿕', to: '⿕', mapping: Mapped("龠") },
    Range { from: '⿖', to: '⿯', mapping: Disallowed },
    Range { from: '⿰', to: '⿻', mapping: Disallowed },
    Range { from: '⿼', to: '⿿', mapping: Disallowed },
    Range { from: '　', to: '　', mapping: DisallowedStd3Mapped(" ") },
    Range { from: '、', to: '、', mapping: Valid },
    Range { from: '。', to: '。', mapping: Mapped(".") },
    Range { from: '〃', to: '〄', mapping: Valid },
    Range { from: '々', to: '〇', mapping: Valid },
    Range { from: '〈', to: '〩', mapping: Valid },
    Range { from: '〪', to: '〭', mapping: Valid },
    Range { from: '〮', to: '〵', mapping: Valid },
    Range { from: '〶', to: '〶', mapping: Mapped("〒") },
    Range { from: '〷', to: '〷', mapping: Valid },
    Range { from: '〸', to: '〸', mapping: Mapped("十") },
    Range { from: '〹', to: '〹', mapping: Mapped("卄") },
    Range { from: '〺', to: '〺', mapping: Mapped("卅") },
    Range { from: '〻', to: '〻', mapping: Valid },
    Range { from: '〼', to: '〼', mapping: Valid },
    Range { from: '〽', to: '〽', mapping: Valid },
    Range { from: '〾', to: '〾', mapping: Valid },
    Range { from: '〿', to: '〿', mapping: Valid },
    Range { from: '぀', to: '぀', mapping: Disallowed },
    Range { from: 'ぁ', to: 'ゔ', mapping: Valid },
    Range { from: 'ゕ', to: 'ゖ', mapping: Valid },
    Range { from: '゗', to: '゘', mapping: Disallowed },
    Range { from: '゙', to: '゚', mapping: Valid },
    Range { from: '゛', to: '゛', mapping: DisallowedStd3Mapped(" ゙") },
    Range { from: '゜', to: '゜', mapping: DisallowedStd3Mapped(" ゚") },
    Range { from: 'ゝ', to: 'ゞ', mapping: Valid },
    Range { from: 'ゟ', to: 'ゟ', mapping: Mapped("より") },
    Range { from: '゠', to: '゠', mapping: Valid },
    Range { from: 'ァ', to: 'ヾ', mapping: Valid },
    Range { from: 'ヿ', to: 'ヿ', mapping: Mapped("コト") },
    Range { from: '㄀', to: '㄄', mapping: Disallowed },
    Range { from: 'ㄅ', to: 'ㄬ', mapping: Valid },
    Range { from: 'ㄭ', to: 'ㄭ', mapping: Valid },
    Range { from: 'ㄮ', to: '㄰', mapping: Disallowed },
    Range { from: 'ㄱ', to: 'ㄱ', mapping: Mapped("ᄀ") },
    Range { from: 'ㄲ', to: 'ㄲ', mapping: Mapped("ᄁ") },
    Range { from: 'ㄳ', to: 'ㄳ', mapping: Mapped("ᆪ") },
    Range { from: 'ㄴ', to: 'ㄴ', mapping: Mapped("ᄂ") },
    Range { from: 'ㄵ', to: 'ㄵ', mapping: Mapped("ᆬ") },
    Range { from: 'ㄶ', to: 'ㄶ', mapping: Mapped("ᆭ") },
    Range { from: 'ㄷ', to: 'ㄷ', mapping: Mapped("ᄃ") },
    Range { from: 'ㄸ', to: 'ㄸ', mapping: Mapped("ᄄ") },
    Range { from: 'ㄹ', to: 'ㄹ', mapping: Mapped("ᄅ") },
    Range { from: 'ㄺ', to: 'ㄺ', mapping: Mapped("ᆰ") },
    Range { from: 'ㄻ', to: 'ㄻ', mapping: Mapped("ᆱ") },
    Range { from: 'ㄼ', to: 'ㄼ', mapping: Mapped("ᆲ") },
    Range { from: 'ㄽ', to: 'ㄽ', mapping: Mapped("ᆳ") },
    Range { from: 'ㄾ', to: 'ㄾ', mapping: Mapped("ᆴ") },
    Range { from: 'ㄿ', to: 'ㄿ', mapping: Mapped("ᆵ") },
    Range { from: 'ㅀ', to: 'ㅀ', mapping: Mapped("ᄚ") },
    Range { from: 'ㅁ', to: 'ㅁ', mapping: Mapped("ᄆ") },
    Range { from: 'ㅂ', to: 'ㅂ', mapping: Mapped("ᄇ") },
    Range { from: 'ㅃ', to: 'ㅃ', mapping: Mapped("ᄈ") },
    Range { from: 'ㅄ', to: 'ㅄ', mapping: Mapped("ᄡ") },
    Range { from: 'ㅅ', to: 'ㅅ', mapping: Mapped("ᄉ") },
    Range { from: 'ㅆ', to: 'ㅆ', mapping: Mapped("ᄊ") },
    Range { from: 'ㅇ', to: 'ㅇ', mapping: Mapped("ᄋ") },
    Range { from: 'ㅈ', to: 'ㅈ', mapping: Mapped("ᄌ") },
    Range { from: 'ㅉ', to: 'ㅉ', mapping: Mapped("ᄍ") },
    Range { from: 'ㅊ', to: 'ㅊ', mapping: Mapped("ᄎ") },
    Range { from: 'ㅋ', to: 'ㅋ', mapping: Mapped("ᄏ") },
    Range { from: 'ㅌ', to: 'ㅌ', mapping: Mapped("ᄐ") },
    Range { from: 'ㅍ', to: 'ㅍ', mapping: Mapped("ᄑ") },
    Range { from: 'ㅎ', to: 'ㅎ', mapping: Mapped("ᄒ") },
    Range { from: 'ㅏ', to: 'ㅏ', mapping: Mapped("ᅡ") },
    Range { from: 'ㅐ', to: 'ㅐ', mapping: Mapped("ᅢ") },
    Range { from: 'ㅑ', to: 'ㅑ', mapping: Mapped("ᅣ") },
    Range { from: 'ㅒ', to: 'ㅒ', mapping: Mapped("ᅤ") },
    Range { from: 'ㅓ', to: 'ㅓ', mapping: Mapped("ᅥ") },
    Range { from: 'ㅔ', to: 'ㅔ', mapping: Mapped("ᅦ") },
    Range { from: 'ㅕ', to: 'ㅕ', mapping: Mapped("ᅧ") },
    Range { from: 'ㅖ', to: 'ㅖ', mapping: Mapped("ᅨ") },
    Range { from: 'ㅗ', to: 'ㅗ', mapping: Mapped("ᅩ") },
    Range { from: 'ㅘ', to: 'ㅘ', mapping: Mapped("ᅪ") },
    Range { from: 'ㅙ', to: 'ㅙ', mapping: Mapped("ᅫ") },
    Range { from: 'ㅚ', to: 'ㅚ', mapping: Mapped("ᅬ") },
    Range { from: 'ㅛ', to: 'ㅛ', mapping: Mapped("ᅭ") },
    Range { from: 'ㅜ', to: 'ㅜ', mapping: Mapped("ᅮ") },
    Range { from: 'ㅝ', to: 'ㅝ', mapping: Mapped("ᅯ") },
    Range { from: 'ㅞ', to: 'ㅞ', mapping: Mapped("ᅰ") },
    Range { from: 'ㅟ', to: 'ㅟ', mapping: Mapped("ᅱ") },
    Range { from: 'ㅠ', to: 'ㅠ', mapping: Mapped("ᅲ") },
    Range { from: 'ㅡ', to: 'ㅡ', mapping: Mapped("ᅳ") },
    Range { from: 'ㅢ', to: 'ㅢ', mapping: Mapped("ᅴ") },
    Range { from: 'ㅣ', to: 'ㅣ', mapping: Mapped("ᅵ") },
    Range { from: 'ㅤ', to: 'ㅤ', mapping: Disallowed },
    Range { from: 'ㅥ', to: 'ㅥ', mapping: Mapped("ᄔ") },
    Range { from: 'ㅦ', to: 'ㅦ', mapping: Mapped("ᄕ") },
    Range { from: 'ㅧ', to: 'ㅧ', mapping: Mapped("ᇇ") },
    Range { from: 'ㅨ', to: 'ㅨ', mapping: Mapped("ᇈ") },
    Range { from: 'ㅩ', to: 'ㅩ', mapping: Mapped("ᇌ") },
    Range { from: 'ㅪ', to: 'ㅪ', mapping: Mapped("ᇎ") },
    Range { from: 'ㅫ', to: 'ㅫ', mapping: Mapped("ᇓ") },
    Range { from: 'ㅬ', to: 'ㅬ', mapping: Mapped("ᇗ") },
    Range { from: 'ㅭ', to: 'ㅭ', mapping: Mapped("ᇙ") },
    Range { from: 'ㅮ', to: 'ㅮ', mapping: Mapped("ᄜ") },
    Range { from: 'ㅯ', to: 'ㅯ', mapping: Mapped("ᇝ") },
    Range { from: 'ㅰ', to: 'ㅰ', mapping: Mapped("ᇟ") },
    Range { from: 'ㅱ', to: 'ㅱ', mapping: Mapped("ᄝ") },
    Range { from: 'ㅲ', to: 'ㅲ', mapping: Mapped("ᄞ") },
    Range { from: 'ㅳ', to: 'ㅳ', mapping: Mapped("ᄠ") },
    Range { from: 'ㅴ', to: 'ㅴ', mapping: Mapped("ᄢ") },
    Range { from: 'ㅵ', to: 'ㅵ', mapping: Mapped("ᄣ") },
    Range { from: 'ㅶ', to: 'ㅶ', mapping: Mapped("ᄧ") },
    Range { from: 'ㅷ', to: 'ㅷ', mapping: Mapped("ᄩ") },
    Range { from: 'ㅸ', to: 'ㅸ', mapping: Mapped("ᄫ") },
    Range { from: 'ㅹ', to: 'ㅹ', mapping: Mapped("ᄬ") },
    Range { from: 'ㅺ', to: 'ㅺ', mapping: Mapped("ᄭ") },
    Range { from: 'ㅻ', to: 'ㅻ', mapping: Mapped("ᄮ") },
    Range { from: 'ㅼ', to: 'ㅼ', mapping: Mapped("ᄯ") },
    Range { from: 'ㅽ', to: 'ㅽ', mapping: Mapped("ᄲ") },
    Range { from: 'ㅾ', to: 'ㅾ', mapping: Mapped("ᄶ") },
    Range { from: 'ㅿ', to: 'ㅿ', mapping: Mapped("ᅀ") },
    Range { from: 'ㆀ', to: 'ㆀ', mapping: Mapped("ᅇ") },
    Range { from: 'ㆁ', to: 'ㆁ', mapping: Mapped("ᅌ") },
    Range { from: 'ㆂ', to: 'ㆂ', mapping: Mapped("ᇱ") },
    Range { from: 'ㆃ', to: 'ㆃ', mapping: Mapped("ᇲ") },
    Range { from: 'ㆄ', to: 'ㆄ', mapping: Mapped("ᅗ") },
    Range { from: 'ㆅ', to: 'ㆅ', mapping: Mapped("ᅘ") },
    Range { from: 'ㆆ', to: 'ㆆ', mapping: Mapped("ᅙ") },
    Range { from: 'ㆇ', to: 'ㆇ', mapping: Mapped("ᆄ") },
    Range { from: 'ㆈ', to: 'ㆈ', mapping: Mapped("ᆅ") },
    Range { from: 'ㆉ', to: 'ㆉ', mapping: Mapped("ᆈ") },
    Range { from: 'ㆊ', to: 'ㆊ', mapping: Mapped("ᆑ") },
    Range { from: 'ㆋ', to: 'ㆋ', mapping: Mapped("ᆒ") },
    Range { from: 'ㆌ', to: 'ㆌ', mapping: Mapped("ᆔ") },
    Range { from: 'ㆍ', to: 'ㆍ', mapping: Mapped("ᆞ") },
    Range { from: 'ㆎ', to: 'ㆎ', mapping: Mapped("ᆡ") },
    Range { from: '㆏', to: '㆏', mapping: Disallowed },
    Range { from: '㆐', to: '㆑', mapping: Valid },
    Range { from: '㆒', to: '㆒', mapping: Mapped("一") },
    Range { from: '㆓', to: '㆓', mapping: Mapped("二") },
    Range { from: '㆔', to: '㆔', mapping: Mapped("三") },
    Range { from: '㆕', to: '㆕', mapping: Mapped("四") },
    Range { from: '㆖', to: '㆖', mapping: Mapped("上") },
    Range { from: '㆗', to: '㆗', mapping: Mapped("中") },
    Range { from: '㆘', to: '㆘', mapping: Mapped("下") },
    Range { from: '㆙', to: '㆙', mapping: Mapped("甲") },
    Range { from: '㆚', to: '㆚', mapping: Mapped("乙") },
    Range { from: '㆛', to: '㆛', mapping: Mapped("丙") },
    Range { from: '㆜', to: '㆜', mapping: Mapped("丁") },
    Range { from: '㆝', to: '㆝', mapping: Mapped("天") },
    Range { from: '㆞', to: '㆞', mapping: Mapped("地") },
    Range { from: '㆟', to: '㆟', mapping: Mapped("人") },
    Range { from: 'ㆠ', to: 'ㆷ', mapping: Valid },
    Range { from: 'ㆸ', to: 'ㆺ', mapping: Valid },
    Range { from: 'ㆻ', to: 'ㆿ', mapping: Disallowed },
    Range { from: '㇀', to: '㇏', mapping: Valid },
    Range { from: '㇐', to: '㇣', mapping: Valid },
    Range { from: '㇤', to: '㇯', mapping: Disallowed },
    Range { from: 'ㇰ', to: 'ㇿ', mapping: Valid },
    Range { from: '㈀', to: '㈀', mapping: DisallowedStd3Mapped("(ᄀ)") },
    Range { from: '㈁', to: '㈁', mapping: DisallowedStd3Mapped("(ᄂ)") },
    Range { from: '㈂', to: '㈂', mapping: DisallowedStd3Mapped("(ᄃ)") },
    Range { from: '㈃', to: '㈃', mapping: DisallowedStd3Mapped("(ᄅ)") },
    Range { from: '㈄', to: '㈄', mapping: DisallowedStd3Mapped("(ᄆ)") },
    Range { from: '㈅', to: '㈅', mapping: DisallowedStd3Mapped("(ᄇ)") },
    Range { from: '㈆', to: '㈆', mapping: DisallowedStd3Mapped("(ᄉ)") },
    Range { from: '㈇', to: '㈇', mapping: DisallowedStd3Mapped("(ᄋ)") },
    Range { from: '㈈', to: '㈈', mapping: DisallowedStd3Mapped("(ᄌ)") },
    Range { from: '㈉', to: '㈉', mapping: DisallowedStd3Mapped("(ᄎ)") },
    Range { from: '㈊', to: '㈊', mapping: DisallowedStd3Mapped("(ᄏ)") },
    Range { from: '㈋', to: '㈋', mapping: DisallowedStd3Mapped("(ᄐ)") },
    Range { from: '㈌', to: '㈌', mapping: DisallowedStd3Mapped("(ᄑ)") },
    Range { from: '㈍', to: '㈍', mapping: DisallowedStd3Mapped("(ᄒ)") },
    Range { from: '㈎', to: '㈎', mapping: DisallowedStd3Mapped("(가)") },
    Range { from: '㈏', to: '㈏', mapping: DisallowedStd3Mapped("(나)") },
    Range { from: '㈐', to: '㈐', mapping: DisallowedStd3Mapped("(다)") },
    Range { from: '㈑', to: '㈑', mapping: DisallowedStd3Mapped("(라)") },
    Range { from: '㈒', to: '㈒', mapping: DisallowedStd3Mapped("(마)") },
    Range { from: '㈓', to: '㈓', mapping: DisallowedStd3Mapped("(바)") },
    Range { from: '㈔', to: '㈔', mapping: DisallowedStd3Mapped("(사)") },
    Range { from: '㈕', to: '㈕', mapping: DisallowedStd3Mapped("(아)") },
    Range { from: '㈖', to: '㈖', mapping: DisallowedStd3Mapped("(자)") },
    Range { from: '㈗', to: '㈗', mapping: DisallowedStd3Mapped("(차)") },
    Range { from: '㈘', to: '㈘', mapping: DisallowedStd3Mapped("(카)") },
    Range { from: '㈙', to: '㈙', mapping: DisallowedStd3Mapped("(타)") },
    Range { from: '㈚', to: '㈚', mapping: DisallowedStd3Mapped("(파)") },
    Range { from: '㈛', to: '㈛', mapping: DisallowedStd3Mapped("(하)") },
    Range { from: '㈜', to: '㈜', mapping: DisallowedStd3Mapped("(주)") },
    Range { from: '㈝', to: '㈝', mapping: DisallowedStd3Mapped("(오전)") },
    Range { from: '㈞', to: '㈞', mapping: DisallowedStd3Mapped("(오후)") },
    Range { from: '㈟', to: '㈟', mapping: Disallowed },
    Range { from: '㈠', to: '㈠', mapping: DisallowedStd3Mapped("(一)") },
    Range { from: '㈡', to: '㈡', mapping: DisallowedStd3Mapped("(二)") },
    Range { from: '㈢', to: '㈢', mapping: DisallowedStd3Mapped("(三)") },
    Range { from: '㈣', to: '㈣', mapping: DisallowedStd3Mapped("(四)") },
    Range { from: '㈤', to: '㈤', mapping: DisallowedStd3Mapped("(五)") },
    Range { from: '㈥', to: '㈥', mapping: DisallowedStd3Mapped("(六)") },
    Range { from: '㈦', to: '㈦', mapping: DisallowedStd3Mapped("(七)") },
    Range { from: '㈧', to: '㈧', mapping: DisallowedStd3Mapped("(八)") },
    Range { from: '㈨', to: '㈨', mapping: DisallowedStd3Mapped("(九)") },
    Range { from: '㈩', to: '㈩', mapping: DisallowedStd3Mapped("(十)") },
    Range { from: '㈪', to: '㈪', mapping: DisallowedStd3Mapped("(月)") },
    Range { from: '㈫', to: '㈫', mapping: DisallowedStd3Mapped("(火)") },
    Range { from: '㈬', to: '㈬', mapping: DisallowedStd3Mapped("(水)") },
    Range { from: '㈭', to: '㈭', mapping: DisallowedStd3Mapped("(木)") },
    Range { from: '㈮', to: '㈮', mapping: DisallowedStd3Mapped("(金)") },
    Range { from: '㈯', to: '㈯', mapping: DisallowedStd3Mapped("(土)") },
    Range { from: '㈰', to: '㈰', mapping: DisallowedStd3Mapped("(日)") },
    Range { from: '㈱', to: '㈱', mapping: DisallowedStd3Mapped("(株)") },
    Range { from: '㈲', to: '㈲', mapping: DisallowedStd3Mapped("(有)") },
    Range { from: '㈳', to: '㈳', mapping: DisallowedStd3Mapped("(社)") },
    Range { from: '㈴', to: '㈴', mapping: DisallowedStd3Mapped("(名)") },
    Range { from: '㈵', to: '㈵', mapping: DisallowedStd3Mapped("(特)") },
    Range { from: '㈶', to: '㈶', mapping: DisallowedStd3Mapped("(財)") },
    Range { from: '㈷', to: '㈷', mapping: DisallowedStd3Mapped("(祝)") },
    Range { from: '㈸', to: '㈸', mapping: DisallowedStd3Mapped("(労)") },
    Range { from: '㈹', to: '㈹', mapping: DisallowedStd3Mapped("(代)") },
    Range { from: '㈺', to: '㈺', mapping: DisallowedStd3Mapped("(呼)") },
    Range { from: '㈻', to: '㈻', mapping: DisallowedStd3Mapped("(学)") },
    Range { from: '㈼', to: '㈼', mapping: DisallowedStd3Mapped("(監)") },
    Range { from: '㈽', to: '㈽', mapping: DisallowedStd3Mapped("(企)") },
    Range { from: '㈾', to: '㈾', mapping: DisallowedStd3Mapped("(資)") },
    Range { from: '㈿', to: '㈿', mapping: DisallowedStd3Mapped("(協)") },
    Range { from: '㉀', to: '㉀', mapping: DisallowedStd3Mapped("(祭)") },
    Range { from: '㉁', to: '㉁', mapping: DisallowedStd3Mapped("(休)") },
    Range { from: '㉂', to: '㉂', mapping: DisallowedStd3Mapped("(自)") },
    Range { from: '㉃', to: '㉃', mapping: DisallowedStd3Mapped("(至)") },
    Range { from: '㉄', to: '㉄', mapping: Mapped("問") },
    Range { from: '㉅', to: '㉅', mapping: Mapped("幼") },
    Range { from: '㉆', to: '㉆', mapping: Mapped("文") },
    Range { from: '㉇', to: '㉇', mapping: Mapped("箏") },
    Range { from: '㉈', to: '㉏', mapping: Valid },
    Range { from: '㉐', to: '㉐', mapping: Mapped("pte") },
    Range { from: '㉑', to: '㉑', mapping: Mapped("21") },
    Range { from: '㉒', to: '㉒', mapping: Mapped("22") },
    Range { from: '㉓', to: '㉓', mapping: Mapped("23") },
    Range { from: '㉔', to: '㉔', mapping: Mapped("24") },
    Range { from: '㉕', to: '㉕', mapping: Mapped("25") },
    Range { from: '㉖', to: '㉖', mapping: Mapped("26") },
    Range { from: '㉗', to: '㉗', mapping: Mapped("27") },
    Range { from: '㉘', to: '㉘', mapping: Mapped("28") },
    Range { from: '㉙', to: '㉙', mapping: Mapped("29") },
    Range { from: '㉚', to: '㉚', mapping: Mapped("30") },
    Range { from: '㉛', to: '㉛', mapping: Mapped("31") },
    Range { from: '㉜', to: '㉜', mapping: Mapped("32") },
    Range { from: '㉝', to: '㉝', mapping: Mapped("33") },
    Range { from: '㉞', to: '㉞', mapping: Mapped("34") },
    Range { from: '㉟', to: '㉟', mapping: Mapped("35") },
    Range { from: '㉠', to: '㉠', mapping: Mapped("ᄀ") },
    Range { from: '㉡', to: '㉡', mapping: Mapped("ᄂ") },
    Range { from: '㉢', to: '㉢', mapping: Mapped("ᄃ") },
    Range { from: '㉣', to: '㉣', mapping: Mapped("ᄅ") },
    Range { from: '㉤', to: '㉤', mapping: Mapped("ᄆ") },
    Range { from: '㉥', to: '㉥', mapping: Mapped("ᄇ") },
    Range { from: '㉦', to: '㉦', mapping: Mapped("ᄉ") },
    Range { from: '㉧', to: '㉧', mapping: Mapped("ᄋ") },
    Range { from: '㉨', to: '㉨', mapping: Mapped("ᄌ") },
    Range { from: '㉩', to: '㉩', mapping: Mapped("ᄎ") },
    Range { from: '㉪', to: '㉪', mapping: Mapped("ᄏ") },
    Range { from: '㉫', to: '㉫', mapping: Mapped("ᄐ") },
    Range { from: '㉬', to: '㉬', mapping: Mapped("ᄑ") },
    Range { from: '㉭', to: '㉭', mapping: Mapped("ᄒ") },
    Range { from: '㉮', to: '㉮', mapping: Mapped("가") },
    Range { from: '㉯', to: '㉯', mapping: Mapped("나") },
    Range { from: '㉰', to: '㉰', mapping: Mapped("다") },
    Range { from: '㉱', to: '㉱', mapping: Mapped("라") },
    Range { from: '㉲', to: '㉲', mapping: Mapped("마") },
    Range { from: '㉳', to: '㉳', mapping: Mapped("바") },
    Range { from: '㉴', to: '㉴', mapping: Mapped("사") },
    Range { from: '㉵', to: '㉵', mapping: Mapped("아") },
    Range { from: '㉶', to: '㉶', mapping: Mapped("자") },
    Range { from: '㉷', to: '㉷', mapping: Mapped("차") },
    Range { from: '㉸', to: '㉸', mapping: Mapped("카") },
    Range { from: '㉹', to: '㉹', mapping: Mapped("타") },
    Range { from: '㉺', to: '㉺', mapping: Mapped("파") },
    Range { from: '㉻', to: '㉻', mapping: Mapped("하") },
    Range { from: '㉼', to: '㉼', mapping: Mapped("참고") },
    Range { from: '㉽', to: '㉽', mapping: Mapped("주의") },
    Range { from: '㉾', to: '㉾', mapping: Mapped("우") },
    Range { from: '㉿', to: '㉿', mapping: Valid },
    Range { from: '㊀', to: '㊀', mapping: Mapped("一") },
    Range { from: '㊁', to: '㊁', mapping: Mapped("二") },
    Range { from: '㊂', to: '㊂', mapping: Mapped("三") },
    Range { from: '㊃', to: '㊃', mapping: Mapped("四") },
    Range { from: '㊄', to: '㊄', mapping: Mapped("五") },
    Range { from: '㊅', to: '㊅', mapping: Mapped("六") },
    Range { from: '㊆', to: '㊆', mapping: Mapped("七") },
    Range { from: '㊇', to: '㊇', mapping: Mapped("八") },
    Range { from: '㊈', to: '㊈', mapping: Mapped("九") },
    Range { from: '㊉', to: '㊉', mapping: Mapped("十") },
    Range { from: '㊊', to: '㊊', mapping: Mapped("月") },
    Range { from: '㊋', to: '㊋', mapping: Mapped("火") },
    Range { from: '㊌', to: '㊌', mapping: Mapped("水") },
    Range { from: '㊍', to: '㊍', mapping: Mapped("木") },
    Range { from: '㊎', to: '㊎', mapping: Mapped("金") },
    Range { from: '㊏', to: '㊏', mapping: Mapped("土") },
    Range { from: '㊐', to: '㊐', mapping: Mapped("日") },
    Range { from: '㊑', to: '㊑', mapping: Mapped("株") },
    Range { from: '㊒', to: '㊒', mapping: Mapped("有") },
    Range { from: '㊓', to: '㊓', mapping: Mapped("社") },
    Range { from: '㊔', to: '㊔', mapping: Mapped("名") },
    Range { from: '㊕', to: '㊕', mapping: Mapped("特") },
    Range { from: '㊖', to: '㊖', mapping: Mapped("財") },
    Range { from: '㊗', to: '㊗', mapping: Mapped("祝") },
    Range { from: '㊘', to: '㊘', mapping: Mapped("労") },
    Range { from: '㊙', to: '㊙', mapping: Mapped("秘") },
    Range { from: '㊚', to: '㊚', mapping: Mapped("男") },
    Range { from: '㊛', to: '㊛', mapping: Mapped("女") },
    Range { from: '㊜', to: '㊜', mapping: Mapped("適") },
    Range { from: '㊝', to: '㊝', mapping: Mapped("優") },
    Range { from: '㊞', to: '㊞', mapping: Mapped("印") },
    Range { from: '㊟', to: '㊟', mapping: Mapped("注") },
    Range { from: '㊠', to: '㊠', mapping: Mapped("項") },
    Range { from: '㊡', to: '㊡', mapping: Mapped("休") },
    Range { from: '㊢', to: '㊢', mapping: Mapped("写") },
    Range { from: '㊣', to: '㊣', mapping: Mapped("正") },
    Range { from: '㊤', to: '㊤', mapping: Mapped("上") },
    Range { from: '㊥', to: '㊥', mapping: Mapped("中") },
    Range { from: '㊦', to: '㊦', mapping: Mapped("下") },
    Range { from: '㊧', to: '㊧', mapping: Mapped("左") },
    Range { from: '㊨', to: '㊨', mapping: Mapped("右") },
    Range { from: '㊩', to: '㊩', mapping: Mapped("医") },
    Range { from: '㊪', to: '㊪', mapping: Mapped("宗") },
    Range { from: '㊫', to: '㊫', mapping: Mapped("学") },
    Range { from: '㊬', to: '㊬', mapping: Mapped("監") },
    Range { from: '㊭', to: '㊭', mapping: Mapped("企") },
    Range { from: '㊮', to: '㊮', mapping: Mapped("資") },
    Range { from: '㊯', to: '㊯', mapping: Mapped("協") },
    Range { from: '㊰', to: '㊰', mapping: Mapped("夜") },
    Range { from: '㊱', to: '㊱', mapping: Mapped("36") },
    Range { from: '㊲', to: '㊲', mapping: Mapped("37") },
    Range { from: '㊳', to: '㊳', mapping: Mapped("38") },
    Range { from: '㊴', to: '㊴', mapping: Mapped("39") },
    Range { from: '㊵', to: '㊵', mapping: Mapped("40") },
    Range { from: '㊶', to: '㊶', mapping: Mapped("41") },
    Range { from: '㊷', to: '㊷', mapping: Mapped("42") },
    Range { from: '㊸', to: '㊸', mapping: Mapped("43") },
    Range { from: '㊹', to: '㊹', mapping: Mapped("44") },
    Range { from: '㊺', to: '㊺', mapping: Mapped("45") },
    Range { from: '㊻', to: '㊻', mapping: Mapped("46") },
    Range { from: '㊼', to: '㊼', mapping: Mapped("47") },
    Range { from: '㊽', to: '㊽', mapping: Mapped("48") },
    Range { from: '㊾', to: '㊾', mapping: Mapped("49") },
    Range { from: '㊿', to: '㊿', mapping: Mapped("50") },
    Range { from: '㋀', to: '㋀', mapping: Mapped("1月") },
    Range { from: '㋁', to: '㋁', mapping: Mapped("2月") },
    Range { from: '㋂', to: '㋂', mapping: Mapped("3月") },
    Range { from: '㋃', to: '㋃', mapping: Mapped("4月") },
    Range { from: '㋄', to: '㋄', mapping: Mapped("5月") },
    Range { from: '㋅', to: '㋅', mapping: Mapped("6月") },
    Range { from: '㋆', to: '㋆', mapping: Mapped("7月") },
    Range { from: '㋇', to: '㋇', mapping: Mapped("8月") },
    Range { from: '㋈', to: '㋈', mapping: Mapped("9月") },
    Range { from: '㋉', to: '㋉', mapping: Mapped("10月") },
    Range { from: '㋊', to: '㋊', mapping: Mapped("11月") },
    Range { from: '㋋', to: '㋋', mapping: Mapped("12月") },
    Range { from: '㋌', to: '㋌', mapping: Mapped("hg") },
    Range { from: '㋍', to: '㋍', mapping: Mapped("erg") },
    Range { from: '㋎', to: '㋎', mapping: Mapped("ev") },
    Range { from: '㋏', to: '㋏', mapping: Mapped("ltd") },
    Range { from: '㋐', to: '㋐', mapping: Mapped("ア") },
    Range { from: '㋑', to: '㋑', mapping: Mapped("イ") },
    Range { from: '㋒', to: '㋒', mapping: Mapped("ウ") },
    Range { from: '㋓', to: '㋓', mapping: Mapped("エ") },
    Range { from: '㋔', to: '㋔', mapping: Mapped("オ") },
    Range { from: '㋕', to: '㋕', mapping: Mapped("カ") },
    Range { from: '㋖', to: '㋖', mapping: Mapped("キ") },
    Range { from: '㋗', to: '㋗', mapping: Mapped("ク") },
    Range { from: '㋘', to: '㋘', mapping: Mapped("ケ") },
    Range { from: '㋙', to: '㋙', mapping: Mapped("コ") },
    Range { from: '㋚', to: '㋚', mapping: Mapped("サ") },
    Range { from: '㋛', to: '㋛', mapping: Mapped("シ") },
    Range { from: '㋜', to: '㋜', mapping: Mapped("ス") },
    Range { from: '㋝', to: '㋝', mapping: Mapped("セ") },
    Range { from: '㋞', to: '㋞', mapping: Mapped("ソ") },
    Range { from: '㋟', to: '㋟', mapping: Mapped("タ") },
    Range { from: '㋠', to: '㋠', mapping: Mapped("チ") },
    Range { from: '㋡', to: '㋡', mapping: Mapped("ツ") },
    Range { from: '㋢', to: '㋢', mapping: Mapped("テ") },
    Range { from: '㋣', to: '㋣', mapping: Mapped("ト") },
    Range { from: '㋤', to: '㋤', mapping: Mapped("ナ") },
    Range { from: '㋥', to: '㋥', mapping: Mapped("ニ") },
    Range { from: '㋦', to: '㋦', mapping: Mapped("ヌ") },
    Range { from: '㋧', to: '㋧', mapping: Mapped("ネ") },
    Range { from: '㋨', to: '㋨', mapping: Mapped("ノ") },
    Range { from: '㋩', to: '㋩', mapping: Mapped("ハ") },
    Range { from: '㋪', to: '㋪', mapping: Mapped("ヒ") },
    Range { from: '㋫', to: '㋫', mapping: Mapped("フ") },
    Range { from: '㋬', to: '㋬', mapping: Mapped("ヘ") },
    Range { from: '㋭', to: '㋭', mapping: Mapped("ホ") },
    Range { from: '㋮', to: '㋮', mapping: Mapped("マ") },
    Range { from: '㋯', to: '㋯', mapping: Mapped("ミ") },
    Range { from: '㋰', to: '㋰', mapping: Mapped("ム") },
    Range { from: '㋱', to: '㋱', mapping: Mapped("メ") },
    Range { from: '㋲', to: '㋲', mapping: Mapped("モ") },
    Range { from: '㋳', to: '㋳', mapping: Mapped("ヤ") },
    Range { from: '㋴', to: '㋴', mapping: Mapped("ユ") },
    Range { from: '㋵', to: '㋵', mapping: Mapped("ヨ") },
    Range { from: '㋶', to: '㋶', mapping: Mapped("ラ") },
    Range { from: '㋷', to: '㋷', mapping: Mapped("リ") },
    Range { from: '㋸', to: '㋸', mapping: Mapped("ル") },
    Range { from: '㋹', to: '㋹', mapping: Mapped("レ") },
    Range { from: '㋺', to: '㋺', mapping: Mapped("ロ") },
    Range { from: '㋻', to: '㋻', mapping: Mapped("ワ") },
    Range { from: '㋼', to: '㋼', mapping: Mapped("ヰ") },
    Range { from: '㋽', to: '㋽', mapping: Mapped("ヱ") },
    Range { from: '㋾', to: '㋾', mapping: Mapped("ヲ") },
    Range { from: '㋿', to: '㋿', mapping: Disallowed },
    Range { from: '㌀', to: '㌀', mapping: Mapped("アパート") },
    Range { from: '㌁', to: '㌁', mapping: Mapped("アルファ") },
    Range { from: '㌂', to: '㌂', mapping: Mapped("アンペア") },
    Range { from: '㌃', to: '㌃', mapping: Mapped("アール") },
    Range { from: '㌄', to: '㌄', mapping: Mapped("イニング") },
    Range { from: '㌅', to: '㌅', mapping: Mapped("インチ") },
    Range { from: '㌆', to: '㌆', mapping: Mapped("ウォン") },
    Range { from: '㌇', to: '㌇', mapping: Mapped("エスクード") },
    Range { from: '㌈', to: '㌈', mapping: Mapped("エーカー") },
    Range { from: '㌉', to: '㌉', mapping: Mapped("オンス") },
    Range { from: '㌊', to: '㌊', mapping: Mapped("オーム") },
    Range { from: '㌋', to: '㌋', mapping: Mapped("カイリ") },
    Range { from: '㌌', to: '㌌', mapping: Mapped("カラット") },
    Range { from: '㌍', to: '㌍', mapping: Mapped("カロリー") },
    Range { from: '㌎', to: '㌎', mapping: Mapped("ガロン") },
    Range { from: '㌏', to: '㌏', mapping: Mapped("ガンマ") },
    Range { from: '㌐', to: '㌐', mapping: Mapped("ギガ") },
    Range { from: '㌑', to: '㌑', mapping: Mapped("ギニー") },
    Range { from: '㌒', to: '㌒', mapping: Mapped("キュリー") },
    Range { from: '㌓', to: '㌓', mapping: Mapped("ギルダー") },
    Range { from: '㌔', to: '㌔', mapping: Mapped("キロ") },
    Range { from: '㌕', to: '㌕', mapping: Mapped("キログラム") },
    Range { from: '㌖', to: '㌖', mapping: Mapped("キロメートル") },
    Range { from: '㌗', to: '㌗', mapping: Mapped("キロワット") },
    Range { from: '㌘', to: '㌘', mapping: Mapped("グラム") },
    Range { from: '㌙', to: '㌙', mapping: Mapped("グラムトン") },
    Range { from: '㌚', to: '㌚', mapping: Mapped("クルゼイロ") },
    Range { from: '㌛', to: '㌛', mapping: Mapped("クローネ") },
    Range { from: '㌜', to: '㌜', mapping: Mapped("ケース") },
    Range { from: '㌝', to: '㌝', mapping: Mapped("コルナ") },
    Range { from: '㌞', to: '㌞', mapping: Mapped("コーポ") },
    Range { from: '㌟', to: '㌟', mapping: Mapped("サイクル") },
    Range { from: '㌠', to: '㌠', mapping: Mapped("サンチーム") },
    Range { from: '㌡', to: '㌡', mapping: Mapped("シリング") },
    Range { from: '㌢', to: '㌢', mapping: Mapped("センチ") },
    Range { from: '㌣', to: '㌣', mapping: Mapped("セント") },
    Range { from: '㌤', to: '㌤', mapping: Mapped("ダース") },
    Range { from: '㌥', to: '㌥', mapping: Mapped("デシ") },
    Range { from: '㌦', to: '㌦', mapping: Mapped("ドル") },
    Range { from: '㌧', to: '㌧', mapping: Mapped("トン") },
    Range { from: '㌨', to: '㌨', mapping: Mapped("ナノ") },
    Range { from: '㌩', to: '㌩', mapping: Mapped("ノット") },
    Range { from: '㌪', to: '㌪', mapping: Mapped("ハイツ") },
    Range { from: '㌫', to: '㌫', mapping: Mapped("パーセント") },
    Range { from: '㌬', to: '㌬', mapping: Mapped("パーツ") },
    Range { from: '㌭', to: '㌭', mapping: Mapped("バーレル") },
    Range { from: '㌮', to: '㌮', mapping: Mapped("ピアストル") },
    Range { from: '㌯', to: '㌯', mapping: Mapped("ピクル") },
    Range { from: '㌰', to: '㌰', mapping: Mapped("ピコ") },
    Range { from: '㌱', to: '㌱', mapping: Mapped("ビル") },
    Range { from: '㌲', to: '㌲', mapping: Mapped("ファラッド") },
    Range { from: '㌳', to: '㌳', mapping: Mapped("フィート") },
    Range { from: '㌴', to: '㌴', mapping: Mapped("ブッシェル") },
    Range { from: '㌵', to: '㌵', mapping: Mapped("フラン") },
    Range { from: '㌶', to: '㌶', mapping: Mapped("ヘクタール") },
    Range { from: '㌷', to: '㌷', mapping: Mapped("ペソ") },
    Range { from: '㌸', to: '㌸', mapping: Mapped("ペニヒ") },
    Range { from: '㌹', to: '㌹', mapping: Mapped("ヘルツ") },
    Range { from: '㌺', to: '㌺', mapping: Mapped("ペンス") },
    Range { from: '㌻', to: '㌻', mapping: Mapped("ページ") },
    Range { from: '㌼', to: '㌼', mapping: Mapped("ベータ") },
    Range { from: '㌽', to: '㌽', mapping: Mapped("ポイント") },
    Range { from: '㌾', to: '㌾', mapping: Mapped("ボルト") },
    Range { from: '㌿', to: '㌿', mapping: Mapped("ホン") },
    Range { from: '㍀', to: '㍀', mapping: Mapped("ポンド") },
    Range { from: '㍁', to: '㍁', mapping: Mapped("ホール") },
    Range { from: '㍂', to: '㍂', mapping: Mapped("ホーン") },
    Range { from: '㍃', to: '㍃', mapping: Mapped("マイクロ") },
    Range { from: '㍄', to: '㍄', mapping: Mapped("マイル") },
    Range { from: '㍅', to: '㍅', mapping: Mapped("マッハ") },
    Range { from: '㍆', to: '㍆', mapping: Mapped("マルク") },
    Range { from: '㍇', to: '㍇', mapping: Mapped("マンション") },
    Range { from: '㍈', to: '㍈', mapping: Mapped("ミクロン") },
    Range { from: '㍉', to: '㍉', mapping: Mapped("ミリ") },
    Range { from: '㍊', to: '㍊', mapping: Mapped("ミリバール") },
    Range { from: '㍋', to: '㍋', mapping: Mapped("メガ") },
    Range { from: '㍌', to: '㍌', mapping: Mapped("メガトン") },
    Range { from: '㍍', to: '㍍', mapping: Mapped("メートル") },
    Range { from: '㍎', to: '㍎', mapping: Mapped("ヤード") },
    Range { from: '㍏', to: '㍏', mapping: Mapped("ヤール") },
    Range { from: '㍐', to: '㍐', mapping: Mapped("ユアン") },
    Range { from: '㍑', to: '㍑', mapping: Mapped("リットル") },
    Range { from: '㍒', to: '㍒', mapping: Mapped("リラ") },
    Range { from: '㍓', to: '㍓', mapping: Mapped("ルピー") },
    Range { from: '㍔', to: '㍔', mapping: Mapped("ルーブル") },
    Range { from: '㍕', to: '㍕', mapping: Mapped("レム") },
    Range { from: '㍖', to: '㍖', mapping: Mapped("レントゲン") },
    Range { from: '㍗', to: '㍗', mapping: Mapped("ワット") },
    Range { from: '㍘', to: '㍘', mapping: Mapped("0点") },
    Range { from: '㍙', to: '㍙', mapping: Mapped("1点") },
    Range { from: '㍚', to: '㍚', mapping: Mapped("2点") },
    Range { from: '㍛', to: '㍛', mapping: Mapped("3点") },
    Range { from: '㍜', to: '㍜', mapping: Mapped("4点") },
    Range { from: '㍝', to: '㍝', mapping: Mapped("5点") },
    Range { from: '㍞', to: '㍞', mapping: Mapped("6点") },
    Range { from: '㍟', to: '㍟', mapping: Mapped("7点") },
    Range { from: '㍠', to: '㍠', mapping: Mapped("8点") },
    Range { from: '㍡', to: '㍡', mapping: Mapped("9点") },
    Range { from: '㍢', to: '㍢', mapping: Mapped("10点") },
    Range { from: '㍣', to: '㍣', mapping: Mapped("11点") },
    Range { from: '㍤', to: '㍤', mapping: Mapped("12点") },
    Range { from: '㍥', to: '㍥', mapping: Mapped("13点") },
    Range { from: '㍦', to: '㍦', mapping: Mapped("14点") },
    Range { from: '㍧', to: '㍧', mapping: Mapped("15点") },
    Range { from: '㍨', to: '㍨', mapping: Mapped("16点") },
    Range { from: '㍩', to: '㍩', mapping: Mapped("17点") },
    Range { from: '㍪', to: '㍪', mapping: Mapped("18点") },
    Range { from: '㍫', to: '㍫', mapping: Mapped("19点") },
    Range { from: '㍬', to: '㍬', mapping: Mapped("20点") },
    Range { from: '㍭', to: '㍭', mapping: Mapped("21点") },
    Range { from: '㍮', to: '㍮', mapping: Mapped("22点") },
    Range { from: '㍯', to: '㍯', mapping: Mapped("23点") },
    Range { from: '㍰', to: '㍰', mapping: Mapped("24点") },
    Range { from: '㍱', to: '㍱', mapping: Mapped("hpa") },
    Range { from: '㍲', to: '㍲', mapping: Mapped("da") },
    Range { from: '㍳', to: '㍳', mapping: Mapped("au") },
    Range { from: '㍴', to: '㍴', mapping: Mapped("bar") },
    Range { from: '㍵', to: '㍵', mapping: Mapped("ov") },
    Range { from: '㍶', to: '㍶', mapping: Mapped("pc") },
    Range { from: '㍷', to: '㍷', mapping: Mapped("dm") },
    Range { from: '㍸', to: '㍸', mapping: Mapped("dm2") },
    Range { from: '㍹', to: '㍹', mapping: Mapped("dm3") },
    Range { from: '㍺', to: '㍺', mapping: Mapped("iu") },
    Range { from: '㍻', to: '㍻', mapping: Mapped("平成") },
    Range { from: '㍼', to: '㍼', mapping: Mapped("昭和") },
    Range { from: '㍽', to: '㍽', mapping: Mapped("大正") },
    Range { from: '㍾', to: '㍾', mapping: Mapped("明治") },
    Range { from: '㍿', to: '㍿', mapping: Mapped("株式会社") },
    Range { from: '㎀', to: '㎀', mapping: Mapped("pa") },
    Range { from: '㎁', to: '㎁', mapping: Mapped("na") },
    Range { from: '㎂', to: '㎂', mapping: Mapped("μa") },
    Range { from: '㎃', to: '㎃', mapping: Mapped("ma") },
    Range { from: '㎄', to: '㎄', mapping: Mapped("ka") },
    Range { from: '㎅', to: '㎅', mapping: Mapped("kb") },
    Range { from: '㎆', to: '㎆', mapping: Mapped("mb") },
    Range { from: '㎇', to: '㎇', mapping: Mapped("gb") },
    Range { from: '㎈', to: '㎈', mapping: Mapped("cal") },
    Range { from: '㎉', to: '㎉', mapping: Mapped("kcal") },
    Range { from: '㎊', to: '㎊', mapping: Mapped("pf") },
    Range { from: '㎋', to: '㎋', mapping: Mapped("nf") },
    Range { from: '㎌', to: '㎌', mapping: Mapped("μf") },
    Range { from: '㎍', to: '㎍', mapping: Mapped("μg") },
    Range { from: '㎎', to: '㎎', mapping: Mapped("mg") },
    Range { from: '㎏', to: '㎏', mapping: Mapped("kg") },
    Range { from: '㎐', to: '㎐', mapping: Mapped("hz") },
    Range { from: '㎑', to: '㎑', mapping: Mapped("khz") },
    Range { from: '㎒', to: '㎒', mapping: Mapped("mhz") },
    Range { from: '㎓', to: '㎓', mapping: Mapped("ghz") },
    Range { from: '㎔', to: '㎔', mapping: Mapped("thz") },
    Range { from: '㎕', to: '㎕', mapping: Mapped("μl") },
    Range { from: '㎖', to: '㎖', mapping: Mapped("ml") },
    Range { from: '㎗', to: '㎗', mapping: Mapped("dl") },
    Range { from: '㎘', to: '㎘', mapping: Mapped("kl") },
    Range { from: '㎙', to: '㎙', mapping: Mapped("fm") },
    Range { from: '㎚', to: '㎚', mapping: Mapped("nm") },
    Range { from: '㎛', to: '㎛', mapping: Mapped("μm") },
    Range { from: '㎜', to: '㎜', mapping: Mapped("mm") },
    Range { from: '㎝', to: '㎝', mapping: Mapped("cm") },
    Range { from: '㎞', to: '㎞', mapping: Mapped("km") },
    Range { from: '㎟', to: '㎟', mapping: Mapped("mm2") },
    Range { from: '㎠', to: '㎠', mapping: Mapped("cm2") },
    Range { from: '㎡', to: '㎡', mapping: Mapped("m2") },
    Range { from: '㎢', to: '㎢', mapping: Mapped("km2") },
    Range { from: '㎣', to: '㎣', mapping: Mapped("mm3") },
    Range { from: '㎤', to: '㎤', mapping: Mapped("cm3") },
    Range { from: '㎥', to: '㎥', mapping: Mapped("m3") },
    Range { from: '㎦', to: '㎦', mapping: Mapped("km3") },
    Range { from: '㎧', to: '㎧', mapping: Mapped("m∕s") },
    Range { from: '㎨', to: '㎨', mapping: Mapped("m∕s2") },
    Range { from: '㎩', to: '㎩', mapping: Mapped("pa") },
    Range { from: '㎪', to: '㎪', mapping: Mapped("kpa") },
    Range { from: '㎫', to: '㎫', mapping: Mapped("mpa") },
    Range { from: '㎬', to: '㎬', mapping: Mapped("gpa") },
    Range { from: '㎭', to: '㎭', mapping: Mapped("rad") },
    Range { from: '㎮', to: '㎮', mapping: Mapped("rad∕s") },
    Range { from: '㎯', to: '㎯', mapping: Mapped("rad∕s2") },
    Range { from: '㎰', to: '㎰', mapping: Mapped("ps") },
    Range { from: '㎱', to: '㎱', mapping: Mapped("ns") },
    Range { from: '㎲', to: '㎲', mapping: Mapped("μs") },
    Range { from: '㎳', to: '㎳', mapping: Mapped("ms") },
    Range { from: '㎴', to: '㎴', mapping: Mapped("pv") },
    Range { from: '㎵', to: '㎵', mapping: Mapped("nv") },
    Range { from: '㎶', to: '㎶', mapping: Mapped("μv") },
    Range { from: '㎷', to: '㎷', mapping: Mapped("mv") },
    Range { from: '㎸', to: '㎸', mapping: Mapped("kv") },
    Range { from: '㎹', to: '㎹', mapping: Mapped("mv") },
    Range { from: '㎺', to: '㎺', mapping: Mapped("pw") },
    Range { from: '㎻', to: '㎻', mapping: Mapped("nw") },
    Range { from: '㎼', to: '㎼', mapping: Mapped("μw") },
    Range { from: '㎽', to: '㎽', mapping: Mapped("mw") },
    Range { from: '㎾', to: '㎾', mapping: Mapped("kw") },
    Range { from: '㎿', to: '㎿', mapping: Mapped("mw") },
    Range { from: '㏀', to: '㏀', mapping: Mapped("kω") },
    Range { from: '㏁', to: '㏁', mapping: Mapped("mω") },
    Range { from: '㏂', to: '㏂', mapping: Disallowed },
    Range { from: '㏃', to: '㏃', mapping: Mapped("bq") },
    Range { from: '㏄', to: '㏄', mapping: Mapped("cc") },
    Range { from: '㏅', to: '㏅', mapping: Mapped("cd") },
    Range { from: '㏆', to: '㏆', mapping: Mapped("c∕kg") },
    Range { from: '㏇', to: '㏇', mapping: Disallowed },
    Range { from: '㏈', to: '㏈', mapping: Mapped("db") },
    Range { from: '㏉', to: '㏉', mapping: Mapped("gy") },
    Range { from: '㏊', to: '㏊', mapping: Mapped("ha") },
    Range { from: '㏋', to: '㏋', mapping: Mapped("hp") },
    Range { from: '㏌', to: '㏌', mapping: Mapped("in") },
    Range { from: '㏍', to: '㏍', mapping: Mapped("kk") },
    Range { from: '㏎', to: '㏎', mapping: Mapped("km") },
    Range { from: '㏏', to: '㏏', mapping: Mapped("kt") },
    Range { from: '㏐', to: '㏐', mapping: Mapped("lm") },
    Range { from: '㏑', to: '㏑', mapping: Mapped("ln") },
    Range { from: '㏒', to: '㏒', mapping: Mapped("log") },
    Range { from: '㏓', to: '㏓', mapping: Mapped("lx") },
    Range { from: '㏔', to: '㏔', mapping: Mapped("mb") },
    Range { from: '㏕', to: '㏕', mapping: Mapped("mil") },
    Range { from: '㏖', to: '㏖', mapping: Mapped("mol") },
    Range { from: '㏗', to: '㏗', mapping: Mapped("ph") },
    Range { from: '㏘', to: '㏘', mapping: Disallowed },
    Range { from: '㏙', to: '㏙', mapping: Mapped("ppm") },
    Range { from: '㏚', to: '㏚', mapping: Mapped("pr") },
    Range { from: '㏛', to: '㏛', mapping: Mapped("sr") },
    Range { from: '㏜', to: '㏜', mapping: Mapped("sv") },
    Range { from: '㏝', to: '㏝', mapping: Mapped("wb") },
    Range { from: '㏞', to: '㏞', mapping: Mapped("v∕m") },
    Range { from: '㏟', to: '㏟', mapping: Mapped("a∕m") },
    Range { from: '㏠', to: '㏠', mapping: Mapped("1日") },
    Range { from: '㏡', to: '㏡', mapping: Mapped("2日") },
    Range { from: '㏢', to: '㏢', mapping: Mapped("3日") },
    Range { from: '㏣', to: '㏣', mapping: Mapped("4日") },
    Range { from: '㏤', to: '㏤', mapping: Mapped("5日") },
    Range { from: '㏥', to: '㏥', mapping: Mapped("6日") },
    Range { from: '㏦', to: '㏦', mapping: Mapped("7日") },
    Range { from: '㏧', to: '㏧', mapping: Mapped("8日") },
    Range { from: '㏨', to: '㏨', mapping: Mapped("9日") },
    Range { from: '㏩', to: '㏩', mapping: Mapped("10日") },
    Range { from: '㏪', to: '㏪', mapping: Mapped("11日") },
    Range { from: '㏫', to: '㏫', mapping: Mapped("12日") },
    Range { from: '㏬', to: '㏬', mapping: Mapped("13日") },
    Range { from: '㏭', to: '㏭', mapping: Mapped("14日") },
    Range { from: '㏮', to: '㏮', mapping: Mapped("15日") },
    Range { from: '㏯', to: '㏯', mapping: Mapped("16日") },
    Range { from: '㏰', to: '㏰', mapping: Mapped("17日") },
    Range { from: '㏱', to: '㏱', mapping: Mapped("18日") },
    Range { from: '㏲', to: '㏲', mapping: Mapped("19日") },
    Range { from: '㏳', to: '㏳', mapping: Mapped("20日") },
    Range { from: '㏴', to: '㏴', mapping: Mapped("21日") },
    Range { from: '㏵', to: '㏵', mapping: Mapped("22日") },
    Range { from: '㏶', to: '㏶', mapping: Mapped("23日") },
    Range { from: '㏷', to: '㏷', mapping: Mapped("24日") },
    Range { from: '㏸', to: '㏸', mapping: Mapped("25日") },
    Range { from: '㏹', to: '㏹', mapping: Mapped("26日") },
    Range { from: '㏺', to: '㏺', mapping: Mapped("27日") },
    Range { from: '㏻', to: '㏻', mapping: Mapped("28日") },
    Range { from: '㏼', to: '㏼', mapping: Mapped("29日") },
    Range { from: '㏽', to: '㏽', mapping: Mapped("30日") },
    Range { from: '㏾', to: '㏾', mapping: Mapped("31日") },
    Range { from: '㏿', to: '㏿', mapping: Mapped("gal") },
    Range { from: '㐀', to: '䶵', mapping: Valid },
    Range { from: '䶶', to: '䶿', mapping: Disallowed },
    Range { from: '䷀', to: '䷿', mapping: Valid },
    Range { from: '一', to: '龥', mapping: Valid },
    Range { from: '龦', to: '龻', mapping: Valid },
    Range { from: '龼', to: '鿃', mapping: Valid },
    Range { from: '鿄', to: '鿋', mapping: Valid },
    Range { from: '鿌', to: '鿌', mapping: Valid },
    Range { from: '鿍', to: '鿕', mapping: Valid },
    Range { from: '鿖', to: '鿿', mapping: Disallowed },
    Range { from: 'ꀀ', to: 'ꒌ', mapping: Valid },
    Range { from: '꒍', to: '꒏', mapping: Disallowed },
    Range { from: '꒐', to: '꒡', mapping: Valid },
    Range { from: '꒢', to: '꒣', mapping: Valid },
    Range { from: '꒤', to: '꒳', mapping: Valid },
    Range { from: '꒴', to: '꒴', mapping: Valid },
    Range { from: '꒵', to: '꓀', mapping: Valid },
    Range { from: '꓁', to: '꓁', mapping: Valid },
    Range { from: '꓂', to: '꓄', mapping: Valid },
    Range { from: '꓅', to: '꓅', mapping: Valid },
    Range { from: '꓆', to: '꓆', mapping: Valid },
    Range { from: '꓇', to: '꓏', mapping: Disallowed },
    Range { from: 'ꓐ', to: 'ꓽ', mapping: Valid },
    Range { from: '꓾', to: '꓿', mapping: Valid },
    Range { from: 'ꔀ', to: 'ꘌ', mapping: Valid },
    Range { from: '꘍', to: '꘏', mapping: Valid },
    Range { from: 'ꘐ', to: 'ꘫ', mapping: Valid },
    Range { from: '꘬', to: '꘿', mapping: Disallowed },
    Range { from: 'Ꙁ', to: 'Ꙁ', mapping: Mapped("ꙁ") },
    Range { from: 'ꙁ', to: 'ꙁ', mapping: Valid },
    Range { from: 'Ꙃ', to: 'Ꙃ', mapping: Mapped("ꙃ") },
    Range { from: 'ꙃ', to: 'ꙃ', mapping: Valid },
    Range { from: 'Ꙅ', to: 'Ꙅ', mapping: Mapped("ꙅ") },
    Range { from: 'ꙅ', to: 'ꙅ', mapping: Valid },
    Range { from: 'Ꙇ', to: 'Ꙇ', mapping: Mapped("ꙇ") },
    Range { from: 'ꙇ', to: 'ꙇ', mapping: Valid },
    Range { from: 'Ꙉ', to: 'Ꙉ', mapping: Mapped("ꙉ") },
    Range { from: 'ꙉ', to: 'ꙉ', mapping: Valid },
    Range { from: 'Ꙋ', to: 'Ꙋ', mapping: Mapped("ꙋ") },
    Range { from: 'ꙋ', to: 'ꙋ', mapping: Valid },
    Range { from: 'Ꙍ', to: 'Ꙍ', mapping: Mapped("ꙍ") },
    Range { from: 'ꙍ', to: 'ꙍ', mapping: Valid },
    Range { from: 'Ꙏ', to: 'Ꙏ', mapping: Mapped("ꙏ") },
    Range { from: 'ꙏ', to: 'ꙏ', mapping: Valid },
    Range { from: 'Ꙑ', to: 'Ꙑ', mapping: Mapped("ꙑ") },
    Range { from: 'ꙑ', to: 'ꙑ', mapping: Valid },
    Range { from: 'Ꙓ', to: 'Ꙓ', mapping: Mapped("ꙓ") },
    Range { from: 'ꙓ', to: 'ꙓ', mapping: Valid },
    Range { from: 'Ꙕ', to: 'Ꙕ', mapping: Mapped("ꙕ") },
    Range { from: 'ꙕ', to: 'ꙕ', mapping: Valid },
    Range { from: 'Ꙗ', to: 'Ꙗ', mapping: Mapped("ꙗ") },
    Range { from: 'ꙗ', to: 'ꙗ', mapping: Valid },
    Range { from: 'Ꙙ', to: 'Ꙙ', mapping: Mapped("ꙙ") },
    Range { from: 'ꙙ', to: 'ꙙ', mapping: Valid },
    Range { from: 'Ꙛ', to: 'Ꙛ', mapping: Mapped("ꙛ") },
    Range { from: 'ꙛ', to: 'ꙛ', mapping: Valid },
    Range { from: 'Ꙝ', to: 'Ꙝ', mapping: Mapped("ꙝ") },
    Range { from: 'ꙝ', to: 'ꙝ', mapping: Valid },
    Range { from: 'Ꙟ', to: 'Ꙟ', mapping: Mapped("ꙟ") },
    Range { from: 'ꙟ', to: 'ꙟ', mapping: Valid },
    Range { from: 'Ꙡ', to: 'Ꙡ', mapping: Mapped("ꙡ") },
    Range { from: 'ꙡ', to: 'ꙡ', mapping: Valid },
    Range { from: 'Ꙣ', to: 'Ꙣ', mapping: Mapped("ꙣ") },
    Range { from: 'ꙣ', to: 'ꙣ', mapping: Valid },
    Range { from: 'Ꙥ', to: 'Ꙥ', mapping: Mapped("ꙥ") },
    Range { from: 'ꙥ', to: 'ꙥ', mapping: Valid },
    Range { from: 'Ꙧ', to: 'Ꙧ', mapping: Mapped("ꙧ") },
    Range { from: 'ꙧ', to: 'ꙧ', mapping: Valid },
    Range { from: 'Ꙩ', to: 'Ꙩ', mapping: Mapped("ꙩ") },
    Range { from: 'ꙩ', to: 'ꙩ', mapping: Valid },
    Range { from: 'Ꙫ', to: 'Ꙫ', mapping: Mapped("ꙫ") },
    Range { from: 'ꙫ', to: 'ꙫ', mapping: Valid },
    Range { from: 'Ꙭ', to: 'Ꙭ', mapping: Mapped("ꙭ") },
    Range { from: 'ꙭ', to: '꙯', mapping: Valid },
    Range { from: '꙰', to: '꙳', mapping: Valid },
    Range { from: 'ꙴ', to: 'ꙻ', mapping: Valid },
    Range { from: '꙼', to: '꙽', mapping: Valid },
    Range { from: '꙾', to: '꙾', mapping: Valid },
    Range { from: 'ꙿ', to: 'ꙿ', mapping: Valid },
    Range { from: 'Ꚁ', to: 'Ꚁ', mapping: Mapped("ꚁ") },
    Range { from: 'ꚁ', to: 'ꚁ', mapping: Valid },
    Range { from: 'Ꚃ', to: 'Ꚃ', mapping: Mapped("ꚃ") },
    Range { from: 'ꚃ', to: 'ꚃ', mapping: Valid },
    Range { from: 'Ꚅ', to: 'Ꚅ', mapping: Mapped("ꚅ") },
    Range { from: 'ꚅ', to: 'ꚅ', mapping: Valid },
    Range { from: 'Ꚇ', to: 'Ꚇ', mapping: Mapped("ꚇ") },
    Range { from: 'ꚇ', to: 'ꚇ', mapping: Valid },
    Range { from: 'Ꚉ', to: 'Ꚉ', mapping: Mapped("ꚉ") },
    Range { from: 'ꚉ', to: 'ꚉ', mapping: Valid },
    Range { from: 'Ꚋ', to: 'Ꚋ', mapping: Mapped("ꚋ") },
    Range { from: 'ꚋ', to: 'ꚋ', mapping: Valid },
    Range { from: 'Ꚍ', to: 'Ꚍ', mapping: Mapped("ꚍ") },
    Range { from: 'ꚍ', to: 'ꚍ', mapping: Valid },
    Range { from: 'Ꚏ', to: 'Ꚏ', mapping: Mapped("ꚏ") },
    Range { from: 'ꚏ', to: 'ꚏ', mapping: Valid },
    Range { from: 'Ꚑ', to: 'Ꚑ', mapping: Mapped("ꚑ") },
    Range { from: 'ꚑ', to: 'ꚑ', mapping: Valid },
    Range { from: 'Ꚓ', to: 'Ꚓ', mapping: Mapped("ꚓ") },
    Range { from: 'ꚓ', to: 'ꚓ', mapping: Valid },
    Range { from: 'Ꚕ', to: 'Ꚕ', mapping: Mapped("ꚕ") },
    Range { from: 'ꚕ', to: 'ꚕ', mapping: Valid },
    Range { from: 'Ꚗ', to: 'Ꚗ', mapping: Mapped("ꚗ") },
    Range { from: 'ꚗ', to: 'ꚗ', mapping: Valid },
    Range { from: 'Ꚙ', to: 'Ꚙ', mapping: Mapped("ꚙ") },
    Range { from: 'ꚙ', to: 'ꚙ', mapping: Valid },
    Range { from: 'Ꚛ', to: 'Ꚛ', mapping: Mapped("ꚛ") },
    Range { from: 'ꚛ', to: 'ꚛ', mapping: Valid },
    Range { from: 'ꚜ', to: 'ꚜ', mapping: Mapped("ъ") },
    Range { from: 'ꚝ', to: 'ꚝ', mapping: Mapped("ь") },
    Range { from: 'ꚞ', to: 'ꚞ', mapping: Valid },
    Range { from: 'ꚟ', to: 'ꚟ', mapping: Valid },
    Range { from: 'ꚠ', to: 'ꛥ', mapping: Valid },
    Range { from: 'ꛦ', to: 'ꛯ', mapping: Valid },
    Range { from: '꛰', to: '꛱', mapping: Valid },
    Range { from: '꛲', to: '꛷', mapping: Valid },
    Range { from: '꛸', to: '꛿', mapping: Disallowed },
    Range { from: '꜀', to: '꜖', mapping: Valid },
    Range { from: 'ꜗ', to: 'ꜚ', mapping: Valid },
    Range { from: 'ꜛ', to: 'ꜟ', mapping: Valid },
    Range { from: '꜠', to: '꜡', mapping: Valid },
    Range { from: 'Ꜣ', to: 'Ꜣ', mapping: Mapped("ꜣ") },
    Range { from: 'ꜣ', to: 'ꜣ', mapping: Valid },
    Range { from: 'Ꜥ', to: 'Ꜥ', mapping: Mapped("ꜥ") },
    Range { from: 'ꜥ', to: 'ꜥ', mapping: Valid },
    Range { from: 'Ꜧ', to: 'Ꜧ', mapping: Mapped("ꜧ") },
    Range { from: 'ꜧ', to: 'ꜧ', mapping: Valid },
    Range { from: 'Ꜩ', to: 'Ꜩ', mapping: Mapped("ꜩ") },
    Range { from: 'ꜩ', to: 'ꜩ', mapping: Valid },
    Range { from: 'Ꜫ', to: 'Ꜫ', mapping: Mapped("ꜫ") },
    Range { from: 'ꜫ', to: 'ꜫ', mapping: Valid },
    Range { from: 'Ꜭ', to: 'Ꜭ', mapping: Mapped("ꜭ") },
    Range { from: 'ꜭ', to: 'ꜭ', mapping: Valid },
    Range { from: 'Ꜯ', to: 'Ꜯ', mapping: Mapped("ꜯ") },
    Range { from: 'ꜯ', to: 'ꜱ', mapping: Valid },
    Range { from: 'Ꜳ', to: 'Ꜳ', mapping: Mapped("ꜳ") },
    Range { from: 'ꜳ', to: 'ꜳ', mapping: Valid },
    Range { from: 'Ꜵ', to: 'Ꜵ', mapping: Mapped("ꜵ") },
    Range { from: 'ꜵ', to: 'ꜵ', mapping: Valid },
    Range { from: 'Ꜷ', to: 'Ꜷ', mapping: Mapped("ꜷ") },
    Range { from: 'ꜷ', to: 'ꜷ', mapping: Valid },
    Range { from: 'Ꜹ', to: 'Ꜹ', mapping: Mapped("ꜹ") },
    Range { from: 'ꜹ', to: 'ꜹ', mapping: Valid },
    Range { from: 'Ꜻ', to: 'Ꜻ', mapping: Mapped("ꜻ") },
    Range { from: 'ꜻ', to: 'ꜻ', mapping: Valid },
    Range { from: 'Ꜽ', to: 'Ꜽ', mapping: Mapped("ꜽ") },
    Range { from: 'ꜽ', to: 'ꜽ', mapping: Valid },
    Range { from: 'Ꜿ', to: 'Ꜿ', mapping: Mapped("ꜿ") },
    Range { from: 'ꜿ', to: 'ꜿ', mapping: Valid },
    Range { from: 'Ꝁ', to: 'Ꝁ', mapping: Mapped("ꝁ") },
    Range { from: 'ꝁ', to: 'ꝁ', mapping: Valid },
    Range { from: 'Ꝃ', to: 'Ꝃ', mapping: Mapped("ꝃ") },
    Range { from: 'ꝃ', to: 'ꝃ', mapping: Valid },
    Range { from: 'Ꝅ', to: 'Ꝅ', mapping: Mapped("ꝅ") },
    Range { from: 'ꝅ', to: 'ꝅ', mapping: Valid },
    Range { from: 'Ꝇ', to: 'Ꝇ', mapping: Mapped("ꝇ") },
    Range { from: 'ꝇ', to: 'ꝇ', mapping: Valid },
    Range { from: 'Ꝉ', to: 'Ꝉ', mapping: Mapped("ꝉ") },
    Range { from: 'ꝉ', to: 'ꝉ', mapping: Valid },
    Range { from: 'Ꝋ', to: 'Ꝋ', mapping: Mapped("ꝋ") },
    Range { from: 'ꝋ', to: 'ꝋ', mapping: Valid },
    Range { from: 'Ꝍ', to: 'Ꝍ', mapping: Mapped("ꝍ") },
    Range { from: 'ꝍ', to: 'ꝍ', mapping: Valid },
    Range { from: 'Ꝏ', to: 'Ꝏ', mapping: Mapped("ꝏ") },
    Range { from: 'ꝏ', to: 'ꝏ', mapping: Valid },
    Range { from: 'Ꝑ', to: 'Ꝑ', mapping: Mapped("ꝑ") },
    Range { from: 'ꝑ', to: 'ꝑ', mapping: Valid },
    Range { from: 'Ꝓ', to: 'Ꝓ', mapping: Mapped("ꝓ") },
    Range { from: 'ꝓ', to: 'ꝓ', mapping: Valid },
    Range { from: 'Ꝕ', to: 'Ꝕ', mapping: Mapped("ꝕ") },
    Range { from: 'ꝕ', to: 'ꝕ', mapping: Valid },
    Range { from: 'Ꝗ', to: 'Ꝗ', mapping: Mapped("ꝗ") },
    Range { from: 'ꝗ', to: 'ꝗ', mapping: Valid },
    Range { from: 'Ꝙ', to: 'Ꝙ', mapping: Mapped("ꝙ") },
    Range { from: 'ꝙ', to: 'ꝙ', mapping: Valid },
    Range { from: 'Ꝛ', to: 'Ꝛ', mapping: Mapped("ꝛ") },
    Range { from: 'ꝛ', to: 'ꝛ', mapping: Valid },
    Range { from: 'Ꝝ', to: 'Ꝝ', mapping: Mapped("ꝝ") },
    Range { from: 'ꝝ', to: 'ꝝ', mapping: Valid },
    Range { from: 'Ꝟ', to: 'Ꝟ', mapping: Mapped("ꝟ") },
    Range { from: 'ꝟ', to: 'ꝟ', mapping: Valid },
    Range { from: 'Ꝡ', to: 'Ꝡ', mapping: Mapped("ꝡ") },
    Range { from: 'ꝡ', to: 'ꝡ', mapping: Valid },
    Range { from: 'Ꝣ', to: 'Ꝣ', mapping: Mapped("ꝣ") },
    Range { from: 'ꝣ', to: 'ꝣ', mapping: Valid },
    Range { from: 'Ꝥ', to: 'Ꝥ', mapping: Mapped("ꝥ") },
    Range { from: 'ꝥ', to: 'ꝥ', mapping: Valid },
    Range { from: 'Ꝧ', to: 'Ꝧ', mapping: Mapped("ꝧ") },
    Range { from: 'ꝧ', to: 'ꝧ', mapping: Valid },
    Range { from: 'Ꝩ', to: 'Ꝩ', mapping: Mapped("ꝩ") },
    Range { from: 'ꝩ', to: 'ꝩ', mapping: Valid },
    Range { from: 'Ꝫ', to: 'Ꝫ', mapping: Mapped("ꝫ") },
    Range { from: 'ꝫ', to: 'ꝫ', mapping: Valid },
    Range { from: 'Ꝭ', to: 'Ꝭ', mapping: Mapped("ꝭ") },
    Range { from: 'ꝭ', to: 'ꝭ', mapping: Valid },
    Range { from: 'Ꝯ', to: 'Ꝯ', mapping: Mapped("ꝯ") },
    Range { from: 'ꝯ', to: 'ꝯ', mapping: Valid },
    Range { from: 'ꝰ', to: 'ꝰ', mapping: Mapped("ꝯ") },
    Range { from: 'ꝱ', to: 'ꝸ', mapping: Valid },
    Range { from: 'Ꝺ', to: 'Ꝺ', mapping: Mapped("ꝺ") },
    Range { from: 'ꝺ', to: 'ꝺ', mapping: Valid },
    Range { from: 'Ꝼ', to: 'Ꝼ', mapping: Mapped("ꝼ") },
    Range { from: 'ꝼ', to: 'ꝼ', mapping: Valid },
    Range { from: 'Ᵹ', to: 'Ᵹ', mapping: Mapped("ᵹ") },
    Range { from: 'Ꝿ', to: 'Ꝿ', mapping: Mapped("ꝿ") },
    Range { from: 'ꝿ', to: 'ꝿ', mapping: Valid },
    Range { from: 'Ꞁ', to: 'Ꞁ', mapping: Mapped("ꞁ") },
    Range { from: 'ꞁ', to: 'ꞁ', mapping: Valid },
    Range { from: 'Ꞃ', to: 'Ꞃ', mapping: Mapped("ꞃ") },
    Range { from: 'ꞃ', to: 'ꞃ', mapping: Valid },
    Range { from: 'Ꞅ', to: 'Ꞅ', mapping: Mapped("ꞅ") },
    Range { from: 'ꞅ', to: 'ꞅ', mapping: Valid },
    Range { from: 'Ꞇ', to: 'Ꞇ', mapping: Mapped("ꞇ") },
    Range { from: 'ꞇ', to: 'ꞈ', mapping: Valid },
    Range { from: '꞉', to: '꞊', mapping: Valid },
    Range { from: 'Ꞌ', to: 'Ꞌ', mapping: Mapped("ꞌ") },
    Range { from: 'ꞌ', to: 'ꞌ', mapping: Valid },
    Range { from: 'Ɥ', to: 'Ɥ', mapping: Mapped("ɥ") },
    Range { from: 'ꞎ', to: 'ꞎ', mapping: Valid },
    Range { from: 'ꞏ', to: 'ꞏ', mapping: Valid },
    Range { from: 'Ꞑ', to: 'Ꞑ', mapping: Mapped("ꞑ") },
    Range { from: 'ꞑ', to: 'ꞑ', mapping: Valid },
    Range { from: 'Ꞓ', to: 'Ꞓ', mapping: Mapped("ꞓ") },
    Range { from: 'ꞓ', to: 'ꞓ', mapping: Valid },
    Range { from: 'ꞔ', to: 'ꞕ', mapping: Valid },
    Range { from: 'Ꞗ', to: 'Ꞗ', mapping: Mapped("ꞗ") },
    Range { from: 'ꞗ', to: 'ꞗ', mapping: Valid },
    Range { from: 'Ꞙ', to: 'Ꞙ', mapping: Mapped("ꞙ") },
    Range { from: 'ꞙ', to: 'ꞙ', mapping: Valid },
    Range { from: 'Ꞛ', to: 'Ꞛ', mapping: Mapped("ꞛ") },
    Range { from: 'ꞛ', to: 'ꞛ', mapping: Valid },
    Range { from: 'Ꞝ', to: 'Ꞝ', mapping: Mapped("ꞝ") },
    Range { from: 'ꞝ', to: 'ꞝ', mapping: Valid },
    Range { from: 'Ꞟ', to: 'Ꞟ', mapping: Mapped("ꞟ") },
    Range { from: 'ꞟ', to: 'ꞟ', mapping: Valid },
    Range { from: 'Ꞡ', to: 'Ꞡ', mapping: Mapped("ꞡ") },
    Range { from: 'ꞡ', to: 'ꞡ', mapping: Valid },
    Range { from: 'Ꞣ', to: 'Ꞣ', mapping: Mapped("ꞣ") },
    Range { from: 'ꞣ', to: 'ꞣ', mapping: Valid },
    Range { from: 'Ꞥ', to: 'Ꞥ', mapping: Mapped("ꞥ") },
    Range { from: 'ꞥ', to: 'ꞥ', mapping: Valid },
    Range { from: 'Ꞧ', to: 'Ꞧ', mapping: Mapped("ꞧ") },
    Range { from: 'ꞧ', to: 'ꞧ', mapping: Valid },
    Range { from: 'Ꞩ', to: 'Ꞩ', mapping: Mapped("ꞩ") },
    Range { from: 'ꞩ', to: 'ꞩ', mapping: Valid },
    Range { from: 'Ɦ', to: 'Ɦ', mapping: Mapped("ɦ") },
    Range { from: 'Ɜ', to: 'Ɜ', mapping: Mapped("ɜ") },
    Range { from: 'Ɡ', to: 'Ɡ', mapping: Mapped("ɡ") },
    Range { from: 'Ɬ', to: 'Ɬ', mapping: Mapped("ɬ") },
    Range { from: 'Ɪ', to: 'ꞯ', mapping: Disallowed },
    Range { from: 'Ʞ', to: 'Ʞ', mapping: Mapped("ʞ") },
    Range { from: 'Ʇ', to: 'Ʇ', mapping: Mapped("ʇ") },
    Range { from: 'Ʝ', to: 'Ʝ', mapping: Mapped("ʝ") },
    Range { from: 'Ꭓ', to: 'Ꭓ', mapping: Mapped("ꭓ") },
    Range { from: 'Ꞵ', to: 'Ꞵ', mapping: Mapped("ꞵ") },
    Range { from: 'ꞵ', to: 'ꞵ', mapping: Valid },
    Range { from: 'Ꞷ', to: 'Ꞷ', mapping: Mapped("ꞷ") },
    Range { from: 'ꞷ', to: 'ꞷ', mapping: Valid },
    Range { from: 'Ꞹ', to: 'ꟶ', mapping: Disallowed },
    Range { from: 'ꟷ', to: 'ꟷ', mapping: Valid },
    Range { from: 'ꟸ', to: 'ꟸ', mapping: Mapped("ħ") },
    Range { from: 'ꟹ', to: 'ꟹ', mapping: Mapped("œ") },
    Range { from: 'ꟺ', to: 'ꟺ', mapping: Valid },
    Range { from: 'ꟻ', to: 'ꟿ', mapping: Valid },
    Range { from: 'ꠀ', to: 'ꠧ', mapping: Valid },
    Range { from: '꠨', to: '꠫', mapping: Valid },
    Range { from: '꠬', to: '꠯', mapping: Disallowed },
    Range { from: '꠰', to: '꠹', mapping: Valid },
    Range { from: '꠺', to: '꠿', mapping: Disallowed },
    Range { from: 'ꡀ', to: 'ꡳ', mapping: Valid },
    Range { from: '꡴', to: '꡷', mapping: Valid },
    Range { from: '꡸', to: '꡿', mapping: Disallowed },
    Range { from: 'ꢀ', to: '꣄', mapping: Valid },
    Range { from: 'ꣅ', to: '꣍', mapping: Disallowed },
    Range { from: '꣎', to: '꣏', mapping: Valid },
    Range { from: '꣐', to: '꣙', mapping: Valid },
    Range { from: '꣚', to: '꣟', mapping: Disallowed },
    Range { from: '꣠', to: 'ꣷ', mapping: Valid },
    Range { from: '꣸', to: '꣺', mapping: Valid },
    Range { from: 'ꣻ', to: 'ꣻ', mapping: Valid },
    Range { from: '꣼', to: '꣼', mapping: Valid },
    Range { from: 'ꣽ', to: 'ꣽ', mapping: Valid },
    Range { from: 'ꣾ', to: 'ꣿ', mapping: Disallowed },
    Range { from: '꤀', to: '꤭', mapping: Valid },
    Range { from: '꤮', to: '꤯', mapping: Valid },
    Range { from: 'ꤰ', to: '꥓', mapping: Valid },
    Range { from: '꥔', to: '꥞', mapping: Disallowed },
    Range { from: '꥟', to: '꥟', mapping: Valid },
    Range { from: 'ꥠ', to: 'ꥼ', mapping: Valid },
    Range { from: '꥽', to: '꥿', mapping: Disallowed },
    Range { from: 'ꦀ', to: '꧀', mapping: Valid },
    Range { from: '꧁', to: '꧍', mapping: Valid },
    Range { from: '꧎', to: '꧎', mapping: Disallowed },
    Range { from: 'ꧏ', to: '꧙', mapping: Valid },
    Range { from: '꧚', to: '꧝', mapping: Disallowed },
    Range { from: '꧞', to: '꧟', mapping: Valid },
    Range { from: 'ꧠ', to: 'ꧾ', mapping: Valid },
    Range { from: '꧿', to: '꧿', mapping: Disallowed },
    Range { from: 'ꨀ', to: 'ꨶ', mapping: Valid },
    Range { from: '꨷', to: '꨿', mapping: Disallowed },
    Range { from: 'ꩀ', to: 'ꩍ', mapping: Valid },
    Range { from: '꩎', to: '꩏', mapping: Disallowed },
    Range { from: '꩐', to: '꩙', mapping: Valid },
    Range { from: '꩚', to: '꩛', mapping: Disallowed },
    Range { from: '꩜', to: '꩟', mapping: Valid },
    Range { from: 'ꩠ', to: 'ꩶ', mapping: Valid },
    Range { from: '꩷', to: '꩹', mapping: Valid },
    Range { from: 'ꩺ', to: 'ꩻ', mapping: Valid },
    Range { from: 'ꩼ', to: 'ꩿ', mapping: Valid },
    Range { from: 'ꪀ', to: 'ꫂ', mapping: Valid },
    Range { from: '꫃', to: '꫚', mapping: Disallowed },
    Range { from: 'ꫛ', to: 'ꫝ', mapping: Valid },
    Range { from: '꫞', to: '꫟', mapping: Valid },
    Range { from: 'ꫠ', to: 'ꫯ', mapping: Valid },
    Range { from: '꫰', to: '꫱', mapping: Valid },
    Range { from: 'ꫲ', to: '꫶', mapping: Valid },
    Range { from: '꫷', to: '꬀', mapping: Disallowed },
    Range { from: 'ꬁ', to: 'ꬆ', mapping: Valid },
    Range { from: '꬇', to: '꬈', mapping: Disallowed },
    Range { from: 'ꬉ', to: 'ꬎ', mapping: Valid },
    Range { from: '꬏', to: '꬐', mapping: Disallowed },
    Range { from: 'ꬑ', to: 'ꬖ', mapping: Valid },
    Range { from: '꬗', to: '꬟', mapping: Disallowed },
    Range { from: 'ꬠ', to: 'ꬦ', mapping: Valid },
    Range { from: '꬧', to: '꬧', mapping: Disallowed },
    Range { from: 'ꬨ', to: 'ꬮ', mapping: Valid },
    Range { from: '꬯', to: '꬯', mapping: Disallowed },
    Range { from: 'ꬰ', to: 'ꭚ', mapping: Valid },
    Range { from: '꭛', to: '꭛', mapping: Valid },
    Range { from: 'ꭜ', to: 'ꭜ', mapping: Mapped("ꜧ") },
    Range { from: 'ꭝ', to: 'ꭝ', mapping: Mapped("ꬷ") },
    Range { from: 'ꭞ', to: 'ꭞ', mapping: Mapped("ɫ") },
    Range { from: 'ꭟ', to: 'ꭟ', mapping: Mapped("ꭒ") },
    Range { from: 'ꭠ', to: 'ꭣ', mapping: Valid },
    Range { from: 'ꭤ', to: 'ꭥ', mapping: Valid },
    Range { from: 'ꭦ', to: '꭯', mapping: Disallowed },
    Range { from: 'ꭰ', to: 'ꭰ', mapping: Mapped("Ꭰ") },
    Range { from: 'ꭱ', to: 'ꭱ', mapping: Mapped("Ꭱ") },
    Range { from: 'ꭲ', to: 'ꭲ', mapping: Mapped("Ꭲ") },
    Range { from: 'ꭳ', to: 'ꭳ', mapping: Mapped("Ꭳ") },
    Range { from: 'ꭴ', to: 'ꭴ', mapping: Mapped("Ꭴ") },
    Range { from: 'ꭵ', to: 'ꭵ', mapping: Mapped("Ꭵ") },
    Range { from: 'ꭶ', to: 'ꭶ', mapping: Mapped("Ꭶ") },
    Range { from: 'ꭷ', to: 'ꭷ', mapping: Mapped("Ꭷ") },
    Range { from: 'ꭸ', to: 'ꭸ', mapping: Mapped("Ꭸ") },
    Range { from: 'ꭹ', to: 'ꭹ', mapping: Mapped("Ꭹ") },
    Range { from: 'ꭺ', to: 'ꭺ', mapping: Mapped("Ꭺ") },
    Range { from: 'ꭻ', to: 'ꭻ', mapping: Mapped("Ꭻ") },
    Range { from: 'ꭼ', to: 'ꭼ', mapping: Mapped("Ꭼ") },
    Range { from: 'ꭽ', to: 'ꭽ', mapping: Mapped("Ꭽ") },
    Range { from: 'ꭾ', to: 'ꭾ', mapping: Mapped("Ꭾ") },
    Range { from: 'ꭿ', to: 'ꭿ', mapping: Mapped("Ꭿ") },
    Range { from: 'ꮀ', to: 'ꮀ', mapping: Mapped("Ꮀ") },
    Range { from: 'ꮁ', to: 'ꮁ', mapping: Mapped("Ꮁ") },
    Range { from: 'ꮂ', to: 'ꮂ', mapping: Mapped("Ꮂ") },
    Range { from: 'ꮃ', to: 'ꮃ', mapping: Mapped("Ꮃ") },
    Range { from: 'ꮄ', to: 'ꮄ', mapping: Mapped("Ꮄ") },
    Range { from: 'ꮅ', to: 'ꮅ', mapping: Mapped("Ꮅ") },
    Range { from: 'ꮆ', to: 'ꮆ', mapping: Mapped("Ꮆ") },
    Range { from: 'ꮇ', to: 'ꮇ', mapping: Mapped("Ꮇ") },
    Range { from: 'ꮈ', to: 'ꮈ', mapping: Mapped("Ꮈ") },
    Range { from: 'ꮉ', to: 'ꮉ', mapping: Mapped("Ꮉ") },
    Range { from: 'ꮊ', to: 'ꮊ', mapping: Mapped("Ꮊ") },
    Range { from: 'ꮋ', to: 'ꮋ', mapping: Mapped("Ꮋ") },
    Range { from: 'ꮌ', to: 'ꮌ', mapping: Mapped("Ꮌ") },
    Range { from: 'ꮍ', to: 'ꮍ', mapping: Mapped("Ꮍ") },
    Range { from: 'ꮎ', to: 'ꮎ', mapping: Mapped("Ꮎ") },
    Range { from: 'ꮏ', to: 'ꮏ', mapping: Mapped("Ꮏ") },
    Range { from: 'ꮐ', to: 'ꮐ', mapping: Mapped("Ꮐ") },
    Range { from: 'ꮑ', to: 'ꮑ', mapping: Mapped("Ꮑ") },
    Range { from: 'ꮒ', to: 'ꮒ', mapping: Mapped("Ꮒ") },
    Range { from: 'ꮓ', to: 'ꮓ', mapping: Mapped("Ꮓ") },
    Range { from: 'ꮔ', to: 'ꮔ', mapping: Mapped("Ꮔ") },
    Range { from: 'ꮕ', to: 'ꮕ', mapping: Mapped("Ꮕ") },
    Range { from: 'ꮖ', to: 'ꮖ', mapping: Mapped("Ꮖ") },
    Range { from: 'ꮗ', to: 'ꮗ', mapping: Mapped("Ꮗ") },
    Range { from: 'ꮘ', to: 'ꮘ', mapping: Mapped("Ꮘ") },
    Range { from: 'ꮙ', to: 'ꮙ', mapping: Mapped("Ꮙ") },
    Range { from: 'ꮚ', to: 'ꮚ', mapping: Mapped("Ꮚ") },
    Range { from: 'ꮛ', to: 'ꮛ', mapping: Mapped("Ꮛ") },
    Range { from: 'ꮜ', to: 'ꮜ', mapping: Mapped("Ꮜ") },
    Range { from: 'ꮝ', to: 'ꮝ', mapping: Mapped("Ꮝ") },
    Range { from: 'ꮞ', to: 'ꮞ', mapping: Mapped("Ꮞ") },
    Range { from: 'ꮟ', to: 'ꮟ', mapping: Mapped("Ꮟ") },
    Range { from: 'ꮠ', to: 'ꮠ', mapping: Mapped("Ꮠ") },
    Range { from: 'ꮡ', to: 'ꮡ', mapping: Mapped("Ꮡ") },
    Range { from: 'ꮢ', to: 'ꮢ', mapping: Mapped("Ꮢ") },
    Range { from: 'ꮣ', to: 'ꮣ', mapping: Mapped("Ꮣ") },
    Range { from: 'ꮤ', to: 'ꮤ', mapping: Mapped("Ꮤ") },
    Range { from: 'ꮥ', to: 'ꮥ', mapping: Mapped("Ꮥ") },
    Range { from: 'ꮦ', to: 'ꮦ', mapping: Mapped("Ꮦ") },
    Range { from: 'ꮧ', to: 'ꮧ', mapping: Mapped("Ꮧ") },
    Range { from: 'ꮨ', to: 'ꮨ', mapping: Mapped("Ꮨ") },
    Range { from: 'ꮩ', to: 'ꮩ', mapping: Mapped("Ꮩ") },
    Range { from: 'ꮪ', to: 'ꮪ', mapping: Mapped("Ꮪ") },
    Range { from: 'ꮫ', to: 'ꮫ', mapping: Mapped("Ꮫ") },
    Range { from: 'ꮬ', to: 'ꮬ', mapping: Mapped("Ꮬ") },
    Range { from: 'ꮭ', to: 'ꮭ', mapping: Mapped("Ꮭ") },
    Range { from: 'ꮮ', to: 'ꮮ', mapping: Mapped("Ꮮ") },
    Range { from: 'ꮯ', to: 'ꮯ', mapping: Mapped("Ꮯ") },
    Range { from: 'ꮰ', to: 'ꮰ', mapping: Mapped("Ꮰ") },
    Range { from: 'ꮱ', to: 'ꮱ', mapping: Mapped("Ꮱ") },
    Range { from: 'ꮲ', to: 'ꮲ', mapping: Mapped("Ꮲ") },
    Range { from: 'ꮳ', to: 'ꮳ', mapping: Mapped("Ꮳ") },
    Range { from: 'ꮴ', to: 'ꮴ', mapping: Mapped("Ꮴ") },
    Range { from: 'ꮵ', to: 'ꮵ', mapping: Mapped("Ꮵ") },
    Range { from: 'ꮶ', to: 'ꮶ', mapping: Mapped("Ꮶ") },
    Range { from: 'ꮷ', to: 'ꮷ', mapping: Mapped("Ꮷ") },
    Range { from: 'ꮸ', to: 'ꮸ', mapping: Mapped("Ꮸ") },
    Range { from: 'ꮹ', to: 'ꮹ', mapping: Mapped("Ꮹ") },
    Range { from: 'ꮺ', to: 'ꮺ', mapping: Mapped("Ꮺ") },
    Range { from: 'ꮻ', to: 'ꮻ', mapping: Mapped("Ꮻ") },
    Range { from: 'ꮼ', to: 'ꮼ', mapping: Mapped("Ꮼ") },
    Range { from: 'ꮽ', to: 'ꮽ', mapping: Mapped("Ꮽ") },
    Range { from: 'ꮾ', to: 'ꮾ', mapping: Mapped("Ꮾ") },
    Range { from: 'ꮿ', to: 'ꮿ', mapping: Mapped("Ꮿ") },
    Range { from: 'ꯀ', to: 'ꯪ', mapping: Valid },
    Range { from: '꯫', to: '꯫', mapping: Valid },
    Range { from: '꯬', to: '꯭', mapping: Valid },
    Range { from: '꯮', to: '꯯', mapping: Disallowed },
    Range { from: '꯰', to: '꯹', mapping: Valid },
    Range { from: '꯺', to: '꯿', mapping: Disallowed },
    Range { from: '가', to: '힣', mapping: Valid },
    Range { from: '힤', to: '힯', mapping: Disallowed },
    Range { from: 'ힰ', to: 'ퟆ', mapping: Valid },
    Range { from: '퟇', to: '퟊', mapping: Disallowed },
    Range { from: 'ퟋ', to: 'ퟻ', mapping: Valid },
    Range { from: '퟼', to: '퟿', mapping: Disallowed },
    Range { from: '', to: '', mapping: Disallowed },
    Range { from: '豈', to: '豈', mapping: Mapped("豈") },
    Range { from: '更', to: '更', mapping: Mapped("更") },
    Range { from: '車', to: '車', mapping: Mapped("車") },
    Range { from: '賈', to: '賈', mapping: Mapped("賈") },
    Range { from: '滑', to: '滑', mapping: Mapped("滑") },
    Range { from: '串', to: '串', mapping: Mapped("串") },
    Range { from: '句', to: '句', mapping: Mapped("句") },
    Range { from: '龜', to: '龜', mapping: Mapped("龜") },
    Range { from: '契', to: '契', mapping: Mapped("契") },
    Range { from: '金', to: '金', mapping: Mapped("金") },
    Range { from: '喇', to: '喇', mapping: Mapped("喇") },
    Range { from: '奈', to: '奈', mapping: Mapped("奈") },
    Range { from: '懶', to: '懶', mapping: Mapped("懶") },
    Range { from: '癩', to: '癩', mapping: Mapped("癩") },
    Range { from: '羅', to: '羅', mapping: Mapped("羅") },
    Range { from: '蘿', to: '蘿', mapping: Mapped("蘿") },
    Range { from: '螺', to: '螺', mapping: Mapped("螺") },
    Range { from: '裸', to: '裸', mapping: Mapped("裸") },
    Range { from: '邏', to: '邏', mapping: Mapped("邏") },
    Range { from: '樂', to: '樂', mapping: Mapped("樂") },
    Range { from: '洛', to: '洛', mapping: Mapped("洛") },
    Range { from: '烙', to: '烙', mapping: Mapped("烙") },
    Range { from: '珞', to: '珞', mapping: Mapped("珞") },
    Range { from: '落', to: '落', mapping: Mapped("落") },
    Range { from: '酪', to: '酪', mapping: Mapped("酪") },
    Range { from: '駱', to: '駱', mapping: Mapped("駱") },
    Range { from: '亂', to: '亂', mapping: Mapped("亂") },
    Range { from: '卵', to: '卵', mapping: Mapped("卵") },
    Range { from: '欄', to: '欄', mapping: Mapped("欄") },
    Range { from: '爛', to: '爛', mapping: Mapped("爛") },
    Range { from: '蘭', to: '蘭', mapping: Mapped("蘭") },
    Range { from: '鸞', to: '鸞', mapping: Mapped("鸞") },
    Range { from: '嵐', to: '嵐', mapping: Mapped("嵐") },
    Range { from: '濫', to: '濫', mapping: Mapped("濫") },
    Range { from: '藍', to: '藍', mapping: Mapped("藍") },
    Range { from: '襤', to: '襤', mapping: Mapped("襤") },
    Range { from: '拉', to: '拉', mapping: Mapped("拉") },
    Range { from: '臘', to: '臘', mapping: Mapped("臘") },
    Range { from: '蠟', to: '蠟', mapping: Mapped("蠟") },
    Range { from: '廊', to: '廊', mapping: Mapped("廊") },
    Range { from: '朗', to: '朗', mapping: Mapped("朗") },
    Range { from: '浪', to: '浪', mapping: Mapped("浪") },
    Range { from: '狼', to: '狼', mapping: Mapped("狼") },
    Range { from: '郎', to: '郎', mapping: Mapped("郎") },
    Range { from: '來', to: '來', mapping: Mapped("來") },
    Range { from: '冷', to: '冷', mapping: Mapped("冷") },
    Range { from: '勞', to: '勞', mapping: Mapped("勞") },
    Range { from: '擄', to: '擄', mapping: Mapped("擄") },
    Range { from: '櫓', to: '櫓', mapping: Mapped("櫓") },
    Range { from: '爐', to: '爐', mapping: Mapped("爐") },
    Range { from: '盧', to: '盧', mapping: Mapped("盧") },
    Range { from: '老', to: '老', mapping: Mapped("老") },
    Range { from: '蘆', to: '蘆', mapping: Mapped("蘆") },
    Range { from: '虜', to: '虜', mapping: Mapped("虜") },
    Range { from: '路', to: '路', mapping: Mapped("路") },
    Range { from: '露', to: '露', mapping: Mapped("露") },
    Range { from: '魯', to: '魯', mapping: Mapped("魯") },
    Range { from: '鷺', to: '鷺', mapping: Mapped("鷺") },
    Range { from: '碌', to: '碌', mapping: Mapped("碌") },
    Range { from: '祿', to: '祿', mapping: Mapped("祿") },
    Range { from: '綠', to: '綠', mapping: Mapped("綠") },
    Range { from: '菉', to: '菉', mapping: Mapped("菉") },
    Range { from: '錄', to: '錄', mapping: Mapped("錄") },
    Range { from: '鹿', to: '鹿', mapping: Mapped("鹿") },
    Range { from: '論', to: '論', mapping: Mapped("論") },
    Range { from: '壟', to: '壟', mapping: Mapped("壟") },
    Range { from: '弄', to: '弄', mapping: Mapped("弄") },
    Range { from: '籠', to: '籠', mapping: Mapped("籠") },
    Range { from: '聾', to: '聾', mapping: Mapped("聾") },
    Range { from: '牢', to: '牢', mapping: Mapped("牢") },
    Range { from: '磊', to: '磊', mapping: Mapped("磊") },
    Range { from: '賂', to: '賂', mapping: Mapped("賂") },
    Range { from: '雷', to: '雷', mapping: Mapped("雷") },
    Range { from: '壘', to: '壘', mapping: Mapped("壘") },
    Range { from: '屢', to: '屢', mapping: Mapped("屢") },
    Range { from: '樓', to: '樓', mapping: Mapped("樓") },
    Range { from: '淚', to: '淚', mapping: Mapped("淚") },
    Range { from: '漏', to: '漏', mapping: Mapped("漏") },
    Range { from: '累', to: '累', mapping: Mapped("累") },
    Range { from: '縷', to: '縷', mapping: Mapped("縷") },
    Range { from: '陋', to: '陋', mapping: Mapped("陋") },
    Range { from: '勒', to: '勒', mapping: Mapped("勒") },
    Range { from: '肋', to: '肋', mapping: Mapped("肋") },
    Range { from: '凜', to: '凜', mapping: Mapped("凜") },
    Range { from: '凌', to: '凌', mapping: Mapped("凌") },
    Range { from: '稜', to: '稜', mapping: Mapped("稜") },
    Range { from: '綾', to: '綾', mapping: Mapped("綾") },
    Range { from: '菱', to: '菱', mapping: Mapped("菱") },
    Range { from: '陵', to: '陵', mapping: Mapped("陵") },
    Range { from: '讀', to: '讀', mapping: Mapped("讀") },
    Range { from: '拏', to: '拏', mapping: Mapped("拏") },
    Range { from: '樂', to: '樂', mapping: Mapped("樂") },
    Range { from: '諾', to: '諾', mapping: Mapped("諾") },
    Range { from: '丹', to: '丹', mapping: Mapped("丹") },
    Range { from: '寧', to: '寧', mapping: Mapped("寧") },
    Range { from: '怒', to: '怒', mapping: Mapped("怒") },
    Range { from: '率', to: '率', mapping: Mapped("率") },
    Range { from: '異', to: '異', mapping: Mapped("異") },
    Range { from: '北', to: '北', mapping: Mapped("北") },
    Range { from: '磻', to: '磻', mapping: Mapped("磻") },
    Range { from: '便', to: '便', mapping: Mapped("便") },
    Range { from: '復', to: '復', mapping: Mapped("復") },
    Range { from: '不', to: '不', mapping: Mapped("不") },
    Range { from: '泌', to: '泌', mapping: Mapped("泌") },
    Range { from: '數', to: '數', mapping: Mapped("數") },
    Range { from: '索', to: '索', mapping: Mapped("索") },
    Range { from: '參', to: '參', mapping: Mapped("參") },
    Range { from: '塞', to: '塞', mapping: Mapped("塞") },
    Range { from: '省', to: '省', mapping: Mapped("省") },
    Range { from: '葉', to: '葉', mapping: Mapped("葉") },
    Range { from: '說', to: '說', mapping: Mapped("說") },
    Range { from: '殺', to: '殺', mapping: Mapped("殺") },
    Range { from: '辰', to: '辰', mapping: Mapped("辰") },
    Range { from: '沈', to: '沈', mapping: Mapped("沈") },
    Range { from: '拾', to: '拾', mapping: Mapped("拾") },
    Range { from: '若', to: '若', mapping: Mapped("若") },
    Range { from: '掠', to: '掠', mapping: Mapped("掠") },
    Range { from: '略', to: '略', mapping: Mapped("略") },
    Range { from: '亮', to: '亮', mapping: Mapped("亮") },
    Range { from: '兩', to: '兩', mapping: Mapped("兩") },
    Range { from: '凉', to: '凉', mapping: Mapped("凉") },
    Range { from: '梁', to: '梁', mapping: Mapped("梁") },
    Range { from: '糧', to: '糧', mapping: Mapped("糧") },
    Range { from: '良', to: '良', mapping: Mapped("良") },
    Range { from: '諒', to: '諒', mapping: Mapped("諒") },
    Range { from: '量', to: '量', mapping: Mapped("量") },
    Range { from: '勵', to: '勵', mapping: Mapped("勵") },
    Range { from: '呂', to: '呂', mapping: Mapped("呂") },
    Range { from: '女', to: '女', mapping: Mapped("女") },
    Range { from: '廬', to: '廬', mapping: Mapped("廬") },
    Range { from: '旅', to: '旅', mapping: Mapped("旅") },
    Range { from: '濾', to: '濾', mapping: Mapped("濾") },
    Range { from: '礪', to: '礪', mapping: Mapped("礪") },
    Range { from: '閭', to: '閭', mapping: Mapped("閭") },
    Range { from: '驪', to: '驪', mapping: Mapped("驪") },
    Range { from: '麗', to: '麗', mapping: Mapped("麗") },
    Range { from: '黎', to: '黎', mapping: Mapped("黎") },
    Range { from: '力', to: '力', mapping: Mapped("力") },
    Range { from: '曆', to: '曆', mapping: Mapped("曆") },
    Range { from: '歷', to: '歷', mapping: Mapped("歷") },
    Range { from: '轢', to: '轢', mapping: Mapped("轢") },
    Range { from: '年', to: '年', mapping: Mapped("年") },
    Range { from: '憐', to: '憐', mapping: Mapped("憐") },
    Range { from: '戀', to: '戀', mapping: Mapped("戀") },
    Range { from: '撚', to: '撚', mapping: Mapped("撚") },
    Range { from: '漣', to: '漣', mapping: Mapped("漣") },
    Range { from: '煉', to: '煉', mapping: Mapped("煉") },
    Range { from: '璉', to: '璉', mapping: Mapped("璉") },
    Range { from: '秊', to: '秊', mapping: Mapped("秊") },
    Range { from: '練', to: '練', mapping: Mapped("練") },
    Range { from: '聯', to: '聯', mapping: Mapped("聯") },
    Range { from: '輦', to: '輦', mapping: Mapped("輦") },
    Range { from: '蓮', to: '蓮', mapping: Mapped("蓮") },
    Range { from: '連', to: '連', mapping: Mapped("連") },
    Range { from: '鍊', to: '鍊', mapping: Mapped("鍊") },
    Range { from: '列', to: '列', mapping: Mapped("列") },
    Range { from: '劣', to: '劣', mapping: Mapped("劣") },
    Range { from: '咽', to: '咽', mapping: Mapped("咽") },
    Range { from: '烈', to: '烈', mapping: Mapped("烈") },
    Range { from: '裂', to: '裂', mapping: Mapped("裂") },
    Range { from: '說', to: '說', mapping: Mapped("說") },
    Range { from: '廉', to: '廉', mapping: Mapped("廉") },
    Range { from: '念', to: '念', mapping: Mapped("念") },
    Range { from: '捻', to: '捻', mapping: Mapped("捻") },
    Range { from: '殮', to: '殮', mapping: Mapped("殮") },
    Range { from: '簾', to: '簾', mapping: Mapped("簾") },
    Range { from: '獵', to: '獵', mapping: Mapped("獵") },
    Range { from: '令', to: '令', mapping: Mapped("令") },
    Range { from: '囹', to: '囹', mapping: Mapped("囹") },
    Range { from: '寧', to: '寧', mapping: Mapped("寧") },
    Range { from: '嶺', to: '嶺', mapping: Mapped("嶺") },
    Range { from: '怜', to: '怜', mapping: Mapped("怜") },
    Range { from: '玲', to: '玲', mapping: Mapped("玲") },
    Range { from: '瑩', to: '瑩', mapping: Mapped("瑩") },
    Range { from: '羚', to: '羚', mapping: Mapped("羚") },
    Range { from: '聆', to: '聆', mapping: Mapped("聆") },
    Range { from: '鈴', to: '鈴', mapping: Mapped("鈴") },
    Range { from: '零', to: '零', mapping: Mapped("零") },
    Range { from: '靈', to: '靈', mapping: Mapped("靈") },
    Range { from: '領', to: '領', mapping: Mapped("領") },
    Range { from: '例', to: '例', mapping: Mapped("例") },
    Range { from: '禮', to: '禮', mapping: Mapped("禮") },
    Range { from: '醴', to: '醴', mapping: Mapped("醴") },
    Range { from: '隸', to: '隸', mapping: Mapped("隸") },
    Range { from: '惡', to: '惡', mapping: Mapped("惡") },
    Range { from: '了', to: '了', mapping: Mapped("了") },
    Range { from: '僚', to: '僚', mapping: Mapped("僚") },
    Range { from: '寮', to: '寮', mapping: Mapped("寮") },
    Range { from: '尿', to: '尿', mapping: Mapped("尿") },
    Range { from: '料', to: '料', mapping: Mapped("料") },
    Range { from: '樂', to: '樂', mapping: Mapped("樂") },
    Range { from: '燎', to: '燎', mapping: Mapped("燎") },
    Range { from: '療', to: '療', mapping: Mapped("療") },
    Range { from: '蓼', to: '蓼', mapping: Mapped("蓼") },
    Range { from: '遼', to: '遼', mapping: Mapped("遼") },
    Range { from: '龍', to: '龍', mapping: Mapped("龍") },
    Range { from: '暈', to: '暈', mapping: Mapped("暈") },
    Range { from: '阮', to: '阮', mapping: Mapped("阮") },
    Range { from: '劉', to: '劉', mapping: Mapped("劉") },
    Range { from: '杻', to: '杻', mapping: Mapped("杻") },
    Range { from: '柳', to: '柳', mapping: Mapped("柳") },
    Range { from: '流', to: '流', mapping: Mapped("流") },
    Range { from: '溜', to: '溜', mapping: Mapped("溜") },
    Range { from: '琉', to: '琉', mapping: Mapped("琉") },
    Range { from: '留', to: '留', mapping: Mapped("留") },
    Range { from: '硫', to: '硫', mapping: Mapped("硫") },
    Range { from: '紐', to: '紐', mapping: Mapped("紐") },
    Range { from: '類', to: '類', mapping: Mapped("類") },
    Range { from: '六', to: '六', mapping: Mapped("六") },
    Range { from: '戮', to: '戮', mapping: Mapped("戮") },
    Range { from: '陸', to: '陸', mapping: Mapped("陸") },
    Range { from: '倫', to: '倫', mapping: Mapped("倫") },
    Range { from: '崙', to: '崙', mapping: Mapped("崙") },
    Range { from: '淪', to: '淪', mapping: Mapped("淪") },
    Range { from: '輪', to: '輪', mapping: Mapped("輪") },
    Range { from: '律', to: '律', mapping: Mapped("律") },
    Range { from: '慄', to: '慄', mapping: Mapped("慄") },
    Range { from: '栗', to: '栗', mapping: Mapped("栗") },
    Range { from: '率', to: '率', mapping: Mapped("率") },
    Range { from: '隆', to: '隆', mapping: Mapped("隆") },
    Range { from: '利', to: '利', mapping: Mapped("利") },
    Range { from: '吏', to: '吏', mapping: Mapped("吏") },
    Range { from: '履', to: '履', mapping: Mapped("履") },
    Range { from: '易', to: '易', mapping: Mapped("易") },
    Range { from: '李', to: '李', mapping: Mapped("李") },
    Range { from: '梨', to: '梨', mapping: Mapped("梨") },
    Range { from: '泥', to: '泥', mapping: Mapped("泥") },
    Range { from: '理', to: '理', mapping: Mapped("理") },
    Range { from: '痢', to: '痢', mapping: Mapped("痢") },
    Range { from: '罹', to: '罹', mapping: Mapped("罹") },
    Range { from: '裏', to: '裏', mapping: Mapped("裏") },
    Range { from: '裡', to: '裡', mapping: Mapped("裡") },
    Range { from: '里', to: '里', mapping: Mapped("里") },
    Range { from: '離', to: '離', mapping: Mapped("離") },
    Range { from: '匿', to: '匿', mapping: Mapped("匿") },
    Range { from: '溺', to: '溺', mapping: Mapped("溺") },
    Range { from: '吝', to: '吝', mapping: Mapped("吝") },
    Range { from: '燐', to: '燐', mapping: Mapped("燐") },
    Range { from: '璘', to: '璘', mapping: Mapped("璘") },
    Range { from: '藺', to: '藺', mapping: Mapped("藺") },
    Range { from: '隣', to: '隣', mapping: Mapped("隣") },
    Range { from: '鱗', to: '鱗', mapping: Mapped("鱗") },
    Range { from: '麟', to: '麟', mapping: Mapped("麟") },
    Range { from: '林', to: '林', mapping: Mapped("林") },
    Range { from: '淋', to: '淋', mapping: Mapped("淋") },
    Range { from: '臨', to: '臨', mapping: Mapped("臨") },
    Range { from: '立', to: '立', mapping: Mapped("立") },
    Range { from: '笠', to: '笠', mapping: Mapped("笠") },
    Range { from: '粒', to: '粒', mapping: Mapped("粒") },
    Range { from: '狀', to: '狀', mapping: Mapped("狀") },
    Range { from: '炙', to: '炙', mapping: Mapped("炙") },
    Range { from: '識', to: '識', mapping: Mapped("識") },
    Range { from: '什', to: '什', mapping: Mapped("什") },
    Range { from: '茶', to: '茶', mapping: Mapped("茶") },
    Range { from: '刺', to: '刺', mapping: Mapped("刺") },
    Range { from: '切', to: '切', mapping: Mapped("切") },
    Range { from: '度', to: '度', mapping: Mapped("度") },
    Range { from: '拓', to: '拓', mapping: Mapped("拓") },
    Range { from: '糖', to: '糖', mapping: Mapped("糖") },
    Range { from: '宅', to: '宅', mapping: Mapped("宅") },
    Range { from: '洞', to: '洞', mapping: Mapped("洞") },
    Range { from: '暴', to: '暴', mapping: Mapped("暴") },
    Range { from: '輻', to: '輻', mapping: Mapped("輻") },
    Range { from: '行', to: '行', mapping: Mapped("行") },
    Range { from: '降', to: '降', mapping: Mapped("降") },
    Range { from: '見', to: '見', mapping: Mapped("見") },
    Range { from: '廓', to: '廓', mapping: Mapped("廓") },
    Range { from: '兀', to: '兀', mapping: Mapped("兀") },
    Range { from: '嗀', to: '嗀', mapping: Mapped("嗀") },
    Range { from: '﨎', to: '﨏', mapping: Valid },
    Range { from: '塚', to: '塚', mapping: Mapped("塚") },
    Range { from: '﨑', to: '﨑', mapping: Valid },
    Range { from: '晴', to: '晴', mapping: Mapped("晴") },
    Range { from: '﨓', to: '﨔', mapping: Valid },
    Range { from: '凞', to: '凞', mapping: Mapped("凞") },
    Range { from: '猪', to: '猪', mapping: Mapped("猪") },
    Range { from: '益', to: '益', mapping: Mapped("益") },
    Range { from: '礼', to: '礼', mapping: Mapped("礼") },
    Range { from: '神', to: '神', mapping: Mapped("神") },
    Range { from: '祥', to: '祥', mapping: Mapped("祥") },
    Range { from: '福', to: '福', mapping: Mapped("福") },
    Range { from: '靖', to: '靖', mapping: Mapped("靖") },
    Range { from: '精', to: '精', mapping: Mapped("精") },
    Range { from: '羽', to: '羽', mapping: Mapped("羽") },
    Range { from: '﨟', to: '﨟', mapping: Valid },
    Range { from: '蘒', to: '蘒', mapping: Mapped("蘒") },
    Range { from: '﨡', to: '﨡', mapping: Valid },
    Range { from: '諸', to: '諸', mapping: Mapped("諸") },
    Range { from: '﨣', to: '﨤', mapping: Valid },
    Range { from: '逸', to: '逸', mapping: Mapped("逸") },
    Range { from: '都', to: '都', mapping: Mapped("都") },
    Range { from: '﨧', to: '﨩', mapping: Valid },
    Range { from: '飯', to: '飯', mapping: Mapped("飯") },
    Range { from: '飼', to: '飼', mapping: Mapped("飼") },
    Range { from: '館', to: '館', mapping: Mapped("館") },
    Range { from: '鶴', to: '鶴', mapping: Mapped("鶴") },
    Range { from: '郞', to: '郞', mapping: Mapped("郞") },
    Range { from: '隷', to: '隷', mapping: Mapped("隷") },
    Range { from: '侮', to: '侮', mapping: Mapped("侮") },
    Range { from: '僧', to: '僧', mapping: Mapped("僧") },
    Range { from: '免', to: '免', mapping: Mapped("免") },
    Range { from: '勉', to: '勉', mapping: Mapped("勉") },
    Range { from: '勤', to: '勤', mapping: Mapped("勤") },
    Range { from: '卑', to: '卑', mapping: Mapped("卑") },
    Range { from: '喝', to: '喝', mapping: Mapped("喝") },
    Range { from: '嘆', to: '嘆', mapping: Mapped("嘆") },
    Range { from: '器', to: '器', mapping: Mapped("器") },
    Range { from: '塀', to: '塀', mapping: Mapped("塀") },
    Range { from: '墨', to: '墨', mapping: Mapped("墨") },
    Range { from: '層', to: '層', mapping: Mapped("層") },
    Range { from: '屮', to: '屮', mapping: Mapped("屮") },
    Range { from: '悔', to: '悔', mapping: Mapped("悔") },
    Range { from: '慨', to: '慨', mapping: Mapped("慨") },
    Range { from: '憎', to: '憎', mapping: Mapped("憎") },
    Range { from: '懲', to: '懲', mapping: Mapped("懲") },
    Range { from: '敏', to: '敏', mapping: Mapped("敏") },
    Range { from: '既', to: '既', mapping: Mapped("既") },
    Range { from: '暑', to: '暑', mapping: Mapped("暑") },
    Range { from: '梅', to: '梅', mapping: Mapped("梅") },
    Range { from: '海', to: '海', mapping: Mapped("海") },
    Range { from: '渚', to: '渚', mapping: Mapped("渚") },
    Range { from: '漢', to: '漢', mapping: Mapped("漢") },
    Range { from: '煮', to: '煮', mapping: Mapped("煮") },
    Range { from: '爫', to: '爫', mapping: Mapped("爫") },
    Range { from: '琢', to: '琢', mapping: Mapped("琢") },
    Range { from: '碑', to: '碑', mapping: Mapped("碑") },
    Range { from: '社', to: '社', mapping: Mapped("社") },
    Range { from: '祉', to: '祉', mapping: Mapped("祉") },
    Range { from: '祈', to: '祈', mapping: Mapped("祈") },
    Range { from: '祐', to: '祐', mapping: Mapped("祐") },
    Range { from: '祖', to: '祖', mapping: Mapped("祖") },
    Range { from: '祝', to: '祝', mapping: Mapped("祝") },
    Range { from: '禍', to: '禍', mapping: Mapped("禍") },
    Range { from: '禎', to: '禎', mapping: Mapped("禎") },
    Range { from: '穀', to: '穀', mapping: Mapped("穀") },
    Range { from: '突', to: '突', mapping: Mapped("突") },
    Range { from: '節', to: '節', mapping: Mapped("節") },
    Range { from: '練', to: '練', mapping: Mapped("練") },
    Range { from: '縉', to: '縉', mapping: Mapped("縉") },
    Range { from: '繁', to: '繁', mapping: Mapped("繁") },
    Range { from: '署', to: '署', mapping: Mapped("署") },
    Range { from: '者', to: '者', mapping: Mapped("者") },
    Range { from: '臭', to: '臭', mapping: Mapped("臭") },
    Range { from: '艹', to: '艹', mapping: Mapped("艹") },
    Range { from: '著', to: '著', mapping: Mapped("著") },
    Range { from: '褐', to: '褐', mapping: Mapped("褐") },
    Range { from: '視', to: '視', mapping: Mapped("視") },
    Range { from: '謁', to: '謁', mapping: Mapped("謁") },
    Range { from: '謹', to: '謹', mapping: Mapped("謹") },
    Range { from: '賓', to: '賓', mapping: Mapped("賓") },
    Range { from: '贈', to: '贈', mapping: Mapped("贈") },
    Range { from: '辶', to: '辶', mapping: Mapped("辶") },
    Range { from: '逸', to: '逸', mapping: Mapped("逸") },
    Range { from: '難', to: '難', mapping: Mapped("難") },
    Range { from: '響', to: '響', mapping: Mapped("響") },
    Range { from: '頻', to: '頻', mapping: Mapped("頻") },
    Range { from: '恵', to: '恵', mapping: Mapped("恵") },
    Range { from: '𤋮', to: '𤋮', mapping: Mapped("𤋮") },
    Range { from: '舘', to: '舘', mapping: Mapped("舘") },
    Range { from: '﩮', to: '﩯', mapping: Disallowed },
    Range { from: '並', to: '並', mapping: Mapped("並") },
    Range { from: '况', to: '况', mapping: Mapped("况") },
    Range { from: '全', to: '全', mapping: Mapped("全") },
    Range { from: '侀', to: '侀', mapping: Mapped("侀") },
    Range { from: '充', to: '充', mapping: Mapped("充") },
    Range { from: '冀', to: '冀', mapping: Mapped("冀") },
    Range { from: '勇', to: '勇', mapping: Mapped("勇") },
    Range { from: '勺', to: '勺', mapping: Mapped("勺") },
    Range { from: '喝', to: '喝', mapping: Mapped("喝") },
    Range { from: '啕', to: '啕', mapping: Mapped("啕") },
    Range { from: '喙', to: '喙', mapping: Mapped("喙") },
    Range { from: '嗢', to: '嗢', mapping: Mapped("嗢") },
    Range { from: '塚', to: '塚', mapping: Mapped("塚") },
    Range { from: '墳', to: '墳', mapping: Mapped("墳") },
    Range { from: '奄', to: '奄', mapping: Mapped("奄") },
    Range { from: '奔', to: '奔', mapping: Mapped("奔") },
    Range { from: '婢', to: '婢', mapping: Mapped("婢") },
    Range { from: '嬨', to: '嬨', mapping: Mapped("嬨") },
    Range { from: '廒', to: '廒', mapping: Mapped("廒") },
    Range { from: '廙', to: '廙', mapping: Mapped("廙") },
    Range { from: '彩', to: '彩', mapping: Mapped("彩") },
    Range { from: '徭', to: '徭', mapping: Mapped("徭") },
    Range { from: '惘', to: '惘', mapping: Mapped("惘") },
    Range { from: '慎', to: '慎', mapping: Mapped("慎") },
    Range { from: '愈', to: '愈', mapping: Mapped("愈") },
    Range { from: '憎', to: '憎', mapping: Mapped("憎") },
    Range { from: '慠', to: '慠', mapping: Mapped("慠") },
    Range { from: '懲', to: '懲', mapping: Mapped("懲") },
    Range { from: '戴', to: '戴', mapping: Mapped("戴") },
    Range { from: '揄', to: '揄', mapping: Mapped("揄") },
    Range { from: '搜', to: '搜', mapping: Mapped("搜") },
    Range { from: '摒', to: '摒', mapping: Mapped("摒") },
    Range { from: '敖', to: '敖', mapping: Mapped("敖") },
    Range { from: '晴', to: '晴', mapping: Mapped("晴") },
    Range { from: '朗', to: '朗', mapping: Mapped("朗") },
    Range { from: '望', to: '望', mapping: Mapped("望") },
    Range { from: '杖', to: '杖', mapping: Mapped("杖") },
    Range { from: '歹', to: '歹', mapping: Mapped("歹") },
    Range { from: '殺', to: '殺', mapping: Mapped("殺") },
    Range { from: '流', to: '流', mapping: Mapped("流") },
    Range { from: '滛', to: '滛', mapping: Mapped("滛") },
    Range { from: '滋', to: '滋', mapping: Mapped("滋") },
    Range { from: '漢', to: '漢', mapping: Mapped("漢") },
    Range { from: '瀞', to: '瀞', mapping: Mapped("瀞") },
    Range { from: '煮', to: '煮', mapping: Mapped("煮") },
    Range { from: '瞧', to: '瞧', mapping: Mapped("瞧") },
    Range { from: '爵', to: '爵', mapping: Mapped("爵") },
    Range { from: '犯', to: '犯', mapping: Mapped("犯") },
    Range { from: '猪', to: '猪', mapping: Mapped("猪") },
    Range { from: '瑱', to: '瑱', mapping: Mapped("瑱") },
    Range { from: '甆', to: '甆', mapping: Mapped("甆") },
    Range { from: '画', to: '画', mapping: Mapped("画") },
    Range { from: '瘝', to: '瘝', mapping: Mapped("瘝") },
    Range { from: '瘟', to: '瘟', mapping: Mapped("瘟") },
    Range { from: '益', to: '益', mapping: Mapped("益") },
    Range { from: '盛', to: '盛', mapping: Mapped("盛") },
    Range { from: '直', to: '直', mapping: Mapped("直") },
    Range { from: '睊', to: '睊', mapping: Mapped("睊") },
    Range { from: '着', to: '着', mapping: Mapped("着") },
    Range { from: '磌', to: '磌', mapping: Mapped("磌") },
    Range { from: '窱', to: '窱', mapping: Mapped("窱") },
    Range { from: '節', to: '節', mapping: Mapped("節") },
    Range { from: '类', to: '类', mapping: Mapped("类") },
    Range { from: '絛', to: '絛', mapping: Mapped("絛") },
    Range { from: '練', to: '練', mapping: Mapped("練") },
    Range { from: '缾', to: '缾', mapping: Mapped("缾") },
    Range { from: '者', to: '者', mapping: Mapped("者") },
    Range { from: '荒', to: '荒', mapping: Mapped("荒") },
    Range { from: '華', to: '華', mapping: Mapped("華") },
    Range { from: '蝹', to: '蝹', mapping: Mapped("蝹") },
    Range { from: '襁', to: '襁', mapping: Mapped("襁") },
    Range { from: '覆', to: '覆', mapping: Mapped("覆") },
    Range { from: '視', to: '視', mapping: Mapped("視") },
    Range { from: '調', to: '調', mapping: Mapped("調") },
    Range { from: '諸', to: '諸', mapping: Mapped("諸") },
    Range { from: '請', to: '請', mapping: Mapped("請") },
    Range { from: '謁', to: '謁', mapping: Mapped("謁") },
    Range { from: '諾', to: '諾', mapping: Mapped("諾") },
    Range { from: '諭', to: '諭', mapping: Mapped("諭") },
    Range { from: '謹', to: '謹', mapping: Mapped("謹") },
    Range { from: '變', to: '變', mapping: Mapped("變") },
    Range { from: '贈', to: '贈', mapping: Mapped("贈") },
    Range { from: '輸', to: '輸', mapping: Mapped("輸") },
    Range { from: '遲', to: '遲', mapping: Mapped("遲") },
    Range { from: '醙', to: '醙', mapping: Mapped("醙") },
    Range { from: '鉶', to: '鉶', mapping: Mapped("鉶") },
    Range { from: '陼', to: '陼', mapping: Mapped("陼") },
    Range { from: '難', to: '難', mapping: Mapped("難") },
    Range { from: '靖', to: '靖', mapping: Mapped("靖") },
    Range { from: '韛', to: '韛', mapping: Mapped("韛") },
    Range { from: '響', to: '響', mapping: Mapped("響") },
    Range { from: '頋', to: '頋', mapping: Mapped("頋") },
    Range { from: '頻', to: '頻', mapping: Mapped("頻") },
    Range { from: '鬒', to: '鬒', mapping: Mapped("鬒") },
    Range { from: '龜', to: '龜', mapping: Mapped("龜") },
    Range { from: '𢡊', to: '𢡊', mapping: Mapped("𢡊") },
    Range { from: '𢡄', to: '𢡄', mapping: Mapped("𢡄") },
    Range { from: '𣏕', to: '𣏕', mapping: Mapped("𣏕") },
    Range { from: '㮝', to: '㮝', mapping: Mapped("㮝") },
    Range { from: '䀘', to: '䀘', mapping: Mapped("䀘") },
    Range { from: '䀹', to: '䀹', mapping: Mapped("䀹") },
    Range { from: '𥉉', to: '𥉉', mapping: Mapped("𥉉") },
    Range { from: '𥳐', to: '𥳐', mapping: Mapped("𥳐") },
    Range { from: '𧻓', to: '𧻓', mapping: Mapped("𧻓") },
    Range { from: '齃', to: '齃', mapping: Mapped("齃") },
    Range { from: '龎', to: '龎', mapping: Mapped("龎") },
    Range { from: '﫚', to: '﫿', mapping: Disallowed },
    Range { from: 'ﬀ', to: 'ﬀ', mapping: Mapped("ff") },
    Range { from: 'ﬁ', to: 'ﬁ', mapping: Mapped("fi") },
    Range { from: 'ﬂ', to: 'ﬂ', mapping: Mapped("fl") },
    Range { from: 'ﬃ', to: 'ﬃ', mapping: Mapped("ffi") },
    Range { from: 'ﬄ', to: 'ﬄ', mapping: Mapped("ffl") },
    Range { from: 'ﬅ', to: 'ﬆ', mapping: Mapped("st") },
    Range { from: '﬇', to: '﬒', mapping: Disallowed },
    Range { from: 'ﬓ', to: 'ﬓ', mapping: Mapped("մն") },
    Range { from: 'ﬔ', to: 'ﬔ', mapping: Mapped("մե") },
    Range { from: 'ﬕ', to: 'ﬕ', mapping: Mapped("մի") },
    Range { from: 'ﬖ', to: 'ﬖ', mapping: Mapped("վն") },
    Range { from: 'ﬗ', to: 'ﬗ', mapping: Mapped("մխ") },
    Range { from: '﬘', to: '﬜', mapping: Disallowed },
    Range { from: 'יִ', to: 'יִ', mapping: Mapped("יִ") },
    Range { from: 'ﬞ', to: 'ﬞ', mapping: Valid },
    Range { from: 'ײַ', to: 'ײַ', mapping: Mapped("ײַ") },
    Range { from: 'ﬠ', to: 'ﬠ', mapping: Mapped("ע") },
    Range { from: 'ﬡ', to: 'ﬡ', mapping: Mapped("א") },
    Range { from: 'ﬢ', to: 'ﬢ', mapping: Mapped("ד") },
    Range { from: 'ﬣ', to: 'ﬣ', mapping: Mapped("ה") },
    Range { from: 'ﬤ', to: 'ﬤ', mapping: Mapped("כ") },
    Range { from: 'ﬥ', to: 'ﬥ', mapping: Mapped("ל") },
    Range { from: 'ﬦ', to: 'ﬦ', mapping: Mapped("ם") },
    Range { from: 'ﬧ', to: 'ﬧ', mapping: Mapped("ר") },
    Range { from: 'ﬨ', to: 'ﬨ', mapping: Mapped("ת") },
    Range { from: '﬩', to: '﬩', mapping: DisallowedStd3Mapped("+") },
    Range { from: 'שׁ', to: 'שׁ', mapping: Mapped("שׁ") },
    Range { from: 'שׂ', to: 'שׂ', mapping: Mapped("שׂ") },
    Range { from: 'שּׁ', to: 'שּׁ', mapping: Mapped("שּׁ") },
    Range { from: 'שּׂ', to: 'שּׂ', mapping: Mapped("שּׂ") },
    Range { from: 'אַ', to: 'אַ', mapping: Mapped("אַ") },
    Range { from: 'אָ', to: 'אָ', mapping: Mapped("אָ") },
    Range { from: 'אּ', to: 'אּ', mapping: Mapped("אּ") },
    Range { from: 'בּ', to: 'בּ', mapping: Mapped("בּ") },
    Range { from: 'גּ', to: 'גּ', mapping: Mapped("גּ") },
    Range { from: 'דּ', to: 'דּ', mapping: Mapped("דּ") },
    Range { from: 'הּ', to: 'הּ', mapping: Mapped("הּ") },
    Range { from: 'וּ', to: 'וּ', mapping: Mapped("וּ") },
    Range { from: 'זּ', to: 'זּ', mapping: Mapped("זּ") },
    Range { from: '﬷', to: '﬷', mapping: Disallowed },
    Range { from: 'טּ', to: 'טּ', mapping: Mapped("טּ") },
    Range { from: 'יּ', to: 'יּ', mapping: Mapped("יּ") },
    Range { from: 'ךּ', to: 'ךּ', mapping: Mapped("ךּ") },
    Range { from: 'כּ', to: 'כּ', mapping: Mapped("כּ") },
    Range { from: 'לּ', to: 'לּ', mapping: Mapped("לּ") },
    Range { from: '﬽', to: '﬽', mapping: Disallowed },
    Range { from: 'מּ', to: 'מּ', mapping: Mapped("מּ") },
    Range { from: '﬿', to: '﬿', mapping: Disallowed },
    Range { from: 'נּ', to: 'נּ', mapping: Mapped("נּ") },
    Range { from: 'סּ', to: 'סּ', mapping: Mapped("סּ") },
    Range { from: '﭂', to: '﭂', mapping: Disallowed },
    Range { from: 'ףּ', to: 'ףּ', mapping: Mapped("ףּ") },
    Range { from: 'פּ', to: 'פּ', mapping: Mapped("פּ") },
    Range { from: '﭅', to: '﭅', mapping: Disallowed },
    Range { from: 'צּ', to: 'צּ', mapping: Mapped("צּ") },
    Range { from: 'קּ', to: 'קּ', mapping: Mapped("קּ") },
    Range { from: 'רּ', to: 'רּ', mapping: Mapped("רּ") },
    Range { from: 'שּ', to: 'שּ', mapping: Mapped("שּ") },
    Range { from: 'תּ', to: 'תּ', mapping: Mapped("תּ") },
    Range { from: 'וֹ', to: 'וֹ', mapping: Mapped("וֹ") },
    Range { from: 'בֿ', to: 'בֿ', mapping: Mapped("בֿ") },
    Range { from: 'כֿ', to: 'כֿ', mapping: Mapped("כֿ") },
    Range { from: 'פֿ', to: 'פֿ', mapping: Mapped("פֿ") },
    Range { from: 'ﭏ', to: 'ﭏ', mapping: Mapped("אל") },
    Range { from: 'ﭐ', to: 'ﭑ', mapping: Mapped("ٱ") },
    Range { from: 'ﭒ', to: 'ﭕ', mapping: Mapped("ٻ") },
    Range { from: 'ﭖ', to: 'ﭙ', mapping: Mapped("پ") },
    Range { from: 'ﭚ', to: 'ﭝ', mapping: Mapped("ڀ") },
    Range { from: 'ﭞ', to: 'ﭡ', mapping: Mapped("ٺ") },
    Range { from: 'ﭢ', to: 'ﭥ', mapping: Mapped("ٿ") },
    Range { from: 'ﭦ', to: 'ﭩ', mapping: Mapped("ٹ") },
    Range { from: 'ﭪ', to: 'ﭭ', mapping: Mapped("ڤ") },
    Range { from: 'ﭮ', to: 'ﭱ', mapping: Mapped("ڦ") },
    Range { from: 'ﭲ', to: 'ﭵ', mapping: Mapped("ڄ") },
    Range { from: 'ﭶ', to: 'ﭹ', mapping: Mapped("ڃ") },
    Range { from: 'ﭺ', to: 'ﭽ', mapping: Mapped("چ") },
    Range { from: 'ﭾ', to: 'ﮁ', mapping: Mapped("ڇ") },
    Range { from: 'ﮂ', to: 'ﮃ', mapping: Mapped("ڍ") },
    Range { from: 'ﮄ', to: 'ﮅ', mapping: Mapped("ڌ") },
    Range { from: 'ﮆ', to: 'ﮇ', mapping: Mapped("ڎ") },
    Range { from: 'ﮈ', to: 'ﮉ', mapping: Mapped("ڈ") },
    Range { from: 'ﮊ', to: 'ﮋ', mapping: Mapped("ژ") },
    Range { from: 'ﮌ', to: 'ﮍ', mapping: Mapped("ڑ") },
    Range { from: 'ﮎ', to: 'ﮑ', mapping: Mapped("ک") },
    Range { from: 'ﮒ', to: 'ﮕ', mapping: Mapped("گ") },
    Range { from: 'ﮖ', to: 'ﮙ', mapping: Mapped("ڳ") },
    Range { from: 'ﮚ', to: 'ﮝ', mapping: Mapped("ڱ") },
    Range { from: 'ﮞ', to: 'ﮟ', mapping: Mapped("ں") },
    Range { from: 'ﮠ', to: 'ﮣ', mapping: Mapped("ڻ") },
    Range { from: 'ﮤ', to: 'ﮥ', mapping: Mapped("ۀ") },
    Range { from: 'ﮦ', to: 'ﮩ', mapping: Mapped("ہ") },
    Range { from: 'ﮪ', to: 'ﮭ', mapping: Mapped("ھ") },
    Range { from: 'ﮮ', to: 'ﮯ', mapping: Mapped("ے") },
    Range { from: 'ﮰ', to: 'ﮱ', mapping: Mapped("ۓ") },
    Range { from: '﮲', to: '﯁', mapping: Valid },
    Range { from: '﯂', to: '﯒', mapping: Disallowed },
    Range { from: 'ﯓ', to: 'ﯖ', mapping: Mapped("ڭ") },
    Range { from: 'ﯗ', to: 'ﯘ', mapping: Mapped("ۇ") },
    Range { from: 'ﯙ', to: 'ﯚ', mapping: Mapped("ۆ") },
    Range { from: 'ﯛ', to: 'ﯜ', mapping: Mapped("ۈ") },
    Range { from: 'ﯝ', to: 'ﯝ', mapping: Mapped("ۇٴ") },
    Range { from: 'ﯞ', to: 'ﯟ', mapping: Mapped("ۋ") },
    Range { from: 'ﯠ', to: 'ﯡ', mapping: Mapped("ۅ") },
    Range { from: 'ﯢ', to: 'ﯣ', mapping: Mapped("ۉ") },
    Range { from: 'ﯤ', to: 'ﯧ', mapping: Mapped("ې") },
    Range { from: 'ﯨ', to: 'ﯩ', mapping: Mapped("ى") },
    Range { from: 'ﯪ', to: 'ﯫ', mapping: Mapped("ئا") },
    Range { from: 'ﯬ', to: 'ﯭ', mapping: Mapped("ئە") },
    Range { from: 'ﯮ', to: 'ﯯ', mapping: Mapped("ئو") },
    Range { from: 'ﯰ', to: 'ﯱ', mapping: Mapped("ئۇ") },
    Range { from: 'ﯲ', to: 'ﯳ', mapping: Mapped("ئۆ") },
    Range { from: 'ﯴ', to: 'ﯵ', mapping: Mapped("ئۈ") },
    Range { from: 'ﯶ', to: 'ﯸ', mapping: Mapped("ئې") },
    Range { from: 'ﯹ', to: 'ﯻ', mapping: Mapped("ئى") },
    Range { from: 'ﯼ', to: 'ﯿ', mapping: Mapped("ی") },
    Range { from: 'ﰀ', to: 'ﰀ', mapping: Mapped("ئج") },
    Range { from: 'ﰁ', to: 'ﰁ', mapping: Mapped("ئح") },
    Range { from: 'ﰂ', to: 'ﰂ', mapping: Mapped("ئم") },
    Range { from: 'ﰃ', to: 'ﰃ', mapping: Mapped("ئى") },
    Range { from: 'ﰄ', to: 'ﰄ', mapping: Mapped("ئي") },
    Range { from: 'ﰅ', to: 'ﰅ', mapping: Mapped("بج") },
    Range { from: 'ﰆ', to: 'ﰆ', mapping: Mapped("بح") },
    Range { from: 'ﰇ', to: 'ﰇ', mapping: Mapped("بخ") },
    Range { from: 'ﰈ', to: 'ﰈ', mapping: Mapped("بم") },
    Range { from: 'ﰉ', to: 'ﰉ', mapping: Mapped("بى") },
    Range { from: 'ﰊ', to: 'ﰊ', mapping: Mapped("بي") },
    Range { from: 'ﰋ', to: 'ﰋ', mapping: Mapped("تج") },
    Range { from: 'ﰌ', to: 'ﰌ', mapping: Mapped("تح") },
    Range { from: 'ﰍ', to: 'ﰍ', mapping: Mapped("تخ") },
    Range { from: 'ﰎ', to: 'ﰎ', mapping: Mapped("تم") },
    Range { from: 'ﰏ', to: 'ﰏ', mapping: Mapped("تى") },
    Range { from: 'ﰐ', to: 'ﰐ', mapping: Mapped("تي") },
    Range { from: 'ﰑ', to: 'ﰑ', mapping: Mapped("ثج") },
    Range { from: 'ﰒ', to: 'ﰒ', mapping: Mapped("ثم") },
    Range { from: 'ﰓ', to: 'ﰓ', mapping: Mapped("ثى") },
    Range { from: 'ﰔ', to: 'ﰔ', mapping: Mapped("ثي") },
    Range { from: 'ﰕ', to: 'ﰕ', mapping: Mapped("جح") },
    Range { from: 'ﰖ', to: 'ﰖ', mapping: Mapped("جم") },
    Range { from: 'ﰗ', to: 'ﰗ', mapping: Mapped("حج") },
    Range { from: 'ﰘ', to: 'ﰘ', mapping: Mapped("حم") },
    Range { from: 'ﰙ', to: 'ﰙ', mapping: Mapped("خج") },
    Range { from: 'ﰚ', to: 'ﰚ', mapping: Mapped("خح") },
    Range { from: 'ﰛ', to: 'ﰛ', mapping: Mapped("خم") },
    Range { from: 'ﰜ', to: 'ﰜ', mapping: Mapped("سج") },
    Range { from: 'ﰝ', to: 'ﰝ', mapping: Mapped("سح") },
    Range { from: 'ﰞ', to: 'ﰞ', mapping: Mapped("سخ") },
    Range { from: 'ﰟ', to: 'ﰟ', mapping: Mapped("سم") },
    Range { from: 'ﰠ', to: 'ﰠ', mapping: Mapped("صح") },
    Range { from: 'ﰡ', to: 'ﰡ', mapping: Mapped("صم") },
    Range { from: 'ﰢ', to: 'ﰢ', mapping: Mapped("ضج") },
    Range { from: 'ﰣ', to: 'ﰣ', mapping: Mapped("ضح") },
    Range { from: 'ﰤ', to: 'ﰤ', mapping: Mapped("ضخ") },
    Range { from: 'ﰥ', to: 'ﰥ', mapping: Mapped("ضم") },
    Range { from: 'ﰦ', to: 'ﰦ', mapping: Mapped("طح") },
    Range { from: 'ﰧ', to: 'ﰧ', mapping: Mapped("طم") },
    Range { from: 'ﰨ', to: 'ﰨ', mapping: Mapped("ظم") },
    Range { from: 'ﰩ', to: 'ﰩ', mapping: Mapped("عج") },
    Range { from: 'ﰪ', to: 'ﰪ', mapping: Mapped("عم") },
    Range { from: 'ﰫ', to: 'ﰫ', mapping: Mapped("غج") },
    Range { from: 'ﰬ', to: 'ﰬ', mapping: Mapped("غم") },
    Range { from: 'ﰭ', to: 'ﰭ', mapping: Mapped("فج") },
    Range { from: 'ﰮ', to: 'ﰮ', mapping: Mapped("فح") },
    Range { from: 'ﰯ', to: 'ﰯ', mapping: Mapped("فخ") },
    Range { from: 'ﰰ', to: 'ﰰ', mapping: Mapped("فم") },
    Range { from: 'ﰱ', to: 'ﰱ', mapping: Mapped("فى") },
    Range { from: 'ﰲ', to: 'ﰲ', mapping: Mapped("في") },
    Range { from: 'ﰳ', to: 'ﰳ', mapping: Mapped("قح") },
    Range { from: 'ﰴ', to: 'ﰴ', mapping: Mapped("قم") },
    Range { from: 'ﰵ', to: 'ﰵ', mapping: Mapped("قى") },
    Range { from: 'ﰶ', to: 'ﰶ', mapping: Mapped("قي") },
    Range { from: 'ﰷ', to: 'ﰷ', mapping: Mapped("كا") },
    Range { from: 'ﰸ', to: 'ﰸ', mapping: Mapped("كج") },
    Range { from: 'ﰹ', to: 'ﰹ', mapping: Mapped("كح") },
    Range { from: 'ﰺ', to: 'ﰺ', mapping: Mapped("كخ") },
    Range { from: 'ﰻ', to: 'ﰻ', mapping: Mapped("كل") },
    Range { from: 'ﰼ', to: 'ﰼ', mapping: Mapped("كم") },
    Range { from: 'ﰽ', to: 'ﰽ', mapping: Mapped("كى") },
    Range { from: 'ﰾ', to: 'ﰾ', mapping: Mapped("كي") },
    Range { from: 'ﰿ', to: 'ﰿ', mapping: Mapped("لج") },
    Range { from: 'ﱀ', to: 'ﱀ', mapping: Mapped("لح") },
    Range { from: 'ﱁ', to: 'ﱁ', mapping: Mapped("لخ") },
    Range { from: 'ﱂ', to: 'ﱂ', mapping: Mapped("لم") },
    Range { from: 'ﱃ', to: 'ﱃ', mapping: Mapped("لى") },
    Range { from: 'ﱄ', to: 'ﱄ', mapping: Mapped("لي") },
    Range { from: 'ﱅ', to: 'ﱅ', mapping: Mapped("مج") },
    Range { from: 'ﱆ', to: 'ﱆ', mapping: Mapped("مح") },
    Range { from: 'ﱇ', to: 'ﱇ', mapping: Mapped("مخ") },
    Range { from: 'ﱈ', to: 'ﱈ', mapping: Mapped("مم") },
    Range { from: 'ﱉ', to: 'ﱉ', mapping: Mapped("مى") },
    Range { from: 'ﱊ', to: 'ﱊ', mapping: Mapped("مي") },
    Range { from: 'ﱋ', to: 'ﱋ', mapping: Mapped("نج") },
    Range { from: 'ﱌ', to: 'ﱌ', mapping: Mapped("نح") },
    Range { from: 'ﱍ', to: 'ﱍ', mapping: Mapped("نخ") },
    Range { from: 'ﱎ', to: 'ﱎ', mapping: Mapped("نم") },
    Range { from: 'ﱏ', to: 'ﱏ', mapping: Mapped("نى") },
    Range { from: 'ﱐ', to: 'ﱐ', mapping: Mapped("ني") },
    Range { from: 'ﱑ', to: 'ﱑ', mapping: Mapped("هج") },
    Range { from: 'ﱒ', to: 'ﱒ', mapping: Mapped("هم") },
    Range { from: 'ﱓ', to: 'ﱓ', mapping: Mapped("هى") },
    Range { from: 'ﱔ', to: 'ﱔ', mapping: Mapped("هي") },
    Range { from: 'ﱕ', to: 'ﱕ', mapping: Mapped("يج") },
    Range { from: 'ﱖ', to: 'ﱖ', mapping: Mapped("يح") },
    Range { from: 'ﱗ', to: 'ﱗ', mapping: Mapped("يخ") },
    Range { from: 'ﱘ', to: 'ﱘ', mapping: Mapped("يم") },
    Range { from: 'ﱙ', to: 'ﱙ', mapping: Mapped("يى") },
    Range { from: 'ﱚ', to: 'ﱚ', mapping: Mapped("يي") },
    Range { from: 'ﱛ', to: 'ﱛ', mapping: Mapped("ذٰ") },
    Range { from: 'ﱜ', to: 'ﱜ', mapping: Mapped("رٰ") },
    Range { from: 'ﱝ', to: 'ﱝ', mapping: Mapped("ىٰ") },
    Range { from: 'ﱞ', to: 'ﱞ', mapping: DisallowedStd3Mapped(" ٌّ") },
    Range { from: 'ﱟ', to: 'ﱟ', mapping: DisallowedStd3Mapped(" ٍّ") },
    Range { from: 'ﱠ', to: 'ﱠ', mapping: DisallowedStd3Mapped(" َّ") },
    Range { from: 'ﱡ', to: 'ﱡ', mapping: DisallowedStd3Mapped(" ُّ") },
    Range { from: 'ﱢ', to: 'ﱢ', mapping: DisallowedStd3Mapped(" ِّ") },
    Range { from: 'ﱣ', to: 'ﱣ', mapping: DisallowedStd3Mapped(" ّٰ") },
    Range { from: 'ﱤ', to: 'ﱤ', mapping: Mapped("ئر") },
    Range { from: 'ﱥ', to: 'ﱥ', mapping: Mapped("ئز") },
    Range { from: 'ﱦ', to: 'ﱦ', mapping: Mapped("ئم") },
    Range { from: 'ﱧ', to: 'ﱧ', mapping: Mapped("ئن") },
    Range { from: 'ﱨ', to: 'ﱨ', mapping: Mapped("ئى") },
    Range { from: 'ﱩ', to: 'ﱩ', mapping: Mapped("ئي") },
    Range { from: 'ﱪ', to: 'ﱪ', mapping: Mapped("بر") },
    Range { from: 'ﱫ', to: 'ﱫ', mapping: Mapped("بز") },
    Range { from: 'ﱬ', to: 'ﱬ', mapping: Mapped("بم") },
    Range { from: 'ﱭ', to: 'ﱭ', mapping: Mapped("بن") },
    Range { from: 'ﱮ', to: 'ﱮ', mapping: Mapped("بى") },
    Range { from: 'ﱯ', to: 'ﱯ', mapping: Mapped("بي") },
    Range { from: 'ﱰ', to: 'ﱰ', mapping: Mapped("تر") },
    Range { from: 'ﱱ', to: 'ﱱ', mapping: Mapped("تز") },
    Range { from: 'ﱲ', to: 'ﱲ', mapping: Mapped("تم") },
    Range { from: 'ﱳ', to: 'ﱳ', mapping: Mapped("تن") },
    Range { from: 'ﱴ', to: 'ﱴ', mapping: Mapped("تى") },
    Range { from: 'ﱵ', to: 'ﱵ', mapping: Mapped("تي") },
    Range { from: 'ﱶ', to: 'ﱶ', mapping: Mapped("ثر") },
    Range { from: 'ﱷ', to: 'ﱷ', mapping: Mapped("ثز") },
    Range { from: 'ﱸ', to: 'ﱸ', mapping: Mapped("ثم") },
    Range { from: 'ﱹ', to: 'ﱹ', mapping: Mapped("ثن") },
    Range { from: 'ﱺ', to: 'ﱺ', mapping: Mapped("ثى") },
    Range { from: 'ﱻ', to: 'ﱻ', mapping: Mapped("ثي") },
    Range { from: 'ﱼ', to: 'ﱼ', mapping: Mapped("فى") },
    Range { from: 'ﱽ', to: 'ﱽ', mapping: Mapped("في") },
    Range { from: 'ﱾ', to: 'ﱾ', mapping: Mapped("قى") },
    Range { from: 'ﱿ', to: 'ﱿ', mapping: Mapped("قي") },
    Range { from: 'ﲀ', to: 'ﲀ', mapping: Mapped("كا") },
    Range { from: 'ﲁ', to: 'ﲁ', mapping: Mapped("كل") },
    Range { from: 'ﲂ', to: 'ﲂ', mapping: Mapped("كم") },
    Range { from: 'ﲃ', to: 'ﲃ', mapping: Mapped("كى") },
    Range { from: 'ﲄ', to: 'ﲄ', mapping: Mapped("كي") },
    Range { from: 'ﲅ', to: 'ﲅ', mapping: Mapped("لم") },
    Range { from: 'ﲆ', to: 'ﲆ', mapping: Mapped("لى") },
    Range { from: 'ﲇ', to: 'ﲇ', mapping: Mapped("لي") },
    Range { from: 'ﲈ', to: 'ﲈ', mapping: Mapped("ما") },
    Range { from: 'ﲉ', to: 'ﲉ', mapping: Mapped("مم") },
    Range { from: 'ﲊ', to: 'ﲊ', mapping: Mapped("نر") },
    Range { from: 'ﲋ', to: 'ﲋ', mapping: Mapped("نز") },
    Range { from: 'ﲌ', to: 'ﲌ', mapping: Mapped("نم") },
    Range { from: 'ﲍ', to: 'ﲍ', mapping: Mapped("نن") },
    Range { from: 'ﲎ', to: 'ﲎ', mapping: Mapped("نى") },
    Range { from: 'ﲏ', to: 'ﲏ', mapping: Mapped("ني") },
    Range { from: 'ﲐ', to: 'ﲐ', mapping: Mapped("ىٰ") },
    Range { from: 'ﲑ', to: 'ﲑ', mapping: Mapped("ير") },
    Range { from: 'ﲒ', to: 'ﲒ', mapping: Mapped("يز") },
    Range { from: 'ﲓ', to: 'ﲓ', mapping: Mapped("يم") },
    Range { from: 'ﲔ', to: 'ﲔ', mapping: Mapped("ين") },
    Range { from: 'ﲕ', to: 'ﲕ', mapping: Mapped("يى") },
    Range { from: 'ﲖ', to: 'ﲖ', mapping: Mapped("يي") },
    Range { from: 'ﲗ', to: 'ﲗ', mapping: Mapped("ئج") },
    Range { from: 'ﲘ', to: 'ﲘ', mapping: Mapped("ئح") },
    Range { from: 'ﲙ', to: 'ﲙ', mapping: Mapped("ئخ") },
    Range { from: 'ﲚ', to: 'ﲚ', mapping: Mapped("ئم") },
    Range { from: 'ﲛ', to: 'ﲛ', mapping: Mapped("ئه") },
    Range { from: 'ﲜ', to: 'ﲜ', mapping: Mapped("بج") },
    Range { from: 'ﲝ', to: 'ﲝ', mapping: Mapped("بح") },
    Range { from: 'ﲞ', to: 'ﲞ', mapping: Mapped("بخ") },
    Range { from: 'ﲟ', to: 'ﲟ', mapping: Mapped("بم") },
    Range { from: 'ﲠ', to: 'ﲠ', mapping: Mapped("به") },
    Range { from: 'ﲡ', to: 'ﲡ', mapping: Mapped("تج") },
    Range { from: 'ﲢ', to: 'ﲢ', mapping: Mapped("تح") },
    Range { from: 'ﲣ', to: 'ﲣ', mapping: Mapped("تخ") },
    Range { from: 'ﲤ', to: 'ﲤ', mapping: Mapped("تم") },
    Range { from: 'ﲥ', to: 'ﲥ', mapping: Mapped("ته") },
    Range { from: 'ﲦ', to: 'ﲦ', mapping: Mapped("ثم") },
    Range { from: 'ﲧ', to: 'ﲧ', mapping: Mapped("جح") },
    Range { from: 'ﲨ', to: 'ﲨ', mapping: Mapped("جم") },
    Range { from: 'ﲩ', to: 'ﲩ', mapping: Mapped("حج") },
    Range { from: 'ﲪ', to: 'ﲪ', mapping: Mapped("حم") },
    Range { from: 'ﲫ', to: 'ﲫ', mapping: Mapped("خج") },
    Range { from: 'ﲬ', to: 'ﲬ', mapping: Mapped("خم") },
    Range { from: 'ﲭ', to: 'ﲭ', mapping: Mapped("سج") },
    Range { from: 'ﲮ', to: 'ﲮ', mapping: Mapped("سح") },
    Range { from: 'ﲯ', to: 'ﲯ', mapping: Mapped("سخ") },
    Range { from: 'ﲰ', to: 'ﲰ', mapping: Mapped("سم") },
    Range { from: 'ﲱ', to: 'ﲱ', mapping: Mapped("صح") },
    Range { from: 'ﲲ', to: 'ﲲ', mapping: Mapped("صخ") },
    Range { from: 'ﲳ', to: 'ﲳ', mapping: Mapped("صم") },
    Range { from: 'ﲴ', to: 'ﲴ', mapping: Mapped("ضج") },
    Range { from: 'ﲵ', to: 'ﲵ', mapping: Mapped("ضح") },
    Range { from: 'ﲶ', to: 'ﲶ', mapping: Mapped("ضخ") },
    Range { from: 'ﲷ', to: 'ﲷ', mapping: Mapped("ضم") },
    Range { from: 'ﲸ', to: 'ﲸ', mapping: Mapped("طح") },
    Range { from: 'ﲹ', to: 'ﲹ', mapping: Mapped("ظم") },
    Range { from: 'ﲺ', to: 'ﲺ', mapping: Mapped("عج") },
    Range { from: 'ﲻ', to: 'ﲻ', mapping: Mapped("عم") },
    Range { from: 'ﲼ', to: 'ﲼ', mapping: Mapped("غج") },
    Range { from: 'ﲽ', to: 'ﲽ', mapping: Mapped("غم") },
    Range { from: 'ﲾ', to: 'ﲾ', mapping: Mapped("فج") },
    Range { from: 'ﲿ', to: 'ﲿ', mapping: Mapped("فح") },
    Range { from: 'ﳀ', to: 'ﳀ', mapping: Mapped("فخ") },
    Range { from: 'ﳁ', to: 'ﳁ', mapping: Mapped("فم") },
    Range { from: 'ﳂ', to: 'ﳂ', mapping: Mapped("قح") },
    Range { from: 'ﳃ', to: 'ﳃ', mapping: Mapped("قم") },
    Range { from: 'ﳄ', to: 'ﳄ', mapping: Mapped("كج") },
    Range { from: 'ﳅ', to: 'ﳅ', mapping: Mapped("كح") },
    Range { from: 'ﳆ', to: 'ﳆ', mapping: Mapped("كخ") },
    Range { from: 'ﳇ', to: 'ﳇ', mapping: Mapped("كل") },
    Range { from: 'ﳈ', to: 'ﳈ', mapping: Mapped("كم") },
    Range { from: 'ﳉ', to: 'ﳉ', mapping: Mapped("لج") },
    Range { from: 'ﳊ', to: 'ﳊ', mapping: Mapped("لح") },
    Range { from: 'ﳋ', to: 'ﳋ', mapping: Mapped("لخ") },
    Range { from: 'ﳌ', to: 'ﳌ', mapping: Mapped("لم") },
    Range { from: 'ﳍ', to: 'ﳍ', mapping: Mapped("له") },
    Range { from: 'ﳎ', to: 'ﳎ', mapping: Mapped("مج") },
    Range { from: 'ﳏ', to: 'ﳏ', mapping: Mapped("مح") },
    Range { from: 'ﳐ', to: 'ﳐ', mapping: Mapped("مخ") },
    Range { from: 'ﳑ', to: 'ﳑ', mapping: Mapped("مم") },
    Range { from: 'ﳒ', to: 'ﳒ', mapping: Mapped("نج") },
    Range { from: 'ﳓ', to: 'ﳓ', mapping: Mapped("نح") },
    Range { from: 'ﳔ', to: 'ﳔ', mapping: Mapped("نخ") },
    Range { from: 'ﳕ', to: 'ﳕ', mapping: Mapped("نم") },
    Range { from: 'ﳖ', to: 'ﳖ', mapping: Mapped("نه") },
    Range { from: 'ﳗ', to: 'ﳗ', mapping: Mapped("هج") },
    Range { from: 'ﳘ', to: 'ﳘ', mapping: Mapped("هم") },
    Range { from: 'ﳙ', to: 'ﳙ', mapping: Mapped("هٰ") },
    Range { from: 'ﳚ', to: 'ﳚ', mapping: Mapped("يج") },
    Range { from: 'ﳛ', to: 'ﳛ', mapping: Mapped("يح") },
    Range { from: 'ﳜ', to: 'ﳜ', mapping: Mapped("يخ") },
    Range { from: 'ﳝ', to: 'ﳝ', mapping: Mapped("يم") },
    Range { from: 'ﳞ', to: 'ﳞ', mapping: Mapped("يه") },
    Range { from: 'ﳟ', to: 'ﳟ', mapping: Mapped("ئم") },
    Range { from: 'ﳠ', to: 'ﳠ', mapping: Mapped("ئه") },
    Range { from: 'ﳡ', to: 'ﳡ', mapping: Mapped("بم") },
    Range { from: 'ﳢ', to: 'ﳢ', mapping: Mapped("به") },
    Range { from: 'ﳣ', to: 'ﳣ', mapping: Mapped("تم") },
    Range { from: 'ﳤ', to: 'ﳤ', mapping: Mapped("ته") },
    Range { from: 'ﳥ', to: 'ﳥ', mapping: Mapped("ثم") },
    Range { from: 'ﳦ', to: 'ﳦ', mapping: Mapped("ثه") },
    Range { from: 'ﳧ', to: 'ﳧ', mapping: Mapped("سم") },
    Range { from: 'ﳨ', to: 'ﳨ', mapping: Mapped("سه") },
    Range { from: 'ﳩ', to: 'ﳩ', mapping: Mapped("شم") },
    Range { from: 'ﳪ', to: 'ﳪ', mapping: Mapped("شه") },
    Range { from: 'ﳫ', to: 'ﳫ', mapping: Mapped("كل") },
    Range { from: 'ﳬ', to: 'ﳬ', mapping: Mapped("كم") },
    Range { from: 'ﳭ', to: 'ﳭ', mapping: Mapped("لم") },
    Range { from: 'ﳮ', to: 'ﳮ', mapping: Mapped("نم") },
    Range { from: 'ﳯ', to: 'ﳯ', mapping: Mapped("نه") },
    Range { from: 'ﳰ', to: 'ﳰ', mapping: Mapped("يم") },
    Range { from: 'ﳱ', to: 'ﳱ', mapping: Mapped("يه") },
    Range { from: 'ﳲ', to: 'ﳲ', mapping: Mapped("ـَّ") },
    Range { from: 'ﳳ', to: 'ﳳ', mapping: Mapped("ـُّ") },
    Range { from: 'ﳴ', to: 'ﳴ', mapping: Mapped("ـِّ") },
    Range { from: 'ﳵ', to: 'ﳵ', mapping: Mapped("طى") },
    Range { from: 'ﳶ', to: 'ﳶ', mapping: Mapped("طي") },
    Range { from: 'ﳷ', to: 'ﳷ', mapping: Mapped("عى") },
    Range { from: 'ﳸ', to: 'ﳸ', mapping: Mapped("عي") },
    Range { from: 'ﳹ', to: 'ﳹ', mapping: Mapped("غى") },
    Range { from: 'ﳺ', to: 'ﳺ', mapping: Mapped("غي") },
    Range { from: 'ﳻ', to: 'ﳻ', mapping: Mapped("سى") },
    Range { from: 'ﳼ', to: 'ﳼ', mapping: Mapped("سي") },
    Range { from: 'ﳽ', to: 'ﳽ', mapping: Mapped("شى") },
    Range { from: 'ﳾ', to: 'ﳾ', mapping: Mapped("شي") },
    Range { from: 'ﳿ', to: 'ﳿ', mapping: Mapped("حى") },
    Range { from: 'ﴀ', to: 'ﴀ', mapping: Mapped("حي") },
    Range { from: 'ﴁ', to: 'ﴁ', mapping: Mapped("جى") },
    Range { from: 'ﴂ', to: 'ﴂ', mapping: Mapped("جي") },
    Range { from: 'ﴃ', to: 'ﴃ', mapping: Mapped("خى") },
    Range { from: 'ﴄ', to: 'ﴄ', mapping: Mapped("خي") },
    Range { from: 'ﴅ', to: 'ﴅ', mapping: Mapped("صى") },
    Range { from: 'ﴆ', to: 'ﴆ', mapping: Mapped("صي") },
    Range { from: 'ﴇ', to: 'ﴇ', mapping: Mapped("ضى") },
    Range { from: 'ﴈ', to: 'ﴈ', mapping: Mapped("ضي") },
    Range { from: 'ﴉ', to: 'ﴉ', mapping: Mapped("شج") },
    Range { from: 'ﴊ', to: 'ﴊ', mapping: Mapped("شح") },
    Range { from: 'ﴋ', to: 'ﴋ', mapping: Mapped("شخ") },
    Range { from: 'ﴌ', to: 'ﴌ', mapping: Mapped("شم") },
    Range { from: 'ﴍ', to: 'ﴍ', mapping: Mapped("شر") },
    Range { from: 'ﴎ', to: 'ﴎ', mapping: Mapped("سر") },
    Range { from: 'ﴏ', to: 'ﴏ', mapping: Mapped("صر") },
    Range { from: 'ﴐ', to: 'ﴐ', mapping: Mapped("ضر") },
    Range { from: 'ﴑ', to: 'ﴑ', mapping: Mapped("طى") },
    Range { from: 'ﴒ', to: 'ﴒ', mapping: Mapped("طي") },
    Range { from: 'ﴓ', to: 'ﴓ', mapping: Mapped("عى") },
    Range { from: 'ﴔ', to: 'ﴔ', mapping: Mapped("عي") },
    Range { from: 'ﴕ', to: 'ﴕ', mapping: Mapped("غى") },
    Range { from: 'ﴖ', to: 'ﴖ', mapping: Mapped("غي") },
    Range { from: 'ﴗ', to: 'ﴗ', mapping: Mapped("سى") },
    Range { from: 'ﴘ', to: 'ﴘ', mapping: Mapped("سي") },
    Range { from: 'ﴙ', to: 'ﴙ', mapping: Mapped("شى") },
    Range { from: 'ﴚ', to: 'ﴚ', mapping: Mapped("شي") },
    Range { from: 'ﴛ', to: 'ﴛ', mapping: Mapped("حى") },
    Range { from: 'ﴜ', to: 'ﴜ', mapping: Mapped("حي") },
    Range { from: 'ﴝ', to: 'ﴝ', mapping: Mapped("جى") },
    Range { from: 'ﴞ', to: 'ﴞ', mapping: Mapped("جي") },
    Range { from: 'ﴟ', to: 'ﴟ', mapping: Mapped("خى") },
    Range { from: 'ﴠ', to: 'ﴠ', mapping: Mapped("خي") },
    Range { from: 'ﴡ', to: 'ﴡ', mapping: Mapped("صى") },
    Range { from: 'ﴢ', to: 'ﴢ', mapping: Mapped("صي") },
    Range { from: 'ﴣ', to: 'ﴣ', mapping: Mapped("ضى") },
    Range { from: 'ﴤ', to: 'ﴤ', mapping: Mapped("ضي") },
    Range { from: 'ﴥ', to: 'ﴥ', mapping: Mapped("شج") },
    Range { from: 'ﴦ', to: 'ﴦ', mapping: Mapped("شح") },
    Range { from: 'ﴧ', to: 'ﴧ', mapping: Mapped("شخ") },
    Range { from: 'ﴨ', to: 'ﴨ', mapping: Mapped("شم") },
    Range { from: 'ﴩ', to: 'ﴩ', mapping: Mapped("شر") },
    Range { from: 'ﴪ', to: 'ﴪ', mapping: Mapped("سر") },
    Range { from: 'ﴫ', to: 'ﴫ', mapping: Mapped("صر") },
    Range { from: 'ﴬ', to: 'ﴬ', mapping: Mapped("ضر") },
    Range { from: 'ﴭ', to: 'ﴭ', mapping: Mapped("شج") },
    Range { from: 'ﴮ', to: 'ﴮ', mapping: Mapped("شح") },
    Range { from: 'ﴯ', to: 'ﴯ', mapping: Mapped("شخ") },
    Range { from: 'ﴰ', to: 'ﴰ', mapping: Mapped("شم") },
    Range { from: 'ﴱ', to: 'ﴱ', mapping: Mapped("سه") },
    Range { from: 'ﴲ', to: 'ﴲ', mapping: Mapped("شه") },
    Range { from: 'ﴳ', to: 'ﴳ', mapping: Mapped("طم") },
    Range { from: 'ﴴ', to: 'ﴴ', mapping: Mapped("سج") },
    Range { from: 'ﴵ', to: 'ﴵ', mapping: Mapped("سح") },
    Range { from: 'ﴶ', to: 'ﴶ', mapping: Mapped("سخ") },
    Range { from: 'ﴷ', to: 'ﴷ', mapping: Mapped("شج") },
    Range { from: 'ﴸ', to: 'ﴸ', mapping: Mapped("شح") },
    Range { from: 'ﴹ', to: 'ﴹ', mapping: Mapped("شخ") },
    Range { from: 'ﴺ', to: 'ﴺ', mapping: Mapped("طم") },
    Range { from: 'ﴻ', to: 'ﴻ', mapping: Mapped("ظم") },
    Range { from: 'ﴼ', to: 'ﴽ', mapping: Mapped("اً") },
    Range { from: '﴾', to: '﴿', mapping: Valid },
    Range { from: '﵀', to: '﵏', mapping: Disallowed },
    Range { from: 'ﵐ', to: 'ﵐ', mapping: Mapped("تجم") },
    Range { from: 'ﵑ', to: 'ﵒ', mapping: Mapped("تحج") },
    Range { from: 'ﵓ', to: 'ﵓ', mapping: Mapped("تحم") },
    Range { from: 'ﵔ', to: 'ﵔ', mapping: Mapped("تخم") },
    Range { from: 'ﵕ', to: 'ﵕ', mapping: Mapped("تمج") },
    Range { from: 'ﵖ', to: 'ﵖ', mapping: Mapped("تمح") },
    Range { from: 'ﵗ', to: 'ﵗ', mapping: Mapped("تمخ") },
    Range { from: 'ﵘ', to: 'ﵙ', mapping: Mapped("جمح") },
    Range { from: 'ﵚ', to: 'ﵚ', mapping: Mapped("حمي") },
    Range { from: 'ﵛ', to: 'ﵛ', mapping: Mapped("حمى") },
    Range { from: 'ﵜ', to: 'ﵜ', mapping: Mapped("سحج") },
    Range { from: 'ﵝ', to: 'ﵝ', mapping: Mapped("سجح") },
    Range { from: 'ﵞ', to: 'ﵞ', mapping: Mapped("سجى") },
    Range { from: 'ﵟ', to: 'ﵠ', mapping: Mapped("سمح") },
    Range { from: 'ﵡ', to: 'ﵡ', mapping: Mapped("سمج") },
    Range { from: 'ﵢ', to: 'ﵣ', mapping: Mapped("سمم") },
    Range { from: 'ﵤ', to: 'ﵥ', mapping: Mapped("صحح") },
    Range { from: 'ﵦ', to: 'ﵦ', mapping: Mapped("صمم") },
    Range { from: 'ﵧ', to: 'ﵨ', mapping: Mapped("شحم") },
    Range { from: 'ﵩ', to: 'ﵩ', mapping: Mapped("شجي") },
    Range { from: 'ﵪ', to: 'ﵫ', mapping: Mapped("شمخ") },
    Range { from: 'ﵬ', to: 'ﵭ', mapping: Mapped("شمم") },
    Range { from: 'ﵮ', to: 'ﵮ', mapping: Mapped("ضحى") },
    Range { from: 'ﵯ', to: 'ﵰ', mapping: Mapped("ضخم") },
    Range { from: 'ﵱ', to: 'ﵲ', mapping: Mapped("طمح") },
    Range { from: 'ﵳ', to: 'ﵳ', mapping: Mapped("طمم") },
    Range { from: 'ﵴ', to: 'ﵴ', mapping: Mapped("طمي") },
    Range { from: 'ﵵ', to: 'ﵵ', mapping: Mapped("عجم") },
    Range { from: 'ﵶ', to: 'ﵷ', mapping: Mapped("عمم") },
    Range { from: 'ﵸ', to: 'ﵸ', mapping: Mapped("عمى") },
    Range { from: 'ﵹ', to: 'ﵹ', mapping: Mapped("غمم") },
    Range { from: 'ﵺ', to: 'ﵺ', mapping: Mapped("غمي") },
    Range { from: 'ﵻ', to: 'ﵻ', mapping: Mapped("غمى") },
    Range { from: 'ﵼ', to: 'ﵽ', mapping: Mapped("فخم") },
    Range { from: 'ﵾ', to: 'ﵾ', mapping: Mapped("قمح") },
    Range { from: 'ﵿ', to: 'ﵿ', mapping: Mapped("قمم") },
    Range { from: 'ﶀ', to: 'ﶀ', mapping: Mapped("لحم") },
    Range { from: 'ﶁ', to: 'ﶁ', mapping: Mapped("لحي") },
    Range { from: 'ﶂ', to: 'ﶂ', mapping: Mapped("لحى") },
    Range { from: 'ﶃ', to: 'ﶄ', mapping: Mapped("لجج") },
    Range { from: 'ﶅ', to: 'ﶆ', mapping: Mapped("لخم") },
    Range { from: 'ﶇ', to: 'ﶈ', mapping: Mapped("لمح") },
    Range { from: 'ﶉ', to: 'ﶉ', mapping: Mapped("محج") },
    Range { from: 'ﶊ', to: 'ﶊ', mapping: Mapped("محم") },
    Range { from: 'ﶋ', to: 'ﶋ', mapping: Mapped("محي") },
    Range { from: 'ﶌ', to: 'ﶌ', mapping: Mapped("مجح") },
    Range { from: 'ﶍ', to: 'ﶍ', mapping: Mapped("مجم") },
    Range { from: 'ﶎ', to: 'ﶎ', mapping: Mapped("مخج") },
    Range { from: 'ﶏ', to: 'ﶏ', mapping: Mapped("مخم") },
    Range { from: '﶐', to: '﶑', mapping: Disallowed },
    Range { from: 'ﶒ', to: 'ﶒ', mapping: Mapped("مجخ") },
    Range { from: 'ﶓ', to: 'ﶓ', mapping: Mapped("همج") },
    Range { from: 'ﶔ', to: 'ﶔ', mapping: Mapped("همم") },
    Range { from: 'ﶕ', to: 'ﶕ', mapping: Mapped("نحم") },
    Range { from: 'ﶖ', to: 'ﶖ', mapping: Mapped("نحى") },
    Range { from: 'ﶗ', to: 'ﶘ', mapping: Mapped("نجم") },
    Range { from: 'ﶙ', to: 'ﶙ', mapping: Mapped("نجى") },
    Range { from: 'ﶚ', to: 'ﶚ', mapping: Mapped("نمي") },
    Range { from: 'ﶛ', to: 'ﶛ', mapping: Mapped("نمى") },
    Range { from: 'ﶜ', to: 'ﶝ', mapping: Mapped("يمم") },
    Range { from: 'ﶞ', to: 'ﶞ', mapping: Mapped("بخي") },
    Range { from: 'ﶟ', to: 'ﶟ', mapping: Mapped("تجي") },
    Range { from: 'ﶠ', to: 'ﶠ', mapping: Mapped("تجى") },
    Range { from: 'ﶡ', to: 'ﶡ', mapping: Mapped("تخي") },
    Range { from: 'ﶢ', to: 'ﶢ', mapping: Mapped("تخى") },
    Range { from: 'ﶣ', to: 'ﶣ', mapping: Mapped("تمي") },
    Range { from: 'ﶤ', to: 'ﶤ', mapping: Mapped("تمى") },
    Range { from: 'ﶥ', to: 'ﶥ', mapping: Mapped("جمي") },
    Range { from: 'ﶦ', to: 'ﶦ', mapping: Mapped("جحى") },
    Range { from: 'ﶧ', to: 'ﶧ', mapping: Mapped("جمى") },
    Range { from: 'ﶨ', to: 'ﶨ', mapping: Mapped("سخى") },
    Range { from: 'ﶩ', to: 'ﶩ', mapping: Mapped("صحي") },
    Range { from: 'ﶪ', to: 'ﶪ', mapping: Mapped("شحي") },
    Range { from: 'ﶫ', to: 'ﶫ', mapping: Mapped("ضحي") },
    Range { from: 'ﶬ', to: 'ﶬ', mapping: Mapped("لجي") },
    Range { from: 'ﶭ', to: 'ﶭ', mapping: Mapped("لمي") },
    Range { from: 'ﶮ', to: 'ﶮ', mapping: Mapped("يحي") },
    Range { from: 'ﶯ', to: 'ﶯ', mapping: Mapped("يجي") },
    Range { from: 'ﶰ', to: 'ﶰ', mapping: Mapped("يمي") },
    Range { from: 'ﶱ', to: 'ﶱ', mapping: Mapped("ممي") },
    Range { from: 'ﶲ', to: 'ﶲ', mapping: Mapped("قمي") },
    Range { from: 'ﶳ', to: 'ﶳ', mapping: Mapped("نحي") },
    Range { from: 'ﶴ', to: 'ﶴ', mapping: Mapped("قمح") },
    Range { from: 'ﶵ', to: 'ﶵ', mapping: Mapped("لحم") },
    Range { from: 'ﶶ', to: 'ﶶ', mapping: Mapped("عمي") },
    Range { from: 'ﶷ', to: 'ﶷ', mapping: Mapped("كمي") },
    Range { from: 'ﶸ', to: 'ﶸ', mapping: Mapped("نجح") },
    Range { from: 'ﶹ', to: 'ﶹ', mapping: Mapped("مخي") },
    Range { from: 'ﶺ', to: 'ﶺ', mapping: Mapped("لجم") },
    Range { from: 'ﶻ', to: 'ﶻ', mapping: Mapped("كمم") },
    Range { from: 'ﶼ', to: 'ﶼ', mapping: Mapped("لجم") },
    Range { from: 'ﶽ', to: 'ﶽ', mapping: Mapped("نجح") },
    Range { from: 'ﶾ', to: 'ﶾ', mapping: Mapped("جحي") },
    Range { from: 'ﶿ', to: 'ﶿ', mapping: Mapped("حجي") },
    Range { from: 'ﷀ', to: 'ﷀ', mapping: Mapped("مجي") },
    Range { from: 'ﷁ', to: 'ﷁ', mapping: Mapped("فمي") },
    Range { from: 'ﷂ', to: 'ﷂ', mapping: Mapped("بحي") },
    Range { from: 'ﷃ', to: 'ﷃ', mapping: Mapped("كمم") },
    Range { from: 'ﷄ', to: 'ﷄ', mapping: Mapped("عجم") },
    Range { from: 'ﷅ', to: 'ﷅ', mapping: Mapped("صمم") },
    Range { from: 'ﷆ', to: 'ﷆ', mapping: Mapped("سخي") },
    Range { from: 'ﷇ', to: 'ﷇ', mapping: Mapped("نجي") },
    Range { from: '﷈', to: '﷏', mapping: Disallowed },
    Range { from: '﷐', to: '﷯', mapping: Disallowed },
    Range { from: 'ﷰ', to: 'ﷰ', mapping: Mapped("صلے") },
    Range { from: 'ﷱ', to: 'ﷱ', mapping: Mapped("قلے") },
    Range { from: 'ﷲ', to: 'ﷲ', mapping: Mapped("الله") },
    Range { from: 'ﷳ', to: 'ﷳ', mapping: Mapped("اكبر") },
    Range { from: 'ﷴ', to: 'ﷴ', mapping: Mapped("محمد") },
    Range { from: 'ﷵ', to: 'ﷵ', mapping: Mapped("صلعم") },
    Range { from: 'ﷶ', to: 'ﷶ', mapping: Mapped("رسول") },
    Range { from: 'ﷷ', to: 'ﷷ', mapping: Mapped("عليه") },
    Range { from: 'ﷸ', to: 'ﷸ', mapping: Mapped("وسلم") },
    Range { from: 'ﷹ', to: 'ﷹ', mapping: Mapped("صلى") },
    Range { from: 'ﷺ', to: 'ﷺ', mapping: DisallowedStd3Mapped("صلى الله عليه وسلم") },
    Range { from: 'ﷻ', to: 'ﷻ', mapping: DisallowedStd3Mapped("جل جلاله") },
    Range { from: '﷼', to: '﷼', mapping: Mapped("ریال") },
    Range { from: '﷽', to: '﷽', mapping: Valid },
    Range { from: '﷾', to: '﷿', mapping: Disallowed },
    Range { from: '︀', to: '️', mapping: Ignored },
    Range { from: '︐', to: '︐', mapping: DisallowedStd3Mapped(",") },
    Range { from: '︑', to: '︑', mapping: Mapped("、") },
    Range { from: '︒', to: '︒', mapping: Disallowed },
    Range { from: '︓', to: '︓', mapping: DisallowedStd3Mapped(":") },
    Range { from: '︔', to: '︔', mapping: DisallowedStd3Mapped(";") },
    Range { from: '︕', to: '︕', mapping: DisallowedStd3Mapped("!") },
    Range { from: '︖', to: '︖', mapping: DisallowedStd3Mapped("?") },
    Range { from: '︗', to: '︗', mapping: Mapped("〖") },
    Range { from: '︘', to: '︘', mapping: Mapped("〗") },
    Range { from: '︙', to: '︙', mapping: Disallowed },
    Range { from: '︚', to: '︟', mapping: Disallowed },
    Range { from: '︠', to: '︣', mapping: Valid },
    Range { from: '︤', to: '︦', mapping: Valid },
    Range { from: '︧', to: '︭', mapping: Valid },
    Range { from: '︮', to: '︯', mapping: Valid },
    Range { from: '︰', to: '︰', mapping: Disallowed },
    Range { from: '︱', to: '︱', mapping: Mapped("—") },
    Range { from: '︲', to: '︲', mapping: Mapped("–") },
    Range { from: '︳', to: '︴', mapping: DisallowedStd3Mapped("_") },
    Range { from: '︵', to: '︵', mapping: DisallowedStd3Mapped("(") },
    Range { from: '︶', to: '︶', mapping: DisallowedStd3Mapped(")") },
    Range { from: '︷', to: '︷', mapping: DisallowedStd3Mapped("{") },
    Range { from: '︸', to: '︸', mapping: DisallowedStd3Mapped("}") },
    Range { from: '︹', to: '︹', mapping: Mapped("〔") },
    Range { from: '︺', to: '︺', mapping: Mapped("〕") },
    Range { from: '︻', to: '︻', mapping: Mapped("【") },
    Range { from: '︼', to: '︼', mapping: Mapped("】") },
    Range { from: '︽', to: '︽', mapping: Mapped("《") },
    Range { from: '︾', to: '︾', mapping: Mapped("》") },
    Range { from: '︿', to: '︿', mapping: Mapped("〈") },
    Range { from: '﹀', to: '﹀', mapping: Mapped("〉") },
    Range { from: '﹁', to: '﹁', mapping: Mapped("「") },
    Range { from: '﹂', to: '﹂', mapping: Mapped("」") },
    Range { from: '﹃', to: '﹃', mapping: Mapped("『") },
    Range { from: '﹄', to: '﹄', mapping: Mapped("』") },
    Range { from: '﹅', to: '﹆', mapping: Valid },
    Range { from: '﹇', to: '﹇', mapping: DisallowedStd3Mapped("[") },
    Range { from: '﹈', to: '﹈', mapping: DisallowedStd3Mapped("]") },
    Range { from: '﹉', to: '﹌', mapping: DisallowedStd3Mapped(" ̅") },
    Range { from: '﹍', to: '﹏', mapping: DisallowedStd3Mapped("_") },
    Range { from: '﹐', to: '﹐', mapping: DisallowedStd3Mapped(",") },
    Range { from: '﹑', to: '﹑', mapping: Mapped("、") },
    Range { from: '﹒', to: '﹒', mapping: Disallowed },
    Range { from: '﹓', to: '﹓', mapping: Disallowed },
    Range { from: '﹔', to: '﹔', mapping: DisallowedStd3Mapped(";") },
    Range { from: '﹕', to: '﹕', mapping: DisallowedStd3Mapped(":") },
    Range { from: '﹖', to: '﹖', mapping: DisallowedStd3Mapped("?") },
    Range { from: '﹗', to: '﹗', mapping: DisallowedStd3Mapped("!") },
    Range { from: '﹘', to: '﹘', mapping: Mapped("—") },
    Range { from: '﹙', to: '﹙', mapping: DisallowedStd3Mapped("(") },
    Range { from: '﹚', to: '﹚', mapping: DisallowedStd3Mapped(")") },
    Range { from: '﹛', to: '﹛', mapping: DisallowedStd3Mapped("{") },
    Range { from: '﹜', to: '﹜', mapping: DisallowedStd3Mapped("}") },
    Range { from: '﹝', to: '﹝', mapping: Mapped("〔") },
    Range { from: '﹞', to: '﹞', mapping: Mapped("〕") },
    Range { from: '﹟', to: '﹟', mapping: DisallowedStd3Mapped("#") },
    Range { from: '﹠', to: '﹠', mapping: DisallowedStd3Mapped("&") },
    Range { from: '﹡', to: '﹡', mapping: DisallowedStd3Mapped("*") },
    Range { from: '﹢', to: '﹢', mapping: DisallowedStd3Mapped("+") },
    Range { from: '﹣', to: '﹣', mapping: Mapped("-") },
    Range { from: '﹤', to: '﹤', mapping: DisallowedStd3Mapped("<") },
    Range { from: '﹥', to: '﹥', mapping: DisallowedStd3Mapped(">") },
    Range { from: '﹦', to: '﹦', mapping: DisallowedStd3Mapped("=") },
    Range { from: '﹧', to: '﹧', mapping: Disallowed },
    Range { from: '﹨', to: '﹨', mapping: DisallowedStd3Mapped("\\") },
    Range { from: '﹩', to: '﹩', mapping: DisallowedStd3Mapped("$") },
    Range { from: '﹪', to: '﹪', mapping: DisallowedStd3Mapped("%") },
    Range { from: '﹫', to: '﹫', mapping: DisallowedStd3Mapped("@") },
    Range { from: '﹬', to: '﹯', mapping: Disallowed },
    Range { from: 'ﹰ', to: 'ﹰ', mapping: DisallowedStd3Mapped(" ً") },
    Range { from: 'ﹱ', to: 'ﹱ', mapping: Mapped("ـً") },
    Range { from: 'ﹲ', to: 'ﹲ', mapping: DisallowedStd3Mapped(" ٌ") },
    Range { from: 'ﹳ', to: 'ﹳ', mapping: Valid },
    Range { from: 'ﹴ', to: 'ﹴ', mapping: DisallowedStd3Mapped(" ٍ") },
    Range { from: '﹵', to: '﹵', mapping: Disallowed },
    Range { from: 'ﹶ', to: 'ﹶ', mapping: DisallowedStd3Mapped(" َ") },
    Range { from: 'ﹷ', to: 'ﹷ', mapping: Mapped("ـَ") },
    Range { from: 'ﹸ', to: 'ﹸ', mapping: DisallowedStd3Mapped(" ُ") },
    Range { from: 'ﹹ', to: 'ﹹ', mapping: Mapped("ـُ") },
    Range { from: 'ﹺ', to: 'ﹺ', mapping: DisallowedStd3Mapped(" ِ") },
    Range { from: 'ﹻ', to: 'ﹻ', mapping: Mapped("ـِ") },
    Range { from: 'ﹼ', to: 'ﹼ', mapping: DisallowedStd3Mapped(" ّ") },
    Range { from: 'ﹽ', to: 'ﹽ', mapping: Mapped("ـّ") },
    Range { from: 'ﹾ', to: 'ﹾ', mapping: DisallowedStd3Mapped(" ْ") },
    Range { from: 'ﹿ', to: 'ﹿ', mapping: Mapped("ـْ") },
    Range { from: 'ﺀ', to: 'ﺀ', mapping: Mapped("ء") },
    Range { from: 'ﺁ', to: 'ﺂ', mapping: Mapped("آ") },
    Range { from: 'ﺃ', to: 'ﺄ', mapping: Mapped("أ") },
    Range { from: 'ﺅ', to: 'ﺆ', mapping: Mapped("ؤ") },
    Range { from: 'ﺇ', to: 'ﺈ', mapping: Mapped("إ") },
    Range { from: 'ﺉ', to: 'ﺌ', mapping: Mapped("ئ") },
    Range { from: 'ﺍ', to: 'ﺎ', mapping: Mapped("ا") },
    Range { from: 'ﺏ', to: 'ﺒ', mapping: Mapped("ب") },
    Range { from: 'ﺓ', to: 'ﺔ', mapping: Mapped("ة") },
    Range { from: 'ﺕ', to: 'ﺘ', mapping: Mapped("ت") },
    Range { from: 'ﺙ', to: 'ﺜ', mapping: Mapped("ث") },
    Range { from: 'ﺝ', to: 'ﺠ', mapping: Mapped("ج") },
    Range { from: 'ﺡ', to: 'ﺤ', mapping: Mapped("ح") },
    Range { from: 'ﺥ', to: 'ﺨ', mapping: Mapped("خ") },
    Range { from: 'ﺩ', to: 'ﺪ', mapping: Mapped("د") },
    Range { from: 'ﺫ', to: 'ﺬ', mapping: Mapped("ذ") },
    Range { from: 'ﺭ', to: 'ﺮ', mapping: Mapped("ر") },
    Range { from: 'ﺯ', to: 'ﺰ', mapping: Mapped("ز") },
    Range { from: 'ﺱ', to: 'ﺴ', mapping: Mapped("س") },
    Range { from: 'ﺵ', to: 'ﺸ', mapping: Mapped("ش") },
    Range { from: 'ﺹ', to: 'ﺼ', mapping: Mapped("ص") },
    Range { from: 'ﺽ', to: 'ﻀ', mapping: Mapped("ض") },
    Range { from: 'ﻁ', to: 'ﻄ', mapping: Mapped("ط") },
    Range { from: 'ﻅ', to: 'ﻈ', mapping: Mapped("ظ") },
    Range { from: 'ﻉ', to: 'ﻌ', mapping: Mapped("ع") },
    Range { from: 'ﻍ', to: 'ﻐ', mapping: Mapped("غ") },
    Range { from: 'ﻑ', to: 'ﻔ', mapping: Mapped("ف") },
    Range { from: 'ﻕ', to: 'ﻘ', mapping: Mapped("ق") },
    Range { from: 'ﻙ', to: 'ﻜ', mapping: Mapped("ك") },
    Range { from: 'ﻝ', to: 'ﻠ', mapping: Mapped("ل") },
    Range { from: 'ﻡ', to: 'ﻤ', mapping: Mapped("م") },
    Range { from: 'ﻥ', to: 'ﻨ', mapping: Mapped("ن") },
    Range { from: 'ﻩ', to: 'ﻬ', mapping: Mapped("ه") },
    Range { from: 'ﻭ', to: 'ﻮ', mapping: Mapped("و") },
    Range { from: 'ﻯ', to: 'ﻰ', mapping: Mapped("ى") },
    Range { from: 'ﻱ', to: 'ﻴ', mapping: Mapped("ي") },
    Range { from: 'ﻵ', to: 'ﻶ', mapping: Mapped("لآ") },
    Range { from: 'ﻷ', to: 'ﻸ', mapping: Mapped("لأ") },
    Range { from: 'ﻹ', to: 'ﻺ', mapping: Mapped("لإ") },
    Range { from: 'ﻻ', to: 'ﻼ', mapping: Mapped("لا") },
    Range { from: '﻽', to: '﻾', mapping: Disallowed },
    Range { from: '﻿', to: '﻿', mapping: Ignored },
    Range { from: '＀', to: '＀', mapping: Disallowed },
    Range { from: '！', to: '！', mapping: DisallowedStd3Mapped("!") },
    Range { from: '＂', to: '＂', mapping: DisallowedStd3Mapped("\"") },
    Range { from: '＃', to: '＃', mapping: DisallowedStd3Mapped("#") },
    Range { from: '＄', to: '＄', mapping: DisallowedStd3Mapped("$") },
    Range { from: '％', to: '％', mapping: DisallowedStd3Mapped("%") },
    Range { from: '＆', to: '＆', mapping: DisallowedStd3Mapped("&") },
    Range { from: '＇', to: '＇', mapping: DisallowedStd3Mapped("'") },
    Range { from: '（', to: '（', mapping: DisallowedStd3Mapped("(") },
    Range { from: '）', to: '）', mapping: DisallowedStd3Mapped(")") },
    Range { from: '＊', to: '＊', mapping: DisallowedStd3Mapped("*") },
    Range { from: '＋', to: '＋', mapping: DisallowedStd3Mapped("+") },
    Range { from: '，', to: '，', mapping: DisallowedStd3Mapped(",") },
    Range { from: '－', to: '－', mapping: Mapped("-") },
    Range { from: '．', to: '．', mapping: Mapped(".") },
    Range { from: '／', to: '／', mapping: DisallowedStd3Mapped("/") },
    Range { from: '０', to: '０', mapping: Mapped("0") },
    Range { from: '１', to: '１', mapping: Mapped("1") },
    Range { from: '２', to: '２', mapping: Mapped("2") },
    Range { from: '３', to: '３', mapping: Mapped("3") },
    Range { from: '４', to: '４', mapping: Mapped("4") },
    Range { from: '５', to: '５', mapping: Mapped("5") },
    Range { from: '６', to: '６', mapping: Mapped("6") },
    Range { from: '７', to: '７', mapping: Mapped("7") },
    Range { from: '８', to: '８', mapping: Mapped("8") },
    Range { from: '９', to: '９', mapping: Mapped("9") },
    Range { from: '：', to: '：', mapping: DisallowedStd3Mapped(":") },
    Range { from: '；', to: '；', mapping: DisallowedStd3Mapped(";") },
    Range { from: '＜', to: '＜', mapping: DisallowedStd3Mapped("<") },
    Range { from: '＝', to: '＝', mapping: DisallowedStd3Mapped("=") },
    Range { from: '＞', to: '＞', mapping: DisallowedStd3Mapped(">") },
    Range { from: '？', to: '？', mapping: DisallowedStd3Mapped("?") },
    Range { from: '＠', to: '＠', mapping: DisallowedStd3Mapped("@") },
    Range { from: 'Ａ', to: 'Ａ', mapping: Mapped("a") },
    Range { from: 'Ｂ', to: 'Ｂ', mapping: Mapped("b") },
    Range { from: 'Ｃ', to: 'Ｃ', mapping: Mapped("c") },
    Range { from: 'Ｄ', to: 'Ｄ', mapping: Mapped("d") },
    Range { from: 'Ｅ', to: 'Ｅ', mapping: Mapped("e") },
    Range { from: 'Ｆ', to: 'Ｆ', mapping: Mapped("f") },
    Range { from: 'Ｇ', to: 'Ｇ', mapping: Mapped("g") },
    Range { from: 'Ｈ', to: 'Ｈ', mapping: Mapped("h") },
    Range { from: 'Ｉ', to: 'Ｉ', mapping: Mapped("i") },
    Range { from: 'Ｊ', to: 'Ｊ', mapping: Mapped("j") },
    Range { from: 'Ｋ', to: 'Ｋ', mapping: Mapped("k") },
    Range { from: 'Ｌ', to: 'Ｌ', mapping: Mapped("l") },
    Range { from: 'Ｍ', to: 'Ｍ', mapping: Mapped("m") },
    Range { from: 'Ｎ', to: 'Ｎ', mapping: Mapped("n") },
    Range { from: 'Ｏ', to: 'Ｏ', mapping: Mapped("o") },
    Range { from: 'Ｐ', to: 'Ｐ', mapping: Mapped("p") },
    Range { from: 'Ｑ', to: 'Ｑ', mapping: Mapped("q") },
    Range { from: 'Ｒ', to: 'Ｒ', mapping: Mapped("r") },
    Range { from: 'Ｓ', to: 'Ｓ', mapping: Mapped("s") },
    Range { from: 'Ｔ', to: 'Ｔ', mapping: Mapped("t") },
    Range { from: 'Ｕ', to: 'Ｕ', mapping: Mapped("u") },
    Range { from: 'Ｖ', to: 'Ｖ', mapping: Mapped("v") },
    Range { from: 'Ｗ', to: 'Ｗ', mapping: Mapped("w") },
    Range { from: 'Ｘ', to: 'Ｘ', mapping: Mapped("x") },
    Range { from: 'Ｙ', to: 'Ｙ', mapping: Mapped("y") },
    Range { from: 'Ｚ', to: 'Ｚ', mapping: Mapped("z") },
    Range { from: '［', to: '［', mapping: DisallowedStd3Mapped("[") },
    Range { from: '＼', to: '＼', mapping: DisallowedStd3Mapped("\\") },
    Range { from: '］', to: '］', mapping: DisallowedStd3Mapped("]") },
    Range { from: '＾', to: '＾', mapping: DisallowedStd3Mapped("^") },
    Range { from: '＿', to: '＿', mapping: DisallowedStd3Mapped("_") },
    Range { from: '｀', to: '｀', mapping: DisallowedStd3Mapped("`") },
    Range { from: 'ａ', to: 'ａ', mapping: Mapped("a") },
    Range { from: 'ｂ', to: 'ｂ', mapping: Mapped("b") },
    Range { from: 'ｃ', to: 'ｃ', mapping: Mapped("c") },
    Range { from: 'ｄ', to: 'ｄ', mapping: Mapped("d") },
    Range { from: 'ｅ', to: 'ｅ', mapping: Mapped("e") },
    Range { from: 'ｆ', to: 'ｆ', mapping: Mapped("f") },
    Range { from: 'ｇ', to: 'ｇ', mapping: Mapped("g") },
    Range { from: 'ｈ', to: 'ｈ', mapping: Mapped("h") },
    Range { from: 'ｉ', to: 'ｉ', mapping: Mapped("i") },
    Range { from: 'ｊ', to: 'ｊ', mapping: Mapped("j") },
    Range { from: 'ｋ', to: 'ｋ', mapping: Mapped("k") },
    Range { from: 'ｌ', to: 'ｌ', mapping: Mapped("l") },
    Range { from: 'ｍ', to: 'ｍ', mapping: Mapped("m") },
    Range { from: 'ｎ', to: 'ｎ', mapping: Mapped("n") },
    Range { from: 'ｏ', to: 'ｏ', mapping: Mapped("o") },
    Range { from: 'ｐ', to: 'ｐ', mapping: Mapped("p") },
    Range { from: 'ｑ', to: 'ｑ', mapping: Mapped("q") },
    Range { from: 'ｒ', to: 'ｒ', mapping: Mapped("r") },
    Range { from: 'ｓ', to: 'ｓ', mapping: Mapped("s") },
    Range { from: 'ｔ', to: 'ｔ', mapping: Mapped("t") },
    Range { from: 'ｕ', to: 'ｕ', mapping: Mapped("u") },
    Range { from: 'ｖ', to: 'ｖ', mapping: Mapped("v") },
    Range { from: 'ｗ', to: 'ｗ', mapping: Mapped("w") },
    Range { from: 'ｘ', to: 'ｘ', mapping: Mapped("x") },
    Range { from: 'ｙ', to: 'ｙ', mapping: Mapped("y") },
    Range { from: 'ｚ', to: 'ｚ', mapping: Mapped("z") },
    Range { from: '｛', to: '｛', mapping: DisallowedStd3Mapped("{") },
    Range { from: '｜', to: '｜', mapping: DisallowedStd3Mapped("|") },
    Range { from: '｝', to: '｝', mapping: DisallowedStd3Mapped("}") },
    Range { from: '～', to: '～', mapping: DisallowedStd3Mapped("~") },
    Range { from: '｟', to: '｟', mapping: Mapped("⦅") },
    Range { from: '｠', to: '｠', mapping: Mapped("⦆") },
    Range { from: '｡', to: '｡', mapping: Mapped(".") },
    Range { from: '｢', to: '｢', mapping: Mapped("「") },
    Range { from: '｣', to: '｣', mapping: Mapped("」") },
    Range { from: '､', to: '､', mapping: Mapped("、") },
    Range { from: '･', to: '･', mapping: Mapped("・") },
    Range { from: 'ｦ', to: 'ｦ', mapping: Mapped("ヲ") },
    Range { from: 'ｧ', to: 'ｧ', mapping: Mapped("ァ") },
    Range { from: 'ｨ', to: 'ｨ', mapping: Mapped("ィ") },
    Range { from: 'ｩ', to: 'ｩ', mapping: Mapped("ゥ") },
    Range { from: 'ｪ', to: 'ｪ', mapping: Mapped("ェ") },
    Range { from: 'ｫ', to: 'ｫ', mapping: Mapped("ォ") },
    Range { from: 'ｬ', to: 'ｬ', mapping: Mapped("ャ") },
    Range { from: 'ｭ', to: 'ｭ', mapping: Mapped("ュ") },
    Range { from: 'ｮ', to: 'ｮ', mapping: Mapped("ョ") },
    Range { from: 'ｯ', to: 'ｯ', mapping: Mapped("ッ") },
    Range { from: 'ｰ', to: 'ｰ', mapping: Mapped("ー") },
    Range { from: 'ｱ', to: 'ｱ', mapping: Mapped("ア") },
    Range { from: 'ｲ', to: 'ｲ', mapping: Mapped("イ") },
    Range { from: 'ｳ', to: 'ｳ', mapping: Mapped("ウ") },
    Range { from: 'ｴ', to: 'ｴ', mapping: Mapped("エ") },
    Range { from: 'ｵ', to: 'ｵ', mapping: Mapped("オ") },
    Range { from: 'ｶ', to: 'ｶ', mapping: Mapped("カ") },
    Range { from: 'ｷ', to: 'ｷ', mapping: Mapped("キ") },
    Range { from: 'ｸ', to: 'ｸ', mapping: Mapped("ク") },
    Range { from: 'ｹ', to: 'ｹ', mapping: Mapped("ケ") },
    Range { from: 'ｺ', to: 'ｺ', mapping: Mapped("コ") },
    Range { from: 'ｻ', to: 'ｻ', mapping: Mapped("サ") },
    Range { from: 'ｼ', to: 'ｼ', mapping: Mapped("シ") },
    Range { from: 'ｽ', to: 'ｽ', mapping: Mapped("ス") },
    Range { from: 'ｾ', to: 'ｾ', mapping: Mapped("セ") },
    Range { from: 'ｿ', to: 'ｿ', mapping: Mapped("ソ") },
    Range { from: 'ﾀ', to: 'ﾀ', mapping: Mapped("タ") },
    Range { from: 'ﾁ', to: 'ﾁ', mapping: Mapped("チ") },
    Range { from: 'ﾂ', to: 'ﾂ', mapping: Mapped("ツ") },
    Range { from: 'ﾃ', to: 'ﾃ', mapping: Mapped("テ") },
    Range { from: 'ﾄ', to: 'ﾄ', mapping: Mapped("ト") },
    Range { from: 'ﾅ', to: 'ﾅ', mapping: Mapped("ナ") },
    Range { from: 'ﾆ', to: 'ﾆ', mapping: Mapped("ニ") },
    Range { from: 'ﾇ', to: 'ﾇ', mapping: Mapped("ヌ") },
    Range { from: 'ﾈ', to: 'ﾈ', mapping: Mapped("ネ") },
    Range { from: 'ﾉ', to: 'ﾉ', mapping: Mapped("ノ") },
    Range { from: 'ﾊ', to: 'ﾊ', mapping: Mapped("ハ") },
    Range { from: 'ﾋ', to: 'ﾋ', mapping: Mapped("ヒ") },
    Range { from: 'ﾌ', to: 'ﾌ', mapping: Mapped("フ") },
    Range { from: 'ﾍ', to: 'ﾍ', mapping: Mapped("ヘ") },
    Range { from: 'ﾎ', to: 'ﾎ', mapping: Mapped("ホ") },
    Range { from: 'ﾏ', to: 'ﾏ', mapping: Mapped("マ") },
    Range { from: 'ﾐ', to: 'ﾐ', mapping: Mapped("ミ") },
    Range { from: 'ﾑ', to: 'ﾑ', mapping: Mapped("ム") },
    Range { from: 'ﾒ', to: 'ﾒ', mapping: Mapped("メ") },
    Range { from: 'ﾓ', to: 'ﾓ', mapping: Mapped("モ") },
    Range { from: 'ﾔ', to: 'ﾔ', mapping: Mapped("ヤ") },
    Range { from: 'ﾕ', to: 'ﾕ', mapping: Mapped("ユ") },
    Range { from: 'ﾖ', to: 'ﾖ', mapping: Mapped("ヨ") },
    Range { from: 'ﾗ', to: 'ﾗ', mapping: Mapped("ラ") },
    Range { from: 'ﾘ', to: 'ﾘ', mapping: Mapped("リ") },
    Range { from: 'ﾙ', to: 'ﾙ', mapping: Mapped("ル") },
    Range { from: 'ﾚ', to: 'ﾚ', mapping: Mapped("レ") },
    Range { from: 'ﾛ', to: 'ﾛ', mapping: Mapped("ロ") },
    Range { from: 'ﾜ', to: 'ﾜ', mapping: Mapped("ワ") },
    Range { from: 'ﾝ', to: 'ﾝ', mapping: Mapped("ン") },
    Range { from: 'ﾞ', to: 'ﾞ', mapping: Mapped("゙") },
    Range { from: 'ﾟ', to: 'ﾟ', mapping: Mapped("゚") },
    Range { from: 'ﾠ', to: 'ﾠ', mapping: Disallowed },
    Range { from: 'ﾡ', to: 'ﾡ', mapping: Mapped("ᄀ") },
    Range { from: 'ﾢ', to: 'ﾢ', mapping: Mapped("ᄁ") },
    Range { from: 'ﾣ', to: 'ﾣ', mapping: Mapped("ᆪ") },
    Range { from: 'ﾤ', to: 'ﾤ', mapping: Mapped("ᄂ") },
    Range { from: 'ﾥ', to: 'ﾥ', mapping: Mapped("ᆬ") },
    Range { from: 'ﾦ', to: 'ﾦ', mapping: Mapped("ᆭ") },
    Range { from: 'ﾧ', to: 'ﾧ', mapping: Mapped("ᄃ") },
    Range { from: 'ﾨ', to: 'ﾨ', mapping: Mapped("ᄄ") },
    Range { from: 'ﾩ', to: 'ﾩ', mapping: Mapped("ᄅ") },
    Range { from: 'ﾪ', to: 'ﾪ', mapping: Mapped("ᆰ") },
    Range { from: 'ﾫ', to: 'ﾫ', mapping: Mapped("ᆱ") },
    Range { from: 'ﾬ', to: 'ﾬ', mapping: Mapped("ᆲ") },
    Range { from: 'ﾭ', to: 'ﾭ', mapping: Mapped("ᆳ") },
    Range { from: 'ﾮ', to: 'ﾮ', mapping: Mapped("ᆴ") },
    Range { from: 'ﾯ', to: 'ﾯ', mapping: Mapped("ᆵ") },
    Range { from: 'ﾰ', to: 'ﾰ', mapping: Mapped("ᄚ") },
    Range { from: 'ﾱ', to: 'ﾱ', mapping: Mapped("ᄆ") },
    Range { from: 'ﾲ', to: 'ﾲ', mapping: Mapped("ᄇ") },
    Range { from: 'ﾳ', to: 'ﾳ', mapping: Mapped("ᄈ") },
    Range { from: 'ﾴ', to: 'ﾴ', mapping: Mapped("ᄡ") },
    Range { from: 'ﾵ', to: 'ﾵ', mapping: Mapped("ᄉ") },
    Range { from: 'ﾶ', to: 'ﾶ', mapping: Mapped("ᄊ") },
    Range { from: 'ﾷ', to: 'ﾷ', mapping: Mapped("ᄋ") },
    Range { from: 'ﾸ', to: 'ﾸ', mapping: Mapped("ᄌ") },
    Range { from: 'ﾹ', to: 'ﾹ', mapping: Mapped("ᄍ") },
    Range { from: 'ﾺ', to: 'ﾺ', mapping: Mapped("ᄎ") },
    Range { from: 'ﾻ', to: 'ﾻ', mapping: Mapped("ᄏ") },
    Range { from: 'ﾼ', to: 'ﾼ', mapping: Mapped("ᄐ") },
    Range { from: 'ﾽ', to: 'ﾽ', mapping: Mapped("ᄑ") },
    Range { from: 'ﾾ', to: 'ﾾ', mapping: Mapped("ᄒ") },
    Range { from: '﾿', to: '￁', mapping: Disallowed },
    Range { from: 'ￂ', to: 'ￂ', mapping: Mapped("ᅡ") },
    Range { from: 'ￃ', to: 'ￃ', mapping: Mapped("ᅢ") },
    Range { from: 'ￄ', to: 'ￄ', mapping: Mapped("ᅣ") },
    Range { from: 'ￅ', to: 'ￅ', mapping: Mapped("ᅤ") },
    Range { from: 'ￆ', to: 'ￆ', mapping: Mapped("ᅥ") },
    Range { from: 'ￇ', to: 'ￇ', mapping: Mapped("ᅦ") },
    Range { from: '￈', to: '￉', mapping: Disallowed },
    Range { from: 'ￊ', to: 'ￊ', mapping: Mapped("ᅧ") },
    Range { from: 'ￋ', to: 'ￋ', mapping: Mapped("ᅨ") },
    Range { from: 'ￌ', to: 'ￌ', mapping: Mapped("ᅩ") },
    Range { from: 'ￍ', to: 'ￍ', mapping: Mapped("ᅪ") },
    Range { from: 'ￎ', to: 'ￎ', mapping: Mapped("ᅫ") },
    Range { from: 'ￏ', to: 'ￏ', mapping: Mapped("ᅬ") },
    Range { from: '￐', to: '￑', mapping: Disallowed },
    Range { from: 'ￒ', to: 'ￒ', mapping: Mapped("ᅭ") },
    Range { from: 'ￓ', to: 'ￓ', mapping: Mapped("ᅮ") },
    Range { from: 'ￔ', to: 'ￔ', mapping: Mapped("ᅯ") },
    Range { from: 'ￕ', to: 'ￕ', mapping: Mapped("ᅰ") },
    Range { from: 'ￖ', to: 'ￖ', mapping: Mapped("ᅱ") },
    Range { from: 'ￗ', to: 'ￗ', mapping: Mapped("ᅲ") },
    Range { from: '￘', to: '￙', mapping: Disallowed },
    Range { from: 'ￚ', to: 'ￚ', mapping: Mapped("ᅳ") },
    Range { from: 'ￛ', to: 'ￛ', mapping: Mapped("ᅴ") },
    Range { from: 'ￜ', to: 'ￜ', mapping: Mapped("ᅵ") },
    Range { from: '￝', to: '￟', mapping: Disallowed },
    Range { from: '￠', to: '￠', mapping: Mapped("¢") },
    Range { from: '￡', to: '￡', mapping: Mapped("£") },
    Range { from: '￢', to: '￢', mapping: Mapped("¬") },
    Range { from: '￣', to: '￣', mapping: DisallowedStd3Mapped(" ̄") },
    Range { from: '￤', to: '￤', mapping: Mapped("¦") },
    Range { from: '￥', to: '￥', mapping: Mapped("¥") },
    Range { from: '￦', to: '￦', mapping: Mapped("₩") },
    Range { from: '￧', to: '￧', mapping: Disallowed },
    Range { from: '￨', to: '￨', mapping: Mapped("│") },
    Range { from: '￩', to: '￩', mapping: Mapped("←") },
    Range { from: '￪', to: '￪', mapping: Mapped("↑") },
    Range { from: '￫', to: '￫', mapping: Mapped("→") },
    Range { from: '￬', to: '￬', mapping: Mapped("↓") },
    Range { from: '￭', to: '￭', mapping: Mapped("■") },
    Range { from: '￮', to: '￮', mapping: Mapped("○") },
    Range { from: '￯', to: '￸', mapping: Disallowed },
    Range { from: '￹', to: '￻', mapping: Disallowed },
    Range { from: '￼', to: '￼', mapping: Disallowed },
    Range { from: '�', to: '�', mapping: Disallowed },
    Range { from: '￾', to: '￿', mapping: Disallowed },
    Range { from: '𐀀', to: '𐀋', mapping: Valid },
    Range { from: '𐀌', to: '𐀌', mapping: Disallowed },
    Range { from: '𐀍', to: '𐀦', mapping: Valid },
    Range { from: '𐀧', to: '𐀧', mapping: Disallowed },
    Range { from: '𐀨', to: '𐀺', mapping: Valid },
    Range { from: '𐀻', to: '𐀻', mapping: Disallowed },
    Range { from: '𐀼', to: '𐀽', mapping: Valid },
    Range { from: '𐀾', to: '𐀾', mapping: Disallowed },
    Range { from: '𐀿', to: '𐁍', mapping: Valid },
    Range { from: '𐁎', to: '𐁏', mapping: Disallowed },
    Range { from: '𐁐', to: '𐁝', mapping: Valid },
    Range { from: '𐁞', to: '𐁿', mapping: Disallowed },
    Range { from: '𐂀', to: '𐃺', mapping: Valid },
    Range { from: '𐃻', to: '𐃿', mapping: Disallowed },
    Range { from: '𐄀', to: '𐄂', mapping: Valid },
    Range { from: '𐄃', to: '𐄆', mapping: Disallowed },
    Range { from: '𐄇', to: '𐄳', mapping: Valid },
    Range { from: '𐄴', to: '𐄶', mapping: Disallowed },
    Range { from: '𐄷', to: '𐄿', mapping: Valid },
    Range { from: '𐅀', to: '𐆊', mapping: Valid },
    Range { from: '𐆋', to: '𐆌', mapping: Valid },
    Range { from: '𐆍', to: '𐆏', mapping: Disallowed },
    Range { from: '𐆐', to: '𐆛', mapping: Valid },
    Range { from: '𐆜', to: '𐆟', mapping: Disallowed },
    Range { from: '𐆠', to: '𐆠', mapping: Valid },
    Range { from: '𐆡', to: '𐇏', mapping: Disallowed },
    Range { from: '𐇐', to: '𐇼', mapping: Valid },
    Range { from: '𐇽', to: '𐇽', mapping: Valid },
    Range { from: '𐇾', to: '𐉿', mapping: Disallowed },
    Range { from: '𐊀', to: '𐊜', mapping: Valid },
    Range { from: '𐊝', to: '𐊟', mapping: Disallowed },
    Range { from: '𐊠', to: '𐋐', mapping: Valid },
    Range { from: '𐋑', to: '𐋟', mapping: Disallowed },
    Range { from: '𐋠', to: '𐋠', mapping: Valid },
    Range { from: '𐋡', to: '𐋻', mapping: Valid },
    Range { from: '𐋼', to: '𐋿', mapping: Disallowed },
    Range { from: '𐌀', to: '𐌞', mapping: Valid },
    Range { from: '𐌟', to: '𐌟', mapping: Valid },
    Range { from: '𐌠', to: '𐌣', mapping: Valid },
    Range { from: '𐌤', to: '𐌯', mapping: Disallowed },
    Range { from: '𐌰', to: '𐍀', mapping: Valid },
    Range { from: '𐍁', to: '𐍁', mapping: Valid },
    Range { from: '𐍂', to: '𐍉', mapping: Valid },
    Range { from: '𐍊', to: '𐍊', mapping: Valid },
    Range { from: '𐍋', to: '𐍏', mapping: Disallowed },
    Range { from: '𐍐', to: '𐍺', mapping: Valid },
    Range { from: '𐍻', to: '𐍿', mapping: Disallowed },
    Range { from: '𐎀', to: '𐎝', mapping: Valid },
    Range { from: '𐎞', to: '𐎞', mapping: Disallowed },
    Range { from: '𐎟', to: '𐎟', mapping: Valid },
    Range { from: '𐎠', to: '𐏃', mapping: Valid },
    Range { from: '𐏄', to: '𐏇', mapping: Disallowed },
    Range { from: '𐏈', to: '𐏏', mapping: Valid },
    Range { from: '𐏐', to: '𐏕', mapping: Valid },
    Range { from: '𐏖', to: '𐏿', mapping: Disallowed },
    Range { from: '𐐀', to: '𐐀', mapping: Mapped("𐐨") },
    Range { from: '𐐁', to: '𐐁', mapping: Mapped("𐐩") },
    Range { from: '𐐂', to: '𐐂', mapping: Mapped("𐐪") },
    Range { from: '𐐃', to: '𐐃', mapping: Mapped("𐐫") },
    Range { from: '𐐄', to: '𐐄', mapping: Mapped("𐐬") },
    Range { from: '𐐅', to: '𐐅', mapping: Mapped("𐐭") },
    Range { from: '𐐆', to: '𐐆', mapping: Mapped("𐐮") },
    Range { from: '𐐇', to: '𐐇', mapping: Mapped("𐐯") },
    Range { from: '𐐈', to: '𐐈', mapping: Mapped("𐐰") },
    Range { from: '𐐉', to: '𐐉', mapping: Mapped("𐐱") },
    Range { from: '𐐊', to: '𐐊', mapping: Mapped("𐐲") },
    Range { from: '𐐋', to: '𐐋', mapping: Mapped("𐐳") },
    Range { from: '𐐌', to: '𐐌', mapping: Mapped("𐐴") },
    Range { from: '𐐍', to: '𐐍', mapping: Mapped("𐐵") },
    Range { from: '𐐎', to: '𐐎', mapping: Mapped("𐐶") },
    Range { from: '𐐏', to: '𐐏', mapping: Mapped("𐐷") },
    Range { from: '𐐐', to: '𐐐', mapping: Mapped("𐐸") },
    Range { from: '𐐑', to: '𐐑', mapping: Mapped("𐐹") },
    Range { from: '𐐒', to: '𐐒', mapping: Mapped("𐐺") },
    Range { from: '𐐓', to: '𐐓', mapping: Mapped("𐐻") },
    Range { from: '𐐔', to: '𐐔', mapping: Mapped("𐐼") },
    Range { from: '𐐕', to: '𐐕', mapping: Mapped("𐐽") },
    Range { from: '𐐖', to: '𐐖', mapping: Mapped("𐐾") },
    Range { from: '𐐗', to: '𐐗', mapping: Mapped("𐐿") },
    Range { from: '𐐘', to: '𐐘', mapping: Mapped("𐑀") },
    Range { from: '𐐙', to: '𐐙', mapping: Mapped("𐑁") },
    Range { from: '𐐚', to: '𐐚', mapping: Mapped("𐑂") },
    Range { from: '𐐛', to: '𐐛', mapping: Mapped("𐑃") },
    Range { from: '𐐜', to: '𐐜', mapping: Mapped("𐑄") },
    Range { from: '𐐝', to: '𐐝', mapping: Mapped("𐑅") },
    Range { from: '𐐞', to: '𐐞', mapping: Mapped("𐑆") },
    Range { from: '𐐟', to: '𐐟', mapping: Mapped("𐑇") },
    Range { from: '𐐠', to: '𐐠', mapping: Mapped("𐑈") },
    Range { from: '𐐡', to: '𐐡', mapping: Mapped("𐑉") },
    Range { from: '𐐢', to: '𐐢', mapping: Mapped("𐑊") },
    Range { from: '𐐣', to: '𐐣', mapping: Mapped("𐑋") },
    Range { from: '𐐤', to: '𐐤', mapping: Mapped("𐑌") },
    Range { from: '𐐥', to: '𐐥', mapping: Mapped("𐑍") },
    Range { from: '𐐦', to: '𐐦', mapping: Mapped("𐑎") },
    Range { from: '𐐧', to: '𐐧', mapping: Mapped("𐑏") },
    Range { from: '𐐨', to: '𐑍', mapping: Valid },
    Range { from: '𐑎', to: '𐒝', mapping: Valid },
    Range { from: '𐒞', to: '𐒟', mapping: Disallowed },
    Range { from: '𐒠', to: '𐒩', mapping: Valid },
    Range { from: '𐒪', to: '𐓿', mapping: Disallowed },
    Range { from: '𐔀', to: '𐔧', mapping: Valid },
    Range { from: '𐔨', to: '𐔯', mapping: Disallowed },
    Range { from: '𐔰', to: '𐕣', mapping: Valid },
    Range { from: '𐕤', to: '𐕮', mapping: Disallowed },
    Range { from: '𐕯', to: '𐕯', mapping: Valid },
    Range { from: '𐕰', to: '𐗿', mapping: Disallowed },
    Range { from: '𐘀', to: '𐜶', mapping: Valid },
    Range { from: '𐜷', to: '𐜿', mapping: Disallowed },
    Range { from: '𐝀', to: '𐝕', mapping: Valid },
    Range { from: '𐝖', to: '𐝟', mapping: Disallowed },
    Range { from: '𐝠', to: '𐝧', mapping: Valid },
    Range { from: '𐝨', to: '𐟿', mapping: Disallowed },
    Range { from: '𐠀', to: '𐠅', mapping: Valid },
    Range { from: '𐠆', to: '𐠇', mapping: Disallowed },
    Range { from: '𐠈', to: '𐠈', mapping: Valid },
    Range { from: '𐠉', to: '𐠉', mapping: Disallowed },
    Range { from: '𐠊', to: '𐠵', mapping: Valid },
    Range { from: '𐠶', to: '𐠶', mapping: Disallowed },
    Range { from: '𐠷', to: '𐠸', mapping: Valid },
    Range { from: '𐠹', to: '𐠻', mapping: Disallowed },
    Range { from: '𐠼', to: '𐠼', mapping: Valid },
    Range { from: '𐠽', to: '𐠾', mapping: Disallowed },
    Range { from: '𐠿', to: '𐠿', mapping: Valid },
    Range { from: '𐡀', to: '𐡕', mapping: Valid },
    Range { from: '𐡖', to: '𐡖', mapping: Disallowed },
    Range { from: '𐡗', to: '𐡟', mapping: Valid },
    Range { from: '𐡠', to: '𐡶', mapping: Valid },
    Range { from: '𐡷', to: '𐡿', mapping: Valid },
    Range { from: '𐢀', to: '𐢞', mapping: Valid },
    Range { from: '𐢟', to: '𐢦', mapping: Disallowed },
    Range { from: '𐢧', to: '𐢯', mapping: Valid },
    Range { from: '𐢰', to: '𐣟', mapping: Disallowed },
    Range { from: '𐣠', to: '𐣲', mapping: Valid },
    Range { from: '𐣳', to: '𐣳', mapping: Disallowed },
    Range { from: '𐣴', to: '𐣵', mapping: Valid },
    Range { from: '𐣶', to: '𐣺', mapping: Disallowed },
    Range { from: '𐣻', to: '𐣿', mapping: Valid },
    Range { from: '𐤀', to: '𐤕', mapping: Valid },
    Range { from: '𐤖', to: '𐤙', mapping: Valid },
    Range { from: '𐤚', to: '𐤛', mapping: Valid },
    Range { from: '𐤜', to: '𐤞', mapping: Disallowed },
    Range { from: '𐤟', to: '𐤟', mapping: Valid },
    Range { from: '𐤠', to: '𐤹', mapping: Valid },
    Range { from: '𐤺', to: '𐤾', mapping: Disallowed },
    Range { from: '𐤿', to: '𐤿', mapping: Valid },
    Range { from: '𐥀', to: '𐥿', mapping: Disallowed },
    Range { from: '𐦀', to: '𐦷', mapping: Valid },
    Range { from: '𐦸', to: '𐦻', mapping: Disallowed },
    Range { from: '𐦼', to: '𐦽', mapping: Valid },
    Range { from: '𐦾', to: '𐦿', mapping: Valid },
    Range { from: '𐧀', to: '𐧏', mapping: Valid },
    Range { from: '𐧐', to: '𐧑', mapping: Disallowed },
    Range { from: '𐧒', to: '𐧿', mapping: Valid },
    Range { from: '𐨀', to: '𐨃', mapping: Valid },
    Range { from: '𐨄', to: '𐨄', mapping: Disallowed },
    Range { from: '𐨅', to: '𐨆', mapping: Valid },
    Range { from: '𐨇', to: '𐨋', mapping: Disallowed },
    Range { from: '𐨌', to: '𐨓', mapping: Valid },
    Range { from: '𐨔', to: '𐨔', mapping: Disallowed },
    Range { from: '𐨕', to: '𐨗', mapping: Valid },
    Range { from: '𐨘', to: '𐨘', mapping: Disallowed },
    Range { from: '𐨙', to: '𐨳', mapping: Valid },
    Range { from: '𐨴', to: '𐨷', mapping: Disallowed },
    Range { from: '𐨸', to: '𐨺', mapping: Valid },
    Range { from: '𐨻', to: '𐨾', mapping: Disallowed },
    Range { from: '𐨿', to: '𐨿', mapping: Valid },
    Range { from: '𐩀', to: '𐩇', mapping: Valid },
    Range { from: '𐩈', to: '𐩏', mapping: Disallowed },
    Range { from: '𐩐', to: '𐩘', mapping: Valid },
    Range { from: '𐩙', to: '𐩟', mapping: Disallowed },
    Range { from: '𐩠', to: '𐩼', mapping: Valid },
    Range { from: '𐩽', to: '𐩿', mapping: Valid },
    Range { from: '𐪀', to: '𐪜', mapping: Valid },
    Range { from: '𐪝', to: '𐪟', mapping: Valid },
    Range { from: '𐪠', to: '𐪿', mapping: Disallowed },
    Range { from: '𐫀', to: '𐫇', mapping: Valid },
    Range { from: '𐫈', to: '𐫈', mapping: Valid },
    Range { from: '𐫉', to: '𐫦', mapping: Valid },
    Range { from: '𐫧', to: '𐫪', mapping: Disallowed },
    Range { from: '𐫫', to: '𐫶', mapping: Valid },
    Range { from: '𐫷', to: '𐫿', mapping: Disallowed },
    Range { from: '𐬀', to: '𐬵', mapping: Valid },
    Range { from: '𐬶', to: '𐬸', mapping: Disallowed },
    Range { from: '𐬹', to: '𐬿', mapping: Valid },
    Range { from: '𐭀', to: '𐭕', mapping: Valid },
    Range { from: '𐭖', to: '𐭗', mapping: Disallowed },
    Range { from: '𐭘', to: '𐭟', mapping: Valid },
    Range { from: '𐭠', to: '𐭲', mapping: Valid },
    Range { from: '𐭳', to: '𐭷', mapping: Disallowed },
    Range { from: '𐭸', to: '𐭿', mapping: Valid },
    Range { from: '𐮀', to: '𐮑', mapping: Valid },
    Range { from: '𐮒', to: '𐮘', mapping: Disallowed },
    Range { from: '𐮙', to: '𐮜', mapping: Valid },
    Range { from: '𐮝', to: '𐮨', mapping: Disallowed },
    Range { from: '𐮩', to: '𐮯', mapping: Valid },
    Range { from: '𐮰', to: '𐯿', mapping: Disallowed },
    Range { from: '𐰀', to: '𐱈', mapping: Valid },
    Range { from: '𐱉', to: '𐱿', mapping: Disallowed },
    Range { from: '𐲀', to: '𐲀', mapping: Mapped("𐳀") },
    Range { from: '𐲁', to: '𐲁', mapping: Mapped("𐳁") },
    Range { from: '𐲂', to: '𐲂', mapping: Mapped("𐳂") },
    Range { from: '𐲃', to: '𐲃', mapping: Mapped("𐳃") },
    Range { from: '𐲄', to: '𐲄', mapping: Mapped("𐳄") },
    Range { from: '𐲅', to: '𐲅', mapping: Mapped("𐳅") },
    Range { from: '𐲆', to: '𐲆', mapping: Mapped("𐳆") },
    Range { from: '𐲇', to: '𐲇', mapping: Mapped("𐳇") },
    Range { from: '𐲈', to: '𐲈', mapping: Mapped("𐳈") },
    Range { from: '𐲉', to: '𐲉', mapping: Mapped("𐳉") },
    Range { from: '𐲊', to: '𐲊', mapping: Mapped("𐳊") },
    Range { from: '𐲋', to: '𐲋', mapping: Mapped("𐳋") },
    Range { from: '𐲌', to: '𐲌', mapping: Mapped("𐳌") },
    Range { from: '𐲍', to: '𐲍', mapping: Mapped("𐳍") },
    Range { from: '𐲎', to: '𐲎', mapping: Mapped("𐳎") },
    Range { from: '𐲏', to: '𐲏', mapping: Mapped("𐳏") },
    Range { from: '𐲐', to: '𐲐', mapping: Mapped("𐳐") },
    Range { from: '𐲑', to: '𐲑', mapping: Mapped("𐳑") },
    Range { from: '𐲒', to: '𐲒', mapping: Mapped("𐳒") },
    Range { from: '𐲓', to: '𐲓', mapping: Mapped("𐳓") },
    Range { from: '𐲔', to: '𐲔', mapping: Mapped("𐳔") },
    Range { from: '𐲕', to: '𐲕', mapping: Mapped("𐳕") },
    Range { from: '𐲖', to: '𐲖', mapping: Mapped("𐳖") },
    Range { from: '𐲗', to: '𐲗', mapping: Mapped("𐳗") },
    Range { from: '𐲘', to: '𐲘', mapping: Mapped("𐳘") },
    Range { from: '𐲙', to: '𐲙', mapping: Mapped("𐳙") },
    Range { from: '𐲚', to: '𐲚', mapping: Mapped("𐳚") },
    Range { from: '𐲛', to: '𐲛', mapping: Mapped("𐳛") },
    Range { from: '𐲜', to: '𐲜', mapping: Mapped("𐳜") },
    Range { from: '𐲝', to: '𐲝', mapping: Mapped("𐳝") },
    Range { from: '𐲞', to: '𐲞', mapping: Mapped("𐳞") },
    Range { from: '𐲟', to: '𐲟', mapping: Mapped("𐳟") },
    Range { from: '𐲠', to: '𐲠', mapping: Mapped("𐳠") },
    Range { from: '𐲡', to: '𐲡', mapping: Mapped("𐳡") },
    Range { from: '𐲢', to: '𐲢', mapping: Mapped("𐳢") },
    Range { from: '𐲣', to: '𐲣', mapping: Mapped("𐳣") },
    Range { from: '𐲤', to: '𐲤', mapping: Mapped("𐳤") },
    Range { from: '𐲥', to: '𐲥', mapping: Mapped("𐳥") },
    Range { from: '𐲦', to: '𐲦', mapping: Mapped("𐳦") },
    Range { from: '𐲧', to: '𐲧', mapping: Mapped("𐳧") },
    Range { from: '𐲨', to: '𐲨', mapping: Mapped("𐳨") },
    Range { from: '𐲩', to: '𐲩', mapping: Mapped("𐳩") },
    Range { from: '𐲪', to: '𐲪', mapping: Mapped("𐳪") },
    Range { from: '𐲫', to: '𐲫', mapping: Mapped("𐳫") },
    Range { from: '𐲬', to: '𐲬', mapping: Mapped("𐳬") },
    Range { from: '𐲭', to: '𐲭', mapping: Mapped("𐳭") },
    Range { from: '𐲮', to: '𐲮', mapping: Mapped("𐳮") },
    Range { from: '𐲯', to: '𐲯', mapping: Mapped("𐳯") },
    Range { from: '𐲰', to: '𐲰', mapping: Mapped("𐳰") },
    Range { from: '𐲱', to: '𐲱', mapping: Mapped("𐳱") },
    Range { from: '𐲲', to: '𐲲', mapping: Mapped("𐳲") },
    Range { from: '𐲳', to: '𐲿', mapping: Disallowed },
    Range { from: '𐳀', to: '𐳲', mapping: Valid },
    Range { from: '𐳳', to: '𐳹', mapping: Disallowed },
    Range { from: '𐳺', to: '𐳿', mapping: Valid },
    Range { from: '𐴀', to: '𐹟', mapping: Disallowed },
    Range { from: '𐹠', to: '𐹾', mapping: Valid },
    Range { from: '𐹿', to: '𐿿', mapping: Disallowed },
    Range { from: '𑀀', to: '𑁆', mapping: Valid },
    Range { from: '𑁇', to: '𑁍', mapping: Valid },
    Range { from: '𑁎', to: '𑁑', mapping: Disallowed },
    Range { from: '𑁒', to: '𑁥', mapping: Valid },
    Range { from: '𑁦', to: '𑁯', mapping: Valid },
    Range { from: '𑁰', to: '𑁾', mapping: Disallowed },
    Range { from: '𑁿', to: '𑁿', mapping: Valid },
    Range { from: '𑂀', to: '𑂺', mapping: Valid },
    Range { from: '𑂻', to: '𑂼', mapping: Valid },
    Range { from: '𑂽', to: '𑂽', mapping: Disallowed },
    Range { from: '𑂾', to: '𑃁', mapping: Valid },
    Range { from: '𑃂', to: '𑃏', mapping: Disallowed },
    Range { from: '𑃐', to: '𑃨', mapping: Valid },
    Range { from: '𑃩', to: '𑃯', mapping: Disallowed },
    Range { from: '𑃰', to: '𑃹', mapping: Valid },
    Range { from: '𑃺', to: '𑃿', mapping: Disallowed },
    Range { from: '𑄀', to: '𑄴', mapping: Valid },
    Range { from: '𑄵', to: '𑄵', mapping: Disallowed },
    Range { from: '𑄶', to: '𑄿', mapping: Valid },
    Range { from: '𑅀', to: '𑅃', mapping: Valid },
    Range { from: '𑅄', to: '𑅏', mapping: Disallowed },
    Range { from: '𑅐', to: '𑅳', mapping: Valid },
    Range { from: '𑅴', to: '𑅵', mapping: Valid },
    Range { from: '𑅶', to: '𑅶', mapping: Valid },
    Range { from: '𑅷', to: '𑅿', mapping: Disallowed },
    Range { from: '𑆀', to: '𑇄', mapping: Valid },
    Range { from: '𑇅', to: '𑇈', mapping: Valid },
    Range { from: '𑇉', to: '𑇉', mapping: Valid },
    Range { from: '𑇊', to: '𑇌', mapping: Valid },
    Range { from: '𑇍', to: '𑇍', mapping: Valid },
    Range { from: '𑇎', to: '𑇏', mapping: Disallowed },
    Range { from: '𑇐', to: '𑇙', mapping: Valid },
    Range { from: '𑇚', to: '𑇚', mapping: Valid },
    Range { from: '𑇛', to: '𑇛', mapping: Valid },
    Range { from: '𑇜', to: '𑇜', mapping: Valid },
    Range { from: '𑇝', to: '𑇟', mapping: Valid },
    Range { from: '𑇠', to: '𑇠', mapping: Disallowed },
    Range { from: '𑇡', to: '𑇴', mapping: Valid },
    Range { from: '𑇵', to: '𑇿', mapping: Disallowed },
    Range { from: '𑈀', to: '𑈑', mapping: Valid },
    Range { from: '𑈒', to: '𑈒', mapping: Disallowed },
    Range { from: '𑈓', to: '𑈷', mapping: Valid },
    Range { from: '𑈸', to: '𑈽', mapping: Valid },
    Range { from: '𑈾', to: '𑉿', mapping: Disallowed },
    Range { from: '𑊀', to: '𑊆', mapping: Valid },
    Range { from: '𑊇', to: '𑊇', mapping: Disallowed },
    Range { from: '𑊈', to: '𑊈', mapping: Valid },
    Range { from: '𑊉', to: '𑊉', mapping: Disallowed },
    Range { from: '𑊊', to: '𑊍', mapping: Valid },
    Range { from: '𑊎', to: '𑊎', mapping: Disallowed },
    Range { from: '𑊏', to: '𑊝', mapping: Valid },
    Range { from: '𑊞', to: '𑊞', mapping: Disallowed },
    Range { from: '𑊟', to: '𑊨', mapping: Valid },
    Range { from: '𑊩', to: '𑊩', mapping: Valid },
    Range { from: '𑊪', to: '𑊯', mapping: Disallowed },
    Range { from: '𑊰', to: '𑋪', mapping: Valid },
    Range { from: '𑋫', to: '𑋯', mapping: Disallowed },
    Range { from: '𑋰', to: '𑋹', mapping: Valid },
    Range { from: '𑋺', to: '𑋿', mapping: Disallowed },
    Range { from: '𑌀', to: '𑌀', mapping: Valid },
    Range { from: '𑌁', to: '𑌃', mapping: Valid },
    Range { from: '𑌄', to: '𑌄', mapping: Disallowed },
    Range { from: '𑌅', to: '𑌌', mapping: Valid },
    Range { from: '𑌍', to: '𑌎', mapping: Disallowed },
    Range { from: '𑌏', to: '𑌐', mapping: Valid },
    Range { from: '𑌑', to: '𑌒', mapping: Disallowed },
    Range { from: '𑌓', to: '𑌨', mapping: Valid },
    Range { from: '𑌩', to: '𑌩', mapping: Disallowed },
    Range { from: '𑌪', to: '𑌰', mapping: Valid },
    Range { from: '𑌱', to: '𑌱', mapping: Disallowed },
    Range { from: '𑌲', to: '𑌳', mapping: Valid },
    Range { from: '𑌴', to: '𑌴', mapping: Disallowed },
    Range { from: '𑌵', to: '𑌹', mapping: Valid },
    Range { from: '𑌺', to: '𑌻', mapping: Disallowed },
    Range { from: '𑌼', to: '𑍄', mapping: Valid },
    Range { from: '𑍅', to: '𑍆', mapping: Disallowed },
    Range { from: '𑍇', to: '𑍈', mapping: Valid },
    Range { from: '𑍉', to: '𑍊', mapping: Disallowed },
    Range { from: '𑍋', to: '𑍍', mapping: Valid },
    Range { from: '𑍎', to: '𑍏', mapping: Disallowed },
    Range { from: '𑍐', to: '𑍐', mapping: Valid },
    Range { from: '𑍑', to: '𑍖', mapping: Disallowed },
    Range { from: '𑍗', to: '𑍗', mapping: Valid },
    Range { from: '𑍘', to: '𑍜', mapping: Disallowed },
    Range { from: '𑍝', to: '𑍣', mapping: Valid },
    Range { from: '𑍤', to: '𑍥', mapping: Disallowed },
    Range { from: '𑍦', to: '𑍬', mapping: Valid },
    Range { from: '𑍭', to: '𑍯', mapping: Disallowed },
    Range { from: '𑍰', to: '𑍴', mapping: Valid },
    Range { from: '𑍵', to: '𑑿', mapping: Disallowed },
    Range { from: '𑒀', to: '𑓅', mapping: Valid },
    Range { from: '𑓆', to: '𑓆', mapping: Valid },
    Range { from: '𑓇', to: '𑓇', mapping: Valid },
    Range { from: '𑓈', to: '𑓏', mapping: Disallowed },
    Range { from: '𑓐', to: '𑓙', mapping: Valid },
    Range { from: '𑓚', to: '𑕿', mapping: Disallowed },
    Range { from: '𑖀', to: '𑖵', mapping: Valid },
    Range { from: '𑖶', to: '𑖷', mapping: Disallowed },
    Range { from: '𑖸', to: '𑗀', mapping: Valid },
    Range { from: '𑗁', to: '𑗉', mapping: Valid },
    Range { from: '𑗊', to: '𑗗', mapping: Valid },
    Range { from: '𑗘', to: '𑗝', mapping: Valid },
    Range { from: '𑗞', to: '𑗿', mapping: Disallowed },
    Range { from: '𑘀', to: '𑙀', mapping: Valid },
    Range { from: '𑙁', to: '𑙃', mapping: Valid },
    Range { from: '𑙄', to: '𑙄', mapping: Valid },
    Range { from: '𑙅', to: '𑙏', mapping: Disallowed },
    Range { from: '𑙐', to: '𑙙', mapping: Valid },
    Range { from: '𑙚', to: '𑙿', mapping: Disallowed },
    Range { from: '𑚀', to: '𑚷', mapping: Valid },
    Range { from: '𑚸', to: '𑚿', mapping: Disallowed },
    Range { from: '𑛀', to: '𑛉', mapping: Valid },
    Range { from: '𑛊', to: '𑛿', mapping: Disallowed },
    Range { from: '𑜀', to: '𑜙', mapping: Valid },
    Range { from: '𑜚', to: '𑜜', mapping: Disallowed },
    Range { from: '𑜝', to: '𑜫', mapping: Valid },
    Range { from: '𑜬', to: '𑜯', mapping: Disallowed },
    Range { from: '𑜰', to: '𑜹', mapping: Valid },
    Range { from: '𑜺', to: '𑜿', mapping: Valid },
    Range { from: '𑝀', to: '𑢟', mapping: Disallowed },
    Range { from: '𑢠', to: '𑢠', mapping: Mapped("𑣀") },
    Range { from: '𑢡', to: '𑢡', mapping: Mapped("𑣁") },
    Range { from: '𑢢', to: '𑢢', mapping: Mapped("𑣂") },
    Range { from: '𑢣', to: '𑢣', mapping: Mapped("𑣃") },
    Range { from: '𑢤', to: '𑢤', mapping: Mapped("𑣄") },
    Range { from: '𑢥', to: '𑢥', mapping: Mapped("𑣅") },
    Range { from: '𑢦', to: '𑢦', mapping: Mapped("𑣆") },
    Range { from: '𑢧', to: '𑢧', mapping: Mapped("𑣇") },
    Range { from: '𑢨', to: '𑢨', mapping: Mapped("𑣈") },
    Range { from: '𑢩', to: '𑢩', mapping: Mapped("𑣉") },
    Range { from: '𑢪', to: '𑢪', mapping: Mapped("𑣊") },
    Range { from: '𑢫', to: '𑢫', mapping: Mapped("𑣋") },
    Range { from: '𑢬', to: '𑢬', mapping: Mapped("𑣌") },
    Range { from: '𑢭', to: '𑢭', mapping: Mapped("𑣍") },
    Range { from: '𑢮', to: '𑢮', mapping: Mapped("𑣎") },
    Range { from: '𑢯', to: '𑢯', mapping: Mapped("𑣏") },
    Range { from: '𑢰', to: '𑢰', mapping: Mapped("𑣐") },
    Range { from: '𑢱', to: '𑢱', mapping: Mapped("𑣑") },
    Range { from: '𑢲', to: '𑢲', mapping: Mapped("𑣒") },
    Range { from: '𑢳', to: '𑢳', mapping: Mapped("𑣓") },
    Range { from: '𑢴', to: '𑢴', mapping: Mapped("𑣔") },
    Range { from: '𑢵', to: '𑢵', mapping: Mapped("𑣕") },
    Range { from: '𑢶', to: '𑢶', mapping: Mapped("𑣖") },
    Range { from: '𑢷', to: '𑢷', mapping: Mapped("𑣗") },
    Range { from: '𑢸', to: '𑢸', mapping: Mapped("𑣘") },
    Range { from: '𑢹', to: '𑢹', mapping: Mapped("𑣙") },
    Range { from: '𑢺', to: '𑢺', mapping: Mapped("𑣚") },
    Range { from: '𑢻', to: '𑢻', mapping: Mapped("𑣛") },
    Range { from: '𑢼', to: '𑢼', mapping: Mapped("𑣜") },
    Range { from: '𑢽', to: '𑢽', mapping: Mapped("𑣝") },
    Range { from: '𑢾', to: '𑢾', mapping: Mapped("𑣞") },
    Range { from: '𑢿', to: '𑢿', mapping: Mapped("𑣟") },
    Range { from: '𑣀', to: '𑣩', mapping: Valid },
    Range { from: '𑣪', to: '𑣲', mapping: Valid },
    Range { from: '𑣳', to: '𑣾', mapping: Disallowed },
    Range { from: '𑣿', to: '𑣿', mapping: Valid },
    Range { from: '𑤀', to: '𑪿', mapping: Disallowed },
    Range { from: '𑫀', to: '𑫸', mapping: Valid },
    Range { from: '𑫹', to: '𑿿', mapping: Disallowed },
    Range { from: '𒀀', to: '𒍮', mapping: Valid },
    Range { from: '𒍯', to: '𒎘', mapping: Valid },
    Range { from: '𒎙', to: '𒎙', mapping: Valid },
    Range { from: '𒎚', to: '𒏿', mapping: Disallowed },
    Range { from: '𒐀', to: '𒑢', mapping: Valid },
    Range { from: '𒑣', to: '𒑮', mapping: Valid },
    Range { from: '𒑯', to: '𒑯', mapping: Disallowed },
    Range { from: '𒑰', to: '𒑳', mapping: Valid },
    Range { from: '𒑴', to: '𒑴', mapping: Valid },
    Range { from: '𒑵', to: '𒑿', mapping: Disallowed },
    Range { from: '𒒀', to: '𒕃', mapping: Valid },
    Range { from: '𒕄', to: '𒿿', mapping: Disallowed },
    Range { from: '𓀀', to: '𓐮', mapping: Valid },
    Range { from: '𓐯', to: '𔏿', mapping: Disallowed },
    Range { from: '𔐀', to: '𔙆', mapping: Valid },
    Range { from: '𔙇', to: '𖟿', mapping: Disallowed },
    Range { from: '𖠀', to: '𖨸', mapping: Valid },
    Range { from: '𖨹', to: '𖨿', mapping: Disallowed },
    Range { from: '𖩀', to: '𖩞', mapping: Valid },
    Range { from: '𖩟', to: '𖩟', mapping: Disallowed },
    Range { from: '𖩠', to: '𖩩', mapping: Valid },
    Range { from: '𖩪', to: '𖩭', mapping: Disallowed },
    Range { from: '𖩮', to: '𖩯', mapping: Valid },
    Range { from: '𖩰', to: '𖫏', mapping: Disallowed },
    Range { from: '𖫐', to: '𖫭', mapping: Valid },
    Range { from: '𖫮', to: '𖫯', mapping: Disallowed },
    Range { from: '𖫰', to: '𖫴', mapping: Valid },
    Range { from: '𖫵', to: '𖫵', mapping: Valid },
    Range { from: '𖫶', to: '𖫿', mapping: Disallowed },
    Range { from: '𖬀', to: '𖬶', mapping: Valid },
    Range { from: '𖬷', to: '𖬿', mapping: Valid },
    Range { from: '𖭀', to: '𖭃', mapping: Valid },
    Range { from: '𖭄', to: '𖭅', mapping: Valid },
    Range { from: '𖭆', to: '𖭏', mapping: Disallowed },
    Range { from: '𖭐', to: '𖭙', mapping: Valid },
    Range { from: '𖭚', to: '𖭚', mapping: Disallowed },
    Range { from: '𖭛', to: '𖭡', mapping: Valid },
    Range { from: '𖭢', to: '𖭢', mapping: Disallowed },
    Range { from: '𖭣', to: '𖭷', mapping: Valid },
    Range { from: '𖭸', to: '𖭼', mapping: Disallowed },
    Range { from: '𖭽', to: '𖮏', mapping: Valid },
    Range { from: '𖮐', to: '𖻿', mapping: Disallowed },
    Range { from: '𖼀', to: '𖽄', mapping: Valid },
    Range { from: '𖽅', to: '𖽏', mapping: Disallowed },
    Range { from: '𖽐', to: '𖽾', mapping: Valid },
    Range { from: '𖽿', to: '𖾎', mapping: Disallowed },
    Range { from: '𖾏', to: '𖾟', mapping: Valid },
    Range { from: '𖾠', to: '𚿿', mapping: Disallowed },
    Range { from: '𛀀', to: '𛀁', mapping: Valid },
    Range { from: '𛀂', to: '𛯿', mapping: Disallowed },
    Range { from: '𛰀', to: '𛱪', mapping: Valid },
    Range { from: '𛱫', to: '𛱯', mapping: Disallowed },
    Range { from: '𛱰', to: '𛱼', mapping: Valid },
    Range { from: '𛱽', to: '𛱿', mapping: Disallowed },
    Range { from: '𛲀', to: '𛲈', mapping: Valid },
    Range { from: '𛲉', to: '𛲏', mapping: Disallowed },
    Range { from: '𛲐', to: '𛲙', mapping: Valid },
    Range { from: '𛲚', to: '𛲛', mapping: Disallowed },
    Range { from: '𛲜', to: '𛲜', mapping: Valid },
    Range { from: '𛲝', to: '𛲞', mapping: Valid },
    Range { from: '𛲟', to: '𛲟', mapping: Valid },
    Range { from: '𛲠', to: '𛲣', mapping: Ignored },
    Range { from: '𛲤', to: '𜿿', mapping: Disallowed },
    Range { from: '𝀀', to: '𝃵', mapping: Valid },
    Range { from: '𝃶', to: '𝃿', mapping: Disallowed },
    Range { from: '𝄀', to: '𝄦', mapping: Valid },
    Range { from: '𝄧', to: '𝄨', mapping: Disallowed },
    Range { from: '𝄩', to: '𝄩', mapping: Valid },
    Range { from: '𝄪', to: '𝅝', mapping: Valid },
    Range { from: '𝅗𝅥', to: '𝅗𝅥', mapping: Mapped("𝅗𝅥") },
    Range { from: '𝅘𝅥', to: '𝅘𝅥', mapping: Mapped("𝅘𝅥") },
    Range { from: '𝅘𝅥𝅮', to: '𝅘𝅥𝅮', mapping: Mapped("𝅘𝅥𝅮") },
    Range { from: '𝅘𝅥𝅯', to: '𝅘𝅥𝅯', mapping: Mapped("𝅘𝅥𝅯") },
    Range { from: '𝅘𝅥𝅰', to: '𝅘𝅥𝅰', mapping: Mapped("𝅘𝅥𝅰") },
    Range { from: '𝅘𝅥𝅱', to: '𝅘𝅥𝅱', mapping: Mapped("𝅘𝅥𝅱") },
    Range { from: '𝅘𝅥𝅲', to: '𝅘𝅥𝅲', mapping: Mapped("𝅘𝅥𝅲") },
    Range { from: '𝅥', to: '𝅲', mapping: Valid },
    Range { from: '𝅳', to: '𝅺', mapping: Disallowed },
    Range { from: '𝅻', to: '𝆺', mapping: Valid },
    Range { from: '𝆹𝅥', to: '𝆹𝅥', mapping: Mapped("𝆹𝅥") },
    Range { from: '𝆺𝅥', to: '𝆺𝅥', mapping: Mapped("𝆺𝅥") },
    Range { from: '𝆹𝅥𝅮', to: '𝆹𝅥𝅮', mapping: Mapped("𝆹𝅥𝅮") },
    Range { from: '𝆺𝅥𝅮', to: '𝆺𝅥𝅮', mapping: Mapped("𝆺𝅥𝅮") },
    Range { from: '𝆹𝅥𝅯', to: '𝆹𝅥𝅯', mapping: Mapped("𝆹𝅥𝅯") },
    Range { from: '𝆺𝅥𝅯', to: '𝆺𝅥𝅯', mapping: Mapped("𝆺𝅥𝅯") },
    Range { from: '𝇁', to: '𝇝', mapping: Valid },
    Range { from: '𝇞', to: '𝇨', mapping: Valid },
    Range { from: '𝇩', to: '𝇿', mapping: Disallowed },
    Range { from: '𝈀', to: '𝉅', mapping: Valid },
    Range { from: '𝉆', to: '𝋿', mapping: Disallowed },
    Range { from: '𝌀', to: '𝍖', mapping: Valid },
    Range { from: '𝍗', to: '𝍟', mapping: Disallowed },
    Range { from: '𝍠', to: '𝍱', mapping: Valid },
    Range { from: '𝍲', to: '𝏿', mapping: Disallowed },
    Range { from: '𝐀', to: '𝐀', mapping: Mapped("a") },
    Range { from: '𝐁', to: '𝐁', mapping: Mapped("b") },
    Range { from: '𝐂', to: '𝐂', mapping: Mapped("c") },
    Range { from: '𝐃', to: '𝐃', mapping: Mapped("d") },
    Range { from: '𝐄', to: '𝐄', mapping: Mapped("e") },
    Range { from: '𝐅', to: '𝐅', mapping: Mapped("f") },
    Range { from: '𝐆', to: '𝐆', mapping: Mapped("g") },
    Range { from: '𝐇', to: '𝐇', mapping: Mapped("h") },
    Range { from: '𝐈', to: '𝐈', mapping: Mapped("i") },
    Range { from: '𝐉', to: '𝐉', mapping: Mapped("j") },
    Range { from: '𝐊', to: '𝐊', mapping: Mapped("k") },
    Range { from: '𝐋', to: '𝐋', mapping: Mapped("l") },
    Range { from: '𝐌', to: '𝐌', mapping: Mapped("m") },
    Range { from: '𝐍', to: '𝐍', mapping: Mapped("n") },
    Range { from: '𝐎', to: '𝐎', mapping: Mapped("o") },
    Range { from: '𝐏', to: '𝐏', mapping: Mapped("p") },
    Range { from: '𝐐', to: '𝐐', mapping: Mapped("q") },
    Range { from: '𝐑', to: '𝐑', mapping: Mapped("r") },
    Range { from: '𝐒', to: '𝐒', mapping: Mapped("s") },
    Range { from: '𝐓', to: '𝐓', mapping: Mapped("t") },
    Range { from: '𝐔', to: '𝐔', mapping: Mapped("u") },
    Range { from: '𝐕', to: '𝐕', mapping: Mapped("v") },
    Range { from: '𝐖', to: '𝐖', mapping: Mapped("w") },
    Range { from: '𝐗', to: '𝐗', mapping: Mapped("x") },
    Range { from: '𝐘', to: '𝐘', mapping: Mapped("y") },
    Range { from: '𝐙', to: '𝐙', mapping: Mapped("z") },
    Range { from: '𝐚', to: '𝐚', mapping: Mapped("a") },
    Range { from: '𝐛', to: '𝐛', mapping: Mapped("b") },
    Range { from: '𝐜', to: '𝐜', mapping: Mapped("c") },
    Range { from: '𝐝', to: '𝐝', mapping: Mapped("d") },
    Range { from: '𝐞', to: '𝐞', mapping: Mapped("e") },
    Range { from: '𝐟', to: '𝐟', mapping: Mapped("f") },
    Range { from: '𝐠', to: '𝐠', mapping: Mapped("g") },
    Range { from: '𝐡', to: '𝐡', mapping: Mapped("h") },
    Range { from: '𝐢', to: '𝐢', mapping: Mapped("i") },
    Range { from: '𝐣', to: '𝐣', mapping: Mapped("j") },
    Range { from: '𝐤', to: '𝐤', mapping: Mapped("k") },
    Range { from: '𝐥', to: '𝐥', mapping: Mapped("l") },
    Range { from: '𝐦', to: '𝐦', mapping: Mapped("m") },
    Range { from: '𝐧', to: '𝐧', mapping: Mapped("n") },
    Range { from: '𝐨', to: '𝐨', mapping: Mapped("o") },
    Range { from: '𝐩', to: '𝐩', mapping: Mapped("p") },
    Range { from: '𝐪', to: '𝐪', mapping: Mapped("q") },
    Range { from: '𝐫', to: '𝐫', mapping: Mapped("r") },
    Range { from: '𝐬', to: '𝐬', mapping: Mapped("s") },
    Range { from: '𝐭', to: '𝐭', mapping: Mapped("t") },
    Range { from: '𝐮', to: '𝐮', mapping: Mapped("u") },
    Range { from: '𝐯', to: '𝐯', mapping: Mapped("v") },
    Range { from: '𝐰', to: '𝐰', mapping: Mapped("w") },
    Range { from: '𝐱', to: '𝐱', mapping: Mapped("x") },
    Range { from: '𝐲', to: '𝐲', mapping: Mapped("y") },
    Range { from: '𝐳', to: '𝐳', mapping: Mapped("z") },
    Range { from: '𝐴', to: '𝐴', mapping: Mapped("a") },
    Range { from: '𝐵', to: '𝐵', mapping: Mapped("b") },
    Range { from: '𝐶', to: '𝐶', mapping: Mapped("c") },
    Range { from: '𝐷', to: '𝐷', mapping: Mapped("d") },
    Range { from: '𝐸', to: '𝐸', mapping: Mapped("e") },
    Range { from: '𝐹', to: '𝐹', mapping: Mapped("f") },
    Range { from: '𝐺', to: '𝐺', mapping: Mapped("g") },
    Range { from: '𝐻', to: '𝐻', mapping: Mapped("h") },
    Range { from: '𝐼', to: '𝐼', mapping: Mapped("i") },
    Range { from: '𝐽', to: '𝐽', mapping: Mapped("j") },
    Range { from: '𝐾', to: '𝐾', mapping: Mapped("k") },
    Range { from: '𝐿', to: '𝐿', mapping: Mapped("l") },
    Range { from: '𝑀', to: '𝑀', mapping: Mapped("m") },
    Range { from: '𝑁', to: '𝑁', mapping: Mapped("n") },
    Range { from: '𝑂', to: '𝑂', mapping: Mapped("o") },
    Range { from: '𝑃', to: '𝑃', mapping: Mapped("p") },
    Range { from: '𝑄', to: '𝑄', mapping: Mapped("q") },
    Range { from: '𝑅', to: '𝑅', mapping: Mapped("r") },
    Range { from: '𝑆', to: '𝑆', mapping: Mapped("s") },
    Range { from: '𝑇', to: '𝑇', mapping: Mapped("t") },
    Range { from: '𝑈', to: '𝑈', mapping: Mapped("u") },
    Range { from: '𝑉', to: '𝑉', mapping: Mapped("v") },
    Range { from: '𝑊', to: '𝑊', mapping: Mapped("w") },
    Range { from: '𝑋', to: '𝑋', mapping: Mapped("x") },
    Range { from: '𝑌', to: '𝑌', mapping: Mapped("y") },
    Range { from: '𝑍', to: '𝑍', mapping: Mapped("z") },
    Range { from: '𝑎', to: '𝑎', mapping: Mapped("a") },
    Range { from: '𝑏', to: '𝑏', mapping: Mapped("b") },
    Range { from: '𝑐', to: '𝑐', mapping: Mapped("c") },
    Range { from: '𝑑', to: '𝑑', mapping: Mapped("d") },
    Range { from: '𝑒', to: '𝑒', mapping: Mapped("e") },
    Range { from: '𝑓', to: '𝑓', mapping: Mapped("f") },
    Range { from: '𝑔', to: '𝑔', mapping: Mapped("g") },
    Range { from: '𝑕', to: '𝑕', mapping: Disallowed },
    Range { from: '𝑖', to: '𝑖', mapping: Mapped("i") },
    Range { from: '𝑗', to: '𝑗', mapping: Mapped("j") },
    Range { from: '𝑘', to: '𝑘', mapping: Mapped("k") },
    Range { from: '𝑙', to: '𝑙', mapping: Mapped("l") },
    Range { from: '𝑚', to: '𝑚', mapping: Mapped("m") },
    Range { from: '𝑛', to: '𝑛', mapping: Mapped("n") },
    Range { from: '𝑜', to: '𝑜', mapping: Mapped("o") },
    Range { from: '𝑝', to: '𝑝', mapping: Mapped("p") },
    Range { from: '𝑞', to: '𝑞', mapping: Mapped("q") },
    Range { from: '𝑟', to: '𝑟', mapping: Mapped("r") },
    Range { from: '𝑠', to: '𝑠', mapping: Mapped("s") },
    Range { from: '𝑡', to: '𝑡', mapping: Mapped("t") },
    Range { from: '𝑢', to: '𝑢', mapping: Mapped("u") },
    Range { from: '𝑣', to: '𝑣', mapping: Mapped("v") },
    Range { from: '𝑤', to: '𝑤', mapping: Mapped("w") },
    Range { from: '𝑥', to: '𝑥', mapping: Mapped("x") },
    Range { from: '𝑦', to: '𝑦', mapping: Mapped("y") },
    Range { from: '𝑧', to: '𝑧', mapping: Mapped("z") },
    Range { from: '𝑨', to: '𝑨', mapping: Mapped("a") },
    Range { from: '𝑩', to: '𝑩', mapping: Mapped("b") },
    Range { from: '𝑪', to: '𝑪', mapping: Mapped("c") },
    Range { from: '𝑫', to: '𝑫', mapping: Mapped("d") },
    Range { from: '𝑬', to: '𝑬', mapping: Mapped("e") },
    Range { from: '𝑭', to: '𝑭', mapping: Mapped("f") },
    Range { from: '𝑮', to: '𝑮', mapping: Mapped("g") },
    Range { from: '𝑯', to: '𝑯', mapping: Mapped("h") },
    Range { from: '𝑰', to: '𝑰', mapping: Mapped("i") },
    Range { from: '𝑱', to: '𝑱', mapping: Mapped("j") },
    Range { from: '𝑲', to: '𝑲', mapping: Mapped("k") },
    Range { from: '𝑳', to: '𝑳', mapping: Mapped("l") },
    Range { from: '𝑴', to: '𝑴', mapping: Mapped("m") },
    Range { from: '𝑵', to: '𝑵', mapping: Mapped("n") },
    Range { from: '𝑶', to: '𝑶', mapping: Mapped("o") },
    Range { from: '𝑷', to: '𝑷', mapping: Mapped("p") },
    Range { from: '𝑸', to: '𝑸', mapping: Mapped("q") },
    Range { from: '𝑹', to: '𝑹', mapping: Mapped("r") },
    Range { from: '𝑺', to: '𝑺', mapping: Mapped("s") },
    Range { from: '𝑻', to: '𝑻', mapping: Mapped("t") },
    Range { from: '𝑼', to: '𝑼', mapping: Mapped("u") },
    Range { from: '𝑽', to: '𝑽', mapping: Mapped("v") },
    Range { from: '𝑾', to: '𝑾', mapping: Mapped("w") },
    Range { from: '𝑿', to: '𝑿', mapping: Mapped("x") },
    Range { from: '𝒀', to: '𝒀', mapping: Mapped("y") },
    Range { from: '𝒁', to: '𝒁', mapping: Mapped("z") },
    Range { from: '𝒂', to: '𝒂', mapping: Mapped("a") },
    Range { from: '𝒃', to: '𝒃', mapping: Mapped("b") },
    Range { from: '𝒄', to: '𝒄', mapping: Mapped("c") },
    Range { from: '𝒅', to: '𝒅', mapping: Mapped("d") },
    Range { from: '𝒆', to: '𝒆', mapping: Mapped("e") },
    Range { from: '𝒇', to: '𝒇', mapping: Mapped("f") },
    Range { from: '𝒈', to: '𝒈', mapping: Mapped("g") },
    Range { from: '𝒉', to: '𝒉', mapping: Mapped("h") },
    Range { from: '𝒊', to: '𝒊', mapping: Mapped("i") },
    Range { from: '𝒋', to: '𝒋', mapping: Mapped("j") },
    Range { from: '𝒌', to: '𝒌', mapping: Mapped("k") },
    Range { from: '𝒍', to: '𝒍', mapping: Mapped("l") },
    Range { from: '𝒎', to: '𝒎', mapping: Mapped("m") },
    Range { from: '𝒏', to: '𝒏', mapping: Mapped("n") },
    Range { from: '𝒐', to: '𝒐', mapping: Mapped("o") },
    Range { from: '𝒑', to: '𝒑', mapping: Mapped("p") },
    Range { from: '𝒒', to: '𝒒', mapping: Mapped("q") },
    Range { from: '𝒓', to: '𝒓', mapping: Mapped("r") },
    Range { from: '𝒔', to: '𝒔', mapping: Mapped("s") },
    Range { from: '𝒕', to: '𝒕', mapping: Mapped("t") },
    Range { from: '𝒖', to: '𝒖', mapping: Mapped("u") },
    Range { from: '𝒗', to: '𝒗', mapping: Mapped("v") },
    Range { from: '𝒘', to: '𝒘', mapping: Mapped("w") },
    Range { from: '𝒙', to: '𝒙', mapping: Mapped("x") },
    Range { from: '𝒚', to: '𝒚', mapping: Mapped("y") },
    Range { from: '𝒛', to: '𝒛', mapping: Mapped("z") },
    Range { from: '𝒜', to: '𝒜', mapping: Mapped("a") },
    Range { from: '𝒝', to: '𝒝', mapping: Disallowed },
    Range { from: '𝒞', to: '𝒞', mapping: Mapped("c") },
    Range { from: '𝒟', to: '𝒟', mapping: Mapped("d") },
    Range { from: '𝒠', to: '𝒡', mapping: Disallowed },
    Range { from: '𝒢', to: '𝒢', mapping: Mapped("g") },
    Range { from: '𝒣', to: '𝒤', mapping: Disallowed },
    Range { from: '𝒥', to: '𝒥', mapping: Mapped("j") },
    Range { from: '𝒦', to: '𝒦', mapping: Mapped("k") },
    Range { from: '𝒧', to: '𝒨', mapping: Disallowed },
    Range { from: '𝒩', to: '𝒩', mapping: Mapped("n") },
    Range { from: '𝒪', to: '𝒪', mapping: Mapped("o") },
    Range { from: '𝒫', to: '𝒫', mapping: Mapped("p") },
    Range { from: '𝒬', to: '𝒬', mapping: Mapped("q") },
    Range { from: '𝒭', to: '𝒭', mapping: Disallowed },
    Range { from: '𝒮', to: '𝒮', mapping: Mapped("s") },
    Range { from: '𝒯', to: '𝒯', mapping: Mapped("t") },
    Range { from: '𝒰', to: '𝒰', mapping: Mapped("u") },
    Range { from: '𝒱', to: '𝒱', mapping: Mapped("v") },
    Range { from: '𝒲', to: '𝒲', mapping: Mapped("w") },
    Range { from: '𝒳', to: '𝒳', mapping: Mapped("x") },
    Range { from: '𝒴', to: '𝒴', mapping: Mapped("y") },
    Range { from: '𝒵', to: '𝒵', mapping: Mapped("z") },
    Range { from: '𝒶', to: '𝒶', mapping: Mapped("a") },
    Range { from: '𝒷', to: '𝒷', mapping: Mapped("b") },
    Range { from: '𝒸', to: '𝒸', mapping: Mapped("c") },
    Range { from: '𝒹', to: '𝒹', mapping: Mapped("d") },
    Range { from: '𝒺', to: '𝒺', mapping: Disallowed },
    Range { from: '𝒻', to: '𝒻', mapping: Mapped("f") },
    Range { from: '𝒼', to: '𝒼', mapping: Disallowed },
    Range { from: '𝒽', to: '𝒽', mapping: Mapped("h") },
    Range { from: '𝒾', to: '𝒾', mapping: Mapped("i") },
    Range { from: '𝒿', to: '𝒿', mapping: Mapped("j") },
    Range { from: '𝓀', to: '𝓀', mapping: Mapped("k") },
    Range { from: '𝓁', to: '𝓁', mapping: Mapped("l") },
    Range { from: '𝓂', to: '𝓂', mapping: Mapped("m") },
    Range { from: '𝓃', to: '𝓃', mapping: Mapped("n") },
    Range { from: '𝓄', to: '𝓄', mapping: Disallowed },
    Range { from: '𝓅', to: '𝓅', mapping: Mapped("p") },
    Range { from: '𝓆', to: '𝓆', mapping: Mapped("q") },
    Range { from: '𝓇', to: '𝓇', mapping: Mapped("r") },
    Range { from: '𝓈', to: '𝓈', mapping: Mapped("s") },
    Range { from: '𝓉', to: '𝓉', mapping: Mapped("t") },
    Range { from: '𝓊', to: '𝓊', mapping: Mapped("u") },
    Range { from: '𝓋', to: '𝓋', mapping: Mapped("v") },
    Range { from: '𝓌', to: '𝓌', mapping: Mapped("w") },
    Range { from: '𝓍', to: '𝓍', mapping: Mapped("x") },
    Range { from: '𝓎', to: '𝓎', mapping: Mapped("y") },
    Range { from: '𝓏', to: '𝓏', mapping: Mapped("z") },
    Range { from: '𝓐', to: '𝓐', mapping: Mapped("a") },
    Range { from: '𝓑', to: '𝓑', mapping: Mapped("b") },
    Range { from: '𝓒', to: '𝓒', mapping: Mapped("c") },
    Range { from: '𝓓', to: '𝓓', mapping: Mapped("d") },
    Range { from: '𝓔', to: '𝓔', mapping: Mapped("e") },
    Range { from: '𝓕', to: '𝓕', mapping: Mapped("f") },
    Range { from: '𝓖', to: '𝓖', mapping: Mapped("g") },
    Range { from: '𝓗', to: '𝓗', mapping: Mapped("h") },
    Range { from: '𝓘', to: '𝓘', mapping: Mapped("i") },
    Range { from: '𝓙', to: '𝓙', mapping: Mapped("j") },
    Range { from: '𝓚', to: '𝓚', mapping: Mapped("k") },
    Range { from: '𝓛', to: '𝓛', mapping: Mapped("l") },
    Range { from: '𝓜', to: '𝓜', mapping: Mapped("m") },
    Range { from: '𝓝', to: '𝓝', mapping: Mapped("n") },
    Range { from: '𝓞', to: '𝓞', mapping: Mapped("o") },
    Range { from: '𝓟', to: '𝓟', mapping: Mapped("p") },
    Range { from: '𝓠', to: '𝓠', mapping: Mapped("q") },
    Range { from: '𝓡', to: '𝓡', mapping: Mapped("r") },
    Range { from: '𝓢', to: '𝓢', mapping: Mapped("s") },
    Range { from: '𝓣', to: '𝓣', mapping: Mapped("t") },
    Range { from: '𝓤', to: '𝓤', mapping: Mapped("u") },
    Range { from: '𝓥', to: '𝓥', mapping: Mapped("v") },
    Range { from: '𝓦', to: '𝓦', mapping: Mapped("w") },
    Range { from: '𝓧', to: '𝓧', mapping: Mapped("x") },
    Range { from: '𝓨', to: '𝓨', mapping: Mapped("y") },
    Range { from: '𝓩', to: '𝓩', mapping: Mapped("z") },
    Range { from: '𝓪', to: '𝓪', mapping: Mapped("a") },
    Range { from: '𝓫', to: '𝓫', mapping: Mapped("b") },
    Range { from: '𝓬', to: '𝓬', mapping: Mapped("c") },
    Range { from: '𝓭', to: '𝓭', mapping: Mapped("d") },
    Range { from: '𝓮', to: '𝓮', mapping: Mapped("e") },
    Range { from: '𝓯', to: '𝓯', mapping: Mapped("f") },
    Range { from: '𝓰', to: '𝓰', mapping: Mapped("g") },
    Range { from: '𝓱', to: '𝓱', mapping: Mapped("h") },
    Range { from: '𝓲', to: '𝓲', mapping: Mapped("i") },
    Range { from: '𝓳', to: '𝓳', mapping: Mapped("j") },
    Range { from: '𝓴', to: '𝓴', mapping: Mapped("k") },
    Range { from: '𝓵', to: '𝓵', mapping: Mapped("l") },
    Range { from: '𝓶', to: '𝓶', mapping: Mapped("m") },
    Range { from: '𝓷', to: '𝓷', mapping: Mapped("n") },
    Range { from: '𝓸', to: '𝓸', mapping: Mapped("o") },
    Range { from: '𝓹', to: '𝓹', mapping: Mapped("p") },
    Range { from: '𝓺', to: '𝓺', mapping: Mapped("q") },
    Range { from: '𝓻', to: '𝓻', mapping: Mapped("r") },
    Range { from: '𝓼', to: '𝓼', mapping: Mapped("s") },
    Range { from: '𝓽', to: '𝓽', mapping: Mapped("t") },
    Range { from: '𝓾', to: '𝓾', mapping: Mapped("u") },
    Range { from: '𝓿', to: '𝓿', mapping: Mapped("v") },
    Range { from: '𝔀', to: '𝔀', mapping: Mapped("w") },
    Range { from: '𝔁', to: '𝔁', mapping: Mapped("x") },
    Range { from: '𝔂', to: '𝔂', mapping: Mapped("y") },
    Range { from: '𝔃', to: '𝔃', mapping: Mapped("z") },
    Range { from: '𝔄', to: '𝔄', mapping: Mapped("a") },
    Range { from: '𝔅', to: '𝔅', mapping: Mapped("b") },
    Range { from: '𝔆', to: '𝔆', mapping: Disallowed },
    Range { from: '𝔇', to: '𝔇', mapping: Mapped("d") },
    Range { from: '𝔈', to: '𝔈', mapping: Mapped("e") },
    Range { from: '𝔉', to: '𝔉', mapping: Mapped("f") },
    Range { from: '𝔊', to: '𝔊', mapping: Mapped("g") },
    Range { from: '𝔋', to: '𝔌', mapping: Disallowed },
    Range { from: '𝔍', to: '𝔍', mapping: Mapped("j") },
    Range { from: '𝔎', to: '𝔎', mapping: Mapped("k") },
    Range { from: '𝔏', to: '𝔏', mapping: Mapped("l") },
    Range { from: '𝔐', to: '𝔐', mapping: Mapped("m") },
    Range { from: '𝔑', to: '𝔑', mapping: Mapped("n") },
    Range { from: '𝔒', to: '𝔒', mapping: Mapped("o") },
    Range { from: '𝔓', to: '𝔓', mapping: Mapped("p") },
    Range { from: '𝔔', to: '𝔔', mapping: Mapped("q") },
    Range { from: '𝔕', to: '𝔕', mapping: Disallowed },
    Range { from: '𝔖', to: '𝔖', mapping: Mapped("s") },
    Range { from: '𝔗', to: '𝔗', mapping: Mapped("t") },
    Range { from: '𝔘', to: '𝔘', mapping: Mapped("u") },
    Range { from: '𝔙', to: '𝔙', mapping: Mapped("v") },
    Range { from: '𝔚', to: '𝔚', mapping: Mapped("w") },
    Range { from: '𝔛', to: '𝔛', mapping: Mapped("x") },
    Range { from: '𝔜', to: '𝔜', mapping: Mapped("y") },
    Range { from: '𝔝', to: '𝔝', mapping: Disallowed },
    Range { from: '𝔞', to: '𝔞', mapping: Mapped("a") },
    Range { from: '𝔟', to: '𝔟', mapping: Mapped("b") },
    Range { from: '𝔠', to: '𝔠', mapping: Mapped("c") },
    Range { from: '𝔡', to: '𝔡', mapping: Mapped("d") },
    Range { from: '𝔢', to: '𝔢', mapping: Mapped("e") },
    Range { from: '𝔣', to: '𝔣', mapping: Mapped("f") },
    Range { from: '𝔤', to: '𝔤', mapping: Mapped("g") },
    Range { from: '𝔥', to: '𝔥', mapping: Mapped("h") },
    Range { from: '𝔦', to: '𝔦', mapping: Mapped("i") },
    Range { from: '𝔧', to: '𝔧', mapping: Mapped("j") },
    Range { from: '𝔨', to: '𝔨', mapping: Mapped("k") },
    Range { from: '𝔩', to: '𝔩', mapping: Mapped("l") },
    Range { from: '𝔪', to: '𝔪', mapping: Mapped("m") },
    Range { from: '𝔫', to: '𝔫', mapping: Mapped("n") },
    Range { from: '𝔬', to: '𝔬', mapping: Mapped("o") },
    Range { from: '𝔭', to: '𝔭', mapping: Mapped("p") },
    Range { from: '𝔮', to: '𝔮', mapping: Mapped("q") },
    Range { from: '𝔯', to: '𝔯', mapping: Mapped("r") },
    Range { from: '𝔰', to: '𝔰', mapping: Mapped("s") },
    Range { from: '𝔱', to: '𝔱', mapping: Mapped("t") },
    Range { from: '𝔲', to: '𝔲', mapping: Mapped("u") },
    Range { from: '𝔳', to: '𝔳', mapping: Mapped("v") },
    Range { from: '𝔴', to: '𝔴', mapping: Mapped("w") },
    Range { from: '𝔵', to: '𝔵', mapping: Mapped("x") },
    Range { from: '𝔶', to: '𝔶', mapping: Mapped("y") },
    Range { from: '𝔷', to: '𝔷', mapping: Mapped("z") },
    Range { from: '𝔸', to: '𝔸', mapping: Mapped("a") },
    Range { from: '𝔹', to: '𝔹', mapping: Mapped("b") },
    Range { from: '𝔺', to: '𝔺', mapping: Disallowed },
    Range { from: '𝔻', to: '𝔻', mapping: Mapped("d") },
    Range { from: '𝔼', to: '𝔼', mapping: Mapped("e") },
    Range { from: '𝔽', to: '𝔽', mapping: Mapped("f") },
    Range { from: '𝔾', to: '𝔾', mapping: Mapped("g") },
    Range { from: '𝔿', to: '𝔿', mapping: Disallowed },
    Range { from: '𝕀', to: '𝕀', mapping: Mapped("i") },
    Range { from: '𝕁', to: '𝕁', mapping: Mapped("j") },
    Range { from: '𝕂', to: '𝕂', mapping: Mapped("k") },
    Range { from: '𝕃', to: '𝕃', mapping: Mapped("l") },
    Range { from: '𝕄', to: '𝕄', mapping: Mapped("m") },
    Range { from: '𝕅', to: '𝕅', mapping: Disallowed },
    Range { from: '𝕆', to: '𝕆', mapping: Mapped("o") },
    Range { from: '𝕇', to: '𝕉', mapping: Disallowed },
    Range { from: '𝕊', to: '𝕊', mapping: Mapped("s") },
    Range { from: '𝕋', to: '𝕋', mapping: Mapped("t") },
    Range { from: '𝕌', to: '𝕌', mapping: Mapped("u") },
    Range { from: '𝕍', to: '𝕍', mapping: Mapped("v") },
    Range { from: '𝕎', to: '𝕎', mapping: Mapped("w") },
    Range { from: '𝕏', to: '𝕏', mapping: Mapped("x") },
    Range { from: '𝕐', to: '𝕐', mapping: Mapped("y") },
    Range { from: '𝕑', to: '𝕑', mapping: Disallowed },
    Range { from: '𝕒', to: '𝕒', mapping: Mapped("a") },
    Range { from: '𝕓', to: '𝕓', mapping: Mapped("b") },
    Range { from: '𝕔', to: '𝕔', mapping: Mapped("c") },
    Range { from: '𝕕', to: '𝕕', mapping: Mapped("d") },
    Range { from: '𝕖', to: '𝕖', mapping: Mapped("e") },
    Range { from: '𝕗', to: '𝕗', mapping: Mapped("f") },
    Range { from: '𝕘', to: '𝕘', mapping: Mapped("g") },
    Range { from: '𝕙', to: '𝕙', mapping: Mapped("h") },
    Range { from: '𝕚', to: '𝕚', mapping: Mapped("i") },
    Range { from: '𝕛', to: '𝕛', mapping: Mapped("j") },
    Range { from: '𝕜', to: '𝕜', mapping: Mapped("k") },
    Range { from: '𝕝', to: '𝕝', mapping: Mapped("l") },
    Range { from: '𝕞', to: '𝕞', mapping: Mapped("m") },
    Range { from: '𝕟', to: '𝕟', mapping: Mapped("n") },
    Range { from: '𝕠', to: '𝕠', mapping: Mapped("o") },
    Range { from: '𝕡', to: '𝕡', mapping: Mapped("p") },
    Range { from: '𝕢', to: '𝕢', mapping: Mapped("q") },
    Range { from: '𝕣', to: '𝕣', mapping: Mapped("r") },
    Range { from: '𝕤', to: '𝕤', mapping: Mapped("s") },
    Range { from: '𝕥', to: '𝕥', mapping: Mapped("t") },
    Range { from: '𝕦', to: '𝕦', mapping: Mapped("u") },
    Range { from: '𝕧', to: '𝕧', mapping: Mapped("v") },
    Range { from: '𝕨', to: '𝕨', mapping: Mapped("w") },
    Range { from: '𝕩', to: '𝕩', mapping: Mapped("x") },
    Range { from: '𝕪', to: '𝕪', mapping: Mapped("y") },
    Range { from: '𝕫', to: '𝕫', mapping: Mapped("z") },
    Range { from: '𝕬', to: '𝕬', mapping: Mapped("a") },
    Range { from: '𝕭', to: '𝕭', mapping: Mapped("b") },
    Range { from: '𝕮', to: '𝕮', mapping: Mapped("c") },
    Range { from: '𝕯', to: '𝕯', mapping: Mapped("d") },
    Range { from: '𝕰', to: '𝕰', mapping: Mapped("e") },
    Range { from: '𝕱', to: '𝕱', mapping: Mapped("f") },
    Range { from: '𝕲', to: '𝕲', mapping: Mapped("g") },
    Range { from: '𝕳', to: '𝕳', mapping: Mapped("h") },
    Range { from: '𝕴', to: '𝕴', mapping: Mapped("i") },
    Range { from: '𝕵', to: '𝕵', mapping: Mapped("j") },
    Range { from: '𝕶', to: '𝕶', mapping: Mapped("k") },
    Range { from: '𝕷', to: '𝕷', mapping: Mapped("l") },
    Range { from: '𝕸', to: '𝕸', mapping: Mapped("m") },
    Range { from: '𝕹', to: '𝕹', mapping: Mapped("n") },
    Range { from: '𝕺', to: '𝕺', mapping: Mapped("o") },
    Range { from: '𝕻', to: '𝕻', mapping: Mapped("p") },
    Range { from: '𝕼', to: '𝕼', mapping: Mapped("q") },
    Range { from: '𝕽', to: '𝕽', mapping: Mapped("r") },
    Range { from: '𝕾', to: '𝕾', mapping: Mapped("s") },
    Range { from: '𝕿', to: '𝕿', mapping: Mapped("t") },
    Range { from: '𝖀', to: '𝖀', mapping: Mapped("u") },
    Range { from: '𝖁', to: '𝖁', mapping: Mapped("v") },
    Range { from: '𝖂', to: '𝖂', mapping: Mapped("w") },
    Range { from: '𝖃', to: '𝖃', mapping: Mapped("x") },
    Range { from: '𝖄', to: '𝖄', mapping: Mapped("y") },
    Range { from: '𝖅', to: '𝖅', mapping: Mapped("z") },
    Range { from: '𝖆', to: '𝖆', mapping: Mapped("a") },
    Range { from: '𝖇', to: '𝖇', mapping: Mapped("b") },
    Range { from: '𝖈', to: '𝖈', mapping: Mapped("c") },
    Range { from: '𝖉', to: '𝖉', mapping: Mapped("d") },
    Range { from: '𝖊', to: '𝖊', mapping: Mapped("e") },
    Range { from: '𝖋', to: '𝖋', mapping: Mapped("f") },
    Range { from: '𝖌', to: '𝖌', mapping: Mapped("g") },
    Range { from: '𝖍', to: '𝖍', mapping: Mapped("h") },
    Range { from: '𝖎', to: '𝖎', mapping: Mapped("i") },
    Range { from: '𝖏', to: '𝖏', mapping: Mapped("j") },
    Range { from: '𝖐', to: '𝖐', mapping: Mapped("k") },
    Range { from: '𝖑', to: '𝖑', mapping: Mapped("l") },
    Range { from: '𝖒', to: '𝖒', mapping: Mapped("m") },
    Range { from: '𝖓', to: '𝖓', mapping: Mapped("n") },
    Range { from: '𝖔', to: '𝖔', mapping: Mapped("o") },
    Range { from: '𝖕', to: '𝖕', mapping: Mapped("p") },
    Range { from: '𝖖', to: '𝖖', mapping: Mapped("q") },
    Range { from: '𝖗', to: '𝖗', mapping: Mapped("r") },
    Range { from: '𝖘', to: '𝖘', mapping: Mapped("s") },
    Range { from: '𝖙', to: '𝖙', mapping: Mapped("t") },
    Range { from: '𝖚', to: '𝖚', mapping: Mapped("u") },
    Range { from: '𝖛', to: '𝖛', mapping: Mapped("v") },
    Range { from: '𝖜', to: '𝖜', mapping: Mapped("w") },
    Range { from: '𝖝', to: '𝖝', mapping: Mapped("x") },
    Range { from: '𝖞', to: '𝖞', mapping: Mapped("y") },
    Range { from: '𝖟', to: '𝖟', mapping: Mapped("z") },
    Range { from: '𝖠', to: '𝖠', mapping: Mapped("a") },
    Range { from: '𝖡', to: '𝖡', mapping: Mapped("b") },
    Range { from: '𝖢', to: '𝖢', mapping: Mapped("c") },
    Range { from: '𝖣', to: '𝖣', mapping: Mapped("d") },
    Range { from: '𝖤', to: '𝖤', mapping: Mapped("e") },
    Range { from: '𝖥', to: '𝖥', mapping: Mapped("f") },
    Range { from: '𝖦', to: '𝖦', mapping: Mapped("g") },
    Range { from: '𝖧', to: '𝖧', mapping: Mapped("h") },
    Range { from: '𝖨', to: '𝖨', mapping: Mapped("i") },
    Range { from: '𝖩', to: '𝖩', mapping: Mapped("j") },
    Range { from: '𝖪', to: '𝖪', mapping: Mapped("k") },
    Range { from: '𝖫', to: '𝖫', mapping: Mapped("l") },
    Range { from: '𝖬', to: '𝖬', mapping: Mapped("m") },
    Range { from: '𝖭', to: '𝖭', mapping: Mapped("n") },
    Range { from: '𝖮', to: '𝖮', mapping: Mapped("o") },
    Range { from: '𝖯', to: '𝖯', mapping: Mapped("p") },
    Range { from: '𝖰', to: '𝖰', mapping: Mapped("q") },
    Range { from: '𝖱', to: '𝖱', mapping: Mapped("r") },
    Range { from: '𝖲', to: '𝖲', mapping: Mapped("s") },
    Range { from: '𝖳', to: '𝖳', mapping: Mapped("t") },
    Range { from: '𝖴', to: '𝖴', mapping: Mapped("u") },
    Range { from: '𝖵', to: '𝖵', mapping: Mapped("v") },
    Range { from: '𝖶', to: '𝖶', mapping: Mapped("w") },
    Range { from: '𝖷', to: '𝖷', mapping: Mapped("x") },
    Range { from: '𝖸', to: '𝖸', mapping: Mapped("y") },
    Range { from: '𝖹', to: '𝖹', mapping: Mapped("z") },
    Range { from: '𝖺', to: '𝖺', mapping: Mapped("a") },
    Range { from: '𝖻', to: '𝖻', mapping: Mapped("b") },
    Range { from: '𝖼', to: '𝖼', mapping: Mapped("c") },
    Range { from: '𝖽', to: '𝖽', mapping: Mapped("d") },
    Range { from: '𝖾', to: '𝖾', mapping: Mapped("e") },
    Range { from: '𝖿', to: '𝖿', mapping: Mapped("f") },
    Range { from: '𝗀', to: '𝗀', mapping: Mapped("g") },
    Range { from: '𝗁', to: '𝗁', mapping: Mapped("h") },
    Range { from: '𝗂', to: '𝗂', mapping: Mapped("i") },
    Range { from: '𝗃', to: '𝗃', mapping: Mapped("j") },
    Range { from: '𝗄', to: '𝗄', mapping: Mapped("k") },
    Range { from: '𝗅', to: '𝗅', mapping: Mapped("l") },
    Range { from: '𝗆', to: '𝗆', mapping: Mapped("m") },
    Range { from: '𝗇', to: '𝗇', mapping: Mapped("n") },
    Range { from: '𝗈', to: '𝗈', mapping: Mapped("o") },
    Range { from: '𝗉', to: '𝗉', mapping: Mapped("p") },
    Range { from: '𝗊', to: '𝗊', mapping: Mapped("q") },
    Range { from: '𝗋', to: '𝗋', mapping: Mapped("r") },
    Range { from: '𝗌', to: '𝗌', mapping: Mapped("s") },
    Range { from: '𝗍', to: '𝗍', mapping: Mapped("t") },
    Range { from: '𝗎', to: '𝗎', mapping: Mapped("u") },
    Range { from: '𝗏', to: '𝗏', mapping: Mapped("v") },
    Range { from: '𝗐', to: '𝗐', mapping: Mapped("w") },
    Range { from: '𝗑', to: '𝗑', mapping: Mapped("x") },
    Range { from: '𝗒', to: '𝗒', mapping: Mapped("y") },
    Range { from: '𝗓', to: '𝗓', mapping: Mapped("z") },
    Range { from: '𝗔', to: '𝗔', mapping: Mapped("a") },
    Range { from: '𝗕', to: '𝗕', mapping: Mapped("b") },
    Range { from: '𝗖', to: '𝗖', mapping: Mapped("c") },
    Range { from: '𝗗', to: '𝗗', mapping: Mapped("d") },
    Range { from: '𝗘', to: '𝗘', mapping: Mapped("e") },
    Range { from: '𝗙', to: '𝗙', mapping: Mapped("f") },
    Range { from: '𝗚', to: '𝗚', mapping: Mapped("g") },
    Range { from: '𝗛', to: '𝗛', mapping: Mapped("h") },
    Range { from: '𝗜', to: '𝗜', mapping: Mapped("i") },
    Range { from: '𝗝', to: '𝗝', mapping: Mapped("j") },
    Range { from: '𝗞', to: '𝗞', mapping: Mapped("k") },
    Range { from: '𝗟', to: '𝗟', mapping: Mapped("l") },
    Range { from: '𝗠', to: '𝗠', mapping: Mapped("m") },
    Range { from: '𝗡', to: '𝗡', mapping: Mapped("n") },
    Range { from: '𝗢', to: '𝗢', mapping: Mapped("o") },
    Range { from: '𝗣', to: '𝗣', mapping: Mapped("p") },
    Range { from: '𝗤', to: '𝗤', mapping: Mapped("q") },
    Range { from: '𝗥', to: '𝗥', mapping: Mapped("r") },
    Range { from: '𝗦', to: '𝗦', mapping: Mapped("s") },
    Range { from: '𝗧', to: '𝗧', mapping: Mapped("t") },
    Range { from: '𝗨', to: '𝗨', mapping: Mapped("u") },
    Range { from: '𝗩', to: '𝗩', mapping: Mapped("v") },
    Range { from: '𝗪', to: '𝗪', mapping: Mapped("w") },
    Range { from: '𝗫', to: '𝗫', mapping: Mapped("x") },
    Range { from: '𝗬', to: '𝗬', mapping: Mapped("y") },
    Range { from: '𝗭', to: '𝗭', mapping: Mapped("z") },
    Range { from: '𝗮', to: '𝗮', mapping: Mapped("a") },
    Range { from: '𝗯', to: '𝗯', mapping: Mapped("b") },
    Range { from: '𝗰', to: '𝗰', mapping: Mapped("c") },
    Range { from: '𝗱', to: '𝗱', mapping: Mapped("d") },
    Range { from: '𝗲', to: '𝗲', mapping: Mapped("e") },
    Range { from: '𝗳', to: '𝗳', mapping: Mapped("f") },
    Range { from: '𝗴', to: '𝗴', mapping: Mapped("g") },
    Range { from: '𝗵', to: '𝗵', mapping: Mapped("h") },
    Range { from: '𝗶', to: '𝗶', mapping: Mapped("i") },
    Range { from: '𝗷', to: '𝗷', mapping: Mapped("j") },
    Range { from: '𝗸', to: '𝗸', mapping: Mapped("k") },
    Range { from: '𝗹', to: '𝗹', mapping: Mapped("l") },
    Range { from: '𝗺', to: '𝗺', mapping: Mapped("m") },
    Range { from: '𝗻', to: '𝗻', mapping: Mapped("n") },
    Range { from: '𝗼', to: '𝗼', mapping: Mapped("o") },
    Range { from: '𝗽', to: '𝗽', mapping: Mapped("p") },
    Range { from: '𝗾', to: '𝗾', mapping: Mapped("q") },
    Range { from: '𝗿', to: '𝗿', mapping: Mapped("r") },
    Range { from: '𝘀', to: '𝘀', mapping: Mapped("s") },
    Range { from: '𝘁', to: '𝘁', mapping: Mapped("t") },
    Range { from: '𝘂', to: '𝘂', mapping: Mapped("u") },
    Range { from: '𝘃', to: '𝘃', mapping: Mapped("v") },
    Range { from: '𝘄', to: '𝘄', mapping: Mapped("w") },
    Range { from: '𝘅', to: '𝘅', mapping: Mapped("x") },
    Range { from: '𝘆', to: '𝘆', mapping: Mapped("y") },
    Range { from: '𝘇', to: '𝘇', mapping: Mapped("z") },
    Range { from: '𝘈', to: '𝘈', mapping: Mapped("a") },
    Range { from: '𝘉', to: '𝘉', mapping: Mapped("b") },
    Range { from: '𝘊', to: '𝘊', mapping: Mapped("c") },
    Range { from: '𝘋', to: '𝘋', mapping: Mapped("d") },
    Range { from: '𝘌', to: '𝘌', mapping: Mapped("e") },
    Range { from: '𝘍', to: '𝘍', mapping: Mapped("f") },
    Range { from: '𝘎', to: '𝘎', mapping: Mapped("g") },
    Range { from: '𝘏', to: '𝘏', mapping: Mapped("h") },
    Range { from: '𝘐', to: '𝘐', mapping: Mapped("i") },
    Range { from: '𝘑', to: '𝘑', mapping: Mapped("j") },
    Range { from: '𝘒', to: '𝘒', mapping: Mapped("k") },
    Range { from: '𝘓', to: '𝘓', mapping: Mapped("l") },
    Range { from: '𝘔', to: '𝘔', mapping: Mapped("m") },
    Range { from: '𝘕', to: '𝘕', mapping: Mapped("n") },
    Range { from: '𝘖', to: '𝘖', mapping: Mapped("o") },
    Range { from: '𝘗', to: '𝘗', mapping: Mapped("p") },
    Range { from: '𝘘', to: '𝘘', mapping: Mapped("q") },
    Range { from: '𝘙', to: '𝘙', mapping: Mapped("r") },
    Range { from: '𝘚', to: '𝘚', mapping: Mapped("s") },
    Range { from: '𝘛', to: '𝘛', mapping: Mapped("t") },
    Range { from: '𝘜', to: '𝘜', mapping: Mapped("u") },
    Range { from: '𝘝', to: '𝘝', mapping: Mapped("v") },
    Range { from: '𝘞', to: '𝘞', mapping: Mapped("w") },
    Range { from: '𝘟', to: '𝘟', mapping: Mapped("x") },
    Range { from: '𝘠', to: '𝘠', mapping: Mapped("y") },
    Range { from: '𝘡', to: '𝘡', mapping: Mapped("z") },
    Range { from: '𝘢', to: '𝘢', mapping: Mapped("a") },
    Range { from: '𝘣', to: '𝘣', mapping: Mapped("b") },
    Range { from: '𝘤', to: '𝘤', mapping: Mapped("c") },
    Range { from: '𝘥', to: '𝘥', mapping: Mapped("d") },
    Range { from: '𝘦', to: '𝘦', mapping: Mapped("e") },
    Range { from: '𝘧', to: '𝘧', mapping: Mapped("f") },
    Range { from: '𝘨', to: '𝘨', mapping: Mapped("g") },
    Range { from: '𝘩', to: '𝘩', mapping: Mapped("h") },
    Range { from: '𝘪', to: '𝘪', mapping: Mapped("i") },
    Range { from: '𝘫', to: '𝘫', mapping: Mapped("j") },
    Range { from: '𝘬', to: '𝘬', mapping: Mapped("k") },
    Range { from: '𝘭', to: '𝘭', mapping: Mapped("l") },
    Range { from: '𝘮', to: '𝘮', mapping: Mapped("m") },
    Range { from: '𝘯', to: '𝘯', mapping: Mapped("n") },
    Range { from: '𝘰', to: '𝘰', mapping: Mapped("o") },
    Range { from: '𝘱', to: '𝘱', mapping: Mapped("p") },
    Range { from: '𝘲', to: '𝘲', mapping: Mapped("q") },
    Range { from: '𝘳', to: '𝘳', mapping: Mapped("r") },
    Range { from: '𝘴', to: '𝘴', mapping: Mapped("s") },
    Range { from: '𝘵', to: '𝘵', mapping: Mapped("t") },
    Range { from: '𝘶', to: '𝘶', mapping: Mapped("u") },
    Range { from: '𝘷', to: '𝘷', mapping: Mapped("v") },
    Range { from: '𝘸', to: '𝘸', mapping: Mapped("w") },
    Range { from: '𝘹', to: '𝘹', mapping: Mapped("x") },
    Range { from: '𝘺', to: '𝘺', mapping: Mapped("y") },
    Range { from: '𝘻', to: '𝘻', mapping: Mapped("z") },
    Range { from: '𝘼', to: '𝘼', mapping: Mapped("a") },
    Range { from: '𝘽', to: '𝘽', mapping: Mapped("b") },
    Range { from: '𝘾', to: '𝘾', mapping: Mapped("c") },
    Range { from: '𝘿', to: '𝘿', mapping: Mapped("d") },
    Range { from: '𝙀', to: '𝙀', mapping: Mapped("e") },
    Range { from: '𝙁', to: '𝙁', mapping: Mapped("f") },
    Range { from: '𝙂', to: '𝙂', mapping: Mapped("g") },
    Range { from: '𝙃', to: '𝙃', mapping: Mapped("h") },
    Range { from: '𝙄', to: '𝙄', mapping: Mapped("i") },
    Range { from: '𝙅', to: '𝙅', mapping: Mapped("j") },
    Range { from: '𝙆', to: '𝙆', mapping: Mapped("k") },
    Range { from: '𝙇', to: '𝙇', mapping: Mapped("l") },
    Range { from: '𝙈', to: '𝙈', mapping: Mapped("m") },
    Range { from: '𝙉', to: '𝙉', mapping: Mapped("n") },
    Range { from: '𝙊', to: '𝙊', mapping: Mapped("o") },
    Range { from: '𝙋', to: '𝙋', mapping: Mapped("p") },
    Range { from: '𝙌', to: '𝙌', mapping: Mapped("q") },
    Range { from: '𝙍', to: '𝙍', mapping: Mapped("r") },
    Range { from: '𝙎', to: '𝙎', mapping: Mapped("s") },
    Range { from: '𝙏', to: '𝙏', mapping: Mapped("t") },
    Range { from: '𝙐', to: '𝙐', mapping: Mapped("u") },
    Range { from: '𝙑', to: '𝙑', mapping: Mapped("v") },
    Range { from: '𝙒', to: '𝙒', mapping: Mapped("w") },
    Range { from: '𝙓', to: '𝙓', mapping: Mapped("x") },
    Range { from: '𝙔', to: '𝙔', mapping: Mapped("y") },
    Range { from: '𝙕', to: '𝙕', mapping: Mapped("z") },
    Range { from: '𝙖', to: '𝙖', mapping: Mapped("a") },
    Range { from: '𝙗', to: '𝙗', mapping: Mapped("b") },
    Range { from: '𝙘', to: '𝙘', mapping: Mapped("c") },
    Range { from: '𝙙', to: '𝙙', mapping: Mapped("d") },
    Range { from: '𝙚', to: '𝙚', mapping: Mapped("e") },
    Range { from: '𝙛', to: '𝙛', mapping: Mapped("f") },
    Range { from: '𝙜', to: '𝙜', mapping: Mapped("g") },
    Range { from: '𝙝', to: '𝙝', mapping: Mapped("h") },
    Range { from: '𝙞', to: '𝙞', mapping: Mapped("i") },
    Range { from: '𝙟', to: '𝙟', mapping: Mapped("j") },
    Range { from: '𝙠', to: '𝙠', mapping: Mapped("k") },
    Range { from: '𝙡', to: '𝙡', mapping: Mapped("l") },
    Range { from: '𝙢', to: '𝙢', mapping: Mapped("m") },
    Range { from: '𝙣', to: '𝙣', mapping: Mapped("n") },
    Range { from: '𝙤', to: '𝙤', mapping: Mapped("o") },
    Range { from: '𝙥', to: '𝙥', mapping: Mapped("p") },
    Range { from: '𝙦', to: '𝙦', mapping: Mapped("q") },
    Range { from: '𝙧', to: '𝙧', mapping: Mapped("r") },
    Range { from: '𝙨', to: '𝙨', mapping: Mapped("s") },
    Range { from: '𝙩', to: '𝙩', mapping: Mapped("t") },
    Range { from: '𝙪', to: '𝙪', mapping: Mapped("u") },
    Range { from: '𝙫', to: '𝙫', mapping: Mapped("v") },
    Range { from: '𝙬', to: '𝙬', mapping: Mapped("w") },
    Range { from: '𝙭', to: '𝙭', mapping: Mapped("x") },
    Range { from: '𝙮', to: '𝙮', mapping: Mapped("y") },
    Range { from: '𝙯', to: '𝙯', mapping: Mapped("z") },
    Range { from: '𝙰', to: '𝙰', mapping: Mapped("a") },
    Range { from: '𝙱', to: '𝙱', mapping: Mapped("b") },
    Range { from: '𝙲', to: '𝙲', mapping: Mapped("c") },
    Range { from: '𝙳', to: '𝙳', mapping: Mapped("d") },
    Range { from: '𝙴', to: '𝙴', mapping: Mapped("e") },
    Range { from: '𝙵', to: '𝙵', mapping: Mapped("f") },
    Range { from: '𝙶', to: '𝙶', mapping: Mapped("g") },
    Range { from: '𝙷', to: '𝙷', mapping: Mapped("h") },
    Range { from: '𝙸', to: '𝙸', mapping: Mapped("i") },
    Range { from: '𝙹', to: '𝙹', mapping: Mapped("j") },
    Range { from: '𝙺', to: '𝙺', mapping: Mapped("k") },
    Range { from: '𝙻', to: '𝙻', mapping: Mapped("l") },
    Range { from: '𝙼', to: '𝙼', mapping: Mapped("m") },
    Range { from: '𝙽', to: '𝙽', mapping: Mapped("n") },
    Range { from: '𝙾', to: '𝙾', mapping: Mapped("o") },
    Range { from: '𝙿', to: '𝙿', mapping: Mapped("p") },
    Range { from: '𝚀', to: '𝚀', mapping: Mapped("q") },
    Range { from: '𝚁', to: '𝚁', mapping: Mapped("r") },
    Range { from: '𝚂', to: '𝚂', mapping: Mapped("s") },
    Range { from: '𝚃', to: '𝚃', mapping: Mapped("t") },
    Range { from: '𝚄', to: '𝚄', mapping: Mapped("u") },
    Range { from: '𝚅', to: '𝚅', mapping: Mapped("v") },
    Range { from: '𝚆', to: '𝚆', mapping: Mapped("w") },
    Range { from: '𝚇', to: '𝚇', mapping: Mapped("x") },
    Range { from: '𝚈', to: '𝚈', mapping: Mapped("y") },
    Range { from: '𝚉', to: '𝚉', mapping: Mapped("z") },
    Range { from: '𝚊', to: '𝚊', mapping: Mapped("a") },
    Range { from: '𝚋', to: '𝚋', mapping: Mapped("b") },
    Range { from: '𝚌', to: '𝚌', mapping: Mapped("c") },
    Range { from: '𝚍', to: '𝚍', mapping: Mapped("d") },
    Range { from: '𝚎', to: '𝚎', mapping: Mapped("e") },
    Range { from: '𝚏', to: '𝚏', mapping: Mapped("f") },
    Range { from: '𝚐', to: '𝚐', mapping: Mapped("g") },
    Range { from: '𝚑', to: '𝚑', mapping: Mapped("h") },
    Range { from: '𝚒', to: '𝚒', mapping: Mapped("i") },
    Range { from: '𝚓', to: '𝚓', mapping: Mapped("j") },
    Range { from: '𝚔', to: '𝚔', mapping: Mapped("k") },
    Range { from: '𝚕', to: '𝚕', mapping: Mapped("l") },
    Range { from: '𝚖', to: '𝚖', mapping: Mapped("m") },
    Range { from: '𝚗', to: '𝚗', mapping: Mapped("n") },
    Range { from: '𝚘', to: '𝚘', mapping: Mapped("o") },
    Range { from: '𝚙', to: '𝚙', mapping: Mapped("p") },
    Range { from: '𝚚', to: '𝚚', mapping: Mapped("q") },
    Range { from: '𝚛', to: '𝚛', mapping: Mapped("r") },
    Range { from: '𝚜', to: '𝚜', mapping: Mapped("s") },
    Range { from: '𝚝', to: '𝚝', mapping: Mapped("t") },
    Range { from: '𝚞', to: '𝚞', mapping: Mapped("u") },
    Range { from: '𝚟', to: '𝚟', mapping: Mapped("v") },
    Range { from: '𝚠', to: '𝚠', mapping: Mapped("w") },
    Range { from: '𝚡', to: '𝚡', mapping: Mapped("x") },
    Range { from: '𝚢', to: '𝚢', mapping: Mapped("y") },
    Range { from: '𝚣', to: '𝚣', mapping: Mapped("z") },
    Range { from: '𝚤', to: '𝚤', mapping: Mapped("ı") },
    Range { from: '𝚥', to: '𝚥', mapping: Mapped("ȷ") },
    Range { from: '𝚦', to: '𝚧', mapping: Disallowed },
    Range { from: '𝚨', to: '𝚨', mapping: Mapped("α") },
    Range { from: '𝚩', to: '𝚩', mapping: Mapped("β") },
    Range { from: '𝚪', to: '𝚪', mapping: Mapped("γ") },
    Range { from: '𝚫', to: '𝚫', mapping: Mapped("δ") },
    Range { from: '𝚬', to: '𝚬', mapping: Mapped("ε") },
    Range { from: '𝚭', to: '𝚭', mapping: Mapped("ζ") },
    Range { from: '𝚮', to: '𝚮', mapping: Mapped("η") },
    Range { from: '𝚯', to: '𝚯', mapping: Mapped("θ") },
    Range { from: '𝚰', to: '𝚰', mapping: Mapped("ι") },
    Range { from: '𝚱', to: '𝚱', mapping: Mapped("κ") },
    Range { from: '𝚲', to: '𝚲', mapping: Mapped("λ") },
    Range { from: '𝚳', to: '𝚳', mapping: Mapped("μ") },
    Range { from: '𝚴', to: '𝚴', mapping: Mapped("ν") },
    Range { from: '𝚵', to: '𝚵', mapping: Mapped("ξ") },
    Range { from: '𝚶', to: '𝚶', mapping: Mapped("ο") },
    Range { from: '𝚷', to: '𝚷', mapping: Mapped("π") },
    Range { from: '𝚸', to: '𝚸', mapping: Mapped("ρ") },
    Range { from: '𝚹', to: '𝚹', mapping: Mapped("θ") },
    Range { from: '𝚺', to: '𝚺', mapping: Mapped("σ") },
    Range { from: '𝚻', to: '𝚻', mapping: Mapped("τ") },
    Range { from: '𝚼', to: '𝚼', mapping: Mapped("υ") },
    Range { from: '𝚽', to: '𝚽', mapping: Mapped("φ") },
    Range { from: '𝚾', to: '𝚾', mapping: Mapped("χ") },
    Range { from: '𝚿', to: '𝚿', mapping: Mapped("ψ") },
    Range { from: '𝛀', to: '𝛀', mapping: Mapped("ω") },
    Range { from: '𝛁', to: '𝛁', mapping: Mapped("∇") },
    Range { from: '𝛂', to: '𝛂', mapping: Mapped("α") },
    Range { from: '𝛃', to: '𝛃', mapping: Mapped("β") },
    Range { from: '𝛄', to: '𝛄', mapping: Mapped("γ") },
    Range { from: '𝛅', to: '𝛅', mapping: Mapped("δ") },
    Range { from: '𝛆', to: '𝛆', mapping: Mapped("ε") },
    Range { from: '𝛇', to: '𝛇', mapping: Mapped("ζ") },
    Range { from: '𝛈', to: '𝛈', mapping: Mapped("η") },
    Range { from: '𝛉', to: '𝛉', mapping: Mapped("θ") },
    Range { from: '𝛊', to: '𝛊', mapping: Mapped("ι") },
    Range { from: '𝛋', to: '𝛋', mapping: Mapped("κ") },
    Range { from: '𝛌', to: '𝛌', mapping: Mapped("λ") },
    Range { from: '𝛍', to: '𝛍', mapping: Mapped("μ") },
    Range { from: '𝛎', to: '𝛎', mapping: Mapped("ν") },
    Range { from: '𝛏', to: '𝛏', mapping: Mapped("ξ") },
    Range { from: '𝛐', to: '𝛐', mapping: Mapped("ο") },
    Range { from: '𝛑', to: '𝛑', mapping: Mapped("π") },
    Range { from: '𝛒', to: '𝛒', mapping: Mapped("ρ") },
    Range { from: '𝛓', to: '𝛔', mapping: Mapped("σ") },
    Range { from: '𝛕', to: '𝛕', mapping: Mapped("τ") },
    Range { from: '𝛖', to: '𝛖', mapping: Mapped("υ") },
    Range { from: '𝛗', to: '𝛗', mapping: Mapped("φ") },
    Range { from: '𝛘', to: '𝛘', mapping: Mapped("χ") },
    Range { from: '𝛙', to: '𝛙', mapping: Mapped("ψ") },
    Range { from: '𝛚', to: '𝛚', mapping: Mapped("ω") },
    Range { from: '𝛛', to: '𝛛', mapping: Mapped("∂") },
    Range { from: '𝛜', to: '𝛜', mapping: Mapped("ε") },
    Range { from: '𝛝', to: '𝛝', mapping: Mapped("θ") },
    Range { from: '𝛞', to: '𝛞', mapping: Mapped("κ") },
    Range { from: '𝛟', to: '𝛟', mapping: Mapped("φ") },
    Range { from: '𝛠', to: '𝛠', mapping: Mapped("ρ") },
    Range { from: '𝛡', to: '𝛡', mapping: Mapped("π") },
    Range { from: '𝛢', to: '𝛢', mapping: Mapped("α") },
    Range { from: '𝛣', to: '𝛣', mapping: Mapped("β") },
    Range { from: '𝛤', to: '𝛤', mapping: Mapped("γ") },
    Range { from: '𝛥', to: '𝛥', mapping: Mapped("δ") },
    Range { from: '𝛦', to: '𝛦', mapping: Mapped("ε") },
    Range { from: '𝛧', to: '𝛧', mapping: Mapped("ζ") },
    Range { from: '𝛨', to: '𝛨', mapping: Mapped("η") },
    Range { from: '𝛩', to: '𝛩', mapping: Mapped("θ") },
    Range { from: '𝛪', to: '𝛪', mapping: Mapped("ι") },
    Range { from: '𝛫', to: '𝛫', mapping: Mapped("κ") },
    Range { from: '𝛬', to: '𝛬', mapping: Mapped("λ") },
    Range { from: '𝛭', to: '𝛭', mapping: Mapped("μ") },
    Range { from: '𝛮', to: '𝛮', mapping: Mapped("ν") },
    Range { from: '𝛯', to: '𝛯', mapping: Mapped("ξ") },
    Range { from: '𝛰', to: '𝛰', mapping: Mapped("ο") },
    Range { from: '𝛱', to: '𝛱', mapping: Mapped("π") },
    Range { from: '𝛲', to: '𝛲', mapping: Mapped("ρ") },
    Range { from: '𝛳', to: '𝛳', mapping: Mapped("θ") },
    Range { from: '𝛴', to: '𝛴', mapping: Mapped("σ") },
    Range { from: '𝛵', to: '𝛵', mapping: Mapped("τ") },
    Range { from: '𝛶', to: '𝛶', mapping: Mapped("υ") },
    Range { from: '𝛷', to: '𝛷', mapping: Mapped("φ") },
    Range { from: '𝛸', to: '𝛸', mapping: Mapped("χ") },
    Range { from: '𝛹', to: '𝛹', mapping: Mapped("ψ") },
    Range { from: '𝛺', to: '𝛺', mapping: Mapped("ω") },
    Range { from: '𝛻', to: '𝛻', mapping: Mapped("∇") },
    Range { from: '𝛼', to: '𝛼', mapping: Mapped("α") },
    Range { from: '𝛽', to: '𝛽', mapping: Mapped("β") },
    Range { from: '𝛾', to: '𝛾', mapping: Mapped("γ") },
    Range { from: '𝛿', to: '𝛿', mapping: Mapped("δ") },
    Range { from: '𝜀', to: '𝜀', mapping: Mapped("ε") },
    Range { from: '𝜁', to: '𝜁', mapping: Mapped("ζ") },
    Range { from: '𝜂', to: '𝜂', mapping: Mapped("η") },
    Range { from: '𝜃', to: '𝜃', mapping: Mapped("θ") },
    Range { from: '𝜄', to: '𝜄', mapping: Mapped("ι") },
    Range { from: '𝜅', to: '𝜅', mapping: Mapped("κ") },
    Range { from: '𝜆', to: '𝜆', mapping: Mapped("λ") },
    Range { from: '𝜇', to: '𝜇', mapping: Mapped("μ") },
    Range { from: '𝜈', to: '𝜈', mapping: Mapped("ν") },
    Range { from: '𝜉', to: '𝜉', mapping: Mapped("ξ") },
    Range { from: '𝜊', to: '𝜊', mapping: Mapped("ο") },
    Range { from: '𝜋', to: '𝜋', mapping: Mapped("π") },
    Range { from: '𝜌', to: '𝜌', mapping: Mapped("ρ") },
    Range { from: '𝜍', to: '𝜎', mapping: Mapped("σ") },
    Range { from: '𝜏', to: '𝜏', mapping: Mapped("τ") },
    Range { from: '𝜐', to: '𝜐', mapping: Mapped("υ") },
    Range { from: '𝜑', to: '𝜑', mapping: Mapped("φ") },
    Range { from: '𝜒', to: '𝜒', mapping: Mapped("χ") },
    Range { from: '𝜓', to: '𝜓', mapping: Mapped("ψ") },
    Range { from: '𝜔', to: '𝜔', mapping: Mapped("ω") },
    Range { from: '𝜕', to: '𝜕', mapping: Mapped("∂") },
    Range { from: '𝜖', to: '𝜖', mapping: Mapped("ε") },
    Range { from: '𝜗', to: '𝜗', mapping: Mapped("θ") },
    Range { from: '𝜘', to: '𝜘', mapping: Mapped("κ") },
    Range { from: '𝜙', to: '𝜙', mapping: Mapped("φ") },
    Range { from: '𝜚', to: '𝜚', mapping: Mapped("ρ") },
    Range { from: '𝜛', to: '𝜛', mapping: Mapped("π") },
    Range { from: '𝜜', to: '𝜜', mapping: Mapped("α") },
    Range { from: '𝜝', to: '𝜝', mapping: Mapped("β") },
    Range { from: '𝜞', to: '𝜞', mapping: Mapped("γ") },
    Range { from: '𝜟', to: '𝜟', mapping: Mapped("δ") },
    Range { from: '𝜠', to: '𝜠', mapping: Mapped("ε") },
    Range { from: '𝜡', to: '𝜡', mapping: Mapped("ζ") },
    Range { from: '𝜢', to: '𝜢', mapping: Mapped("η") },
    Range { from: '𝜣', to: '𝜣', mapping: Mapped("θ") },
    Range { from: '𝜤', to: '𝜤', mapping: Mapped("ι") },
    Range { from: '𝜥', to: '𝜥', mapping: Mapped("κ") },
    Range { from: '𝜦', to: '𝜦', mapping: Mapped("λ") },
    Range { from: '𝜧', to: '𝜧', mapping: Mapped("μ") },
    Range { from: '𝜨', to: '𝜨', mapping: Mapped("ν") },
    Range { from: '𝜩', to: '𝜩', mapping: Mapped("ξ") },
    Range { from: '𝜪', to: '𝜪', mapping: Mapped("ο") },
    Range { from: '𝜫', to: '𝜫', mapping: Mapped("π") },
    Range { from: '𝜬', to: '𝜬', mapping: Mapped("ρ") },
    Range { from: '𝜭', to: '𝜭', mapping: Mapped("θ") },
    Range { from: '𝜮', to: '𝜮', mapping: Mapped("σ") },
    Range { from: '𝜯', to: '𝜯', mapping: Mapped("τ") },
    Range { from: '𝜰', to: '𝜰', mapping: Mapped("υ") },
    Range { from: '𝜱', to: '𝜱', mapping: Mapped("φ") },
    Range { from: '𝜲', to: '𝜲', mapping: Mapped("χ") },
    Range { from: '𝜳', to: '𝜳', mapping: Mapped("ψ") },
    Range { from: '𝜴', to: '𝜴', mapping: Mapped("ω") },
    Range { from: '𝜵', to: '𝜵', mapping: Mapped("∇") },
    Range { from: '𝜶', to: '𝜶', mapping: Mapped("α") },
    Range { from: '𝜷', to: '𝜷', mapping: Mapped("β") },
    Range { from: '𝜸', to: '𝜸', mapping: Mapped("γ") },
    Range { from: '𝜹', to: '𝜹', mapping: Mapped("δ") },
    Range { from: '𝜺', to: '𝜺', mapping: Mapped("ε") },
    Range { from: '𝜻', to: '𝜻', mapping: Mapped("ζ") },
    Range { from: '𝜼', to: '𝜼', mapping: Mapped("η") },
    Range { from: '𝜽', to: '𝜽', mapping: Mapped("θ") },
    Range { from: '𝜾', to: '𝜾', mapping: Mapped("ι") },
    Range { from: '𝜿', to: '𝜿', mapping: Mapped("κ") },
    Range { from: '𝝀', to: '𝝀', mapping: Mapped("λ") },
    Range { from: '𝝁', to: '𝝁', mapping: Mapped("μ") },
    Range { from: '𝝂', to: '𝝂', mapping: Mapped("ν") },
    Range { from: '𝝃', to: '𝝃', mapping: Mapped("ξ") },
    Range { from: '𝝄', to: '𝝄', mapping: Mapped("ο") },
    Range { from: '𝝅', to: '𝝅', mapping: Mapped("π") },
    Range { from: '𝝆', to: '𝝆', mapping: Mapped("ρ") },
    Range { from: '𝝇', to: '𝝈', mapping: Mapped("σ") },
    Range { from: '𝝉', to: '𝝉', mapping: Mapped("τ") },
    Range { from: '𝝊', to: '𝝊', mapping: Mapped("υ") },
    Range { from: '𝝋', to: '𝝋', mapping: Mapped("φ") },
    Range { from: '𝝌', to: '𝝌', mapping: Mapped("χ") },
    Range { from: '𝝍', to: '𝝍', mapping: Mapped("ψ") },
    Range { from: '𝝎', to: '𝝎', mapping: Mapped("ω") },
    Range { from: '𝝏', to: '𝝏', mapping: Mapped("∂") },
    Range { from: '𝝐', to: '𝝐', mapping: Mapped("ε") },
    Range { from: '𝝑', to: '𝝑', mapping: Mapped("θ") },
    Range { from: '𝝒', to: '𝝒', mapping: Mapped("κ") },
    Range { from: '𝝓', to: '𝝓', mapping: Mapped("φ") },
    Range { from: '𝝔', to: '𝝔', mapping: Mapped("ρ") },
    Range { from: '𝝕', to: '𝝕', mapping: Mapped("π") },
    Range { from: '𝝖', to: '𝝖', mapping: Mapped("α") },
    Range { from: '𝝗', to: '𝝗', mapping: Mapped("β") },
    Range { from: '𝝘', to: '𝝘', mapping: Mapped("γ") },
    Range { from: '𝝙', to: '𝝙', mapping: Mapped("δ") },
    Range { from: '𝝚', to: '𝝚', mapping: Mapped("ε") },
    Range { from: '𝝛', to: '𝝛', mapping: Mapped("ζ") },
    Range { from: '𝝜', to: '𝝜', mapping: Mapped("η") },
    Range { from: '𝝝', to: '𝝝', mapping: Mapped("θ") },
    Range { from: '𝝞', to: '𝝞', mapping: Mapped("ι") },
    Range { from: '𝝟', to: '𝝟', mapping: Mapped("κ") },
    Range { from: '𝝠', to: '𝝠', mapping: Mapped("λ") },
    Range { from: '𝝡', to: '𝝡', mapping: Mapped("μ") },
    Range { from: '𝝢', to: '𝝢', mapping: Mapped("ν") },
    Range { from: '𝝣', to: '𝝣', mapping: Mapped("ξ") },
    Range { from: '𝝤', to: '𝝤', mapping: Mapped("ο") },
    Range { from: '𝝥', to: '𝝥', mapping: Mapped("π") },
    Range { from: '𝝦', to: '𝝦', mapping: Mapped("ρ") },
    Range { from: '𝝧', to: '𝝧', mapping: Mapped("θ") },
    Range { from: '𝝨', to: '𝝨', mapping: Mapped("σ") },
    Range { from: '𝝩', to: '𝝩', mapping: Mapped("τ") },
    Range { from: '𝝪', to: '𝝪', mapping: Mapped("υ") },
    Range { from: '𝝫', to: '𝝫', mapping: Mapped("φ") },
    Range { from: '𝝬', to: '𝝬', mapping: Mapped("χ") },
    Range { from: '𝝭', to: '𝝭', mapping: Mapped("ψ") },
    Range { from: '𝝮', to: '𝝮', mapping: Mapped("ω") },
    Range { from: '𝝯', to: '𝝯', mapping: Mapped("∇") },
    Range { from: '𝝰', to: '𝝰', mapping: Mapped("α") },
    Range { from: '𝝱', to: '𝝱', mapping: Mapped("β") },
    Range { from: '𝝲', to: '𝝲', mapping: Mapped("γ") },
    Range { from: '𝝳', to: '𝝳', mapping: Mapped("δ") },
    Range { from: '𝝴', to: '𝝴', mapping: Mapped("ε") },
    Range { from: '𝝵', to: '𝝵', mapping: Mapped("ζ") },
    Range { from: '𝝶', to: '𝝶', mapping: Mapped("η") },
    Range { from: '𝝷', to: '𝝷', mapping: Mapped("θ") },
    Range { from: '𝝸', to: '𝝸', mapping: Mapped("ι") },
    Range { from: '𝝹', to: '𝝹', mapping: Mapped("κ") },
    Range { from: '𝝺', to: '𝝺', mapping: Mapped("λ") },
    Range { from: '𝝻', to: '𝝻', mapping: Mapped("μ") },
    Range { from: '𝝼', to: '𝝼', mapping: Mapped("ν") },
    Range { from: '𝝽', to: '𝝽', mapping: Mapped("ξ") },
    Range { from: '𝝾', to: '𝝾', mapping: Mapped("ο") },
    Range { from: '𝝿', to: '𝝿', mapping: Mapped("π") },
    Range { from: '𝞀', to: '𝞀', mapping: Mapped("ρ") },
    Range { from: '𝞁', to: '𝞂', mapping: Mapped("σ") },
    Range { from: '𝞃', to: '𝞃', mapping: Mapped("τ") },
    Range { from: '𝞄', to: '𝞄', mapping: Mapped("υ") },
    Range { from: '𝞅', to: '𝞅', mapping: Mapped("φ") },
    Range { from: '𝞆', to: '𝞆', mapping: Mapped("χ") },
    Range { from: '𝞇', to: '𝞇', mapping: Mapped("ψ") },
    Range { from: '𝞈', to: '𝞈', mapping: Mapped("ω") },
    Range { from: '𝞉', to: '𝞉', mapping: Mapped("∂") },
    Range { from: '𝞊', to: '𝞊', mapping: Mapped("ε") },
    Range { from: '𝞋', to: '𝞋', mapping: Mapped("θ") },
    Range { from: '𝞌', to: '𝞌', mapping: Mapped("κ") },
    Range { from: '𝞍', to: '𝞍', mapping: Mapped("φ") },
    Range { from: '𝞎', to: '𝞎', mapping: Mapped("ρ") },
    Range { from: '𝞏', to: '𝞏', mapping: Mapped("π") },
    Range { from: '𝞐', to: '𝞐', mapping: Mapped("α") },
    Range { from: '𝞑', to: '𝞑', mapping: Mapped("β") },
    Range { from: '𝞒', to: '𝞒', mapping: Mapped("γ") },
    Range { from: '𝞓', to: '𝞓', mapping: Mapped("δ") },
    Range { from: '𝞔', to: '𝞔', mapping: Mapped("ε") },
    Range { from: '𝞕', to: '𝞕', mapping: Mapped("ζ") },
    Range { from: '𝞖', to: '𝞖', mapping: Mapped("η") },
    Range { from: '𝞗', to: '𝞗', mapping: Mapped("θ") },
    Range { from: '𝞘', to: '𝞘', mapping: Mapped("ι") },
    Range { from: '𝞙', to: '𝞙', mapping: Mapped("κ") },
    Range { from: '𝞚', to: '𝞚', mapping: Mapped("λ") },
    Range { from: '𝞛', to: '𝞛', mapping: Mapped("μ") },
    Range { from: '𝞜', to: '𝞜', mapping: Mapped("ν") },
    Range { from: '𝞝', to: '𝞝', mapping: Mapped("ξ") },
    Range { from: '𝞞', to: '𝞞', mapping: Mapped("ο") },
    Range { from: '𝞟', to: '𝞟', mapping: Mapped("π") },
    Range { from: '𝞠', to: '𝞠', mapping: Mapped("ρ") },
    Range { from: '𝞡', to: '𝞡', mapping: Mapped("θ") },
    Range { from: '𝞢', to: '𝞢', mapping: Mapped("σ") },
    Range { from: '𝞣', to: '𝞣', mapping: Mapped("τ") },
    Range { from: '𝞤', to: '𝞤', mapping: Mapped("υ") },
    Range { from: '𝞥', to: '𝞥', mapping: Mapped("φ") },
    Range { from: '𝞦', to: '𝞦', mapping: Mapped("χ") },
    Range { from: '𝞧', to: '𝞧', mapping: Mapped("ψ") },
    Range { from: '𝞨', to: '𝞨', mapping: Mapped("ω") },
    Range { from: '𝞩', to: '𝞩', mapping: Mapped("∇") },
    Range { from: '𝞪', to: '𝞪', mapping: Mapped("α") },
    Range { from: '𝞫', to: '𝞫', mapping: Mapped("β") },
    Range { from: '𝞬', to: '𝞬', mapping: Mapped("γ") },
    Range { from: '𝞭', to: '𝞭', mapping: Mapped("δ") },
    Range { from: '𝞮', to: '𝞮', mapping: Mapped("ε") },
    Range { from: '𝞯', to: '𝞯', mapping: Mapped("ζ") },
    Range { from: '𝞰', to: '𝞰', mapping: Mapped("η") },
    Range { from: '𝞱', to: '𝞱', mapping: Mapped("θ") },
    Range { from: '𝞲', to: '𝞲', mapping: Mapped("ι") },
    Range { from: '𝞳', to: '𝞳', mapping: Mapped("κ") },
    Range { from: '𝞴', to: '𝞴', mapping: Mapped("λ") },
    Range { from: '𝞵', to: '𝞵', mapping: Mapped("μ") },
    Range { from: '𝞶', to: '𝞶', mapping: Mapped("ν") },
    Range { from: '𝞷', to: '𝞷', mapping: Mapped("ξ") },
    Range { from: '𝞸', to: '𝞸', mapping: Mapped("ο") },
    Range { from: '𝞹', to: '𝞹', mapping: Mapped("π") },
    Range { from: '𝞺', to: '𝞺', mapping: Mapped("ρ") },
    Range { from: '𝞻', to: '𝞼', mapping: Mapped("σ") },
    Range { from: '𝞽', to: '𝞽', mapping: Mapped("τ") },
    Range { from: '𝞾', to: '𝞾', mapping: Mapped("υ") },
    Range { from: '𝞿', to: '𝞿', mapping: Mapped("φ") },
    Range { from: '𝟀', to: '𝟀', mapping: Mapped("χ") },
    Range { from: '𝟁', to: '𝟁', mapping: Mapped("ψ") },
    Range { from: '𝟂', to: '𝟂', mapping: Mapped("ω") },
    Range { from: '𝟃', to: '𝟃', mapping: Mapped("∂") },
    Range { from: '𝟄', to: '𝟄', mapping: Mapped("ε") },
    Range { from: '𝟅', to: '𝟅', mapping: Mapped("θ") },
    Range { from: '𝟆', to: '𝟆', mapping: Mapped("κ") },
    Range { from: '𝟇', to: '𝟇', mapping: Mapped("φ") },
    Range { from: '𝟈', to: '𝟈', mapping: Mapped("ρ") },
    Range { from: '𝟉', to: '𝟉', mapping: Mapped("π") },
    Range { from: '𝟊', to: '𝟋', mapping: Mapped("ϝ") },
    Range { from: '𝟌', to: '𝟍', mapping: Disallowed },
    Range { from: '𝟎', to: '𝟎', mapping: Mapped("0") },
    Range { from: '𝟏', to: '𝟏', mapping: Mapped("1") },
    Range { from: '𝟐', to: '𝟐', mapping: Mapped("2") },
    Range { from: '𝟑', to: '𝟑', mapping: Mapped("3") },
    Range { from: '𝟒', to: '𝟒', mapping: Mapped("4") },
    Range { from: '𝟓', to: '𝟓', mapping: Mapped("5") },
    Range { from: '𝟔', to: '𝟔', mapping: Mapped("6") },
    Range { from: '𝟕', to: '𝟕', mapping: Mapped("7") },
    Range { from: '𝟖', to: '𝟖', mapping: Mapped("8") },
    Range { from: '𝟗', to: '𝟗', mapping: Mapped("9") },
    Range { from: '𝟘', to: '𝟘', mapping: Mapped("0") },
    Range { from: '𝟙', to: '𝟙', mapping: Mapped("1") },
    Range { from: '𝟚', to: '𝟚', mapping: Mapped("2") },
    Range { from: '𝟛', to: '𝟛', mapping: Mapped("3") },
    Range { from: '𝟜', to: '𝟜', mapping: Mapped("4") },
    Range { from: '𝟝', to: '𝟝', mapping: Mapped("5") },
    Range { from: '𝟞', to: '𝟞', mapping: Mapped("6") },
    Range { from: '𝟟', to: '𝟟', mapping: Mapped("7") },
    Range { from: '𝟠', to: '𝟠', mapping: Mapped("8") },
    Range { from: '𝟡', to: '𝟡', mapping: Mapped("9") },
    Range { from: '𝟢', to: '𝟢', mapping: Mapped("0") },
    Range { from: '𝟣', to: '𝟣', mapping: Mapped("1") },
    Range { from: '𝟤', to: '𝟤', mapping: Mapped("2") },
    Range { from: '𝟥', to: '𝟥', mapping: Mapped("3") },
    Range { from: '𝟦', to: '𝟦', mapping: Mapped("4") },
    Range { from: '𝟧', to: '𝟧', mapping: Mapped("5") },
    Range { from: '𝟨', to: '𝟨', mapping: Mapped("6") },
    Range { from: '𝟩', to: '𝟩', mapping: Mapped("7") },
    Range { from: '𝟪', to: '𝟪', mapping: Mapped("8") },
    Range { from: '𝟫', to: '𝟫', mapping: Mapped("9") },
    Range { from: '𝟬', to: '𝟬', mapping: Mapped("0") },
    Range { from: '𝟭', to: '𝟭', mapping: Mapped("1") },
    Range { from: '𝟮', to: '𝟮', mapping: Mapped("2") },
    Range { from: '𝟯', to: '𝟯', mapping: Mapped("3") },
    Range { from: '𝟰', to: '𝟰', mapping: Mapped("4") },
    Range { from: '𝟱', to: '𝟱', mapping: Mapped("5") },
    Range { from: '𝟲', to: '𝟲', mapping: Mapped("6") },
    Range { from: '𝟳', to: '𝟳', mapping: Mapped("7") },
    Range { from: '𝟴', to: '𝟴', mapping: Mapped("8") },
    Range { from: '𝟵', to: '𝟵', mapping: Mapped("9") },
    Range { from: '𝟶', to: '𝟶', mapping: Mapped("0") },
    Range { from: '𝟷', to: '𝟷', mapping: Mapped("1") },
    Range { from: '𝟸', to: '𝟸', mapping: Mapped("2") },
    Range { from: '𝟹', to: '𝟹', mapping: Mapped("3") },
    Range { from: '𝟺', to: '𝟺', mapping: Mapped("4") },
    Range { from: '𝟻', to: '𝟻', mapping: Mapped("5") },
    Range { from: '𝟼', to: '𝟼', mapping: Mapped("6") },
    Range { from: '𝟽', to: '𝟽', mapping: Mapped("7") },
    Range { from: '𝟾', to: '𝟾', mapping: Mapped("8") },
    Range { from: '𝟿', to: '𝟿', mapping: Mapped("9") },
    Range { from: '𝠀', to: '𝧿', mapping: Valid },
    Range { from: '𝨀', to: '𝨶', mapping: Valid },
    Range { from: '𝨷', to: '𝨺', mapping: Valid },
    Range { from: '𝨻', to: '𝩬', mapping: Valid },
    Range { from: '𝩭', to: '𝩴', mapping: Valid },
    Range { from: '𝩵', to: '𝩵', mapping: Valid },
    Range { from: '𝩶', to: '𝪃', mapping: Valid },
    Range { from: '𝪄', to: '𝪄', mapping: Valid },
    Range { from: '𝪅', to: '𝪋', mapping: Valid },
    Range { from: '𝪌', to: '𝪚', mapping: Disallowed },
    Range { from: '𝪛', to: '𝪟', mapping: Valid },
    Range { from: '𝪠', to: '𝪠', mapping: Disallowed },
    Range { from: '𝪡', to: '𝪯', mapping: Valid },
    Range { from: '𝪰', to: '𞟿', mapping: Disallowed },
    Range { from: '𞠀', to: '𞣄', mapping: Valid },
    Range { from: '𞣅', to: '𞣆', mapping: Disallowed },
    Range { from: '𞣇', to: '𞣏', mapping: Valid },
    Range { from: '𞣐', to: '𞣖', mapping: Valid },
    Range { from: '𞣗', to: '𞷿', mapping: Disallowed },
    Range { from: '𞸀', to: '𞸀', mapping: Mapped("ا") },
    Range { from: '𞸁', to: '𞸁', mapping: Mapped("ب") },
    Range { from: '𞸂', to: '𞸂', mapping: Mapped("ج") },
    Range { from: '𞸃', to: '𞸃', mapping: Mapped("د") },
    Range { from: '𞸄', to: '𞸄', mapping: Disallowed },
    Range { from: '𞸅', to: '𞸅', mapping: Mapped("و") },
    Range { from: '𞸆', to: '𞸆', mapping: Mapped("ز") },
    Range { from: '𞸇', to: '𞸇', mapping: Mapped("ح") },
    Range { from: '𞸈', to: '𞸈', mapping: Mapped("ط") },
    Range { from: '𞸉', to: '𞸉', mapping: Mapped("ي") },
    Range { from: '𞸊', to: '𞸊', mapping: Mapped("ك") },
    Range { from: '𞸋', to: '𞸋', mapping: Mapped("ل") },
    Range { from: '𞸌', to: '𞸌', mapping: Mapped("م") },
    Range { from: '𞸍', to: '𞸍', mapping: Mapped("ن") },
    Range { from: '𞸎', to: '𞸎', mapping: Mapped("س") },
    Range { from: '𞸏', to: '𞸏', mapping: Mapped("ع") },
    Range { from: '𞸐', to: '𞸐', mapping: Mapped("ف") },
    Range { from: '𞸑', to: '𞸑', mapping: Mapped("ص") },
    Range { from: '𞸒', to: '𞸒', mapping: Mapped("ق") },
    Range { from: '𞸓', to: '𞸓', mapping: Mapped("ر") },
    Range { from: '𞸔', to: '𞸔', mapping: Mapped("ش") },
    Range { from: '𞸕', to: '𞸕', mapping: Mapped("ت") },
    Range { from: '𞸖', to: '𞸖', mapping: Mapped("ث") },
    Range { from: '𞸗', to: '𞸗', mapping: Mapped("خ") },
    Range { from: '𞸘', to: '𞸘', mapping: Mapped("ذ") },
    Range { from: '𞸙', to: '𞸙', mapping: Mapped("ض") },
    Range { from: '𞸚', to: '𞸚', mapping: Mapped("ظ") },
    Range { from: '𞸛', to: '𞸛', mapping: Mapped("غ") },
    Range { from: '𞸜', to: '𞸜', mapping: Mapped("ٮ") },
    Range { from: '𞸝', to: '𞸝', mapping: Mapped("ں") },
    Range { from: '𞸞', to: '𞸞', mapping: Mapped("ڡ") },
    Range { from: '𞸟', to: '𞸟', mapping: Mapped("ٯ") },
    Range { from: '𞸠', to: '𞸠', mapping: Disallowed },
    Range { from: '𞸡', to: '𞸡', mapping: Mapped("ب") },
    Range { from: '𞸢', to: '𞸢', mapping: Mapped("ج") },
    Range { from: '𞸣', to: '𞸣', mapping: Disallowed },
    Range { from: '𞸤', to: '𞸤', mapping: Mapped("ه") },
    Range { from: '𞸥', to: '𞸦', mapping: Disallowed },
    Range { from: '𞸧', to: '𞸧', mapping: Mapped("ح") },
    Range { from: '𞸨', to: '𞸨', mapping: Disallowed },
    Range { from: '𞸩', to: '𞸩', mapping: Mapped("ي") },
    Range { from: '𞸪', to: '𞸪', mapping: Mapped("ك") },
    Range { from: '𞸫', to: '𞸫', mapping: Mapped("ل") },
    Range { from: '𞸬', to: '𞸬', mapping: Mapped("م") },
    Range { from: '𞸭', to: '𞸭', mapping: Mapped("ن") },
    Range { from: '𞸮', to: '𞸮', mapping: Mapped("س") },
    Range { from: '𞸯', to: '𞸯', mapping: Mapped("ع") },
    Range { from: '𞸰', to: '𞸰', mapping: Mapped("ف") },
    Range { from: '𞸱', to: '𞸱', mapping: Mapped("ص") },
    Range { from: '𞸲', to: '𞸲', mapping: Mapped("ق") },
    Range { from: '𞸳', to: '𞸳', mapping: Disallowed },
    Range { from: '𞸴', to: '𞸴', mapping: Mapped("ش") },
    Range { from: '𞸵', to: '𞸵', mapping: Mapped("ت") },
    Range { from: '𞸶', to: '𞸶', mapping: Mapped("ث") },
    Range { from: '𞸷', to: '𞸷', mapping: Mapped("خ") },
    Range { from: '𞸸', to: '𞸸', mapping: Disallowed },
    Range { from: '𞸹', to: '𞸹', mapping: Mapped("ض") },
    Range { from: '𞸺', to: '𞸺', mapping: Disallowed },
    Range { from: '𞸻', to: '𞸻', mapping: Mapped("غ") },
    Range { from: '𞸼', to: '𞹁', mapping: Disallowed },
    Range { from: '𞹂', to: '𞹂', mapping: Mapped("ج") },
    Range { from: '𞹃', to: '𞹆', mapping: Disallowed },
    Range { from: '𞹇', to: '𞹇', mapping: Mapped("ح") },
    Range { from: '𞹈', to: '𞹈', mapping: Disallowed },
    Range { from: '𞹉', to: '𞹉', mapping: Mapped("ي") },
    Range { from: '𞹊', to: '𞹊', mapping: Disallowed },
    Range { from: '𞹋', to: '𞹋', mapping: Mapped("ل") },
    Range { from: '𞹌', to: '𞹌', mapping: Disallowed },
    Range { from: '𞹍', to: '𞹍', mapping: Mapped("ن") },
    Range { from: '𞹎', to: '𞹎', mapping: Mapped("س") },
    Range { from: '𞹏', to: '𞹏', mapping: Mapped("ع") },
    Range { from: '𞹐', to: '𞹐', mapping: Disallowed },
    Range { from: '𞹑', to: '𞹑', mapping: Mapped("ص") },
    Range { from: '𞹒', to: '𞹒', mapping: Mapped("ق") },
    Range { from: '𞹓', to: '𞹓', mapping: Disallowed },
    Range { from: '𞹔', to: '𞹔', mapping: Mapped("ش") },
    Range { from: '𞹕', to: '𞹖', mapping: Disallowed },
    Range { from: '𞹗', to: '𞹗', mapping: Mapped("خ") },
    Range { from: '𞹘', to: '𞹘', mapping: Disallowed },
    Range { from: '𞹙', to: '𞹙', mapping: Mapped("ض") },
    Range { from: '𞹚', to: '𞹚', mapping: Disallowed },
    Range { from: '𞹛', to: '𞹛', mapping: Mapped("غ") },
    Range { from: '𞹜', to: '𞹜', mapping: Disallowed },
    Range { from: '𞹝', to: '𞹝', mapping: Mapped("ں") },
    Range { from: '𞹞', to: '𞹞', mapping: Disallowed },
    Range { from: '𞹟', to: '𞹟', mapping: Mapped("ٯ") },
    Range { from: '𞹠', to: '𞹠', mapping: Disallowed },
    Range { from: '𞹡', to: '𞹡', mapping: Mapped("ب") },
    Range { from: '𞹢', to: '𞹢', mapping: Mapped("ج") },
    Range { from: '𞹣', to: '𞹣', mapping: Disallowed },
    Range { from: '𞹤', to: '𞹤', mapping: Mapped("ه") },
    Range { from: '𞹥', to: '𞹦', mapping: Disallowed },
    Range { from: '𞹧', to: '𞹧', mapping: Mapped("ح") },
    Range { from: '𞹨', to: '𞹨', mapping: Mapped("ط") },
    Range { from: '𞹩', to: '𞹩', mapping: Mapped("ي") },
    Range { from: '𞹪', to: '𞹪', mapping: Mapped("ك") },
    Range { from: '𞹫', to: '𞹫', mapping: Disallowed },
    Range { from: '𞹬', to: '𞹬', mapping: Mapped("م") },
    Range { from: '𞹭', to: '𞹭', mapping: Mapped("ن") },
    Range { from: '𞹮', to: '𞹮', mapping: Mapped("س") },
    Range { from: '𞹯', to: '𞹯', mapping: Mapped("ع") },
    Range { from: '𞹰', to: '𞹰', mapping: Mapped("ف") },
    Range { from: '𞹱', to: '𞹱', mapping: Mapped("ص") },
    Range { from: '𞹲', to: '𞹲', mapping: Mapped("ق") },
    Range { from: '𞹳', to: '𞹳', mapping: Disallowed },
    Range { from: '𞹴', to: '𞹴', mapping: Mapped("ش") },
    Range { from: '𞹵', to: '𞹵', mapping: Mapped("ت") },
    Range { from: '𞹶', to: '𞹶', mapping: Mapped("ث") },
    Range { from: '𞹷', to: '𞹷', mapping: Mapped("خ") },
    Range { from: '𞹸', to: '𞹸', mapping: Disallowed },
    Range { from: '𞹹', to: '𞹹', mapping: Mapped("ض") },
    Range { from: '𞹺', to: '𞹺', mapping: Mapped("ظ") },
    Range { from: '𞹻', to: '𞹻', mapping: Mapped("غ") },
    Range { from: '𞹼', to: '𞹼', mapping: Mapped("ٮ") },
    Range { from: '𞹽', to: '𞹽', mapping: Disallowed },
    Range { from: '𞹾', to: '𞹾', mapping: Mapped("ڡ") },
    Range { from: '𞹿', to: '𞹿', mapping: Disallowed },
    Range { from: '𞺀', to: '𞺀', mapping: Mapped("ا") },
    Range { from: '𞺁', to: '𞺁', mapping: Mapped("ب") },
    Range { from: '𞺂', to: '𞺂', mapping: Mapped("ج") },
    Range { from: '𞺃', to: '𞺃', mapping: Mapped("د") },
    Range { from: '𞺄', to: '𞺄', mapping: Mapped("ه") },
    Range { from: '𞺅', to: '𞺅', mapping: Mapped("و") },
    Range { from: '𞺆', to: '𞺆', mapping: Mapped("ز") },
    Range { from: '𞺇', to: '𞺇', mapping: Mapped("ح") },
    Range { from: '𞺈', to: '𞺈', mapping: Mapped("ط") },
    Range { from: '𞺉', to: '𞺉', mapping: Mapped("ي") },
    Range { from: '𞺊', to: '𞺊', mapping: Disallowed },
    Range { from: '𞺋', to: '𞺋', mapping: Mapped("ل") },
    Range { from: '𞺌', to: '𞺌', mapping: Mapped("م") },
    Range { from: '𞺍', to: '𞺍', mapping: Mapped("ن") },
    Range { from: '𞺎', to: '𞺎', mapping: Mapped("س") },
    Range { from: '𞺏', to: '𞺏', mapping: Mapped("ع") },
    Range { from: '𞺐', to: '𞺐', mapping: Mapped("ف") },
    Range { from: '𞺑', to: '𞺑', mapping: Mapped("ص") },
    Range { from: '𞺒', to: '𞺒', mapping: Mapped("ق") },
    Range { from: '𞺓', to: '𞺓', mapping: Mapped("ر") },
    Range { from: '𞺔', to: '𞺔', mapping: Mapped("ش") },
    Range { from: '𞺕', to: '𞺕', mapping: Mapped("ت") },
    Range { from: '𞺖', to: '𞺖', mapping: Mapped("ث") },
    Range { from: '𞺗', to: '𞺗', mapping: Mapped("خ") },
    Range { from: '𞺘', to: '𞺘', mapping: Mapped("ذ") },
    Range { from: '𞺙', to: '𞺙', mapping: Mapped("ض") },
    Range { from: '𞺚', to: '𞺚', mapping: Mapped("ظ") },
    Range { from: '𞺛', to: '𞺛', mapping: Mapped("غ") },
    Range { from: '𞺜', to: '𞺠', mapping: Disallowed },
    Range { from: '𞺡', to: '𞺡', mapping: Mapped("ب") },
    Range { from: '𞺢', to: '𞺢', mapping: Mapped("ج") },
    Range { from: '𞺣', to: '𞺣', mapping: Mapped("د") },
    Range { from: '𞺤', to: '𞺤', mapping: Disallowed },
    Range { from: '𞺥', to: '𞺥', mapping: Mapped("و") },
    Range { from: '𞺦', to: '𞺦', mapping: Mapped("ز") },
    Range { from: '𞺧', to: '𞺧', mapping: Mapped("ح") },
    Range { from: '𞺨', to: '𞺨', mapping: Mapped("ط") },
    Range { from: '𞺩', to: '𞺩', mapping: Mapped("ي") },
    Range { from: '𞺪', to: '𞺪', mapping: Disallowed },
    Range { from: '𞺫', to: '𞺫', mapping: Mapped("ل") },
    Range { from: '𞺬', to: '𞺬', mapping: Mapped("م") },
    Range { from: '𞺭', to: '𞺭', mapping: Mapped("ن") },
    Range { from: '𞺮', to: '𞺮', mapping: Mapped("س") },
    Range { from: '𞺯', to: '𞺯', mapping: Mapped("ع") },
    Range { from: '𞺰', to: '𞺰', mapping: Mapped("ف") },
    Range { from: '𞺱', to: '𞺱', mapping: Mapped("ص") },
    Range { from: '𞺲', to: '𞺲', mapping: Mapped("ق") },
    Range { from: '𞺳', to: '𞺳', mapping: Mapped("ر") },
    Range { from: '𞺴', to: '𞺴', mapping: Mapped("ش") },
    Range { from: '𞺵', to: '𞺵', mapping: Mapped("ت") },
    Range { from: '𞺶', to: '𞺶', mapping: Mapped("ث") },
    Range { from: '𞺷', to: '𞺷', mapping: Mapped("خ") },
    Range { from: '𞺸', to: '𞺸', mapping: Mapped("ذ") },
    Range { from: '𞺹', to: '𞺹', mapping: Mapped("ض") },
    Range { from: '𞺺', to: '𞺺', mapping: Mapped("ظ") },
    Range { from: '𞺻', to: '𞺻', mapping: Mapped("غ") },
    Range { from: '𞺼', to: '𞻯', mapping: Disallowed },
    Range { from: '𞻰', to: '𞻱', mapping: Valid },
    Range { from: '𞻲', to: '𞿿', mapping: Disallowed },
    Range { from: '🀀', to: '🀫', mapping: Valid },
    Range { from: '🀬', to: '🀯', mapping: Disallowed },
    Range { from: '🀰', to: '🂓', mapping: Valid },
    Range { from: '🂔', to: '🂟', mapping: Disallowed },
    Range { from: '🂠', to: '🂮', mapping: Valid },
    Range { from: '🂯', to: '🂰', mapping: Disallowed },
    Range { from: '🂱', to: '🂾', mapping: Valid },
    Range { from: '🂿', to: '🂿', mapping: Valid },
    Range { from: '🃀', to: '🃀', mapping: Disallowed },
    Range { from: '🃁', to: '🃏', mapping: Valid },
    Range { from: '🃐', to: '🃐', mapping: Disallowed },
    Range { from: '🃑', to: '🃟', mapping: Valid },
    Range { from: '🃠', to: '🃵', mapping: Valid },
    Range { from: '🃶', to: '🃿', mapping: Disallowed },
    Range { from: '🄀', to: '🄀', mapping: Disallowed },
    Range { from: '🄁', to: '🄁', mapping: DisallowedStd3Mapped("0,") },
    Range { from: '🄂', to: '🄂', mapping: DisallowedStd3Mapped("1,") },
    Range { from: '🄃', to: '🄃', mapping: DisallowedStd3Mapped("2,") },
    Range { from: '🄄', to: '🄄', mapping: DisallowedStd3Mapped("3,") },
    Range { from: '🄅', to: '🄅', mapping: DisallowedStd3Mapped("4,") },
    Range { from: '🄆', to: '🄆', mapping: DisallowedStd3Mapped("5,") },
    Range { from: '🄇', to: '🄇', mapping: DisallowedStd3Mapped("6,") },
    Range { from: '🄈', to: '🄈', mapping: DisallowedStd3Mapped("7,") },
    Range { from: '🄉', to: '🄉', mapping: DisallowedStd3Mapped("8,") },
    Range { from: '🄊', to: '🄊', mapping: DisallowedStd3Mapped("9,") },
    Range { from: '🄋', to: '🄌', mapping: Valid },
    Range { from: '🄍', to: '🄏', mapping: Disallowed },
    Range { from: '🄐', to: '🄐', mapping: DisallowedStd3Mapped("(a)") },
    Range { from: '🄑', to: '🄑', mapping: DisallowedStd3Mapped("(b)") },
    Range { from: '🄒', to: '🄒', mapping: DisallowedStd3Mapped("(c)") },
    Range { from: '🄓', to: '🄓', mapping: DisallowedStd3Mapped("(d)") },
    Range { from: '🄔', to: '🄔', mapping: DisallowedStd3Mapped("(e)") },
    Range { from: '🄕', to: '🄕', mapping: DisallowedStd3Mapped("(f)") },
    Range { from: '🄖', to: '🄖', mapping: DisallowedStd3Mapped("(g)") },
    Range { from: '🄗', to: '🄗', mapping: DisallowedStd3Mapped("(h)") },
    Range { from: '🄘', to: '🄘', mapping: DisallowedStd3Mapped("(i)") },
    Range { from: '🄙', to: '🄙', mapping: DisallowedStd3Mapped("(j)") },
    Range { from: '🄚', to: '🄚', mapping: DisallowedStd3Mapped("(k)") },
    Range { from: '🄛', to: '🄛', mapping: DisallowedStd3Mapped("(l)") },
    Range { from: '🄜', to: '🄜', mapping: DisallowedStd3Mapped("(m)") },
    Range { from: '🄝', to: '🄝', mapping: DisallowedStd3Mapped("(n)") },
    Range { from: '🄞', to: '🄞', mapping: DisallowedStd3Mapped("(o)") },
    Range { from: '🄟', to: '🄟', mapping: DisallowedStd3Mapped("(p)") },
    Range { from: '🄠', to: '🄠', mapping: DisallowedStd3Mapped("(q)") },
    Range { from: '🄡', to: '🄡', mapping: DisallowedStd3Mapped("(r)") },
    Range { from: '🄢', to: '🄢', mapping: DisallowedStd3Mapped("(s)") },
    Range { from: '🄣', to: '🄣', mapping: DisallowedStd3Mapped("(t)") },
    Range { from: '🄤', to: '🄤', mapping: DisallowedStd3Mapped("(u)") },
    Range { from: '🄥', to: '🄥', mapping: DisallowedStd3Mapped("(v)") },
    Range { from: '🄦', to: '🄦', mapping: DisallowedStd3Mapped("(w)") },
    Range { from: '🄧', to: '🄧', mapping: DisallowedStd3Mapped("(x)") },
    Range { from: '🄨', to: '🄨', mapping: DisallowedStd3Mapped("(y)") },
    Range { from: '🄩', to: '🄩', mapping: DisallowedStd3Mapped("(z)") },
    Range { from: '🄪', to: '🄪', mapping: Mapped("〔s〕") },
    Range { from: '🄫', to: '🄫', mapping: Mapped("c") },
    Range { from: '🄬', to: '🄬', mapping: Mapped("r") },
    Range { from: '🄭', to: '🄭', mapping: Mapped("cd") },
    Range { from: '🄮', to: '🄮', mapping: Mapped("wz") },
    Range { from: '🄯', to: '🄯', mapping: Disallowed },
    Range { from: '🄰', to: '🄰', mapping: Mapped("a") },
    Range { from: '🄱', to: '🄱', mapping: Mapped("b") },
    Range { from: '🄲', to: '🄲', mapping: Mapped("c") },
    Range { from: '🄳', to: '🄳', mapping: Mapped("d") },
    Range { from: '🄴', to: '🄴', mapping: Mapped("e") },
    Range { from: '🄵', to: '🄵', mapping: Mapped("f") },
    Range { from: '🄶', to: '🄶', mapping: Mapped("g") },
    Range { from: '🄷', to: '🄷', mapping: Mapped("h") },
    Range { from: '🄸', to: '🄸', mapping: Mapped("i") },
    Range { from: '🄹', to: '🄹', mapping: Mapped("j") },
    Range { from: '🄺', to: '🄺', mapping: Mapped("k") },
    Range { from: '🄻', to: '🄻', mapping: Mapped("l") },
    Range { from: '🄼', to: '🄼', mapping: Mapped("m") },
    Range { from: '🄽', to: '🄽', mapping: Mapped("n") },
    Range { from: '🄾', to: '🄾', mapping: Mapped("o") },
    Range { from: '🄿', to: '🄿', mapping: Mapped("p") },
    Range { from: '🅀', to: '🅀', mapping: Mapped("q") },
    Range { from: '🅁', to: '🅁', mapping: Mapped("r") },
    Range { from: '🅂', to: '🅂', mapping: Mapped("s") },
    Range { from: '🅃', to: '🅃', mapping: Mapped("t") },
    Range { from: '🅄', to: '🅄', mapping: Mapped("u") },
    Range { from: '🅅', to: '🅅', mapping: Mapped("v") },
    Range { from: '🅆', to: '🅆', mapping: Mapped("w") },
    Range { from: '🅇', to: '🅇', mapping: Mapped("x") },
    Range { from: '🅈', to: '🅈', mapping: Mapped("y") },
    Range { from: '🅉', to: '🅉', mapping: Mapped("z") },
    Range { from: '🅊', to: '🅊', mapping: Mapped("hv") },
    Range { from: '🅋', to: '🅋', mapping: Mapped("mv") },
    Range { from: '🅌', to: '🅌', mapping: Mapped("sd") },
    Range { from: '🅍', to: '🅍', mapping: Mapped("ss") },
    Range { from: '🅎', to: '🅎', mapping: Mapped("ppv") },
    Range { from: '🅏', to: '🅏', mapping: Mapped("wc") },
    Range { from: '🅐', to: '🅖', mapping: Valid },
    Range { from: '🅗', to: '🅗', mapping: Valid },
    Range { from: '🅘', to: '🅞', mapping: Valid },
    Range { from: '🅟', to: '🅟', mapping: Valid },
    Range { from: '🅠', to: '🅩', mapping: Valid },
    Range { from: '🅪', to: '🅪', mapping: Mapped("mc") },
    Range { from: '🅫', to: '🅫', mapping: Mapped("md") },
    Range { from: '🅬', to: '🅯', mapping: Disallowed },
    Range { from: '🅰', to: '🅸', mapping: Valid },
    Range { from: '🅹', to: '🅹', mapping: Valid },
    Range { from: '🅺', to: '🅺', mapping: Valid },
    Range { from: '🅻', to: '🅼', mapping: Valid },
    Range { from: '🅽', to: '🅾', mapping: Valid },
    Range { from: '🅿', to: '🅿', mapping: Valid },
    Range { from: '🆀', to: '🆉', mapping: Valid },
    Range { from: '🆊', to: '🆍', mapping: Valid },
    Range { from: '🆎', to: '🆏', mapping: Valid },
    Range { from: '🆐', to: '🆐', mapping: Mapped("dj") },
    Range { from: '🆑', to: '🆚', mapping: Valid },
    Range { from: '🆛', to: '🇥', mapping: Disallowed },
    Range { from: '🇦', to: '🇿', mapping: Valid },
    Range { from: '🈀', to: '🈀', mapping: Mapped("ほか") },
    Range { from: '🈁', to: '🈁', mapping: Mapped("ココ") },
    Range { from: '🈂', to: '🈂', mapping: Mapped("サ") },
    Range { from: '🈃', to: '🈏', mapping: Disallowed },
    Range { from: '🈐', to: '🈐', mapping: Mapped("手") },
    Range { from: '🈑', to: '🈑', mapping: Mapped("字") },
    Range { from: '🈒', to: '🈒', mapping: Mapped("双") },
    Range { from: '🈓', to: '🈓', mapping: Mapped("デ") },
    Range { from: '🈔', to: '🈔', mapping: Mapped("二") },
    Range { from: '🈕', to: '🈕', mapping: Mapped("多") },
    Range { from: '🈖', to: '🈖', mapping: Mapped("解") },
    Range { from: '🈗', to: '🈗', mapping: Mapped("天") },
    Range { from: '🈘', to: '🈘', mapping: Mapped("交") },
    Range { from: '🈙', to: '🈙', mapping: Mapped("映") },
    Range { from: '🈚', to: '🈚', mapping: Mapped("無") },
    Range { from: '🈛', to: '🈛', mapping: Mapped("料") },
    Range { from: '🈜', to: '🈜', mapping: Mapped("前") },
    Range { from: '🈝', to: '🈝', mapping: Mapped("後") },
    Range { from: '🈞', to: '🈞', mapping: Mapped("再") },
    Range { from: '🈟', to: '🈟', mapping: Mapped("新") },
    Range { from: '🈠', to: '🈠', mapping: Mapped("初") },
    Range { from: '🈡', to: '🈡', mapping: Mapped("終") },
    Range { from: '🈢', to: '🈢', mapping: Mapped("生") },
    Range { from: '🈣', to: '🈣', mapping: Mapped("販") },
    Range { from: '🈤', to: '🈤', mapping: Mapped("声") },
    Range { from: '🈥', to: '🈥', mapping: Mapped("吹") },
    Range { from: '🈦', to: '🈦', mapping: Mapped("演") },
    Range { from: '🈧', to: '🈧', mapping: Mapped("投") },
    Range { from: '🈨', to: '🈨', mapping: Mapped("捕") },
    Range { from: '🈩', to: '🈩', mapping: Mapped("一") },
    Range { from: '🈪', to: '🈪', mapping: Mapped("三") },
    Range { from: '🈫', to: '🈫', mapping: Mapped("遊") },
    Range { from: '🈬', to: '🈬', mapping: Mapped("左") },
    Range { from: '🈭', to: '🈭', mapping: Mapped("中") },
    Range { from: '🈮', to: '🈮', mapping: Mapped("右") },
    Range { from: '🈯', to: '🈯', mapping: Mapped("指") },
    Range { from: '🈰', to: '🈰', mapping: Mapped("走") },
    Range { from: '🈱', to: '🈱', mapping: Mapped("打") },
    Range { from: '🈲', to: '🈲', mapping: Mapped("禁") },
    Range { from: '🈳', to: '🈳', mapping: Mapped("空") },
    Range { from: '🈴', to: '🈴', mapping: Mapped("合") },
    Range { from: '🈵', to: '🈵', mapping: Mapped("満") },
    Range { from: '🈶', to: '🈶', mapping: Mapped("有") },
    Range { from: '🈷', to: '🈷', mapping: Mapped("月") },
    Range { from: '🈸', to: '🈸', mapping: Mapped("申") },
    Range { from: '🈹', to: '🈹', mapping: Mapped("割") },
    Range { from: '🈺', to: '🈺', mapping: Mapped("営") },
    Range { from: '🈻', to: '🈿', mapping: Disallowed },
    Range { from: '🉀', to: '🉀', mapping: Mapped("〔本〕") },
    Range { from: '🉁', to: '🉁', mapping: Mapped("〔三〕") },
    Range { from: '🉂', to: '🉂', mapping: Mapped("〔二〕") },
    Range { from: '🉃', to: '🉃', mapping: Mapped("〔安〕") },
    Range { from: '🉄', to: '🉄', mapping: Mapped("〔点〕") },
    Range { from: '🉅', to: '🉅', mapping: Mapped("〔打〕") },
    Range { from: '🉆', to: '🉆', mapping: Mapped("〔盗〕") },
    Range { from: '🉇', to: '🉇', mapping: Mapped("〔勝〕") },
    Range { from: '🉈', to: '🉈', mapping: Mapped("〔敗〕") },
    Range { from: '🉉', to: '🉏', mapping: Disallowed },
    Range { from: '🉐', to: '🉐', mapping: Mapped("得") },
    Range { from: '🉑', to: '🉑', mapping: Mapped("可") },
    Range { from: '🉒', to: '🋿', mapping: Disallowed },
    Range { from: '🌀', to: '🌠', mapping: Valid },
    Range { from: '🌡', to: '🌬', mapping: Valid },
    Range { from: '🌭', to: '🌯', mapping: Valid },
    Range { from: '🌰', to: '🌵', mapping: Valid },
    Range { from: '🌶', to: '🌶', mapping: Valid },
    Range { from: '🌷', to: '🍼', mapping: Valid },
    Range { from: '🍽', to: '🍽', mapping: Valid },
    Range { from: '🍾', to: '🍿', mapping: Valid },
    Range { from: '🎀', to: '🎓', mapping: Valid },
    Range { from: '🎔', to: '🎟', mapping: Valid },
    Range { from: '🎠', to: '🏄', mapping: Valid },
    Range { from: '🏅', to: '🏅', mapping: Valid },
    Range { from: '🏆', to: '🏊', mapping: Valid },
    Range { from: '🏋', to: '🏎', mapping: Valid },
    Range { from: '🏏', to: '🏓', mapping: Valid },
    Range { from: '🏔', to: '🏟', mapping: Valid },
    Range { from: '🏠', to: '🏰', mapping: Valid },
    Range { from: '🏱', to: '🏷', mapping: Valid },
    Range { from: '🏸', to: '🏿', mapping: Valid },
    Range { from: '🐀', to: '🐾', mapping: Valid },
    Range { from: '🐿', to: '🐿', mapping: Valid },
    Range { from: '👀', to: '👀', mapping: Valid },
    Range { from: '👁', to: '👁', mapping: Valid },
    Range { from: '👂', to: '📷', mapping: Valid },
    Range { from: '📸', to: '📸', mapping: Valid },
    Range { from: '📹', to: '📼', mapping: Valid },
    Range { from: '📽', to: '📾', mapping: Valid },
    Range { from: '📿', to: '📿', mapping: Valid },
    Range { from: '🔀', to: '🔽', mapping: Valid },
    Range { from: '🔾', to: '🔿', mapping: Valid },
    Range { from: '🕀', to: '🕃', mapping: Valid },
    Range { from: '🕄', to: '🕊', mapping: Valid },
    Range { from: '🕋', to: '🕏', mapping: Valid },
    Range { from: '🕐', to: '🕧', mapping: Valid },
    Range { from: '🕨', to: '🕹', mapping: Valid },
    Range { from: '🕺', to: '🕺', mapping: Disallowed },
    Range { from: '🕻', to: '🖣', mapping: Valid },
    Range { from: '🖤', to: '🖤', mapping: Disallowed },
    Range { from: '🖥', to: '🗺', mapping: Valid },
    Range { from: '🗻', to: '🗿', mapping: Valid },
    Range { from: '😀', to: '😀', mapping: Valid },
    Range { from: '😁', to: '😐', mapping: Valid },
    Range { from: '😑', to: '😑', mapping: Valid },
    Range { from: '😒', to: '😔', mapping: Valid },
    Range { from: '😕', to: '😕', mapping: Valid },
    Range { from: '😖', to: '😖', mapping: Valid },
    Range { from: '😗', to: '😗', mapping: Valid },
    Range { from: '😘', to: '😘', mapping: Valid },
    Range { from: '😙', to: '😙', mapping: Valid },
    Range { from: '😚', to: '😚', mapping: Valid },
    Range { from: '😛', to: '😛', mapping: Valid },
    Range { from: '😜', to: '😞', mapping: Valid },
    Range { from: '😟', to: '😟', mapping: Valid },
    Range { from: '😠', to: '😥', mapping: Valid },
    Range { from: '😦', to: '😧', mapping: Valid },
    Range { from: '😨', to: '😫', mapping: Valid },
    Range { from: '😬', to: '😬', mapping: Valid },
    Range { from: '😭', to: '😭', mapping: Valid },
    Range { from: '😮', to: '😯', mapping: Valid },
    Range { from: '😰', to: '😳', mapping: Valid },
    Range { from: '😴', to: '😴', mapping: Valid },
    Range { from: '😵', to: '🙀', mapping: Valid },
    Range { from: '🙁', to: '🙂', mapping: Valid },
    Range { from: '🙃', to: '🙄', mapping: Valid },
    Range { from: '🙅', to: '🙏', mapping: Valid },
    Range { from: '🙐', to: '🙿', mapping: Valid },
    Range { from: '🚀', to: '🛅', mapping: Valid },
    Range { from: '🛆', to: '🛏', mapping: Valid },
    Range { from: '🛐', to: '🛐', mapping: Valid },
    Range { from: '🛑', to: '🛟', mapping: Disallowed },
    Range { from: '🛠', to: '🛬', mapping: Valid },
    Range { from: '🛭', to: '🛯', mapping: Disallowed },
    Range { from: '🛰', to: '🛳', mapping: Valid },
    Range { from: '🛴', to: '🛿', mapping: Disallowed },
    Range { from: '🜀', to: '🝳', mapping: Valid },
    Range { from: '🝴', to: '🝿', mapping: Disallowed },
    Range { from: '🞀', to: '🟔', mapping: Valid },
    Range { from: '🟕', to: '🟿', mapping: Disallowed },
    Range { from: '🠀', to: '🠋', mapping: Valid },
    Range { from: '🠌', to: '🠏', mapping: Disallowed },
    Range { from: '🠐', to: '🡇', mapping: Valid },
    Range { from: '🡈', to: '🡏', mapping: Disallowed },
    Range { from: '🡐', to: '🡙', mapping: Valid },
    Range { from: '🡚', to: '🡟', mapping: Disallowed },
    Range { from: '🡠', to: '🢇', mapping: Valid },
    Range { from: '🢈', to: '🢏', mapping: Disallowed },
    Range { from: '🢐', to: '🢭', mapping: Valid },
    Range { from: '🢮', to: '🤏', mapping: Disallowed },
    Range { from: '🤐', to: '🤘', mapping: Valid },
    Range { from: '🤙', to: '🥿', mapping: Disallowed },
    Range { from: '🦀', to: '🦄', mapping: Valid },
    Range { from: '🦅', to: '🦿', mapping: Disallowed },
    Range { from: '🧀', to: '🧀', mapping: Valid },
    Range { from: '🧁', to: '🿽', mapping: Disallowed },
    Range { from: '🿾', to: '🿿', mapping: Disallowed },
    Range { from: '𠀀', to: '𪛖', mapping: Valid },
    Range { from: '𪛗', to: '𪛿', mapping: Disallowed },
    Range { from: '𪜀', to: '𫜴', mapping: Valid },
    Range { from: '𫜵', to: '𫜿', mapping: Disallowed },
    Range { from: '𫝀', to: '𫠝', mapping: Valid },
    Range { from: '𫠞', to: '𫠟', mapping: Disallowed },
    Range { from: '𫠠', to: '𬺡', mapping: Valid },
    Range { from: '𬺢', to: '𯟿', mapping: Disallowed },
    Range { from: '丽', to: '丽', mapping: Mapped("丽") },
    Range { from: '丸', to: '丸', mapping: Mapped("丸") },
    Range { from: '乁', to: '乁', mapping: Mapped("乁") },
    Range { from: '𠄢', to: '𠄢', mapping: Mapped("𠄢") },
    Range { from: '你', to: '你', mapping: Mapped("你") },
    Range { from: '侮', to: '侮', mapping: Mapped("侮") },
    Range { from: '侻', to: '侻', mapping: Mapped("侻") },
    Range { from: '倂', to: '倂', mapping: Mapped("倂") },
    Range { from: '偺', to: '偺', mapping: Mapped("偺") },
    Range { from: '備', to: '備', mapping: Mapped("備") },
    Range { from: '僧', to: '僧', mapping: Mapped("僧") },
    Range { from: '像', to: '像', mapping: Mapped("像") },
    Range { from: '㒞', to: '㒞', mapping: Mapped("㒞") },
    Range { from: '𠘺', to: '𠘺', mapping: Mapped("𠘺") },
    Range { from: '免', to: '免', mapping: Mapped("免") },
    Range { from: '兔', to: '兔', mapping: Mapped("兔") },
    Range { from: '兤', to: '兤', mapping: Mapped("兤") },
    Range { from: '具', to: '具', mapping: Mapped("具") },
    Range { from: '𠔜', to: '𠔜', mapping: Mapped("𠔜") },
    Range { from: '㒹', to: '㒹', mapping: Mapped("㒹") },
    Range { from: '內', to: '內', mapping: Mapped("內") },
    Range { from: '再', to: '再', mapping: Mapped("再") },
    Range { from: '𠕋', to: '𠕋', mapping: Mapped("𠕋") },
    Range { from: '冗', to: '冗', mapping: Mapped("冗") },
    Range { from: '冤', to: '冤', mapping: Mapped("冤") },
    Range { from: '仌', to: '仌', mapping: Mapped("仌") },
    Range { from: '冬', to: '冬', mapping: Mapped("冬") },
    Range { from: '况', to: '况', mapping: Mapped("况") },
    Range { from: '𩇟', to: '𩇟', mapping: Mapped("𩇟") },
    Range { from: '凵', to: '凵', mapping: Mapped("凵") },
    Range { from: '刃', to: '刃', mapping: Mapped("刃") },
    Range { from: '㓟', to: '㓟', mapping: Mapped("㓟") },
    Range { from: '刻', to: '刻', mapping: Mapped("刻") },
    Range { from: '剆', to: '剆', mapping: Mapped("剆") },
    Range { from: '割', to: '割', mapping: Mapped("割") },
    Range { from: '剷', to: '剷', mapping: Mapped("剷") },
    Range { from: '㔕', to: '㔕', mapping: Mapped("㔕") },
    Range { from: '勇', to: '勇', mapping: Mapped("勇") },
    Range { from: '勉', to: '勉', mapping: Mapped("勉") },
    Range { from: '勤', to: '勤', mapping: Mapped("勤") },
    Range { from: '勺', to: '勺', mapping: Mapped("勺") },
    Range { from: '包', to: '包', mapping: Mapped("包") },
    Range { from: '匆', to: '匆', mapping: Mapped("匆") },
    Range { from: '北', to: '北', mapping: Mapped("北") },
    Range { from: '卉', to: '卉', mapping: Mapped("卉") },
    Range { from: '卑', to: '卑', mapping: Mapped("卑") },
    Range { from: '博', to: '博', mapping: Mapped("博") },
    Range { from: '即', to: '即', mapping: Mapped("即") },
    Range { from: '卽', to: '卽', mapping: Mapped("卽") },
    Range { from: '卿', to: '卿', mapping: Mapped("卿") },
    Range { from: '𠨬', to: '𠨬', mapping: Mapped("𠨬") },
    Range { from: '灰', to: '灰', mapping: Mapped("灰") },
    Range { from: '及', to: '及', mapping: Mapped("及") },
    Range { from: '叟', to: '叟', mapping: Mapped("叟") },
    Range { from: '𠭣', to: '𠭣', mapping: Mapped("𠭣") },
    Range { from: '叫', to: '叫', mapping: Mapped("叫") },
    Range { from: '叱', to: '叱', mapping: Mapped("叱") },
    Range { from: '吆', to: '吆', mapping: Mapped("吆") },
    Range { from: '咞', to: '咞', mapping: Mapped("咞") },
    Range { from: '吸', to: '吸', mapping: Mapped("吸") },
    Range { from: '呈', to: '呈', mapping: Mapped("呈") },
    Range { from: '周', to: '周', mapping: Mapped("周") },
    Range { from: '咢', to: '咢', mapping: Mapped("咢") },
    Range { from: '哶', to: '哶', mapping: Mapped("哶") },
    Range { from: '唐', to: '唐', mapping: Mapped("唐") },
    Range { from: '啓', to: '啓', mapping: Mapped("啓") },
    Range { from: '啣', to: '啣', mapping: Mapped("啣") },
    Range { from: '善', to: '善', mapping: Mapped("善") },
    Range { from: '喙', to: '喙', mapping: Mapped("喙") },
    Range { from: '喫', to: '喫', mapping: Mapped("喫") },
    Range { from: '喳', to: '喳', mapping: Mapped("喳") },
    Range { from: '嗂', to: '嗂', mapping: Mapped("嗂") },
    Range { from: '圖', to: '圖', mapping: Mapped("圖") },
    Range { from: '嘆', to: '嘆', mapping: Mapped("嘆") },
    Range { from: '圗', to: '圗', mapping: Mapped("圗") },
    Range { from: '噑', to: '噑', mapping: Mapped("噑") },
    Range { from: '噴', to: '噴', mapping: Mapped("噴") },
    Range { from: '切', to: '切', mapping: Mapped("切") },
    Range { from: '壮', to: '壮', mapping: Mapped("壮") },
    Range { from: '城', to: '城', mapping: Mapped("城") },
    Range { from: '埴', to: '埴', mapping: Mapped("埴") },
    Range { from: '堍', to: '堍', mapping: Mapped("堍") },
    Range { from: '型', to: '型', mapping: Mapped("型") },
    Range { from: '堲', to: '堲', mapping: Mapped("堲") },
    Range { from: '報', to: '報', mapping: Mapped("報") },
    Range { from: '墬', to: '墬', mapping: Mapped("墬") },
    Range { from: '𡓤', to: '𡓤', mapping: Mapped("𡓤") },
    Range { from: '売', to: '売', mapping: Mapped("売") },
    Range { from: '壷', to: '壷', mapping: Mapped("壷") },
    Range { from: '夆', to: '夆', mapping: Mapped("夆") },
    Range { from: '多', to: '多', mapping: Mapped("多") },
    Range { from: '夢', to: '夢', mapping: Mapped("夢") },
    Range { from: '奢', to: '奢', mapping: Mapped("奢") },
    Range { from: '𡚨', to: '𡚨', mapping: Mapped("𡚨") },
    Range { from: '𡛪', to: '𡛪', mapping: Mapped("𡛪") },
    Range { from: '姬', to: '姬', mapping: Mapped("姬") },
    Range { from: '娛', to: '娛', mapping: Mapped("娛") },
    Range { from: '娧', to: '娧', mapping: Mapped("娧") },
    Range { from: '姘', to: '姘', mapping: Mapped("姘") },
    Range { from: '婦', to: '婦', mapping: Mapped("婦") },
    Range { from: '㛮', to: '㛮', mapping: Mapped("㛮") },
    Range { from: '㛼', to: '㛼', mapping: Disallowed },
    Range { from: '嬈', to: '嬈', mapping: Mapped("嬈") },
    Range { from: '嬾', to: '嬾', mapping: Mapped("嬾") },
    Range { from: '𡧈', to: '𡧈', mapping: Mapped("𡧈") },
    Range { from: '寃', to: '寃', mapping: Mapped("寃") },
    Range { from: '寘', to: '寘', mapping: Mapped("寘") },
    Range { from: '寧', to: '寧', mapping: Mapped("寧") },
    Range { from: '寳', to: '寳', mapping: Mapped("寳") },
    Range { from: '𡬘', to: '𡬘', mapping: Mapped("𡬘") },
    Range { from: '寿', to: '寿', mapping: Mapped("寿") },
    Range { from: '将', to: '将', mapping: Mapped("将") },
    Range { from: '当', to: '当', mapping: Disallowed },
    Range { from: '尢', to: '尢', mapping: Mapped("尢") },
    Range { from: '㞁', to: '㞁', mapping: Mapped("㞁") },
    Range { from: '屠', to: '屠', mapping: Mapped("屠") },
    Range { from: '屮', to: '屮', mapping: Mapped("屮") },
    Range { from: '峀', to: '峀', mapping: Mapped("峀") },
    Range { from: '岍', to: '岍', mapping: Mapped("岍") },
    Range { from: '𡷤', to: '𡷤', mapping: Mapped("𡷤") },
    Range { from: '嵃', to: '嵃', mapping: Mapped("嵃") },
    Range { from: '𡷦', to: '𡷦', mapping: Mapped("𡷦") },
    Range { from: '嵮', to: '嵮', mapping: Mapped("嵮") },
    Range { from: '嵫', to: '嵫', mapping: Mapped("嵫") },
    Range { from: '嵼', to: '嵼', mapping: Mapped("嵼") },
    Range { from: '巡', to: '巡', mapping: Mapped("巡") },
    Range { from: '巢', to: '巢', mapping: Mapped("巢") },
    Range { from: '㠯', to: '㠯', mapping: Mapped("㠯") },
    Range { from: '巽', to: '巽', mapping: Mapped("巽") },
    Range { from: '帨', to: '帨', mapping: Mapped("帨") },
    Range { from: '帽', to: '帽', mapping: Mapped("帽") },
    Range { from: '幩', to: '幩', mapping: Mapped("幩") },
    Range { from: '㡢', to: '㡢', mapping: Mapped("㡢") },
    Range { from: '𢆃', to: '𢆃', mapping: Mapped("𢆃") },
    Range { from: '㡼', to: '㡼', mapping: Mapped("㡼") },
    Range { from: '庰', to: '庰', mapping: Mapped("庰") },
    Range { from: '庳', to: '庳', mapping: Mapped("庳") },
    Range { from: '庶', to: '庶', mapping: Mapped("庶") },
    Range { from: '廊', to: '廊', mapping: Mapped("廊") },
    Range { from: '𪎒', to: '𪎒', mapping: Mapped("𪎒") },
    Range { from: '廾', to: '廾', mapping: Mapped("廾") },
    Range { from: '𢌱', to: '𢌱', mapping: Mapped("𢌱") },
    Range { from: '舁', to: '舁', mapping: Mapped("舁") },
    Range { from: '弢', to: '弢', mapping: Mapped("弢") },
    Range { from: '㣇', to: '㣇', mapping: Mapped("㣇") },
    Range { from: '𣊸', to: '𣊸', mapping: Mapped("𣊸") },
    Range { from: '𦇚', to: '𦇚', mapping: Mapped("𦇚") },
    Range { from: '形', to: '形', mapping: Mapped("形") },
    Range { from: '彫', to: '彫', mapping: Mapped("彫") },
    Range { from: '㣣', to: '㣣', mapping: Mapped("㣣") },
    Range { from: '徚', to: '徚', mapping: Mapped("徚") },
    Range { from: '忍', to: '忍', mapping: Mapped("忍") },
    Range { from: '志', to: '志', mapping: Mapped("志") },
    Range { from: '忹', to: '忹', mapping: Mapped("忹") },
    Range { from: '悁', to: '悁', mapping: Mapped("悁") },
    Range { from: '㤺', to: '㤺', mapping: Mapped("㤺") },
    Range { from: '㤜', to: '㤜', mapping: Mapped("㤜") },
    Range { from: '悔', to: '悔', mapping: Mapped("悔") },
    Range { from: '𢛔', to: '𢛔', mapping: Mapped("𢛔") },
    Range { from: '惇', to: '惇', mapping: Mapped("惇") },
    Range { from: '慈', to: '慈', mapping: Mapped("慈") },
    Range { from: '慌', to: '慌', mapping: Mapped("慌") },
    Range { from: '慎', to: '慎', mapping: Mapped("慎") },
    Range { from: '慌', to: '慌', mapping: Mapped("慌") },
    Range { from: '慺', to: '慺', mapping: Mapped("慺") },
    Range { from: '憎', to: '憎', mapping: Mapped("憎") },
    Range { from: '憲', to: '憲', mapping: Mapped("憲") },
    Range { from: '憤', to: '憤', mapping: Mapped("憤") },
    Range { from: '憯', to: '憯', mapping: Mapped("憯") },
    Range { from: '懞', to: '懞', mapping: Mapped("懞") },
    Range { from: '懲', to: '懲', mapping: Mapped("懲") },
    Range { from: '懶', to: '懶', mapping: Mapped("懶") },
    Range { from: '成', to: '成', mapping: Mapped("成") },
    Range { from: '戛', to: '戛', mapping: Mapped("戛") },
    Range { from: '扝', to: '扝', mapping: Mapped("扝") },
    Range { from: '抱', to: '抱', mapping: Mapped("抱") },
    Range { from: '拔', to: '拔', mapping: Mapped("拔") },
    Range { from: '捐', to: '捐', mapping: Mapped("捐") },
    Range { from: '𢬌', to: '𢬌', mapping: Mapped("𢬌") },
    Range { from: '挽', to: '挽', mapping: Mapped("挽") },
    Range { from: '拼', to: '拼', mapping: Mapped("拼") },
    Range { from: '捨', to: '捨', mapping: Mapped("捨") },
    Range { from: '掃', to: '掃', mapping: Mapped("掃") },
    Range { from: '揤', to: '揤', mapping: Mapped("揤") },
    Range { from: '𢯱', to: '𢯱', mapping: Mapped("𢯱") },
    Range { from: '搢', to: '搢', mapping: Mapped("搢") },
    Range { from: '揅', to: '揅', mapping: Mapped("揅") },
    Range { from: '掩', to: '掩', mapping: Mapped("掩") },
    Range { from: '㨮', to: '㨮', mapping: Mapped("㨮") },
    Range { from: '摩', to: '摩', mapping: Mapped("摩") },
    Range { from: '摾', to: '摾', mapping: Mapped("摾") },
    Range { from: '撝', to: '撝', mapping: Mapped("撝") },
    Range { from: '摷', to: '摷', mapping: Mapped("摷") },
    Range { from: '㩬', to: '㩬', mapping: Mapped("㩬") },
    Range { from: '敏', to: '敏', mapping: Mapped("敏") },
    Range { from: '敬', to: '敬', mapping: Mapped("敬") },
    Range { from: '𣀊', to: '𣀊', mapping: Mapped("𣀊") },
    Range { from: '旣', to: '旣', mapping: Mapped("旣") },
    Range { from: '書', to: '書', mapping: Mapped("書") },
    Range { from: '晉', to: '晉', mapping: Mapped("晉") },
    Range { from: '㬙', to: '㬙', mapping: Mapped("㬙") },
    Range { from: '暑', to: '暑', mapping: Mapped("暑") },
    Range { from: '㬈', to: '㬈', mapping: Mapped("㬈") },
    Range { from: '㫤', to: '㫤', mapping: Mapped("㫤") },
    Range { from: '冒', to: '冒', mapping: Mapped("冒") },
    Range { from: '冕', to: '冕', mapping: Mapped("冕") },
    Range { from: '最', to: '最', mapping: Mapped("最") },
    Range { from: '暜', to: '暜', mapping: Mapped("暜") },
    Range { from: '肭', to: '肭', mapping: Mapped("肭") },
    Range { from: '䏙', to: '䏙', mapping: Mapped("䏙") },
    Range { from: '朗', to: '朗', mapping: Mapped("朗") },
    Range { from: '望', to: '望', mapping: Mapped("望") },
    Range { from: '朡', to: '朡', mapping: Mapped("朡") },
    Range { from: '杞', to: '杞', mapping: Mapped("杞") },
    Range { from: '杓', to: '杓', mapping: Mapped("杓") },
    Range { from: '𣏃', to: '𣏃', mapping: Mapped("𣏃") },
    Range { from: '㭉', to: '㭉', mapping: Mapped("㭉") },
    Range { from: '柺', to: '柺', mapping: Mapped("柺") },
    Range { from: '枅', to: '枅', mapping: Mapped("枅") },
    Range { from: '桒', to: '桒', mapping: Mapped("桒") },
    Range { from: '梅', to: '梅', mapping: Mapped("梅") },
    Range { from: '𣑭', to: '𣑭', mapping: Mapped("𣑭") },
    Range { from: '梎', to: '梎', mapping: Mapped("梎") },
    Range { from: '栟', to: '栟', mapping: Mapped("栟") },
    Range { from: '椔', to: '椔', mapping: Mapped("椔") },
    Range { from: '㮝', to: '㮝', mapping: Mapped("㮝") },
    Range { from: '楂', to: '楂', mapping: Mapped("楂") },
    Range { from: '榣', to: '榣', mapping: Mapped("榣") },
    Range { from: '槪', to: '槪', mapping: Mapped("槪") },
    Range { from: '檨', to: '檨', mapping: Mapped("檨") },
    Range { from: '𣚣', to: '𣚣', mapping: Mapped("𣚣") },
    Range { from: '櫛', to: '櫛', mapping: Mapped("櫛") },
    Range { from: '㰘', to: '㰘', mapping: Mapped("㰘") },
    Range { from: '次', to: '次', mapping: Mapped("次") },
    Range { from: '𣢧', to: '𣢧', mapping: Mapped("𣢧") },
    Range { from: '歔', to: '歔', mapping: Mapped("歔") },
    Range { from: '㱎', to: '㱎', mapping: Mapped("㱎") },
    Range { from: '歲', to: '歲', mapping: Mapped("歲") },
    Range { from: '殟', to: '殟', mapping: Mapped("殟") },
    Range { from: '殺', to: '殺', mapping: Mapped("殺") },
    Range { from: '殻', to: '殻', mapping: Mapped("殻") },
    Range { from: '𣪍', to: '𣪍', mapping: Mapped("𣪍") },
    Range { from: '𡴋', to: '𡴋', mapping: Mapped("𡴋") },
    Range { from: '𣫺', to: '𣫺', mapping: Mapped("𣫺") },
    Range { from: '汎', to: '汎', mapping: Mapped("汎") },
    Range { from: '𣲼', to: '𣲼', mapping: Mapped("𣲼") },
    Range { from: '沿', to: '沿', mapping: Mapped("沿") },
    Range { from: '泍', to: '泍', mapping: Mapped("泍") },
    Range { from: '汧', to: '汧', mapping: Mapped("汧") },
    Range { from: '洖', to: '洖', mapping: Mapped("洖") },
    Range { from: '派', to: '派', mapping: Mapped("派") },
    Range { from: '海', to: '海', mapping: Mapped("海") },
    Range { from: '流', to: '流', mapping: Mapped("流") },
    Range { from: '浩', to: '浩', mapping: Mapped("浩") },
    Range { from: '浸', to: '浸', mapping: Mapped("浸") },
    Range { from: '涅', to: '涅', mapping: Mapped("涅") },
    Range { from: '𣴞', to: '𣴞', mapping: Mapped("𣴞") },
    Range { from: '洴', to: '洴', mapping: Mapped("洴") },
    Range { from: '港', to: '港', mapping: Mapped("港") },
    Range { from: '湮', to: '湮', mapping: Mapped("湮") },
    Range { from: '㴳', to: '㴳', mapping: Mapped("㴳") },
    Range { from: '滋', to: '滋', mapping: Mapped("滋") },
    Range { from: '滇', to: '滇', mapping: Mapped("滇") },
    Range { from: '𣻑', to: '𣻑', mapping: Mapped("𣻑") },
    Range { from: '淹', to: '淹', mapping: Mapped("淹") },
    Range { from: '潮', to: '潮', mapping: Mapped("潮") },
    Range { from: '𣽞', to: '𣽞', mapping: Mapped("𣽞") },
    Range { from: '𣾎', to: '𣾎', mapping: Mapped("𣾎") },
    Range { from: '濆', to: '濆', mapping: Mapped("濆") },
    Range { from: '瀹', to: '瀹', mapping: Mapped("瀹") },
    Range { from: '瀞', to: '瀞', mapping: Mapped("瀞") },
    Range { from: '瀛', to: '瀛', mapping: Mapped("瀛") },
    Range { from: '㶖', to: '㶖', mapping: Mapped("㶖") },
    Range { from: '灊', to: '灊', mapping: Mapped("灊") },
    Range { from: '災', to: '災', mapping: Mapped("災") },
    Range { from: '灷', to: '灷', mapping: Mapped("灷") },
    Range { from: '炭', to: '炭', mapping: Mapped("炭") },
    Range { from: '𠔥', to: '𠔥', mapping: Mapped("𠔥") },
    Range { from: '煅', to: '煅', mapping: Mapped("煅") },
    Range { from: '𤉣', to: '𤉣', mapping: Mapped("𤉣") },
    Range { from: '熜', to: '熜', mapping: Mapped("熜") },
    Range { from: '𤎫', to: '𤎫', mapping: Disallowed },
    Range { from: '爨', to: '爨', mapping: Mapped("爨") },
    Range { from: '爵', to: '爵', mapping: Mapped("爵") },
    Range { from: '牐', to: '牐', mapping: Mapped("牐") },
    Range { from: '𤘈', to: '𤘈', mapping: Mapped("𤘈") },
    Range { from: '犀', to: '犀', mapping: Mapped("犀") },
    Range { from: '犕', to: '犕', mapping: Mapped("犕") },
    Range { from: '𤜵', to: '𤜵', mapping: Mapped("𤜵") },
    Range { from: '𤠔', to: '𤠔', mapping: Mapped("𤠔") },
    Range { from: '獺', to: '獺', mapping: Mapped("獺") },
    Range { from: '王', to: '王', mapping: Mapped("王") },
    Range { from: '㺬', to: '㺬', mapping: Mapped("㺬") },
    Range { from: '玥', to: '玥', mapping: Mapped("玥") },
    Range { from: '㺸', to: '㺸', mapping: Mapped("㺸") },
    Range { from: '瑇', to: '瑇', mapping: Mapped("瑇") },
    Range { from: '瑜', to: '瑜', mapping: Mapped("瑜") },
    Range { from: '瑱', to: '瑱', mapping: Mapped("瑱") },
    Range { from: '璅', to: '璅', mapping: Mapped("璅") },
    Range { from: '瓊', to: '瓊', mapping: Mapped("瓊") },
    Range { from: '㼛', to: '㼛', mapping: Mapped("㼛") },
    Range { from: '甤', to: '甤', mapping: Mapped("甤") },
    Range { from: '𤰶', to: '𤰶', mapping: Mapped("𤰶") },
    Range { from: '甾', to: '甾', mapping: Mapped("甾") },
    Range { from: '𤲒', to: '𤲒', mapping: Mapped("𤲒") },
    Range { from: '異', to: '異', mapping: Mapped("異") },
    Range { from: '𢆟', to: '𢆟', mapping: Mapped("𢆟") },
    Range { from: '瘐', to: '瘐', mapping: Mapped("瘐") },
    Range { from: '𤾡', to: '𤾡', mapping: Mapped("𤾡") },
    Range { from: '𤾸', to: '𤾸', mapping: Mapped("𤾸") },
    Range { from: '𥁄', to: '𥁄', mapping: Mapped("𥁄") },
    Range { from: '㿼', to: '㿼', mapping: Mapped("㿼") },
    Range { from: '䀈', to: '䀈', mapping: Mapped("䀈") },
    Range { from: '直', to: '直', mapping: Mapped("直") },
    Range { from: '𥃳', to: '𥃳', mapping: Mapped("𥃳") },
    Range { from: '𥃲', to: '𥃲', mapping: Mapped("𥃲") },
    Range { from: '𥄙', to: '𥄙', mapping: Mapped("𥄙") },
    Range { from: '𥄳', to: '𥄳', mapping: Mapped("𥄳") },
    Range { from: '眞', to: '眞', mapping: Mapped("眞") },
    Range { from: '真', to: '真', mapping: Mapped("真") },
    Range { from: '睊', to: '睊', mapping: Mapped("睊") },
    Range { from: '䀹', to: '䀹', mapping: Mapped("䀹") },
    Range { from: '瞋', to: '瞋', mapping: Mapped("瞋") },
    Range { from: '䁆', to: '䁆', mapping: Mapped("䁆") },
    Range { from: '䂖', to: '䂖', mapping: Mapped("䂖") },
    Range { from: '𥐝', to: '𥐝', mapping: Mapped("𥐝") },
    Range { from: '硎', to: '硎', mapping: Mapped("硎") },
    Range { from: '碌', to: '碌', mapping: Mapped("碌") },
    Range { from: '磌', to: '磌', mapping: Mapped("磌") },
    Range { from: '䃣', to: '䃣', mapping: Mapped("䃣") },
    Range { from: '𥘦', to: '𥘦', mapping: Mapped("𥘦") },
    Range { from: '祖', to: '祖', mapping: Mapped("祖") },
    Range { from: '𥚚', to: '𥚚', mapping: Mapped("𥚚") },
    Range { from: '𥛅', to: '𥛅', mapping: Mapped("𥛅") },
    Range { from: '福', to: '福', mapping: Mapped("福") },
    Range { from: '秫', to: '秫', mapping: Mapped("秫") },
    Range { from: '䄯', to: '䄯', mapping: Mapped("䄯") },
    Range { from: '穀', to: '穀', mapping: Mapped("穀") },
    Range { from: '穊', to: '穊', mapping: Mapped("穊") },
    Range { from: '穏', to: '穏', mapping: Mapped("穏") },
    Range { from: '𥥼', to: '𥥼', mapping: Mapped("𥥼") },
    Range { from: '𥪧', to: '𥪧', mapping: Mapped("𥪧") },
    Range { from: '竮', to: '竮', mapping: Disallowed },
    Range { from: '䈂', to: '䈂', mapping: Mapped("䈂") },
    Range { from: '𥮫', to: '𥮫', mapping: Mapped("𥮫") },
    Range { from: '篆', to: '篆', mapping: Mapped("篆") },
    Range { from: '築', to: '築', mapping: Mapped("築") },
    Range { from: '䈧', to: '䈧', mapping: Mapped("䈧") },
    Range { from: '𥲀', to: '𥲀', mapping: Mapped("𥲀") },
    Range { from: '糒', to: '糒', mapping: Mapped("糒") },
    Range { from: '䊠', to: '䊠', mapping: Mapped("䊠") },
    Range { from: '糨', to: '糨', mapping: Mapped("糨") },
    Range { from: '糣', to: '糣', mapping: Mapped("糣") },
    Range { from: '紀', to: '紀', mapping: Mapped("紀") },
    Range { from: '𥾆', to: '𥾆', mapping: Mapped("𥾆") },
    Range { from: '絣', to: '絣', mapping: Mapped("絣") },
    Range { from: '䌁', to: '䌁', mapping: Mapped("䌁") },
    Range { from: '緇', to: '緇', mapping: Mapped("緇") },
    Range { from: '縂', to: '縂', mapping: Mapped("縂") },
    Range { from: '繅', to: '繅', mapping: Mapped("繅") },
    Range { from: '䌴', to: '䌴', mapping: Mapped("䌴") },
    Range { from: '𦈨', to: '𦈨', mapping: Mapped("𦈨") },
    Range { from: '𦉇', to: '𦉇', mapping: Mapped("𦉇") },
    Range { from: '䍙', to: '䍙', mapping: Mapped("䍙") },
    Range { from: '𦋙', to: '𦋙', mapping: Mapped("𦋙") },
    Range { from: '罺', to: '罺', mapping: Mapped("罺") },
    Range { from: '𦌾', to: '𦌾', mapping: Mapped("𦌾") },
    Range { from: '羕', to: '羕', mapping: Mapped("羕") },
    Range { from: '翺', to: '翺', mapping: Mapped("翺") },
    Range { from: '者', to: '者', mapping: Mapped("者") },
    Range { from: '𦓚', to: '𦓚', mapping: Mapped("𦓚") },
    Range { from: '𦔣', to: '𦔣', mapping: Mapped("𦔣") },
    Range { from: '聠', to: '聠', mapping: Mapped("聠") },
    Range { from: '𦖨', to: '𦖨', mapping: Mapped("𦖨") },
    Range { from: '聰', to: '聰', mapping: Mapped("聰") },
    Range { from: '𣍟', to: '𣍟', mapping: Mapped("𣍟") },
    Range { from: '䏕', to: '䏕', mapping: Mapped("䏕") },
    Range { from: '育', to: '育', mapping: Mapped("育") },
    Range { from: '脃', to: '脃', mapping: Mapped("脃") },
    Range { from: '䐋', to: '䐋', mapping: Mapped("䐋") },
    Range { from: '脾', to: '脾', mapping: Mapped("脾") },
    Range { from: '媵', to: '媵', mapping: Mapped("媵") },
    Range { from: '𦞧', to: '𦞧', mapping: Mapped("𦞧") },
    Range { from: '𦞵', to: '𦞵', mapping: Mapped("𦞵") },
    Range { from: '𣎓', to: '𣎓', mapping: Mapped("𣎓") },
    Range { from: '𣎜', to: '𣎜', mapping: Mapped("𣎜") },
    Range { from: '舁', to: '舁', mapping: Mapped("舁") },
    Range { from: '舄', to: '舄', mapping: Mapped("舄") },
    Range { from: '辞', to: '辞', mapping: Mapped("辞") },
    Range { from: '䑫', to: '䑫', mapping: Mapped("䑫") },
    Range { from: '芑', to: '芑', mapping: Mapped("芑") },
    Range { from: '芋', to: '芋', mapping: Mapped("芋") },
    Range { from: '芝', to: '芝', mapping: Mapped("芝") },
    Range { from: '劳', to: '劳', mapping: Mapped("劳") },
    Range { from: '花', to: '花', mapping: Mapped("花") },
    Range { from: '芳', to: '芳', mapping: Mapped("芳") },
    Range { from: '芽', to: '芽', mapping: Mapped("芽") },
    Range { from: '苦', to: '苦', mapping: Mapped("苦") },
    Range { from: '𦬼', to: '𦬼', mapping: Mapped("𦬼") },
    Range { from: '若', to: '若', mapping: Mapped("若") },
    Range { from: '茝', to: '茝', mapping: Mapped("茝") },
    Range { from: '荣', to: '荣', mapping: Mapped("荣") },
    Range { from: '莭', to: '莭', mapping: Mapped("莭") },
    Range { from: '茣', to: '茣', mapping: Mapped("茣") },
    Range { from: '莽', to: '莽', mapping: Mapped("莽") },
    Range { from: '菧', to: '菧', mapping: Mapped("菧") },
    Range { from: '著', to: '著', mapping: Mapped("著") },
    Range { from: '荓', to: '荓', mapping: Mapped("荓") },
    Range { from: '菊', to: '菊', mapping: Mapped("菊") },
    Range { from: '菌', to: '菌', mapping: Mapped("菌") },
    Range { from: '菜', to: '菜', mapping: Mapped("菜") },
    Range { from: '𦰶', to: '𦰶', mapping: Mapped("𦰶") },
    Range { from: '𦵫', to: '𦵫', mapping: Mapped("𦵫") },
    Range { from: '𦳕', to: '𦳕', mapping: Mapped("𦳕") },
    Range { from: '䔫', to: '䔫', mapping: Mapped("䔫") },
    Range { from: '蓱', to: '蓱', mapping: Mapped("蓱") },
    Range { from: '蓳', to: '蓳', mapping: Mapped("蓳") },
    Range { from: '蔖', to: '蔖', mapping: Mapped("蔖") },
    Range { from: '𧏊', to: '𧏊', mapping: Mapped("𧏊") },
    Range { from: '蕤', to: '蕤', mapping: Mapped("蕤") },
    Range { from: '𦼬', to: '𦼬', mapping: Mapped("𦼬") },
    Range { from: '䕝', to: '䕝', mapping: Mapped("䕝") },
    Range { from: '䕡', to: '䕡', mapping: Mapped("䕡") },
    Range { from: '𦾱', to: '𦾱', mapping: Mapped("𦾱") },
    Range { from: '𧃒', to: '𧃒', mapping: Mapped("𧃒") },
    Range { from: '䕫', to: '䕫', mapping: Mapped("䕫") },
    Range { from: '虐', to: '虐', mapping: Mapped("虐") },
    Range { from: '虜', to: '虜', mapping: Mapped("虜") },
    Range { from: '虧', to: '虧', mapping: Mapped("虧") },
    Range { from: '虩', to: '虩', mapping: Mapped("虩") },
    Range { from: '蚩', to: '蚩', mapping: Mapped("蚩") },
    Range { from: '蚈', to: '蚈', mapping: Mapped("蚈") },
    Range { from: '蜎', to: '蜎', mapping: Mapped("蜎") },
    Range { from: '蛢', to: '蛢', mapping: Mapped("蛢") },
    Range { from: '蝹', to: '蝹', mapping: Mapped("蝹") },
    Range { from: '蜨', to: '蜨', mapping: Mapped("蜨") },
    Range { from: '蝫', to: '蝫', mapping: Mapped("蝫") },
    Range { from: '螆', to: '螆', mapping: Mapped("螆") },
    Range { from: '䗗', to: '䗗', mapping: Disallowed },
    Range { from: '蟡', to: '蟡', mapping: Mapped("蟡") },
    Range { from: '蠁', to: '蠁', mapping: Mapped("蠁") },
    Range { from: '䗹', to: '䗹', mapping: Mapped("䗹") },
    Range { from: '衠', to: '衠', mapping: Mapped("衠") },
    Range { from: '衣', to: '衣', mapping: Mapped("衣") },
    Range { from: '𧙧', to: '𧙧', mapping: Mapped("𧙧") },
    Range { from: '裗', to: '裗', mapping: Mapped("裗") },
    Range { from: '裞', to: '裞', mapping: Mapped("裞") },
    Range { from: '䘵', to: '䘵', mapping: Mapped("䘵") },
    Range { from: '裺', to: '裺', mapping: Mapped("裺") },
    Range { from: '㒻', to: '㒻', mapping: Mapped("㒻") },
    Range { from: '𧢮', to: '𧢮', mapping: Mapped("𧢮") },
    Range { from: '𧥦', to: '𧥦', mapping: Mapped("𧥦") },
    Range { from: '䚾', to: '䚾', mapping: Mapped("䚾") },
    Range { from: '䛇', to: '䛇', mapping: Mapped("䛇") },
    Range { from: '誠', to: '誠', mapping: Mapped("誠") },
    Range { from: '諭', to: '諭', mapping: Mapped("諭") },
    Range { from: '變', to: '變', mapping: Mapped("變") },
    Range { from: '豕', to: '豕', mapping: Mapped("豕") },
    Range { from: '𧲨', to: '𧲨', mapping: Mapped("𧲨") },
    Range { from: '貫', to: '貫', mapping: Mapped("貫") },
    Range { from: '賁', to: '賁', mapping: Mapped("賁") },
    Range { from: '贛', to: '贛', mapping: Mapped("贛") },
    Range { from: '起', to: '起', mapping: Mapped("起") },
    Range { from: '𧼯', to: '𧼯', mapping: Mapped("𧼯") },
    Range { from: '𠠄', to: '𠠄', mapping: Mapped("𠠄") },
    Range { from: '跋', to: '跋', mapping: Mapped("跋") },
    Range { from: '趼', to: '趼', mapping: Mapped("趼") },
    Range { from: '跰', to: '跰', mapping: Mapped("跰") },
    Range { from: '𠣞', to: '𠣞', mapping: Mapped("𠣞") },
    Range { from: '軔', to: '軔', mapping: Mapped("軔") },
    Range { from: '輸', to: '輸', mapping: Mapped("輸") },
    Range { from: '𨗒', to: '𨗒', mapping: Mapped("𨗒") },
    Range { from: '𨗭', to: '𨗭', mapping: Mapped("𨗭") },
    Range { from: '邔', to: '邔', mapping: Mapped("邔") },
    Range { from: '郱', to: '郱', mapping: Mapped("郱") },
    Range { from: '鄑', to: '鄑', mapping: Mapped("鄑") },
    Range { from: '𨜮', to: '𨜮', mapping: Mapped("𨜮") },
    Range { from: '鄛', to: '鄛', mapping: Mapped("鄛") },
    Range { from: '鈸', to: '鈸', mapping: Mapped("鈸") },
    Range { from: '鋗', to: '鋗', mapping: Mapped("鋗") },
    Range { from: '鋘', to: '鋘', mapping: Mapped("鋘") },
    Range { from: '鉼', to: '鉼', mapping: Mapped("鉼") },
    Range { from: '鏹', to: '鏹', mapping: Mapped("鏹") },
    Range { from: '鐕', to: '鐕', mapping: Mapped("鐕") },
    Range { from: '𨯺', to: '𨯺', mapping: Mapped("𨯺") },
    Range { from: '開', to: '開', mapping: Mapped("開") },
    Range { from: '䦕', to: '䦕', mapping: Mapped("䦕") },
    Range { from: '閷', to: '閷', mapping: Mapped("閷") },
    Range { from: '𨵷', to: '𨵷', mapping: Mapped("𨵷") },
    Range { from: '䧦', to: '䧦', mapping: Mapped("䧦") },
    Range { from: '雃', to: '雃', mapping: Mapped("雃") },
    Range { from: '嶲', to: '嶲', mapping: Mapped("嶲") },
    Range { from: '霣', to: '霣', mapping: Mapped("霣") },
    Range { from: '𩅅', to: '𩅅', mapping: Mapped("𩅅") },
    Range { from: '𩈚', to: '𩈚', mapping: Mapped("𩈚") },
    Range { from: '䩮', to: '䩮', mapping: Mapped("䩮") },
    Range { from: '䩶', to: '䩶', mapping: Mapped("䩶") },
    Range { from: '韠', to: '韠', mapping: Mapped("韠") },
    Range { from: '𩐊', to: '𩐊', mapping: Mapped("𩐊") },
    Range { from: '䪲', to: '䪲', mapping: Mapped("䪲") },
    Range { from: '𩒖', to: '𩒖', mapping: Mapped("𩒖") },
    Range { from: '頋', to: '頋', mapping: Mapped("頋") },
    Range { from: '頩', to: '頩', mapping: Mapped("頩") },
    Range { from: '𩖶', to: '𩖶', mapping: Mapped("𩖶") },
    Range { from: '飢', to: '飢', mapping: Mapped("飢") },
    Range { from: '䬳', to: '䬳', mapping: Mapped("䬳") },
    Range { from: '餩', to: '餩', mapping: Mapped("餩") },
    Range { from: '馧', to: '馧', mapping: Mapped("馧") },
    Range { from: '駂', to: '駂', mapping: Mapped("駂") },
    Range { from: '駾', to: '駾', mapping: Mapped("駾") },
    Range { from: '䯎', to: '䯎', mapping: Mapped("䯎") },
    Range { from: '𩬰', to: '𩬰', mapping: Mapped("𩬰") },
    Range { from: '鬒', to: '鬒', mapping: Mapped("鬒") },
    Range { from: '鱀', to: '鱀', mapping: Mapped("鱀") },
    Range { from: '鳽', to: '鳽', mapping: Mapped("鳽") },
    Range { from: '䳎', to: '䳎', mapping: Mapped("䳎") },
    Range { from: '䳭', to: '䳭', mapping: Mapped("䳭") },
    Range { from: '鵧', to: '鵧', mapping: Mapped("鵧") },
    Range { from: '𪃎', to: '𪃎', mapping: Mapped("𪃎") },
    Range { from: '䳸', to: '䳸', mapping: Mapped("䳸") },
    Range { from: '𪄅', to: '𪄅', mapping: Mapped("𪄅") },
    Range { from: '𪈎', to: '𪈎', mapping: Mapped("𪈎") },
    Range { from: '𪊑', to: '𪊑', mapping: Mapped("𪊑") },
    Range { from: '麻', to: '麻', mapping: Mapped("麻") },
    Range { from: '䵖', to: '䵖', mapping: Mapped("䵖") },
    Range { from: '黹', to: '黹', mapping: Mapped("黹") },
    Range { from: '黾', to: '黾', mapping: Mapped("黾") },
    Range { from: '鼅', to: '鼅', mapping: Mapped("鼅") },
    Range { from: '鼏', to: '鼏', mapping: Mapped("鼏") },
    Range { from: '鼖', to: '鼖', mapping: Mapped("鼖") },
    Range { from: '鼻', to: '鼻', mapping: Mapped("鼻") },
    Range { from: '𪘀', to: '𪘀', mapping: Mapped("𪘀") },
    Range { from: '𯨞', to: '𯿽', mapping: Disallowed },
    Range { from: '𯿾', to: '𯿿', mapping: Disallowed },
    Range { from: '𰀀', to: '𿿽', mapping: Disallowed },
    Range { from: '𿿾', to: '𿿿', mapping: Disallowed },
    Range { from: '񀀀', to: '񏿽', mapping: Disallowed },
    Range { from: '񏿾', to: '񏿿', mapping: Disallowed },
    Range { from: '񐀀', to: '񟿽', mapping: Disallowed },
    Range { from: '񟿾', to: '񟿿', mapping: Disallowed },
    Range { from: '񠀀', to: '񯿽', mapping: Disallowed },
    Range { from: '񯿾', to: '񯿿', mapping: Disallowed },
    Range { from: '񰀀', to: '񿿽', mapping: Disallowed },
    Range { from: '񿿾', to: '񿿿', mapping: Disallowed },
    Range { from: '򀀀', to: '򏿽', mapping: Disallowed },
    Range { from: '򏿾', to: '򏿿', mapping: Disallowed },
    Range { from: '򐀀', to: '򟿽', mapping: Disallowed },
    Range { from: '򟿾', to: '򟿿', mapping: Disallowed },
    Range { from: '򠀀', to: '򯿽', mapping: Disallowed },
    Range { from: '򯿾', to: '򯿿', mapping: Disallowed },
    Range { from: '򰀀', to: '򿿽', mapping: Disallowed },
    Range { from: '򿿾', to: '򿿿', mapping: Disallowed },
    Range { from: '󀀀', to: '󏿽', mapping: Disallowed },
    Range { from: '󏿾', to: '󏿿', mapping: Disallowed },
    Range { from: '󐀀', to: '󟿽', mapping: Disallowed },
    Range { from: '󟿾', to: '󟿿', mapping: Disallowed },
    Range { from: '󠀀', to: '󠀀', mapping: Disallowed },
    Range { from: '󠀁', to: '󠀁', mapping: Disallowed },
    Range { from: '󠀂', to: '󠀟', mapping: Disallowed },
    Range { from: '󠀠', to: '󠁿', mapping: Disallowed },
    Range { from: '󠂀', to: '󠃿', mapping: Disallowed },
    Range { from: '󠄀', to: '󠇯', mapping: Ignored },
    Range { from: '󠇰', to: '󯿽', mapping: Disallowed },
    Range { from: '󯿾', to: '󯿿', mapping: Disallowed },
    Range { from: '󰀀', to: '󿿽', mapping: Disallowed },
    Range { from: '󿿾', to: '󿿿', mapping: Disallowed },
    Range { from: '􀀀', to: '􏿽', mapping: Disallowed },
    Range { from: '􏿾', to: '􏿿', mapping: Disallowed },
];
