#!/bin/sh
# Sometimes, by the time we get around to packaging cargo, the crates.io
# ecosystem has moved on from the versions that cargo-vendor *would have* used
# when that version of cargo was released. This places a lot of maintenance
# burden on us, since it requires us to keep debcargo-conf always up-to-date.
#
# This script allows us to force cargo-vendor to use old versions of dependency
# crates, that better match our debcargo-conf patches, as well as the versions
# of crates used when a particular version of cargo was actually released.
#
# Example:
# cargo update -p filetime --precise 0.2.12
#

# Drop the "vendored" feature since we patch it out of debcargo
sed -i /vendored/d Cargo.toml

# cargo 0.57 can't download the newest libgit2-sys version
cargo update -p git2@0.15.0 -p libgit2-sys@0.14.0+1.5.0 -p git2-curl@0.16.0
sed -i 's/git2 = "0.14.2"/git2 = "0.15.0"/' Cargo.toml
sed -i 's/git2 = "0.14.2"/git2 = "0.15.0"/' crates/cargo-test-support/Cargo.toml
sed -i 's/libgit2-sys = "0.13.2"/libgit2-sys = "0.14.0+1.5.0"/' Cargo.toml
sed -i 's/git2-curl = "0.15.0"/git2-curl = "0.16.0"/' Cargo.toml

# avoid pulling in windows-sys for now
# cargo update -p schannel --precise 0.1.19
