#!/bin/sh
# Sometimes, by the time we get around to packaging cargo, the crates.io
# ecosystem has moved on from the versions that cargo-vendor *would have* used
# when that version of cargo was released. This places a lot of maintenance
# burden on us, since it requires us to keep debcargo-conf always up-to-date.
#
# This script allows us to force cargo-vendor to use old versions of dependency
# crates, that better match our debcargo-conf patches, as well as the versions
# of crates used when a particular version of cargo was actually released.
#
# Example:
# cargo update -p filetime --precise 0.2.12
#

# Drop the "vendored" feature since we patch it out of debcargo
sed -i /vendored/d Cargo.toml

# Downgrade the git2-rs crates. Cannot be done via cargo update because it spans
# multiple crates
sed -i 's/git2 = "0.14.2"/git2 = "0.13.25"/' Cargo.toml
sed -i 's/libgit2-sys = ".*"/libgit2-sys = "^0.12"/' Cargo.toml
sed -i 's/git2-curl = ".*"/git2-curl = "^0.14.1"/' Cargo.toml
sed -i 's/git2 = "0.14.2"/git2 = "0.13.25"/' crates/cargo-test-support/Cargo.toml
