// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
//! This module defines the 32-Bit Windows Device I/O control codes.
//123
pub const FILE_DEVICE_BEEP: ::DWORD = 0x00000001;
pub const FILE_DEVICE_CD_ROM: ::DWORD = 0x00000002;
pub const FILE_DEVICE_CD_ROM_FILE_SYSTEM: ::DWORD = 0x00000003;
pub const FILE_DEVICE_CONTROLLER: ::DWORD = 0x00000004;
pub const FILE_DEVICE_DATALINK: ::DWORD = 0x00000005;
pub const FILE_DEVICE_DFS: ::DWORD = 0x00000006;
pub const FILE_DEVICE_DISK: ::DWORD = 0x00000007;
pub const FILE_DEVICE_DISK_FILE_SYSTEM: ::DWORD = 0x00000008;
pub const FILE_DEVICE_FILE_SYSTEM: ::DWORD = 0x00000009;
pub const FILE_DEVICE_INPORT_PORT: ::DWORD = 0x0000000a;
pub const FILE_DEVICE_KEYBOARD: ::DWORD = 0x0000000b;
pub const FILE_DEVICE_MAILSLOT: ::DWORD = 0x0000000c;
pub const FILE_DEVICE_MIDI_IN: ::DWORD = 0x0000000d;
pub const FILE_DEVICE_MIDI_OUT: ::DWORD = 0x0000000e;
pub const FILE_DEVICE_MOUSE: ::DWORD = 0x0000000f;
pub const FILE_DEVICE_MULTI_UNC_PROVIDER: ::DWORD = 0x00000010;
pub const FILE_DEVICE_NAMED_PIPE: ::DWORD = 0x00000011;
pub const FILE_DEVICE_NETWORK: ::DWORD = 0x00000012;
pub const FILE_DEVICE_NETWORK_BROWSER: ::DWORD = 0x00000013;
pub const FILE_DEVICE_NETWORK_FILE_SYSTEM: ::DWORD = 0x00000014;
pub const FILE_DEVICE_NULL: ::DWORD = 0x00000015;
pub const FILE_DEVICE_PARALLEL_PORT: ::DWORD = 0x00000016;
pub const FILE_DEVICE_PHYSICAL_NETCARD: ::DWORD = 0x00000017;
pub const FILE_DEVICE_PRINTER: ::DWORD = 0x00000018;
pub const FILE_DEVICE_SCANNER: ::DWORD = 0x00000019;
pub const FILE_DEVICE_SERIAL_MOUSE_PORT: ::DWORD = 0x0000001a;
pub const FILE_DEVICE_SERIAL_PORT: ::DWORD = 0x0000001b;
pub const FILE_DEVICE_SCREEN: ::DWORD = 0x0000001c;
pub const FILE_DEVICE_SOUND: ::DWORD = 0x0000001d;
pub const FILE_DEVICE_STREAMS: ::DWORD = 0x0000001e;
pub const FILE_DEVICE_TAPE: ::DWORD = 0x0000001f;
pub const FILE_DEVICE_TAPE_FILE_SYSTEM: ::DWORD = 0x00000020;
pub const FILE_DEVICE_TRANSPORT: ::DWORD = 0x00000021;
pub const FILE_DEVICE_UNKNOWN: ::DWORD = 0x00000022;
pub const FILE_DEVICE_VIDEO: ::DWORD = 0x00000023;
pub const FILE_DEVICE_VIRTUAL_DISK: ::DWORD = 0x00000024;
pub const FILE_DEVICE_WAVE_IN: ::DWORD = 0x00000025;
pub const FILE_DEVICE_WAVE_OUT: ::DWORD = 0x00000026;
pub const FILE_DEVICE_8042_PORT: ::DWORD = 0x00000027;
pub const FILE_DEVICE_NETWORK_REDIRECTOR: ::DWORD = 0x00000028;
pub const FILE_DEVICE_BATTERY: ::DWORD = 0x00000029;
pub const FILE_DEVICE_BUS_EXTENDER: ::DWORD = 0x0000002a;
pub const FILE_DEVICE_MODEM: ::DWORD = 0x0000002b;
pub const FILE_DEVICE_VDM: ::DWORD = 0x0000002c;
pub const FILE_DEVICE_MASS_STORAGE: ::DWORD = 0x0000002d;
pub const FILE_DEVICE_SMB: ::DWORD = 0x0000002e;
pub const FILE_DEVICE_KS: ::DWORD = 0x0000002f;
pub const FILE_DEVICE_CHANGER: ::DWORD = 0x00000030;
pub const FILE_DEVICE_SMARTCARD: ::DWORD = 0x00000031;
pub const FILE_DEVICE_ACPI: ::DWORD = 0x00000032;
pub const FILE_DEVICE_DVD: ::DWORD = 0x00000033;
pub const FILE_DEVICE_FULLSCREEN_VIDEO: ::DWORD = 0x00000034;
pub const FILE_DEVICE_DFS_FILE_SYSTEM: ::DWORD = 0x00000035;
pub const FILE_DEVICE_DFS_VOLUME: ::DWORD = 0x00000036;
pub const FILE_DEVICE_SERENUM: ::DWORD = 0x00000037;
pub const FILE_DEVICE_TERMSRV: ::DWORD = 0x00000038;
pub const FILE_DEVICE_KSEC: ::DWORD = 0x00000039;
pub const FILE_DEVICE_FIPS: ::DWORD = 0x0000003A;
pub const FILE_DEVICE_INFINIBAND: ::DWORD = 0x0000003B;
pub const FILE_DEVICE_VMBUS: ::DWORD = 0x0000003E;
pub const FILE_DEVICE_CRYPT_PROVIDER: ::DWORD = 0x0000003F;
pub const FILE_DEVICE_WPD: ::DWORD = 0x00000040;
pub const FILE_DEVICE_BLUETOOTH: ::DWORD = 0x00000041;
pub const FILE_DEVICE_MT_COMPOSITE: ::DWORD = 0x00000042;
pub const FILE_DEVICE_MT_TRANSPORT: ::DWORD = 0x00000043;
pub const FILE_DEVICE_BIOMETRIC: ::DWORD = 0x00000044;
pub const FILE_DEVICE_PMI: ::DWORD = 0x00000045;
pub const FILE_DEVICE_EHSTOR: ::DWORD = 0x00000046;
pub const FILE_DEVICE_DEVAPI: ::DWORD = 0x00000047;
pub const FILE_DEVICE_GPIO: ::DWORD = 0x00000048;
pub const FILE_DEVICE_USBEX: ::DWORD = 0x00000049;
pub const FILE_DEVICE_CONSOLE: ::DWORD = 0x00000050;
pub const FILE_DEVICE_NFP: ::DWORD = 0x00000051;
pub const FILE_DEVICE_SYSENV: ::DWORD = 0x00000052;
pub const FILE_DEVICE_VIRTUAL_BLOCK: ::DWORD = 0x00000053;
pub const FILE_DEVICE_POINT_OF_SERVICE: ::DWORD = 0x00000054;
//224
pub const METHOD_BUFFERED: ::DWORD = 0;
pub const METHOD_IN_DIRECT: ::DWORD = 1;
pub const METHOD_OUT_DIRECT: ::DWORD = 2;
pub const METHOD_NEITHER: ::DWORD = 3;
//253
pub const FILE_ANY_ACCESS: ::DWORD = 0;
pub const FILE_SPECIAL_ACCESS: ::DWORD = FILE_ANY_ACCESS;
pub const FILE_READ_ACCESS: ::DWORD = 0x0001;
pub const FILE_WRITE_ACCESS: ::DWORD = 0x0002;
//4690
pub const FSCTL_REQUEST_OPLOCK_LEVEL_1: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 0, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_REQUEST_OPLOCK_LEVEL_2: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 1, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_REQUEST_BATCH_OPLOCK: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 2, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_OPLOCK_BREAK_ACKNOWLEDGE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 3, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_OPBATCH_ACK_CLOSE_PENDING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 4, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_OPLOCK_BREAK_NOTIFY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 5, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_LOCK_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 6, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_UNLOCK_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 7, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DISMOUNT_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 8, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_IS_VOLUME_MOUNTED: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 10, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_IS_PATHNAME_VALID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 11, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_MARK_VOLUME_DIRTY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 12, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_RETRIEVAL_POINTERS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 14, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_GET_COMPRESSION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 15, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_COMPRESSION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 16, METHOD_BUFFERED, ::FILE_READ_DATA | ::FILE_WRITE_DATA);
pub const FSCTL_SET_BOOTLOADER_ACCESSED: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 19, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_MARK_AS_SYSTEM_HIVE: ::DWORD = FSCTL_SET_BOOTLOADER_ACCESSED;
pub const FSCTL_OPLOCK_BREAK_ACK_NO_2: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 20, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_INVALIDATE_VOLUMES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 21, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_FAT_BPB: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 22, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_REQUEST_FILTER_OPLOCK: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 23, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_FILESYSTEM_GET_STATISTICS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 24, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_NTFS_VOLUME_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 25, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_NTFS_FILE_RECORD: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 26, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_VOLUME_BITMAP: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 27, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_GET_RETRIEVAL_POINTERS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 28, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_MOVE_FILE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 29, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_IS_VOLUME_DIRTY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 30, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_ALLOW_EXTENDED_DASD_IO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 32, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_FIND_FILES_BY_SID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 35, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_SET_OBJECT_ID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 38, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_GET_OBJECT_ID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 39, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DELETE_OBJECT_ID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 40, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_SET_REPARSE_POINT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 41, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_GET_REPARSE_POINT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 42, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DELETE_REPARSE_POINT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 43, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_ENUM_USN_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 44, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_SECURITY_ID_CHECK: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 45, METHOD_NEITHER, ::FILE_READ_DATA);
pub const FSCTL_READ_USN_JOURNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 46, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_SET_OBJECT_ID_EXTENDED: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 47, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_CREATE_OR_GET_OBJECT_ID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 48, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_SPARSE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 49, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_SET_ZERO_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 50, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_QUERY_ALLOCATED_RANGES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 51, METHOD_NEITHER, ::FILE_READ_DATA);
pub const FSCTL_ENABLE_UPGRADE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 52, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_SET_ENCRYPTION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 53, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_ENCRYPTION_FSCTL_IO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 54, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_WRITE_RAW_ENCRYPTED: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 55, METHOD_NEITHER, FILE_SPECIAL_ACCESS);
pub const FSCTL_READ_RAW_ENCRYPTED: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 56, METHOD_NEITHER, FILE_SPECIAL_ACCESS);
pub const FSCTL_CREATE_USN_JOURNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 57, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_READ_FILE_USN_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 58, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_WRITE_USN_CLOSE_RECORD: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 59, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_EXTEND_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 60, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_USN_JOURNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 61, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DELETE_USN_JOURNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 62, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_MARK_HANDLE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 63, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SIS_COPYFILE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 64, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SIS_LINK_FILES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 65, METHOD_BUFFERED, ::FILE_READ_DATA | ::FILE_WRITE_DATA);
pub const FSCTL_RECALL_FILE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 69, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_READ_FROM_PLEX: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 71, METHOD_OUT_DIRECT, ::FILE_READ_DATA);
pub const FSCTL_FILE_PREFETCH: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 72, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_MAKE_MEDIA_COMPATIBLE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 76, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_SET_DEFECT_MANAGEMENT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 77, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_QUERY_SPARING_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 78, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_ON_DISK_VOLUME_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 79, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_VOLUME_COMPRESSION_STATE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 80, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_TXFS_MODIFY_RM: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 81, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_QUERY_RM_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 82, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_TXFS_ROLLFORWARD_REDO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 84, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_ROLLFORWARD_UNDO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 85, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_START_RM: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 86, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_SHUTDOWN_RM: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 87, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_READ_BACKUP_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 88, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_TXFS_WRITE_BACKUP_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 89, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_CREATE_SECONDARY_RM: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 90, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_GET_METADATA_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 91, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_TXFS_GET_TRANSACTED_VERSION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 92, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_TXFS_SAVEPOINT_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 94, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_CREATE_MINIVERSION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 95, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_TXFS_TRANSACTION_ACTIVE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 99, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_SET_ZERO_ON_DEALLOCATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 101, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_SET_REPAIR: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 102, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_REPAIR: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 103, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_WAIT_FOR_REPAIR: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 104, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_INITIATE_REPAIR: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 106, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSC_INTERNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 107, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_SHRINK_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 108, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_SET_SHORT_NAME_BEHAVIOR: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 109, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DFSR_SET_GHOST_HANDLE_STATE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 110, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_TXFS_LIST_TRANSACTION_LOCKED_FILES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 120, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_TXFS_LIST_TRANSACTIONS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 121, METHOD_BUFFERED, ::FILE_READ_DATA);
pub const FSCTL_QUERY_PAGEFILE_ENCRYPTION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 122, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_RESET_VOLUME_ALLOCATION_HINTS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 123, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_DEPENDENT_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 124, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SD_GLOBAL_CHANGE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 125, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_TXFS_READ_BACKUP_INFORMATION2: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 126, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_LOOKUP_STREAM_FROM_CLUSTER: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 127, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_TXFS_WRITE_BACKUP_INFORMATION2: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 128, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_FILE_TYPE_NOTIFICATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 129, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_FILE_LEVEL_TRIM: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 130, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_GET_BOOT_AREA_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 140, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_RETRIEVAL_POINTER_BASE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 141, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_PERSISTENT_VOLUME_STATE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 142, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_PERSISTENT_VOLUME_STATE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 143, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_REQUEST_OPLOCK: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 144, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_TUNNEL_REQUEST: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 145, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_IS_CSV_FILE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 146, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_FILE_SYSTEM_RECOGNITION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 147, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_GET_VOLUME_PATH_NAME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 148, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_GET_VOLUME_NAME_FOR_VOLUME_MOUNT_POINT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 149, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_GET_VOLUME_PATH_NAMES_FOR_VOLUME_NAME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 150, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_IS_FILE_ON_CSV_VOLUME: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 151, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CORRUPTION_HANDLING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 152, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_OFFLOAD_READ: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 153, METHOD_BUFFERED, FILE_READ_ACCESS);
pub const FSCTL_OFFLOAD_WRITE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 154, METHOD_BUFFERED, FILE_WRITE_ACCESS);
pub const FSCTL_CSV_INTERNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 155, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_PURGE_FAILURE_MODE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 156, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_FILE_LAYOUT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 157, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_IS_VOLUME_OWNED_BYCSVFS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 158, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_INTEGRITY_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 159, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_INTEGRITY_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 160, METHOD_BUFFERED, ::FILE_READ_DATA | ::FILE_WRITE_DATA);
pub const FSCTL_QUERY_FILE_REGIONS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 161, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DEDUP_FILE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 165, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DEDUP_QUERY_FILE_HASHES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 166, METHOD_NEITHER, ::FILE_READ_DATA);
pub const FSCTL_DEDUP_QUERY_RANGE_STATE: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 167, METHOD_NEITHER, ::FILE_READ_DATA);
pub const FSCTL_DEDUP_QUERY_REPARSE_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 168, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_RKF_INTERNAL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 171, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_SCRUB_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 172, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_REPAIR_COPIES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 173, METHOD_BUFFERED, ::FILE_READ_DATA | ::FILE_WRITE_DATA);
pub const FSCTL_DISABLE_LOCAL_BUFFERING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 174, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_MGMT_LOCK: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 175, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_QUERY_DOWN_LEVEL_FILE_SYSTEM_CHARACTERISTICS: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 176, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_ADVANCE_FILE_ID: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 177, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_SYNC_TUNNEL_REQUEST: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 178, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_QUERY_VETO_FILE_DIRECT_IO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 179, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_WRITE_USN_REASON: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 180, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_CONTROL: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 181, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_GET_REFS_VOLUME_DATA: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 182, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_CSV_H_BREAKING_SYNC_TUNNEL_REQUEST: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 185, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_STORAGE_CLASSES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 187, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_REGION_INFO: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 188, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_USN_TRACK_MODIFIED_RANGES: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 189, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_QUERY_SHARED_VIRTUAL_DISK_SUPPORT: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 192, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SVHDX_SYNC_TUNNEL_REQUEST: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 193, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SVHDX_SET_INITIATOR_INFORMATION: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 194, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_SET_EXTERNAL_BACKING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 195, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_GET_EXTERNAL_BACKING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 196, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_DELETE_EXTERNAL_BACKING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 197, METHOD_BUFFERED, FILE_SPECIAL_ACCESS);
pub const FSCTL_ENUM_EXTERNAL_BACKING: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 198, METHOD_BUFFERED, FILE_ANY_ACCESS);
pub const FSCTL_ENUM_OVERLAY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 199, METHOD_NEITHER, FILE_ANY_ACCESS);
pub const FSCTL_ADD_OVERLAY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 204, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_REMOVE_OVERLAY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 205, METHOD_BUFFERED, ::FILE_WRITE_DATA);
pub const FSCTL_UPDATE_OVERLAY: ::DWORD = CTL_CODE!(FILE_DEVICE_FILE_SYSTEM, 206, METHOD_BUFFERED, ::FILE_WRITE_DATA);
