// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
//! error code definitions for the Win32 API functions
pub const FACILITY_XPS: HRESULT = 82;
pub const FACILITY_XAML: HRESULT = 43;
pub const FACILITY_USN: HRESULT = 129;
pub const FACILITY_BLBUI: HRESULT = 128;
pub const FACILITY_SPP: HRESULT = 256;
pub const FACILITY_WSB_ONLINE: HRESULT = 133;
pub const FACILITY_DLS: HRESULT = 153;
pub const FACILITY_BLB_CLI: HRESULT = 121;
pub const FACILITY_BLB: HRESULT = 120;
pub const FACILITY_WSBAPP: HRESULT = 122;
pub const FACILITY_WPN: HRESULT = 62;
pub const FACILITY_WMAAECMA: HRESULT = 1996;
pub const FACILITY_WINRM: HRESULT = 51;
pub const FACILITY_WINPE: HRESULT = 61;
pub const FACILITY_WINDOWSUPDATE: HRESULT = 36;
pub const FACILITY_WINDOWS_STORE: HRESULT = 63;
pub const FACILITY_WINDOWS_SETUP: HRESULT = 48;
pub const FACILITY_WINDOWS_DEFENDER: HRESULT = 80;
pub const FACILITY_WINDOWS_CE: HRESULT = 24;
pub const FACILITY_WINDOWS: HRESULT = 8;
pub const FACILITY_WINCODEC_DWRITE_DWM: HRESULT = 2200;
pub const FACILITY_WIA: HRESULT = 33;
pub const FACILITY_WER: HRESULT = 27;
pub const FACILITY_WEP: HRESULT = 2049;
pub const FACILITY_WEB_SOCKET: HRESULT = 886;
pub const FACILITY_WEB: HRESULT = 885;
pub const FACILITY_USERMODE_VOLSNAP: HRESULT = 130;
pub const FACILITY_USERMODE_VOLMGR: HRESULT = 56;
pub const FACILITY_VISUALCPP: HRESULT = 109;
pub const FACILITY_USERMODE_VIRTUALIZATION: HRESULT = 55;
pub const FACILITY_USERMODE_VHD: HRESULT = 58;
pub const FACILITY_URT: HRESULT = 19;
pub const FACILITY_UMI: HRESULT = 22;
pub const FACILITY_UI: HRESULT = 42;
pub const FACILITY_TPM_SOFTWARE: HRESULT = 41;
pub const FACILITY_TPM_SERVICES: HRESULT = 40;
pub const FACILITY_TIERING: HRESULT = 131;
pub const FACILITY_SYNCENGINE: HRESULT = 2050;
pub const FACILITY_SXS: HRESULT = 23;
pub const FACILITY_STORAGE: HRESULT = 3;
pub const FACILITY_STATE_MANAGEMENT: HRESULT = 34;
pub const FACILITY_SSPI: HRESULT = 9;
pub const FACILITY_USERMODE_SPACES: HRESULT = 231;
pub const FACILITY_SOS: HRESULT = 160;
pub const FACILITY_SCARD: HRESULT = 16;
pub const FACILITY_SHELL: HRESULT = 39;
pub const FACILITY_SETUPAPI: HRESULT = 15;
pub const FACILITY_SECURITY: HRESULT = 9;
pub const FACILITY_SDIAG: HRESULT = 60;
pub const FACILITY_USERMODE_SDBUS: HRESULT = 2305;
pub const FACILITY_RPC: HRESULT = 1;
pub const FACILITY_RESTORE: HRESULT = 256;
pub const FACILITY_SCRIPT: HRESULT = 112;
pub const FACILITY_PARSE: HRESULT = 113;
pub const FACILITY_RAS: HRESULT = 83;
pub const FACILITY_POWERSHELL: HRESULT = 84;
pub const FACILITY_PLA: HRESULT = 48;
pub const FACILITY_PIDGENX: HRESULT = 2561;
pub const FACILITY_P2P_INT: HRESULT = 98;
pub const FACILITY_P2P: HRESULT = 99;
pub const FACILITY_OPC: HRESULT = 81;
pub const FACILITY_ONLINE_ID: HRESULT = 134;
pub const FACILITY_WIN32: HRESULT = 7;
pub const FACILITY_CONTROL: HRESULT = 10;
pub const FACILITY_WEBSERVICES: HRESULT = 61;
pub const FACILITY_NULL: HRESULT = 0;
pub const FACILITY_NDIS: HRESULT = 52;
pub const FACILITY_NAP: HRESULT = 39;
pub const FACILITY_MOBILE: HRESULT = 1793;
pub const FACILITY_METADIRECTORY: HRESULT = 35;
pub const FACILITY_MSMQ: HRESULT = 14;
pub const FACILITY_MEDIASERVER: HRESULT = 13;
pub const FACILITY_MBN: HRESULT = 84;
pub const FACILITY_LINGUISTIC_SERVICES: HRESULT = 305;
pub const FACILITY_LEAP: HRESULT = 2184;
pub const FACILITY_JSCRIPT: HRESULT = 2306;
pub const FACILITY_INTERNET: HRESULT = 12;
pub const FACILITY_ITF: HRESULT = 4;
pub const FACILITY_INPUT: HRESULT = 64;
pub const FACILITY_USERMODE_HYPERVISOR: HRESULT = 53;
pub const FACILITY_ACCELERATOR: HRESULT = 1536;
pub const FACILITY_HTTP: HRESULT = 25;
pub const FACILITY_GRAPHICS: HRESULT = 38;
pub const FACILITY_FWP: HRESULT = 50;
pub const FACILITY_FVE: HRESULT = 49;
pub const FACILITY_USERMODE_FILTER_MANAGER: HRESULT = 31;
pub const FACILITY_EAS: HRESULT = 85;
pub const FACILITY_EAP: HRESULT = 66;
pub const FACILITY_DXGI_DDI: HRESULT = 2171;
pub const FACILITY_DXGI: HRESULT = 2170;
pub const FACILITY_DPLAY: HRESULT = 21;
pub const FACILITY_DMSERVER: HRESULT = 256;
pub const FACILITY_DISPATCH: HRESULT = 2;
pub const FACILITY_DIRECTORYSERVICE: HRESULT = 37;
pub const FACILITY_DIRECTMUSIC: HRESULT = 2168;
pub const FACILITY_DIRECT3D11: HRESULT = 2172;
pub const FACILITY_DIRECT3D10: HRESULT = 2169;
pub const FACILITY_DIRECT2D: HRESULT = 2201;
pub const FACILITY_DAF: HRESULT = 100;
pub const FACILITY_DEPLOYMENT_SERVICES_UTIL: HRESULT = 260;
pub const FACILITY_DEPLOYMENT_SERVICES_TRANSPORT_MANAGEMENT: HRESULT = 272;
pub const FACILITY_DEPLOYMENT_SERVICES_TFTP: HRESULT = 264;
pub const FACILITY_DEPLOYMENT_SERVICES_PXE: HRESULT = 263;
pub const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_SERVER: HRESULT = 289;
pub const FACILITY_DEPLOYMENT_SERVICES_MULTICAST_CLIENT: HRESULT = 290;
pub const FACILITY_DEPLOYMENT_SERVICES_MANAGEMENT: HRESULT = 259;
pub const FACILITY_DEPLOYMENT_SERVICES_IMAGING: HRESULT = 258;
pub const FACILITY_DEPLOYMENT_SERVICES_DRIVER_PROVISIONING: HRESULT = 278;
pub const FACILITY_DEPLOYMENT_SERVICES_SERVER: HRESULT = 257;
pub const FACILITY_DEPLOYMENT_SERVICES_CONTENT_PROVIDER: HRESULT = 293;
pub const FACILITY_DEPLOYMENT_SERVICES_BINLSVC: HRESULT = 261;
pub const FACILITY_DEFRAG: HRESULT = 2304;
pub const FACILITY_DEBUGGERS: HRESULT = 176;
pub const FACILITY_CONFIGURATION: HRESULT = 33;
pub const FACILITY_COMPLUS: HRESULT = 17;
pub const FACILITY_USERMODE_COMMONLOG: HRESULT = 26;
pub const FACILITY_CMI: HRESULT = 54;
pub const FACILITY_CERT: HRESULT = 11;
pub const FACILITY_BLUETOOTH_ATT: HRESULT = 101;
pub const FACILITY_BCD: HRESULT = 57;
pub const FACILITY_BACKGROUNDCOPY: HRESULT = 32;
pub const FACILITY_AUDIOSTREAMING: HRESULT = 1094;
pub const FACILITY_AUDCLNT: HRESULT = 2185;
pub const FACILITY_AUDIO: HRESULT = 102;
pub const FACILITY_ACTION_QUEUE: HRESULT = 44;
pub const FACILITY_ACS: HRESULT = 20;
pub const FACILITY_AAF: HRESULT = 18;
pub const ERROR_SUCCESS: ::DWORD = 0;
pub const NO_ERROR: ::DWORD = 0;
pub const SEC_E_OK: HRESULT = 0;
pub const ERROR_INVALID_FUNCTION: ::DWORD = 1;
pub const ERROR_FILE_NOT_FOUND: ::DWORD = 2;
pub const ERROR_PATH_NOT_FOUND: ::DWORD = 3;
pub const ERROR_TOO_MANY_OPEN_FILES: ::DWORD = 4;
pub const ERROR_ACCESS_DENIED: ::DWORD = 5;
pub const ERROR_INVALID_HANDLE: ::DWORD = 6;
pub const ERROR_ARENA_TRASHED: ::DWORD = 7;
pub const ERROR_NOT_ENOUGH_MEMORY: ::DWORD = 8;
pub const ERROR_INVALID_BLOCK: ::DWORD = 9;
pub const ERROR_BAD_ENVIRONMENT: ::DWORD = 10;
pub const ERROR_BAD_FORMAT: ::DWORD = 11;
pub const ERROR_INVALID_ACCESS: ::DWORD = 12;
pub const ERROR_INVALID_DATA: ::DWORD = 13;
pub const ERROR_OUTOFMEMORY: ::DWORD = 14;
pub const ERROR_INVALID_DRIVE: ::DWORD = 15;
pub const ERROR_CURRENT_DIRECTORY: ::DWORD = 16;
pub const ERROR_NOT_SAME_DEVICE: ::DWORD = 17;
pub const ERROR_NO_MORE_FILES: ::DWORD = 18;
pub const ERROR_WRITE_PROTECT: ::DWORD = 19;
pub const ERROR_BAD_UNIT: ::DWORD = 20;
pub const ERROR_NOT_READY: ::DWORD = 21;
pub const ERROR_BAD_COMMAND: ::DWORD = 22;
pub const ERROR_CRC: ::DWORD = 23;
pub const ERROR_BAD_LENGTH: ::DWORD = 24;
pub const ERROR_SEEK: ::DWORD = 25;
pub const ERROR_NOT_DOS_DISK: ::DWORD = 26;
pub const ERROR_SECTOR_NOT_FOUND: ::DWORD = 27;
pub const ERROR_OUT_OF_PAPER: ::DWORD = 28;
pub const ERROR_WRITE_FAULT: ::DWORD = 29;
pub const ERROR_READ_FAULT: ::DWORD = 30;
pub const ERROR_GEN_FAILURE: ::DWORD = 31;
pub const ERROR_SHARING_VIOLATION: ::DWORD = 32;
pub const ERROR_LOCK_VIOLATION: ::DWORD = 33;
pub const ERROR_WRONG_DISK: ::DWORD = 34;
pub const ERROR_SHARING_BUFFER_EXCEEDED: ::DWORD = 36;
pub const ERROR_HANDLE_EOF: ::DWORD = 38;
pub const ERROR_HANDLE_DISK_FULL: ::DWORD = 39;
pub const ERROR_NOT_SUPPORTED: ::DWORD = 50;
pub const ERROR_REM_NOT_LIST: ::DWORD = 51;
pub const ERROR_DUP_NAME: ::DWORD = 52;
pub const ERROR_BAD_NETPATH: ::DWORD = 53;
pub const ERROR_NETWORK_BUSY: ::DWORD = 54;
pub const ERROR_DEV_NOT_EXIST: ::DWORD = 55;
pub const ERROR_TOO_MANY_CMDS: ::DWORD = 56;
pub const ERROR_ADAP_HDW_ERR: ::DWORD = 57;
pub const ERROR_BAD_NET_RESP: ::DWORD = 58;
pub const ERROR_UNEXP_NET_ERR: ::DWORD = 59;
pub const ERROR_BAD_REM_ADAP: ::DWORD = 60;
pub const ERROR_PRINTQ_FULL: ::DWORD = 61;
pub const ERROR_NO_SPOOL_SPACE: ::DWORD = 62;
pub const ERROR_PRINT_CANCELLED: ::DWORD = 63;
pub const ERROR_NETNAME_DELETED: ::DWORD = 64;
pub const ERROR_NETWORK_ACCESS_DENIED: ::DWORD = 65;
pub const ERROR_BAD_DEV_TYPE: ::DWORD = 66;
pub const ERROR_BAD_NET_NAME: ::DWORD = 67;
pub const ERROR_TOO_MANY_NAMES: ::DWORD = 68;
pub const ERROR_TOO_MANY_SESS: ::DWORD = 69;
pub const ERROR_SHARING_PAUSED: ::DWORD = 70;
pub const ERROR_REQ_NOT_ACCEP: ::DWORD = 71;
pub const ERROR_REDIR_PAUSED: ::DWORD = 72;
pub const ERROR_FILE_EXISTS: ::DWORD = 80;
pub const ERROR_CANNOT_MAKE: ::DWORD = 82;
pub const ERROR_FAIL_I24: ::DWORD = 83;
pub const ERROR_OUT_OF_STRUCTURES: ::DWORD = 84;
pub const ERROR_ALREADY_ASSIGNED: ::DWORD = 85;
pub const ERROR_INVALID_PASSWORD: ::DWORD = 86;
pub const ERROR_INVALID_PARAMETER: ::DWORD = 87;
pub const ERROR_NET_WRITE_FAULT: ::DWORD = 88;
pub const ERROR_NO_PROC_SLOTS: ::DWORD = 89;
pub const ERROR_TOO_MANY_SEMAPHORES: ::DWORD = 100;
pub const ERROR_EXCL_SEM_ALREADY_OWNED: ::DWORD = 101;
pub const ERROR_SEM_IS_SET: ::DWORD = 102;
pub const ERROR_TOO_MANY_SEM_REQUESTS: ::DWORD = 103;
pub const ERROR_INVALID_AT_INTERRUPT_TIME: ::DWORD = 104;
pub const ERROR_SEM_OWNER_DIED: ::DWORD = 105;
pub const ERROR_SEM_USER_LIMIT: ::DWORD = 106;
pub const ERROR_DISK_CHANGE: ::DWORD = 107;
pub const ERROR_DRIVE_LOCKED: ::DWORD = 108;
pub const ERROR_BROKEN_PIPE: ::DWORD = 109;
pub const ERROR_OPEN_FAILED: ::DWORD = 110;
pub const ERROR_BUFFER_OVERFLOW: ::DWORD = 111;
pub const ERROR_DISK_FULL: ::DWORD = 112;
pub const ERROR_NO_MORE_SEARCH_HANDLES: ::DWORD = 113;
pub const ERROR_INVALID_TARGET_HANDLE: ::DWORD = 114;
pub const ERROR_INVALID_CATEGORY: ::DWORD = 117;
pub const ERROR_INVALID_VERIFY_SWITCH: ::DWORD = 118;
pub const ERROR_BAD_DRIVER_LEVEL: ::DWORD = 119;
pub const ERROR_CALL_NOT_IMPLEMENTED: ::DWORD = 120;
pub const ERROR_SEM_TIMEOUT: ::DWORD = 121;
pub const ERROR_INSUFFICIENT_BUFFER: ::DWORD = 122;
pub const ERROR_INVALID_NAME: ::DWORD = 123;
pub const ERROR_INVALID_LEVEL: ::DWORD = 124;
pub const ERROR_NO_VOLUME_LABEL: ::DWORD = 125;
pub const ERROR_MOD_NOT_FOUND: ::DWORD = 126;
pub const ERROR_PROC_NOT_FOUND: ::DWORD = 127;
pub const ERROR_WAIT_NO_CHILDREN: ::DWORD = 128;
pub const ERROR_CHILD_NOT_COMPLETE: ::DWORD = 129;
pub const ERROR_DIRECT_ACCESS_HANDLE: ::DWORD = 130;
pub const ERROR_NEGATIVE_SEEK: ::DWORD = 131;
pub const ERROR_SEEK_ON_DEVICE: ::DWORD = 132;
pub const ERROR_IS_JOIN_TARGET: ::DWORD = 133;
pub const ERROR_IS_JOINED: ::DWORD = 134;
pub const ERROR_IS_SUBSTED: ::DWORD = 135;
pub const ERROR_NOT_JOINED: ::DWORD = 136;
pub const ERROR_NOT_SUBSTED: ::DWORD = 137;
pub const ERROR_JOIN_TO_JOIN: ::DWORD = 138;
pub const ERROR_SUBST_TO_SUBST: ::DWORD = 139;
pub const ERROR_JOIN_TO_SUBST: ::DWORD = 140;
pub const ERROR_SUBST_TO_JOIN: ::DWORD = 141;
pub const ERROR_BUSY_DRIVE: ::DWORD = 142;
pub const ERROR_SAME_DRIVE: ::DWORD = 143;
pub const ERROR_DIR_NOT_ROOT: ::DWORD = 144;
pub const ERROR_DIR_NOT_EMPTY: ::DWORD = 145;
pub const ERROR_IS_SUBST_PATH: ::DWORD = 146;
pub const ERROR_IS_JOIN_PATH: ::DWORD = 147;
pub const ERROR_PATH_BUSY: ::DWORD = 148;
pub const ERROR_IS_SUBST_TARGET: ::DWORD = 149;
pub const ERROR_SYSTEM_TRACE: ::DWORD = 150;
pub const ERROR_INVALID_EVENT_COUNT: ::DWORD = 151;
pub const ERROR_TOO_MANY_MUXWAITERS: ::DWORD = 152;
pub const ERROR_INVALID_LIST_FORMAT: ::DWORD = 153;
pub const ERROR_LABEL_TOO_LONG: ::DWORD = 154;
pub const ERROR_TOO_MANY_TCBS: ::DWORD = 155;
pub const ERROR_SIGNAL_REFUSED: ::DWORD = 156;
pub const ERROR_DISCARDED: ::DWORD = 157;
pub const ERROR_NOT_LOCKED: ::DWORD = 158;
pub const ERROR_BAD_THREADID_ADDR: ::DWORD = 159;
pub const ERROR_BAD_ARGUMENTS: ::DWORD = 160;
pub const ERROR_BAD_PATHNAME: ::DWORD = 161;
pub const ERROR_SIGNAL_PENDING: ::DWORD = 162;
pub const ERROR_MAX_THRDS_REACHED: ::DWORD = 164;
pub const ERROR_LOCK_FAILED: ::DWORD = 167;
pub const ERROR_BUSY: ::DWORD = 170;
pub const ERROR_DEVICE_SUPPORT_IN_PROGRESS: ::DWORD = 171;
pub const ERROR_CANCEL_VIOLATION: ::DWORD = 173;
pub const ERROR_ATOMIC_LOCKS_NOT_SUPPORTED: ::DWORD = 174;
pub const ERROR_INVALID_SEGMENT_NUMBER: ::DWORD = 180;
pub const ERROR_INVALID_ORDINAL: ::DWORD = 182;
pub const ERROR_ALREADY_EXISTS: ::DWORD = 183;
pub const ERROR_INVALID_FLAG_NUMBER: ::DWORD = 186;
pub const ERROR_SEM_NOT_FOUND: ::DWORD = 187;
pub const ERROR_INVALID_STARTING_CODESEG: ::DWORD = 188;
pub const ERROR_INVALID_STACKSEG: ::DWORD = 189;
pub const ERROR_INVALID_MODULETYPE: ::DWORD = 190;
pub const ERROR_INVALID_EXE_SIGNATURE: ::DWORD = 191;
pub const ERROR_EXE_MARKED_INVALID: ::DWORD = 192;
pub const ERROR_BAD_EXE_FORMAT: ::DWORD = 193;
pub const ERROR_ITERATED_DATA_EXCEEDS_64k: ::DWORD = 194;
pub const ERROR_INVALID_MINALLOCSIZE: ::DWORD = 195;
pub const ERROR_DYNLINK_FROM_INVALID_RING: ::DWORD = 196;
pub const ERROR_IOPL_NOT_ENABLED: ::DWORD = 197;
pub const ERROR_INVALID_SEGDPL: ::DWORD = 198;
pub const ERROR_AUTODATASEG_EXCEEDS_64k: ::DWORD = 199;
pub const ERROR_RING2SEG_MUST_BE_MOVABLE: ::DWORD = 200;
pub const ERROR_RELOC_CHAIN_XEEDS_SEGLIM: ::DWORD = 201;
pub const ERROR_INFLOOP_IN_RELOC_CHAIN: ::DWORD = 202;
pub const ERROR_ENVVAR_NOT_FOUND: ::DWORD = 203;
pub const ERROR_NO_SIGNAL_SENT: ::DWORD = 205;
pub const ERROR_FILENAME_EXCED_RANGE: ::DWORD = 206;
pub const ERROR_RING2_STACK_IN_USE: ::DWORD = 207;
pub const ERROR_META_EXPANSION_TOO_LONG: ::DWORD = 208;
pub const ERROR_INVALID_SIGNAL_NUMBER: ::DWORD = 209;
pub const ERROR_THREAD_1_INACTIVE: ::DWORD = 210;
pub const ERROR_LOCKED: ::DWORD = 212;
pub const ERROR_TOO_MANY_MODULES: ::DWORD = 214;
pub const ERROR_NESTING_NOT_ALLOWED: ::DWORD = 215;
pub const ERROR_EXE_MACHINE_TYPE_MISMATCH: ::DWORD = 216;
pub const ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY: ::DWORD = 217;
pub const ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY: ::DWORD = 218;
pub const ERROR_FILE_CHECKED_OUT: ::DWORD = 220;
pub const ERROR_CHECKOUT_REQUIRED: ::DWORD = 221;
pub const ERROR_BAD_FILE_TYPE: ::DWORD = 222;
pub const ERROR_FILE_TOO_LARGE: ::DWORD = 223;
pub const ERROR_FORMS_AUTH_REQUIRED: ::DWORD = 224;
pub const ERROR_VIRUS_INFECTED: ::DWORD = 225;
pub const ERROR_VIRUS_DELETED: ::DWORD = 226;
pub const ERROR_PIPE_LOCAL: ::DWORD = 229;
pub const ERROR_BAD_PIPE: ::DWORD = 230;
pub const ERROR_PIPE_BUSY: ::DWORD = 231;
pub const ERROR_NO_DATA: ::DWORD = 232;
pub const ERROR_PIPE_NOT_CONNECTED: ::DWORD = 233;
pub const ERROR_MORE_DATA: ::DWORD = 234;
pub const ERROR_VC_DISCONNECTED: ::DWORD = 240;
pub const ERROR_INVALID_EA_NAME: ::DWORD = 254;
pub const ERROR_EA_LIST_INCONSISTENT: ::DWORD = 255;
pub const WAIT_TIMEOUT: ::DWORD = 258;
pub const ERROR_NO_MORE_ITEMS: ::DWORD = 259;
pub const ERROR_CANNOT_COPY: ::DWORD = 266;
pub const ERROR_DIRECTORY: ::DWORD = 267;
pub const ERROR_EAS_DIDNT_FIT: ::DWORD = 275;
pub const ERROR_EA_FILE_CORRUPT: ::DWORD = 276;
pub const ERROR_EA_TABLE_FULL: ::DWORD = 277;
pub const ERROR_INVALID_EA_HANDLE: ::DWORD = 278;
pub const ERROR_EAS_NOT_SUPPORTED: ::DWORD = 282;
pub const ERROR_NOT_OWNER: ::DWORD = 288;
pub const ERROR_TOO_MANY_POSTS: ::DWORD = 298;
pub const ERROR_PARTIAL_COPY: ::DWORD = 299;
pub const ERROR_OPLOCK_NOT_GRANTED: ::DWORD = 300;
pub const ERROR_INVALID_OPLOCK_PROTOCOL: ::DWORD = 301;
pub const ERROR_DISK_TOO_FRAGMENTED: ::DWORD = 302;
pub const ERROR_DELETE_PENDING: ::DWORD = 303;
pub const ERROR_INCOMPATIBLE_WITH_GLOBAL_SHORT_NAME_REGISTRY_SETTING: ::DWORD = 304;
pub const ERROR_SHORT_NAMES_NOT_ENABLED_ON_VOLUME: ::DWORD = 305;
pub const ERROR_SECURITY_STREAM_IS_INCONSISTENT: ::DWORD = 306;
pub const ERROR_INVALID_LOCK_RANGE: ::DWORD = 307;
pub const ERROR_IMAGE_SUBSYSTEM_NOT_PRESENT: ::DWORD = 308;
pub const ERROR_NOTIFICATION_GUID_ALREADY_DEFINED: ::DWORD = 309;
pub const ERROR_INVALID_EXCEPTION_HANDLER: ::DWORD = 310;
pub const ERROR_DUPLICATE_PRIVILEGES: ::DWORD = 311;
pub const ERROR_NO_RANGES_PROCESSED: ::DWORD = 312;
pub const ERROR_NOT_ALLOWED_ON_SYSTEM_FILE: ::DWORD = 313;
pub const ERROR_DISK_RESOURCES_EXHAUSTED: ::DWORD = 314;
pub const ERROR_INVALID_TOKEN: ::DWORD = 315;
pub const ERROR_DEVICE_FEATURE_NOT_SUPPORTED: ::DWORD = 316;
pub const ERROR_MR_MID_NOT_FOUND: ::DWORD = 317;
pub const ERROR_SCOPE_NOT_FOUND: ::DWORD = 318;
pub const ERROR_UNDEFINED_SCOPE: ::DWORD = 319;
pub const ERROR_INVALID_CAP: ::DWORD = 320;
pub const ERROR_DEVICE_UNREACHABLE: ::DWORD = 321;
pub const ERROR_DEVICE_NO_RESOURCES: ::DWORD = 322;
pub const ERROR_DATA_CHECKSUM_ERROR: ::DWORD = 323;
pub const ERROR_INTERMIXED_KERNEL_EA_OPERATION: ::DWORD = 324;
pub const ERROR_FILE_LEVEL_TRIM_NOT_SUPPORTED: ::DWORD = 326;
pub const ERROR_OFFSET_ALIGNMENT_VIOLATION: ::DWORD = 327;
pub const ERROR_INVALID_FIELD_IN_PARAMETER_LIST: ::DWORD = 328;
pub const ERROR_OPERATION_IN_PROGRESS: ::DWORD = 329;
pub const ERROR_BAD_DEVICE_PATH: ::DWORD = 330;
pub const ERROR_TOO_MANY_DESCRIPTORS: ::DWORD = 331;
pub const ERROR_SCRUB_DATA_DISABLED: ::DWORD = 332;
pub const ERROR_NOT_REDUNDANT_STORAGE: ::DWORD = 333;
pub const ERROR_RESIDENT_FILE_NOT_SUPPORTED: ::DWORD = 334;
pub const ERROR_COMPRESSED_FILE_NOT_SUPPORTED: ::DWORD = 335;
pub const ERROR_DIRECTORY_NOT_SUPPORTED: ::DWORD = 336;
pub const ERROR_NOT_READ_FROM_COPY: ::DWORD = 337;
pub const ERROR_FT_WRITE_FAILURE: ::DWORD = 338;
pub const ERROR_FT_DI_SCAN_REQUIRED: ::DWORD = 339;
pub const ERROR_INVALID_KERNEL_INFO_VERSION: ::DWORD = 340;
pub const ERROR_INVALID_PEP_INFO_VERSION: ::DWORD = 341;
pub const ERROR_OBJECT_NOT_EXTERNALLY_BACKED: ::DWORD = 342;
pub const ERROR_EXTERNAL_BACKING_PROVIDER_UNKNOWN: ::DWORD = 343;
pub const ERROR_FAIL_NOACTION_REBOOT: ::DWORD = 350;
pub const ERROR_FAIL_SHUTDOWN: ::DWORD = 351;
pub const ERROR_FAIL_RESTART: ::DWORD = 352;
pub const ERROR_MAX_SESSIONS_REACHED: ::DWORD = 353;
pub const ERROR_THREAD_MODE_ALREADY_BACKGROUND: ::DWORD = 400;
pub const ERROR_THREAD_MODE_NOT_BACKGROUND: ::DWORD = 401;
pub const ERROR_PROCESS_MODE_ALREADY_BACKGROUND: ::DWORD = 402;
pub const ERROR_PROCESS_MODE_NOT_BACKGROUND: ::DWORD = 403;
pub const ERROR_DEVICE_HARDWARE_ERROR: ::DWORD = 483;
pub const ERROR_INVALID_ADDRESS: ::DWORD = 487;
pub const ERROR_USER_PROFILE_LOAD: ::DWORD = 500;
pub const ERROR_ARITHMETIC_OVERFLOW: ::DWORD = 534;
pub const ERROR_PIPE_CONNECTED: ::DWORD = 535;
pub const ERROR_PIPE_LISTENING: ::DWORD = 536;
pub const ERROR_VERIFIER_STOP: ::DWORD = 537;
pub const ERROR_ABIOS_ERROR: ::DWORD = 538;
pub const ERROR_WX86_WARNING: ::DWORD = 539;
pub const ERROR_WX86_ERROR: ::DWORD = 540;
pub const ERROR_TIMER_NOT_CANCELED: ::DWORD = 541;
pub const ERROR_UNWIND: ::DWORD = 542;
pub const ERROR_BAD_STACK: ::DWORD = 543;
pub const ERROR_INVALID_UNWIND_TARGET: ::DWORD = 544;
pub const ERROR_INVALID_PORT_ATTRIBUTES: ::DWORD = 545;
pub const ERROR_PORT_MESSAGE_TOO_LONG: ::DWORD = 546;
pub const ERROR_INVALID_QUOTA_LOWER: ::DWORD = 547;
pub const ERROR_DEVICE_ALREADY_ATTACHED: ::DWORD = 548;
pub const ERROR_INSTRUCTION_MISALIGNMENT: ::DWORD = 549;
pub const ERROR_PROFILING_NOT_STARTED: ::DWORD = 550;
pub const ERROR_PROFILING_NOT_STOPPED: ::DWORD = 551;
pub const ERROR_COULD_NOT_INTERPRET: ::DWORD = 552;
pub const ERROR_PROFILING_AT_LIMIT: ::DWORD = 553;
pub const ERROR_CANT_WAIT: ::DWORD = 554;
pub const ERROR_CANT_TERMINATE_SELF: ::DWORD = 555;
pub const ERROR_UNEXPECTED_MM_CREATE_ERR: ::DWORD = 556;
pub const ERROR_UNEXPECTED_MM_MAP_ERROR: ::DWORD = 557;
pub const ERROR_UNEXPECTED_MM_EXTEND_ERR: ::DWORD = 558;
pub const ERROR_BAD_FUNCTION_TABLE: ::DWORD = 559;
pub const ERROR_NO_GUID_TRANSLATION: ::DWORD = 560;
pub const ERROR_INVALID_LDT_SIZE: ::DWORD = 561;
pub const ERROR_INVALID_LDT_OFFSET: ::DWORD = 563;
pub const ERROR_INVALID_LDT_DESCRIPTOR: ::DWORD = 564;
pub const ERROR_TOO_MANY_THREADS: ::DWORD = 565;
pub const ERROR_THREAD_NOT_IN_PROCESS: ::DWORD = 566;
pub const ERROR_PAGEFILE_QUOTA_EXCEEDED: ::DWORD = 567;
pub const ERROR_LOGON_SERVER_CONFLICT: ::DWORD = 568;
pub const ERROR_SYNCHRONIZATION_REQUIRED: ::DWORD = 569;
pub const ERROR_NET_OPEN_FAILED: ::DWORD = 570;
pub const ERROR_IO_PRIVILEGE_FAILED: ::DWORD = 571;
pub const ERROR_CONTROL_C_EXIT: ::DWORD = 572;
pub const ERROR_MISSING_SYSTEMFILE: ::DWORD = 573;
pub const ERROR_UNHANDLED_EXCEPTION: ::DWORD = 574;
pub const ERROR_APP_INIT_FAILURE: ::DWORD = 575;
pub const ERROR_PAGEFILE_CREATE_FAILED: ::DWORD = 576;
pub const ERROR_INVALID_IMAGE_HASH: ::DWORD = 577;
pub const ERROR_NO_PAGEFILE: ::DWORD = 578;
pub const ERROR_ILLEGAL_FLOAT_CONTEXT: ::DWORD = 579;
pub const ERROR_NO_EVENT_PAIR: ::DWORD = 580;
pub const ERROR_DOMAIN_CTRLR_CONFIG_ERROR: ::DWORD = 581;
pub const ERROR_ILLEGAL_CHARACTER: ::DWORD = 582;
pub const ERROR_UNDEFINED_CHARACTER: ::DWORD = 583;
pub const ERROR_FLOPPY_VOLUME: ::DWORD = 584;
pub const ERROR_BIOS_FAILED_TO_CONNECT_INTERRUPT: ::DWORD = 585;
pub const ERROR_BACKUP_CONTROLLER: ::DWORD = 586;
pub const ERROR_MUTANT_LIMIT_EXCEEDED: ::DWORD = 587;
pub const ERROR_FS_DRIVER_REQUIRED: ::DWORD = 588;
pub const ERROR_CANNOT_LOAD_REGISTRY_FILE: ::DWORD = 589;
pub const ERROR_DEBUG_ATTACH_FAILED: ::DWORD = 590;
pub const ERROR_SYSTEM_PROCESS_TERMINATED: ::DWORD = 591;
pub const ERROR_DATA_NOT_ACCEPTED: ::DWORD = 592;
pub const ERROR_VDM_HARD_ERROR: ::DWORD = 593;
pub const ERROR_DRIVER_CANCEL_TIMEOUT: ::DWORD = 594;
pub const ERROR_REPLY_MESSAGE_MISMATCH: ::DWORD = 595;
pub const ERROR_LOST_WRITEBEHIND_DATA: ::DWORD = 596;
pub const ERROR_CLIENT_SERVER_PARAMETERS_INVALID: ::DWORD = 597;
pub const ERROR_NOT_TINY_STREAM: ::DWORD = 598;
pub const ERROR_STACK_OVERFLOW_READ: ::DWORD = 599;
pub const ERROR_CONVERT_TO_LARGE: ::DWORD = 600;
pub const ERROR_FOUND_OUT_OF_SCOPE: ::DWORD = 601;
pub const ERROR_ALLOCATE_BUCKET: ::DWORD = 602;
pub const ERROR_MARSHALL_OVERFLOW: ::DWORD = 603;
pub const ERROR_INVALID_VARIANT: ::DWORD = 604;
pub const ERROR_BAD_COMPRESSION_BUFFER: ::DWORD = 605;
pub const ERROR_AUDIT_FAILED: ::DWORD = 606;
pub const ERROR_TIMER_RESOLUTION_NOT_SET: ::DWORD = 607;
pub const ERROR_INSUFFICIENT_LOGON_INFO: ::DWORD = 608;
pub const ERROR_BAD_DLL_ENTRYPOINT: ::DWORD = 609;
pub const ERROR_BAD_SERVICE_ENTRYPOINT: ::DWORD = 610;
pub const ERROR_IP_ADDRESS_CONFLICT1: ::DWORD = 611;
pub const ERROR_IP_ADDRESS_CONFLICT2: ::DWORD = 612;
pub const ERROR_REGISTRY_QUOTA_LIMIT: ::DWORD = 613;
pub const ERROR_NO_CALLBACK_ACTIVE: ::DWORD = 614;
pub const ERROR_PWD_TOO_SHORT: ::DWORD = 615;
pub const ERROR_PWD_TOO_RECENT: ::DWORD = 616;
pub const ERROR_PWD_HISTORY_CONFLICT: ::DWORD = 617;
pub const ERROR_UNSUPPORTED_COMPRESSION: ::DWORD = 618;
pub const ERROR_INVALID_HW_PROFILE: ::DWORD = 619;
pub const ERROR_INVALID_PLUGPLAY_DEVICE_PATH: ::DWORD = 620;
pub const ERROR_QUOTA_LIST_INCONSISTENT: ::DWORD = 621;
pub const ERROR_EVALUATION_EXPIRATION: ::DWORD = 622;
pub const ERROR_ILLEGAL_DLL_RELOCATION: ::DWORD = 623;
pub const ERROR_DLL_INIT_FAILED_LOGOFF: ::DWORD = 624;
pub const ERROR_VALIDATE_CONTINUE: ::DWORD = 625;
pub const ERROR_NO_MORE_MATCHES: ::DWORD = 626;
pub const ERROR_RANGE_LIST_CONFLICT: ::DWORD = 627;
pub const ERROR_SERVER_SID_MISMATCH: ::DWORD = 628;
pub const ERROR_CANT_ENABLE_DENY_ONLY: ::DWORD = 629;
pub const ERROR_FLOAT_MULTIPLE_FAULTS: ::DWORD = 630;
pub const ERROR_FLOAT_MULTIPLE_TRAPS: ::DWORD = 631;
pub const ERROR_NOINTERFACE: ::DWORD = 632;
pub const ERROR_DRIVER_FAILED_SLEEP: ::DWORD = 633;
pub const ERROR_CORRUPT_SYSTEM_FILE: ::DWORD = 634;
pub const ERROR_COMMITMENT_MINIMUM: ::DWORD = 635;
pub const ERROR_PNP_RESTART_ENUMERATION: ::DWORD = 636;
pub const ERROR_SYSTEM_IMAGE_BAD_SIGNATURE: ::DWORD = 637;
pub const ERROR_PNP_REBOOT_REQUIRED: ::DWORD = 638;
pub const ERROR_INSUFFICIENT_POWER: ::DWORD = 639;
pub const ERROR_MULTIPLE_FAULT_VIOLATION: ::DWORD = 640;
pub const ERROR_SYSTEM_SHUTDOWN: ::DWORD = 641;
pub const ERROR_PORT_NOT_SET: ::DWORD = 642;
pub const ERROR_DS_VERSION_CHECK_FAILURE: ::DWORD = 643;
pub const ERROR_RANGE_NOT_FOUND: ::DWORD = 644;
pub const ERROR_NOT_SAFE_MODE_DRIVER: ::DWORD = 646;
pub const ERROR_FAILED_DRIVER_ENTRY: ::DWORD = 647;
pub const ERROR_DEVICE_ENUMERATION_ERROR: ::DWORD = 648;
pub const ERROR_MOUNT_POINT_NOT_RESOLVED: ::DWORD = 649;
pub const ERROR_INVALID_DEVICE_OBJECT_PARAMETER: ::DWORD = 650;
pub const ERROR_MCA_OCCURED: ::DWORD = 651;
pub const ERROR_DRIVER_DATABASE_ERROR: ::DWORD = 652;
pub const ERROR_SYSTEM_HIVE_TOO_LARGE: ::DWORD = 653;
pub const ERROR_DRIVER_FAILED_PRIOR_UNLOAD: ::DWORD = 654;
pub const ERROR_VOLSNAP_PREPARE_HIBERNATE: ::DWORD = 655;
pub const ERROR_HIBERNATION_FAILURE: ::DWORD = 656;
pub const ERROR_PWD_TOO_LONG: ::DWORD = 657;
pub const ERROR_FILE_SYSTEM_LIMITATION: ::DWORD = 665;
pub const ERROR_ASSERTION_FAILURE: ::DWORD = 668;
pub const ERROR_ACPI_ERROR: ::DWORD = 669;
pub const ERROR_WOW_ASSERTION: ::DWORD = 670;
pub const ERROR_PNP_BAD_MPS_TABLE: ::DWORD = 671;
pub const ERROR_PNP_TRANSLATION_FAILED: ::DWORD = 672;
pub const ERROR_PNP_IRQ_TRANSLATION_FAILED: ::DWORD = 673;
pub const ERROR_PNP_INVALID_ID: ::DWORD = 674;
pub const ERROR_WAKE_SYSTEM_DEBUGGER: ::DWORD = 675;
pub const ERROR_HANDLES_CLOSED: ::DWORD = 676;
pub const ERROR_EXTRANEOUS_INFORMATION: ::DWORD = 677;
pub const ERROR_RXACT_COMMIT_NECESSARY: ::DWORD = 678;
pub const ERROR_MEDIA_CHECK: ::DWORD = 679;
pub const ERROR_GUID_SUBSTITUTION_MADE: ::DWORD = 680;
pub const ERROR_STOPPED_ON_SYMLINK: ::DWORD = 681;
pub const ERROR_LONGJUMP: ::DWORD = 682;
pub const ERROR_PLUGPLAY_QUERY_VETOED: ::DWORD = 683;
pub const ERROR_UNWIND_CONSOLIDATE: ::DWORD = 684;
pub const ERROR_REGISTRY_HIVE_RECOVERED: ::DWORD = 685;
pub const ERROR_DLL_MIGHT_BE_INSECURE: ::DWORD = 686;
pub const ERROR_DLL_MIGHT_BE_INCOMPATIBLE: ::DWORD = 687;
pub const ERROR_DBG_EXCEPTION_NOT_HANDLED: ::DWORD = 688;
pub const ERROR_DBG_REPLY_LATER: ::DWORD = 689;
pub const ERROR_DBG_UNABLE_TO_PROVIDE_HANDLE: ::DWORD = 690;
pub const ERROR_DBG_TERMINATE_THREAD: ::DWORD = 691;
pub const ERROR_DBG_TERMINATE_PROCESS: ::DWORD = 692;
pub const ERROR_DBG_CONTROL_C: ::DWORD = 693;
pub const ERROR_DBG_PRINTEXCEPTION_C: ::DWORD = 694;
pub const ERROR_DBG_RIPEXCEPTION: ::DWORD = 695;
pub const ERROR_DBG_CONTROL_BREAK: ::DWORD = 696;
pub const ERROR_DBG_COMMAND_EXCEPTION: ::DWORD = 697;
pub const ERROR_OBJECT_NAME_EXISTS: ::DWORD = 698;
pub const ERROR_THREAD_WAS_SUSPENDED: ::DWORD = 699;
pub const ERROR_IMAGE_NOT_AT_BASE: ::DWORD = 700;
pub const ERROR_RXACT_STATE_CREATED: ::DWORD = 701;
pub const ERROR_SEGMENT_NOTIFICATION: ::DWORD = 702;
pub const ERROR_BAD_CURRENT_DIRECTORY: ::DWORD = 703;
pub const ERROR_FT_READ_RECOVERY_FROM_BACKUP: ::DWORD = 704;
pub const ERROR_FT_WRITE_RECOVERY: ::DWORD = 705;
pub const ERROR_IMAGE_MACHINE_TYPE_MISMATCH: ::DWORD = 706;
pub const ERROR_RECEIVE_PARTIAL: ::DWORD = 707;
pub const ERROR_RECEIVE_EXPEDITED: ::DWORD = 708;
pub const ERROR_RECEIVE_PARTIAL_EXPEDITED: ::DWORD = 709;
pub const ERROR_EVENT_DONE: ::DWORD = 710;
pub const ERROR_EVENT_PENDING: ::DWORD = 711;
pub const ERROR_CHECKING_FILE_SYSTEM: ::DWORD = 712;
pub const ERROR_FATAL_APP_EXIT: ::DWORD = 713;
pub const ERROR_PREDEFINED_HANDLE: ::DWORD = 714;
pub const ERROR_WAS_UNLOCKED: ::DWORD = 715;
pub const ERROR_SERVICE_NOTIFICATION: ::DWORD = 716;
pub const ERROR_WAS_LOCKED: ::DWORD = 717;
pub const ERROR_LOG_HARD_ERROR: ::DWORD = 718;
pub const ERROR_ALREADY_WIN32: ::DWORD = 719;
pub const ERROR_IMAGE_MACHINE_TYPE_MISMATCH_EXE: ::DWORD = 720;
pub const ERROR_NO_YIELD_PERFORMED: ::DWORD = 721;
pub const ERROR_TIMER_RESUME_IGNORED: ::DWORD = 722;
pub const ERROR_ARBITRATION_UNHANDLED: ::DWORD = 723;
pub const ERROR_CARDBUS_NOT_SUPPORTED: ::DWORD = 724;
pub const ERROR_MP_PROCESSOR_MISMATCH: ::DWORD = 725;
pub const ERROR_HIBERNATED: ::DWORD = 726;
pub const ERROR_RESUME_HIBERNATION: ::DWORD = 727;
pub const ERROR_FIRMWARE_UPDATED: ::DWORD = 728;
pub const ERROR_DRIVERS_LEAKING_LOCKED_PAGES: ::DWORD = 729;
pub const ERROR_WAKE_SYSTEM: ::DWORD = 730;
pub const ERROR_WAIT_1: ::DWORD = 731;
pub const ERROR_WAIT_2: ::DWORD = 732;
pub const ERROR_WAIT_3: ::DWORD = 733;
pub const ERROR_WAIT_63: ::DWORD = 734;
pub const ERROR_ABANDONED_WAIT_0: ::DWORD = 735;
pub const ERROR_ABANDONED_WAIT_63: ::DWORD = 736;
pub const ERROR_USER_APC: ::DWORD = 737;
pub const ERROR_KERNEL_APC: ::DWORD = 738;
pub const ERROR_ALERTED: ::DWORD = 739;
pub const ERROR_ELEVATION_REQUIRED: ::DWORD = 740;
pub const ERROR_REPARSE: ::DWORD = 741;
pub const ERROR_OPLOCK_BREAK_IN_PROGRESS: ::DWORD = 742;
pub const ERROR_VOLUME_MOUNTED: ::DWORD = 743;
pub const ERROR_RXACT_COMMITTED: ::DWORD = 744;
pub const ERROR_NOTIFY_CLEANUP: ::DWORD = 745;
pub const ERROR_PRIMARY_TRANSPORT_CONNECT_FAILED: ::DWORD = 746;
pub const ERROR_PAGE_FAULT_TRANSITION: ::DWORD = 747;
pub const ERROR_PAGE_FAULT_DEMAND_ZERO: ::DWORD = 748;
pub const ERROR_PAGE_FAULT_COPY_ON_WRITE: ::DWORD = 749;
pub const ERROR_PAGE_FAULT_GUARD_PAGE: ::DWORD = 750;
pub const ERROR_PAGE_FAULT_PAGING_FILE: ::DWORD = 751;
pub const ERROR_CACHE_PAGE_LOCKED: ::DWORD = 752;
pub const ERROR_CRASH_DUMP: ::DWORD = 753;
pub const ERROR_BUFFER_ALL_ZEROS: ::DWORD = 754;
pub const ERROR_REPARSE_OBJECT: ::DWORD = 755;
pub const ERROR_RESOURCE_REQUIREMENTS_CHANGED: ::DWORD = 756;
pub const ERROR_TRANSLATION_COMPLETE: ::DWORD = 757;
pub const ERROR_NOTHING_TO_TERMINATE: ::DWORD = 758;
pub const ERROR_PROCESS_NOT_IN_JOB: ::DWORD = 759;
pub const ERROR_PROCESS_IN_JOB: ::DWORD = 760;
pub const ERROR_VOLSNAP_HIBERNATE_READY: ::DWORD = 761;
pub const ERROR_FSFILTER_OP_COMPLETED_SUCCESSFULLY: ::DWORD = 762;
pub const ERROR_INTERRUPT_VECTOR_ALREADY_CONNECTED: ::DWORD = 763;
pub const ERROR_INTERRUPT_STILL_CONNECTED: ::DWORD = 764;
pub const ERROR_WAIT_FOR_OPLOCK: ::DWORD = 765;
pub const ERROR_DBG_EXCEPTION_HANDLED: ::DWORD = 766;
pub const ERROR_DBG_CONTINUE: ::DWORD = 767;
pub const ERROR_CALLBACK_POP_STACK: ::DWORD = 768;
pub const ERROR_COMPRESSION_DISABLED: ::DWORD = 769;
pub const ERROR_CANTFETCHBACKWARDS: ::DWORD = 770;
pub const ERROR_CANTSCROLLBACKWARDS: ::DWORD = 771;
pub const ERROR_ROWSNOTRELEASED: ::DWORD = 772;
pub const ERROR_BAD_ACCESSOR_FLAGS: ::DWORD = 773;
pub const ERROR_ERRORS_ENCOUNTERED: ::DWORD = 774;
pub const ERROR_NOT_CAPABLE: ::DWORD = 775;
pub const ERROR_REQUEST_OUT_OF_SEQUENCE: ::DWORD = 776;
pub const ERROR_VERSION_PARSE_ERROR: ::DWORD = 777;
pub const ERROR_BADSTARTPOSITION: ::DWORD = 778;
pub const ERROR_MEMORY_HARDWARE: ::DWORD = 779;
pub const ERROR_DISK_REPAIR_DISABLED: ::DWORD = 780;
pub const ERROR_INSUFFICIENT_RESOURCE_FOR_SPECIFIED_SHARED_SECTION_SIZE: ::DWORD = 781;
pub const ERROR_SYSTEM_POWERSTATE_TRANSITION: ::DWORD = 782;
pub const ERROR_SYSTEM_POWERSTATE_COMPLEX_TRANSITION: ::DWORD = 783;
pub const ERROR_MCA_EXCEPTION: ::DWORD = 784;
pub const ERROR_ACCESS_AUDIT_BY_POLICY: ::DWORD = 785;
pub const ERROR_ACCESS_DISABLED_NO_SAFER_UI_BY_POLICY: ::DWORD = 786;
pub const ERROR_ABANDON_HIBERFILE: ::DWORD = 787;
pub const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_DISCONNECTED: ::DWORD = 788;
pub const ERROR_LOST_WRITEBEHIND_DATA_NETWORK_SERVER_ERROR: ::DWORD = 789;
pub const ERROR_LOST_WRITEBEHIND_DATA_LOCAL_DISK_ERROR: ::DWORD = 790;
pub const ERROR_BAD_MCFG_TABLE: ::DWORD = 791;
pub const ERROR_DISK_REPAIR_REDIRECTED: ::DWORD = 792;
pub const ERROR_DISK_REPAIR_UNSUCCESSFUL: ::DWORD = 793;
pub const ERROR_CORRUPT_LOG_OVERFULL: ::DWORD = 794;
pub const ERROR_CORRUPT_LOG_CORRUPTED: ::DWORD = 795;
pub const ERROR_CORRUPT_LOG_UNAVAILABLE: ::DWORD = 796;
pub const ERROR_CORRUPT_LOG_DELETED_FULL: ::DWORD = 797;
pub const ERROR_CORRUPT_LOG_CLEARED: ::DWORD = 798;
pub const ERROR_ORPHAN_NAME_EXHAUSTED: ::DWORD = 799;
pub const ERROR_OPLOCK_SWITCHED_TO_NEW_HANDLE: ::DWORD = 800;
pub const ERROR_CANNOT_GRANT_REQUESTED_OPLOCK: ::DWORD = 801;
pub const ERROR_CANNOT_BREAK_OPLOCK: ::DWORD = 802;
pub const ERROR_OPLOCK_HANDLE_CLOSED: ::DWORD = 803;
pub const ERROR_NO_ACE_CONDITION: ::DWORD = 804;
pub const ERROR_INVALID_ACE_CONDITION: ::DWORD = 805;
pub const ERROR_FILE_HANDLE_REVOKED: ::DWORD = 806;
pub const ERROR_IMAGE_AT_DIFFERENT_BASE: ::DWORD = 807;
pub const ERROR_ENCRYPTED_IO_NOT_POSSIBLE: ::DWORD = 808;
pub const ERROR_EA_ACCESS_DENIED: ::DWORD = 994;
pub const ERROR_OPERATION_ABORTED: ::DWORD = 995;
pub const ERROR_IO_INCOMPLETE: ::DWORD = 996;
pub const ERROR_IO_PENDING: ::DWORD = 997;
pub const ERROR_NOACCESS: ::DWORD = 998;
pub const ERROR_SWAPERROR: ::DWORD = 999;
pub const ERROR_STACK_OVERFLOW: ::DWORD = 1001;
pub const ERROR_INVALID_MESSAGE: ::DWORD = 1002;
pub const ERROR_CAN_NOT_COMPLETE: ::DWORD = 1003;
pub const ERROR_INVALID_FLAGS: ::DWORD = 1004;
pub const ERROR_UNRECOGNIZED_VOLUME: ::DWORD = 1005;
pub const ERROR_FILE_INVALID: ::DWORD = 1006;
pub const ERROR_FULLSCREEN_MODE: ::DWORD = 1007;
pub const ERROR_NO_TOKEN: ::DWORD = 1008;
pub const ERROR_BADDB: ::DWORD = 1009;
pub const ERROR_BADKEY: ::DWORD = 1010;
pub const ERROR_CANTOPEN: ::DWORD = 1011;
pub const ERROR_CANTREAD: ::DWORD = 1012;
pub const ERROR_CANTWRITE: ::DWORD = 1013;
pub const ERROR_REGISTRY_RECOVERED: ::DWORD = 1014;
pub const ERROR_REGISTRY_CORRUPT: ::DWORD = 1015;
pub const ERROR_REGISTRY_IO_FAILED: ::DWORD = 1016;
pub const ERROR_NOT_REGISTRY_FILE: ::DWORD = 1017;
pub const ERROR_KEY_DELETED: ::DWORD = 1018;
pub const ERROR_NO_LOG_SPACE: ::DWORD = 1019;
pub const ERROR_KEY_HAS_CHILDREN: ::DWORD = 1020;
pub const ERROR_CHILD_MUST_BE_VOLATILE: ::DWORD = 1021;
pub const ERROR_NOTIFY_ENUM_DIR: ::DWORD = 1022;
pub const ERROR_DEPENDENT_SERVICES_RUNNING: ::DWORD = 1051;
pub const ERROR_INVALID_SERVICE_CONTROL: ::DWORD = 1052;
pub const ERROR_SERVICE_REQUEST_TIMEOUT: ::DWORD = 1053;
pub const ERROR_SERVICE_NO_THREAD: ::DWORD = 1054;
pub const ERROR_SERVICE_DATABASE_LOCKED: ::DWORD = 1055;
pub const ERROR_SERVICE_ALREADY_RUNNING: ::DWORD = 1056;
pub const ERROR_INVALID_SERVICE_ACCOUNT: ::DWORD = 1057;
pub const ERROR_SERVICE_DISABLED: ::DWORD = 1058;
pub const ERROR_CIRCULAR_DEPENDENCY: ::DWORD = 1059;
pub const ERROR_SERVICE_DOES_NOT_EXIST: ::DWORD = 1060;
pub const ERROR_SERVICE_CANNOT_ACCEPT_CTRL: ::DWORD = 1061;
pub const ERROR_SERVICE_NOT_ACTIVE: ::DWORD = 1062;
pub const ERROR_FAILED_SERVICE_CONTROLLER_CONNECT: ::DWORD = 1063;
pub const ERROR_EXCEPTION_IN_SERVICE: ::DWORD = 1064;
pub const ERROR_DATABASE_DOES_NOT_EXIST: ::DWORD = 1065;
pub const ERROR_SERVICE_SPECIFIC_ERROR: ::DWORD = 1066;
pub const ERROR_PROCESS_ABORTED: ::DWORD = 1067;
pub const ERROR_SERVICE_DEPENDENCY_FAIL: ::DWORD = 1068;
pub const ERROR_SERVICE_LOGON_FAILED: ::DWORD = 1069;
pub const ERROR_SERVICE_START_HANG: ::DWORD = 1070;
pub const ERROR_INVALID_SERVICE_LOCK: ::DWORD = 1071;
pub const ERROR_SERVICE_MARKED_FOR_DELETE: ::DWORD = 1072;
pub const ERROR_SERVICE_EXISTS: ::DWORD = 1073;
pub const ERROR_ALREADY_RUNNING_LKG: ::DWORD = 1074;
pub const ERROR_SERVICE_DEPENDENCY_DELETED: ::DWORD = 1075;
pub const ERROR_BOOT_ALREADY_ACCEPTED: ::DWORD = 1076;
pub const ERROR_SERVICE_NEVER_STARTED: ::DWORD = 1077;
pub const ERROR_DUPLICATE_SERVICE_NAME: ::DWORD = 1078;
pub const ERROR_DIFFERENT_SERVICE_ACCOUNT: ::DWORD = 1079;
pub const ERROR_CANNOT_DETECT_DRIVER_FAILURE: ::DWORD = 1080;
pub const ERROR_CANNOT_DETECT_PROCESS_ABORT: ::DWORD = 1081;
pub const ERROR_NO_RECOVERY_PROGRAM: ::DWORD = 1082;
pub const ERROR_SERVICE_NOT_IN_EXE: ::DWORD = 1083;
pub const ERROR_NOT_SAFEBOOT_SERVICE: ::DWORD = 1084;
pub const ERROR_END_OF_MEDIA: ::DWORD = 1100;
pub const ERROR_FILEMARK_DETECTED: ::DWORD = 1101;
pub const ERROR_BEGINNING_OF_MEDIA: ::DWORD = 1102;
pub const ERROR_SETMARK_DETECTED: ::DWORD = 1103;
pub const ERROR_NO_DATA_DETECTED: ::DWORD = 1104;
pub const ERROR_PARTITION_FAILURE: ::DWORD = 1105;
pub const ERROR_INVALID_BLOCK_LENGTH: ::DWORD = 1106;
pub const ERROR_DEVICE_NOT_PARTITIONED: ::DWORD = 1107;
pub const ERROR_UNABLE_TO_LOCK_MEDIA: ::DWORD = 1108;
pub const ERROR_UNABLE_TO_UNLOAD_MEDIA: ::DWORD = 1109;
pub const ERROR_MEDIA_CHANGED: ::DWORD = 1110;
pub const ERROR_BUS_RESET: ::DWORD = 1111;
pub const ERROR_NO_MEDIA_IN_DRIVE: ::DWORD = 1112;
pub const ERROR_NO_UNICODE_TRANSLATION: ::DWORD = 1113;
pub const ERROR_DLL_INIT_FAILED: ::DWORD = 1114;
pub const ERROR_SHUTDOWN_IN_PROGRESS: ::DWORD = 1115;
pub const ERROR_NO_SHUTDOWN_IN_PROGRESS: ::DWORD = 1116;
pub const ERROR_IO_DEVICE: ::DWORD = 1117;
pub const ERROR_SERIAL_NO_DEVICE: ::DWORD = 1118;
pub const ERROR_IRQ_BUSY: ::DWORD = 1119;
pub const ERROR_MORE_WRITES: ::DWORD = 1120;
pub const ERROR_COUNTER_TIMEOUT: ::DWORD = 1121;
pub const ERROR_FLOPPY_ID_MARK_NOT_FOUND: ::DWORD = 1122;
pub const ERROR_FLOPPY_WRONG_CYLINDER: ::DWORD = 1123;
pub const ERROR_FLOPPY_UNKNOWN_ERROR: ::DWORD = 1124;
pub const ERROR_FLOPPY_BAD_REGISTERS: ::DWORD = 1125;
pub const ERROR_DISK_RECALIBRATE_FAILED: ::DWORD = 1126;
pub const ERROR_DISK_OPERATION_FAILED: ::DWORD = 1127;
pub const ERROR_DISK_RESET_FAILED: ::DWORD = 1128;
pub const ERROR_EOM_OVERFLOW: ::DWORD = 1129;
pub const ERROR_NOT_ENOUGH_SERVER_MEMORY: ::DWORD = 1130;
pub const ERROR_POSSIBLE_DEADLOCK: ::DWORD = 1131;
pub const ERROR_MAPPED_ALIGNMENT: ::DWORD = 1132;
pub const ERROR_SET_POWER_STATE_VETOED: ::DWORD = 1140;
pub const ERROR_SET_POWER_STATE_FAILED: ::DWORD = 1141;
pub const ERROR_TOO_MANY_LINKS: ::DWORD = 1142;
pub const ERROR_OLD_WIN_VERSION: ::DWORD = 1150;
pub const ERROR_APP_WRONG_OS: ::DWORD = 1151;
pub const ERROR_SINGLE_INSTANCE_APP: ::DWORD = 1152;
pub const ERROR_RMODE_APP: ::DWORD = 1153;
pub const ERROR_INVALID_DLL: ::DWORD = 1154;
pub const ERROR_NO_ASSOCIATION: ::DWORD = 1155;
pub const ERROR_DDE_FAIL: ::DWORD = 1156;
pub const ERROR_DLL_NOT_FOUND: ::DWORD = 1157;
pub const ERROR_NO_MORE_USER_HANDLES: ::DWORD = 1158;
pub const ERROR_MESSAGE_SYNC_ONLY: ::DWORD = 1159;
pub const ERROR_SOURCE_ELEMENT_EMPTY: ::DWORD = 1160;
pub const ERROR_DESTINATION_ELEMENT_FULL: ::DWORD = 1161;
pub const ERROR_ILLEGAL_ELEMENT_ADDRESS: ::DWORD = 1162;
pub const ERROR_MAGAZINE_NOT_PRESENT: ::DWORD = 1163;
pub const ERROR_DEVICE_REINITIALIZATION_NEEDED: ::DWORD = 1164;
pub const ERROR_DEVICE_REQUIRES_CLEANING: ::DWORD = 1165;
pub const ERROR_DEVICE_DOOR_OPEN: ::DWORD = 1166;
pub const ERROR_DEVICE_NOT_CONNECTED: ::DWORD = 1167;
pub const ERROR_NOT_FOUND: ::DWORD = 1168;
pub const ERROR_NO_MATCH: ::DWORD = 1169;
pub const ERROR_SET_NOT_FOUND: ::DWORD = 1170;
pub const ERROR_POINT_NOT_FOUND: ::DWORD = 1171;
pub const ERROR_NO_TRACKING_SERVICE: ::DWORD = 1172;
pub const ERROR_NO_VOLUME_ID: ::DWORD = 1173;
pub const ERROR_UNABLE_TO_REMOVE_REPLACED: ::DWORD = 1175;
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT: ::DWORD = 1176;
pub const ERROR_UNABLE_TO_MOVE_REPLACEMENT_2: ::DWORD = 1177;
pub const ERROR_JOURNAL_DELETE_IN_PROGRESS: ::DWORD = 1178;
pub const ERROR_JOURNAL_NOT_ACTIVE: ::DWORD = 1179;
pub const ERROR_POTENTIAL_FILE_FOUND: ::DWORD = 1180;
pub const ERROR_JOURNAL_ENTRY_DELETED: ::DWORD = 1181;
pub const ERROR_SHUTDOWN_IS_SCHEDULED: ::DWORD = 1190;
pub const ERROR_SHUTDOWN_USERS_LOGGED_ON: ::DWORD = 1191;
pub const ERROR_BAD_DEVICE: ::DWORD = 1200;
pub const ERROR_CONNECTION_UNAVAIL: ::DWORD = 1201;
pub const ERROR_DEVICE_ALREADY_REMEMBERED: ::DWORD = 1202;
pub const ERROR_NO_NET_OR_BAD_PATH: ::DWORD = 1203;
pub const ERROR_BAD_PROVIDER: ::DWORD = 1204;
pub const ERROR_CANNOT_OPEN_PROFILE: ::DWORD = 1205;
pub const ERROR_BAD_PROFILE: ::DWORD = 1206;
pub const ERROR_NOT_CONTAINER: ::DWORD = 1207;
pub const ERROR_EXTENDED_ERROR: ::DWORD = 1208;
pub const ERROR_INVALID_GROUPNAME: ::DWORD = 1209;
pub const ERROR_INVALID_COMPUTERNAME: ::DWORD = 1210;
pub const ERROR_INVALID_EVENTNAME: ::DWORD = 1211;
pub const ERROR_INVALID_DOMAINNAME: ::DWORD = 1212;
pub const ERROR_INVALID_SERVICENAME: ::DWORD = 1213;
pub const ERROR_INVALID_NETNAME: ::DWORD = 1214;
pub const ERROR_INVALID_SHARENAME: ::DWORD = 1215;
pub const ERROR_INVALID_PASSWORDNAME: ::DWORD = 1216;
pub const ERROR_INVALID_MESSAGENAME: ::DWORD = 1217;
pub const ERROR_INVALID_MESSAGEDEST: ::DWORD = 1218;
pub const ERROR_SESSION_CREDENTIAL_CONFLICT: ::DWORD = 1219;
pub const ERROR_REMOTE_SESSION_LIMIT_EXCEEDED: ::DWORD = 1220;
pub const ERROR_DUP_DOMAINNAME: ::DWORD = 1221;
pub const ERROR_NO_NETWORK: ::DWORD = 1222;
pub const ERROR_CANCELLED: ::DWORD = 1223;
pub const ERROR_USER_MAPPED_FILE: ::DWORD = 1224;
pub const ERROR_CONNECTION_REFUSED: ::DWORD = 1225;
pub const ERROR_GRACEFUL_DISCONNECT: ::DWORD = 1226;
pub const ERROR_ADDRESS_ALREADY_ASSOCIATED: ::DWORD = 1227;
pub const ERROR_ADDRESS_NOT_ASSOCIATED: ::DWORD = 1228;
pub const ERROR_CONNECTION_INVALID: ::DWORD = 1229;
pub const ERROR_CONNECTION_ACTIVE: ::DWORD = 1230;
pub const ERROR_NETWORK_UNREACHABLE: ::DWORD = 1231;
pub const ERROR_HOST_UNREACHABLE: ::DWORD = 1232;
pub const ERROR_PROTOCOL_UNREACHABLE: ::DWORD = 1233;
pub const ERROR_PORT_UNREACHABLE: ::DWORD = 1234;
pub const ERROR_REQUEST_ABORTED: ::DWORD = 1235;
pub const ERROR_CONNECTION_ABORTED: ::DWORD = 1236;
pub const ERROR_RETRY: ::DWORD = 1237;
pub const ERROR_CONNECTION_COUNT_LIMIT: ::DWORD = 1238;
pub const ERROR_LOGIN_TIME_RESTRICTION: ::DWORD = 1239;
pub const ERROR_LOGIN_WKSTA_RESTRICTION: ::DWORD = 1240;
pub const ERROR_INCORRECT_ADDRESS: ::DWORD = 1241;
pub const ERROR_ALREADY_REGISTERED: ::DWORD = 1242;
pub const ERROR_SERVICE_NOT_FOUND: ::DWORD = 1243;
pub const ERROR_NOT_AUTHENTICATED: ::DWORD = 1244;
pub const ERROR_NOT_LOGGED_ON: ::DWORD = 1245;
pub const ERROR_CONTINUE: ::DWORD = 1246;
pub const ERROR_ALREADY_INITIALIZED: ::DWORD = 1247;
pub const ERROR_NO_MORE_DEVICES: ::DWORD = 1248;
pub const ERROR_NO_SUCH_SITE: ::DWORD = 1249;
pub const ERROR_DOMAIN_CONTROLLER_EXISTS: ::DWORD = 1250;
pub const ERROR_ONLY_IF_CONNECTED: ::DWORD = 1251;
pub const ERROR_OVERRIDE_NOCHANGES: ::DWORD = 1252;
pub const ERROR_BAD_USER_PROFILE: ::DWORD = 1253;
pub const ERROR_NOT_SUPPORTED_ON_SBS: ::DWORD = 1254;
pub const ERROR_SERVER_SHUTDOWN_IN_PROGRESS: ::DWORD = 1255;
pub const ERROR_HOST_DOWN: ::DWORD = 1256;
pub const ERROR_NON_ACCOUNT_SID: ::DWORD = 1257;
pub const ERROR_NON_DOMAIN_SID: ::DWORD = 1258;
pub const ERROR_APPHELP_BLOCK: ::DWORD = 1259;
pub const ERROR_ACCESS_DISABLED_BY_POLICY: ::DWORD = 1260;
pub const ERROR_REG_NAT_CONSUMPTION: ::DWORD = 1261;
pub const ERROR_CSCSHARE_OFFLINE: ::DWORD = 1262;
pub const ERROR_PKINIT_FAILURE: ::DWORD = 1263;
pub const ERROR_SMARTCARD_SUBSYSTEM_FAILURE: ::DWORD = 1264;
pub const ERROR_DOWNGRADE_DETECTED: ::DWORD = 1265;
pub const ERROR_MACHINE_LOCKED: ::DWORD = 1271;
pub const ERROR_CALLBACK_SUPPLIED_INVALID_DATA: ::DWORD = 1273;
pub const ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED: ::DWORD = 1274;
pub const ERROR_DRIVER_BLOCKED: ::DWORD = 1275;
pub const ERROR_INVALID_IMPORT_OF_NON_DLL: ::DWORD = 1276;
pub const ERROR_ACCESS_DISABLED_WEBBLADE: ::DWORD = 1277;
pub const ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER: ::DWORD = 1278;
pub const ERROR_RECOVERY_FAILURE: ::DWORD = 1279;
pub const ERROR_ALREADY_FIBER: ::DWORD = 1280;
pub const ERROR_ALREADY_THREAD: ::DWORD = 1281;
pub const ERROR_STACK_BUFFER_OVERRUN: ::DWORD = 1282;
pub const ERROR_PARAMETER_QUOTA_EXCEEDED: ::DWORD = 1283;
pub const ERROR_DEBUGGER_INACTIVE: ::DWORD = 1284;
pub const ERROR_DELAY_LOAD_FAILED: ::DWORD = 1285;
pub const ERROR_VDM_DISALLOWED: ::DWORD = 1286;
pub const ERROR_UNIDENTIFIED_ERROR: ::DWORD = 1287;
pub const ERROR_INVALID_CRUNTIME_PARAMETER: ::DWORD = 1288;
pub const ERROR_BEYOND_VDL: ::DWORD = 1289;
pub const ERROR_INCOMPATIBLE_SERVICE_SID_TYPE: ::DWORD = 1290;
pub const ERROR_DRIVER_PROCESS_TERMINATED: ::DWORD = 1291;
pub const ERROR_IMPLEMENTATION_LIMIT: ::DWORD = 1292;
pub const ERROR_PROCESS_IS_PROTECTED: ::DWORD = 1293;
pub const ERROR_SERVICE_NOTIFY_CLIENT_LAGGING: ::DWORD = 1294;
pub const ERROR_DISK_QUOTA_EXCEEDED: ::DWORD = 1295;
pub const ERROR_CONTENT_BLOCKED: ::DWORD = 1296;
pub const ERROR_INCOMPATIBLE_SERVICE_PRIVILEGE: ::DWORD = 1297;
pub const ERROR_APP_HANG: ::DWORD = 1298;
pub const ERROR_INVALID_LABEL: ::DWORD = 1299;
pub const ERROR_NOT_ALL_ASSIGNED: ::DWORD = 1300;
pub const ERROR_SOME_NOT_MAPPED: ::DWORD = 1301;
pub const ERROR_NO_QUOTAS_FOR_ACCOUNT: ::DWORD = 1302;
pub const ERROR_LOCAL_USER_SESSION_KEY: ::DWORD = 1303;
pub const ERROR_NULL_LM_PASSWORD: ::DWORD = 1304;
pub const ERROR_UNKNOWN_REVISION: ::DWORD = 1305;
pub const ERROR_REVISION_MISMATCH: ::DWORD = 1306;
pub const ERROR_INVALID_OWNER: ::DWORD = 1307;
pub const ERROR_INVALID_PRIMARY_GROUP: ::DWORD = 1308;
pub const ERROR_NO_IMPERSONATION_TOKEN: ::DWORD = 1309;
pub const ERROR_CANT_DISABLE_MANDATORY: ::DWORD = 1310;
pub const ERROR_NO_LOGON_SERVERS: ::DWORD = 1311;
pub const ERROR_NO_SUCH_LOGON_SESSION: ::DWORD = 1312;
pub const ERROR_NO_SUCH_PRIVILEGE: ::DWORD = 1313;
pub const ERROR_PRIVILEGE_NOT_HELD: ::DWORD = 1314;
pub const ERROR_INVALID_ACCOUNT_NAME: ::DWORD = 1315;
pub const ERROR_USER_EXISTS: ::DWORD = 1316;
pub const ERROR_NO_SUCH_USER: ::DWORD = 1317;
pub const ERROR_GROUP_EXISTS: ::DWORD = 1318;
pub const ERROR_NO_SUCH_GROUP: ::DWORD = 1319;
pub const ERROR_MEMBER_IN_GROUP: ::DWORD = 1320;
pub const ERROR_MEMBER_NOT_IN_GROUP: ::DWORD = 1321;
pub const ERROR_LAST_ADMIN: ::DWORD = 1322;
pub const ERROR_WRONG_PASSWORD: ::DWORD = 1323;
pub const ERROR_ILL_FORMED_PASSWORD: ::DWORD = 1324;
pub const ERROR_PASSWORD_RESTRICTION: ::DWORD = 1325;
pub const ERROR_LOGON_FAILURE: ::DWORD = 1326;
pub const ERROR_ACCOUNT_RESTRICTION: ::DWORD = 1327;
pub const ERROR_INVALID_LOGON_HOURS: ::DWORD = 1328;
pub const ERROR_INVALID_WORKSTATION: ::DWORD = 1329;
pub const ERROR_PASSWORD_EXPIRED: ::DWORD = 1330;
pub const ERROR_ACCOUNT_DISABLED: ::DWORD = 1331;
pub const ERROR_NONE_MAPPED: ::DWORD = 1332;
pub const ERROR_TOO_MANY_LUIDS_REQUESTED: ::DWORD = 1333;
pub const ERROR_LUIDS_EXHAUSTED: ::DWORD = 1334;
pub const ERROR_INVALID_SUB_AUTHORITY: ::DWORD = 1335;
pub const ERROR_INVALID_ACL: ::DWORD = 1336;
pub const ERROR_INVALID_SID: ::DWORD = 1337;
pub const ERROR_INVALID_SECURITY_DESCR: ::DWORD = 1338;
pub const ERROR_BAD_INHERITANCE_ACL: ::DWORD = 1340;
pub const ERROR_SERVER_DISABLED: ::DWORD = 1341;
pub const ERROR_SERVER_NOT_DISABLED: ::DWORD = 1342;
pub const ERROR_INVALID_ID_AUTHORITY: ::DWORD = 1343;
pub const ERROR_ALLOTTED_SPACE_EXCEEDED: ::DWORD = 1344;
pub const ERROR_INVALID_GROUP_ATTRIBUTES: ::DWORD = 1345;
pub const ERROR_BAD_IMPERSONATION_LEVEL: ::DWORD = 1346;
pub const ERROR_CANT_OPEN_ANONYMOUS: ::DWORD = 1347;
pub const ERROR_BAD_VALIDATION_CLASS: ::DWORD = 1348;
pub const ERROR_BAD_TOKEN_TYPE: ::DWORD = 1349;
pub const ERROR_NO_SECURITY_ON_OBJECT: ::DWORD = 1350;
pub const ERROR_CANT_ACCESS_DOMAIN_INFO: ::DWORD = 1351;
pub const ERROR_INVALID_SERVER_STATE: ::DWORD = 1352;
pub const ERROR_INVALID_DOMAIN_STATE: ::DWORD = 1353;
pub const ERROR_INVALID_DOMAIN_ROLE: ::DWORD = 1354;
pub const ERROR_NO_SUCH_DOMAIN: ::DWORD = 1355;
pub const ERROR_DOMAIN_EXISTS: ::DWORD = 1356;
pub const ERROR_DOMAIN_LIMIT_EXCEEDED: ::DWORD = 1357;
pub const ERROR_INTERNAL_DB_CORRUPTION: ::DWORD = 1358;
pub const ERROR_INTERNAL_ERROR: ::DWORD = 1359;
pub const ERROR_GENERIC_NOT_MAPPED: ::DWORD = 1360;
pub const ERROR_BAD_DESCRIPTOR_FORMAT: ::DWORD = 1361;
pub const ERROR_NOT_LOGON_PROCESS: ::DWORD = 1362;
pub const ERROR_LOGON_SESSION_EXISTS: ::DWORD = 1363;
pub const ERROR_NO_SUCH_PACKAGE: ::DWORD = 1364;
pub const ERROR_BAD_LOGON_SESSION_STATE: ::DWORD = 1365;
pub const ERROR_LOGON_SESSION_COLLISION: ::DWORD = 1366;
pub const ERROR_INVALID_LOGON_TYPE: ::DWORD = 1367;
pub const ERROR_CANNOT_IMPERSONATE: ::DWORD = 1368;
pub const ERROR_RXACT_INVALID_STATE: ::DWORD = 1369;
pub const ERROR_RXACT_COMMIT_FAILURE: ::DWORD = 1370;
pub const ERROR_SPECIAL_ACCOUNT: ::DWORD = 1371;
pub const ERROR_SPECIAL_GROUP: ::DWORD = 1372;
pub const ERROR_SPECIAL_USER: ::DWORD = 1373;
pub const ERROR_MEMBERS_PRIMARY_GROUP: ::DWORD = 1374;
pub const ERROR_TOKEN_ALREADY_IN_USE: ::DWORD = 1375;
pub const ERROR_NO_SUCH_ALIAS: ::DWORD = 1376;
pub const ERROR_MEMBER_NOT_IN_ALIAS: ::DWORD = 1377;
pub const ERROR_MEMBER_IN_ALIAS: ::DWORD = 1378;
pub const ERROR_ALIAS_EXISTS: ::DWORD = 1379;
pub const ERROR_LOGON_NOT_GRANTED: ::DWORD = 1380;
pub const ERROR_TOO_MANY_SECRETS: ::DWORD = 1381;
pub const ERROR_SECRET_TOO_LONG: ::DWORD = 1382;
pub const ERROR_INTERNAL_DB_ERROR: ::DWORD = 1383;
pub const ERROR_TOO_MANY_CONTEXT_IDS: ::DWORD = 1384;
pub const ERROR_LOGON_TYPE_NOT_GRANTED: ::DWORD = 1385;
pub const ERROR_NT_CROSS_ENCRYPTION_REQUIRED: ::DWORD = 1386;
pub const ERROR_NO_SUCH_MEMBER: ::DWORD = 1387;
pub const ERROR_INVALID_MEMBER: ::DWORD = 1388;
pub const ERROR_TOO_MANY_SIDS: ::DWORD = 1389;
pub const ERROR_LM_CROSS_ENCRYPTION_REQUIRED: ::DWORD = 1390;
pub const ERROR_NO_INHERITANCE: ::DWORD = 1391;
pub const ERROR_FILE_CORRUPT: ::DWORD = 1392;
pub const ERROR_DISK_CORRUPT: ::DWORD = 1393;
pub const ERROR_NO_USER_SESSION_KEY: ::DWORD = 1394;
pub const ERROR_LICENSE_QUOTA_EXCEEDED: ::DWORD = 1395;
pub const ERROR_WRONG_TARGET_NAME: ::DWORD = 1396;
pub const ERROR_MUTUAL_AUTH_FAILED: ::DWORD = 1397;
pub const ERROR_TIME_SKEW: ::DWORD = 1398;
pub const ERROR_CURRENT_DOMAIN_NOT_ALLOWED: ::DWORD = 1399;
pub const ERROR_INVALID_WINDOW_HANDLE: ::DWORD = 1400;
pub const ERROR_INVALID_MENU_HANDLE: ::DWORD = 1401;
pub const ERROR_INVALID_CURSOR_HANDLE: ::DWORD = 1402;
pub const ERROR_INVALID_ACCEL_HANDLE: ::DWORD = 1403;
pub const ERROR_INVALID_HOOK_HANDLE: ::DWORD = 1404;
pub const ERROR_INVALID_DWP_HANDLE: ::DWORD = 1405;
pub const ERROR_TLW_WITH_WSCHILD: ::DWORD = 1406;
pub const ERROR_CANNOT_FIND_WND_CLASS: ::DWORD = 1407;
pub const ERROR_WINDOW_OF_OTHER_THREAD: ::DWORD = 1408;
pub const ERROR_HOTKEY_ALREADY_REGISTERED: ::DWORD = 1409;
pub const ERROR_CLASS_ALREADY_EXISTS: ::DWORD = 1410;
pub const ERROR_CLASS_DOES_NOT_EXIST: ::DWORD = 1411;
pub const ERROR_CLASS_HAS_WINDOWS: ::DWORD = 1412;
pub const ERROR_INVALID_INDEX: ::DWORD = 1413;
pub const ERROR_INVALID_ICON_HANDLE: ::DWORD = 1414;
pub const ERROR_PRIVATE_DIALOG_INDEX: ::DWORD = 1415;
pub const ERROR_LISTBOX_ID_NOT_FOUND: ::DWORD = 1416;
pub const ERROR_NO_WILDCARD_CHARACTERS: ::DWORD = 1417;
pub const ERROR_CLIPBOARD_NOT_OPEN: ::DWORD = 1418;
pub const ERROR_HOTKEY_NOT_REGISTERED: ::DWORD = 1419;
pub const ERROR_WINDOW_NOT_DIALOG: ::DWORD = 1420;
pub const ERROR_CONTROL_ID_NOT_FOUND: ::DWORD = 1421;
pub const ERROR_INVALID_COMBOBOX_MESSAGE: ::DWORD = 1422;
pub const ERROR_WINDOW_NOT_COMBOBOX: ::DWORD = 1423;
pub const ERROR_INVALID_EDIT_HEIGHT: ::DWORD = 1424;
pub const ERROR_DC_NOT_FOUND: ::DWORD = 1425;
pub const ERROR_INVALID_HOOK_FILTER: ::DWORD = 1426;
pub const ERROR_INVALID_FILTER_PROC: ::DWORD = 1427;
pub const ERROR_HOOK_NEEDS_HMOD: ::DWORD = 1428;
pub const ERROR_GLOBAL_ONLY_HOOK: ::DWORD = 1429;
pub const ERROR_JOURNAL_HOOK_SET: ::DWORD = 1430;
pub const ERROR_HOOK_NOT_INSTALLED: ::DWORD = 1431;
pub const ERROR_INVALID_LB_MESSAGE: ::DWORD = 1432;
pub const ERROR_SETCOUNT_ON_BAD_LB: ::DWORD = 1433;
pub const ERROR_LB_WITHOUT_TABSTOPS: ::DWORD = 1434;
pub const ERROR_DESTROY_OBJECT_OF_OTHER_THREAD: ::DWORD = 1435;
pub const ERROR_CHILD_WINDOW_MENU: ::DWORD = 1436;
pub const ERROR_NO_SYSTEM_MENU: ::DWORD = 1437;
pub const ERROR_INVALID_MSGBOX_STYLE: ::DWORD = 1438;
pub const ERROR_INVALID_SPI_VALUE: ::DWORD = 1439;
pub const ERROR_SCREEN_ALREADY_LOCKED: ::DWORD = 1440;
pub const ERROR_HWNDS_HAVE_DIFF_PARENT: ::DWORD = 1441;
pub const ERROR_NOT_CHILD_WINDOW: ::DWORD = 1442;
pub const ERROR_INVALID_GW_COMMAND: ::DWORD = 1443;
pub const ERROR_INVALID_THREAD_ID: ::DWORD = 1444;
pub const ERROR_NON_MDICHILD_WINDOW: ::DWORD = 1445;
pub const ERROR_POPUP_ALREADY_ACTIVE: ::DWORD = 1446;
pub const ERROR_NO_SCROLLBARS: ::DWORD = 1447;
pub const ERROR_INVALID_SCROLLBAR_RANGE: ::DWORD = 1448;
pub const ERROR_INVALID_SHOWWIN_COMMAND: ::DWORD = 1449;
pub const ERROR_NO_SYSTEM_RESOURCES: ::DWORD = 1450;
pub const ERROR_NONPAGED_SYSTEM_RESOURCES: ::DWORD = 1451;
pub const ERROR_PAGED_SYSTEM_RESOURCES: ::DWORD = 1452;
pub const ERROR_WORKING_SET_QUOTA: ::DWORD = 1453;
pub const ERROR_PAGEFILE_QUOTA: ::DWORD = 1454;
pub const ERROR_COMMITMENT_LIMIT: ::DWORD = 1455;
pub const ERROR_MENU_ITEM_NOT_FOUND: ::DWORD = 1456;
pub const ERROR_INVALID_KEYBOARD_HANDLE: ::DWORD = 1457;
pub const ERROR_HOOK_TYPE_NOT_ALLOWED: ::DWORD = 1458;
pub const ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION: ::DWORD = 1459;
pub const ERROR_TIMEOUT: ::DWORD = 1460;
pub const ERROR_INVALID_MONITOR_HANDLE: ::DWORD = 1461;
pub const ERROR_INCORRECT_SIZE: ::DWORD = 1462;
pub const ERROR_SYMLINK_CLASS_DISABLED: ::DWORD = 1463;
pub const ERROR_SYMLINK_NOT_SUPPORTED: ::DWORD = 1464;
pub const ERROR_XML_PARSE_ERROR: ::DWORD = 1465;
pub const ERROR_XMLDSIG_ERROR: ::DWORD = 1466;
pub const ERROR_RESTART_APPLICATION: ::DWORD = 1467;
pub const ERROR_WRONG_COMPARTMENT: ::DWORD = 1468;
pub const ERROR_AUTHIP_FAILURE: ::DWORD = 1469;
pub const ERROR_NO_NVRAM_RESOURCES: ::DWORD = 1470;
pub const ERROR_NOT_GUI_PROCESS: ::DWORD = 1471;
pub const ERROR_EVENTLOG_FILE_CORRUPT: ::DWORD = 1500;
pub const ERROR_EVENTLOG_CANT_START: ::DWORD = 1501;
pub const ERROR_LOG_FILE_FULL: ::DWORD = 1502;
pub const ERROR_EVENTLOG_FILE_CHANGED: ::DWORD = 1503;
pub const ERROR_INVALID_TASK_NAME: ::DWORD = 1550;
pub const ERROR_INVALID_TASK_INDEX: ::DWORD = 1551;
pub const ERROR_THREAD_ALREADY_IN_TASK: ::DWORD = 1552;
pub const ERROR_INSTALL_SERVICE_FAILURE: ::DWORD = 1601;
pub const ERROR_INSTALL_USEREXIT: ::DWORD = 1602;
pub const ERROR_INSTALL_FAILURE: ::DWORD = 1603;
pub const ERROR_INSTALL_SUSPEND: ::DWORD = 1604;
pub const ERROR_UNKNOWN_PRODUCT: ::DWORD = 1605;
pub const ERROR_UNKNOWN_FEATURE: ::DWORD = 1606;
pub const ERROR_UNKNOWN_COMPONENT: ::DWORD = 1607;
pub const ERROR_UNKNOWN_PROPERTY: ::DWORD = 1608;
pub const ERROR_INVALID_HANDLE_STATE: ::DWORD = 1609;
pub const ERROR_BAD_CONFIGURATION: ::DWORD = 1610;
pub const ERROR_INDEX_ABSENT: ::DWORD = 1611;
pub const ERROR_INSTALL_SOURCE_ABSENT: ::DWORD = 1612;
pub const ERROR_INSTALL_PACKAGE_VERSION: ::DWORD = 1613;
pub const ERROR_PRODUCT_UNINSTALLED: ::DWORD = 1614;
pub const ERROR_BAD_QUERY_SYNTAX: ::DWORD = 1615;
pub const ERROR_INVALID_FIELD: ::DWORD = 1616;
pub const ERROR_DEVICE_REMOVED: ::DWORD = 1617;
pub const ERROR_INSTALL_ALREADY_RUNNING: ::DWORD = 1618;
pub const ERROR_INSTALL_PACKAGE_OPEN_FAILED: ::DWORD = 1619;
pub const ERROR_INSTALL_PACKAGE_INVALID: ::DWORD = 1620;
pub const ERROR_INSTALL_UI_FAILURE: ::DWORD = 1621;
pub const ERROR_INSTALL_LOG_FAILURE: ::DWORD = 1622;
pub const ERROR_INSTALL_LANGUAGE_UNSUPPORTED: ::DWORD = 1623;
pub const ERROR_INSTALL_TRANSFORM_FAILURE: ::DWORD = 1624;
pub const ERROR_INSTALL_PACKAGE_REJECTED: ::DWORD = 1625;
pub const ERROR_FUNCTION_NOT_CALLED: ::DWORD = 1626;
pub const ERROR_FUNCTION_FAILED: ::DWORD = 1627;
pub const ERROR_INVALID_TABLE: ::DWORD = 1628;
pub const ERROR_DATATYPE_MISMATCH: ::DWORD = 1629;
pub const ERROR_UNSUPPORTED_TYPE: ::DWORD = 1630;
pub const ERROR_CREATE_FAILED: ::DWORD = 1631;
pub const ERROR_INSTALL_TEMP_UNWRITABLE: ::DWORD = 1632;
pub const ERROR_INSTALL_PLATFORM_UNSUPPORTED: ::DWORD = 1633;
pub const ERROR_INSTALL_NOTUSED: ::DWORD = 1634;
pub const ERROR_PATCH_PACKAGE_OPEN_FAILED: ::DWORD = 1635;
pub const ERROR_PATCH_PACKAGE_INVALID: ::DWORD = 1636;
pub const ERROR_PATCH_PACKAGE_UNSUPPORTED: ::DWORD = 1637;
pub const ERROR_PRODUCT_VERSION: ::DWORD = 1638;
pub const ERROR_INVALID_COMMAND_LINE: ::DWORD = 1639;
pub const ERROR_INSTALL_REMOTE_DISALLOWED: ::DWORD = 1640;
pub const ERROR_SUCCESS_REBOOT_INITIATED: ::DWORD = 1641;
pub const ERROR_PATCH_TARGET_NOT_FOUND: ::DWORD = 1642;
pub const ERROR_PATCH_PACKAGE_REJECTED: ::DWORD = 1643;
pub const ERROR_INSTALL_TRANSFORM_REJECTED: ::DWORD = 1644;
pub const ERROR_INSTALL_REMOTE_PROHIBITED: ::DWORD = 1645;
pub const ERROR_PATCH_REMOVAL_UNSUPPORTED: ::DWORD = 1646;
pub const ERROR_UNKNOWN_PATCH: ::DWORD = 1647;
pub const ERROR_PATCH_NO_SEQUENCE: ::DWORD = 1648;
pub const ERROR_PATCH_REMOVAL_DISALLOWED: ::DWORD = 1649;
pub const ERROR_INVALID_PATCH_XML: ::DWORD = 1650;
pub const ERROR_PATCH_MANAGED_ADVERTISED_PRODUCT: ::DWORD = 1651;
pub const ERROR_INSTALL_SERVICE_SAFEBOOT: ::DWORD = 1652;
pub const ERROR_FAIL_FAST_EXCEPTION: ::DWORD = 1653;
pub const ERROR_INSTALL_REJECTED: ::DWORD = 1654;
pub const ERROR_DYNAMIC_CODE_BLOCKED: ::DWORD = 1655;
pub const RPC_S_INVALID_STRING_BINDING: ::DWORD = 1700;
pub const RPC_S_WRONG_KIND_OF_BINDING: ::DWORD = 1701;
pub const RPC_S_INVALID_BINDING: ::DWORD = 1702;
pub const RPC_S_PROTSEQ_NOT_SUPPORTED: ::DWORD = 1703;
pub const RPC_S_INVALID_RPC_PROTSEQ: ::DWORD = 1704;
pub const RPC_S_INVALID_STRING_UUID: ::DWORD = 1705;
pub const RPC_S_INVALID_ENDPOINT_FORMAT: ::DWORD = 1706;
pub const RPC_S_INVALID_NET_ADDR: ::DWORD = 1707;
pub const RPC_S_NO_ENDPOINT_FOUND: ::DWORD = 1708;
pub const RPC_S_INVALID_TIMEOUT: ::DWORD = 1709;
pub const RPC_S_OBJECT_NOT_FOUND: ::DWORD = 1710;
pub const RPC_S_ALREADY_REGISTERED: ::DWORD = 1711;
pub const RPC_S_TYPE_ALREADY_REGISTERED: ::DWORD = 1712;
pub const RPC_S_ALREADY_LISTENING: ::DWORD = 1713;
pub const RPC_S_NO_PROTSEQS_REGISTERED: ::DWORD = 1714;
pub const RPC_S_NOT_LISTENING: ::DWORD = 1715;
pub const RPC_S_UNKNOWN_MGR_TYPE: ::DWORD = 1716;
pub const RPC_S_UNKNOWN_IF: ::DWORD = 1717;
pub const RPC_S_NO_BINDINGS: ::DWORD = 1718;
pub const RPC_S_NO_PROTSEQS: ::DWORD = 1719;
pub const RPC_S_CANT_CREATE_ENDPOINT: ::DWORD = 1720;
pub const RPC_S_OUT_OF_RESOURCES: ::DWORD = 1721;
pub const RPC_S_SERVER_UNAVAILABLE: ::DWORD = 1722;
pub const RPC_S_SERVER_TOO_BUSY: ::DWORD = 1723;
pub const RPC_S_INVALID_NETWORK_OPTIONS: ::DWORD = 1724;
pub const RPC_S_NO_CALL_ACTIVE: ::DWORD = 1725;
pub const RPC_S_CALL_FAILED: ::DWORD = 1726;
pub const RPC_S_CALL_FAILED_DNE: ::DWORD = 1727;
pub const RPC_S_PROTOCOL_ERROR: ::DWORD = 1728;
pub const RPC_S_PROXY_ACCESS_DENIED: ::DWORD = 1729;
pub const RPC_S_UNSUPPORTED_TRANS_SYN: ::DWORD = 1730;
pub const RPC_S_UNSUPPORTED_TYPE: ::DWORD = 1732;
pub const RPC_S_INVALID_TAG: ::DWORD = 1733;
pub const RPC_S_INVALID_BOUND: ::DWORD = 1734;
pub const RPC_S_NO_ENTRY_NAME: ::DWORD = 1735;
pub const RPC_S_INVALID_NAME_SYNTAX: ::DWORD = 1736;
pub const RPC_S_UNSUPPORTED_NAME_SYNTAX: ::DWORD = 1737;
pub const RPC_S_UUID_NO_ADDRESS: ::DWORD = 1739;
pub const RPC_S_DUPLICATE_ENDPOINT: ::DWORD = 1740;
pub const RPC_S_UNKNOWN_AUTHN_TYPE: ::DWORD = 1741;
pub const RPC_S_MAX_CALLS_TOO_SMALL: ::DWORD = 1742;
pub const RPC_S_STRING_TOO_LONG: ::DWORD = 1743;
pub const RPC_S_PROTSEQ_NOT_FOUND: ::DWORD = 1744;
pub const RPC_S_PROCNUM_OUT_OF_RANGE: ::DWORD = 1745;
pub const RPC_S_BINDING_HAS_NO_AUTH: ::DWORD = 1746;
pub const RPC_S_UNKNOWN_AUTHN_SERVICE: ::DWORD = 1747;
pub const RPC_S_UNKNOWN_AUTHN_LEVEL: ::DWORD = 1748;
pub const RPC_S_INVALID_AUTH_IDENTITY: ::DWORD = 1749;
pub const RPC_S_UNKNOWN_AUTHZ_SERVICE: ::DWORD = 1750;
pub const EPT_S_INVALID_ENTRY: ::DWORD = 1751;
pub const EPT_S_CANT_PERFORM_OP: ::DWORD = 1752;
pub const EPT_S_NOT_REGISTERED: ::DWORD = 1753;
pub const RPC_S_NOTHING_TO_EXPORT: ::DWORD = 1754;
pub const RPC_S_INCOMPLETE_NAME: ::DWORD = 1755;
pub const RPC_S_INVALID_VERS_OPTION: ::DWORD = 1756;
pub const RPC_S_NO_MORE_MEMBERS: ::DWORD = 1757;
pub const RPC_S_NOT_ALL_OBJS_UNEXPORTED: ::DWORD = 1758;
pub const RPC_S_INTERFACE_NOT_FOUND: ::DWORD = 1759;
pub const RPC_S_ENTRY_ALREADY_EXISTS: ::DWORD = 1760;
pub const RPC_S_ENTRY_NOT_FOUND: ::DWORD = 1761;
pub const RPC_S_NAME_SERVICE_UNAVAILABLE: ::DWORD = 1762;
pub const RPC_S_INVALID_NAF_ID: ::DWORD = 1763;
pub const RPC_S_CANNOT_SUPPORT: ::DWORD = 1764;
pub const RPC_S_NO_CONTEXT_AVAILABLE: ::DWORD = 1765;
pub const RPC_S_INTERNAL_ERROR: ::DWORD = 1766;
pub const RPC_S_ZERO_DIVIDE: ::DWORD = 1767;
pub const RPC_S_ADDRESS_ERROR: ::DWORD = 1768;
pub const RPC_S_FP_DIV_ZERO: ::DWORD = 1769;
pub const RPC_S_FP_UNDERFLOW: ::DWORD = 1770;
pub const RPC_S_FP_OVERFLOW: ::DWORD = 1771;
pub const RPC_X_NO_MORE_ENTRIES: ::DWORD = 1772;
pub const RPC_X_SS_CHAR_TRANS_OPEN_FAIL: ::DWORD = 1773;
pub const RPC_X_SS_CHAR_TRANS_SHORT_FILE: ::DWORD = 1774;
pub const RPC_X_SS_IN_NULL_CONTEXT: ::DWORD = 1775;
pub const RPC_X_SS_CONTEXT_DAMAGED: ::DWORD = 1777;
pub const RPC_X_SS_HANDLES_MISMATCH: ::DWORD = 1778;
pub const RPC_X_SS_CANNOT_GET_CALL_HANDLE: ::DWORD = 1779;
pub const RPC_X_NULL_REF_POINTER: ::DWORD = 1780;
pub const RPC_X_ENUM_VALUE_OUT_OF_RANGE: ::DWORD = 1781;
pub const RPC_X_BYTE_COUNT_TOO_SMALL: ::DWORD = 1782;
pub const RPC_X_BAD_STUB_DATA: ::DWORD = 1783;
pub const ERROR_INVALID_USER_BUFFER: ::DWORD = 1784;
pub const ERROR_UNRECOGNIZED_MEDIA: ::DWORD = 1785;
pub const ERROR_NO_TRUST_LSA_SECRET: ::DWORD = 1786;
pub const ERROR_NO_TRUST_SAM_ACCOUNT: ::DWORD = 1787;
pub const ERROR_TRUSTED_DOMAIN_FAILURE: ::DWORD = 1788;
pub const ERROR_TRUSTED_RELATIONSHIP_FAILURE: ::DWORD = 1789;
pub const ERROR_TRUST_FAILURE: ::DWORD = 1790;
pub const RPC_S_CALL_IN_PROGRESS: ::DWORD = 1791;
pub const ERROR_NETLOGON_NOT_STARTED: ::DWORD = 1792;
pub const ERROR_ACCOUNT_EXPIRED: ::DWORD = 1793;
pub const ERROR_REDIRECTOR_HAS_OPEN_HANDLES: ::DWORD = 1794;
pub const ERROR_PRINTER_DRIVER_ALREADY_INSTALLED: ::DWORD = 1795;
pub const ERROR_UNKNOWN_PORT: ::DWORD = 1796;
pub const ERROR_UNKNOWN_PRINTER_DRIVER: ::DWORD = 1797;
pub const ERROR_UNKNOWN_PRINTPROCESSOR: ::DWORD = 1798;
pub const ERROR_INVALID_SEPARATOR_FILE: ::DWORD = 1799;
pub const ERROR_INVALID_PRIORITY: ::DWORD = 1800;
pub const ERROR_INVALID_PRINTER_NAME: ::DWORD = 1801;
pub const ERROR_PRINTER_ALREADY_EXISTS: ::DWORD = 1802;
pub const ERROR_INVALID_PRINTER_COMMAND: ::DWORD = 1803;
pub const ERROR_INVALID_DATATYPE: ::DWORD = 1804;
pub const ERROR_INVALID_ENVIRONMENT: ::DWORD = 1805;
pub const RPC_S_NO_MORE_BINDINGS: ::DWORD = 1806;
pub const ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT: ::DWORD = 1807;
pub const ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT: ::DWORD = 1808;
pub const ERROR_NOLOGON_SERVER_TRUST_ACCOUNT: ::DWORD = 1809;
pub const ERROR_DOMAIN_TRUST_INCONSISTENT: ::DWORD = 1810;
pub const ERROR_SERVER_HAS_OPEN_HANDLES: ::DWORD = 1811;
pub const ERROR_RESOURCE_DATA_NOT_FOUND: ::DWORD = 1812;
pub const ERROR_RESOURCE_TYPE_NOT_FOUND: ::DWORD = 1813;
pub const ERROR_RESOURCE_NAME_NOT_FOUND: ::DWORD = 1814;
pub const ERROR_RESOURCE_LANG_NOT_FOUND: ::DWORD = 1815;
pub const ERROR_NOT_ENOUGH_QUOTA: ::DWORD = 1816;
pub const RPC_S_NO_INTERFACES: ::DWORD = 1817;
pub const RPC_S_CALL_CANCELLED: ::DWORD = 1818;
pub const RPC_S_BINDING_INCOMPLETE: ::DWORD = 1819;
pub const RPC_S_COMM_FAILURE: ::DWORD = 1820;
pub const RPC_S_UNSUPPORTED_AUTHN_LEVEL: ::DWORD = 1821;
pub const RPC_S_NO_PRINC_NAME: ::DWORD = 1822;
pub const RPC_S_NOT_RPC_ERROR: ::DWORD = 1823;
pub const RPC_S_UUID_LOCAL_ONLY: ::DWORD = 1824;
pub const RPC_S_SEC_PKG_ERROR: ::DWORD = 1825;
pub const RPC_S_NOT_CANCELLED: ::DWORD = 1826;
pub const RPC_X_INVALID_ES_ACTION: ::DWORD = 1827;
pub const RPC_X_WRONG_ES_VERSION: ::DWORD = 1828;
pub const RPC_X_WRONG_STUB_VERSION: ::DWORD = 1829;
pub const RPC_X_INVALID_PIPE_OBJECT: ::DWORD = 1830;
pub const RPC_X_WRONG_PIPE_ORDER: ::DWORD = 1831;
pub const RPC_X_WRONG_PIPE_VERSION: ::DWORD = 1832;
pub const RPC_S_COOKIE_AUTH_FAILED: ::DWORD = 1833;
pub const RPC_S_GROUP_MEMBER_NOT_FOUND: ::DWORD = 1898;
pub const EPT_S_CANT_CREATE: ::DWORD = 1899;
pub const RPC_S_INVALID_OBJECT: ::DWORD = 1900;
pub const ERROR_INVALID_TIME: ::DWORD = 1901;
pub const ERROR_INVALID_FORM_NAME: ::DWORD = 1902;
pub const ERROR_INVALID_FORM_SIZE: ::DWORD = 1903;
pub const ERROR_ALREADY_WAITING: ::DWORD = 1904;
pub const ERROR_PRINTER_DELETED: ::DWORD = 1905;
pub const ERROR_INVALID_PRINTER_STATE: ::DWORD = 1906;
pub const ERROR_PASSWORD_MUST_CHANGE: ::DWORD = 1907;
pub const ERROR_DOMAIN_CONTROLLER_NOT_FOUND: ::DWORD = 1908;
pub const ERROR_ACCOUNT_LOCKED_OUT: ::DWORD = 1909;
pub const OR_INVALID_OXID: ::DWORD = 1910;
pub const OR_INVALID_OID: ::DWORD = 1911;
pub const OR_INVALID_SET: ::DWORD = 1912;
pub const RPC_S_SEND_INCOMPLETE: ::DWORD = 1913;
pub const RPC_S_INVALID_ASYNC_HANDLE: ::DWORD = 1914;
pub const RPC_S_INVALID_ASYNC_CALL: ::DWORD = 1915;
pub const RPC_X_PIPE_CLOSED: ::DWORD = 1916;
pub const RPC_X_PIPE_DISCIPLINE_ERROR: ::DWORD = 1917;
pub const RPC_X_PIPE_EMPTY: ::DWORD = 1918;
pub const ERROR_NO_SITENAME: ::DWORD = 1919;
pub const ERROR_CANT_ACCESS_FILE: ::DWORD = 1920;
pub const ERROR_CANT_RESOLVE_FILENAME: ::DWORD = 1921;
pub const RPC_S_ENTRY_TYPE_MISMATCH: ::DWORD = 1922;
pub const RPC_S_NOT_ALL_OBJS_EXPORTED: ::DWORD = 1923;
pub const RPC_S_INTERFACE_NOT_EXPORTED: ::DWORD = 1924;
pub const RPC_S_PROFILE_NOT_ADDED: ::DWORD = 1925;
pub const RPC_S_PRF_ELT_NOT_ADDED: ::DWORD = 1926;
pub const RPC_S_PRF_ELT_NOT_REMOVED: ::DWORD = 1927;
pub const RPC_S_GRP_ELT_NOT_ADDED: ::DWORD = 1928;
pub const RPC_S_GRP_ELT_NOT_REMOVED: ::DWORD = 1929;
pub const ERROR_KM_DRIVER_BLOCKED: ::DWORD = 1930;
pub const ERROR_CONTEXT_EXPIRED: ::DWORD = 1931;
pub const ERROR_PER_USER_TRUST_QUOTA_EXCEEDED: ::DWORD = 1932;
pub const ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED: ::DWORD = 1933;
pub const ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED: ::DWORD = 1934;
pub const ERROR_AUTHENTICATION_FIREWALL_FAILED: ::DWORD = 1935;
pub const ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED: ::DWORD = 1936;
pub const ERROR_NTLM_BLOCKED: ::DWORD = 1937;
pub const ERROR_PASSWORD_CHANGE_REQUIRED: ::DWORD = 1938;
pub const ERROR_INVALID_PIXEL_FORMAT: ::DWORD = 2000;
pub const ERROR_BAD_DRIVER: ::DWORD = 2001;
pub const ERROR_INVALID_WINDOW_STYLE: ::DWORD = 2002;
pub const ERROR_METAFILE_NOT_SUPPORTED: ::DWORD = 2003;
pub const ERROR_TRANSFORM_NOT_SUPPORTED: ::DWORD = 2004;
pub const ERROR_CLIPPING_NOT_SUPPORTED: ::DWORD = 2005;
pub const ERROR_INVALID_CMM: ::DWORD = 2010;
pub const ERROR_INVALID_PROFILE: ::DWORD = 2011;
pub const ERROR_TAG_NOT_FOUND: ::DWORD = 2012;
pub const ERROR_TAG_NOT_PRESENT: ::DWORD = 2013;
pub const ERROR_DUPLICATE_TAG: ::DWORD = 2014;
pub const ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE: ::DWORD = 2015;
pub const ERROR_PROFILE_NOT_FOUND: ::DWORD = 2016;
pub const ERROR_INVALID_COLORSPACE: ::DWORD = 2017;
pub const ERROR_ICM_NOT_ENABLED: ::DWORD = 2018;
pub const ERROR_DELETING_ICM_XFORM: ::DWORD = 2019;
pub const ERROR_INVALID_TRANSFORM: ::DWORD = 2020;
pub const ERROR_COLORSPACE_MISMATCH: ::DWORD = 2021;
pub const ERROR_INVALID_COLORINDEX: ::DWORD = 2022;
pub const ERROR_PROFILE_DOES_NOT_MATCH_DEVICE: ::DWORD = 2023;
pub const ERROR_CONNECTED_OTHER_PASSWORD: ::DWORD = 2108;
pub const ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT: ::DWORD = 2109;
pub const ERROR_BAD_USERNAME: ::DWORD = 2202;
pub const ERROR_NOT_CONNECTED: ::DWORD = 2250;
pub const ERROR_OPEN_FILES: ::DWORD = 2401;
pub const ERROR_ACTIVE_CONNECTIONS: ::DWORD = 2402;
pub const ERROR_DEVICE_IN_USE: ::DWORD = 2404;
pub const ERROR_UNKNOWN_PRINT_MONITOR: ::DWORD = 3000;
pub const ERROR_PRINTER_DRIVER_IN_USE: ::DWORD = 3001;
pub const ERROR_SPOOL_FILE_NOT_FOUND: ::DWORD = 3002;
pub const ERROR_SPL_NO_STARTDOC: ::DWORD = 3003;
pub const ERROR_SPL_NO_ADDJOB: ::DWORD = 3004;
pub const ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED: ::DWORD = 3005;
pub const ERROR_PRINT_MONITOR_ALREADY_INSTALLED: ::DWORD = 3006;
pub const ERROR_INVALID_PRINT_MONITOR: ::DWORD = 3007;
pub const ERROR_PRINT_MONITOR_IN_USE: ::DWORD = 3008;
pub const ERROR_PRINTER_HAS_JOBS_QUEUED: ::DWORD = 3009;
pub const ERROR_SUCCESS_REBOOT_REQUIRED: ::DWORD = 3010;
pub const ERROR_SUCCESS_RESTART_REQUIRED: ::DWORD = 3011;
pub const ERROR_PRINTER_NOT_FOUND: ::DWORD = 3012;
pub const ERROR_PRINTER_DRIVER_WARNED: ::DWORD = 3013;
pub const ERROR_PRINTER_DRIVER_BLOCKED: ::DWORD = 3014;
pub const ERROR_PRINTER_DRIVER_PACKAGE_IN_USE: ::DWORD = 3015;
pub const ERROR_CORE_DRIVER_PACKAGE_NOT_FOUND: ::DWORD = 3016;
pub const ERROR_FAIL_REBOOT_REQUIRED: ::DWORD = 3017;
pub const ERROR_FAIL_REBOOT_INITIATED: ::DWORD = 3018;
pub const ERROR_PRINTER_DRIVER_DOWNLOAD_NEEDED: ::DWORD = 3019;
pub const ERROR_PRINT_JOB_RESTART_REQUIRED: ::DWORD = 3020;
pub const ERROR_INVALID_PRINTER_DRIVER_MANIFEST: ::DWORD = 3021;
pub const ERROR_PRINTER_NOT_SHAREABLE: ::DWORD = 3022;
pub const ERROR_REQUEST_PAUSED: ::DWORD = 3050;
pub const ERROR_IO_REISSUE_AS_CACHED: ::DWORD = 3950;
pub const ERROR_WINS_INTERNAL: ::DWORD = 4000;
pub const ERROR_CAN_NOT_DEL_LOCAL_WINS: ::DWORD = 4001;
pub const ERROR_STATIC_INIT: ::DWORD = 4002;
pub const ERROR_INC_BACKUP: ::DWORD = 4003;
pub const ERROR_FULL_BACKUP: ::DWORD = 4004;
pub const ERROR_REC_NON_EXISTENT: ::DWORD = 4005;
pub const ERROR_RPL_NOT_ALLOWED: ::DWORD = 4006;
pub const PEERDIST_ERROR_CONTENTINFO_VERSION_UNSUPPORTED: ::DWORD = 4050;
pub const PEERDIST_ERROR_CANNOT_PARSE_CONTENTINFO: ::DWORD = 4051;
pub const PEERDIST_ERROR_MISSING_DATA: ::DWORD = 4052;
pub const PEERDIST_ERROR_NO_MORE: ::DWORD = 4053;
pub const PEERDIST_ERROR_NOT_INITIALIZED: ::DWORD = 4054;
pub const PEERDIST_ERROR_ALREADY_INITIALIZED: ::DWORD = 4055;
pub const PEERDIST_ERROR_SHUTDOWN_IN_PROGRESS: ::DWORD = 4056;
pub const PEERDIST_ERROR_INVALIDATED: ::DWORD = 4057;
pub const PEERDIST_ERROR_ALREADY_EXISTS: ::DWORD = 4058;
pub const PEERDIST_ERROR_OPERATION_NOTFOUND: ::DWORD = 4059;
pub const PEERDIST_ERROR_ALREADY_COMPLETED: ::DWORD = 4060;
pub const PEERDIST_ERROR_OUT_OF_BOUNDS: ::DWORD = 4061;
pub const PEERDIST_ERROR_VERSION_UNSUPPORTED: ::DWORD = 4062;
pub const PEERDIST_ERROR_INVALID_CONFIGURATION: ::DWORD = 4063;
pub const PEERDIST_ERROR_NOT_LICENSED: ::DWORD = 4064;
pub const PEERDIST_ERROR_SERVICE_UNAVAILABLE: ::DWORD = 4065;
pub const PEERDIST_ERROR_TRUST_FAILURE: ::DWORD = 4066;
pub const ERROR_DHCP_ADDRESS_CONFLICT: ::DWORD = 4100;
pub const ERROR_WMI_GUID_NOT_FOUND: ::DWORD = 4200;
pub const ERROR_WMI_INSTANCE_NOT_FOUND: ::DWORD = 4201;
pub const ERROR_WMI_ITEMID_NOT_FOUND: ::DWORD = 4202;
pub const ERROR_WMI_TRY_AGAIN: ::DWORD = 4203;
pub const ERROR_WMI_DP_NOT_FOUND: ::DWORD = 4204;
pub const ERROR_WMI_UNRESOLVED_INSTANCE_REF: ::DWORD = 4205;
pub const ERROR_WMI_ALREADY_ENABLED: ::DWORD = 4206;
pub const ERROR_WMI_GUID_DISCONNECTED: ::DWORD = 4207;
pub const ERROR_WMI_SERVER_UNAVAILABLE: ::DWORD = 4208;
pub const ERROR_WMI_DP_FAILED: ::DWORD = 4209;
pub const ERROR_WMI_INVALID_MOF: ::DWORD = 4210;
pub const ERROR_WMI_INVALID_REGINFO: ::DWORD = 4211;
pub const ERROR_WMI_ALREADY_DISABLED: ::DWORD = 4212;
pub const ERROR_WMI_READ_ONLY: ::DWORD = 4213;
pub const ERROR_WMI_SET_FAILURE: ::DWORD = 4214;
pub const ERROR_NOT_APPCONTAINER: ::DWORD = 4250;
pub const ERROR_APPCONTAINER_REQUIRED: ::DWORD = 4251;
pub const ERROR_NOT_SUPPORTED_IN_APPCONTAINER: ::DWORD = 4252;
pub const ERROR_INVALID_PACKAGE_SID_LENGTH: ::DWORD = 4253;
pub const ERROR_INVALID_MEDIA: ::DWORD = 4300;
pub const ERROR_INVALID_LIBRARY: ::DWORD = 4301;
pub const ERROR_INVALID_MEDIA_POOL: ::DWORD = 4302;
pub const ERROR_DRIVE_MEDIA_MISMATCH: ::DWORD = 4303;
pub const ERROR_MEDIA_OFFLINE: ::DWORD = 4304;
pub const ERROR_LIBRARY_OFFLINE: ::DWORD = 4305;
pub const ERROR_EMPTY: ::DWORD = 4306;
pub const ERROR_NOT_EMPTY: ::DWORD = 4307;
pub const ERROR_MEDIA_UNAVAILABLE: ::DWORD = 4308;
pub const ERROR_RESOURCE_DISABLED: ::DWORD = 4309;
pub const ERROR_INVALID_CLEANER: ::DWORD = 4310;
pub const ERROR_UNABLE_TO_CLEAN: ::DWORD = 4311;
pub const ERROR_OBJECT_NOT_FOUND: ::DWORD = 4312;
pub const ERROR_DATABASE_FAILURE: ::DWORD = 4313;
pub const ERROR_DATABASE_FULL: ::DWORD = 4314;
pub const ERROR_MEDIA_INCOMPATIBLE: ::DWORD = 4315;
pub const ERROR_RESOURCE_NOT_PRESENT: ::DWORD = 4316;
pub const ERROR_INVALID_OPERATION: ::DWORD = 4317;
pub const ERROR_MEDIA_NOT_AVAILABLE: ::DWORD = 4318;
pub const ERROR_DEVICE_NOT_AVAILABLE: ::DWORD = 4319;
pub const ERROR_REQUEST_REFUSED: ::DWORD = 4320;
pub const ERROR_INVALID_DRIVE_OBJECT: ::DWORD = 4321;
pub const ERROR_LIBRARY_FULL: ::DWORD = 4322;
pub const ERROR_MEDIUM_NOT_ACCESSIBLE: ::DWORD = 4323;
pub const ERROR_UNABLE_TO_LOAD_MEDIUM: ::DWORD = 4324;
pub const ERROR_UNABLE_TO_INVENTORY_DRIVE: ::DWORD = 4325;
pub const ERROR_UNABLE_TO_INVENTORY_SLOT: ::DWORD = 4326;
pub const ERROR_UNABLE_TO_INVENTORY_TRANSPORT: ::DWORD = 4327;
pub const ERROR_TRANSPORT_FULL: ::DWORD = 4328;
pub const ERROR_CONTROLLING_IEPORT: ::DWORD = 4329;
pub const ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA: ::DWORD = 4330;
pub const ERROR_CLEANER_SLOT_SET: ::DWORD = 4331;
pub const ERROR_CLEANER_SLOT_NOT_SET: ::DWORD = 4332;
pub const ERROR_CLEANER_CARTRIDGE_SPENT: ::DWORD = 4333;
pub const ERROR_UNEXPECTED_OMID: ::DWORD = 4334;
pub const ERROR_CANT_DELETE_LAST_ITEM: ::DWORD = 4335;
pub const ERROR_MESSAGE_EXCEEDS_MAX_SIZE: ::DWORD = 4336;
pub const ERROR_VOLUME_CONTAINS_SYS_FILES: ::DWORD = 4337;
pub const ERROR_INDIGENOUS_TYPE: ::DWORD = 4338;
pub const ERROR_NO_SUPPORTING_DRIVES: ::DWORD = 4339;
pub const ERROR_CLEANER_CARTRIDGE_INSTALLED: ::DWORD = 4340;
pub const ERROR_IEPORT_FULL: ::DWORD = 4341;
pub const ERROR_FILE_OFFLINE: ::DWORD = 4350;
pub const ERROR_REMOTE_STORAGE_NOT_ACTIVE: ::DWORD = 4351;
pub const ERROR_REMOTE_STORAGE_MEDIA_ERROR: ::DWORD = 4352;
pub const ERROR_NOT_A_REPARSE_POINT: ::DWORD = 4390;
pub const ERROR_REPARSE_ATTRIBUTE_CONFLICT: ::DWORD = 4391;
pub const ERROR_INVALID_REPARSE_DATA: ::DWORD = 4392;
pub const ERROR_REPARSE_TAG_INVALID: ::DWORD = 4393;
pub const ERROR_REPARSE_TAG_MISMATCH: ::DWORD = 4394;
pub const ERROR_APP_DATA_NOT_FOUND: ::DWORD = 4400;
pub const ERROR_APP_DATA_EXPIRED: ::DWORD = 4401;
pub const ERROR_APP_DATA_CORRUPT: ::DWORD = 4402;
pub const ERROR_APP_DATA_LIMIT_EXCEEDED: ::DWORD = 4403;
pub const ERROR_APP_DATA_REBOOT_REQUIRED: ::DWORD = 4404;
pub const ERROR_SECUREBOOT_ROLLBACK_DETECTED: ::DWORD = 4420;
pub const ERROR_SECUREBOOT_POLICY_VIOLATION: ::DWORD = 4421;
pub const ERROR_SECUREBOOT_INVALID_POLICY: ::DWORD = 4422;
pub const ERROR_SECUREBOOT_POLICY_PUBLISHER_NOT_FOUND: ::DWORD = 4423;
pub const ERROR_SECUREBOOT_POLICY_NOT_SIGNED: ::DWORD = 4424;
pub const ERROR_SECUREBOOT_NOT_ENABLED: ::DWORD = 4425;
pub const ERROR_SECUREBOOT_FILE_REPLACED: ::DWORD = 4426;
pub const ERROR_OFFLOAD_READ_FLT_NOT_SUPPORTED: ::DWORD = 4440;
pub const ERROR_OFFLOAD_WRITE_FLT_NOT_SUPPORTED: ::DWORD = 4441;
pub const ERROR_OFFLOAD_READ_FILE_NOT_SUPPORTED: ::DWORD = 4442;
pub const ERROR_OFFLOAD_WRITE_FILE_NOT_SUPPORTED: ::DWORD = 4443;
pub const ERROR_VOLUME_NOT_SIS_ENABLED: ::DWORD = 4500;
pub const ERROR_DEPENDENT_RESOURCE_EXISTS: ::DWORD = 5001;
pub const ERROR_DEPENDENCY_NOT_FOUND: ::DWORD = 5002;
pub const ERROR_DEPENDENCY_ALREADY_EXISTS: ::DWORD = 5003;
pub const ERROR_RESOURCE_NOT_ONLINE: ::DWORD = 5004;
pub const ERROR_HOST_NODE_NOT_AVAILABLE: ::DWORD = 5005;
pub const ERROR_RESOURCE_NOT_AVAILABLE: ::DWORD = 5006;
pub const ERROR_RESOURCE_NOT_FOUND: ::DWORD = 5007;
pub const ERROR_SHUTDOWN_CLUSTER: ::DWORD = 5008;
pub const ERROR_CANT_EVICT_ACTIVE_NODE: ::DWORD = 5009;
pub const ERROR_OBJECT_ALREADY_EXISTS: ::DWORD = 5010;
pub const ERROR_OBJECT_IN_LIST: ::DWORD = 5011;
pub const ERROR_GROUP_NOT_AVAILABLE: ::DWORD = 5012;
pub const ERROR_GROUP_NOT_FOUND: ::DWORD = 5013;
pub const ERROR_GROUP_NOT_ONLINE: ::DWORD = 5014;
pub const ERROR_HOST_NODE_NOT_RESOURCE_OWNER: ::DWORD = 5015;
pub const ERROR_HOST_NODE_NOT_GROUP_OWNER: ::DWORD = 5016;
pub const ERROR_RESMON_CREATE_FAILED: ::DWORD = 5017;
pub const ERROR_RESMON_ONLINE_FAILED: ::DWORD = 5018;
pub const ERROR_RESOURCE_ONLINE: ::DWORD = 5019;
pub const ERROR_QUORUM_RESOURCE: ::DWORD = 5020;
pub const ERROR_NOT_QUORUM_CAPABLE: ::DWORD = 5021;
pub const ERROR_CLUSTER_SHUTTING_DOWN: ::DWORD = 5022;
pub const ERROR_INVALID_STATE: ::DWORD = 5023;
pub const ERROR_RESOURCE_PROPERTIES_STORED: ::DWORD = 5024;
pub const ERROR_NOT_QUORUM_CLASS: ::DWORD = 5025;
pub const ERROR_CORE_RESOURCE: ::DWORD = 5026;
pub const ERROR_QUORUM_RESOURCE_ONLINE_FAILED: ::DWORD = 5027;
pub const ERROR_QUORUMLOG_OPEN_FAILED: ::DWORD = 5028;
pub const ERROR_CLUSTERLOG_CORRUPT: ::DWORD = 5029;
pub const ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE: ::DWORD = 5030;
pub const ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE: ::DWORD = 5031;
pub const ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND: ::DWORD = 5032;
pub const ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE: ::DWORD = 5033;
pub const ERROR_QUORUM_OWNER_ALIVE: ::DWORD = 5034;
pub const ERROR_NETWORK_NOT_AVAILABLE: ::DWORD = 5035;
pub const ERROR_NODE_NOT_AVAILABLE: ::DWORD = 5036;
pub const ERROR_ALL_NODES_NOT_AVAILABLE: ::DWORD = 5037;
pub const ERROR_RESOURCE_FAILED: ::DWORD = 5038;
pub const ERROR_CLUSTER_INVALID_NODE: ::DWORD = 5039;
pub const ERROR_CLUSTER_NODE_EXISTS: ::DWORD = 5040;
pub const ERROR_CLUSTER_JOIN_IN_PROGRESS: ::DWORD = 5041;
pub const ERROR_CLUSTER_NODE_NOT_FOUND: ::DWORD = 5042;
pub const ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND: ::DWORD = 5043;
pub const ERROR_CLUSTER_NETWORK_EXISTS: ::DWORD = 5044;
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND: ::DWORD = 5045;
pub const ERROR_CLUSTER_NETINTERFACE_EXISTS: ::DWORD = 5046;
pub const ERROR_CLUSTER_NETINTERFACE_NOT_FOUND: ::DWORD = 5047;
pub const ERROR_CLUSTER_INVALID_REQUEST: ::DWORD = 5048;
pub const ERROR_CLUSTER_INVALID_NETWORK_PROVIDER: ::DWORD = 5049;
pub const ERROR_CLUSTER_NODE_DOWN: ::DWORD = 5050;
pub const ERROR_CLUSTER_NODE_UNREACHABLE: ::DWORD = 5051;
pub const ERROR_CLUSTER_NODE_NOT_MEMBER: ::DWORD = 5052;
pub const ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS: ::DWORD = 5053;
pub const ERROR_CLUSTER_INVALID_NETWORK: ::DWORD = 5054;
pub const ERROR_CLUSTER_NODE_UP: ::DWORD = 5056;
pub const ERROR_CLUSTER_IPADDR_IN_USE: ::DWORD = 5057;
pub const ERROR_CLUSTER_NODE_NOT_PAUSED: ::DWORD = 5058;
pub const ERROR_CLUSTER_NO_SECURITY_CONTEXT: ::DWORD = 5059;
pub const ERROR_CLUSTER_NETWORK_NOT_INTERNAL: ::DWORD = 5060;
pub const ERROR_CLUSTER_NODE_ALREADY_UP: ::DWORD = 5061;
pub const ERROR_CLUSTER_NODE_ALREADY_DOWN: ::DWORD = 5062;
pub const ERROR_CLUSTER_NETWORK_ALREADY_ONLINE: ::DWORD = 5063;
pub const ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE: ::DWORD = 5064;
pub const ERROR_CLUSTER_NODE_ALREADY_MEMBER: ::DWORD = 5065;
pub const ERROR_CLUSTER_LAST_INTERNAL_NETWORK: ::DWORD = 5066;
pub const ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS: ::DWORD = 5067;
pub const ERROR_INVALID_OPERATION_ON_QUORUM: ::DWORD = 5068;
pub const ERROR_DEPENDENCY_NOT_ALLOWED: ::DWORD = 5069;
pub const ERROR_CLUSTER_NODE_PAUSED: ::DWORD = 5070;
pub const ERROR_NODE_CANT_HOST_RESOURCE: ::DWORD = 5071;
pub const ERROR_CLUSTER_NODE_NOT_READY: ::DWORD = 5072;
pub const ERROR_CLUSTER_NODE_SHUTTING_DOWN: ::DWORD = 5073;
pub const ERROR_CLUSTER_JOIN_ABORTED: ::DWORD = 5074;
pub const ERROR_CLUSTER_INCOMPATIBLE_VERSIONS: ::DWORD = 5075;
pub const ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED: ::DWORD = 5076;
pub const ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED: ::DWORD = 5077;
pub const ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND: ::DWORD = 5078;
pub const ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED: ::DWORD = 5079;
pub const ERROR_CLUSTER_RESNAME_NOT_FOUND: ::DWORD = 5080;
pub const ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED: ::DWORD = 5081;
pub const ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST: ::DWORD = 5082;
pub const ERROR_CLUSTER_DATABASE_SEQMISMATCH: ::DWORD = 5083;
pub const ERROR_RESMON_INVALID_STATE: ::DWORD = 5084;
pub const ERROR_CLUSTER_GUM_NOT_LOCKER: ::DWORD = 5085;
pub const ERROR_QUORUM_DISK_NOT_FOUND: ::DWORD = 5086;
pub const ERROR_DATABASE_BACKUP_CORRUPT: ::DWORD = 5087;
pub const ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT: ::DWORD = 5088;
pub const ERROR_RESOURCE_PROPERTY_UNCHANGEABLE: ::DWORD = 5089;
pub const ERROR_NO_ADMIN_ACCESS_POINT: ::DWORD = 5090;
pub const ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE: ::DWORD = 5890;
pub const ERROR_CLUSTER_QUORUMLOG_NOT_FOUND: ::DWORD = 5891;
pub const ERROR_CLUSTER_MEMBERSHIP_HALT: ::DWORD = 5892;
pub const ERROR_CLUSTER_INSTANCE_ID_MISMATCH: ::DWORD = 5893;
pub const ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP: ::DWORD = 5894;
pub const ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH: ::DWORD = 5895;
pub const ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP: ::DWORD = 5896;
pub const ERROR_CLUSTER_PARAMETER_MISMATCH: ::DWORD = 5897;
pub const ERROR_NODE_CANNOT_BE_CLUSTERED: ::DWORD = 5898;
pub const ERROR_CLUSTER_WRONG_OS_VERSION: ::DWORD = 5899;
pub const ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME: ::DWORD = 5900;
pub const ERROR_CLUSCFG_ALREADY_COMMITTED: ::DWORD = 5901;
pub const ERROR_CLUSCFG_ROLLBACK_FAILED: ::DWORD = 5902;
pub const ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT: ::DWORD = 5903;
pub const ERROR_CLUSTER_OLD_VERSION: ::DWORD = 5904;
pub const ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME: ::DWORD = 5905;
pub const ERROR_CLUSTER_NO_NET_ADAPTERS: ::DWORD = 5906;
pub const ERROR_CLUSTER_POISONED: ::DWORD = 5907;
pub const ERROR_CLUSTER_GROUP_MOVING: ::DWORD = 5908;
pub const ERROR_CLUSTER_RESOURCE_TYPE_BUSY: ::DWORD = 5909;
pub const ERROR_RESOURCE_CALL_TIMED_OUT: ::DWORD = 5910;
pub const ERROR_INVALID_CLUSTER_IPV6_ADDRESS: ::DWORD = 5911;
pub const ERROR_CLUSTER_INTERNAL_INVALID_FUNCTION: ::DWORD = 5912;
pub const ERROR_CLUSTER_PARAMETER_OUT_OF_BOUNDS: ::DWORD = 5913;
pub const ERROR_CLUSTER_PARTIAL_SEND: ::DWORD = 5914;
pub const ERROR_CLUSTER_REGISTRY_INVALID_FUNCTION: ::DWORD = 5915;
pub const ERROR_CLUSTER_INVALID_STRING_TERMINATION: ::DWORD = 5916;
pub const ERROR_CLUSTER_INVALID_STRING_FORMAT: ::DWORD = 5917;
pub const ERROR_CLUSTER_DATABASE_TRANSACTION_IN_PROGRESS: ::DWORD = 5918;
pub const ERROR_CLUSTER_DATABASE_TRANSACTION_NOT_IN_PROGRESS: ::DWORD = 5919;
pub const ERROR_CLUSTER_NULL_DATA: ::DWORD = 5920;
pub const ERROR_CLUSTER_PARTIAL_READ: ::DWORD = 5921;
pub const ERROR_CLUSTER_PARTIAL_WRITE: ::DWORD = 5922;
pub const ERROR_CLUSTER_CANT_DESERIALIZE_DATA: ::DWORD = 5923;
pub const ERROR_DEPENDENT_RESOURCE_PROPERTY_CONFLICT: ::DWORD = 5924;
pub const ERROR_CLUSTER_NO_QUORUM: ::DWORD = 5925;
pub const ERROR_CLUSTER_INVALID_IPV6_NETWORK: ::DWORD = 5926;
pub const ERROR_CLUSTER_INVALID_IPV6_TUNNEL_NETWORK: ::DWORD = 5927;
pub const ERROR_QUORUM_NOT_ALLOWED_IN_THIS_GROUP: ::DWORD = 5928;
pub const ERROR_DEPENDENCY_TREE_TOO_COMPLEX: ::DWORD = 5929;
pub const ERROR_EXCEPTION_IN_RESOURCE_CALL: ::DWORD = 5930;
pub const ERROR_CLUSTER_RHS_FAILED_INITIALIZATION: ::DWORD = 5931;
pub const ERROR_CLUSTER_NOT_INSTALLED: ::DWORD = 5932;
pub const ERROR_CLUSTER_RESOURCES_MUST_BE_ONLINE_ON_THE_SAME_NODE: ::DWORD = 5933;
pub const ERROR_CLUSTER_MAX_NODES_IN_CLUSTER: ::DWORD = 5934;
pub const ERROR_CLUSTER_TOO_MANY_NODES: ::DWORD = 5935;
pub const ERROR_CLUSTER_OBJECT_ALREADY_USED: ::DWORD = 5936;
pub const ERROR_NONCORE_GROUPS_FOUND: ::DWORD = 5937;
pub const ERROR_FILE_SHARE_RESOURCE_CONFLICT: ::DWORD = 5938;
pub const ERROR_CLUSTER_EVICT_INVALID_REQUEST: ::DWORD = 5939;
pub const ERROR_CLUSTER_SINGLETON_RESOURCE: ::DWORD = 5940;
pub const ERROR_CLUSTER_GROUP_SINGLETON_RESOURCE: ::DWORD = 5941;
pub const ERROR_CLUSTER_RESOURCE_PROVIDER_FAILED: ::DWORD = 5942;
pub const ERROR_CLUSTER_RESOURCE_CONFIGURATION_ERROR: ::DWORD = 5943;
pub const ERROR_CLUSTER_GROUP_BUSY: ::DWORD = 5944;
pub const ERROR_CLUSTER_NOT_SHARED_VOLUME: ::DWORD = 5945;
pub const ERROR_CLUSTER_INVALID_SECURITY_DESCRIPTOR: ::DWORD = 5946;
pub const ERROR_CLUSTER_SHARED_VOLUMES_IN_USE: ::DWORD = 5947;
pub const ERROR_CLUSTER_USE_SHARED_VOLUMES_API: ::DWORD = 5948;
pub const ERROR_CLUSTER_BACKUP_IN_PROGRESS: ::DWORD = 5949;
pub const ERROR_NON_CSV_PATH: ::DWORD = 5950;
pub const ERROR_CSV_VOLUME_NOT_LOCAL: ::DWORD = 5951;
pub const ERROR_CLUSTER_WATCHDOG_TERMINATING: ::DWORD = 5952;
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_INCOMPATIBLE_NODES: ::DWORD = 5953;
pub const ERROR_CLUSTER_INVALID_NODE_WEIGHT: ::DWORD = 5954;
pub const ERROR_CLUSTER_RESOURCE_VETOED_CALL: ::DWORD = 5955;
pub const ERROR_RESMON_SYSTEM_RESOURCES_LACKING: ::DWORD = 5956;
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_DESTINATION: ::DWORD = 5957;
pub const ERROR_CLUSTER_RESOURCE_VETOED_MOVE_NOT_ENOUGH_RESOURCES_ON_SOURCE: ::DWORD = 5958;
pub const ERROR_CLUSTER_GROUP_QUEUED: ::DWORD = 5959;
pub const ERROR_CLUSTER_RESOURCE_LOCKED_STATUS: ::DWORD = 5960;
pub const ERROR_CLUSTER_SHARED_VOLUME_FAILOVER_NOT_ALLOWED: ::DWORD = 5961;
pub const ERROR_CLUSTER_NODE_DRAIN_IN_PROGRESS: ::DWORD = 5962;
pub const ERROR_CLUSTER_DISK_NOT_CONNECTED: ::DWORD = 5963;
pub const ERROR_DISK_NOT_CSV_CAPABLE: ::DWORD = 5964;
pub const ERROR_RESOURCE_NOT_IN_AVAILABLE_STORAGE: ::DWORD = 5965;
pub const ERROR_CLUSTER_SHARED_VOLUME_REDIRECTED: ::DWORD = 5966;
pub const ERROR_CLUSTER_SHARED_VOLUME_NOT_REDIRECTED: ::DWORD = 5967;
pub const ERROR_CLUSTER_CANNOT_RETURN_PROPERTIES: ::DWORD = 5968;
pub const ERROR_CLUSTER_RESOURCE_CONTAINS_UNSUPPORTED_DIFF_AREA_FOR_SHARED_VOLUMES: ::DWORD = 5969;
pub const ERROR_CLUSTER_RESOURCE_IS_IN_MAINTENANCE_MODE: ::DWORD = 5970;
pub const ERROR_CLUSTER_AFFINITY_CONFLICT: ::DWORD = 5971;
pub const ERROR_CLUSTER_RESOURCE_IS_REPLICA_VIRTUAL_MACHINE: ::DWORD = 5972;
pub const ERROR_ENCRYPTION_FAILED: ::DWORD = 6000;
pub const ERROR_DECRYPTION_FAILED: ::DWORD = 6001;
pub const ERROR_FILE_ENCRYPTED: ::DWORD = 6002;
pub const ERROR_NO_RECOVERY_POLICY: ::DWORD = 6003;
pub const ERROR_NO_EFS: ::DWORD = 6004;
pub const ERROR_WRONG_EFS: ::DWORD = 6005;
pub const ERROR_NO_USER_KEYS: ::DWORD = 6006;
pub const ERROR_FILE_NOT_ENCRYPTED: ::DWORD = 6007;
pub const ERROR_NOT_EXPORT_FORMAT: ::DWORD = 6008;
pub const ERROR_FILE_READ_ONLY: ::DWORD = 6009;
pub const ERROR_DIR_EFS_DISALLOWED: ::DWORD = 6010;
pub const ERROR_EFS_SERVER_NOT_TRUSTED: ::DWORD = 6011;
pub const ERROR_BAD_RECOVERY_POLICY: ::DWORD = 6012;
pub const ERROR_EFS_ALG_BLOB_TOO_BIG: ::DWORD = 6013;
pub const ERROR_VOLUME_NOT_SUPPORT_EFS: ::DWORD = 6014;
pub const ERROR_EFS_DISABLED: ::DWORD = 6015;
pub const ERROR_EFS_VERSION_NOT_SUPPORT: ::DWORD = 6016;
pub const ERROR_CS_ENCRYPTION_INVALID_SERVER_RESPONSE: ::DWORD = 6017;
pub const ERROR_CS_ENCRYPTION_UNSUPPORTED_SERVER: ::DWORD = 6018;
pub const ERROR_CS_ENCRYPTION_EXISTING_ENCRYPTED_FILE: ::DWORD = 6019;
pub const ERROR_CS_ENCRYPTION_NEW_ENCRYPTED_FILE: ::DWORD = 6020;
pub const ERROR_CS_ENCRYPTION_FILE_NOT_CSE: ::DWORD = 6021;
pub const ERROR_ENCRYPTION_POLICY_DENIES_OPERATION: ::DWORD = 6022;
pub const ERROR_NO_BROWSER_SERVERS_FOUND: ::DWORD = 6118;
pub const SCHED_E_SERVICE_NOT_LOCALSYSTEM: ::DWORD = 6200;
pub const ERROR_LOG_SECTOR_INVALID: ::DWORD = 6600;
pub const ERROR_LOG_SECTOR_PARITY_INVALID: ::DWORD = 6601;
pub const ERROR_LOG_SECTOR_REMAPPED: ::DWORD = 6602;
pub const ERROR_LOG_BLOCK_INCOMPLETE: ::DWORD = 6603;
pub const ERROR_LOG_INVALID_RANGE: ::DWORD = 6604;
pub const ERROR_LOG_BLOCKS_EXHAUSTED: ::DWORD = 6605;
pub const ERROR_LOG_READ_CONTEXT_INVALID: ::DWORD = 6606;
pub const ERROR_LOG_RESTART_INVALID: ::DWORD = 6607;
pub const ERROR_LOG_BLOCK_VERSION: ::DWORD = 6608;
pub const ERROR_LOG_BLOCK_INVALID: ::DWORD = 6609;
pub const ERROR_LOG_READ_MODE_INVALID: ::DWORD = 6610;
pub const ERROR_LOG_NO_RESTART: ::DWORD = 6611;
pub const ERROR_LOG_METADATA_CORRUPT: ::DWORD = 6612;
pub const ERROR_LOG_METADATA_INVALID: ::DWORD = 6613;
pub const ERROR_LOG_METADATA_INCONSISTENT: ::DWORD = 6614;
pub const ERROR_LOG_RESERVATION_INVALID: ::DWORD = 6615;
pub const ERROR_LOG_CANT_DELETE: ::DWORD = 6616;
pub const ERROR_LOG_CONTAINER_LIMIT_EXCEEDED: ::DWORD = 6617;
pub const ERROR_LOG_START_OF_LOG: ::DWORD = 6618;
pub const ERROR_LOG_POLICY_ALREADY_INSTALLED: ::DWORD = 6619;
pub const ERROR_LOG_POLICY_NOT_INSTALLED: ::DWORD = 6620;
pub const ERROR_LOG_POLICY_INVALID: ::DWORD = 6621;
pub const ERROR_LOG_POLICY_CONFLICT: ::DWORD = 6622;
pub const ERROR_LOG_PINNED_ARCHIVE_TAIL: ::DWORD = 6623;
pub const ERROR_LOG_RECORD_NONEXISTENT: ::DWORD = 6624;
pub const ERROR_LOG_RECORDS_RESERVED_INVALID: ::DWORD = 6625;
pub const ERROR_LOG_SPACE_RESERVED_INVALID: ::DWORD = 6626;
pub const ERROR_LOG_TAIL_INVALID: ::DWORD = 6627;
pub const ERROR_LOG_FULL: ::DWORD = 6628;
pub const ERROR_COULD_NOT_RESIZE_LOG: ::DWORD = 6629;
pub const ERROR_LOG_MULTIPLEXED: ::DWORD = 6630;
pub const ERROR_LOG_DEDICATED: ::DWORD = 6631;
pub const ERROR_LOG_ARCHIVE_NOT_IN_PROGRESS: ::DWORD = 6632;
pub const ERROR_LOG_ARCHIVE_IN_PROGRESS: ::DWORD = 6633;
pub const ERROR_LOG_EPHEMERAL: ::DWORD = 6634;
pub const ERROR_LOG_NOT_ENOUGH_CONTAINERS: ::DWORD = 6635;
pub const ERROR_LOG_CLIENT_ALREADY_REGISTERED: ::DWORD = 6636;
pub const ERROR_LOG_CLIENT_NOT_REGISTERED: ::DWORD = 6637;
pub const ERROR_LOG_FULL_HANDLER_IN_PROGRESS: ::DWORD = 6638;
pub const ERROR_LOG_CONTAINER_READ_FAILED: ::DWORD = 6639;
pub const ERROR_LOG_CONTAINER_WRITE_FAILED: ::DWORD = 6640;
pub const ERROR_LOG_CONTAINER_OPEN_FAILED: ::DWORD = 6641;
pub const ERROR_LOG_CONTAINER_STATE_INVALID: ::DWORD = 6642;
pub const ERROR_LOG_STATE_INVALID: ::DWORD = 6643;
pub const ERROR_LOG_PINNED: ::DWORD = 6644;
pub const ERROR_LOG_METADATA_FLUSH_FAILED: ::DWORD = 6645;
pub const ERROR_LOG_INCONSISTENT_SECURITY: ::DWORD = 6646;
pub const ERROR_LOG_APPENDED_FLUSH_FAILED: ::DWORD = 6647;
pub const ERROR_LOG_PINNED_RESERVATION: ::DWORD = 6648;
pub const ERROR_INVALID_TRANSACTION: ::DWORD = 6700;
pub const ERROR_TRANSACTION_NOT_ACTIVE: ::DWORD = 6701;
pub const ERROR_TRANSACTION_REQUEST_NOT_VALID: ::DWORD = 6702;
pub const ERROR_TRANSACTION_NOT_REQUESTED: ::DWORD = 6703;
pub const ERROR_TRANSACTION_ALREADY_ABORTED: ::DWORD = 6704;
pub const ERROR_TRANSACTION_ALREADY_COMMITTED: ::DWORD = 6705;
pub const ERROR_TM_INITIALIZATION_FAILED: ::DWORD = 6706;
pub const ERROR_RESOURCEMANAGER_READ_ONLY: ::DWORD = 6707;
pub const ERROR_TRANSACTION_NOT_JOINED: ::DWORD = 6708;
pub const ERROR_TRANSACTION_SUPERIOR_EXISTS: ::DWORD = 6709;
pub const ERROR_CRM_PROTOCOL_ALREADY_EXISTS: ::DWORD = 6710;
pub const ERROR_TRANSACTION_PROPAGATION_FAILED: ::DWORD = 6711;
pub const ERROR_CRM_PROTOCOL_NOT_FOUND: ::DWORD = 6712;
pub const ERROR_TRANSACTION_INVALID_MARSHALL_BUFFER: ::DWORD = 6713;
pub const ERROR_CURRENT_TRANSACTION_NOT_VALID: ::DWORD = 6714;
pub const ERROR_TRANSACTION_NOT_FOUND: ::DWORD = 6715;
pub const ERROR_RESOURCEMANAGER_NOT_FOUND: ::DWORD = 6716;
pub const ERROR_ENLISTMENT_NOT_FOUND: ::DWORD = 6717;
pub const ERROR_TRANSACTIONMANAGER_NOT_FOUND: ::DWORD = 6718;
pub const ERROR_TRANSACTIONMANAGER_NOT_ONLINE: ::DWORD = 6719;
pub const ERROR_TRANSACTIONMANAGER_RECOVERY_NAME_COLLISION: ::DWORD = 6720;
pub const ERROR_TRANSACTION_NOT_ROOT: ::DWORD = 6721;
pub const ERROR_TRANSACTION_OBJECT_EXPIRED: ::DWORD = 6722;
pub const ERROR_TRANSACTION_RESPONSE_NOT_ENLISTED: ::DWORD = 6723;
pub const ERROR_TRANSACTION_RECORD_TOO_LONG: ::DWORD = 6724;
pub const ERROR_IMPLICIT_TRANSACTION_NOT_SUPPORTED: ::DWORD = 6725;
pub const ERROR_TRANSACTION_INTEGRITY_VIOLATED: ::DWORD = 6726;
pub const ERROR_TRANSACTIONMANAGER_IDENTITY_MISMATCH: ::DWORD = 6727;
pub const ERROR_RM_CANNOT_BE_FROZEN_FOR_SNAPSHOT: ::DWORD = 6728;
pub const ERROR_TRANSACTION_MUST_WRITETHROUGH: ::DWORD = 6729;
pub const ERROR_TRANSACTION_NO_SUPERIOR: ::DWORD = 6730;
pub const ERROR_HEURISTIC_DAMAGE_POSSIBLE: ::DWORD = 6731;
pub const ERROR_TRANSACTIONAL_CONFLICT: ::DWORD = 6800;
pub const ERROR_RM_NOT_ACTIVE: ::DWORD = 6801;
pub const ERROR_RM_METADATA_CORRUPT: ::DWORD = 6802;
pub const ERROR_DIRECTORY_NOT_RM: ::DWORD = 6803;
pub const ERROR_TRANSACTIONS_UNSUPPORTED_REMOTE: ::DWORD = 6805;
pub const ERROR_LOG_RESIZE_INVALID_SIZE: ::DWORD = 6806;
pub const ERROR_OBJECT_NO_LONGER_EXISTS: ::DWORD = 6807;
pub const ERROR_STREAM_MINIVERSION_NOT_FOUND: ::DWORD = 6808;
pub const ERROR_STREAM_MINIVERSION_NOT_VALID: ::DWORD = 6809;
pub const ERROR_MINIVERSION_INACCESSIBLE_FROM_SPECIFIED_TRANSACTION: ::DWORD = 6810;
pub const ERROR_CANT_OPEN_MINIVERSION_WITH_MODIFY_INTENT: ::DWORD = 6811;
pub const ERROR_CANT_CREATE_MORE_STREAM_MINIVERSIONS: ::DWORD = 6812;
pub const ERROR_REMOTE_FILE_VERSION_MISMATCH: ::DWORD = 6814;
pub const ERROR_HANDLE_NO_LONGER_VALID: ::DWORD = 6815;
pub const ERROR_NO_TXF_METADATA: ::DWORD = 6816;
pub const ERROR_LOG_CORRUPTION_DETECTED: ::DWORD = 6817;
pub const ERROR_CANT_RECOVER_WITH_HANDLE_OPEN: ::DWORD = 6818;
pub const ERROR_RM_DISCONNECTED: ::DWORD = 6819;
pub const ERROR_ENLISTMENT_NOT_SUPERIOR: ::DWORD = 6820;
pub const ERROR_RECOVERY_NOT_NEEDED: ::DWORD = 6821;
pub const ERROR_RM_ALREADY_STARTED: ::DWORD = 6822;
pub const ERROR_FILE_IDENTITY_NOT_PERSISTENT: ::DWORD = 6823;
pub const ERROR_CANT_BREAK_TRANSACTIONAL_DEPENDENCY: ::DWORD = 6824;
pub const ERROR_CANT_CROSS_RM_BOUNDARY: ::DWORD = 6825;
pub const ERROR_TXF_DIR_NOT_EMPTY: ::DWORD = 6826;
pub const ERROR_INDOUBT_TRANSACTIONS_EXIST: ::DWORD = 6827;
pub const ERROR_TM_VOLATILE: ::DWORD = 6828;
pub const ERROR_ROLLBACK_TIMER_EXPIRED: ::DWORD = 6829;
pub const ERROR_TXF_ATTRIBUTE_CORRUPT: ::DWORD = 6830;
pub const ERROR_EFS_NOT_ALLOWED_IN_TRANSACTION: ::DWORD = 6831;
pub const ERROR_TRANSACTIONAL_OPEN_NOT_ALLOWED: ::DWORD = 6832;
pub const ERROR_LOG_GROWTH_FAILED: ::DWORD = 6833;
pub const ERROR_TRANSACTED_MAPPING_UNSUPPORTED_REMOTE: ::DWORD = 6834;
pub const ERROR_TXF_METADATA_ALREADY_PRESENT: ::DWORD = 6835;
pub const ERROR_TRANSACTION_SCOPE_CALLBACKS_NOT_SET: ::DWORD = 6836;
pub const ERROR_TRANSACTION_REQUIRED_PROMOTION: ::DWORD = 6837;
pub const ERROR_CANNOT_EXECUTE_FILE_IN_TRANSACTION: ::DWORD = 6838;
pub const ERROR_TRANSACTIONS_NOT_FROZEN: ::DWORD = 6839;
pub const ERROR_TRANSACTION_FREEZE_IN_PROGRESS: ::DWORD = 6840;
pub const ERROR_NOT_SNAPSHOT_VOLUME: ::DWORD = 6841;
pub const ERROR_NO_SAVEPOINT_WITH_OPEN_FILES: ::DWORD = 6842;
pub const ERROR_DATA_LOST_REPAIR: ::DWORD = 6843;
pub const ERROR_SPARSE_NOT_ALLOWED_IN_TRANSACTION: ::DWORD = 6844;
pub const ERROR_TM_IDENTITY_MISMATCH: ::DWORD = 6845;
pub const ERROR_FLOATED_SECTION: ::DWORD = 6846;
pub const ERROR_CANNOT_ACCEPT_TRANSACTED_WORK: ::DWORD = 6847;
pub const ERROR_CANNOT_ABORT_TRANSACTIONS: ::DWORD = 6848;
pub const ERROR_BAD_CLUSTERS: ::DWORD = 6849;
pub const ERROR_COMPRESSION_NOT_ALLOWED_IN_TRANSACTION: ::DWORD = 6850;
pub const ERROR_VOLUME_DIRTY: ::DWORD = 6851;
pub const ERROR_NO_LINK_TRACKING_IN_TRANSACTION: ::DWORD = 6852;
pub const ERROR_OPERATION_NOT_SUPPORTED_IN_TRANSACTION: ::DWORD = 6853;
pub const ERROR_EXPIRED_HANDLE: ::DWORD = 6854;
pub const ERROR_TRANSACTION_NOT_ENLISTED: ::DWORD = 6855;
pub const ERROR_CTX_WINSTATION_NAME_INVALID: ::DWORD = 7001;
pub const ERROR_CTX_INVALID_PD: ::DWORD = 7002;
pub const ERROR_CTX_PD_NOT_FOUND: ::DWORD = 7003;
pub const ERROR_CTX_WD_NOT_FOUND: ::DWORD = 7004;
pub const ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY: ::DWORD = 7005;
pub const ERROR_CTX_SERVICE_NAME_COLLISION: ::DWORD = 7006;
pub const ERROR_CTX_CLOSE_PENDING: ::DWORD = 7007;
pub const ERROR_CTX_NO_OUTBUF: ::DWORD = 7008;
pub const ERROR_CTX_MODEM_INF_NOT_FOUND: ::DWORD = 7009;
pub const ERROR_CTX_INVALID_MODEMNAME: ::DWORD = 7010;
pub const ERROR_CTX_MODEM_RESPONSE_ERROR: ::DWORD = 7011;
pub const ERROR_CTX_MODEM_RESPONSE_TIMEOUT: ::DWORD = 7012;
pub const ERROR_CTX_MODEM_RESPONSE_NO_CARRIER: ::DWORD = 7013;
pub const ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE: ::DWORD = 7014;
pub const ERROR_CTX_MODEM_RESPONSE_BUSY: ::DWORD = 7015;
pub const ERROR_CTX_MODEM_RESPONSE_VOICE: ::DWORD = 7016;
pub const ERROR_CTX_TD_ERROR: ::DWORD = 7017;
pub const ERROR_CTX_WINSTATION_NOT_FOUND: ::DWORD = 7022;
pub const ERROR_CTX_WINSTATION_ALREADY_EXISTS: ::DWORD = 7023;
pub const ERROR_CTX_WINSTATION_BUSY: ::DWORD = 7024;
pub const ERROR_CTX_BAD_VIDEO_MODE: ::DWORD = 7025;
pub const ERROR_CTX_GRAPHICS_INVALID: ::DWORD = 7035;
pub const ERROR_CTX_LOGON_DISABLED: ::DWORD = 7037;
pub const ERROR_CTX_NOT_CONSOLE: ::DWORD = 7038;
pub const ERROR_CTX_CLIENT_QUERY_TIMEOUT: ::DWORD = 7040;
pub const ERROR_CTX_CONSOLE_DISCONNECT: ::DWORD = 7041;
pub const ERROR_CTX_CONSOLE_CONNECT: ::DWORD = 7042;
pub const ERROR_CTX_SHADOW_DENIED: ::DWORD = 7044;
pub const ERROR_CTX_WINSTATION_ACCESS_DENIED: ::DWORD = 7045;
pub const ERROR_CTX_INVALID_WD: ::DWORD = 7049;
pub const ERROR_CTX_SHADOW_INVALID: ::DWORD = 7050;
pub const ERROR_CTX_SHADOW_DISABLED: ::DWORD = 7051;
pub const ERROR_CTX_CLIENT_LICENSE_IN_USE: ::DWORD = 7052;
pub const ERROR_CTX_CLIENT_LICENSE_NOT_SET: ::DWORD = 7053;
pub const ERROR_CTX_LICENSE_NOT_AVAILABLE: ::DWORD = 7054;
pub const ERROR_CTX_LICENSE_CLIENT_INVALID: ::DWORD = 7055;
pub const ERROR_CTX_LICENSE_EXPIRED: ::DWORD = 7056;
pub const ERROR_CTX_SHADOW_NOT_RUNNING: ::DWORD = 7057;
pub const ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE: ::DWORD = 7058;
pub const ERROR_ACTIVATION_COUNT_EXCEEDED: ::DWORD = 7059;
pub const ERROR_CTX_WINSTATIONS_DISABLED: ::DWORD = 7060;
pub const ERROR_CTX_ENCRYPTION_LEVEL_REQUIRED: ::DWORD = 7061;
pub const ERROR_CTX_SESSION_IN_USE: ::DWORD = 7062;
pub const ERROR_CTX_NO_FORCE_LOGOFF: ::DWORD = 7063;
pub const ERROR_CTX_ACCOUNT_RESTRICTION: ::DWORD = 7064;
pub const ERROR_RDP_PROTOCOL_ERROR: ::DWORD = 7065;
pub const ERROR_CTX_CDM_CONNECT: ::DWORD = 7066;
pub const ERROR_CTX_CDM_DISCONNECT: ::DWORD = 7067;
pub const ERROR_CTX_SECURITY_LAYER_ERROR: ::DWORD = 7068;
pub const ERROR_TS_INCOMPATIBLE_SESSIONS: ::DWORD = 7069;
pub const ERROR_TS_VIDEO_SUBSYSTEM_ERROR: ::DWORD = 7070;
pub const FRS_ERR_INVALID_API_SEQUENCE: ::DWORD = 8001;
pub const FRS_ERR_STARTING_SERVICE: ::DWORD = 8002;
pub const FRS_ERR_STOPPING_SERVICE: ::DWORD = 8003;
pub const FRS_ERR_INTERNAL_API: ::DWORD = 8004;
pub const FRS_ERR_INTERNAL: ::DWORD = 8005;
pub const FRS_ERR_SERVICE_COMM: ::DWORD = 8006;
pub const FRS_ERR_INSUFFICIENT_PRIV: ::DWORD = 8007;
pub const FRS_ERR_AUTHENTICATION: ::DWORD = 8008;
pub const FRS_ERR_PARENT_INSUFFICIENT_PRIV: ::DWORD = 8009;
pub const FRS_ERR_PARENT_AUTHENTICATION: ::DWORD = 8010;
pub const FRS_ERR_CHILD_TO_PARENT_COMM: ::DWORD = 8011;
pub const FRS_ERR_PARENT_TO_CHILD_COMM: ::DWORD = 8012;
pub const FRS_ERR_SYSVOL_POPULATE: ::DWORD = 8013;
pub const FRS_ERR_SYSVOL_POPULATE_TIMEOUT: ::DWORD = 8014;
pub const FRS_ERR_SYSVOL_IS_BUSY: ::DWORD = 8015;
pub const FRS_ERR_SYSVOL_DEMOTE: ::DWORD = 8016;
pub const FRS_ERR_INVALID_SERVICE_PARAMETER: ::DWORD = 8017;
pub const DS_S_SUCCESS: ::DWORD = NO_ERROR;
pub const ERROR_DS_NOT_INSTALLED: ::DWORD = 8200;
pub const ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY: ::DWORD = 8201;
pub const ERROR_DS_NO_ATTRIBUTE_OR_VALUE: ::DWORD = 8202;
pub const ERROR_DS_INVALID_ATTRIBUTE_SYNTAX: ::DWORD = 8203;
pub const ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED: ::DWORD = 8204;
pub const ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS: ::DWORD = 8205;
pub const ERROR_DS_BUSY: ::DWORD = 8206;
pub const ERROR_DS_UNAVAILABLE: ::DWORD = 8207;
pub const ERROR_DS_NO_RIDS_ALLOCATED: ::DWORD = 8208;
pub const ERROR_DS_NO_MORE_RIDS: ::DWORD = 8209;
pub const ERROR_DS_INCORRECT_ROLE_OWNER: ::DWORD = 8210;
pub const ERROR_DS_RIDMGR_INIT_ERROR: ::DWORD = 8211;
pub const ERROR_DS_OBJ_CLASS_VIOLATION: ::DWORD = 8212;
pub const ERROR_DS_CANT_ON_NON_LEAF: ::DWORD = 8213;
pub const ERROR_DS_CANT_ON_RDN: ::DWORD = 8214;
pub const ERROR_DS_CANT_MOD_OBJ_CLASS: ::DWORD = 8215;
pub const ERROR_DS_CROSS_DOM_MOVE_ERROR: ::DWORD = 8216;
pub const ERROR_DS_GC_NOT_AVAILABLE: ::DWORD = 8217;
pub const ERROR_SHARED_POLICY: ::DWORD = 8218;
pub const ERROR_POLICY_OBJECT_NOT_FOUND: ::DWORD = 8219;
pub const ERROR_POLICY_ONLY_IN_DS: ::DWORD = 8220;
pub const ERROR_PROMOTION_ACTIVE: ::DWORD = 8221;
pub const ERROR_NO_PROMOTION_ACTIVE: ::DWORD = 8222;
pub const ERROR_DS_OPERATIONS_ERROR: ::DWORD = 8224;
pub const ERROR_DS_PROTOCOL_ERROR: ::DWORD = 8225;
pub const ERROR_DS_TIMELIMIT_EXCEEDED: ::DWORD = 8226;
pub const ERROR_DS_SIZELIMIT_EXCEEDED: ::DWORD = 8227;
pub const ERROR_DS_ADMIN_LIMIT_EXCEEDED: ::DWORD = 8228;
pub const ERROR_DS_COMPARE_FALSE: ::DWORD = 8229;
pub const ERROR_DS_COMPARE_TRUE: ::DWORD = 8230;
pub const ERROR_DS_AUTH_METHOD_NOT_SUPPORTED: ::DWORD = 8231;
pub const ERROR_DS_STRONG_AUTH_REQUIRED: ::DWORD = 8232;
pub const ERROR_DS_INAPPROPRIATE_AUTH: ::DWORD = 8233;
pub const ERROR_DS_AUTH_UNKNOWN: ::DWORD = 8234;
pub const ERROR_DS_REFERRAL: ::DWORD = 8235;
pub const ERROR_DS_UNAVAILABLE_CRIT_EXTENSION: ::DWORD = 8236;
pub const ERROR_DS_CONFIDENTIALITY_REQUIRED: ::DWORD = 8237;
pub const ERROR_DS_INAPPROPRIATE_MATCHING: ::DWORD = 8238;
pub const ERROR_DS_CONSTRAINT_VIOLATION: ::DWORD = 8239;
pub const ERROR_DS_NO_SUCH_OBJECT: ::DWORD = 8240;
pub const ERROR_DS_ALIAS_PROBLEM: ::DWORD = 8241;
pub const ERROR_DS_INVALID_DN_SYNTAX: ::DWORD = 8242;
pub const ERROR_DS_IS_LEAF: ::DWORD = 8243;
pub const ERROR_DS_ALIAS_DEREF_PROBLEM: ::DWORD = 8244;
pub const ERROR_DS_UNWILLING_TO_PERFORM: ::DWORD = 8245;
pub const ERROR_DS_LOOP_DETECT: ::DWORD = 8246;
pub const ERROR_DS_NAMING_VIOLATION: ::DWORD = 8247;
pub const ERROR_DS_OBJECT_RESULTS_TOO_LARGE: ::DWORD = 8248;
pub const ERROR_DS_AFFECTS_MULTIPLE_DSAS: ::DWORD = 8249;
pub const ERROR_DS_SERVER_DOWN: ::DWORD = 8250;
pub const ERROR_DS_LOCAL_ERROR: ::DWORD = 8251;
pub const ERROR_DS_ENCODING_ERROR: ::DWORD = 8252;
pub const ERROR_DS_DECODING_ERROR: ::DWORD = 8253;
pub const ERROR_DS_FILTER_UNKNOWN: ::DWORD = 8254;
pub const ERROR_DS_PARAM_ERROR: ::DWORD = 8255;
pub const ERROR_DS_NOT_SUPPORTED: ::DWORD = 8256;
pub const ERROR_DS_NO_RESULTS_RETURNED: ::DWORD = 8257;
pub const ERROR_DS_CONTROL_NOT_FOUND: ::DWORD = 8258;
pub const ERROR_DS_CLIENT_LOOP: ::DWORD = 8259;
pub const ERROR_DS_REFERRAL_LIMIT_EXCEEDED: ::DWORD = 8260;
pub const ERROR_DS_SORT_CONTROL_MISSING: ::DWORD = 8261;
pub const ERROR_DS_OFFSET_RANGE_ERROR: ::DWORD = 8262;
pub const ERROR_DS_RIDMGR_DISABLED: ::DWORD = 8263;
pub const ERROR_DS_ROOT_MUST_BE_NC: ::DWORD = 8301;
pub const ERROR_DS_ADD_REPLICA_INHIBITED: ::DWORD = 8302;
pub const ERROR_DS_ATT_NOT_DEF_IN_SCHEMA: ::DWORD = 8303;
pub const ERROR_DS_MAX_OBJ_SIZE_EXCEEDED: ::DWORD = 8304;
pub const ERROR_DS_OBJ_STRING_NAME_EXISTS: ::DWORD = 8305;
pub const ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA: ::DWORD = 8306;
pub const ERROR_DS_RDN_DOESNT_MATCH_SCHEMA: ::DWORD = 8307;
pub const ERROR_DS_NO_REQUESTED_ATTS_FOUND: ::DWORD = 8308;
pub const ERROR_DS_USER_BUFFER_TO_SMALL: ::DWORD = 8309;
pub const ERROR_DS_ATT_IS_NOT_ON_OBJ: ::DWORD = 8310;
pub const ERROR_DS_ILLEGAL_MOD_OPERATION: ::DWORD = 8311;
pub const ERROR_DS_OBJ_TOO_LARGE: ::DWORD = 8312;
pub const ERROR_DS_BAD_INSTANCE_TYPE: ::DWORD = 8313;
pub const ERROR_DS_MASTERDSA_REQUIRED: ::DWORD = 8314;
pub const ERROR_DS_OBJECT_CLASS_REQUIRED: ::DWORD = 8315;
pub const ERROR_DS_MISSING_REQUIRED_ATT: ::DWORD = 8316;
pub const ERROR_DS_ATT_NOT_DEF_FOR_CLASS: ::DWORD = 8317;
pub const ERROR_DS_ATT_ALREADY_EXISTS: ::DWORD = 8318;
pub const ERROR_DS_CANT_ADD_ATT_VALUES: ::DWORD = 8320;
pub const ERROR_DS_SINGLE_VALUE_CONSTRAINT: ::DWORD = 8321;
pub const ERROR_DS_RANGE_CONSTRAINT: ::DWORD = 8322;
pub const ERROR_DS_ATT_VAL_ALREADY_EXISTS: ::DWORD = 8323;
pub const ERROR_DS_CANT_REM_MISSING_ATT: ::DWORD = 8324;
pub const ERROR_DS_CANT_REM_MISSING_ATT_VAL: ::DWORD = 8325;
pub const ERROR_DS_ROOT_CANT_BE_SUBREF: ::DWORD = 8326;
pub const ERROR_DS_NO_CHAINING: ::DWORD = 8327;
pub const ERROR_DS_NO_CHAINED_EVAL: ::DWORD = 8328;
pub const ERROR_DS_NO_PARENT_OBJECT: ::DWORD = 8329;
pub const ERROR_DS_PARENT_IS_AN_ALIAS: ::DWORD = 8330;
pub const ERROR_DS_CANT_MIX_MASTER_AND_REPS: ::DWORD = 8331;
pub const ERROR_DS_CHILDREN_EXIST: ::DWORD = 8332;
pub const ERROR_DS_OBJ_NOT_FOUND: ::DWORD = 8333;
pub const ERROR_DS_ALIASED_OBJ_MISSING: ::DWORD = 8334;
pub const ERROR_DS_BAD_NAME_SYNTAX: ::DWORD = 8335;
pub const ERROR_DS_ALIAS_POINTS_TO_ALIAS: ::DWORD = 8336;
pub const ERROR_DS_CANT_DEREF_ALIAS: ::DWORD = 8337;
pub const ERROR_DS_OUT_OF_SCOPE: ::DWORD = 8338;
pub const ERROR_DS_OBJECT_BEING_REMOVED: ::DWORD = 8339;
pub const ERROR_DS_CANT_DELETE_DSA_OBJ: ::DWORD = 8340;
pub const ERROR_DS_GENERIC_ERROR: ::DWORD = 8341;
pub const ERROR_DS_DSA_MUST_BE_INT_MASTER: ::DWORD = 8342;
pub const ERROR_DS_CLASS_NOT_DSA: ::DWORD = 8343;
pub const ERROR_DS_INSUFF_ACCESS_RIGHTS: ::DWORD = 8344;
pub const ERROR_DS_ILLEGAL_SUPERIOR: ::DWORD = 8345;
pub const ERROR_DS_ATTRIBUTE_OWNED_BY_SAM: ::DWORD = 8346;
pub const ERROR_DS_NAME_TOO_MANY_PARTS: ::DWORD = 8347;
pub const ERROR_DS_NAME_TOO_LONG: ::DWORD = 8348;
pub const ERROR_DS_NAME_VALUE_TOO_LONG: ::DWORD = 8349;
pub const ERROR_DS_NAME_UNPARSEABLE: ::DWORD = 8350;
pub const ERROR_DS_NAME_TYPE_UNKNOWN: ::DWORD = 8351;
pub const ERROR_DS_NOT_AN_OBJECT: ::DWORD = 8352;
pub const ERROR_DS_SEC_DESC_TOO_SHORT: ::DWORD = 8353;
pub const ERROR_DS_SEC_DESC_INVALID: ::DWORD = 8354;
pub const ERROR_DS_NO_DELETED_NAME: ::DWORD = 8355;
pub const ERROR_DS_SUBREF_MUST_HAVE_PARENT: ::DWORD = 8356;
pub const ERROR_DS_NCNAME_MUST_BE_NC: ::DWORD = 8357;
pub const ERROR_DS_CANT_ADD_SYSTEM_ONLY: ::DWORD = 8358;
pub const ERROR_DS_CLASS_MUST_BE_CONCRETE: ::DWORD = 8359;
pub const ERROR_DS_INVALID_DMD: ::DWORD = 8360;
pub const ERROR_DS_OBJ_GUID_EXISTS: ::DWORD = 8361;
pub const ERROR_DS_NOT_ON_BACKLINK: ::DWORD = 8362;
pub const ERROR_DS_NO_CROSSREF_FOR_NC: ::DWORD = 8363;
pub const ERROR_DS_SHUTTING_DOWN: ::DWORD = 8364;
pub const ERROR_DS_UNKNOWN_OPERATION: ::DWORD = 8365;
pub const ERROR_DS_INVALID_ROLE_OWNER: ::DWORD = 8366;
pub const ERROR_DS_COULDNT_CONTACT_FSMO: ::DWORD = 8367;
pub const ERROR_DS_CROSS_NC_DN_RENAME: ::DWORD = 8368;
pub const ERROR_DS_CANT_MOD_SYSTEM_ONLY: ::DWORD = 8369;
pub const ERROR_DS_REPLICATOR_ONLY: ::DWORD = 8370;
pub const ERROR_DS_OBJ_CLASS_NOT_DEFINED: ::DWORD = 8371;
pub const ERROR_DS_OBJ_CLASS_NOT_SUBCLASS: ::DWORD = 8372;
pub const ERROR_DS_NAME_REFERENCE_INVALID: ::DWORD = 8373;
pub const ERROR_DS_CROSS_REF_EXISTS: ::DWORD = 8374;
pub const ERROR_DS_CANT_DEL_MASTER_CROSSREF: ::DWORD = 8375;
pub const ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD: ::DWORD = 8376;
pub const ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX: ::DWORD = 8377;
pub const ERROR_DS_DUP_RDN: ::DWORD = 8378;
pub const ERROR_DS_DUP_OID: ::DWORD = 8379;
pub const ERROR_DS_DUP_MAPI_ID: ::DWORD = 8380;
pub const ERROR_DS_DUP_SCHEMA_ID_GUID: ::DWORD = 8381;
pub const ERROR_DS_DUP_LDAP_DISPLAY_NAME: ::DWORD = 8382;
pub const ERROR_DS_SEMANTIC_ATT_TEST: ::DWORD = 8383;
pub const ERROR_DS_SYNTAX_MISMATCH: ::DWORD = 8384;
pub const ERROR_DS_EXISTS_IN_MUST_HAVE: ::DWORD = 8385;
pub const ERROR_DS_EXISTS_IN_MAY_HAVE: ::DWORD = 8386;
pub const ERROR_DS_NONEXISTENT_MAY_HAVE: ::DWORD = 8387;
pub const ERROR_DS_NONEXISTENT_MUST_HAVE: ::DWORD = 8388;
pub const ERROR_DS_AUX_CLS_TEST_FAIL: ::DWORD = 8389;
pub const ERROR_DS_NONEXISTENT_POSS_SUP: ::DWORD = 8390;
pub const ERROR_DS_SUB_CLS_TEST_FAIL: ::DWORD = 8391;
pub const ERROR_DS_BAD_RDN_ATT_ID_SYNTAX: ::DWORD = 8392;
pub const ERROR_DS_EXISTS_IN_AUX_CLS: ::DWORD = 8393;
pub const ERROR_DS_EXISTS_IN_SUB_CLS: ::DWORD = 8394;
pub const ERROR_DS_EXISTS_IN_POSS_SUP: ::DWORD = 8395;
pub const ERROR_DS_RECALCSCHEMA_FAILED: ::DWORD = 8396;
pub const ERROR_DS_TREE_DELETE_NOT_FINISHED: ::DWORD = 8397;
pub const ERROR_DS_CANT_DELETE: ::DWORD = 8398;
pub const ERROR_DS_ATT_SCHEMA_REQ_ID: ::DWORD = 8399;
pub const ERROR_DS_BAD_ATT_SCHEMA_SYNTAX: ::DWORD = 8400;
pub const ERROR_DS_CANT_CACHE_ATT: ::DWORD = 8401;
pub const ERROR_DS_CANT_CACHE_CLASS: ::DWORD = 8402;
pub const ERROR_DS_CANT_REMOVE_ATT_CACHE: ::DWORD = 8403;
pub const ERROR_DS_CANT_REMOVE_CLASS_CACHE: ::DWORD = 8404;
pub const ERROR_DS_CANT_RETRIEVE_DN: ::DWORD = 8405;
pub const ERROR_DS_MISSING_SUPREF: ::DWORD = 8406;
pub const ERROR_DS_CANT_RETRIEVE_INSTANCE: ::DWORD = 8407;
pub const ERROR_DS_CODE_INCONSISTENCY: ::DWORD = 8408;
pub const ERROR_DS_DATABASE_ERROR: ::DWORD = 8409;
pub const ERROR_DS_GOVERNSID_MISSING: ::DWORD = 8410;
pub const ERROR_DS_MISSING_EXPECTED_ATT: ::DWORD = 8411;
pub const ERROR_DS_NCNAME_MISSING_CR_REF: ::DWORD = 8412;
pub const ERROR_DS_SECURITY_CHECKING_ERROR: ::DWORD = 8413;
pub const ERROR_DS_SCHEMA_NOT_LOADED: ::DWORD = 8414;
pub const ERROR_DS_SCHEMA_ALLOC_FAILED: ::DWORD = 8415;
pub const ERROR_DS_ATT_SCHEMA_REQ_SYNTAX: ::DWORD = 8416;
pub const ERROR_DS_GCVERIFY_ERROR: ::DWORD = 8417;
pub const ERROR_DS_DRA_SCHEMA_MISMATCH: ::DWORD = 8418;
pub const ERROR_DS_CANT_FIND_DSA_OBJ: ::DWORD = 8419;
pub const ERROR_DS_CANT_FIND_EXPECTED_NC: ::DWORD = 8420;
pub const ERROR_DS_CANT_FIND_NC_IN_CACHE: ::DWORD = 8421;
pub const ERROR_DS_CANT_RETRIEVE_CHILD: ::DWORD = 8422;
pub const ERROR_DS_SECURITY_ILLEGAL_MODIFY: ::DWORD = 8423;
pub const ERROR_DS_CANT_REPLACE_HIDDEN_REC: ::DWORD = 8424;
pub const ERROR_DS_BAD_HIERARCHY_FILE: ::DWORD = 8425;
pub const ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED: ::DWORD = 8426;
pub const ERROR_DS_CONFIG_PARAM_MISSING: ::DWORD = 8427;
pub const ERROR_DS_COUNTING_AB_INDICES_FAILED: ::DWORD = 8428;
pub const ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED: ::DWORD = 8429;
pub const ERROR_DS_INTERNAL_FAILURE: ::DWORD = 8430;
pub const ERROR_DS_UNKNOWN_ERROR: ::DWORD = 8431;
pub const ERROR_DS_ROOT_REQUIRES_CLASS_TOP: ::DWORD = 8432;
pub const ERROR_DS_REFUSING_FSMO_ROLES: ::DWORD = 8433;
pub const ERROR_DS_MISSING_FSMO_SETTINGS: ::DWORD = 8434;
pub const ERROR_DS_UNABLE_TO_SURRENDER_ROLES: ::DWORD = 8435;
pub const ERROR_DS_DRA_GENERIC: ::DWORD = 8436;
pub const ERROR_DS_DRA_INVALID_PARAMETER: ::DWORD = 8437;
pub const ERROR_DS_DRA_BUSY: ::DWORD = 8438;
pub const ERROR_DS_DRA_BAD_DN: ::DWORD = 8439;
pub const ERROR_DS_DRA_BAD_NC: ::DWORD = 8440;
pub const ERROR_DS_DRA_DN_EXISTS: ::DWORD = 8441;
pub const ERROR_DS_DRA_INTERNAL_ERROR: ::DWORD = 8442;
pub const ERROR_DS_DRA_INCONSISTENT_DIT: ::DWORD = 8443;
pub const ERROR_DS_DRA_CONNECTION_FAILED: ::DWORD = 8444;
pub const ERROR_DS_DRA_BAD_INSTANCE_TYPE: ::DWORD = 8445;
pub const ERROR_DS_DRA_OUT_OF_MEM: ::DWORD = 8446;
pub const ERROR_DS_DRA_MAIL_PROBLEM: ::DWORD = 8447;
pub const ERROR_DS_DRA_REF_ALREADY_EXISTS: ::DWORD = 8448;
pub const ERROR_DS_DRA_REF_NOT_FOUND: ::DWORD = 8449;
pub const ERROR_DS_DRA_OBJ_IS_REP_SOURCE: ::DWORD = 8450;
pub const ERROR_DS_DRA_DB_ERROR: ::DWORD = 8451;
pub const ERROR_DS_DRA_NO_REPLICA: ::DWORD = 8452;
pub const ERROR_DS_DRA_ACCESS_DENIED: ::DWORD = 8453;
pub const ERROR_DS_DRA_NOT_SUPPORTED: ::DWORD = 8454;
pub const ERROR_DS_DRA_RPC_CANCELLED: ::DWORD = 8455;
pub const ERROR_DS_DRA_SOURCE_DISABLED: ::DWORD = 8456;
pub const ERROR_DS_DRA_SINK_DISABLED: ::DWORD = 8457;
pub const ERROR_DS_DRA_NAME_COLLISION: ::DWORD = 8458;
pub const ERROR_DS_DRA_SOURCE_REINSTALLED: ::DWORD = 8459;
pub const ERROR_DS_DRA_MISSING_PARENT: ::DWORD = 8460;
pub const ERROR_DS_DRA_PREEMPTED: ::DWORD = 8461;
pub const ERROR_DS_DRA_ABANDON_SYNC: ::DWORD = 8462;
pub const ERROR_DS_DRA_SHUTDOWN: ::DWORD = 8463;
pub const ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET: ::DWORD = 8464;
pub const ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA: ::DWORD = 8465;
pub const ERROR_DS_DRA_EXTN_CONNECTION_FAILED: ::DWORD = 8466;
pub const ERROR_DS_INSTALL_SCHEMA_MISMATCH: ::DWORD = 8467;
pub const ERROR_DS_DUP_LINK_ID: ::DWORD = 8468;
pub const ERROR_DS_NAME_ERROR_RESOLVING: ::DWORD = 8469;
pub const ERROR_DS_NAME_ERROR_NOT_FOUND: ::DWORD = 8470;
pub const ERROR_DS_NAME_ERROR_NOT_UNIQUE: ::DWORD = 8471;
pub const ERROR_DS_NAME_ERROR_NO_MAPPING: ::DWORD = 8472;
pub const ERROR_DS_NAME_ERROR_DOMAIN_ONLY: ::DWORD = 8473;
pub const ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING: ::DWORD = 8474;
pub const ERROR_DS_CONSTRUCTED_ATT_MOD: ::DWORD = 8475;
pub const ERROR_DS_WRONG_OM_OBJ_CLASS: ::DWORD = 8476;
pub const ERROR_DS_DRA_REPL_PENDING: ::DWORD = 8477;
pub const ERROR_DS_DS_REQUIRED: ::DWORD = 8478;
pub const ERROR_DS_INVALID_LDAP_DISPLAY_NAME: ::DWORD = 8479;
pub const ERROR_DS_NON_BASE_SEARCH: ::DWORD = 8480;
pub const ERROR_DS_CANT_RETRIEVE_ATTS: ::DWORD = 8481;
pub const ERROR_DS_BACKLINK_WITHOUT_LINK: ::DWORD = 8482;
pub const ERROR_DS_EPOCH_MISMATCH: ::DWORD = 8483;
pub const ERROR_DS_SRC_NAME_MISMATCH: ::DWORD = 8484;
pub const ERROR_DS_SRC_AND_DST_NC_IDENTICAL: ::DWORD = 8485;
pub const ERROR_DS_DST_NC_MISMATCH: ::DWORD = 8486;
pub const ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC: ::DWORD = 8487;
pub const ERROR_DS_SRC_GUID_MISMATCH: ::DWORD = 8488;
pub const ERROR_DS_CANT_MOVE_DELETED_OBJECT: ::DWORD = 8489;
pub const ERROR_DS_PDC_OPERATION_IN_PROGRESS: ::DWORD = 8490;
pub const ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD: ::DWORD = 8491;
pub const ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION: ::DWORD = 8492;
pub const ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS: ::DWORD = 8493;
pub const ERROR_DS_NC_MUST_HAVE_NC_PARENT: ::DWORD = 8494;
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE: ::DWORD = 8495;
pub const ERROR_DS_DST_DOMAIN_NOT_NATIVE: ::DWORD = 8496;
pub const ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER: ::DWORD = 8497;
pub const ERROR_DS_CANT_MOVE_ACCOUNT_GROUP: ::DWORD = 8498;
pub const ERROR_DS_CANT_MOVE_RESOURCE_GROUP: ::DWORD = 8499;
pub const ERROR_DS_INVALID_SEARCH_FLAG: ::DWORD = 8500;
pub const ERROR_DS_NO_TREE_DELETE_ABOVE_NC: ::DWORD = 8501;
pub const ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE: ::DWORD = 8502;
pub const ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE: ::DWORD = 8503;
pub const ERROR_DS_SAM_INIT_FAILURE: ::DWORD = 8504;
pub const ERROR_DS_SENSITIVE_GROUP_VIOLATION: ::DWORD = 8505;
pub const ERROR_DS_CANT_MOD_PRIMARYGROUPID: ::DWORD = 8506;
pub const ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD: ::DWORD = 8507;
pub const ERROR_DS_NONSAFE_SCHEMA_CHANGE: ::DWORD = 8508;
pub const ERROR_DS_SCHEMA_UPDATE_DISALLOWED: ::DWORD = 8509;
pub const ERROR_DS_CANT_CREATE_UNDER_SCHEMA: ::DWORD = 8510;
pub const ERROR_DS_INSTALL_NO_SRC_SCH_VERSION: ::DWORD = 8511;
pub const ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE: ::DWORD = 8512;
pub const ERROR_DS_INVALID_GROUP_TYPE: ::DWORD = 8513;
pub const ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN: ::DWORD = 8514;
pub const ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN: ::DWORD = 8515;
pub const ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER: ::DWORD = 8516;
pub const ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER: ::DWORD = 8517;
pub const ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER: ::DWORD = 8518;
pub const ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER: ::DWORD = 8519;
pub const ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER: ::DWORD = 8520;
pub const ERROR_DS_HAVE_PRIMARY_MEMBERS: ::DWORD = 8521;
pub const ERROR_DS_STRING_SD_CONVERSION_FAILED: ::DWORD = 8522;
pub const ERROR_DS_NAMING_MASTER_GC: ::DWORD = 8523;
pub const ERROR_DS_DNS_LOOKUP_FAILURE: ::DWORD = 8524;
pub const ERROR_DS_COULDNT_UPDATE_SPNS: ::DWORD = 8525;
pub const ERROR_DS_CANT_RETRIEVE_SD: ::DWORD = 8526;
pub const ERROR_DS_KEY_NOT_UNIQUE: ::DWORD = 8527;
pub const ERROR_DS_WRONG_LINKED_ATT_SYNTAX: ::DWORD = 8528;
pub const ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD: ::DWORD = 8529;
pub const ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY: ::DWORD = 8530;
pub const ERROR_DS_CANT_START: ::DWORD = 8531;
pub const ERROR_DS_INIT_FAILURE: ::DWORD = 8532;
pub const ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION: ::DWORD = 8533;
pub const ERROR_DS_SOURCE_DOMAIN_IN_FOREST: ::DWORD = 8534;
pub const ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST: ::DWORD = 8535;
pub const ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED: ::DWORD = 8536;
pub const ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN: ::DWORD = 8537;
pub const ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER: ::DWORD = 8538;
pub const ERROR_DS_SRC_SID_EXISTS_IN_FOREST: ::DWORD = 8539;
pub const ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH: ::DWORD = 8540;
pub const ERROR_SAM_INIT_FAILURE: ::DWORD = 8541;
pub const ERROR_DS_DRA_SCHEMA_INFO_SHIP: ::DWORD = 8542;
pub const ERROR_DS_DRA_SCHEMA_CONFLICT: ::DWORD = 8543;
pub const ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT: ::DWORD = 8544;
pub const ERROR_DS_DRA_OBJ_NC_MISMATCH: ::DWORD = 8545;
pub const ERROR_DS_NC_STILL_HAS_DSAS: ::DWORD = 8546;
pub const ERROR_DS_GC_REQUIRED: ::DWORD = 8547;
pub const ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY: ::DWORD = 8548;
pub const ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS: ::DWORD = 8549;
pub const ERROR_DS_CANT_ADD_TO_GC: ::DWORD = 8550;
pub const ERROR_DS_NO_CHECKPOINT_WITH_PDC: ::DWORD = 8551;
pub const ERROR_DS_SOURCE_AUDITING_NOT_ENABLED: ::DWORD = 8552;
pub const ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC: ::DWORD = 8553;
pub const ERROR_DS_INVALID_NAME_FOR_SPN: ::DWORD = 8554;
pub const ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS: ::DWORD = 8555;
pub const ERROR_DS_UNICODEPWD_NOT_IN_QUOTES: ::DWORD = 8556;
pub const ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED: ::DWORD = 8557;
pub const ERROR_DS_MUST_BE_RUN_ON_DST_DC: ::DWORD = 8558;
pub const ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER: ::DWORD = 8559;
pub const ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ: ::DWORD = 8560;
pub const ERROR_DS_INIT_FAILURE_CONSOLE: ::DWORD = 8561;
pub const ERROR_DS_SAM_INIT_FAILURE_CONSOLE: ::DWORD = 8562;
pub const ERROR_DS_FOREST_VERSION_TOO_HIGH: ::DWORD = 8563;
pub const ERROR_DS_DOMAIN_VERSION_TOO_HIGH: ::DWORD = 8564;
pub const ERROR_DS_FOREST_VERSION_TOO_LOW: ::DWORD = 8565;
pub const ERROR_DS_DOMAIN_VERSION_TOO_LOW: ::DWORD = 8566;
pub const ERROR_DS_INCOMPATIBLE_VERSION: ::DWORD = 8567;
pub const ERROR_DS_LOW_DSA_VERSION: ::DWORD = 8568;
pub const ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN: ::DWORD = 8569;
pub const ERROR_DS_NOT_SUPPORTED_SORT_ORDER: ::DWORD = 8570;
pub const ERROR_DS_NAME_NOT_UNIQUE: ::DWORD = 8571;
pub const ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4: ::DWORD = 8572;
pub const ERROR_DS_OUT_OF_VERSION_STORE: ::DWORD = 8573;
pub const ERROR_DS_INCOMPATIBLE_CONTROLS_USED: ::DWORD = 8574;
pub const ERROR_DS_NO_REF_DOMAIN: ::DWORD = 8575;
pub const ERROR_DS_RESERVED_LINK_ID: ::DWORD = 8576;
pub const ERROR_DS_LINK_ID_NOT_AVAILABLE: ::DWORD = 8577;
pub const ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER: ::DWORD = 8578;
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE: ::DWORD = 8579;
pub const ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC: ::DWORD = 8580;
pub const ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG: ::DWORD = 8581;
pub const ERROR_DS_MODIFYDN_WRONG_GRANDPARENT: ::DWORD = 8582;
pub const ERROR_DS_NAME_ERROR_TRUST_REFERRAL: ::DWORD = 8583;
pub const ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER: ::DWORD = 8584;
pub const ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD: ::DWORD = 8585;
pub const ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2: ::DWORD = 8586;
pub const ERROR_DS_THREAD_LIMIT_EXCEEDED: ::DWORD = 8587;
pub const ERROR_DS_NOT_CLOSEST: ::DWORD = 8588;
pub const ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF: ::DWORD = 8589;
pub const ERROR_DS_SINGLE_USER_MODE_FAILED: ::DWORD = 8590;
pub const ERROR_DS_NTDSCRIPT_SYNTAX_ERROR: ::DWORD = 8591;
pub const ERROR_DS_NTDSCRIPT_PROCESS_ERROR: ::DWORD = 8592;
pub const ERROR_DS_DIFFERENT_REPL_EPOCHS: ::DWORD = 8593;
pub const ERROR_DS_DRS_EXTENSIONS_CHANGED: ::DWORD = 8594;
pub const ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR: ::DWORD = 8595;
pub const ERROR_DS_NO_MSDS_INTID: ::DWORD = 8596;
pub const ERROR_DS_DUP_MSDS_INTID: ::DWORD = 8597;
pub const ERROR_DS_EXISTS_IN_RDNATTID: ::DWORD = 8598;
pub const ERROR_DS_AUTHORIZATION_FAILED: ::DWORD = 8599;
pub const ERROR_DS_INVALID_SCRIPT: ::DWORD = 8600;
pub const ERROR_DS_REMOTE_CROSSREF_OP_FAILED: ::DWORD = 8601;
pub const ERROR_DS_CROSS_REF_BUSY: ::DWORD = 8602;
pub const ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN: ::DWORD = 8603;
pub const ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC: ::DWORD = 8604;
pub const ERROR_DS_DUPLICATE_ID_FOUND: ::DWORD = 8605;
pub const ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT: ::DWORD = 8606;
pub const ERROR_DS_GROUP_CONVERSION_ERROR: ::DWORD = 8607;
pub const ERROR_DS_CANT_MOVE_APP_BASIC_GROUP: ::DWORD = 8608;
pub const ERROR_DS_CANT_MOVE_APP_QUERY_GROUP: ::DWORD = 8609;
pub const ERROR_DS_ROLE_NOT_VERIFIED: ::DWORD = 8610;
pub const ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL: ::DWORD = 8611;
pub const ERROR_DS_DOMAIN_RENAME_IN_PROGRESS: ::DWORD = 8612;
pub const ERROR_DS_EXISTING_AD_CHILD_NC: ::DWORD = 8613;
pub const ERROR_DS_REPL_LIFETIME_EXCEEDED: ::DWORD = 8614;
pub const ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER: ::DWORD = 8615;
pub const ERROR_DS_LDAP_SEND_QUEUE_FULL: ::DWORD = 8616;
pub const ERROR_DS_DRA_OUT_SCHEDULE_WINDOW: ::DWORD = 8617;
pub const ERROR_DS_POLICY_NOT_KNOWN: ::DWORD = 8618;
pub const ERROR_NO_SITE_SETTINGS_OBJECT: ::DWORD = 8619;
pub const ERROR_NO_SECRETS: ::DWORD = 8620;
pub const ERROR_NO_WRITABLE_DC_FOUND: ::DWORD = 8621;
pub const ERROR_DS_NO_SERVER_OBJECT: ::DWORD = 8622;
pub const ERROR_DS_NO_NTDSA_OBJECT: ::DWORD = 8623;
pub const ERROR_DS_NON_ASQ_SEARCH: ::DWORD = 8624;
pub const ERROR_DS_AUDIT_FAILURE: ::DWORD = 8625;
pub const ERROR_DS_INVALID_SEARCH_FLAG_SUBTREE: ::DWORD = 8626;
pub const ERROR_DS_INVALID_SEARCH_FLAG_TUPLE: ::DWORD = 8627;
pub const ERROR_DS_HIERARCHY_TABLE_TOO_DEEP: ::DWORD = 8628;
pub const ERROR_DS_DRA_CORRUPT_UTD_VECTOR: ::DWORD = 8629;
pub const ERROR_DS_DRA_SECRETS_DENIED: ::DWORD = 8630;
pub const ERROR_DS_RESERVED_MAPI_ID: ::DWORD = 8631;
pub const ERROR_DS_MAPI_ID_NOT_AVAILABLE: ::DWORD = 8632;
pub const ERROR_DS_DRA_MISSING_KRBTGT_SECRET: ::DWORD = 8633;
pub const ERROR_DS_DOMAIN_NAME_EXISTS_IN_FOREST: ::DWORD = 8634;
pub const ERROR_DS_FLAT_NAME_EXISTS_IN_FOREST: ::DWORD = 8635;
pub const ERROR_INVALID_USER_PRINCIPAL_NAME: ::DWORD = 8636;
pub const ERROR_DS_OID_MAPPED_GROUP_CANT_HAVE_MEMBERS: ::DWORD = 8637;
pub const ERROR_DS_OID_NOT_FOUND: ::DWORD = 8638;
pub const ERROR_DS_DRA_RECYCLED_TARGET: ::DWORD = 8639;
pub const ERROR_DS_DISALLOWED_NC_REDIRECT: ::DWORD = 8640;
pub const ERROR_DS_HIGH_ADLDS_FFL: ::DWORD = 8641;
pub const ERROR_DS_HIGH_DSA_VERSION: ::DWORD = 8642;
pub const ERROR_DS_LOW_ADLDS_FFL: ::DWORD = 8643;
pub const ERROR_DOMAIN_SID_SAME_AS_LOCAL_WORKSTATION: ::DWORD = 8644;
pub const ERROR_DS_UNDELETE_SAM_VALIDATION_FAILED: ::DWORD = 8645;
pub const ERROR_INCORRECT_ACCOUNT_TYPE: ::DWORD = 8646;
pub const ERROR_DS_SPN_VALUE_NOT_UNIQUE_IN_FOREST: ::DWORD = 8647;
pub const ERROR_DS_UPN_VALUE_NOT_UNIQUE_IN_FOREST: ::DWORD = 8648;
pub const DNS_ERROR_RESPONSE_CODES_BASE: ::DWORD = 9000;
pub const DNS_ERROR_RCODE_NO_ERROR: ::DWORD = NO_ERROR;
pub const DNS_ERROR_MASK: ::DWORD = 0x00002328;
pub const DNS_ERROR_RCODE_FORMAT_ERROR: ::DWORD = 9001;
pub const DNS_ERROR_RCODE_SERVER_FAILURE: ::DWORD = 9002;
pub const DNS_ERROR_RCODE_NAME_ERROR: ::DWORD = 9003;
pub const DNS_ERROR_RCODE_NOT_IMPLEMENTED: ::DWORD = 9004;
pub const DNS_ERROR_RCODE_REFUSED: ::DWORD = 9005;
pub const DNS_ERROR_RCODE_YXDOMAIN: ::DWORD = 9006;
pub const DNS_ERROR_RCODE_YXRRSET: ::DWORD = 9007;
pub const DNS_ERROR_RCODE_NXRRSET: ::DWORD = 9008;
pub const DNS_ERROR_RCODE_NOTAUTH: ::DWORD = 9009;
pub const DNS_ERROR_RCODE_NOTZONE: ::DWORD = 9010;
pub const DNS_ERROR_RCODE_BADSIG: ::DWORD = 9016;
pub const DNS_ERROR_RCODE_BADKEY: ::DWORD = 9017;
pub const DNS_ERROR_RCODE_BADTIME: ::DWORD = 9018;
pub const DNS_ERROR_RCODE_LAST: ::DWORD = DNS_ERROR_RCODE_BADTIME;
pub const DNS_ERROR_DNSSEC_BASE: ::DWORD = 9100;
pub const DNS_ERROR_KEYMASTER_REQUIRED: ::DWORD = 9101;
pub const DNS_ERROR_NOT_ALLOWED_ON_SIGNED_ZONE: ::DWORD = 9102;
pub const DNS_ERROR_NSEC3_INCOMPATIBLE_WITH_RSA_SHA1: ::DWORD = 9103;
pub const DNS_ERROR_NOT_ENOUGH_SIGNING_KEY_DESCRIPTORS: ::DWORD = 9104;
pub const DNS_ERROR_UNSUPPORTED_ALGORITHM: ::DWORD = 9105;
pub const DNS_ERROR_INVALID_KEY_SIZE: ::DWORD = 9106;
pub const DNS_ERROR_SIGNING_KEY_NOT_ACCESSIBLE: ::DWORD = 9107;
pub const DNS_ERROR_KSP_DOES_NOT_SUPPORT_PROTECTION: ::DWORD = 9108;
pub const DNS_ERROR_UNEXPECTED_DATA_PROTECTION_ERROR: ::DWORD = 9109;
pub const DNS_ERROR_UNEXPECTED_CNG_ERROR: ::DWORD = 9110;
pub const DNS_ERROR_UNKNOWN_SIGNING_PARAMETER_VERSION: ::DWORD = 9111;
pub const DNS_ERROR_KSP_NOT_ACCESSIBLE: ::DWORD = 9112;
pub const DNS_ERROR_TOO_MANY_SKDS: ::DWORD = 9113;
pub const DNS_ERROR_INVALID_ROLLOVER_PERIOD: ::DWORD = 9114;
pub const DNS_ERROR_INVALID_INITIAL_ROLLOVER_OFFSET: ::DWORD = 9115;
pub const DNS_ERROR_ROLLOVER_IN_PROGRESS: ::DWORD = 9116;
pub const DNS_ERROR_STANDBY_KEY_NOT_PRESENT: ::DWORD = 9117;
pub const DNS_ERROR_NOT_ALLOWED_ON_ZSK: ::DWORD = 9118;
pub const DNS_ERROR_NOT_ALLOWED_ON_ACTIVE_SKD: ::DWORD = 9119;
pub const DNS_ERROR_ROLLOVER_ALREADY_QUEUED: ::DWORD = 9120;
pub const DNS_ERROR_NOT_ALLOWED_ON_UNSIGNED_ZONE: ::DWORD = 9121;
pub const DNS_ERROR_BAD_KEYMASTER: ::DWORD = 9122;
pub const DNS_ERROR_INVALID_SIGNATURE_VALIDITY_PERIOD: ::DWORD = 9123;
pub const DNS_ERROR_INVALID_NSEC3_ITERATION_COUNT: ::DWORD = 9124;
pub const DNS_ERROR_DNSSEC_IS_DISABLED: ::DWORD = 9125;
pub const DNS_ERROR_INVALID_XML: ::DWORD = 9126;
pub const DNS_ERROR_NO_VALID_TRUST_ANCHORS: ::DWORD = 9127;
pub const DNS_ERROR_ROLLOVER_NOT_POKEABLE: ::DWORD = 9128;
pub const DNS_ERROR_NSEC3_NAME_COLLISION: ::DWORD = 9129;
pub const DNS_ERROR_NSEC_INCOMPATIBLE_WITH_NSEC3_RSA_SHA1: ::DWORD = 9130;
pub const DNS_ERROR_PACKET_FMT_BASE: ::DWORD = 9500;
pub const DNS_INFO_NO_RECORDS: ::DWORD = 9501;
pub const DNS_ERROR_BAD_PACKET: ::DWORD = 9502;
pub const DNS_ERROR_NO_PACKET: ::DWORD = 9503;
pub const DNS_ERROR_RCODE: ::DWORD = 9504;
pub const DNS_ERROR_UNSECURE_PACKET: ::DWORD = 9505;
pub const DNS_STATUS_PACKET_UNSECURE: ::DWORD = DNS_ERROR_UNSECURE_PACKET;
pub const DNS_REQUEST_PENDING: ::DWORD = 9506;
pub const DNS_ERROR_NO_MEMORY: ::DWORD = ERROR_OUTOFMEMORY;
pub const DNS_ERROR_INVALID_NAME: ::DWORD = ERROR_INVALID_NAME;
pub const DNS_ERROR_INVALID_DATA: ::DWORD = ERROR_INVALID_DATA;
pub const DNS_ERROR_GENERAL_API_BASE: ::DWORD = 9550;
pub const DNS_ERROR_INVALID_TYPE: ::DWORD = 9551;
pub const DNS_ERROR_INVALID_IP_ADDRESS: ::DWORD = 9552;
pub const DNS_ERROR_INVALID_PROPERTY: ::DWORD = 9553;
pub const DNS_ERROR_TRY_AGAIN_LATER: ::DWORD = 9554;
pub const DNS_ERROR_NOT_UNIQUE: ::DWORD = 9555;
pub const DNS_ERROR_NON_RFC_NAME: ::DWORD = 9556;
pub const DNS_STATUS_FQDN: ::DWORD = 9557;
pub const DNS_STATUS_DOTTED_NAME: ::DWORD = 9558;
pub const DNS_STATUS_SINGLE_PART_NAME: ::DWORD = 9559;
pub const DNS_ERROR_INVALID_NAME_CHAR: ::DWORD = 9560;
pub const DNS_ERROR_NUMERIC_NAME: ::DWORD = 9561;
pub const DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER: ::DWORD = 9562;
pub const DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION: ::DWORD = 9563;
pub const DNS_ERROR_CANNOT_FIND_ROOT_HINTS: ::DWORD = 9564;
pub const DNS_ERROR_INCONSISTENT_ROOT_HINTS: ::DWORD = 9565;
pub const DNS_ERROR_DWORD_VALUE_TOO_SMALL: ::DWORD = 9566;
pub const DNS_ERROR_DWORD_VALUE_TOO_LARGE: ::DWORD = 9567;
pub const DNS_ERROR_BACKGROUND_LOADING: ::DWORD = 9568;
pub const DNS_ERROR_NOT_ALLOWED_ON_RODC: ::DWORD = 9569;
pub const DNS_ERROR_NOT_ALLOWED_UNDER_DNAME: ::DWORD = 9570;
pub const DNS_ERROR_DELEGATION_REQUIRED: ::DWORD = 9571;
pub const DNS_ERROR_INVALID_POLICY_TABLE: ::DWORD = 9572;
pub const DNS_ERROR_ZONE_BASE: ::DWORD = 9600;
pub const DNS_ERROR_ZONE_DOES_NOT_EXIST: ::DWORD = 9601;
pub const DNS_ERROR_NO_ZONE_INFO: ::DWORD = 9602;
pub const DNS_ERROR_INVALID_ZONE_OPERATION: ::DWORD = 9603;
pub const DNS_ERROR_ZONE_CONFIGURATION_ERROR: ::DWORD = 9604;
pub const DNS_ERROR_ZONE_HAS_NO_SOA_RECORD: ::DWORD = 9605;
pub const DNS_ERROR_ZONE_HAS_NO_NS_RECORDS: ::DWORD = 9606;
pub const DNS_ERROR_ZONE_LOCKED: ::DWORD = 9607;
pub const DNS_ERROR_ZONE_CREATION_FAILED: ::DWORD = 9608;
pub const DNS_ERROR_ZONE_ALREADY_EXISTS: ::DWORD = 9609;
pub const DNS_ERROR_AUTOZONE_ALREADY_EXISTS: ::DWORD = 9610;
pub const DNS_ERROR_INVALID_ZONE_TYPE: ::DWORD = 9611;
pub const DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP: ::DWORD = 9612;
pub const DNS_ERROR_ZONE_NOT_SECONDARY: ::DWORD = 9613;
pub const DNS_ERROR_NEED_SECONDARY_ADDRESSES: ::DWORD = 9614;
pub const DNS_ERROR_WINS_INIT_FAILED: ::DWORD = 9615;
pub const DNS_ERROR_NEED_WINS_SERVERS: ::DWORD = 9616;
pub const DNS_ERROR_NBSTAT_INIT_FAILED: ::DWORD = 9617;
pub const DNS_ERROR_SOA_DELETE_INVALID: ::DWORD = 9618;
pub const DNS_ERROR_FORWARDER_ALREADY_EXISTS: ::DWORD = 9619;
pub const DNS_ERROR_ZONE_REQUIRES_MASTER_IP: ::DWORD = 9620;
pub const DNS_ERROR_ZONE_IS_SHUTDOWN: ::DWORD = 9621;
pub const DNS_ERROR_ZONE_LOCKED_FOR_SIGNING: ::DWORD = 9622;
pub const DNS_ERROR_DATAFILE_BASE: ::DWORD = 9650;
pub const DNS_ERROR_PRIMARY_REQUIRES_DATAFILE: ::DWORD = 9651;
pub const DNS_ERROR_INVALID_DATAFILE_NAME: ::DWORD = 9652;
pub const DNS_ERROR_DATAFILE_OPEN_FAILURE: ::DWORD = 9653;
pub const DNS_ERROR_FILE_WRITEBACK_FAILED: ::DWORD = 9654;
pub const DNS_ERROR_DATAFILE_PARSING: ::DWORD = 9655;
pub const DNS_ERROR_DATABASE_BASE: ::DWORD = 9700;
pub const DNS_ERROR_RECORD_DOES_NOT_EXIST: ::DWORD = 9701;
pub const DNS_ERROR_RECORD_FORMAT: ::DWORD = 9702;
pub const DNS_ERROR_NODE_CREATION_FAILED: ::DWORD = 9703;
pub const DNS_ERROR_UNKNOWN_RECORD_TYPE: ::DWORD = 9704;
pub const DNS_ERROR_RECORD_TIMED_OUT: ::DWORD = 9705;
pub const DNS_ERROR_NAME_NOT_IN_ZONE: ::DWORD = 9706;
pub const DNS_ERROR_CNAME_LOOP: ::DWORD = 9707;
pub const DNS_ERROR_NODE_IS_CNAME: ::DWORD = 9708;
pub const DNS_ERROR_CNAME_COLLISION: ::DWORD = 9709;
pub const DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT: ::DWORD = 9710;
pub const DNS_ERROR_RECORD_ALREADY_EXISTS: ::DWORD = 9711;
pub const DNS_ERROR_SECONDARY_DATA: ::DWORD = 9712;
pub const DNS_ERROR_NO_CREATE_CACHE_DATA: ::DWORD = 9713;
pub const DNS_ERROR_NAME_DOES_NOT_EXIST: ::DWORD = 9714;
pub const DNS_WARNING_PTR_CREATE_FAILED: ::DWORD = 9715;
pub const DNS_WARNING_DOMAIN_UNDELETED: ::DWORD = 9716;
pub const DNS_ERROR_DS_UNAVAILABLE: ::DWORD = 9717;
pub const DNS_ERROR_DS_ZONE_ALREADY_EXISTS: ::DWORD = 9718;
pub const DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE: ::DWORD = 9719;
pub const DNS_ERROR_NODE_IS_DNAME: ::DWORD = 9720;
pub const DNS_ERROR_DNAME_COLLISION: ::DWORD = 9721;
pub const DNS_ERROR_ALIAS_LOOP: ::DWORD = 9722;
pub const DNS_ERROR_OPERATION_BASE: ::DWORD = 9750;
pub const DNS_INFO_AXFR_COMPLETE: ::DWORD = 9751;
pub const DNS_ERROR_AXFR: ::DWORD = 9752;
pub const DNS_INFO_ADDED_LOCAL_WINS: ::DWORD = 9753;
pub const DNS_ERROR_SECURE_BASE: ::DWORD = 9800;
pub const DNS_STATUS_CONTINUE_NEEDED: ::DWORD = 9801;
pub const DNS_ERROR_SETUP_BASE: ::DWORD = 9850;
pub const DNS_ERROR_NO_TCPIP: ::DWORD = 9851;
pub const DNS_ERROR_NO_DNS_SERVERS: ::DWORD = 9852;
pub const DNS_ERROR_DP_BASE: ::DWORD = 9900;
pub const DNS_ERROR_DP_DOES_NOT_EXIST: ::DWORD = 9901;
pub const DNS_ERROR_DP_ALREADY_EXISTS: ::DWORD = 9902;
pub const DNS_ERROR_DP_NOT_ENLISTED: ::DWORD = 9903;
pub const DNS_ERROR_DP_ALREADY_ENLISTED: ::DWORD = 9904;
pub const DNS_ERROR_DP_NOT_AVAILABLE: ::DWORD = 9905;
pub const DNS_ERROR_DP_FSMO_ERROR: ::DWORD = 9906;
pub const DNS_ERROR_ZONESCOPE_ALREADY_EXISTS: ::DWORD = 9951;
pub const DNS_ERROR_ZONESCOPE_DOES_NOT_EXIST: ::DWORD = 9952;
pub const DNS_ERROR_DEFAULT_ZONESCOPE: ::DWORD = 9953;
pub const DNS_ERROR_INVALID_ZONESCOPE_NAME: ::DWORD = 9954;
pub const DNS_ERROR_NOT_ALLOWED_WITH_ZONESCOPES: ::DWORD = 9955;
pub const DNS_ERROR_LOAD_ZONESCOPE_FAILED: ::DWORD = 9956;
pub const DNS_ERROR_ZONESCOPE_FILE_WRITEBACK_FAILED: ::DWORD = 9957;
pub const DNS_ERROR_INVALID_SCOPE_NAME: ::DWORD = 9958;
pub const DNS_ERROR_SCOPE_DOES_NOT_EXIST: ::DWORD = 9959;
pub const DNS_ERROR_DEFAULT_SCOPE: ::DWORD = 9960;
pub const DNS_ERROR_INVALID_SCOPE_OPERATION: ::DWORD = 9961;
pub const DNS_ERROR_SCOPE_LOCKED: ::DWORD = 9962;
pub const DNS_ERROR_SCOPE_ALREADY_EXISTS: ::DWORD = 9963;
pub const WSABASEERR: ::DWORD = 10000;
pub const WSAEINTR: ::DWORD = 10004;
pub const WSAEBADF: ::DWORD = 10009;
pub const WSAEACCES: ::DWORD = 10013;
pub const WSAEFAULT: ::DWORD = 10014;
pub const WSAEINVAL: ::DWORD = 10022;
pub const WSAEMFILE: ::DWORD = 10024;
pub const WSAEWOULDBLOCK: ::DWORD = 10035;
pub const WSAEINPROGRESS: ::DWORD = 10036;
pub const WSAEALREADY: ::DWORD = 10037;
pub const WSAENOTSOCK: ::DWORD = 10038;
pub const WSAEDESTADDRREQ: ::DWORD = 10039;
pub const WSAEMSGSIZE: ::DWORD = 10040;
pub const WSAEPROTOTYPE: ::DWORD = 10041;
pub const WSAENOPROTOOPT: ::DWORD = 10042;
pub const WSAEPROTONOSUPPORT: ::DWORD = 10043;
pub const WSAESOCKTNOSUPPORT: ::DWORD = 10044;
pub const WSAEOPNOTSUPP: ::DWORD = 10045;
pub const WSAEPFNOSUPPORT: ::DWORD = 10046;
pub const WSAEAFNOSUPPORT: ::DWORD = 10047;
pub const WSAEADDRINUSE: ::DWORD = 10048;
pub const WSAEADDRNOTAVAIL: ::DWORD = 10049;
pub const WSAENETDOWN: ::DWORD = 10050;
pub const WSAENETUNREACH: ::DWORD = 10051;
pub const WSAENETRESET: ::DWORD = 10052;
pub const WSAECONNABORTED: ::DWORD = 10053;
pub const WSAECONNRESET: ::DWORD = 10054;
pub const WSAENOBUFS: ::DWORD = 10055;
pub const WSAEISCONN: ::DWORD = 10056;
pub const WSAENOTCONN: ::DWORD = 10057;
pub const WSAESHUTDOWN: ::DWORD = 10058;
pub const WSAETOOMANYREFS: ::DWORD = 10059;
pub const WSAETIMEDOUT: ::DWORD = 10060;
pub const WSAECONNREFUSED: ::DWORD = 10061;
pub const WSAELOOP: ::DWORD = 10062;
pub const WSAENAMETOOLONG: ::DWORD = 10063;
pub const WSAEHOSTDOWN: ::DWORD = 10064;
pub const WSAEHOSTUNREACH: ::DWORD = 10065;
pub const WSAENOTEMPTY: ::DWORD = 10066;
pub const WSAEPROCLIM: ::DWORD = 10067;
pub const WSAEUSERS: ::DWORD = 10068;
pub const WSAEDQUOT: ::DWORD = 10069;
pub const WSAESTALE: ::DWORD = 10070;
pub const WSAEREMOTE: ::DWORD = 10071;
pub const WSASYSNOTREADY: ::DWORD = 10091;
pub const WSAVERNOTSUPPORTED: ::DWORD = 10092;
pub const WSANOTINITIALISED: ::DWORD = 10093;
pub const WSAEDISCON: ::DWORD = 10101;
pub const WSAENOMORE: ::DWORD = 10102;
pub const WSAECANCELLED: ::DWORD = 10103;
pub const WSAEINVALIDPROCTABLE: ::DWORD = 10104;
pub const WSAEINVALIDPROVIDER: ::DWORD = 10105;
pub const WSAEPROVIDERFAILEDINIT: ::DWORD = 10106;
pub const WSASYSCALLFAILURE: ::DWORD = 10107;
pub const WSASERVICE_NOT_FOUND: ::DWORD = 10108;
pub const WSATYPE_NOT_FOUND: ::DWORD = 10109;
pub const WSA_E_NO_MORE: ::DWORD = 10110;
pub const WSA_E_CANCELLED: ::DWORD = 10111;
pub const WSAEREFUSED: ::DWORD = 10112;
pub const WSAHOST_NOT_FOUND: ::DWORD = 11001;
pub const WSATRY_AGAIN: ::DWORD = 11002;
pub const WSANO_RECOVERY: ::DWORD = 11003;
pub const WSANO_DATA: ::DWORD = 11004;
pub const WSA_QOS_RECEIVERS: ::DWORD = 11005;
pub const WSA_QOS_SENDERS: ::DWORD = 11006;
pub const WSA_QOS_NO_SENDERS: ::DWORD = 11007;
pub const WSA_QOS_NO_RECEIVERS: ::DWORD = 11008;
pub const WSA_QOS_REQUEST_CONFIRMED: ::DWORD = 11009;
pub const WSA_QOS_ADMISSION_FAILURE: ::DWORD = 11010;
pub const WSA_QOS_POLICY_FAILURE: ::DWORD = 11011;
pub const WSA_QOS_BAD_STYLE: ::DWORD = 11012;
pub const WSA_QOS_BAD_OBJECT: ::DWORD = 11013;
pub const WSA_QOS_TRAFFIC_CTRL_ERROR: ::DWORD = 11014;
pub const WSA_QOS_GENERIC_ERROR: ::DWORD = 11015;
pub const WSA_QOS_ESERVICETYPE: ::DWORD = 11016;
pub const WSA_QOS_EFLOWSPEC: ::DWORD = 11017;
pub const WSA_QOS_EPROVSPECBUF: ::DWORD = 11018;
pub const WSA_QOS_EFILTERSTYLE: ::DWORD = 11019;
pub const WSA_QOS_EFILTERTYPE: ::DWORD = 11020;
pub const WSA_QOS_EFILTERCOUNT: ::DWORD = 11021;
pub const WSA_QOS_EOBJLENGTH: ::DWORD = 11022;
pub const WSA_QOS_EFLOWCOUNT: ::DWORD = 11023;
pub const WSA_QOS_EUNKOWNPSOBJ: ::DWORD = 11024;
pub const WSA_QOS_EPOLICYOBJ: ::DWORD = 11025;
pub const WSA_QOS_EFLOWDESC: ::DWORD = 11026;
pub const WSA_QOS_EPSFLOWSPEC: ::DWORD = 11027;
pub const WSA_QOS_EPSFILTERSPEC: ::DWORD = 11028;
pub const WSA_QOS_ESDMODEOBJ: ::DWORD = 11029;
pub const WSA_QOS_ESHAPERATEOBJ: ::DWORD = 11030;
pub const WSA_QOS_RESERVED_PETYPE: ::DWORD = 11031;
pub const WSA_SECURE_HOST_NOT_FOUND: ::DWORD = 11032;
pub const WSA_IPSEC_NAME_POLICY_ERROR: ::DWORD = 11033;
pub const ERROR_IPSEC_QM_POLICY_EXISTS: ::DWORD = 13000;
pub const ERROR_IPSEC_QM_POLICY_NOT_FOUND: ::DWORD = 13001;
pub const ERROR_IPSEC_QM_POLICY_IN_USE: ::DWORD = 13002;
pub const ERROR_IPSEC_MM_POLICY_EXISTS: ::DWORD = 13003;
pub const ERROR_IPSEC_MM_POLICY_NOT_FOUND: ::DWORD = 13004;
pub const ERROR_IPSEC_MM_POLICY_IN_USE: ::DWORD = 13005;
pub const ERROR_IPSEC_MM_FILTER_EXISTS: ::DWORD = 13006;
pub const ERROR_IPSEC_MM_FILTER_NOT_FOUND: ::DWORD = 13007;
pub const ERROR_IPSEC_TRANSPORT_FILTER_EXISTS: ::DWORD = 13008;
pub const ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND: ::DWORD = 13009;
pub const ERROR_IPSEC_MM_AUTH_EXISTS: ::DWORD = 13010;
pub const ERROR_IPSEC_MM_AUTH_NOT_FOUND: ::DWORD = 13011;
pub const ERROR_IPSEC_MM_AUTH_IN_USE: ::DWORD = 13012;
pub const ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND: ::DWORD = 13013;
pub const ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND: ::DWORD = 13014;
pub const ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND: ::DWORD = 13015;
pub const ERROR_IPSEC_TUNNEL_FILTER_EXISTS: ::DWORD = 13016;
pub const ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND: ::DWORD = 13017;
pub const ERROR_IPSEC_MM_FILTER_PENDING_DELETION: ::DWORD = 13018;
pub const ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION: ::DWORD = 13019;
pub const ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION: ::DWORD = 13020;
pub const ERROR_IPSEC_MM_POLICY_PENDING_DELETION: ::DWORD = 13021;
pub const ERROR_IPSEC_MM_AUTH_PENDING_DELETION: ::DWORD = 13022;
pub const ERROR_IPSEC_QM_POLICY_PENDING_DELETION: ::DWORD = 13023;
pub const WARNING_IPSEC_MM_POLICY_PRUNED: ::DWORD = 13024;
pub const WARNING_IPSEC_QM_POLICY_PRUNED: ::DWORD = 13025;
pub const ERROR_IPSEC_IKE_NEG_STATUS_BEGIN: ::DWORD = 13800;
pub const ERROR_IPSEC_IKE_AUTH_FAIL: ::DWORD = 13801;
pub const ERROR_IPSEC_IKE_ATTRIB_FAIL: ::DWORD = 13802;
pub const ERROR_IPSEC_IKE_NEGOTIATION_PENDING: ::DWORD = 13803;
pub const ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR: ::DWORD = 13804;
pub const ERROR_IPSEC_IKE_TIMED_OUT: ::DWORD = 13805;
pub const ERROR_IPSEC_IKE_NO_CERT: ::DWORD = 13806;
pub const ERROR_IPSEC_IKE_SA_DELETED: ::DWORD = 13807;
pub const ERROR_IPSEC_IKE_SA_REAPED: ::DWORD = 13808;
pub const ERROR_IPSEC_IKE_MM_ACQUIRE_DROP: ::DWORD = 13809;
pub const ERROR_IPSEC_IKE_QM_ACQUIRE_DROP: ::DWORD = 13810;
pub const ERROR_IPSEC_IKE_QUEUE_DROP_MM: ::DWORD = 13811;
pub const ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM: ::DWORD = 13812;
pub const ERROR_IPSEC_IKE_DROP_NO_RESPONSE: ::DWORD = 13813;
pub const ERROR_IPSEC_IKE_MM_DELAY_DROP: ::DWORD = 13814;
pub const ERROR_IPSEC_IKE_QM_DELAY_DROP: ::DWORD = 13815;
pub const ERROR_IPSEC_IKE_ERROR: ::DWORD = 13816;
pub const ERROR_IPSEC_IKE_CRL_FAILED: ::DWORD = 13817;
pub const ERROR_IPSEC_IKE_INVALID_KEY_USAGE: ::DWORD = 13818;
pub const ERROR_IPSEC_IKE_INVALID_CERT_TYPE: ::DWORD = 13819;
pub const ERROR_IPSEC_IKE_NO_PRIVATE_KEY: ::DWORD = 13820;
pub const ERROR_IPSEC_IKE_SIMULTANEOUS_REKEY: ::DWORD = 13821;
pub const ERROR_IPSEC_IKE_DH_FAIL: ::DWORD = 13822;
pub const ERROR_IPSEC_IKE_CRITICAL_PAYLOAD_NOT_RECOGNIZED: ::DWORD = 13823;
pub const ERROR_IPSEC_IKE_INVALID_HEADER: ::DWORD = 13824;
pub const ERROR_IPSEC_IKE_NO_POLICY: ::DWORD = 13825;
pub const ERROR_IPSEC_IKE_INVALID_SIGNATURE: ::DWORD = 13826;
pub const ERROR_IPSEC_IKE_KERBEROS_ERROR: ::DWORD = 13827;
pub const ERROR_IPSEC_IKE_NO_PUBLIC_KEY: ::DWORD = 13828;
pub const ERROR_IPSEC_IKE_PROCESS_ERR: ::DWORD = 13829;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SA: ::DWORD = 13830;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_PROP: ::DWORD = 13831;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_TRANS: ::DWORD = 13832;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_KE: ::DWORD = 13833;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_ID: ::DWORD = 13834;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT: ::DWORD = 13835;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ: ::DWORD = 13836;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_HASH: ::DWORD = 13837;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_SIG: ::DWORD = 13838;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NONCE: ::DWORD = 13839;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY: ::DWORD = 13840;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_DELETE: ::DWORD = 13841;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR: ::DWORD = 13842;
pub const ERROR_IPSEC_IKE_INVALID_PAYLOAD: ::DWORD = 13843;
pub const ERROR_IPSEC_IKE_LOAD_SOFT_SA: ::DWORD = 13844;
pub const ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN: ::DWORD = 13845;
pub const ERROR_IPSEC_IKE_INVALID_COOKIE: ::DWORD = 13846;
pub const ERROR_IPSEC_IKE_NO_PEER_CERT: ::DWORD = 13847;
pub const ERROR_IPSEC_IKE_PEER_CRL_FAILED: ::DWORD = 13848;
pub const ERROR_IPSEC_IKE_POLICY_CHANGE: ::DWORD = 13849;
pub const ERROR_IPSEC_IKE_NO_MM_POLICY: ::DWORD = 13850;
pub const ERROR_IPSEC_IKE_NOTCBPRIV: ::DWORD = 13851;
pub const ERROR_IPSEC_IKE_SECLOADFAIL: ::DWORD = 13852;
pub const ERROR_IPSEC_IKE_FAILSSPINIT: ::DWORD = 13853;
pub const ERROR_IPSEC_IKE_FAILQUERYSSP: ::DWORD = 13854;
pub const ERROR_IPSEC_IKE_SRVACQFAIL: ::DWORD = 13855;
pub const ERROR_IPSEC_IKE_SRVQUERYCRED: ::DWORD = 13856;
pub const ERROR_IPSEC_IKE_GETSPIFAIL: ::DWORD = 13857;
pub const ERROR_IPSEC_IKE_INVALID_FILTER: ::DWORD = 13858;
pub const ERROR_IPSEC_IKE_OUT_OF_MEMORY: ::DWORD = 13859;
pub const ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED: ::DWORD = 13860;
pub const ERROR_IPSEC_IKE_INVALID_POLICY: ::DWORD = 13861;
pub const ERROR_IPSEC_IKE_UNKNOWN_DOI: ::DWORD = 13862;
pub const ERROR_IPSEC_IKE_INVALID_SITUATION: ::DWORD = 13863;
pub const ERROR_IPSEC_IKE_DH_FAILURE: ::DWORD = 13864;
pub const ERROR_IPSEC_IKE_INVALID_GROUP: ::DWORD = 13865;
pub const ERROR_IPSEC_IKE_ENCRYPT: ::DWORD = 13866;
pub const ERROR_IPSEC_IKE_DECRYPT: ::DWORD = 13867;
pub const ERROR_IPSEC_IKE_POLICY_MATCH: ::DWORD = 13868;
pub const ERROR_IPSEC_IKE_UNSUPPORTED_ID: ::DWORD = 13869;
pub const ERROR_IPSEC_IKE_INVALID_HASH: ::DWORD = 13870;
pub const ERROR_IPSEC_IKE_INVALID_HASH_ALG: ::DWORD = 13871;
pub const ERROR_IPSEC_IKE_INVALID_HASH_SIZE: ::DWORD = 13872;
pub const ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG: ::DWORD = 13873;
pub const ERROR_IPSEC_IKE_INVALID_AUTH_ALG: ::DWORD = 13874;
pub const ERROR_IPSEC_IKE_INVALID_SIG: ::DWORD = 13875;
pub const ERROR_IPSEC_IKE_LOAD_FAILED: ::DWORD = 13876;
pub const ERROR_IPSEC_IKE_RPC_DELETE: ::DWORD = 13877;
pub const ERROR_IPSEC_IKE_BENIGN_REINIT: ::DWORD = 13878;
pub const ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY: ::DWORD = 13879;
pub const ERROR_IPSEC_IKE_INVALID_MAJOR_VERSION: ::DWORD = 13880;
pub const ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN: ::DWORD = 13881;
pub const ERROR_IPSEC_IKE_MM_LIMIT: ::DWORD = 13882;
pub const ERROR_IPSEC_IKE_NEGOTIATION_DISABLED: ::DWORD = 13883;
pub const ERROR_IPSEC_IKE_QM_LIMIT: ::DWORD = 13884;
pub const ERROR_IPSEC_IKE_MM_EXPIRED: ::DWORD = 13885;
pub const ERROR_IPSEC_IKE_PEER_MM_ASSUMED_INVALID: ::DWORD = 13886;
pub const ERROR_IPSEC_IKE_CERT_CHAIN_POLICY_MISMATCH: ::DWORD = 13887;
pub const ERROR_IPSEC_IKE_UNEXPECTED_MESSAGE_ID: ::DWORD = 13888;
pub const ERROR_IPSEC_IKE_INVALID_AUTH_PAYLOAD: ::DWORD = 13889;
pub const ERROR_IPSEC_IKE_DOS_COOKIE_SENT: ::DWORD = 13890;
pub const ERROR_IPSEC_IKE_SHUTTING_DOWN: ::DWORD = 13891;
pub const ERROR_IPSEC_IKE_CGA_AUTH_FAILED: ::DWORD = 13892;
pub const ERROR_IPSEC_IKE_PROCESS_ERR_NATOA: ::DWORD = 13893;
pub const ERROR_IPSEC_IKE_INVALID_MM_FOR_QM: ::DWORD = 13894;
pub const ERROR_IPSEC_IKE_QM_EXPIRED: ::DWORD = 13895;
pub const ERROR_IPSEC_IKE_TOO_MANY_FILTERS: ::DWORD = 13896;
pub const ERROR_IPSEC_IKE_NEG_STATUS_END: ::DWORD = 13897;
pub const ERROR_IPSEC_IKE_KILL_DUMMY_NAP_TUNNEL: ::DWORD = 13898;
pub const ERROR_IPSEC_IKE_INNER_IP_ASSIGNMENT_FAILURE: ::DWORD = 13899;
pub const ERROR_IPSEC_IKE_REQUIRE_CP_PAYLOAD_MISSING: ::DWORD = 13900;
pub const ERROR_IPSEC_KEY_MODULE_IMPERSONATION_NEGOTIATION_PENDING: ::DWORD = 13901;
pub const ERROR_IPSEC_IKE_COEXISTENCE_SUPPRESS: ::DWORD = 13902;
pub const ERROR_IPSEC_IKE_RATELIMIT_DROP: ::DWORD = 13903;
pub const ERROR_IPSEC_IKE_PEER_DOESNT_SUPPORT_MOBIKE: ::DWORD = 13904;
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE: ::DWORD = 13905;
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_FAILURE: ::DWORD = 13906;
pub const ERROR_IPSEC_IKE_AUTHORIZATION_FAILURE_WITH_OPTIONAL_RETRY: ::DWORD = 13907;
pub const ERROR_IPSEC_IKE_STRONG_CRED_AUTHORIZATION_AND_CERTMAP_FAILURE: ::DWORD = 13908;
pub const ERROR_IPSEC_IKE_NEG_STATUS_EXTENDED_END: ::DWORD = 13909;
pub const ERROR_IPSEC_BAD_SPI: ::DWORD = 13910;
pub const ERROR_IPSEC_SA_LIFETIME_EXPIRED: ::DWORD = 13911;
pub const ERROR_IPSEC_WRONG_SA: ::DWORD = 13912;
pub const ERROR_IPSEC_REPLAY_CHECK_FAILED: ::DWORD = 13913;
pub const ERROR_IPSEC_INVALID_PACKET: ::DWORD = 13914;
pub const ERROR_IPSEC_INTEGRITY_CHECK_FAILED: ::DWORD = 13915;
pub const ERROR_IPSEC_CLEAR_TEXT_DROP: ::DWORD = 13916;
pub const ERROR_IPSEC_AUTH_FIREWALL_DROP: ::DWORD = 13917;
pub const ERROR_IPSEC_THROTTLE_DROP: ::DWORD = 13918;
pub const ERROR_IPSEC_DOSP_BLOCK: ::DWORD = 13925;
pub const ERROR_IPSEC_DOSP_RECEIVED_MULTICAST: ::DWORD = 13926;
pub const ERROR_IPSEC_DOSP_INVALID_PACKET: ::DWORD = 13927;
pub const ERROR_IPSEC_DOSP_STATE_LOOKUP_FAILED: ::DWORD = 13928;
pub const ERROR_IPSEC_DOSP_MAX_ENTRIES: ::DWORD = 13929;
pub const ERROR_IPSEC_DOSP_KEYMOD_NOT_ALLOWED: ::DWORD = 13930;
pub const ERROR_IPSEC_DOSP_NOT_INSTALLED: ::DWORD = 13931;
pub const ERROR_IPSEC_DOSP_MAX_PER_IP_RATELIMIT_QUEUES: ::DWORD = 13932;
pub const ERROR_SXS_SECTION_NOT_FOUND: ::DWORD = 14000;
pub const ERROR_SXS_CANT_GEN_ACTCTX: ::DWORD = 14001;
pub const ERROR_SXS_INVALID_ACTCTXDATA_FORMAT: ::DWORD = 14002;
pub const ERROR_SXS_ASSEMBLY_NOT_FOUND: ::DWORD = 14003;
pub const ERROR_SXS_MANIFEST_FORMAT_ERROR: ::DWORD = 14004;
pub const ERROR_SXS_MANIFEST_PARSE_ERROR: ::DWORD = 14005;
pub const ERROR_SXS_ACTIVATION_CONTEXT_DISABLED: ::DWORD = 14006;
pub const ERROR_SXS_KEY_NOT_FOUND: ::DWORD = 14007;
pub const ERROR_SXS_VERSION_CONFLICT: ::DWORD = 14008;
pub const ERROR_SXS_WRONG_SECTION_TYPE: ::DWORD = 14009;
pub const ERROR_SXS_THREAD_QUERIES_DISABLED: ::DWORD = 14010;
pub const ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET: ::DWORD = 14011;
pub const ERROR_SXS_UNKNOWN_ENCODING_GROUP: ::DWORD = 14012;
pub const ERROR_SXS_UNKNOWN_ENCODING: ::DWORD = 14013;
pub const ERROR_SXS_INVALID_XML_NAMESPACE_URI: ::DWORD = 14014;
pub const ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED: ::DWORD = 14015;
pub const ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED: ::DWORD = 14016;
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE: ::DWORD = 14017;
pub const ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE: ::DWORD = 14018;
pub const ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE: ::DWORD = 14019;
pub const ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT: ::DWORD = 14020;
pub const ERROR_SXS_DUPLICATE_DLL_NAME: ::DWORD = 14021;
pub const ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME: ::DWORD = 14022;
pub const ERROR_SXS_DUPLICATE_CLSID: ::DWORD = 14023;
pub const ERROR_SXS_DUPLICATE_IID: ::DWORD = 14024;
pub const ERROR_SXS_DUPLICATE_TLBID: ::DWORD = 14025;
pub const ERROR_SXS_DUPLICATE_PROGID: ::DWORD = 14026;
pub const ERROR_SXS_DUPLICATE_ASSEMBLY_NAME: ::DWORD = 14027;
pub const ERROR_SXS_FILE_HASH_MISMATCH: ::DWORD = 14028;
pub const ERROR_SXS_POLICY_PARSE_ERROR: ::DWORD = 14029;
pub const ERROR_SXS_XML_E_MISSINGQUOTE: ::DWORD = 14030;
pub const ERROR_SXS_XML_E_COMMENTSYNTAX: ::DWORD = 14031;
pub const ERROR_SXS_XML_E_BADSTARTNAMECHAR: ::DWORD = 14032;
pub const ERROR_SXS_XML_E_BADNAMECHAR: ::DWORD = 14033;
pub const ERROR_SXS_XML_E_BADCHARINSTRING: ::DWORD = 14034;
pub const ERROR_SXS_XML_E_XMLDECLSYNTAX: ::DWORD = 14035;
pub const ERROR_SXS_XML_E_BADCHARDATA: ::DWORD = 14036;
pub const ERROR_SXS_XML_E_MISSINGWHITESPACE: ::DWORD = 14037;
pub const ERROR_SXS_XML_E_EXPECTINGTAGEND: ::DWORD = 14038;
pub const ERROR_SXS_XML_E_MISSINGSEMICOLON: ::DWORD = 14039;
pub const ERROR_SXS_XML_E_UNBALANCEDPAREN: ::DWORD = 14040;
pub const ERROR_SXS_XML_E_INTERNALERROR: ::DWORD = 14041;
pub const ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE: ::DWORD = 14042;
pub const ERROR_SXS_XML_E_INCOMPLETE_ENCODING: ::DWORD = 14043;
pub const ERROR_SXS_XML_E_MISSING_PAREN: ::DWORD = 14044;
pub const ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE: ::DWORD = 14045;
pub const ERROR_SXS_XML_E_MULTIPLE_COLONS: ::DWORD = 14046;
pub const ERROR_SXS_XML_E_INVALID_DECIMAL: ::DWORD = 14047;
pub const ERROR_SXS_XML_E_INVALID_HEXIDECIMAL: ::DWORD = 14048;
pub const ERROR_SXS_XML_E_INVALID_UNICODE: ::DWORD = 14049;
pub const ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK: ::DWORD = 14050;
pub const ERROR_SXS_XML_E_UNEXPECTEDENDTAG: ::DWORD = 14051;
pub const ERROR_SXS_XML_E_UNCLOSEDTAG: ::DWORD = 14052;
pub const ERROR_SXS_XML_E_DUPLICATEATTRIBUTE: ::DWORD = 14053;
pub const ERROR_SXS_XML_E_MULTIPLEROOTS: ::DWORD = 14054;
pub const ERROR_SXS_XML_E_INVALIDATROOTLEVEL: ::DWORD = 14055;
pub const ERROR_SXS_XML_E_BADXMLDECL: ::DWORD = 14056;
pub const ERROR_SXS_XML_E_MISSINGROOT: ::DWORD = 14057;
pub const ERROR_SXS_XML_E_UNEXPECTEDEOF: ::DWORD = 14058;
pub const ERROR_SXS_XML_E_BADPEREFINSUBSET: ::DWORD = 14059;
pub const ERROR_SXS_XML_E_UNCLOSEDSTARTTAG: ::DWORD = 14060;
pub const ERROR_SXS_XML_E_UNCLOSEDENDTAG: ::DWORD = 14061;
pub const ERROR_SXS_XML_E_UNCLOSEDSTRING: ::DWORD = 14062;
pub const ERROR_SXS_XML_E_UNCLOSEDCOMMENT: ::DWORD = 14063;
pub const ERROR_SXS_XML_E_UNCLOSEDDECL: ::DWORD = 14064;
pub const ERROR_SXS_XML_E_UNCLOSEDCDATA: ::DWORD = 14065;
pub const ERROR_SXS_XML_E_RESERVEDNAMESPACE: ::DWORD = 14066;
pub const ERROR_SXS_XML_E_INVALIDENCODING: ::DWORD = 14067;
pub const ERROR_SXS_XML_E_INVALIDSWITCH: ::DWORD = 14068;
pub const ERROR_SXS_XML_E_BADXMLCASE: ::DWORD = 14069;
pub const ERROR_SXS_XML_E_INVALID_STANDALONE: ::DWORD = 14070;
pub const ERROR_SXS_XML_E_UNEXPECTED_STANDALONE: ::DWORD = 14071;
pub const ERROR_SXS_XML_E_INVALID_VERSION: ::DWORD = 14072;
pub const ERROR_SXS_XML_E_MISSINGEQUALS: ::DWORD = 14073;
pub const ERROR_SXS_PROTECTION_RECOVERY_FAILED: ::DWORD = 14074;
pub const ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT: ::DWORD = 14075;
pub const ERROR_SXS_PROTECTION_CATALOG_NOT_VALID: ::DWORD = 14076;
pub const ERROR_SXS_UNTRANSLATABLE_HRESULT: ::DWORD = 14077;
pub const ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING: ::DWORD = 14078;
pub const ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE: ::DWORD = 14079;
pub const ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME: ::DWORD = 14080;
pub const ERROR_SXS_ASSEMBLY_MISSING: ::DWORD = 14081;
pub const ERROR_SXS_CORRUPT_ACTIVATION_STACK: ::DWORD = 14082;
pub const ERROR_SXS_CORRUPTION: ::DWORD = 14083;
pub const ERROR_SXS_EARLY_DEACTIVATION: ::DWORD = 14084;
pub const ERROR_SXS_INVALID_DEACTIVATION: ::DWORD = 14085;
pub const ERROR_SXS_MULTIPLE_DEACTIVATION: ::DWORD = 14086;
pub const ERROR_SXS_PROCESS_TERMINATION_REQUESTED: ::DWORD = 14087;
pub const ERROR_SXS_RELEASE_ACTIVATION_CONTEXT: ::DWORD = 14088;
pub const ERROR_SXS_SYSTEM_DEFAULT_ACTIVATION_CONTEXT_EMPTY: ::DWORD = 14089;
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_VALUE: ::DWORD = 14090;
pub const ERROR_SXS_INVALID_IDENTITY_ATTRIBUTE_NAME: ::DWORD = 14091;
pub const ERROR_SXS_IDENTITY_DUPLICATE_ATTRIBUTE: ::DWORD = 14092;
pub const ERROR_SXS_IDENTITY_PARSE_ERROR: ::DWORD = 14093;
pub const ERROR_MALFORMED_SUBSTITUTION_STRING: ::DWORD = 14094;
pub const ERROR_SXS_INCORRECT_PUBLIC_KEY_TOKEN: ::DWORD = 14095;
pub const ERROR_UNMAPPED_SUBSTITUTION_STRING: ::DWORD = 14096;
pub const ERROR_SXS_ASSEMBLY_NOT_LOCKED: ::DWORD = 14097;
pub const ERROR_SXS_COMPONENT_STORE_CORRUPT: ::DWORD = 14098;
pub const ERROR_ADVANCED_INSTALLER_FAILED: ::DWORD = 14099;
pub const ERROR_XML_ENCODING_MISMATCH: ::DWORD = 14100;
pub const ERROR_SXS_MANIFEST_IDENTITY_SAME_BUT_CONTENTS_DIFFERENT: ::DWORD = 14101;
pub const ERROR_SXS_IDENTITIES_DIFFERENT: ::DWORD = 14102;
pub const ERROR_SXS_ASSEMBLY_IS_NOT_A_DEPLOYMENT: ::DWORD = 14103;
pub const ERROR_SXS_FILE_NOT_PART_OF_ASSEMBLY: ::DWORD = 14104;
pub const ERROR_SXS_MANIFEST_TOO_BIG: ::DWORD = 14105;
pub const ERROR_SXS_SETTING_NOT_REGISTERED: ::DWORD = 14106;
pub const ERROR_SXS_TRANSACTION_CLOSURE_INCOMPLETE: ::DWORD = 14107;
pub const ERROR_SMI_PRIMITIVE_INSTALLER_FAILED: ::DWORD = 14108;
pub const ERROR_GENERIC_COMMAND_FAILED: ::DWORD = 14109;
pub const ERROR_SXS_FILE_HASH_MISSING: ::DWORD = 14110;
pub const ERROR_EVT_INVALID_CHANNEL_PATH: ::DWORD = 15000;
pub const ERROR_EVT_INVALID_QUERY: ::DWORD = 15001;
pub const ERROR_EVT_PUBLISHER_METADATA_NOT_FOUND: ::DWORD = 15002;
pub const ERROR_EVT_EVENT_TEMPLATE_NOT_FOUND: ::DWORD = 15003;
pub const ERROR_EVT_INVALID_PUBLISHER_NAME: ::DWORD = 15004;
pub const ERROR_EVT_INVALID_EVENT_DATA: ::DWORD = 15005;
pub const ERROR_EVT_CHANNEL_NOT_FOUND: ::DWORD = 15007;
pub const ERROR_EVT_MALFORMED_XML_TEXT: ::DWORD = 15008;
pub const ERROR_EVT_SUBSCRIPTION_TO_DIRECT_CHANNEL: ::DWORD = 15009;
pub const ERROR_EVT_CONFIGURATION_ERROR: ::DWORD = 15010;
pub const ERROR_EVT_QUERY_RESULT_STALE: ::DWORD = 15011;
pub const ERROR_EVT_QUERY_RESULT_INVALID_POSITION: ::DWORD = 15012;
pub const ERROR_EVT_NON_VALIDATING_MSXML: ::DWORD = 15013;
pub const ERROR_EVT_FILTER_ALREADYSCOPED: ::DWORD = 15014;
pub const ERROR_EVT_FILTER_NOTELTSET: ::DWORD = 15015;
pub const ERROR_EVT_FILTER_INVARG: ::DWORD = 15016;
pub const ERROR_EVT_FILTER_INVTEST: ::DWORD = 15017;
pub const ERROR_EVT_FILTER_INVTYPE: ::DWORD = 15018;
pub const ERROR_EVT_FILTER_PARSEERR: ::DWORD = 15019;
pub const ERROR_EVT_FILTER_UNSUPPORTEDOP: ::DWORD = 15020;
pub const ERROR_EVT_FILTER_UNEXPECTEDTOKEN: ::DWORD = 15021;
pub const ERROR_EVT_INVALID_OPERATION_OVER_ENABLED_DIRECT_CHANNEL: ::DWORD = 15022;
pub const ERROR_EVT_INVALID_CHANNEL_PROPERTY_VALUE: ::DWORD = 15023;
pub const ERROR_EVT_INVALID_PUBLISHER_PROPERTY_VALUE: ::DWORD = 15024;
pub const ERROR_EVT_CHANNEL_CANNOT_ACTIVATE: ::DWORD = 15025;
pub const ERROR_EVT_FILTER_TOO_COMPLEX: ::DWORD = 15026;
pub const ERROR_EVT_MESSAGE_NOT_FOUND: ::DWORD = 15027;
pub const ERROR_EVT_MESSAGE_ID_NOT_FOUND: ::DWORD = 15028;
pub const ERROR_EVT_UNRESOLVED_VALUE_INSERT: ::DWORD = 15029;
pub const ERROR_EVT_UNRESOLVED_PARAMETER_INSERT: ::DWORD = 15030;
pub const ERROR_EVT_MAX_INSERTS_REACHED: ::DWORD = 15031;
pub const ERROR_EVT_EVENT_DEFINITION_NOT_FOUND: ::DWORD = 15032;
pub const ERROR_EVT_MESSAGE_LOCALE_NOT_FOUND: ::DWORD = 15033;
pub const ERROR_EVT_VERSION_TOO_OLD: ::DWORD = 15034;
pub const ERROR_EVT_VERSION_TOO_NEW: ::DWORD = 15035;
pub const ERROR_EVT_CANNOT_OPEN_CHANNEL_OF_QUERY: ::DWORD = 15036;
pub const ERROR_EVT_PUBLISHER_DISABLED: ::DWORD = 15037;
pub const ERROR_EVT_FILTER_OUT_OF_RANGE: ::DWORD = 15038;
pub const ERROR_EC_SUBSCRIPTION_CANNOT_ACTIVATE: ::DWORD = 15080;
pub const ERROR_EC_LOG_DISABLED: ::DWORD = 15081;
pub const ERROR_EC_CIRCULAR_FORWARDING: ::DWORD = 15082;
pub const ERROR_EC_CREDSTORE_FULL: ::DWORD = 15083;
pub const ERROR_EC_CRED_NOT_FOUND: ::DWORD = 15084;
pub const ERROR_EC_NO_ACTIVE_CHANNEL: ::DWORD = 15085;
pub const ERROR_MUI_FILE_NOT_FOUND: ::DWORD = 15100;
pub const ERROR_MUI_INVALID_FILE: ::DWORD = 15101;
pub const ERROR_MUI_INVALID_RC_CONFIG: ::DWORD = 15102;
pub const ERROR_MUI_INVALID_LOCALE_NAME: ::DWORD = 15103;
pub const ERROR_MUI_INVALID_ULTIMATEFALLBACK_NAME: ::DWORD = 15104;
pub const ERROR_MUI_FILE_NOT_LOADED: ::DWORD = 15105;
pub const ERROR_RESOURCE_ENUM_USER_STOP: ::DWORD = 15106;
pub const ERROR_MUI_INTLSETTINGS_UILANG_NOT_INSTALLED: ::DWORD = 15107;
pub const ERROR_MUI_INTLSETTINGS_INVALID_LOCALE_NAME: ::DWORD = 15108;
pub const ERROR_MRM_RUNTIME_NO_DEFAULT_OR_NEUTRAL_RESOURCE: ::DWORD = 15110;
pub const ERROR_MRM_INVALID_PRICONFIG: ::DWORD = 15111;
pub const ERROR_MRM_INVALID_FILE_TYPE: ::DWORD = 15112;
pub const ERROR_MRM_UNKNOWN_QUALIFIER: ::DWORD = 15113;
pub const ERROR_MRM_INVALID_QUALIFIER_VALUE: ::DWORD = 15114;
pub const ERROR_MRM_NO_CANDIDATE: ::DWORD = 15115;
pub const ERROR_MRM_NO_MATCH_OR_DEFAULT_CANDIDATE: ::DWORD = 15116;
pub const ERROR_MRM_RESOURCE_TYPE_MISMATCH: ::DWORD = 15117;
pub const ERROR_MRM_DUPLICATE_MAP_NAME: ::DWORD = 15118;
pub const ERROR_MRM_DUPLICATE_ENTRY: ::DWORD = 15119;
pub const ERROR_MRM_INVALID_RESOURCE_IDENTIFIER: ::DWORD = 15120;
pub const ERROR_MRM_FILEPATH_TOO_LONG: ::DWORD = 15121;
pub const ERROR_MRM_UNSUPPORTED_DIRECTORY_TYPE: ::DWORD = 15122;
pub const ERROR_MRM_INVALID_PRI_FILE: ::DWORD = 15126;
pub const ERROR_MRM_NAMED_RESOURCE_NOT_FOUND: ::DWORD = 15127;
pub const ERROR_MRM_MAP_NOT_FOUND: ::DWORD = 15135;
pub const ERROR_MRM_UNSUPPORTED_PROFILE_TYPE: ::DWORD = 15136;
pub const ERROR_MRM_INVALID_QUALIFIER_OPERATOR: ::DWORD = 15137;
pub const ERROR_MRM_INDETERMINATE_QUALIFIER_VALUE: ::DWORD = 15138;
pub const ERROR_MRM_AUTOMERGE_ENABLED: ::DWORD = 15139;
pub const ERROR_MRM_TOO_MANY_RESOURCES: ::DWORD = 15140;
pub const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_MERGE: ::DWORD = 15141;
pub const ERROR_MRM_UNSUPPORTED_FILE_TYPE_FOR_LOAD_UNLOAD_PRI_FILE: ::DWORD = 15142;
pub const ERROR_MRM_NO_CURRENT_VIEW_ON_THREAD: ::DWORD = 15143;
pub const ERROR_DIFFERENT_PROFILE_RESOURCE_MANAGER_EXIST: ::DWORD = 15144;
pub const ERROR_OPERATION_NOT_ALLOWED_FROM_SYSTEM_COMPONENT: ::DWORD = 15145;
pub const ERROR_MRM_DIRECT_REF_TO_NON_DEFAULT_RESOURCE: ::DWORD = 15146;
pub const ERROR_MRM_GENERATION_COUNT_MISMATCH: ::DWORD = 15147;
pub const ERROR_MCA_INVALID_CAPABILITIES_STRING: ::DWORD = 15200;
pub const ERROR_MCA_INVALID_VCP_VERSION: ::DWORD = 15201;
pub const ERROR_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: ::DWORD = 15202;
pub const ERROR_MCA_MCCS_VERSION_MISMATCH: ::DWORD = 15203;
pub const ERROR_MCA_UNSUPPORTED_MCCS_VERSION: ::DWORD = 15204;
pub const ERROR_MCA_INTERNAL_ERROR: ::DWORD = 15205;
pub const ERROR_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: ::DWORD = 15206;
pub const ERROR_MCA_UNSUPPORTED_COLOR_TEMPERATURE: ::DWORD = 15207;
pub const ERROR_AMBIGUOUS_SYSTEM_DEVICE: ::DWORD = 15250;
pub const ERROR_SYSTEM_DEVICE_NOT_FOUND: ::DWORD = 15299;
pub const ERROR_HASH_NOT_SUPPORTED: ::DWORD = 15300;
pub const ERROR_HASH_NOT_PRESENT: ::DWORD = 15301;
pub const ERROR_SECONDARY_IC_PROVIDER_NOT_REGISTERED: ::DWORD = 15321;
pub const ERROR_GPIO_CLIENT_INFORMATION_INVALID: ::DWORD = 15322;
pub const ERROR_GPIO_VERSION_NOT_SUPPORTED: ::DWORD = 15323;
pub const ERROR_GPIO_INVALID_REGISTRATION_PACKET: ::DWORD = 15324;
pub const ERROR_GPIO_OPERATION_DENIED: ::DWORD = 15325;
pub const ERROR_GPIO_INCOMPATIBLE_CONNECT_MODE: ::DWORD = 15326;
pub const ERROR_GPIO_INTERRUPT_ALREADY_UNMASKED: ::DWORD = 15327;
pub const ERROR_CANNOT_SWITCH_RUNLEVEL: ::DWORD = 15400;
pub const ERROR_INVALID_RUNLEVEL_SETTING: ::DWORD = 15401;
pub const ERROR_RUNLEVEL_SWITCH_TIMEOUT: ::DWORD = 15402;
pub const ERROR_RUNLEVEL_SWITCH_AGENT_TIMEOUT: ::DWORD = 15403;
pub const ERROR_RUNLEVEL_SWITCH_IN_PROGRESS: ::DWORD = 15404;
pub const ERROR_SERVICES_FAILED_AUTOSTART: ::DWORD = 15405;
pub const ERROR_COM_TASK_STOP_PENDING: ::DWORD = 15501;
pub const ERROR_INSTALL_OPEN_PACKAGE_FAILED: ::DWORD = 15600;
pub const ERROR_INSTALL_PACKAGE_NOT_FOUND: ::DWORD = 15601;
pub const ERROR_INSTALL_INVALID_PACKAGE: ::DWORD = 15602;
pub const ERROR_INSTALL_RESOLVE_DEPENDENCY_FAILED: ::DWORD = 15603;
pub const ERROR_INSTALL_OUT_OF_DISK_SPACE: ::DWORD = 15604;
pub const ERROR_INSTALL_NETWORK_FAILURE: ::DWORD = 15605;
pub const ERROR_INSTALL_REGISTRATION_FAILURE: ::DWORD = 15606;
pub const ERROR_INSTALL_DEREGISTRATION_FAILURE: ::DWORD = 15607;
pub const ERROR_INSTALL_CANCEL: ::DWORD = 15608;
pub const ERROR_INSTALL_FAILED: ::DWORD = 15609;
pub const ERROR_REMOVE_FAILED: ::DWORD = 15610;
pub const ERROR_PACKAGE_ALREADY_EXISTS: ::DWORD = 15611;
pub const ERROR_NEEDS_REMEDIATION: ::DWORD = 15612;
pub const ERROR_INSTALL_PREREQUISITE_FAILED: ::DWORD = 15613;
pub const ERROR_PACKAGE_REPOSITORY_CORRUPTED: ::DWORD = 15614;
pub const ERROR_INSTALL_POLICY_FAILURE: ::DWORD = 15615;
pub const ERROR_PACKAGE_UPDATING: ::DWORD = 15616;
pub const ERROR_DEPLOYMENT_BLOCKED_BY_POLICY: ::DWORD = 15617;
pub const ERROR_PACKAGES_IN_USE: ::DWORD = 15618;
pub const ERROR_RECOVERY_FILE_CORRUPT: ::DWORD = 15619;
pub const ERROR_INVALID_STAGED_SIGNATURE: ::DWORD = 15620;
pub const ERROR_DELETING_EXISTING_APPLICATIONDATA_STORE_FAILED: ::DWORD = 15621;
pub const ERROR_INSTALL_PACKAGE_DOWNGRADE: ::DWORD = 15622;
pub const ERROR_SYSTEM_NEEDS_REMEDIATION: ::DWORD = 15623;
pub const ERROR_APPX_INTEGRITY_FAILURE_CLR_NGEN: ::DWORD = 15624;
pub const ERROR_RESILIENCY_FILE_CORRUPT: ::DWORD = 15625;
pub const ERROR_INSTALL_FIREWALL_SERVICE_NOT_RUNNING: ::DWORD = 15626;
pub const APPMODEL_ERROR_NO_PACKAGE: ::DWORD = 15700;
pub const APPMODEL_ERROR_PACKAGE_RUNTIME_CORRUPT: ::DWORD = 15701;
pub const APPMODEL_ERROR_PACKAGE_IDENTITY_CORRUPT: ::DWORD = 15702;
pub const APPMODEL_ERROR_NO_APPLICATION: ::DWORD = 15703;
pub const APPMODEL_ERROR_DYNAMIC_PROPERTY_READ_FAILED: ::DWORD = 15704;
pub const APPMODEL_ERROR_DYNAMIC_PROPERTY_INVALID: ::DWORD = 15705;
pub const ERROR_STATE_LOAD_STORE_FAILED: ::DWORD = 15800;
pub const ERROR_STATE_GET_VERSION_FAILED: ::DWORD = 15801;
pub const ERROR_STATE_SET_VERSION_FAILED: ::DWORD = 15802;
pub const ERROR_STATE_STRUCTURED_RESET_FAILED: ::DWORD = 15803;
pub const ERROR_STATE_OPEN_CONTAINER_FAILED: ::DWORD = 15804;
pub const ERROR_STATE_CREATE_CONTAINER_FAILED: ::DWORD = 15805;
pub const ERROR_STATE_DELETE_CONTAINER_FAILED: ::DWORD = 15806;
pub const ERROR_STATE_READ_SETTING_FAILED: ::DWORD = 15807;
pub const ERROR_STATE_WRITE_SETTING_FAILED: ::DWORD = 15808;
pub const ERROR_STATE_DELETE_SETTING_FAILED: ::DWORD = 15809;
pub const ERROR_STATE_QUERY_SETTING_FAILED: ::DWORD = 15810;
pub const ERROR_STATE_READ_COMPOSITE_SETTING_FAILED: ::DWORD = 15811;
pub const ERROR_STATE_WRITE_COMPOSITE_SETTING_FAILED: ::DWORD = 15812;
pub const ERROR_STATE_ENUMERATE_CONTAINER_FAILED: ::DWORD = 15813;
pub const ERROR_STATE_ENUMERATE_SETTINGS_FAILED: ::DWORD = 15814;
pub const ERROR_STATE_COMPOSITE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: ::DWORD = 15815;
pub const ERROR_STATE_SETTING_VALUE_SIZE_LIMIT_EXCEEDED: ::DWORD = 15816;
pub const ERROR_STATE_SETTING_NAME_SIZE_LIMIT_EXCEEDED: ::DWORD = 15817;
pub const ERROR_STATE_CONTAINER_NAME_SIZE_LIMIT_EXCEEDED: ::DWORD = 15818;
pub const ERROR_API_UNAVAILABLE: ::DWORD = 15841;
pub const STORE_ERROR_UNLICENSED: ::DWORD = 15861;
pub const STORE_ERROR_UNLICENSED_USER: ::DWORD = 15862;
pub const STORE_ERROR_PENDING_COM_TRANSACTION: ::DWORD = 15863;
pub const STORE_ERROR_LICENSE_REVOKED: ::DWORD = 15864;
pub const SEVERITY_SUCCESS: HRESULT = 0;
pub const SEVERITY_ERROR: HRESULT = 1;
pub type HRESULT = ::c_long;
pub const NOERROR: HRESULT = 0;
pub const E_UNEXPECTED: HRESULT = 0x8000FFFFu32 as HRESULT;
pub const E_NOTIMPL: HRESULT = 0x80004001u32 as HRESULT;
pub const E_OUTOFMEMORY: HRESULT = 0x8007000Eu32 as HRESULT;
pub const E_INVALIDARG: HRESULT = 0x80070057u32 as HRESULT;
pub const E_NOINTERFACE: HRESULT = 0x80004002u32 as HRESULT;
pub const E_POINTER: HRESULT = 0x80004003u32 as HRESULT;
pub const E_HANDLE: HRESULT = 0x80070006u32 as HRESULT;
pub const E_ABORT: HRESULT = 0x80004004u32 as HRESULT;
pub const E_FAIL: HRESULT = 0x80004005u32 as HRESULT;
pub const E_ACCESSDENIED: HRESULT = 0x80070005u32 as HRESULT;
pub const E_PENDING: HRESULT = 0x8000000Au32 as HRESULT;
pub const E_BOUNDS: HRESULT = 0x8000000Bu32 as HRESULT;
pub const E_CHANGED_STATE: HRESULT = 0x8000000Cu32 as HRESULT;
pub const E_ILLEGAL_STATE_CHANGE: HRESULT = 0x8000000Du32 as HRESULT;
pub const E_ILLEGAL_METHOD_CALL: HRESULT = 0x8000000Eu32 as HRESULT;
pub const RO_E_METADATA_NAME_NOT_FOUND: HRESULT = 0x8000000Fu32 as HRESULT;
pub const RO_E_METADATA_NAME_IS_NAMESPACE: HRESULT = 0x80000010u32 as HRESULT;
pub const RO_E_METADATA_INVALID_TYPE_FORMAT: HRESULT = 0x80000011u32 as HRESULT;
pub const RO_E_INVALID_METADATA_FILE: HRESULT = 0x80000012u32 as HRESULT;
pub const RO_E_CLOSED: HRESULT = 0x80000013u32 as HRESULT;
pub const RO_E_EXCLUSIVE_WRITE: HRESULT = 0x80000014u32 as HRESULT;
pub const RO_E_CHANGE_NOTIFICATION_IN_PROGRESS: HRESULT = 0x80000015u32 as HRESULT;
pub const RO_E_ERROR_STRING_NOT_FOUND: HRESULT = 0x80000016u32 as HRESULT;
pub const E_STRING_NOT_NULL_TERMINATED: HRESULT = 0x80000017u32 as HRESULT;
pub const E_ILLEGAL_DELEGATE_ASSIGNMENT: HRESULT = 0x80000018u32 as HRESULT;
pub const E_ASYNC_OPERATION_NOT_STARTED: HRESULT = 0x80000019u32 as HRESULT;
pub const E_APPLICATION_EXITING: HRESULT = 0x8000001Au32 as HRESULT;
pub const E_APPLICATION_VIEW_EXITING: HRESULT = 0x8000001Bu32 as HRESULT;
pub const RO_E_MUST_BE_AGILE: HRESULT = 0x8000001Cu32 as HRESULT;
pub const RO_E_UNSUPPORTED_FROM_MTA: HRESULT = 0x8000001Du32 as HRESULT;
pub const RO_E_COMMITTED: HRESULT = 0x8000001Eu32 as HRESULT;
pub const RO_E_BLOCKED_CROSS_ASTA_CALL: HRESULT = 0x8000001Fu32 as HRESULT;
pub const CO_E_INIT_TLS: HRESULT = 0x80004006u32 as HRESULT;
pub const CO_E_INIT_SHARED_ALLOCATOR: HRESULT = 0x80004007u32 as HRESULT;
pub const CO_E_INIT_MEMORY_ALLOCATOR: HRESULT = 0x80004008u32 as HRESULT;
pub const CO_E_INIT_CLASS_CACHE: HRESULT = 0x80004009u32 as HRESULT;
pub const CO_E_INIT_RPC_CHANNEL: HRESULT = 0x8000400Au32 as HRESULT;
pub const CO_E_INIT_TLS_SET_CHANNEL_CONTROL: HRESULT = 0x8000400Bu32 as HRESULT;
pub const CO_E_INIT_TLS_CHANNEL_CONTROL: HRESULT = 0x8000400Cu32 as HRESULT;
pub const CO_E_INIT_UNACCEPTED_USER_ALLOCATOR: HRESULT = 0x8000400Du32 as HRESULT;
pub const CO_E_INIT_SCM_MUTEX_EXISTS: HRESULT = 0x8000400Eu32 as HRESULT;
pub const CO_E_INIT_SCM_FILE_MAPPING_EXISTS: HRESULT = 0x8000400Fu32 as HRESULT;
pub const CO_E_INIT_SCM_MAP_VIEW_OF_FILE: HRESULT = 0x80004010u32 as HRESULT;
pub const CO_E_INIT_SCM_EXEC_FAILURE: HRESULT = 0x80004011u32 as HRESULT;
pub const CO_E_INIT_ONLY_SINGLE_THREADED: HRESULT = 0x80004012u32 as HRESULT;
pub const CO_E_CANT_REMOTE: HRESULT = 0x80004013u32 as HRESULT;
pub const CO_E_BAD_SERVER_NAME: HRESULT = 0x80004014u32 as HRESULT;
pub const CO_E_WRONG_SERVER_IDENTITY: HRESULT = 0x80004015u32 as HRESULT;
pub const CO_E_OLE1DDE_DISABLED: HRESULT = 0x80004016u32 as HRESULT;
pub const CO_E_RUNAS_SYNTAX: HRESULT = 0x80004017u32 as HRESULT;
pub const CO_E_CREATEPROCESS_FAILURE: HRESULT = 0x80004018u32 as HRESULT;
pub const CO_E_RUNAS_CREATEPROCESS_FAILURE: HRESULT = 0x80004019u32 as HRESULT;
pub const CO_E_RUNAS_LOGON_FAILURE: HRESULT = 0x8000401Au32 as HRESULT;
pub const CO_E_LAUNCH_PERMSSION_DENIED: HRESULT = 0x8000401Bu32 as HRESULT;
pub const CO_E_START_SERVICE_FAILURE: HRESULT = 0x8000401Cu32 as HRESULT;
pub const CO_E_REMOTE_COMMUNICATION_FAILURE: HRESULT = 0x8000401Du32 as HRESULT;
pub const CO_E_SERVER_START_TIMEOUT: HRESULT = 0x8000401Eu32 as HRESULT;
pub const CO_E_CLSREG_INCONSISTENT: HRESULT = 0x8000401Fu32 as HRESULT;
pub const CO_E_IIDREG_INCONSISTENT: HRESULT = 0x80004020u32 as HRESULT;
pub const CO_E_NOT_SUPPORTED: HRESULT = 0x80004021u32 as HRESULT;
pub const CO_E_RELOAD_DLL: HRESULT = 0x80004022u32 as HRESULT;
pub const CO_E_MSI_ERROR: HRESULT = 0x80004023u32 as HRESULT;
pub const CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT: HRESULT = 0x80004024u32 as HRESULT;
pub const CO_E_SERVER_PAUSED: HRESULT = 0x80004025u32 as HRESULT;
pub const CO_E_SERVER_NOT_PAUSED: HRESULT = 0x80004026u32 as HRESULT;
pub const CO_E_CLASS_DISABLED: HRESULT = 0x80004027u32 as HRESULT;
pub const CO_E_CLRNOTAVAILABLE: HRESULT = 0x80004028u32 as HRESULT;
pub const CO_E_ASYNC_WORK_REJECTED: HRESULT = 0x80004029u32 as HRESULT;
pub const CO_E_SERVER_INIT_TIMEOUT: HRESULT = 0x8000402Au32 as HRESULT;
pub const CO_E_NO_SECCTX_IN_ACTIVATE: HRESULT = 0x8000402Bu32 as HRESULT;
pub const CO_E_TRACKER_CONFIG: HRESULT = 0x80004030u32 as HRESULT;
pub const CO_E_THREADPOOL_CONFIG: HRESULT = 0x80004031u32 as HRESULT;
pub const CO_E_SXS_CONFIG: HRESULT = 0x80004032u32 as HRESULT;
pub const CO_E_MALFORMED_SPN: HRESULT = 0x80004033u32 as HRESULT;
pub const CO_E_UNREVOKED_REGISTRATION_ON_APARTMENT_SHUTDOWN: HRESULT = 0x80004034u32 as HRESULT;
pub const CO_E_PREMATURE_STUB_RUNDOWN: HRESULT = 0x80004035u32 as HRESULT;
pub const S_OK: HRESULT = 0;
pub const S_FALSE: HRESULT = 1;
pub const OLE_E_FIRST: HRESULT = 0x80040000u32 as HRESULT;
pub const OLE_E_LAST: HRESULT = 0x800400FFu32 as HRESULT;
pub const OLE_S_FIRST: HRESULT = 0x00040000;
pub const OLE_S_LAST: HRESULT = 0x000400FF;
pub const OLE_E_OLEVERB: HRESULT = 0x80040000u32 as HRESULT;
pub const OLE_E_ADVF: HRESULT = 0x80040001u32 as HRESULT;
pub const OLE_E_ENUM_NOMORE: HRESULT = 0x80040002u32 as HRESULT;
pub const OLE_E_ADVISENOTSUPPORTED: HRESULT = 0x80040003u32 as HRESULT;
pub const OLE_E_NOCONNECTION: HRESULT = 0x80040004u32 as HRESULT;
pub const OLE_E_NOTRUNNING: HRESULT = 0x80040005u32 as HRESULT;
pub const OLE_E_NOCACHE: HRESULT = 0x80040006u32 as HRESULT;
pub const OLE_E_BLANK: HRESULT = 0x80040007u32 as HRESULT;
pub const OLE_E_CLASSDIFF: HRESULT = 0x80040008u32 as HRESULT;
pub const OLE_E_CANT_GETMONIKER: HRESULT = 0x80040009u32 as HRESULT;
pub const OLE_E_CANT_BINDTOSOURCE: HRESULT = 0x8004000Au32 as HRESULT;
pub const OLE_E_STATIC: HRESULT = 0x8004000Bu32 as HRESULT;
pub const OLE_E_PROMPTSAVECANCELLED: HRESULT = 0x8004000Cu32 as HRESULT;
pub const OLE_E_INVALIDRECT: HRESULT = 0x8004000Du32 as HRESULT;
pub const OLE_E_WRONGCOMPOBJ: HRESULT = 0x8004000Eu32 as HRESULT;
pub const OLE_E_INVALIDHWND: HRESULT = 0x8004000Fu32 as HRESULT;
pub const OLE_E_NOT_INPLACEACTIVE: HRESULT = 0x80040010u32 as HRESULT;
pub const OLE_E_CANTCONVERT: HRESULT = 0x80040011u32 as HRESULT;
pub const OLE_E_NOSTORAGE: HRESULT = 0x80040012u32 as HRESULT;
pub const DV_E_FORMATETC: HRESULT = 0x80040064u32 as HRESULT;
pub const DV_E_DVTARGETDEVICE: HRESULT = 0x80040065u32 as HRESULT;
pub const DV_E_STGMEDIUM: HRESULT = 0x80040066u32 as HRESULT;
pub const DV_E_STATDATA: HRESULT = 0x80040067u32 as HRESULT;
pub const DV_E_LINDEX: HRESULT = 0x80040068u32 as HRESULT;
pub const DV_E_TYMED: HRESULT = 0x80040069u32 as HRESULT;
pub const DV_E_CLIPFORMAT: HRESULT = 0x8004006Au32 as HRESULT;
pub const DV_E_DVASPECT: HRESULT = 0x8004006Bu32 as HRESULT;
pub const DV_E_DVTARGETDEVICE_SIZE: HRESULT = 0x8004006Cu32 as HRESULT;
pub const DV_E_NOIVIEWOBJECT: HRESULT = 0x8004006Du32 as HRESULT;
pub const DRAGDROP_E_FIRST: HRESULT = 0x80040100u32 as HRESULT;
pub const DRAGDROP_E_LAST: HRESULT = 0x8004010Fu32 as HRESULT;
pub const DRAGDROP_S_FIRST: HRESULT = 0x00040100;
pub const DRAGDROP_S_LAST: HRESULT = 0x0004010F;
pub const DRAGDROP_E_NOTREGISTERED: HRESULT = 0x80040100u32 as HRESULT;
pub const DRAGDROP_E_ALREADYREGISTERED: HRESULT = 0x80040101u32 as HRESULT;
pub const DRAGDROP_E_INVALIDHWND: HRESULT = 0x80040102u32 as HRESULT;
pub const DRAGDROP_E_CONCURRENT_DRAG_ATTEMPTED: HRESULT = 0x80040103u32 as HRESULT;
pub const CLASSFACTORY_E_FIRST: HRESULT = 0x80040110u32 as HRESULT;
pub const CLASSFACTORY_E_LAST: HRESULT = 0x8004011Fu32 as HRESULT;
pub const CLASSFACTORY_S_FIRST: HRESULT = 0x00040110;
pub const CLASSFACTORY_S_LAST: HRESULT = 0x0004011F;
pub const CLASS_E_NOAGGREGATION: HRESULT = 0x80040110u32 as HRESULT;
pub const CLASS_E_CLASSNOTAVAILABLE: HRESULT = 0x80040111u32 as HRESULT;
pub const CLASS_E_NOTLICENSED: HRESULT = 0x80040112u32 as HRESULT;
pub const MARSHAL_E_FIRST: HRESULT = 0x80040120u32 as HRESULT;
pub const MARSHAL_E_LAST: HRESULT = 0x8004012Fu32 as HRESULT;
pub const MARSHAL_S_FIRST: HRESULT = 0x00040120;
pub const MARSHAL_S_LAST: HRESULT = 0x0004012F;
pub const DATA_E_FIRST: HRESULT = 0x80040130u32 as HRESULT;
pub const DATA_E_LAST: HRESULT = 0x8004013Fu32 as HRESULT;
pub const DATA_S_FIRST: HRESULT = 0x00040130;
pub const DATA_S_LAST: HRESULT = 0x0004013F;
pub const VIEW_E_FIRST: HRESULT = 0x80040140u32 as HRESULT;
pub const VIEW_E_LAST: HRESULT = 0x8004014Fu32 as HRESULT;
pub const VIEW_S_FIRST: HRESULT = 0x00040140;
pub const VIEW_S_LAST: HRESULT = 0x0004014F;
pub const VIEW_E_DRAW: HRESULT = 0x80040140u32 as HRESULT;
pub const REGDB_E_FIRST: HRESULT = 0x80040150u32 as HRESULT;
pub const REGDB_E_LAST: HRESULT = 0x8004015Fu32 as HRESULT;
pub const REGDB_S_FIRST: HRESULT = 0x00040150;
pub const REGDB_S_LAST: HRESULT = 0x0004015F;
pub const REGDB_E_READREGDB: HRESULT = 0x80040150u32 as HRESULT;
pub const REGDB_E_WRITEREGDB: HRESULT = 0x80040151u32 as HRESULT;
pub const REGDB_E_KEYMISSING: HRESULT = 0x80040152u32 as HRESULT;
pub const REGDB_E_INVALIDVALUE: HRESULT = 0x80040153u32 as HRESULT;
pub const REGDB_E_CLASSNOTREG: HRESULT = 0x80040154u32 as HRESULT;
pub const REGDB_E_IIDNOTREG: HRESULT = 0x80040155u32 as HRESULT;
pub const REGDB_E_BADTHREADINGMODEL: HRESULT = 0x80040156u32 as HRESULT;
pub const CAT_E_FIRST: HRESULT = 0x80040160u32 as HRESULT;
pub const CAT_E_LAST: HRESULT = 0x80040161u32 as HRESULT;
pub const CAT_E_CATIDNOEXIST: HRESULT = 0x80040160u32 as HRESULT;
pub const CAT_E_NODESCRIPTION: HRESULT = 0x80040161u32 as HRESULT;
pub const CS_E_FIRST: HRESULT = 0x80040164u32 as HRESULT;
pub const CS_E_LAST: HRESULT = 0x8004016Fu32 as HRESULT;
pub const CS_E_PACKAGE_NOTFOUND: HRESULT = 0x80040164u32 as HRESULT;
pub const CS_E_NOT_DELETABLE: HRESULT = 0x80040165u32 as HRESULT;
pub const CS_E_CLASS_NOTFOUND: HRESULT = 0x80040166u32 as HRESULT;
pub const CS_E_INVALID_VERSION: HRESULT = 0x80040167u32 as HRESULT;
pub const CS_E_NO_CLASSSTORE: HRESULT = 0x80040168u32 as HRESULT;
pub const CS_E_OBJECT_NOTFOUND: HRESULT = 0x80040169u32 as HRESULT;
pub const CS_E_OBJECT_ALREADY_EXISTS: HRESULT = 0x8004016Au32 as HRESULT;
pub const CS_E_INVALID_PATH: HRESULT = 0x8004016Bu32 as HRESULT;
pub const CS_E_NETWORK_ERROR: HRESULT = 0x8004016Cu32 as HRESULT;
pub const CS_E_ADMIN_LIMIT_EXCEEDED: HRESULT = 0x8004016Du32 as HRESULT;
pub const CS_E_SCHEMA_MISMATCH: HRESULT = 0x8004016Eu32 as HRESULT;
pub const CS_E_INTERNAL_ERROR: HRESULT = 0x8004016Fu32 as HRESULT;
pub const CACHE_E_FIRST: HRESULT = 0x80040170u32 as HRESULT;
pub const CACHE_E_LAST: HRESULT = 0x8004017Fu32 as HRESULT;
pub const CACHE_S_FIRST: HRESULT = 0x00040170;
pub const CACHE_S_LAST: HRESULT = 0x0004017F;
pub const CACHE_E_NOCACHE_UPDATED: HRESULT = 0x80040170u32 as HRESULT;
pub const OLEOBJ_E_FIRST: HRESULT = 0x80040180u32 as HRESULT;
pub const OLEOBJ_E_LAST: HRESULT = 0x8004018Fu32 as HRESULT;
pub const OLEOBJ_S_FIRST: HRESULT = 0x00040180;
pub const OLEOBJ_S_LAST: HRESULT = 0x0004018F;
pub const OLEOBJ_E_NOVERBS: HRESULT = 0x80040180u32 as HRESULT;
pub const OLEOBJ_E_INVALIDVERB: HRESULT = 0x80040181u32 as HRESULT;
pub const CLIENTSITE_E_FIRST: HRESULT = 0x80040190u32 as HRESULT;
pub const CLIENTSITE_E_LAST: HRESULT = 0x8004019Fu32 as HRESULT;
pub const CLIENTSITE_S_FIRST: HRESULT = 0x00040190;
pub const CLIENTSITE_S_LAST: HRESULT = 0x0004019F;
pub const INPLACE_E_NOTUNDOABLE: HRESULT = 0x800401A0u32 as HRESULT;
pub const INPLACE_E_NOTOOLSPACE: HRESULT = 0x800401A1u32 as HRESULT;
pub const INPLACE_E_FIRST: HRESULT = 0x800401A0u32 as HRESULT;
pub const INPLACE_E_LAST: HRESULT = 0x800401AFu32 as HRESULT;
pub const INPLACE_S_FIRST: HRESULT = 0x000401A0;
pub const INPLACE_S_LAST: HRESULT = 0x000401AF;
pub const ENUM_E_FIRST: HRESULT = 0x800401B0u32 as HRESULT;
pub const ENUM_E_LAST: HRESULT = 0x800401BFu32 as HRESULT;
pub const ENUM_S_FIRST: HRESULT = 0x000401B0;
pub const ENUM_S_LAST: HRESULT = 0x000401BF;
pub const CONVERT10_E_FIRST: HRESULT = 0x800401C0u32 as HRESULT;
pub const CONVERT10_E_LAST: HRESULT = 0x800401CFu32 as HRESULT;
pub const CONVERT10_S_FIRST: HRESULT = 0x000401C0;
pub const CONVERT10_S_LAST: HRESULT = 0x000401CF;
pub const CONVERT10_E_OLESTREAM_GET: HRESULT = 0x800401C0u32 as HRESULT;
pub const CONVERT10_E_OLESTREAM_PUT: HRESULT = 0x800401C1u32 as HRESULT;
pub const CONVERT10_E_OLESTREAM_FMT: HRESULT = 0x800401C2u32 as HRESULT;
pub const CONVERT10_E_OLESTREAM_BITMAP_TO_DIB: HRESULT = 0x800401C3u32 as HRESULT;
pub const CONVERT10_E_STG_FMT: HRESULT = 0x800401C4u32 as HRESULT;
pub const CONVERT10_E_STG_NO_STD_STREAM: HRESULT = 0x800401C5u32 as HRESULT;
pub const CONVERT10_E_STG_DIB_TO_BITMAP: HRESULT = 0x800401C6u32 as HRESULT;
pub const CLIPBRD_E_FIRST: HRESULT = 0x800401D0u32 as HRESULT;
pub const CLIPBRD_E_LAST: HRESULT = 0x800401DFu32 as HRESULT;
pub const CLIPBRD_S_FIRST: HRESULT = 0x000401D0;
pub const CLIPBRD_S_LAST: HRESULT = 0x000401DF;
pub const CLIPBRD_E_CANT_OPEN: HRESULT = 0x800401D0u32 as HRESULT;
pub const CLIPBRD_E_CANT_EMPTY: HRESULT = 0x800401D1u32 as HRESULT;
pub const CLIPBRD_E_CANT_SET: HRESULT = 0x800401D2u32 as HRESULT;
pub const CLIPBRD_E_BAD_DATA: HRESULT = 0x800401D3u32 as HRESULT;
pub const CLIPBRD_E_CANT_CLOSE: HRESULT = 0x800401D4u32 as HRESULT;
pub const MK_E_FIRST: HRESULT = 0x800401E0u32 as HRESULT;
pub const MK_E_LAST: HRESULT = 0x800401EFu32 as HRESULT;
pub const MK_S_FIRST: HRESULT = 0x000401E0;
pub const MK_S_LAST: HRESULT = 0x000401EF;
pub const MK_E_CONNECTMANUALLY: HRESULT = 0x800401E0u32 as HRESULT;
pub const MK_E_EXCEEDEDDEADLINE: HRESULT = 0x800401E1u32 as HRESULT;
pub const MK_E_NEEDGENERIC: HRESULT = 0x800401E2u32 as HRESULT;
pub const MK_E_UNAVAILABLE: HRESULT = 0x800401E3u32 as HRESULT;
pub const MK_E_SYNTAX: HRESULT = 0x800401E4u32 as HRESULT;
pub const MK_E_NOOBJECT: HRESULT = 0x800401E5u32 as HRESULT;
pub const MK_E_INVALIDEXTENSION: HRESULT = 0x800401E6u32 as HRESULT;
pub const MK_E_INTERMEDIATEINTERFACENOTSUPPORTED: HRESULT = 0x800401E7u32 as HRESULT;
pub const MK_E_NOTBINDABLE: HRESULT = 0x800401E8u32 as HRESULT;
pub const MK_E_NOTBOUND: HRESULT = 0x800401E9u32 as HRESULT;
pub const MK_E_CANTOPENFILE: HRESULT = 0x800401EAu32 as HRESULT;
pub const MK_E_MUSTBOTHERUSER: HRESULT = 0x800401EBu32 as HRESULT;
pub const MK_E_NOINVERSE: HRESULT = 0x800401ECu32 as HRESULT;
pub const MK_E_NOSTORAGE: HRESULT = 0x800401EDu32 as HRESULT;
pub const MK_E_NOPREFIX: HRESULT = 0x800401EEu32 as HRESULT;
pub const MK_E_ENUMERATION_FAILED: HRESULT = 0x800401EFu32 as HRESULT;
pub const CO_E_FIRST: HRESULT = 0x800401F0u32 as HRESULT;
pub const CO_E_LAST: HRESULT = 0x800401FFu32 as HRESULT;
pub const CO_S_FIRST: HRESULT = 0x000401F0;
pub const CO_S_LAST: HRESULT = 0x000401FF;
pub const CO_E_NOTINITIALIZED: HRESULT = 0x800401F0u32 as HRESULT;
pub const CO_E_ALREADYINITIALIZED: HRESULT = 0x800401F1u32 as HRESULT;
pub const CO_E_CANTDETERMINECLASS: HRESULT = 0x800401F2u32 as HRESULT;
pub const CO_E_CLASSSTRING: HRESULT = 0x800401F3u32 as HRESULT;
pub const CO_E_IIDSTRING: HRESULT = 0x800401F4u32 as HRESULT;
pub const CO_E_APPNOTFOUND: HRESULT = 0x800401F5u32 as HRESULT;
pub const CO_E_APPSINGLEUSE: HRESULT = 0x800401F6u32 as HRESULT;
pub const CO_E_ERRORINAPP: HRESULT = 0x800401F7u32 as HRESULT;
pub const CO_E_DLLNOTFOUND: HRESULT = 0x800401F8u32 as HRESULT;
pub const CO_E_ERRORINDLL: HRESULT = 0x800401F9u32 as HRESULT;
pub const CO_E_WRONGOSFORAPP: HRESULT = 0x800401FAu32 as HRESULT;
pub const CO_E_OBJNOTREG: HRESULT = 0x800401FBu32 as HRESULT;
pub const CO_E_OBJISREG: HRESULT = 0x800401FCu32 as HRESULT;
pub const CO_E_OBJNOTCONNECTED: HRESULT = 0x800401FDu32 as HRESULT;
pub const CO_E_APPDIDNTREG: HRESULT = 0x800401FEu32 as HRESULT;
pub const CO_E_RELEASED: HRESULT = 0x800401FFu32 as HRESULT;
pub const EVENT_E_FIRST: HRESULT = 0x80040200u32 as HRESULT;
pub const EVENT_E_LAST: HRESULT = 0x8004021Fu32 as HRESULT;
pub const EVENT_S_FIRST: HRESULT = 0x00040200;
pub const EVENT_S_LAST: HRESULT = 0x0004021F;
pub const EVENT_S_SOME_SUBSCRIBERS_FAILED: HRESULT = 0x00040200;
pub const EVENT_E_ALL_SUBSCRIBERS_FAILED: HRESULT = 0x80040201u32 as HRESULT;
pub const EVENT_S_NOSUBSCRIBERS: HRESULT = 0x00040202;
pub const EVENT_E_QUERYSYNTAX: HRESULT = 0x80040203u32 as HRESULT;
pub const EVENT_E_QUERYFIELD: HRESULT = 0x80040204u32 as HRESULT;
pub const EVENT_E_INTERNALEXCEPTION: HRESULT = 0x80040205u32 as HRESULT;
pub const EVENT_E_INTERNALERROR: HRESULT = 0x80040206u32 as HRESULT;
pub const EVENT_E_INVALID_PER_USER_SID: HRESULT = 0x80040207u32 as HRESULT;
pub const EVENT_E_USER_EXCEPTION: HRESULT = 0x80040208u32 as HRESULT;
pub const EVENT_E_TOO_MANY_METHODS: HRESULT = 0x80040209u32 as HRESULT;
pub const EVENT_E_MISSING_EVENTCLASS: HRESULT = 0x8004020Au32 as HRESULT;
pub const EVENT_E_NOT_ALL_REMOVED: HRESULT = 0x8004020Bu32 as HRESULT;
pub const EVENT_E_COMPLUS_NOT_INSTALLED: HRESULT = 0x8004020Cu32 as HRESULT;
pub const EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT: HRESULT = 0x8004020Du32 as HRESULT;
pub const EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT: HRESULT = 0x8004020Eu32 as HRESULT;
pub const EVENT_E_INVALID_EVENT_CLASS_PARTITION: HRESULT = 0x8004020Fu32 as HRESULT;
pub const EVENT_E_PER_USER_SID_NOT_LOGGED_ON: HRESULT = 0x80040210u32 as HRESULT;
pub const TPC_E_INVALID_PROPERTY: HRESULT = 0x80040241u32 as HRESULT;
pub const TPC_E_NO_DEFAULT_TABLET: HRESULT = 0x80040212u32 as HRESULT;
pub const TPC_E_UNKNOWN_PROPERTY: HRESULT = 0x8004021Bu32 as HRESULT;
pub const TPC_E_INVALID_INPUT_RECT: HRESULT = 0x80040219u32 as HRESULT;
pub const TPC_E_INVALID_STROKE: HRESULT = 0x80040222u32 as HRESULT;
pub const TPC_E_INITIALIZE_FAIL: HRESULT = 0x80040223u32 as HRESULT;
pub const TPC_E_NOT_RELEVANT: HRESULT = 0x80040232u32 as HRESULT;
pub const TPC_E_INVALID_PACKET_DESCRIPTION: HRESULT = 0x80040233u32 as HRESULT;
pub const TPC_E_RECOGNIZER_NOT_REGISTERED: HRESULT = 0x80040235u32 as HRESULT;
pub const TPC_E_INVALID_RIGHTS: HRESULT = 0x80040236u32 as HRESULT;
pub const TPC_E_OUT_OF_ORDER_CALL: HRESULT = 0x80040237u32 as HRESULT;
pub const TPC_E_QUEUE_FULL: HRESULT = 0x80040238u32 as HRESULT;
pub const TPC_E_INVALID_CONFIGURATION: HRESULT = 0x80040239u32 as HRESULT;
pub const TPC_E_INVALID_DATA_FROM_RECOGNIZER: HRESULT = 0x8004023Au32 as HRESULT;
pub const TPC_S_TRUNCATED: HRESULT = 0x00040252;
pub const TPC_S_INTERRUPTED: HRESULT = 0x00040253;
pub const TPC_S_NO_DATA_TO_PROCESS: HRESULT = 0x00040254;
pub const XACT_E_FIRST: HRESULT = 0x8004D000u32 as HRESULT;
pub const XACT_E_LAST: HRESULT = 0x8004D02Bu32 as HRESULT;
pub const XACT_S_FIRST: HRESULT = 0x0004D000;
pub const XACT_S_LAST: HRESULT = 0x0004D010;
pub const XACT_E_ALREADYOTHERSINGLEPHASE: HRESULT = 0x8004D000u32 as HRESULT;
pub const XACT_E_CANTRETAIN: HRESULT = 0x8004D001u32 as HRESULT;
pub const XACT_E_COMMITFAILED: HRESULT = 0x8004D002u32 as HRESULT;
pub const XACT_E_COMMITPREVENTED: HRESULT = 0x8004D003u32 as HRESULT;
pub const XACT_E_HEURISTICABORT: HRESULT = 0x8004D004u32 as HRESULT;
pub const XACT_E_HEURISTICCOMMIT: HRESULT = 0x8004D005u32 as HRESULT;
pub const XACT_E_HEURISTICDAMAGE: HRESULT = 0x8004D006u32 as HRESULT;
pub const XACT_E_HEURISTICDANGER: HRESULT = 0x8004D007u32 as HRESULT;
pub const XACT_E_ISOLATIONLEVEL: HRESULT = 0x8004D008u32 as HRESULT;
pub const XACT_E_NOASYNC: HRESULT = 0x8004D009u32 as HRESULT;
pub const XACT_E_NOENLIST: HRESULT = 0x8004D00Au32 as HRESULT;
pub const XACT_E_NOISORETAIN: HRESULT = 0x8004D00Bu32 as HRESULT;
pub const XACT_E_NORESOURCE: HRESULT = 0x8004D00Cu32 as HRESULT;
pub const XACT_E_NOTCURRENT: HRESULT = 0x8004D00Du32 as HRESULT;
pub const XACT_E_NOTRANSACTION: HRESULT = 0x8004D00Eu32 as HRESULT;
pub const XACT_E_NOTSUPPORTED: HRESULT = 0x8004D00Fu32 as HRESULT;
pub const XACT_E_UNKNOWNRMGRID: HRESULT = 0x8004D010u32 as HRESULT;
pub const XACT_E_WRONGSTATE: HRESULT = 0x8004D011u32 as HRESULT;
pub const XACT_E_WRONGUOW: HRESULT = 0x8004D012u32 as HRESULT;
pub const XACT_E_XTIONEXISTS: HRESULT = 0x8004D013u32 as HRESULT;
pub const XACT_E_NOIMPORTOBJECT: HRESULT = 0x8004D014u32 as HRESULT;
pub const XACT_E_INVALIDCOOKIE: HRESULT = 0x8004D015u32 as HRESULT;
pub const XACT_E_INDOUBT: HRESULT = 0x8004D016u32 as HRESULT;
pub const XACT_E_NOTIMEOUT: HRESULT = 0x8004D017u32 as HRESULT;
pub const XACT_E_ALREADYINPROGRESS: HRESULT = 0x8004D018u32 as HRESULT;
pub const XACT_E_ABORTED: HRESULT = 0x8004D019u32 as HRESULT;
pub const XACT_E_LOGFULL: HRESULT = 0x8004D01Au32 as HRESULT;
pub const XACT_E_TMNOTAVAILABLE: HRESULT = 0x8004D01Bu32 as HRESULT;
pub const XACT_E_CONNECTION_DOWN: HRESULT = 0x8004D01Cu32 as HRESULT;
pub const XACT_E_CONNECTION_DENIED: HRESULT = 0x8004D01Du32 as HRESULT;
pub const XACT_E_REENLISTTIMEOUT: HRESULT = 0x8004D01Eu32 as HRESULT;
pub const XACT_E_TIP_CONNECT_FAILED: HRESULT = 0x8004D01Fu32 as HRESULT;
pub const XACT_E_TIP_PROTOCOL_ERROR: HRESULT = 0x8004D020u32 as HRESULT;
pub const XACT_E_TIP_PULL_FAILED: HRESULT = 0x8004D021u32 as HRESULT;
pub const XACT_E_DEST_TMNOTAVAILABLE: HRESULT = 0x8004D022u32 as HRESULT;
pub const XACT_E_TIP_DISABLED: HRESULT = 0x8004D023u32 as HRESULT;
pub const XACT_E_NETWORK_TX_DISABLED: HRESULT = 0x8004D024u32 as HRESULT;
pub const XACT_E_PARTNER_NETWORK_TX_DISABLED: HRESULT = 0x8004D025u32 as HRESULT;
pub const XACT_E_XA_TX_DISABLED: HRESULT = 0x8004D026u32 as HRESULT;
pub const XACT_E_UNABLE_TO_READ_DTC_CONFIG: HRESULT = 0x8004D027u32 as HRESULT;
pub const XACT_E_UNABLE_TO_LOAD_DTC_PROXY: HRESULT = 0x8004D028u32 as HRESULT;
pub const XACT_E_ABORTING: HRESULT = 0x8004D029u32 as HRESULT;
pub const XACT_E_PUSH_COMM_FAILURE: HRESULT = 0x8004D02Au32 as HRESULT;
pub const XACT_E_PULL_COMM_FAILURE: HRESULT = 0x8004D02Bu32 as HRESULT;
pub const XACT_E_LU_TX_DISABLED: HRESULT = 0x8004D02Cu32 as HRESULT;
pub const XACT_E_CLERKNOTFOUND: HRESULT = 0x8004D080u32 as HRESULT;
pub const XACT_E_CLERKEXISTS: HRESULT = 0x8004D081u32 as HRESULT;
pub const XACT_E_RECOVERYINPROGRESS: HRESULT = 0x8004D082u32 as HRESULT;
pub const XACT_E_TRANSACTIONCLOSED: HRESULT = 0x8004D083u32 as HRESULT;
pub const XACT_E_INVALIDLSN: HRESULT = 0x8004D084u32 as HRESULT;
pub const XACT_E_REPLAYREQUEST: HRESULT = 0x8004D085u32 as HRESULT;
pub const XACT_S_ASYNC: HRESULT = 0x0004D000;
pub const XACT_S_DEFECT: HRESULT = 0x0004D001;
pub const XACT_S_READONLY: HRESULT = 0x0004D002;
pub const XACT_S_SOMENORETAIN: HRESULT = 0x0004D003;
pub const XACT_S_OKINFORM: HRESULT = 0x0004D004;
pub const XACT_S_MADECHANGESCONTENT: HRESULT = 0x0004D005;
pub const XACT_S_MADECHANGESINFORM: HRESULT = 0x0004D006;
pub const XACT_S_ALLNORETAIN: HRESULT = 0x0004D007;
pub const XACT_S_ABORTING: HRESULT = 0x0004D008;
pub const XACT_S_SINGLEPHASE: HRESULT = 0x0004D009;
pub const XACT_S_LOCALLY_OK: HRESULT = 0x0004D00A;
pub const XACT_S_LASTRESOURCEMANAGER: HRESULT = 0x0004D010;
pub const CONTEXT_E_FIRST: HRESULT = 0x8004E000u32 as HRESULT;
pub const CONTEXT_E_LAST: HRESULT = 0x8004E02Fu32 as HRESULT;
pub const CONTEXT_S_FIRST: HRESULT = 0x0004E000;
pub const CONTEXT_S_LAST: HRESULT = 0x0004E02F;
pub const CONTEXT_E_ABORTED: HRESULT = 0x8004E002u32 as HRESULT;
pub const CONTEXT_E_ABORTING: HRESULT = 0x8004E003u32 as HRESULT;
pub const CONTEXT_E_NOCONTEXT: HRESULT = 0x8004E004u32 as HRESULT;
pub const CONTEXT_E_WOULD_DEADLOCK: HRESULT = 0x8004E005u32 as HRESULT;
pub const CONTEXT_E_SYNCH_TIMEOUT: HRESULT = 0x8004E006u32 as HRESULT;
pub const CONTEXT_E_OLDREF: HRESULT = 0x8004E007u32 as HRESULT;
pub const CONTEXT_E_ROLENOTFOUND: HRESULT = 0x8004E00Cu32 as HRESULT;
pub const CONTEXT_E_TMNOTAVAILABLE: HRESULT = 0x8004E00Fu32 as HRESULT;
pub const CO_E_ACTIVATIONFAILED: HRESULT = 0x8004E021u32 as HRESULT;
pub const CO_E_ACTIVATIONFAILED_EVENTLOGGED: HRESULT = 0x8004E022u32 as HRESULT;
pub const CO_E_ACTIVATIONFAILED_CATALOGERROR: HRESULT = 0x8004E023u32 as HRESULT;
pub const CO_E_ACTIVATIONFAILED_TIMEOUT: HRESULT = 0x8004E024u32 as HRESULT;
pub const CO_E_INITIALIZATIONFAILED: HRESULT = 0x8004E025u32 as HRESULT;
pub const CONTEXT_E_NOJIT: HRESULT = 0x8004E026u32 as HRESULT;
pub const CONTEXT_E_NOTRANSACTION: HRESULT = 0x8004E027u32 as HRESULT;
pub const CO_E_THREADINGMODEL_CHANGED: HRESULT = 0x8004E028u32 as HRESULT;
pub const CO_E_NOIISINTRINSICS: HRESULT = 0x8004E029u32 as HRESULT;
pub const CO_E_NOCOOKIES: HRESULT = 0x8004E02Au32 as HRESULT;
pub const CO_E_DBERROR: HRESULT = 0x8004E02Bu32 as HRESULT;
pub const CO_E_NOTPOOLED: HRESULT = 0x8004E02Cu32 as HRESULT;
pub const CO_E_NOTCONSTRUCTED: HRESULT = 0x8004E02Du32 as HRESULT;
pub const CO_E_NOSYNCHRONIZATION: HRESULT = 0x8004E02Eu32 as HRESULT;
pub const CO_E_ISOLEVELMISMATCH: HRESULT = 0x8004E02Fu32 as HRESULT;
pub const CO_E_CALL_OUT_OF_TX_SCOPE_NOT_ALLOWED: HRESULT = 0x8004E030u32 as HRESULT;
pub const CO_E_EXIT_TRANSACTION_SCOPE_NOT_CALLED: HRESULT = 0x8004E031u32 as HRESULT;
pub const OLE_S_USEREG: HRESULT = 0x00040000;
pub const OLE_S_STATIC: HRESULT = 0x00040001;
pub const OLE_S_MAC_CLIPFORMAT: HRESULT = 0x00040002;
pub const DRAGDROP_S_DROP: HRESULT = 0x00040100;
pub const DRAGDROP_S_CANCEL: HRESULT = 0x00040101;
pub const DRAGDROP_S_USEDEFAULTCURSORS: HRESULT = 0x00040102;
pub const DATA_S_SAMEFORMATETC: HRESULT = 0x00040130;
pub const VIEW_S_ALREADY_FROZEN: HRESULT = 0x00040140;
pub const CACHE_S_FORMATETC_NOTSUPPORTED: HRESULT = 0x00040170;
pub const CACHE_S_SAMECACHE: HRESULT = 0x00040171;
pub const CACHE_S_SOMECACHES_NOTUPDATED: HRESULT = 0x00040172;
pub const OLEOBJ_S_INVALIDVERB: HRESULT = 0x00040180;
pub const OLEOBJ_S_CANNOT_DOVERB_NOW: HRESULT = 0x00040181;
pub const OLEOBJ_S_INVALIDHWND: HRESULT = 0x00040182;
pub const INPLACE_S_TRUNCATED: HRESULT = 0x000401A0;
pub const CONVERT10_S_NO_PRESENTATION: HRESULT = 0x000401C0;
pub const MK_S_REDUCED_TO_SELF: HRESULT = 0x000401E2;
pub const MK_S_ME: HRESULT = 0x000401E4;
pub const MK_S_HIM: HRESULT = 0x000401E5;
pub const MK_S_US: HRESULT = 0x000401E6;
pub const MK_S_MONIKERALREADYREGISTERED: HRESULT = 0x000401E7;
pub const SCHED_S_TASK_READY: HRESULT = 0x00041300;
pub const SCHED_S_TASK_RUNNING: HRESULT = 0x00041301;
pub const SCHED_S_TASK_DISABLED: HRESULT = 0x00041302;
pub const SCHED_S_TASK_HAS_NOT_RUN: HRESULT = 0x00041303;
pub const SCHED_S_TASK_NO_MORE_RUNS: HRESULT = 0x00041304;
pub const SCHED_S_TASK_NOT_SCHEDULED: HRESULT = 0x00041305;
pub const SCHED_S_TASK_TERMINATED: HRESULT = 0x00041306;
pub const SCHED_S_TASK_NO_VALID_TRIGGERS: HRESULT = 0x00041307;
pub const SCHED_S_EVENT_TRIGGER: HRESULT = 0x00041308;
pub const SCHED_E_TRIGGER_NOT_FOUND: HRESULT = 0x80041309u32 as HRESULT;
pub const SCHED_E_TASK_NOT_READY: HRESULT = 0x8004130Au32 as HRESULT;
pub const SCHED_E_TASK_NOT_RUNNING: HRESULT = 0x8004130Bu32 as HRESULT;
pub const SCHED_E_SERVICE_NOT_INSTALLED: HRESULT = 0x8004130Cu32 as HRESULT;
pub const SCHED_E_CANNOT_OPEN_TASK: HRESULT = 0x8004130Du32 as HRESULT;
pub const SCHED_E_INVALID_TASK: HRESULT = 0x8004130Eu32 as HRESULT;
pub const SCHED_E_ACCOUNT_INFORMATION_NOT_SET: HRESULT = 0x8004130Fu32 as HRESULT;
pub const SCHED_E_ACCOUNT_NAME_NOT_FOUND: HRESULT = 0x80041310u32 as HRESULT;
pub const SCHED_E_ACCOUNT_DBASE_CORRUPT: HRESULT = 0x80041311u32 as HRESULT;
pub const SCHED_E_NO_SECURITY_SERVICES: HRESULT = 0x80041312u32 as HRESULT;
pub const SCHED_E_UNKNOWN_OBJECT_VERSION: HRESULT = 0x80041313u32 as HRESULT;
pub const SCHED_E_UNSUPPORTED_ACCOUNT_OPTION: HRESULT = 0x80041314u32 as HRESULT;
pub const SCHED_E_SERVICE_NOT_RUNNING: HRESULT = 0x80041315u32 as HRESULT;
pub const SCHED_E_UNEXPECTEDNODE: HRESULT = 0x80041316u32 as HRESULT;
pub const SCHED_E_NAMESPACE: HRESULT = 0x80041317u32 as HRESULT;
pub const SCHED_E_INVALIDVALUE: HRESULT = 0x80041318u32 as HRESULT;
pub const SCHED_E_MISSINGNODE: HRESULT = 0x80041319u32 as HRESULT;
pub const SCHED_E_MALFORMEDXML: HRESULT = 0x8004131Au32 as HRESULT;
pub const SCHED_S_SOME_TRIGGERS_FAILED: HRESULT = 0x0004131B;
pub const SCHED_S_BATCH_LOGON_PROBLEM: HRESULT = 0x0004131C;
pub const SCHED_E_TOO_MANY_NODES: HRESULT = 0x8004131Du32 as HRESULT;
pub const SCHED_E_PAST_END_BOUNDARY: HRESULT = 0x8004131Eu32 as HRESULT;
pub const SCHED_E_ALREADY_RUNNING: HRESULT = 0x8004131Fu32 as HRESULT;
pub const SCHED_E_USER_NOT_LOGGED_ON: HRESULT = 0x80041320u32 as HRESULT;
pub const SCHED_E_INVALID_TASK_HASH: HRESULT = 0x80041321u32 as HRESULT;
pub const SCHED_E_SERVICE_NOT_AVAILABLE: HRESULT = 0x80041322u32 as HRESULT;
pub const SCHED_E_SERVICE_TOO_BUSY: HRESULT = 0x80041323u32 as HRESULT;
pub const SCHED_E_TASK_ATTEMPTED: HRESULT = 0x80041324u32 as HRESULT;
pub const SCHED_S_TASK_QUEUED: HRESULT = 0x00041325;
pub const SCHED_E_TASK_DISABLED: HRESULT = 0x80041326u32 as HRESULT;
pub const SCHED_E_TASK_NOT_V1_COMPAT: HRESULT = 0x80041327u32 as HRESULT;
pub const SCHED_E_START_ON_DEMAND: HRESULT = 0x80041328u32 as HRESULT;
pub const SCHED_E_TASK_NOT_UBPM_COMPAT: HRESULT = 0x80041329u32 as HRESULT;
pub const SCHED_E_DEPRECATED_FEATURE_USED: HRESULT = 0x80041330u32 as HRESULT;
pub const CO_E_CLASS_CREATE_FAILED: HRESULT = 0x80080001u32 as HRESULT;
pub const CO_E_SCM_ERROR: HRESULT = 0x80080002u32 as HRESULT;
pub const CO_E_SCM_RPC_FAILURE: HRESULT = 0x80080003u32 as HRESULT;
pub const CO_E_BAD_PATH: HRESULT = 0x80080004u32 as HRESULT;
pub const CO_E_SERVER_EXEC_FAILURE: HRESULT = 0x80080005u32 as HRESULT;
pub const CO_E_OBJSRV_RPC_FAILURE: HRESULT = 0x80080006u32 as HRESULT;
pub const MK_E_NO_NORMALIZED: HRESULT = 0x80080007u32 as HRESULT;
pub const CO_E_SERVER_STOPPING: HRESULT = 0x80080008u32 as HRESULT;
pub const MEM_E_INVALID_ROOT: HRESULT = 0x80080009u32 as HRESULT;
pub const MEM_E_INVALID_LINK: HRESULT = 0x80080010u32 as HRESULT;
pub const MEM_E_INVALID_SIZE: HRESULT = 0x80080011u32 as HRESULT;
pub const CO_S_NOTALLINTERFACES: HRESULT = 0x00080012;
pub const CO_S_MACHINENAMENOTFOUND: HRESULT = 0x00080013;
pub const CO_E_MISSING_DISPLAYNAME: HRESULT = 0x80080015u32 as HRESULT;
pub const CO_E_RUNAS_VALUE_MUST_BE_AAA: HRESULT = 0x80080016u32 as HRESULT;
pub const CO_E_ELEVATION_DISABLED: HRESULT = 0x80080017u32 as HRESULT;
pub const APPX_E_PACKAGING_INTERNAL: HRESULT = 0x80080200u32 as HRESULT;
pub const APPX_E_INTERLEAVING_NOT_ALLOWED: HRESULT = 0x80080201u32 as HRESULT;
pub const APPX_E_RELATIONSHIPS_NOT_ALLOWED: HRESULT = 0x80080202u32 as HRESULT;
pub const APPX_E_MISSING_REQUIRED_FILE: HRESULT = 0x80080203u32 as HRESULT;
pub const APPX_E_INVALID_MANIFEST: HRESULT = 0x80080204u32 as HRESULT;
pub const APPX_E_INVALID_BLOCKMAP: HRESULT = 0x80080205u32 as HRESULT;
pub const APPX_E_CORRUPT_CONTENT: HRESULT = 0x80080206u32 as HRESULT;
pub const APPX_E_BLOCK_HASH_INVALID: HRESULT = 0x80080207u32 as HRESULT;
pub const APPX_E_REQUESTED_RANGE_TOO_LARGE: HRESULT = 0x80080208u32 as HRESULT;
pub const APPX_E_INVALID_SIP_CLIENT_DATA: HRESULT = 0x80080209u32 as HRESULT;
pub const BT_E_SPURIOUS_ACTIVATION: HRESULT = 0x80080300u32 as HRESULT;
pub const DISP_E_UNKNOWNINTERFACE: HRESULT = 0x80020001u32 as HRESULT;
pub const DISP_E_MEMBERNOTFOUND: HRESULT = 0x80020003u32 as HRESULT;
pub const DISP_E_PARAMNOTFOUND: HRESULT = 0x80020004u32 as HRESULT;
pub const DISP_E_TYPEMISMATCH: HRESULT = 0x80020005u32 as HRESULT;
pub const DISP_E_UNKNOWNNAME: HRESULT = 0x80020006u32 as HRESULT;
pub const DISP_E_NONAMEDARGS: HRESULT = 0x80020007u32 as HRESULT;
pub const DISP_E_BADVARTYPE: HRESULT = 0x80020008u32 as HRESULT;
pub const DISP_E_EXCEPTION: HRESULT = 0x80020009u32 as HRESULT;
pub const DISP_E_OVERFLOW: HRESULT = 0x8002000Au32 as HRESULT;
pub const DISP_E_BADINDEX: HRESULT = 0x8002000Bu32 as HRESULT;
pub const DISP_E_UNKNOWNLCID: HRESULT = 0x8002000Cu32 as HRESULT;
pub const DISP_E_ARRAYISLOCKED: HRESULT = 0x8002000Du32 as HRESULT;
pub const DISP_E_BADPARAMCOUNT: HRESULT = 0x8002000Eu32 as HRESULT;
pub const DISP_E_PARAMNOTOPTIONAL: HRESULT = 0x8002000Fu32 as HRESULT;
pub const DISP_E_BADCALLEE: HRESULT = 0x80020010u32 as HRESULT;
pub const DISP_E_NOTACOLLECTION: HRESULT = 0x80020011u32 as HRESULT;
pub const DISP_E_DIVBYZERO: HRESULT = 0x80020012u32 as HRESULT;
pub const DISP_E_BUFFERTOOSMALL: HRESULT = 0x80020013u32 as HRESULT;
pub const TYPE_E_BUFFERTOOSMALL: HRESULT = 0x80028016u32 as HRESULT;
pub const TYPE_E_FIELDNOTFOUND: HRESULT = 0x80028017u32 as HRESULT;
pub const TYPE_E_INVDATAREAD: HRESULT = 0x80028018u32 as HRESULT;
pub const TYPE_E_UNSUPFORMAT: HRESULT = 0x80028019u32 as HRESULT;
pub const TYPE_E_REGISTRYACCESS: HRESULT = 0x8002801Cu32 as HRESULT;
pub const TYPE_E_LIBNOTREGISTERED: HRESULT = 0x8002801Du32 as HRESULT;
pub const TYPE_E_UNDEFINEDTYPE: HRESULT = 0x80028027u32 as HRESULT;
pub const TYPE_E_QUALIFIEDNAMEDISALLOWED: HRESULT = 0x80028028u32 as HRESULT;
pub const TYPE_E_INVALIDSTATE: HRESULT = 0x80028029u32 as HRESULT;
pub const TYPE_E_WRONGTYPEKIND: HRESULT = 0x8002802Au32 as HRESULT;
pub const TYPE_E_ELEMENTNOTFOUND: HRESULT = 0x8002802Bu32 as HRESULT;
pub const TYPE_E_AMBIGUOUSNAME: HRESULT = 0x8002802Cu32 as HRESULT;
pub const TYPE_E_NAMECONFLICT: HRESULT = 0x8002802Du32 as HRESULT;
pub const TYPE_E_UNKNOWNLCID: HRESULT = 0x8002802Eu32 as HRESULT;
pub const TYPE_E_DLLFUNCTIONNOTFOUND: HRESULT = 0x8002802Fu32 as HRESULT;
pub const TYPE_E_BADMODULEKIND: HRESULT = 0x800288BDu32 as HRESULT;
pub const TYPE_E_SIZETOOBIG: HRESULT = 0x800288C5u32 as HRESULT;
pub const TYPE_E_DUPLICATEID: HRESULT = 0x800288C6u32 as HRESULT;
pub const TYPE_E_INVALIDID: HRESULT = 0x800288CFu32 as HRESULT;
pub const TYPE_E_TYPEMISMATCH: HRESULT = 0x80028CA0u32 as HRESULT;
pub const TYPE_E_OUTOFBOUNDS: HRESULT = 0x80028CA1u32 as HRESULT;
pub const TYPE_E_IOERROR: HRESULT = 0x80028CA2u32 as HRESULT;
pub const TYPE_E_CANTCREATETMPFILE: HRESULT = 0x80028CA3u32 as HRESULT;
pub const TYPE_E_CANTLOADLIBRARY: HRESULT = 0x80029C4Au32 as HRESULT;
pub const TYPE_E_INCONSISTENTPROPFUNCS: HRESULT = 0x80029C83u32 as HRESULT;
pub const TYPE_E_CIRCULARTYPE: HRESULT = 0x80029C84u32 as HRESULT;
pub const STG_E_INVALIDFUNCTION: HRESULT = 0x80030001u32 as HRESULT;
pub const STG_E_FILENOTFOUND: HRESULT = 0x80030002u32 as HRESULT;
pub const STG_E_PATHNOTFOUND: HRESULT = 0x80030003u32 as HRESULT;
pub const STG_E_TOOMANYOPENFILES: HRESULT = 0x80030004u32 as HRESULT;
pub const STG_E_ACCESSDENIED: HRESULT = 0x80030005u32 as HRESULT;
pub const STG_E_INVALIDHANDLE: HRESULT = 0x80030006u32 as HRESULT;
pub const STG_E_INSUFFICIENTMEMORY: HRESULT = 0x80030008u32 as HRESULT;
pub const STG_E_INVALIDPOINTER: HRESULT = 0x80030009u32 as HRESULT;
pub const STG_E_NOMOREFILES: HRESULT = 0x80030012u32 as HRESULT;
pub const STG_E_DISKISWRITEPROTECTED: HRESULT = 0x80030013u32 as HRESULT;
pub const STG_E_SEEKERROR: HRESULT = 0x80030019u32 as HRESULT;
pub const STG_E_WRITEFAULT: HRESULT = 0x8003001Du32 as HRESULT;
pub const STG_E_READFAULT: HRESULT = 0x8003001Eu32 as HRESULT;
pub const STG_E_SHAREVIOLATION: HRESULT = 0x80030020u32 as HRESULT;
pub const STG_E_LOCKVIOLATION: HRESULT = 0x80030021u32 as HRESULT;
pub const STG_E_FILEALREADYEXISTS: HRESULT = 0x80030050u32 as HRESULT;
pub const STG_E_INVALIDPARAMETER: HRESULT = 0x80030057u32 as HRESULT;
pub const STG_E_MEDIUMFULL: HRESULT = 0x80030070u32 as HRESULT;
pub const STG_E_PROPSETMISMATCHED: HRESULT = 0x800300F0u32 as HRESULT;
pub const STG_E_ABNORMALAPIEXIT: HRESULT = 0x800300FAu32 as HRESULT;
pub const STG_E_INVALIDHEADER: HRESULT = 0x800300FBu32 as HRESULT;
pub const STG_E_INVALIDNAME: HRESULT = 0x800300FCu32 as HRESULT;
pub const STG_E_UNKNOWN: HRESULT = 0x800300FDu32 as HRESULT;
pub const STG_E_UNIMPLEMENTEDFUNCTION: HRESULT = 0x800300FEu32 as HRESULT;
pub const STG_E_INVALIDFLAG: HRESULT = 0x800300FFu32 as HRESULT;
pub const STG_E_INUSE: HRESULT = 0x80030100u32 as HRESULT;
pub const STG_E_NOTCURRENT: HRESULT = 0x80030101u32 as HRESULT;
pub const STG_E_REVERTED: HRESULT = 0x80030102u32 as HRESULT;
pub const STG_E_CANTSAVE: HRESULT = 0x80030103u32 as HRESULT;
pub const STG_E_OLDFORMAT: HRESULT = 0x80030104u32 as HRESULT;
pub const STG_E_OLDDLL: HRESULT = 0x80030105u32 as HRESULT;
pub const STG_E_SHAREREQUIRED: HRESULT = 0x80030106u32 as HRESULT;
pub const STG_E_NOTFILEBASEDSTORAGE: HRESULT = 0x80030107u32 as HRESULT;
pub const STG_E_EXTANTMARSHALLINGS: HRESULT = 0x80030108u32 as HRESULT;
pub const STG_E_DOCFILECORRUPT: HRESULT = 0x80030109u32 as HRESULT;
pub const STG_E_BADBASEADDRESS: HRESULT = 0x80030110u32 as HRESULT;
pub const STG_E_DOCFILETOOLARGE: HRESULT = 0x80030111u32 as HRESULT;
pub const STG_E_NOTSIMPLEFORMAT: HRESULT = 0x80030112u32 as HRESULT;
pub const STG_E_INCOMPLETE: HRESULT = 0x80030201u32 as HRESULT;
pub const STG_E_TERMINATED: HRESULT = 0x80030202u32 as HRESULT;
pub const STG_S_CONVERTED: HRESULT = 0x00030200;
pub const STG_S_BLOCK: HRESULT = 0x00030201;
pub const STG_S_RETRYNOW: HRESULT = 0x00030202;
pub const STG_S_MONITORING: HRESULT = 0x00030203;
pub const STG_S_MULTIPLEOPENS: HRESULT = 0x00030204;
pub const STG_S_CONSOLIDATIONFAILED: HRESULT = 0x00030205;
pub const STG_S_CANNOTCONSOLIDATE: HRESULT = 0x00030206;
pub const STG_E_STATUS_COPY_PROTECTION_FAILURE: HRESULT = 0x80030305u32 as HRESULT;
pub const STG_E_CSS_AUTHENTICATION_FAILURE: HRESULT = 0x80030306u32 as HRESULT;
pub const STG_E_CSS_KEY_NOT_PRESENT: HRESULT = 0x80030307u32 as HRESULT;
pub const STG_E_CSS_KEY_NOT_ESTABLISHED: HRESULT = 0x80030308u32 as HRESULT;
pub const STG_E_CSS_SCRAMBLED_SECTOR: HRESULT = 0x80030309u32 as HRESULT;
pub const STG_E_CSS_REGION_MISMATCH: HRESULT = 0x8003030Au32 as HRESULT;
pub const STG_E_RESETS_EXHAUSTED: HRESULT = 0x8003030Bu32 as HRESULT;
pub const RPC_E_CALL_REJECTED: HRESULT = 0x80010001u32 as HRESULT;
pub const RPC_E_CALL_CANCELED: HRESULT = 0x80010002u32 as HRESULT;
pub const RPC_E_CANTPOST_INSENDCALL: HRESULT = 0x80010003u32 as HRESULT;
pub const RPC_E_CANTCALLOUT_INASYNCCALL: HRESULT = 0x80010004u32 as HRESULT;
pub const RPC_E_CANTCALLOUT_INEXTERNALCALL: HRESULT = 0x80010005u32 as HRESULT;
pub const RPC_E_CONNECTION_TERMINATED: HRESULT = 0x80010006u32 as HRESULT;
pub const RPC_E_SERVER_DIED: HRESULT = 0x80010007u32 as HRESULT;
pub const RPC_E_CLIENT_DIED: HRESULT = 0x80010008u32 as HRESULT;
pub const RPC_E_INVALID_DATAPACKET: HRESULT = 0x80010009u32 as HRESULT;
pub const RPC_E_CANTTRANSMIT_CALL: HRESULT = 0x8001000Au32 as HRESULT;
pub const RPC_E_CLIENT_CANTMARSHAL_DATA: HRESULT = 0x8001000Bu32 as HRESULT;
pub const RPC_E_CLIENT_CANTUNMARSHAL_DATA: HRESULT = 0x8001000Cu32 as HRESULT;
pub const RPC_E_SERVER_CANTMARSHAL_DATA: HRESULT = 0x8001000Du32 as HRESULT;
pub const RPC_E_SERVER_CANTUNMARSHAL_DATA: HRESULT = 0x8001000Eu32 as HRESULT;
pub const RPC_E_INVALID_DATA: HRESULT = 0x8001000Fu32 as HRESULT;
pub const RPC_E_INVALID_PARAMETER: HRESULT = 0x80010010u32 as HRESULT;
pub const RPC_E_CANTCALLOUT_AGAIN: HRESULT = 0x80010011u32 as HRESULT;
pub const RPC_E_SERVER_DIED_DNE: HRESULT = 0x80010012u32 as HRESULT;
pub const RPC_E_SYS_CALL_FAILED: HRESULT = 0x80010100u32 as HRESULT;
pub const RPC_E_OUT_OF_RESOURCES: HRESULT = 0x80010101u32 as HRESULT;
pub const RPC_E_ATTEMPTED_MULTITHREAD: HRESULT = 0x80010102u32 as HRESULT;
pub const RPC_E_NOT_REGISTERED: HRESULT = 0x80010103u32 as HRESULT;
pub const RPC_E_FAULT: HRESULT = 0x80010104u32 as HRESULT;
pub const RPC_E_SERVERFAULT: HRESULT = 0x80010105u32 as HRESULT;
pub const RPC_E_CHANGED_MODE: HRESULT = 0x80010106u32 as HRESULT;
pub const RPC_E_INVALIDMETHOD: HRESULT = 0x80010107u32 as HRESULT;
pub const RPC_E_DISCONNECTED: HRESULT = 0x80010108u32 as HRESULT;
pub const RPC_E_RETRY: HRESULT = 0x80010109u32 as HRESULT;
pub const RPC_E_SERVERCALL_RETRYLATER: HRESULT = 0x8001010Au32 as HRESULT;
pub const RPC_E_SERVERCALL_REJECTED: HRESULT = 0x8001010Bu32 as HRESULT;
pub const RPC_E_INVALID_CALLDATA: HRESULT = 0x8001010Cu32 as HRESULT;
pub const RPC_E_CANTCALLOUT_ININPUTSYNCCALL: HRESULT = 0x8001010Du32 as HRESULT;
pub const RPC_E_WRONG_THREAD: HRESULT = 0x8001010Eu32 as HRESULT;
pub const RPC_E_THREAD_NOT_INIT: HRESULT = 0x8001010Fu32 as HRESULT;
pub const RPC_E_VERSION_MISMATCH: HRESULT = 0x80010110u32 as HRESULT;
pub const RPC_E_INVALID_HEADER: HRESULT = 0x80010111u32 as HRESULT;
pub const RPC_E_INVALID_EXTENSION: HRESULT = 0x80010112u32 as HRESULT;
pub const RPC_E_INVALID_IPID: HRESULT = 0x80010113u32 as HRESULT;
pub const RPC_E_INVALID_OBJECT: HRESULT = 0x80010114u32 as HRESULT;
pub const RPC_S_CALLPENDING: HRESULT = 0x80010115u32 as HRESULT;
pub const RPC_S_WAITONTIMER: HRESULT = 0x80010116u32 as HRESULT;
pub const RPC_E_CALL_COMPLETE: HRESULT = 0x80010117u32 as HRESULT;
pub const RPC_E_UNSECURE_CALL: HRESULT = 0x80010118u32 as HRESULT;
pub const RPC_E_TOO_LATE: HRESULT = 0x80010119u32 as HRESULT;
pub const RPC_E_NO_GOOD_SECURITY_PACKAGES: HRESULT = 0x8001011Au32 as HRESULT;
pub const RPC_E_ACCESS_DENIED: HRESULT = 0x8001011Bu32 as HRESULT;
pub const RPC_E_REMOTE_DISABLED: HRESULT = 0x8001011Cu32 as HRESULT;
pub const RPC_E_INVALID_OBJREF: HRESULT = 0x8001011Du32 as HRESULT;
pub const RPC_E_NO_CONTEXT: HRESULT = 0x8001011Eu32 as HRESULT;
pub const RPC_E_TIMEOUT: HRESULT = 0x8001011Fu32 as HRESULT;
pub const RPC_E_NO_SYNC: HRESULT = 0x80010120u32 as HRESULT;
pub const RPC_E_FULLSIC_REQUIRED: HRESULT = 0x80010121u32 as HRESULT;
pub const RPC_E_INVALID_STD_NAME: HRESULT = 0x80010122u32 as HRESULT;
pub const CO_E_FAILEDTOIMPERSONATE: HRESULT = 0x80010123u32 as HRESULT;
pub const CO_E_FAILEDTOGETSECCTX: HRESULT = 0x80010124u32 as HRESULT;
pub const CO_E_FAILEDTOOPENTHREADTOKEN: HRESULT = 0x80010125u32 as HRESULT;
pub const CO_E_FAILEDTOGETTOKENINFO: HRESULT = 0x80010126u32 as HRESULT;
pub const CO_E_TRUSTEEDOESNTMATCHCLIENT: HRESULT = 0x80010127u32 as HRESULT;
pub const CO_E_FAILEDTOQUERYCLIENTBLANKET: HRESULT = 0x80010128u32 as HRESULT;
pub const CO_E_FAILEDTOSETDACL: HRESULT = 0x80010129u32 as HRESULT;
pub const CO_E_ACCESSCHECKFAILED: HRESULT = 0x8001012Au32 as HRESULT;
pub const CO_E_NETACCESSAPIFAILED: HRESULT = 0x8001012Bu32 as HRESULT;
pub const CO_E_WRONGTRUSTEENAMESYNTAX: HRESULT = 0x8001012Cu32 as HRESULT;
pub const CO_E_INVALIDSID: HRESULT = 0x8001012Du32 as HRESULT;
pub const CO_E_CONVERSIONFAILED: HRESULT = 0x8001012Eu32 as HRESULT;
pub const CO_E_NOMATCHINGSIDFOUND: HRESULT = 0x8001012Fu32 as HRESULT;
pub const CO_E_LOOKUPACCSIDFAILED: HRESULT = 0x80010130u32 as HRESULT;
pub const CO_E_NOMATCHINGNAMEFOUND: HRESULT = 0x80010131u32 as HRESULT;
pub const CO_E_LOOKUPACCNAMEFAILED: HRESULT = 0x80010132u32 as HRESULT;
pub const CO_E_SETSERLHNDLFAILED: HRESULT = 0x80010133u32 as HRESULT;
pub const CO_E_FAILEDTOGETWINDIR: HRESULT = 0x80010134u32 as HRESULT;
pub const CO_E_PATHTOOLONG: HRESULT = 0x80010135u32 as HRESULT;
pub const CO_E_FAILEDTOGENUUID: HRESULT = 0x80010136u32 as HRESULT;
pub const CO_E_FAILEDTOCREATEFILE: HRESULT = 0x80010137u32 as HRESULT;
pub const CO_E_FAILEDTOCLOSEHANDLE: HRESULT = 0x80010138u32 as HRESULT;
pub const CO_E_EXCEEDSYSACLLIMIT: HRESULT = 0x80010139u32 as HRESULT;
pub const CO_E_ACESINWRONGORDER: HRESULT = 0x8001013Au32 as HRESULT;
pub const CO_E_INCOMPATIBLESTREAMVERSION: HRESULT = 0x8001013Bu32 as HRESULT;
pub const CO_E_FAILEDTOOPENPROCESSTOKEN: HRESULT = 0x8001013Cu32 as HRESULT;
pub const CO_E_DECODEFAILED: HRESULT = 0x8001013Du32 as HRESULT;
pub const CO_E_ACNOTINITIALIZED: HRESULT = 0x8001013Fu32 as HRESULT;
pub const CO_E_CANCEL_DISABLED: HRESULT = 0x80010140u32 as HRESULT;
pub const RPC_E_UNEXPECTED: HRESULT = 0x8001FFFFu32 as HRESULT;
pub const ERROR_AUDITING_DISABLED: HRESULT = 0xC0090001u32 as HRESULT;
pub const ERROR_ALL_SIDS_FILTERED: HRESULT = 0xC0090002u32 as HRESULT;
pub const ERROR_BIZRULES_NOT_ENABLED: HRESULT = 0xC0090003u32 as HRESULT;
pub const NTE_BAD_UID: HRESULT = 0x80090001u32 as HRESULT;
pub const NTE_BAD_HASH: HRESULT = 0x80090002u32 as HRESULT;
pub const NTE_BAD_KEY: HRESULT = 0x80090003u32 as HRESULT;
pub const NTE_BAD_LEN: HRESULT = 0x80090004u32 as HRESULT;
pub const NTE_BAD_DATA: HRESULT = 0x80090005u32 as HRESULT;
pub const NTE_BAD_SIGNATURE: HRESULT = 0x80090006u32 as HRESULT;
pub const NTE_BAD_VER: HRESULT = 0x80090007u32 as HRESULT;
pub const NTE_BAD_ALGID: HRESULT = 0x80090008u32 as HRESULT;
pub const NTE_BAD_FLAGS: HRESULT = 0x80090009u32 as HRESULT;
pub const NTE_BAD_TYPE: HRESULT = 0x8009000Au32 as HRESULT;
pub const NTE_BAD_KEY_STATE: HRESULT = 0x8009000Bu32 as HRESULT;
pub const NTE_BAD_HASH_STATE: HRESULT = 0x8009000Cu32 as HRESULT;
pub const NTE_NO_KEY: HRESULT = 0x8009000Du32 as HRESULT;
pub const NTE_NO_MEMORY: HRESULT = 0x8009000Eu32 as HRESULT;
pub const NTE_EXISTS: HRESULT = 0x8009000Fu32 as HRESULT;
pub const NTE_PERM: HRESULT = 0x80090010u32 as HRESULT;
pub const NTE_NOT_FOUND: HRESULT = 0x80090011u32 as HRESULT;
pub const NTE_DOUBLE_ENCRYPT: HRESULT = 0x80090012u32 as HRESULT;
pub const NTE_BAD_PROVIDER: HRESULT = 0x80090013u32 as HRESULT;
pub const NTE_BAD_PROV_TYPE: HRESULT = 0x80090014u32 as HRESULT;
pub const NTE_BAD_PUBLIC_KEY: HRESULT = 0x80090015u32 as HRESULT;
pub const NTE_BAD_KEYSET: HRESULT = 0x80090016u32 as HRESULT;
pub const NTE_PROV_TYPE_NOT_DEF: HRESULT = 0x80090017u32 as HRESULT;
pub const NTE_PROV_TYPE_ENTRY_BAD: HRESULT = 0x80090018u32 as HRESULT;
pub const NTE_KEYSET_NOT_DEF: HRESULT = 0x80090019u32 as HRESULT;
pub const NTE_KEYSET_ENTRY_BAD: HRESULT = 0x8009001Au32 as HRESULT;
pub const NTE_PROV_TYPE_NO_MATCH: HRESULT = 0x8009001Bu32 as HRESULT;
pub const NTE_SIGNATURE_FILE_BAD: HRESULT = 0x8009001Cu32 as HRESULT;
pub const NTE_PROVIDER_DLL_FAIL: HRESULT = 0x8009001Du32 as HRESULT;
pub const NTE_PROV_DLL_NOT_FOUND: HRESULT = 0x8009001Eu32 as HRESULT;
pub const NTE_BAD_KEYSET_PARAM: HRESULT = 0x8009001Fu32 as HRESULT;
pub const NTE_FAIL: HRESULT = 0x80090020u32 as HRESULT;
pub const NTE_SYS_ERR: HRESULT = 0x80090021u32 as HRESULT;
pub const NTE_SILENT_CONTEXT: HRESULT = 0x80090022u32 as HRESULT;
pub const NTE_TOKEN_KEYSET_STORAGE_FULL: HRESULT = 0x80090023u32 as HRESULT;
pub const NTE_TEMPORARY_PROFILE: HRESULT = 0x80090024u32 as HRESULT;
pub const NTE_FIXEDPARAMETER: HRESULT = 0x80090025u32 as HRESULT;
pub const NTE_INVALID_HANDLE: HRESULT = 0x80090026u32 as HRESULT;
pub const NTE_INVALID_PARAMETER: HRESULT = 0x80090027u32 as HRESULT;
pub const NTE_BUFFER_TOO_SMALL: HRESULT = 0x80090028u32 as HRESULT;
pub const NTE_NOT_SUPPORTED: HRESULT = 0x80090029u32 as HRESULT;
pub const NTE_NO_MORE_ITEMS: HRESULT = 0x8009002Au32 as HRESULT;
pub const NTE_BUFFERS_OVERLAP: HRESULT = 0x8009002Bu32 as HRESULT;
pub const NTE_DECRYPTION_FAILURE: HRESULT = 0x8009002Cu32 as HRESULT;
pub const NTE_INTERNAL_ERROR: HRESULT = 0x8009002Du32 as HRESULT;
pub const NTE_UI_REQUIRED: HRESULT = 0x8009002Eu32 as HRESULT;
pub const NTE_HMAC_NOT_SUPPORTED: HRESULT = 0x8009002Fu32 as HRESULT;
pub const NTE_DEVICE_NOT_READY: HRESULT = 0x80090030u32 as HRESULT;
pub const NTE_AUTHENTICATION_IGNORED: HRESULT = 0x80090031u32 as HRESULT;
pub const NTE_VALIDATION_FAILED: HRESULT = 0x80090032u32 as HRESULT;
pub const NTE_INCORRECT_PASSWORD: HRESULT = 0x80090033u32 as HRESULT;
pub const NTE_ENCRYPTION_FAILURE: HRESULT = 0x80090034u32 as HRESULT;
pub const NTE_DEVICE_NOT_FOUND: HRESULT = 0x80090035u32 as HRESULT;
pub const SEC_E_INSUFFICIENT_MEMORY: HRESULT = 0x80090300u32 as HRESULT;
pub const SEC_E_INVALID_HANDLE: HRESULT = 0x80090301u32 as HRESULT;
pub const SEC_E_UNSUPPORTED_FUNCTION: HRESULT = 0x80090302u32 as HRESULT;
pub const SEC_E_TARGET_UNKNOWN: HRESULT = 0x80090303u32 as HRESULT;
pub const SEC_E_INTERNAL_ERROR: HRESULT = 0x80090304u32 as HRESULT;
pub const SEC_E_SECPKG_NOT_FOUND: HRESULT = 0x80090305u32 as HRESULT;
pub const SEC_E_NOT_OWNER: HRESULT = 0x80090306u32 as HRESULT;
pub const SEC_E_CANNOT_INSTALL: HRESULT = 0x80090307u32 as HRESULT;
pub const SEC_E_INVALID_TOKEN: HRESULT = 0x80090308u32 as HRESULT;
pub const SEC_E_CANNOT_PACK: HRESULT = 0x80090309u32 as HRESULT;
pub const SEC_E_QOP_NOT_SUPPORTED: HRESULT = 0x8009030Au32 as HRESULT;
pub const SEC_E_NO_IMPERSONATION: HRESULT = 0x8009030Bu32 as HRESULT;
pub const SEC_E_LOGON_DENIED: HRESULT = 0x8009030Cu32 as HRESULT;
pub const SEC_E_UNKNOWN_CREDENTIALS: HRESULT = 0x8009030Du32 as HRESULT;
pub const SEC_E_NO_CREDENTIALS: HRESULT = 0x8009030Eu32 as HRESULT;
pub const SEC_E_MESSAGE_ALTERED: HRESULT = 0x8009030Fu32 as HRESULT;
pub const SEC_E_OUT_OF_SEQUENCE: HRESULT = 0x80090310u32 as HRESULT;
pub const SEC_E_NO_AUTHENTICATING_AUTHORITY: HRESULT = 0x80090311u32 as HRESULT;
pub const SEC_I_CONTINUE_NEEDED: HRESULT = 0x00090312;
pub const SEC_I_COMPLETE_NEEDED: HRESULT = 0x00090313;
pub const SEC_I_COMPLETE_AND_CONTINUE: HRESULT = 0x00090314;
pub const SEC_I_LOCAL_LOGON: HRESULT = 0x00090315;
pub const SEC_E_BAD_PKGID: HRESULT = 0x80090316u32 as HRESULT;
pub const SEC_E_CONTEXT_EXPIRED: HRESULT = 0x80090317u32 as HRESULT;
pub const SEC_I_CONTEXT_EXPIRED: HRESULT = 0x00090317;
pub const SEC_E_INCOMPLETE_MESSAGE: HRESULT = 0x80090318u32 as HRESULT;
pub const SEC_E_INCOMPLETE_CREDENTIALS: HRESULT = 0x80090320u32 as HRESULT;
pub const SEC_E_BUFFER_TOO_SMALL: HRESULT = 0x80090321u32 as HRESULT;
pub const SEC_I_INCOMPLETE_CREDENTIALS: HRESULT = 0x00090320;
pub const SEC_I_RENEGOTIATE: HRESULT = 0x00090321;
pub const SEC_E_WRONG_PRINCIPAL: HRESULT = 0x80090322u32 as HRESULT;
pub const SEC_I_NO_LSA_CONTEXT: HRESULT = 0x00090323;
pub const SEC_E_TIME_SKEW: HRESULT = 0x80090324u32 as HRESULT;
pub const SEC_E_UNTRUSTED_ROOT: HRESULT = 0x80090325u32 as HRESULT;
pub const SEC_E_ILLEGAL_MESSAGE: HRESULT = 0x80090326u32 as HRESULT;
pub const SEC_E_CERT_UNKNOWN: HRESULT = 0x80090327u32 as HRESULT;
pub const SEC_E_CERT_EXPIRED: HRESULT = 0x80090328u32 as HRESULT;
pub const SEC_E_ENCRYPT_FAILURE: HRESULT = 0x80090329u32 as HRESULT;
pub const SEC_E_DECRYPT_FAILURE: HRESULT = 0x80090330u32 as HRESULT;
pub const SEC_E_ALGORITHM_MISMATCH: HRESULT = 0x80090331u32 as HRESULT;
pub const SEC_E_SECURITY_QOS_FAILED: HRESULT = 0x80090332u32 as HRESULT;
pub const SEC_E_UNFINISHED_CONTEXT_DELETED: HRESULT = 0x80090333u32 as HRESULT;
pub const SEC_E_NO_TGT_REPLY: HRESULT = 0x80090334u32 as HRESULT;
pub const SEC_E_NO_IP_ADDRESSES: HRESULT = 0x80090335u32 as HRESULT;
pub const SEC_E_WRONG_CREDENTIAL_HANDLE: HRESULT = 0x80090336u32 as HRESULT;
pub const SEC_E_CRYPTO_SYSTEM_INVALID: HRESULT = 0x80090337u32 as HRESULT;
pub const SEC_E_MAX_REFERRALS_EXCEEDED: HRESULT = 0x80090338u32 as HRESULT;
pub const SEC_E_MUST_BE_KDC: HRESULT = 0x80090339u32 as HRESULT;
pub const SEC_E_STRONG_CRYPTO_NOT_SUPPORTED: HRESULT = 0x8009033Au32 as HRESULT;
pub const SEC_E_TOO_MANY_PRINCIPALS: HRESULT = 0x8009033Bu32 as HRESULT;
pub const SEC_E_NO_PA_DATA: HRESULT = 0x8009033Cu32 as HRESULT;
pub const SEC_E_PKINIT_NAME_MISMATCH: HRESULT = 0x8009033Du32 as HRESULT;
pub const SEC_E_SMARTCARD_LOGON_REQUIRED: HRESULT = 0x8009033Eu32 as HRESULT;
pub const SEC_E_SHUTDOWN_IN_PROGRESS: HRESULT = 0x8009033Fu32 as HRESULT;
pub const SEC_E_KDC_INVALID_REQUEST: HRESULT = 0x80090340u32 as HRESULT;
pub const SEC_E_KDC_UNABLE_TO_REFER: HRESULT = 0x80090341u32 as HRESULT;
pub const SEC_E_KDC_UNKNOWN_ETYPE: HRESULT = 0x80090342u32 as HRESULT;
pub const SEC_E_UNSUPPORTED_PREAUTH: HRESULT = 0x80090343u32 as HRESULT;
pub const SEC_E_DELEGATION_REQUIRED: HRESULT = 0x80090345u32 as HRESULT;
pub const SEC_E_BAD_BINDINGS: HRESULT = 0x80090346u32 as HRESULT;
pub const SEC_E_MULTIPLE_ACCOUNTS: HRESULT = 0x80090347u32 as HRESULT;
pub const SEC_E_NO_KERB_KEY: HRESULT = 0x80090348u32 as HRESULT;
pub const SEC_E_CERT_WRONG_USAGE: HRESULT = 0x80090349u32 as HRESULT;
pub const SEC_E_DOWNGRADE_DETECTED: HRESULT = 0x80090350u32 as HRESULT;
pub const SEC_E_SMARTCARD_CERT_REVOKED: HRESULT = 0x80090351u32 as HRESULT;
pub const SEC_E_ISSUING_CA_UNTRUSTED: HRESULT = 0x80090352u32 as HRESULT;
pub const SEC_E_REVOCATION_OFFLINE_C: HRESULT = 0x80090353u32 as HRESULT;
pub const SEC_E_PKINIT_CLIENT_FAILURE: HRESULT = 0x80090354u32 as HRESULT;
pub const SEC_E_SMARTCARD_CERT_EXPIRED: HRESULT = 0x80090355u32 as HRESULT;
pub const SEC_E_NO_S4U_PROT_SUPPORT: HRESULT = 0x80090356u32 as HRESULT;
pub const SEC_E_CROSSREALM_DELEGATION_FAILURE: HRESULT = 0x80090357u32 as HRESULT;
pub const SEC_E_REVOCATION_OFFLINE_KDC: HRESULT = 0x80090358u32 as HRESULT;
pub const SEC_E_ISSUING_CA_UNTRUSTED_KDC: HRESULT = 0x80090359u32 as HRESULT;
pub const SEC_E_KDC_CERT_EXPIRED: HRESULT = 0x8009035Au32 as HRESULT;
pub const SEC_E_KDC_CERT_REVOKED: HRESULT = 0x8009035Bu32 as HRESULT;
pub const SEC_I_SIGNATURE_NEEDED: HRESULT = 0x0009035C;
pub const SEC_E_INVALID_PARAMETER: HRESULT = 0x8009035Du32 as HRESULT;
pub const SEC_E_DELEGATION_POLICY: HRESULT = 0x8009035Eu32 as HRESULT;
pub const SEC_E_POLICY_NLTM_ONLY: HRESULT = 0x8009035Fu32 as HRESULT;
pub const SEC_I_NO_RENEGOTIATION: HRESULT = 0x00090360;
pub const SEC_E_NO_CONTEXT: HRESULT = 0x80090361u32 as HRESULT;
pub const SEC_E_PKU2U_CERT_FAILURE: HRESULT = 0x80090362u32 as HRESULT;
pub const SEC_E_MUTUAL_AUTH_FAILED: HRESULT = 0x80090363u32 as HRESULT;
pub const SEC_I_MESSAGE_FRAGMENT: HRESULT = 0x00090364;
pub const SEC_E_ONLY_HTTPS_ALLOWED: HRESULT = 0x80090365u32 as HRESULT;
pub const SEC_I_CONTINUE_NEEDED_MESSAGE_OK: HRESULT = 0x00090366;
pub const SEC_E_APPLICATION_PROTOCOL_MISMATCH: HRESULT = 0x80090367u32 as HRESULT;
pub const SEC_E_NO_SPM: HRESULT = SEC_E_INTERNAL_ERROR;
pub const SEC_E_NOT_SUPPORTED: HRESULT = SEC_E_UNSUPPORTED_FUNCTION;
pub const CRYPT_E_MSG_ERROR: HRESULT = 0x80091001u32 as HRESULT;
pub const CRYPT_E_UNKNOWN_ALGO: HRESULT = 0x80091002u32 as HRESULT;
pub const CRYPT_E_OID_FORMAT: HRESULT = 0x80091003u32 as HRESULT;
pub const CRYPT_E_INVALID_MSG_TYPE: HRESULT = 0x80091004u32 as HRESULT;
pub const CRYPT_E_UNEXPECTED_ENCODING: HRESULT = 0x80091005u32 as HRESULT;
pub const CRYPT_E_AUTH_ATTR_MISSING: HRESULT = 0x80091006u32 as HRESULT;
pub const CRYPT_E_HASH_VALUE: HRESULT = 0x80091007u32 as HRESULT;
pub const CRYPT_E_INVALID_INDEX: HRESULT = 0x80091008u32 as HRESULT;
pub const CRYPT_E_ALREADY_DECRYPTED: HRESULT = 0x80091009u32 as HRESULT;
pub const CRYPT_E_NOT_DECRYPTED: HRESULT = 0x8009100Au32 as HRESULT;
pub const CRYPT_E_RECIPIENT_NOT_FOUND: HRESULT = 0x8009100Bu32 as HRESULT;
pub const CRYPT_E_CONTROL_TYPE: HRESULT = 0x8009100Cu32 as HRESULT;
pub const CRYPT_E_ISSUER_SERIALNUMBER: HRESULT = 0x8009100Du32 as HRESULT;
pub const CRYPT_E_SIGNER_NOT_FOUND: HRESULT = 0x8009100Eu32 as HRESULT;
pub const CRYPT_E_ATTRIBUTES_MISSING: HRESULT = 0x8009100Fu32 as HRESULT;
pub const CRYPT_E_STREAM_MSG_NOT_READY: HRESULT = 0x80091010u32 as HRESULT;
pub const CRYPT_E_STREAM_INSUFFICIENT_DATA: HRESULT = 0x80091011u32 as HRESULT;
pub const CRYPT_I_NEW_PROTECTION_REQUIRED: HRESULT = 0x00091012;
pub const CRYPT_E_BAD_LEN: HRESULT = 0x80092001u32 as HRESULT;
pub const CRYPT_E_BAD_ENCODE: HRESULT = 0x80092002u32 as HRESULT;
pub const CRYPT_E_FILE_ERROR: HRESULT = 0x80092003u32 as HRESULT;
pub const CRYPT_E_NOT_FOUND: HRESULT = 0x80092004u32 as HRESULT;
pub const CRYPT_E_EXISTS: HRESULT = 0x80092005u32 as HRESULT;
pub const CRYPT_E_NO_PROVIDER: HRESULT = 0x80092006u32 as HRESULT;
pub const CRYPT_E_SELF_SIGNED: HRESULT = 0x80092007u32 as HRESULT;
pub const CRYPT_E_DELETED_PREV: HRESULT = 0x80092008u32 as HRESULT;
pub const CRYPT_E_NO_MATCH: HRESULT = 0x80092009u32 as HRESULT;
pub const CRYPT_E_UNEXPECTED_MSG_TYPE: HRESULT = 0x8009200Au32 as HRESULT;
pub const CRYPT_E_NO_KEY_PROPERTY: HRESULT = 0x8009200Bu32 as HRESULT;
pub const CRYPT_E_NO_DECRYPT_CERT: HRESULT = 0x8009200Cu32 as HRESULT;
pub const CRYPT_E_BAD_MSG: HRESULT = 0x8009200Du32 as HRESULT;
pub const CRYPT_E_NO_SIGNER: HRESULT = 0x8009200Eu32 as HRESULT;
pub const CRYPT_E_PENDING_CLOSE: HRESULT = 0x8009200Fu32 as HRESULT;
pub const CRYPT_E_REVOKED: HRESULT = 0x80092010u32 as HRESULT;
pub const CRYPT_E_NO_REVOCATION_DLL: HRESULT = 0x80092011u32 as HRESULT;
pub const CRYPT_E_NO_REVOCATION_CHECK: HRESULT = 0x80092012u32 as HRESULT;
pub const CRYPT_E_REVOCATION_OFFLINE: HRESULT = 0x80092013u32 as HRESULT;
pub const CRYPT_E_NOT_IN_REVOCATION_DATABASE: HRESULT = 0x80092014u32 as HRESULT;
pub const CRYPT_E_INVALID_NUMERIC_STRING: HRESULT = 0x80092020u32 as HRESULT;
pub const CRYPT_E_INVALID_PRINTABLE_STRING: HRESULT = 0x80092021u32 as HRESULT;
pub const CRYPT_E_INVALID_IA5_STRING: HRESULT = 0x80092022u32 as HRESULT;
pub const CRYPT_E_INVALID_X500_STRING: HRESULT = 0x80092023u32 as HRESULT;
pub const CRYPT_E_NOT_CHAR_STRING: HRESULT = 0x80092024u32 as HRESULT;
pub const CRYPT_E_FILERESIZED: HRESULT = 0x80092025u32 as HRESULT;
pub const CRYPT_E_SECURITY_SETTINGS: HRESULT = 0x80092026u32 as HRESULT;
pub const CRYPT_E_NO_VERIFY_USAGE_DLL: HRESULT = 0x80092027u32 as HRESULT;
pub const CRYPT_E_NO_VERIFY_USAGE_CHECK: HRESULT = 0x80092028u32 as HRESULT;
pub const CRYPT_E_VERIFY_USAGE_OFFLINE: HRESULT = 0x80092029u32 as HRESULT;
pub const CRYPT_E_NOT_IN_CTL: HRESULT = 0x8009202Au32 as HRESULT;
pub const CRYPT_E_NO_TRUSTED_SIGNER: HRESULT = 0x8009202Bu32 as HRESULT;
pub const CRYPT_E_MISSING_PUBKEY_PARA: HRESULT = 0x8009202Cu32 as HRESULT;
pub const CRYPT_E_OBJECT_LOCATOR_OBJECT_NOT_FOUND: HRESULT = 0x8009202Du32 as HRESULT;
pub const CRYPT_E_OSS_ERROR: HRESULT = 0x80093000u32 as HRESULT;
pub const OSS_MORE_BUF: HRESULT = 0x80093001u32 as HRESULT;
pub const OSS_NEGATIVE_UINTEGER: HRESULT = 0x80093002u32 as HRESULT;
pub const OSS_PDU_RANGE: HRESULT = 0x80093003u32 as HRESULT;
pub const OSS_MORE_INPUT: HRESULT = 0x80093004u32 as HRESULT;
pub const OSS_DATA_ERROR: HRESULT = 0x80093005u32 as HRESULT;
pub const OSS_BAD_ARG: HRESULT = 0x80093006u32 as HRESULT;
pub const OSS_BAD_VERSION: HRESULT = 0x80093007u32 as HRESULT;
pub const OSS_OUT_MEMORY: HRESULT = 0x80093008u32 as HRESULT;
pub const OSS_PDU_MISMATCH: HRESULT = 0x80093009u32 as HRESULT;
pub const OSS_LIMITED: HRESULT = 0x8009300Au32 as HRESULT;
pub const OSS_BAD_PTR: HRESULT = 0x8009300Bu32 as HRESULT;
pub const OSS_BAD_TIME: HRESULT = 0x8009300Cu32 as HRESULT;
pub const OSS_INDEFINITE_NOT_SUPPORTED: HRESULT = 0x8009300Du32 as HRESULT;
pub const OSS_MEM_ERROR: HRESULT = 0x8009300Eu32 as HRESULT;
pub const OSS_BAD_TABLE: HRESULT = 0x8009300Fu32 as HRESULT;
pub const OSS_TOO_LONG: HRESULT = 0x80093010u32 as HRESULT;
pub const OSS_CONSTRAINT_VIOLATED: HRESULT = 0x80093011u32 as HRESULT;
pub const OSS_FATAL_ERROR: HRESULT = 0x80093012u32 as HRESULT;
pub const OSS_ACCESS_SERIALIZATION_ERROR: HRESULT = 0x80093013u32 as HRESULT;
pub const OSS_NULL_TBL: HRESULT = 0x80093014u32 as HRESULT;
pub const OSS_NULL_FCN: HRESULT = 0x80093015u32 as HRESULT;
pub const OSS_BAD_ENCRULES: HRESULT = 0x80093016u32 as HRESULT;
pub const OSS_UNAVAIL_ENCRULES: HRESULT = 0x80093017u32 as HRESULT;
pub const OSS_CANT_OPEN_TRACE_WINDOW: HRESULT = 0x80093018u32 as HRESULT;
pub const OSS_UNIMPLEMENTED: HRESULT = 0x80093019u32 as HRESULT;
pub const OSS_OID_DLL_NOT_LINKED: HRESULT = 0x8009301Au32 as HRESULT;
pub const OSS_CANT_OPEN_TRACE_FILE: HRESULT = 0x8009301Bu32 as HRESULT;
pub const OSS_TRACE_FILE_ALREADY_OPEN: HRESULT = 0x8009301Cu32 as HRESULT;
pub const OSS_TABLE_MISMATCH: HRESULT = 0x8009301Du32 as HRESULT;
pub const OSS_TYPE_NOT_SUPPORTED: HRESULT = 0x8009301Eu32 as HRESULT;
pub const OSS_REAL_DLL_NOT_LINKED: HRESULT = 0x8009301Fu32 as HRESULT;
pub const OSS_REAL_CODE_NOT_LINKED: HRESULT = 0x80093020u32 as HRESULT;
pub const OSS_OUT_OF_RANGE: HRESULT = 0x80093021u32 as HRESULT;
pub const OSS_COPIER_DLL_NOT_LINKED: HRESULT = 0x80093022u32 as HRESULT;
pub const OSS_CONSTRAINT_DLL_NOT_LINKED: HRESULT = 0x80093023u32 as HRESULT;
pub const OSS_COMPARATOR_DLL_NOT_LINKED: HRESULT = 0x80093024u32 as HRESULT;
pub const OSS_COMPARATOR_CODE_NOT_LINKED: HRESULT = 0x80093025u32 as HRESULT;
pub const OSS_MEM_MGR_DLL_NOT_LINKED: HRESULT = 0x80093026u32 as HRESULT;
pub const OSS_PDV_DLL_NOT_LINKED: HRESULT = 0x80093027u32 as HRESULT;
pub const OSS_PDV_CODE_NOT_LINKED: HRESULT = 0x80093028u32 as HRESULT;
pub const OSS_API_DLL_NOT_LINKED: HRESULT = 0x80093029u32 as HRESULT;
pub const OSS_BERDER_DLL_NOT_LINKED: HRESULT = 0x8009302Au32 as HRESULT;
pub const OSS_PER_DLL_NOT_LINKED: HRESULT = 0x8009302Bu32 as HRESULT;
pub const OSS_OPEN_TYPE_ERROR: HRESULT = 0x8009302Cu32 as HRESULT;
pub const OSS_MUTEX_NOT_CREATED: HRESULT = 0x8009302Du32 as HRESULT;
pub const OSS_CANT_CLOSE_TRACE_FILE: HRESULT = 0x8009302Eu32 as HRESULT;
pub const CRYPT_E_ASN1_ERROR: HRESULT = 0x80093100u32 as HRESULT;
pub const CRYPT_E_ASN1_INTERNAL: HRESULT = 0x80093101u32 as HRESULT;
pub const CRYPT_E_ASN1_EOD: HRESULT = 0x80093102u32 as HRESULT;
pub const CRYPT_E_ASN1_CORRUPT: HRESULT = 0x80093103u32 as HRESULT;
pub const CRYPT_E_ASN1_LARGE: HRESULT = 0x80093104u32 as HRESULT;
pub const CRYPT_E_ASN1_CONSTRAINT: HRESULT = 0x80093105u32 as HRESULT;
pub const CRYPT_E_ASN1_MEMORY: HRESULT = 0x80093106u32 as HRESULT;
pub const CRYPT_E_ASN1_OVERFLOW: HRESULT = 0x80093107u32 as HRESULT;
pub const CRYPT_E_ASN1_BADPDU: HRESULT = 0x80093108u32 as HRESULT;
pub const CRYPT_E_ASN1_BADARGS: HRESULT = 0x80093109u32 as HRESULT;
pub const CRYPT_E_ASN1_BADREAL: HRESULT = 0x8009310Au32 as HRESULT;
pub const CRYPT_E_ASN1_BADTAG: HRESULT = 0x8009310Bu32 as HRESULT;
pub const CRYPT_E_ASN1_CHOICE: HRESULT = 0x8009310Cu32 as HRESULT;
pub const CRYPT_E_ASN1_RULE: HRESULT = 0x8009310Du32 as HRESULT;
pub const CRYPT_E_ASN1_UTF8: HRESULT = 0x8009310Eu32 as HRESULT;
pub const CRYPT_E_ASN1_PDU_TYPE: HRESULT = 0x80093133u32 as HRESULT;
pub const CRYPT_E_ASN1_NYI: HRESULT = 0x80093134u32 as HRESULT;
pub const CRYPT_E_ASN1_EXTENDED: HRESULT = 0x80093201u32 as HRESULT;
pub const CRYPT_E_ASN1_NOEOD: HRESULT = 0x80093202u32 as HRESULT;
pub const CERTSRV_E_BAD_REQUESTSUBJECT: HRESULT = 0x80094001u32 as HRESULT;
pub const CERTSRV_E_NO_REQUEST: HRESULT = 0x80094002u32 as HRESULT;
pub const CERTSRV_E_BAD_REQUESTSTATUS: HRESULT = 0x80094003u32 as HRESULT;
pub const CERTSRV_E_PROPERTY_EMPTY: HRESULT = 0x80094004u32 as HRESULT;
pub const CERTSRV_E_INVALID_CA_CERTIFICATE: HRESULT = 0x80094005u32 as HRESULT;
pub const CERTSRV_E_SERVER_SUSPENDED: HRESULT = 0x80094006u32 as HRESULT;
pub const CERTSRV_E_ENCODING_LENGTH: HRESULT = 0x80094007u32 as HRESULT;
pub const CERTSRV_E_ROLECONFLICT: HRESULT = 0x80094008u32 as HRESULT;
pub const CERTSRV_E_RESTRICTEDOFFICER: HRESULT = 0x80094009u32 as HRESULT;
pub const CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED: HRESULT = 0x8009400Au32 as HRESULT;
pub const CERTSRV_E_NO_VALID_KRA: HRESULT = 0x8009400Bu32 as HRESULT;
pub const CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL: HRESULT = 0x8009400Cu32 as HRESULT;
pub const CERTSRV_E_NO_CAADMIN_DEFINED: HRESULT = 0x8009400Du32 as HRESULT;
pub const CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE: HRESULT = 0x8009400Eu32 as HRESULT;
pub const CERTSRV_E_NO_DB_SESSIONS: HRESULT = 0x8009400Fu32 as HRESULT;
pub const CERTSRV_E_ALIGNMENT_FAULT: HRESULT = 0x80094010u32 as HRESULT;
pub const CERTSRV_E_ENROLL_DENIED: HRESULT = 0x80094011u32 as HRESULT;
pub const CERTSRV_E_TEMPLATE_DENIED: HRESULT = 0x80094012u32 as HRESULT;
pub const CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE: HRESULT = 0x80094013u32 as HRESULT;
pub const CERTSRV_E_ADMIN_DENIED_REQUEST: HRESULT = 0x80094014u32 as HRESULT;
pub const CERTSRV_E_NO_POLICY_SERVER: HRESULT = 0x80094015u32 as HRESULT;
pub const CERTSRV_E_WEAK_SIGNATURE_OR_KEY: HRESULT = 0x80094016u32 as HRESULT;
pub const CERTSRV_E_KEY_ATTESTATION_NOT_SUPPORTED: HRESULT = 0x80094017u32 as HRESULT;
pub const CERTSRV_E_ENCRYPTION_CERT_REQUIRED: HRESULT = 0x80094018u32 as HRESULT;
pub const CERTSRV_E_UNSUPPORTED_CERT_TYPE: HRESULT = 0x80094800u32 as HRESULT;
pub const CERTSRV_E_NO_CERT_TYPE: HRESULT = 0x80094801u32 as HRESULT;
pub const CERTSRV_E_TEMPLATE_CONFLICT: HRESULT = 0x80094802u32 as HRESULT;
pub const CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED: HRESULT = 0x80094803u32 as HRESULT;
pub const CERTSRV_E_ARCHIVED_KEY_REQUIRED: HRESULT = 0x80094804u32 as HRESULT;
pub const CERTSRV_E_SMIME_REQUIRED: HRESULT = 0x80094805u32 as HRESULT;
pub const CERTSRV_E_BAD_RENEWAL_SUBJECT: HRESULT = 0x80094806u32 as HRESULT;
pub const CERTSRV_E_BAD_TEMPLATE_VERSION: HRESULT = 0x80094807u32 as HRESULT;
pub const CERTSRV_E_TEMPLATE_POLICY_REQUIRED: HRESULT = 0x80094808u32 as HRESULT;
pub const CERTSRV_E_SIGNATURE_POLICY_REQUIRED: HRESULT = 0x80094809u32 as HRESULT;
pub const CERTSRV_E_SIGNATURE_COUNT: HRESULT = 0x8009480Au32 as HRESULT;
pub const CERTSRV_E_SIGNATURE_REJECTED: HRESULT = 0x8009480Bu32 as HRESULT;
pub const CERTSRV_E_ISSUANCE_POLICY_REQUIRED: HRESULT = 0x8009480Cu32 as HRESULT;
pub const CERTSRV_E_SUBJECT_UPN_REQUIRED: HRESULT = 0x8009480Du32 as HRESULT;
pub const CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED: HRESULT = 0x8009480Eu32 as HRESULT;
pub const CERTSRV_E_SUBJECT_DNS_REQUIRED: HRESULT = 0x8009480Fu32 as HRESULT;
pub const CERTSRV_E_ARCHIVED_KEY_UNEXPECTED: HRESULT = 0x80094810u32 as HRESULT;
pub const CERTSRV_E_KEY_LENGTH: HRESULT = 0x80094811u32 as HRESULT;
pub const CERTSRV_E_SUBJECT_EMAIL_REQUIRED: HRESULT = 0x80094812u32 as HRESULT;
pub const CERTSRV_E_UNKNOWN_CERT_TYPE: HRESULT = 0x80094813u32 as HRESULT;
pub const CERTSRV_E_CERT_TYPE_OVERLAP: HRESULT = 0x80094814u32 as HRESULT;
pub const CERTSRV_E_TOO_MANY_SIGNATURES: HRESULT = 0x80094815u32 as HRESULT;
pub const CERTSRV_E_RENEWAL_BAD_PUBLIC_KEY: HRESULT = 0x80094816u32 as HRESULT;
pub const CERTSRV_E_INVALID_EK: HRESULT = 0x80094817u32 as HRESULT;
pub const CERTSRV_E_INVALID_IDBINDING: HRESULT = 0x80094818u32 as HRESULT;
pub const CERTSRV_E_INVALID_ATTESTATION: HRESULT = 0x80094819u32 as HRESULT;
pub const CERTSRV_E_KEY_ATTESTATION: HRESULT = 0x8009481Au32 as HRESULT;
pub const CERTSRV_E_CORRUPT_KEY_ATTESTATION: HRESULT = 0x8009481Bu32 as HRESULT;
pub const CERTSRV_E_EXPIRED_CHALLENGE: HRESULT = 0x8009481Cu32 as HRESULT;
pub const CERTSRV_E_INVALID_RESPONSE: HRESULT = 0x8009481Du32 as HRESULT;
pub const CERTSRV_E_INVALID_REQUESTID: HRESULT = 0x8009481Eu32 as HRESULT;
pub const XENROLL_E_KEY_NOT_EXPORTABLE: HRESULT = 0x80095000u32 as HRESULT;
pub const XENROLL_E_CANNOT_ADD_ROOT_CERT: HRESULT = 0x80095001u32 as HRESULT;
pub const XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND: HRESULT = 0x80095002u32 as HRESULT;
pub const XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH: HRESULT = 0x80095003u32 as HRESULT;
pub const XENROLL_E_RESPONSE_KA_HASH_MISMATCH: HRESULT = 0x80095004u32 as HRESULT;
pub const XENROLL_E_KEYSPEC_SMIME_MISMATCH: HRESULT = 0x80095005u32 as HRESULT;
pub const TRUST_E_SYSTEM_ERROR: HRESULT = 0x80096001u32 as HRESULT;
pub const TRUST_E_NO_SIGNER_CERT: HRESULT = 0x80096002u32 as HRESULT;
pub const TRUST_E_COUNTER_SIGNER: HRESULT = 0x80096003u32 as HRESULT;
pub const TRUST_E_CERT_SIGNATURE: HRESULT = 0x80096004u32 as HRESULT;
pub const TRUST_E_TIME_STAMP: HRESULT = 0x80096005u32 as HRESULT;
pub const TRUST_E_BAD_DIGEST: HRESULT = 0x80096010u32 as HRESULT;
pub const TRUST_E_BASIC_CONSTRAINTS: HRESULT = 0x80096019u32 as HRESULT;
pub const TRUST_E_FINANCIAL_CRITERIA: HRESULT = 0x8009601Eu32 as HRESULT;
pub const MSSIPOTF_E_OUTOFMEMRANGE: HRESULT = 0x80097001u32 as HRESULT;
pub const MSSIPOTF_E_CANTGETOBJECT: HRESULT = 0x80097002u32 as HRESULT;
pub const MSSIPOTF_E_NOHEADTABLE: HRESULT = 0x80097003u32 as HRESULT;
pub const MSSIPOTF_E_BAD_MAGICNUMBER: HRESULT = 0x80097004u32 as HRESULT;
pub const MSSIPOTF_E_BAD_OFFSET_TABLE: HRESULT = 0x80097005u32 as HRESULT;
pub const MSSIPOTF_E_TABLE_TAGORDER: HRESULT = 0x80097006u32 as HRESULT;
pub const MSSIPOTF_E_TABLE_LONGWORD: HRESULT = 0x80097007u32 as HRESULT;
pub const MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT: HRESULT = 0x80097008u32 as HRESULT;
pub const MSSIPOTF_E_TABLES_OVERLAP: HRESULT = 0x80097009u32 as HRESULT;
pub const MSSIPOTF_E_TABLE_PADBYTES: HRESULT = 0x8009700Au32 as HRESULT;
pub const MSSIPOTF_E_FILETOOSMALL: HRESULT = 0x8009700Bu32 as HRESULT;
pub const MSSIPOTF_E_TABLE_CHECKSUM: HRESULT = 0x8009700Cu32 as HRESULT;
pub const MSSIPOTF_E_FILE_CHECKSUM: HRESULT = 0x8009700Du32 as HRESULT;
pub const MSSIPOTF_E_FAILED_POLICY: HRESULT = 0x80097010u32 as HRESULT;
pub const MSSIPOTF_E_FAILED_HINTS_CHECK: HRESULT = 0x80097011u32 as HRESULT;
pub const MSSIPOTF_E_NOT_OPENTYPE: HRESULT = 0x80097012u32 as HRESULT;
pub const MSSIPOTF_E_FILE: HRESULT = 0x80097013u32 as HRESULT;
pub const MSSIPOTF_E_CRYPT: HRESULT = 0x80097014u32 as HRESULT;
pub const MSSIPOTF_E_BADVERSION: HRESULT = 0x80097015u32 as HRESULT;
pub const MSSIPOTF_E_DSIG_STRUCTURE: HRESULT = 0x80097016u32 as HRESULT;
pub const MSSIPOTF_E_PCONST_CHECK: HRESULT = 0x80097017u32 as HRESULT;
pub const MSSIPOTF_E_STRUCTURE: HRESULT = 0x80097018u32 as HRESULT;
pub const ERROR_CRED_REQUIRES_CONFIRMATION: HRESULT = 0x80097019u32 as HRESULT;
pub const NTE_OP_OK: HRESULT = 0;
pub const TRUST_E_PROVIDER_UNKNOWN: HRESULT = 0x800B0001u32 as HRESULT;
pub const TRUST_E_ACTION_UNKNOWN: HRESULT = 0x800B0002u32 as HRESULT;
pub const TRUST_E_SUBJECT_FORM_UNKNOWN: HRESULT = 0x800B0003u32 as HRESULT;
pub const TRUST_E_SUBJECT_NOT_TRUSTED: HRESULT = 0x800B0004u32 as HRESULT;
pub const DIGSIG_E_ENCODE: HRESULT = 0x800B0005u32 as HRESULT;
pub const DIGSIG_E_DECODE: HRESULT = 0x800B0006u32 as HRESULT;
pub const DIGSIG_E_EXTENSIBILITY: HRESULT = 0x800B0007u32 as HRESULT;
pub const DIGSIG_E_CRYPTO: HRESULT = 0x800B0008u32 as HRESULT;
pub const PERSIST_E_SIZEDEFINITE: HRESULT = 0x800B0009u32 as HRESULT;
pub const PERSIST_E_SIZEINDEFINITE: HRESULT = 0x800B000Au32 as HRESULT;
pub const PERSIST_E_NOTSELFSIZING: HRESULT = 0x800B000Bu32 as HRESULT;
pub const TRUST_E_NOSIGNATURE: HRESULT = 0x800B0100u32 as HRESULT;
pub const CERT_E_EXPIRED: HRESULT = 0x800B0101u32 as HRESULT;
pub const CERT_E_VALIDITYPERIODNESTING: HRESULT = 0x800B0102u32 as HRESULT;
pub const CERT_E_ROLE: HRESULT = 0x800B0103u32 as HRESULT;
pub const CERT_E_PATHLENCONST: HRESULT = 0x800B0104u32 as HRESULT;
pub const CERT_E_CRITICAL: HRESULT = 0x800B0105u32 as HRESULT;
pub const CERT_E_PURPOSE: HRESULT = 0x800B0106u32 as HRESULT;
pub const CERT_E_ISSUERCHAINING: HRESULT = 0x800B0107u32 as HRESULT;
pub const CERT_E_MALFORMED: HRESULT = 0x800B0108u32 as HRESULT;
pub const CERT_E_UNTRUSTEDROOT: HRESULT = 0x800B0109u32 as HRESULT;
pub const CERT_E_CHAINING: HRESULT = 0x800B010Au32 as HRESULT;
pub const TRUST_E_FAIL: HRESULT = 0x800B010Bu32 as HRESULT;
pub const CERT_E_REVOKED: HRESULT = 0x800B010Cu32 as HRESULT;
pub const CERT_E_UNTRUSTEDTESTROOT: HRESULT = 0x800B010Du32 as HRESULT;
pub const CERT_E_REVOCATION_FAILURE: HRESULT = 0x800B010Eu32 as HRESULT;
pub const CERT_E_CN_NO_MATCH: HRESULT = 0x800B010Fu32 as HRESULT;
pub const CERT_E_WRONG_USAGE: HRESULT = 0x800B0110u32 as HRESULT;
pub const TRUST_E_EXPLICIT_DISTRUST: HRESULT = 0x800B0111u32 as HRESULT;
pub const CERT_E_UNTRUSTEDCA: HRESULT = 0x800B0112u32 as HRESULT;
pub const CERT_E_INVALID_POLICY: HRESULT = 0x800B0113u32 as HRESULT;
pub const CERT_E_INVALID_NAME: HRESULT = 0x800B0114u32 as HRESULT;
pub const SPAPI_E_EXPECTED_SECTION_NAME: HRESULT = 0x800F0000u32 as HRESULT;
pub const SPAPI_E_BAD_SECTION_NAME_LINE: HRESULT = 0x800F0001u32 as HRESULT;
pub const SPAPI_E_SECTION_NAME_TOO_LONG: HRESULT = 0x800F0002u32 as HRESULT;
pub const SPAPI_E_GENERAL_SYNTAX: HRESULT = 0x800F0003u32 as HRESULT;
pub const SPAPI_E_WRONG_INF_STYLE: HRESULT = 0x800F0100u32 as HRESULT;
pub const SPAPI_E_SECTION_NOT_FOUND: HRESULT = 0x800F0101u32 as HRESULT;
pub const SPAPI_E_LINE_NOT_FOUND: HRESULT = 0x800F0102u32 as HRESULT;
pub const SPAPI_E_NO_BACKUP: HRESULT = 0x800F0103u32 as HRESULT;
pub const SPAPI_E_NO_ASSOCIATED_CLASS: HRESULT = 0x800F0200u32 as HRESULT;
pub const SPAPI_E_CLASS_MISMATCH: HRESULT = 0x800F0201u32 as HRESULT;
pub const SPAPI_E_DUPLICATE_FOUND: HRESULT = 0x800F0202u32 as HRESULT;
pub const SPAPI_E_NO_DRIVER_SELECTED: HRESULT = 0x800F0203u32 as HRESULT;
pub const SPAPI_E_KEY_DOES_NOT_EXIST: HRESULT = 0x800F0204u32 as HRESULT;
pub const SPAPI_E_INVALID_DEVINST_NAME: HRESULT = 0x800F0205u32 as HRESULT;
pub const SPAPI_E_INVALID_CLASS: HRESULT = 0x800F0206u32 as HRESULT;
pub const SPAPI_E_DEVINST_ALREADY_EXISTS: HRESULT = 0x800F0207u32 as HRESULT;
pub const SPAPI_E_DEVINFO_NOT_REGISTERED: HRESULT = 0x800F0208u32 as HRESULT;
pub const SPAPI_E_INVALID_REG_PROPERTY: HRESULT = 0x800F0209u32 as HRESULT;
pub const SPAPI_E_NO_INF: HRESULT = 0x800F020Au32 as HRESULT;
pub const SPAPI_E_NO_SUCH_DEVINST: HRESULT = 0x800F020Bu32 as HRESULT;
pub const SPAPI_E_CANT_LOAD_CLASS_ICON: HRESULT = 0x800F020Cu32 as HRESULT;
pub const SPAPI_E_INVALID_CLASS_INSTALLER: HRESULT = 0x800F020Du32 as HRESULT;
pub const SPAPI_E_DI_DO_DEFAULT: HRESULT = 0x800F020Eu32 as HRESULT;
pub const SPAPI_E_DI_NOFILECOPY: HRESULT = 0x800F020Fu32 as HRESULT;
pub const SPAPI_E_INVALID_HWPROFILE: HRESULT = 0x800F0210u32 as HRESULT;
pub const SPAPI_E_NO_DEVICE_SELECTED: HRESULT = 0x800F0211u32 as HRESULT;
pub const SPAPI_E_DEVINFO_LIST_LOCKED: HRESULT = 0x800F0212u32 as HRESULT;
pub const SPAPI_E_DEVINFO_DATA_LOCKED: HRESULT = 0x800F0213u32 as HRESULT;
pub const SPAPI_E_DI_BAD_PATH: HRESULT = 0x800F0214u32 as HRESULT;
pub const SPAPI_E_NO_CLASSINSTALL_PARAMS: HRESULT = 0x800F0215u32 as HRESULT;
pub const SPAPI_E_FILEQUEUE_LOCKED: HRESULT = 0x800F0216u32 as HRESULT;
pub const SPAPI_E_BAD_SERVICE_INSTALLSECT: HRESULT = 0x800F0217u32 as HRESULT;
pub const SPAPI_E_NO_CLASS_DRIVER_LIST: HRESULT = 0x800F0218u32 as HRESULT;
pub const SPAPI_E_NO_ASSOCIATED_SERVICE: HRESULT = 0x800F0219u32 as HRESULT;
pub const SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE: HRESULT = 0x800F021Au32 as HRESULT;
pub const SPAPI_E_DEVICE_INTERFACE_ACTIVE: HRESULT = 0x800F021Bu32 as HRESULT;
pub const SPAPI_E_DEVICE_INTERFACE_REMOVED: HRESULT = 0x800F021Cu32 as HRESULT;
pub const SPAPI_E_BAD_INTERFACE_INSTALLSECT: HRESULT = 0x800F021Du32 as HRESULT;
pub const SPAPI_E_NO_SUCH_INTERFACE_CLASS: HRESULT = 0x800F021Eu32 as HRESULT;
pub const SPAPI_E_INVALID_REFERENCE_STRING: HRESULT = 0x800F021Fu32 as HRESULT;
pub const SPAPI_E_INVALID_MACHINENAME: HRESULT = 0x800F0220u32 as HRESULT;
pub const SPAPI_E_REMOTE_COMM_FAILURE: HRESULT = 0x800F0221u32 as HRESULT;
pub const SPAPI_E_MACHINE_UNAVAILABLE: HRESULT = 0x800F0222u32 as HRESULT;
pub const SPAPI_E_NO_CONFIGMGR_SERVICES: HRESULT = 0x800F0223u32 as HRESULT;
pub const SPAPI_E_INVALID_PROPPAGE_PROVIDER: HRESULT = 0x800F0224u32 as HRESULT;
pub const SPAPI_E_NO_SUCH_DEVICE_INTERFACE: HRESULT = 0x800F0225u32 as HRESULT;
pub const SPAPI_E_DI_POSTPROCESSING_REQUIRED: HRESULT = 0x800F0226u32 as HRESULT;
pub const SPAPI_E_INVALID_COINSTALLER: HRESULT = 0x800F0227u32 as HRESULT;
pub const SPAPI_E_NO_COMPAT_DRIVERS: HRESULT = 0x800F0228u32 as HRESULT;
pub const SPAPI_E_NO_DEVICE_ICON: HRESULT = 0x800F0229u32 as HRESULT;
pub const SPAPI_E_INVALID_INF_LOGCONFIG: HRESULT = 0x800F022Au32 as HRESULT;
pub const SPAPI_E_DI_DONT_INSTALL: HRESULT = 0x800F022Bu32 as HRESULT;
pub const SPAPI_E_INVALID_FILTER_DRIVER: HRESULT = 0x800F022Cu32 as HRESULT;
pub const SPAPI_E_NON_WINDOWS_NT_DRIVER: HRESULT = 0x800F022Du32 as HRESULT;
pub const SPAPI_E_NON_WINDOWS_DRIVER: HRESULT = 0x800F022Eu32 as HRESULT;
pub const SPAPI_E_NO_CATALOG_FOR_OEM_INF: HRESULT = 0x800F022Fu32 as HRESULT;
pub const SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE: HRESULT = 0x800F0230u32 as HRESULT;
pub const SPAPI_E_NOT_DISABLEABLE: HRESULT = 0x800F0231u32 as HRESULT;
pub const SPAPI_E_CANT_REMOVE_DEVINST: HRESULT = 0x800F0232u32 as HRESULT;
pub const SPAPI_E_INVALID_TARGET: HRESULT = 0x800F0233u32 as HRESULT;
pub const SPAPI_E_DRIVER_NONNATIVE: HRESULT = 0x800F0234u32 as HRESULT;
pub const SPAPI_E_IN_WOW64: HRESULT = 0x800F0235u32 as HRESULT;
pub const SPAPI_E_SET_SYSTEM_RESTORE_POINT: HRESULT = 0x800F0236u32 as HRESULT;
pub const SPAPI_E_INCORRECTLY_COPIED_INF: HRESULT = 0x800F0237u32 as HRESULT;
pub const SPAPI_E_SCE_DISABLED: HRESULT = 0x800F0238u32 as HRESULT;
pub const SPAPI_E_UNKNOWN_EXCEPTION: HRESULT = 0x800F0239u32 as HRESULT;
pub const SPAPI_E_PNP_REGISTRY_ERROR: HRESULT = 0x800F023Au32 as HRESULT;
pub const SPAPI_E_REMOTE_REQUEST_UNSUPPORTED: HRESULT = 0x800F023Bu32 as HRESULT;
pub const SPAPI_E_NOT_AN_INSTALLED_OEM_INF: HRESULT = 0x800F023Cu32 as HRESULT;
pub const SPAPI_E_INF_IN_USE_BY_DEVICES: HRESULT = 0x800F023Du32 as HRESULT;
pub const SPAPI_E_DI_FUNCTION_OBSOLETE: HRESULT = 0x800F023Eu32 as HRESULT;
pub const SPAPI_E_NO_AUTHENTICODE_CATALOG: HRESULT = 0x800F023Fu32 as HRESULT;
pub const SPAPI_E_AUTHENTICODE_DISALLOWED: HRESULT = 0x800F0240u32 as HRESULT;
pub const SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER: HRESULT = 0x800F0241u32 as HRESULT;
pub const SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED: HRESULT = 0x800F0242u32 as HRESULT;
pub const SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED: HRESULT = 0x800F0243u32 as HRESULT;
pub const SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH: HRESULT = 0x800F0244u32 as HRESULT;
pub const SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE: HRESULT = 0x800F0245u32 as HRESULT;
pub const SPAPI_E_DEVICE_INSTALLER_NOT_READY: HRESULT = 0x800F0246u32 as HRESULT;
pub const SPAPI_E_DRIVER_STORE_ADD_FAILED: HRESULT = 0x800F0247u32 as HRESULT;
pub const SPAPI_E_DEVICE_INSTALL_BLOCKED: HRESULT = 0x800F0248u32 as HRESULT;
pub const SPAPI_E_DRIVER_INSTALL_BLOCKED: HRESULT = 0x800F0249u32 as HRESULT;
pub const SPAPI_E_WRONG_INF_TYPE: HRESULT = 0x800F024Au32 as HRESULT;
pub const SPAPI_E_FILE_HASH_NOT_IN_CATALOG: HRESULT = 0x800F024Bu32 as HRESULT;
pub const SPAPI_E_DRIVER_STORE_DELETE_FAILED: HRESULT = 0x800F024Cu32 as HRESULT;
pub const SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW: HRESULT = 0x800F0300u32 as HRESULT;
pub const SPAPI_E_ERROR_NOT_INSTALLED: HRESULT = 0x800F1000u32 as HRESULT;
pub const SCARD_S_SUCCESS: HRESULT = NO_ERROR as HRESULT;
pub const SCARD_F_INTERNAL_ERROR: HRESULT = 0x80100001u32 as HRESULT;
pub const SCARD_E_CANCELLED: HRESULT = 0x80100002u32 as HRESULT;
pub const SCARD_E_INVALID_HANDLE: HRESULT = 0x80100003u32 as HRESULT;
pub const SCARD_E_INVALID_PARAMETER: HRESULT = 0x80100004u32 as HRESULT;
pub const SCARD_E_INVALID_TARGET: HRESULT = 0x80100005u32 as HRESULT;
pub const SCARD_E_NO_MEMORY: HRESULT = 0x80100006u32 as HRESULT;
pub const SCARD_F_WAITED_TOO_LONG: HRESULT = 0x80100007u32 as HRESULT;
pub const SCARD_E_INSUFFICIENT_BUFFER: HRESULT = 0x80100008u32 as HRESULT;
pub const SCARD_E_UNKNOWN_READER: HRESULT = 0x80100009u32 as HRESULT;
pub const SCARD_E_TIMEOUT: HRESULT = 0x8010000Au32 as HRESULT;
pub const SCARD_E_SHARING_VIOLATION: HRESULT = 0x8010000Bu32 as HRESULT;
pub const SCARD_E_NO_SMARTCARD: HRESULT = 0x8010000Cu32 as HRESULT;
pub const SCARD_E_UNKNOWN_CARD: HRESULT = 0x8010000Du32 as HRESULT;
pub const SCARD_E_CANT_DISPOSE: HRESULT = 0x8010000Eu32 as HRESULT;
pub const SCARD_E_PROTO_MISMATCH: HRESULT = 0x8010000Fu32 as HRESULT;
pub const SCARD_E_NOT_READY: HRESULT = 0x80100010u32 as HRESULT;
pub const SCARD_E_INVALID_VALUE: HRESULT = 0x80100011u32 as HRESULT;
pub const SCARD_E_SYSTEM_CANCELLED: HRESULT = 0x80100012u32 as HRESULT;
pub const SCARD_F_COMM_ERROR: HRESULT = 0x80100013u32 as HRESULT;
pub const SCARD_F_UNKNOWN_ERROR: HRESULT = 0x80100014u32 as HRESULT;
pub const SCARD_E_INVALID_ATR: HRESULT = 0x80100015u32 as HRESULT;
pub const SCARD_E_NOT_TRANSACTED: HRESULT = 0x80100016u32 as HRESULT;
pub const SCARD_E_READER_UNAVAILABLE: HRESULT = 0x80100017u32 as HRESULT;
pub const SCARD_P_SHUTDOWN: HRESULT = 0x80100018u32 as HRESULT;
pub const SCARD_E_PCI_TOO_SMALL: HRESULT = 0x80100019u32 as HRESULT;
pub const SCARD_E_READER_UNSUPPORTED: HRESULT = 0x8010001Au32 as HRESULT;
pub const SCARD_E_DUPLICATE_READER: HRESULT = 0x8010001Bu32 as HRESULT;
pub const SCARD_E_CARD_UNSUPPORTED: HRESULT = 0x8010001Cu32 as HRESULT;
pub const SCARD_E_NO_SERVICE: HRESULT = 0x8010001Du32 as HRESULT;
pub const SCARD_E_SERVICE_STOPPED: HRESULT = 0x8010001Eu32 as HRESULT;
pub const SCARD_E_UNEXPECTED: HRESULT = 0x8010001Fu32 as HRESULT;
pub const SCARD_E_ICC_INSTALLATION: HRESULT = 0x80100020u32 as HRESULT;
pub const SCARD_E_ICC_CREATEORDER: HRESULT = 0x80100021u32 as HRESULT;
pub const SCARD_E_UNSUPPORTED_FEATURE: HRESULT = 0x80100022u32 as HRESULT;
pub const SCARD_E_DIR_NOT_FOUND: HRESULT = 0x80100023u32 as HRESULT;
pub const SCARD_E_FILE_NOT_FOUND: HRESULT = 0x80100024u32 as HRESULT;
pub const SCARD_E_NO_DIR: HRESULT = 0x80100025u32 as HRESULT;
pub const SCARD_E_NO_FILE: HRESULT = 0x80100026u32 as HRESULT;
pub const SCARD_E_NO_ACCESS: HRESULT = 0x80100027u32 as HRESULT;
pub const SCARD_E_WRITE_TOO_MANY: HRESULT = 0x80100028u32 as HRESULT;
pub const SCARD_E_BAD_SEEK: HRESULT = 0x80100029u32 as HRESULT;
pub const SCARD_E_INVALID_CHV: HRESULT = 0x8010002Au32 as HRESULT;
pub const SCARD_E_UNKNOWN_RES_MNG: HRESULT = 0x8010002Bu32 as HRESULT;
pub const SCARD_E_NO_SUCH_CERTIFICATE: HRESULT = 0x8010002Cu32 as HRESULT;
pub const SCARD_E_CERTIFICATE_UNAVAILABLE: HRESULT = 0x8010002Du32 as HRESULT;
pub const SCARD_E_NO_READERS_AVAILABLE: HRESULT = 0x8010002Eu32 as HRESULT;
pub const SCARD_E_COMM_DATA_LOST: HRESULT = 0x8010002Fu32 as HRESULT;
pub const SCARD_E_NO_KEY_CONTAINER: HRESULT = 0x80100030u32 as HRESULT;
pub const SCARD_E_SERVER_TOO_BUSY: HRESULT = 0x80100031u32 as HRESULT;
pub const SCARD_E_PIN_CACHE_EXPIRED: HRESULT = 0x80100032u32 as HRESULT;
pub const SCARD_E_NO_PIN_CACHE: HRESULT = 0x80100033u32 as HRESULT;
pub const SCARD_E_READ_ONLY_CARD: HRESULT = 0x80100034u32 as HRESULT;
pub const SCARD_W_UNSUPPORTED_CARD: HRESULT = 0x80100065u32 as HRESULT;
pub const SCARD_W_UNRESPONSIVE_CARD: HRESULT = 0x80100066u32 as HRESULT;
pub const SCARD_W_UNPOWERED_CARD: HRESULT = 0x80100067u32 as HRESULT;
pub const SCARD_W_RESET_CARD: HRESULT = 0x80100068u32 as HRESULT;
pub const SCARD_W_REMOVED_CARD: HRESULT = 0x80100069u32 as HRESULT;
pub const SCARD_W_SECURITY_VIOLATION: HRESULT = 0x8010006Au32 as HRESULT;
pub const SCARD_W_WRONG_CHV: HRESULT = 0x8010006Bu32 as HRESULT;
pub const SCARD_W_CHV_BLOCKED: HRESULT = 0x8010006Cu32 as HRESULT;
pub const SCARD_W_EOF: HRESULT = 0x8010006Du32 as HRESULT;
pub const SCARD_W_CANCELLED_BY_USER: HRESULT = 0x8010006Eu32 as HRESULT;
pub const SCARD_W_CARD_NOT_AUTHENTICATED: HRESULT = 0x8010006Fu32 as HRESULT;
pub const SCARD_W_CACHE_ITEM_NOT_FOUND: HRESULT = 0x80100070u32 as HRESULT;
pub const SCARD_W_CACHE_ITEM_STALE: HRESULT = 0x80100071u32 as HRESULT;
pub const SCARD_W_CACHE_ITEM_TOO_BIG: HRESULT = 0x80100072u32 as HRESULT;
pub const COMADMIN_E_OBJECTERRORS: HRESULT = 0x80110401u32 as HRESULT;
pub const COMADMIN_E_OBJECTINVALID: HRESULT = 0x80110402u32 as HRESULT;
pub const COMADMIN_E_KEYMISSING: HRESULT = 0x80110403u32 as HRESULT;
pub const COMADMIN_E_ALREADYINSTALLED: HRESULT = 0x80110404u32 as HRESULT;
pub const COMADMIN_E_APP_FILE_WRITEFAIL: HRESULT = 0x80110407u32 as HRESULT;
pub const COMADMIN_E_APP_FILE_READFAIL: HRESULT = 0x80110408u32 as HRESULT;
pub const COMADMIN_E_APP_FILE_VERSION: HRESULT = 0x80110409u32 as HRESULT;
pub const COMADMIN_E_BADPATH: HRESULT = 0x8011040Au32 as HRESULT;
pub const COMADMIN_E_APPLICATIONEXISTS: HRESULT = 0x8011040Bu32 as HRESULT;
pub const COMADMIN_E_ROLEEXISTS: HRESULT = 0x8011040Cu32 as HRESULT;
pub const COMADMIN_E_CANTCOPYFILE: HRESULT = 0x8011040Du32 as HRESULT;
pub const COMADMIN_E_NOUSER: HRESULT = 0x8011040Fu32 as HRESULT;
pub const COMADMIN_E_INVALIDUSERIDS: HRESULT = 0x80110410u32 as HRESULT;
pub const COMADMIN_E_NOREGISTRYCLSID: HRESULT = 0x80110411u32 as HRESULT;
pub const COMADMIN_E_BADREGISTRYPROGID: HRESULT = 0x80110412u32 as HRESULT;
pub const COMADMIN_E_AUTHENTICATIONLEVEL: HRESULT = 0x80110413u32 as HRESULT;
pub const COMADMIN_E_USERPASSWDNOTVALID: HRESULT = 0x80110414u32 as HRESULT;
pub const COMADMIN_E_CLSIDORIIDMISMATCH: HRESULT = 0x80110418u32 as HRESULT;
pub const COMADMIN_E_REMOTEINTERFACE: HRESULT = 0x80110419u32 as HRESULT;
pub const COMADMIN_E_DLLREGISTERSERVER: HRESULT = 0x8011041Au32 as HRESULT;
pub const COMADMIN_E_NOSERVERSHARE: HRESULT = 0x8011041Bu32 as HRESULT;
pub const COMADMIN_E_DLLLOADFAILED: HRESULT = 0x8011041Du32 as HRESULT;
pub const COMADMIN_E_BADREGISTRYLIBID: HRESULT = 0x8011041Eu32 as HRESULT;
pub const COMADMIN_E_APPDIRNOTFOUND: HRESULT = 0x8011041Fu32 as HRESULT;
pub const COMADMIN_E_REGISTRARFAILED: HRESULT = 0x80110423u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_DOESNOTEXIST: HRESULT = 0x80110424u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_LOADDLLFAIL: HRESULT = 0x80110425u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_GETCLASSOBJ: HRESULT = 0x80110426u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_CLASSNOTAVAIL: HRESULT = 0x80110427u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_BADTLB: HRESULT = 0x80110428u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_NOTINSTALLABLE: HRESULT = 0x80110429u32 as HRESULT;
pub const COMADMIN_E_NOTCHANGEABLE: HRESULT = 0x8011042Au32 as HRESULT;
pub const COMADMIN_E_NOTDELETEABLE: HRESULT = 0x8011042Bu32 as HRESULT;
pub const COMADMIN_E_SESSION: HRESULT = 0x8011042Cu32 as HRESULT;
pub const COMADMIN_E_COMP_MOVE_LOCKED: HRESULT = 0x8011042Du32 as HRESULT;
pub const COMADMIN_E_COMP_MOVE_BAD_DEST: HRESULT = 0x8011042Eu32 as HRESULT;
pub const COMADMIN_E_REGISTERTLB: HRESULT = 0x80110430u32 as HRESULT;
pub const COMADMIN_E_SYSTEMAPP: HRESULT = 0x80110433u32 as HRESULT;
pub const COMADMIN_E_COMPFILE_NOREGISTRAR: HRESULT = 0x80110434u32 as HRESULT;
pub const COMADMIN_E_COREQCOMPINSTALLED: HRESULT = 0x80110435u32 as HRESULT;
pub const COMADMIN_E_SERVICENOTINSTALLED: HRESULT = 0x80110436u32 as HRESULT;
pub const COMADMIN_E_PROPERTYSAVEFAILED: HRESULT = 0x80110437u32 as HRESULT;
pub const COMADMIN_E_OBJECTEXISTS: HRESULT = 0x80110438u32 as HRESULT;
pub const COMADMIN_E_COMPONENTEXISTS: HRESULT = 0x80110439u32 as HRESULT;
pub const COMADMIN_E_REGFILE_CORRUPT: HRESULT = 0x8011043Bu32 as HRESULT;
pub const COMADMIN_E_PROPERTY_OVERFLOW: HRESULT = 0x8011043Cu32 as HRESULT;
pub const COMADMIN_E_NOTINREGISTRY: HRESULT = 0x8011043Eu32 as HRESULT;
pub const COMADMIN_E_OBJECTNOTPOOLABLE: HRESULT = 0x8011043Fu32 as HRESULT;
pub const COMADMIN_E_APPLID_MATCHES_CLSID: HRESULT = 0x80110446u32 as HRESULT;
pub const COMADMIN_E_ROLE_DOES_NOT_EXIST: HRESULT = 0x80110447u32 as HRESULT;
pub const COMADMIN_E_START_APP_NEEDS_COMPONENTS: HRESULT = 0x80110448u32 as HRESULT;
pub const COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM: HRESULT = 0x80110449u32 as HRESULT;
pub const COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY: HRESULT = 0x8011044Au32 as HRESULT;
pub const COMADMIN_E_CAN_NOT_START_APP: HRESULT = 0x8011044Bu32 as HRESULT;
pub const COMADMIN_E_CAN_NOT_EXPORT_SYS_APP: HRESULT = 0x8011044Cu32 as HRESULT;
pub const COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT: HRESULT = 0x8011044Du32 as HRESULT;
pub const COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER: HRESULT = 0x8011044Eu32 as HRESULT;
pub const COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE: HRESULT = 0x8011044Fu32 as HRESULT;
pub const COMADMIN_E_BASE_PARTITION_ONLY: HRESULT = 0x80110450u32 as HRESULT;
pub const COMADMIN_E_START_APP_DISABLED: HRESULT = 0x80110451u32 as HRESULT;
pub const COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME: HRESULT = 0x80110457u32 as HRESULT;
pub const COMADMIN_E_CAT_INVALID_PARTITION_NAME: HRESULT = 0x80110458u32 as HRESULT;
pub const COMADMIN_E_CAT_PARTITION_IN_USE: HRESULT = 0x80110459u32 as HRESULT;
pub const COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES: HRESULT = 0x8011045Au32 as HRESULT;
pub const COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED: HRESULT = 0x8011045Bu32 as HRESULT;
pub const COMADMIN_E_AMBIGUOUS_APPLICATION_NAME: HRESULT = 0x8011045Cu32 as HRESULT;
pub const COMADMIN_E_AMBIGUOUS_PARTITION_NAME: HRESULT = 0x8011045Du32 as HRESULT;
pub const COMADMIN_E_REGDB_NOTINITIALIZED: HRESULT = 0x80110472u32 as HRESULT;
pub const COMADMIN_E_REGDB_NOTOPEN: HRESULT = 0x80110473u32 as HRESULT;
pub const COMADMIN_E_REGDB_SYSTEMERR: HRESULT = 0x80110474u32 as HRESULT;
pub const COMADMIN_E_REGDB_ALREADYRUNNING: HRESULT = 0x80110475u32 as HRESULT;
pub const COMADMIN_E_MIG_VERSIONNOTSUPPORTED: HRESULT = 0x80110480u32 as HRESULT;
pub const COMADMIN_E_MIG_SCHEMANOTFOUND: HRESULT = 0x80110481u32 as HRESULT;
pub const COMADMIN_E_CAT_BITNESSMISMATCH: HRESULT = 0x80110482u32 as HRESULT;
pub const COMADMIN_E_CAT_UNACCEPTABLEBITNESS: HRESULT = 0x80110483u32 as HRESULT;
pub const COMADMIN_E_CAT_WRONGAPPBITNESS: HRESULT = 0x80110484u32 as HRESULT;
pub const COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED: HRESULT = 0x80110485u32 as HRESULT;
pub const COMADMIN_E_CAT_SERVERFAULT: HRESULT = 0x80110486u32 as HRESULT;
pub const COMQC_E_APPLICATION_NOT_QUEUED: HRESULT = 0x80110600u32 as HRESULT;
pub const COMQC_E_NO_QUEUEABLE_INTERFACES: HRESULT = 0x80110601u32 as HRESULT;
pub const COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE: HRESULT = 0x80110602u32 as HRESULT;
pub const COMQC_E_NO_IPERSISTSTREAM: HRESULT = 0x80110603u32 as HRESULT;
pub const COMQC_E_BAD_MESSAGE: HRESULT = 0x80110604u32 as HRESULT;
pub const COMQC_E_UNAUTHENTICATED: HRESULT = 0x80110605u32 as HRESULT;
pub const COMQC_E_UNTRUSTED_ENQUEUER: HRESULT = 0x80110606u32 as HRESULT;
pub const MSDTC_E_DUPLICATE_RESOURCE: HRESULT = 0x80110701u32 as HRESULT;
pub const COMADMIN_E_OBJECT_PARENT_MISSING: HRESULT = 0x80110808u32 as HRESULT;
pub const COMADMIN_E_OBJECT_DOES_NOT_EXIST: HRESULT = 0x80110809u32 as HRESULT;
pub const COMADMIN_E_APP_NOT_RUNNING: HRESULT = 0x8011080Au32 as HRESULT;
pub const COMADMIN_E_INVALID_PARTITION: HRESULT = 0x8011080Bu32 as HRESULT;
pub const COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE: HRESULT = 0x8011080Du32 as HRESULT;
pub const COMADMIN_E_USER_IN_SET: HRESULT = 0x8011080Eu32 as HRESULT;
pub const COMADMIN_E_CANTRECYCLELIBRARYAPPS: HRESULT = 0x8011080Fu32 as HRESULT;
pub const COMADMIN_E_CANTRECYCLESERVICEAPPS: HRESULT = 0x80110811u32 as HRESULT;
pub const COMADMIN_E_PROCESSALREADYRECYCLED: HRESULT = 0x80110812u32 as HRESULT;
pub const COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED: HRESULT = 0x80110813u32 as HRESULT;
pub const COMADMIN_E_CANTMAKEINPROCSERVICE: HRESULT = 0x80110814u32 as HRESULT;
pub const COMADMIN_E_PROGIDINUSEBYCLSID: HRESULT = 0x80110815u32 as HRESULT;
pub const COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET: HRESULT = 0x80110816u32 as HRESULT;
pub const COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED: HRESULT = 0x80110817u32 as HRESULT;
pub const COMADMIN_E_PARTITION_ACCESSDENIED: HRESULT = 0x80110818u32 as HRESULT;
pub const COMADMIN_E_PARTITION_MSI_ONLY: HRESULT = 0x80110819u32 as HRESULT;
pub const COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT: HRESULT = 0x8011081Au32 as HRESULT;
pub const COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS: HRESULT = 0x8011081Bu32 as HRESULT;
pub const COMADMIN_E_COMP_MOVE_SOURCE: HRESULT = 0x8011081Cu32 as HRESULT;
pub const COMADMIN_E_COMP_MOVE_DEST: HRESULT = 0x8011081Du32 as HRESULT;
pub const COMADMIN_E_COMP_MOVE_PRIVATE: HRESULT = 0x8011081Eu32 as HRESULT;
pub const COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET: HRESULT = 0x8011081Fu32 as HRESULT;
pub const COMADMIN_E_CANNOT_ALIAS_EVENTCLASS: HRESULT = 0x80110820u32 as HRESULT;
pub const COMADMIN_E_PRIVATE_ACCESSDENIED: HRESULT = 0x80110821u32 as HRESULT;
pub const COMADMIN_E_SAFERINVALID: HRESULT = 0x80110822u32 as HRESULT;
pub const COMADMIN_E_REGISTRY_ACCESSDENIED: HRESULT = 0x80110823u32 as HRESULT;
pub const COMADMIN_E_PARTITIONS_DISABLED: HRESULT = 0x80110824u32 as HRESULT;
pub const WER_S_REPORT_DEBUG: HRESULT = 0x001B0000;
pub const WER_S_REPORT_UPLOADED: HRESULT = 0x001B0001;
pub const WER_S_REPORT_QUEUED: HRESULT = 0x001B0002;
pub const WER_S_DISABLED: HRESULT = 0x001B0003;
pub const WER_S_SUSPENDED_UPLOAD: HRESULT = 0x001B0004;
pub const WER_S_DISABLED_QUEUE: HRESULT = 0x001B0005;
pub const WER_S_DISABLED_ARCHIVE: HRESULT = 0x001B0006;
pub const WER_S_REPORT_ASYNC: HRESULT = 0x001B0007;
pub const WER_S_IGNORE_ASSERT_INSTANCE: HRESULT = 0x001B0008;
pub const WER_S_IGNORE_ALL_ASSERTS: HRESULT = 0x001B0009;
pub const WER_S_ASSERT_CONTINUE: HRESULT = 0x001B000A;
pub const WER_S_THROTTLED: HRESULT = 0x001B000B;
pub const WER_E_CRASH_FAILURE: HRESULT = 0x801B8000u32 as HRESULT;
pub const WER_E_CANCELED: HRESULT = 0x801B8001u32 as HRESULT;
pub const WER_E_NETWORK_FAILURE: HRESULT = 0x801B8002u32 as HRESULT;
pub const WER_E_NOT_INITIALIZED: HRESULT = 0x801B8003u32 as HRESULT;
pub const WER_E_ALREADY_REPORTING: HRESULT = 0x801B8004u32 as HRESULT;
pub const WER_E_DUMP_THROTTLED: HRESULT = 0x801B8005u32 as HRESULT;
pub const ERROR_FLT_IO_COMPLETE: HRESULT = 0x001F0001;
pub const ERROR_FLT_NO_HANDLER_DEFINED: HRESULT = 0x801F0001u32 as HRESULT;
pub const ERROR_FLT_CONTEXT_ALREADY_DEFINED: HRESULT = 0x801F0002u32 as HRESULT;
pub const ERROR_FLT_INVALID_ASYNCHRONOUS_REQUEST: HRESULT = 0x801F0003u32 as HRESULT;
pub const ERROR_FLT_DISALLOW_FAST_IO: HRESULT = 0x801F0004u32 as HRESULT;
pub const ERROR_FLT_INVALID_NAME_REQUEST: HRESULT = 0x801F0005u32 as HRESULT;
pub const ERROR_FLT_NOT_SAFE_TO_POST_OPERATION: HRESULT = 0x801F0006u32 as HRESULT;
pub const ERROR_FLT_NOT_INITIALIZED: HRESULT = 0x801F0007u32 as HRESULT;
pub const ERROR_FLT_FILTER_NOT_READY: HRESULT = 0x801F0008u32 as HRESULT;
pub const ERROR_FLT_POST_OPERATION_CLEANUP: HRESULT = 0x801F0009u32 as HRESULT;
pub const ERROR_FLT_INTERNAL_ERROR: HRESULT = 0x801F000Au32 as HRESULT;
pub const ERROR_FLT_DELETING_OBJECT: HRESULT = 0x801F000Bu32 as HRESULT;
pub const ERROR_FLT_MUST_BE_NONPAGED_POOL: HRESULT = 0x801F000Cu32 as HRESULT;
pub const ERROR_FLT_DUPLICATE_ENTRY: HRESULT = 0x801F000Du32 as HRESULT;
pub const ERROR_FLT_CBDQ_DISABLED: HRESULT = 0x801F000Eu32 as HRESULT;
pub const ERROR_FLT_DO_NOT_ATTACH: HRESULT = 0x801F000Fu32 as HRESULT;
pub const ERROR_FLT_DO_NOT_DETACH: HRESULT = 0x801F0010u32 as HRESULT;
pub const ERROR_FLT_INSTANCE_ALTITUDE_COLLISION: HRESULT = 0x801F0011u32 as HRESULT;
pub const ERROR_FLT_INSTANCE_NAME_COLLISION: HRESULT = 0x801F0012u32 as HRESULT;
pub const ERROR_FLT_FILTER_NOT_FOUND: HRESULT = 0x801F0013u32 as HRESULT;
pub const ERROR_FLT_VOLUME_NOT_FOUND: HRESULT = 0x801F0014u32 as HRESULT;
pub const ERROR_FLT_INSTANCE_NOT_FOUND: HRESULT = 0x801F0015u32 as HRESULT;
pub const ERROR_FLT_CONTEXT_ALLOCATION_NOT_FOUND: HRESULT = 0x801F0016u32 as HRESULT;
pub const ERROR_FLT_INVALID_CONTEXT_REGISTRATION: HRESULT = 0x801F0017u32 as HRESULT;
pub const ERROR_FLT_NAME_CACHE_MISS: HRESULT = 0x801F0018u32 as HRESULT;
pub const ERROR_FLT_NO_DEVICE_OBJECT: HRESULT = 0x801F0019u32 as HRESULT;
pub const ERROR_FLT_VOLUME_ALREADY_MOUNTED: HRESULT = 0x801F001Au32 as HRESULT;
pub const ERROR_FLT_ALREADY_ENLISTED: HRESULT = 0x801F001Bu32 as HRESULT;
pub const ERROR_FLT_CONTEXT_ALREADY_LINKED: HRESULT = 0x801F001Cu32 as HRESULT;
pub const ERROR_FLT_NO_WAITER_FOR_REPLY: HRESULT = 0x801F0020u32 as HRESULT;
pub const ERROR_FLT_REGISTRATION_BUSY: HRESULT = 0x801F0023u32 as HRESULT;
pub const ERROR_HUNG_DISPLAY_DRIVER_THREAD: HRESULT = 0x80260001u32 as HRESULT;
pub const DWM_E_COMPOSITIONDISABLED: HRESULT = 0x80263001u32 as HRESULT;
pub const DWM_E_REMOTING_NOT_SUPPORTED: HRESULT = 0x80263002u32 as HRESULT;
pub const DWM_E_NO_REDIRECTION_SURFACE_AVAILABLE: HRESULT = 0x80263003u32 as HRESULT;
pub const DWM_E_NOT_QUEUING_PRESENTS: HRESULT = 0x80263004u32 as HRESULT;
pub const DWM_E_ADAPTER_NOT_FOUND: HRESULT = 0x80263005u32 as HRESULT;
pub const DWM_S_GDI_REDIRECTION_SURFACE: HRESULT = 0x00263005;
pub const DWM_E_TEXTURE_TOO_LARGE: HRESULT = 0x80263007u32 as HRESULT;
pub const ERROR_MONITOR_NO_DESCRIPTOR: HRESULT = 0x80261001u32 as HRESULT;
pub const ERROR_MONITOR_UNKNOWN_DESCRIPTOR_FORMAT: HRESULT = 0x80261002u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_DESCRIPTOR_CHECKSUM: HRESULT = 0xC0261003u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_STANDARD_TIMING_BLOCK: HRESULT = 0xC0261004u32 as HRESULT;
pub const ERROR_MONITOR_WMI_DATABLOCK_REGISTRATION_FAILED: HRESULT = 0xC0261005u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_SERIAL_NUMBER_MONDSC_BLOCK: HRESULT = 0xC0261006u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_USER_FRIENDLY_MONDSC_BLOCK: HRESULT = 0xC0261007u32 as HRESULT;
pub const ERROR_MONITOR_NO_MORE_DESCRIPTOR_DATA: HRESULT = 0xC0261008u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_DETAILED_TIMING_BLOCK: HRESULT = 0xC0261009u32 as HRESULT;
pub const ERROR_MONITOR_INVALID_MANUFACTURE_DATE: HRESULT = 0xC026100Au32 as HRESULT;
pub const ERROR_GRAPHICS_NOT_EXCLUSIVE_MODE_OWNER: HRESULT = 0xC0262000u32 as HRESULT;
pub const ERROR_GRAPHICS_INSUFFICIENT_DMA_BUFFER: HRESULT = 0xC0262001u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_DISPLAY_ADAPTER: HRESULT = 0xC0262002u32 as HRESULT;
pub const ERROR_GRAPHICS_ADAPTER_WAS_RESET: HRESULT = 0xC0262003u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_DRIVER_MODEL: HRESULT = 0xC0262004u32 as HRESULT;
pub const ERROR_GRAPHICS_PRESENT_MODE_CHANGED: HRESULT = 0xC0262005u32 as HRESULT;
pub const ERROR_GRAPHICS_PRESENT_OCCLUDED: HRESULT = 0xC0262006u32 as HRESULT;
pub const ERROR_GRAPHICS_PRESENT_DENIED: HRESULT = 0xC0262007u32 as HRESULT;
pub const ERROR_GRAPHICS_CANNOTCOLORCONVERT: HRESULT = 0xC0262008u32 as HRESULT;
pub const ERROR_GRAPHICS_DRIVER_MISMATCH: HRESULT = 0xC0262009u32 as HRESULT;
pub const ERROR_GRAPHICS_PARTIAL_DATA_POPULATED: HRESULT = 0x4026200A;
pub const ERROR_GRAPHICS_PRESENT_REDIRECTION_DISABLED: HRESULT = 0xC026200Bu32 as HRESULT;
pub const ERROR_GRAPHICS_PRESENT_UNOCCLUDED: HRESULT = 0xC026200Cu32 as HRESULT;
pub const ERROR_GRAPHICS_WINDOWDC_NOT_AVAILABLE: HRESULT = 0xC026200Du32 as HRESULT;
pub const ERROR_GRAPHICS_WINDOWLESS_PRESENT_DISABLED: HRESULT = 0xC026200Eu32 as HRESULT;
pub const ERROR_GRAPHICS_NO_VIDEO_MEMORY: HRESULT = 0xC0262100u32 as HRESULT;
pub const ERROR_GRAPHICS_CANT_LOCK_MEMORY: HRESULT = 0xC0262101u32 as HRESULT;
pub const ERROR_GRAPHICS_ALLOCATION_BUSY: HRESULT = 0xC0262102u32 as HRESULT;
pub const ERROR_GRAPHICS_TOO_MANY_REFERENCES: HRESULT = 0xC0262103u32 as HRESULT;
pub const ERROR_GRAPHICS_TRY_AGAIN_LATER: HRESULT = 0xC0262104u32 as HRESULT;
pub const ERROR_GRAPHICS_TRY_AGAIN_NOW: HRESULT = 0xC0262105u32 as HRESULT;
pub const ERROR_GRAPHICS_ALLOCATION_INVALID: HRESULT = 0xC0262106u32 as HRESULT;
pub const ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNAVAILABLE: HRESULT = 0xC0262107u32 as HRESULT;
pub const ERROR_GRAPHICS_UNSWIZZLING_APERTURE_UNSUPPORTED: HRESULT = 0xC0262108u32 as HRESULT;
pub const ERROR_GRAPHICS_CANT_EVICT_PINNED_ALLOCATION: HRESULT = 0xC0262109u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_USAGE: HRESULT = 0xC0262110u32 as HRESULT;
pub const ERROR_GRAPHICS_CANT_RENDER_LOCKED_ALLOCATION: HRESULT = 0xC0262111u32 as HRESULT;
pub const ERROR_GRAPHICS_ALLOCATION_CLOSED: HRESULT = 0xC0262112u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_INSTANCE: HRESULT = 0xC0262113u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_ALLOCATION_HANDLE: HRESULT = 0xC0262114u32 as HRESULT;
pub const ERROR_GRAPHICS_WRONG_ALLOCATION_DEVICE: HRESULT = 0xC0262115u32 as HRESULT;
pub const ERROR_GRAPHICS_ALLOCATION_CONTENT_LOST: HRESULT = 0xC0262116u32 as HRESULT;
pub const ERROR_GRAPHICS_GPU_EXCEPTION_ON_DEVICE: HRESULT = 0xC0262200u32 as HRESULT;
pub const ERROR_GRAPHICS_SKIP_ALLOCATION_PREPARATION: HRESULT = 0x40262201;
pub const ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY: HRESULT = 0xC0262300u32 as HRESULT;
pub const ERROR_GRAPHICS_VIDPN_TOPOLOGY_NOT_SUPPORTED: HRESULT = 0xC0262301u32 as HRESULT;
pub const ERROR_GRAPHICS_VIDPN_TOPOLOGY_CURRENTLY_NOT_SUPPORTED: HRESULT = 0xC0262302u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDPN: HRESULT = 0xC0262303u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE: HRESULT = 0xC0262304u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET: HRESULT = 0xC0262305u32 as HRESULT;
pub const ERROR_GRAPHICS_VIDPN_MODALITY_NOT_SUPPORTED: HRESULT = 0xC0262306u32 as HRESULT;
pub const ERROR_GRAPHICS_MODE_NOT_PINNED: HRESULT = 0x00262307;
pub const ERROR_GRAPHICS_INVALID_VIDPN_SOURCEMODESET: HRESULT = 0xC0262308u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDPN_TARGETMODESET: HRESULT = 0xC0262309u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_FREQUENCY: HRESULT = 0xC026230Au32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_ACTIVE_REGION: HRESULT = 0xC026230Bu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_TOTAL_REGION: HRESULT = 0xC026230Cu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_SOURCE_MODE: HRESULT = 0xC0262310u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEO_PRESENT_TARGET_MODE: HRESULT = 0xC0262311u32 as HRESULT;
pub const ERROR_GRAPHICS_PINNED_MODE_MUST_REMAIN_IN_SET: HRESULT = 0xC0262312u32 as HRESULT;
pub const ERROR_GRAPHICS_PATH_ALREADY_IN_TOPOLOGY: HRESULT = 0xC0262313u32 as HRESULT;
pub const ERROR_GRAPHICS_MODE_ALREADY_IN_MODESET: HRESULT = 0xC0262314u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEOPRESENTSOURCESET: HRESULT = 0xC0262315u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDEOPRESENTTARGETSET: HRESULT = 0xC0262316u32 as HRESULT;
pub const ERROR_GRAPHICS_SOURCE_ALREADY_IN_SET: HRESULT = 0xC0262317u32 as HRESULT;
pub const ERROR_GRAPHICS_TARGET_ALREADY_IN_SET: HRESULT = 0xC0262318u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDPN_PRESENT_PATH: HRESULT = 0xC0262319u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_RECOMMENDED_VIDPN_TOPOLOGY: HRESULT = 0xC026231Au32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGESET: HRESULT = 0xC026231Bu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE: HRESULT = 0xC026231Cu32 as HRESULT;
pub const ERROR_GRAPHICS_FREQUENCYRANGE_NOT_IN_SET: HRESULT = 0xC026231Du32 as HRESULT;
pub const ERROR_GRAPHICS_NO_PREFERRED_MODE: HRESULT = 0x0026231E;
pub const ERROR_GRAPHICS_FREQUENCYRANGE_ALREADY_IN_SET: HRESULT = 0xC026231Fu32 as HRESULT;
pub const ERROR_GRAPHICS_STALE_MODESET: HRESULT = 0xC0262320u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_SOURCEMODESET: HRESULT = 0xC0262321u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_SOURCE_MODE: HRESULT = 0xC0262322u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_RECOMMENDED_FUNCTIONAL_VIDPN: HRESULT = 0xC0262323u32 as HRESULT;
pub const ERROR_GRAPHICS_MODE_ID_MUST_BE_UNIQUE: HRESULT = 0xC0262324u32 as HRESULT;
pub const ERROR_GRAPHICS_EMPTY_ADAPTER_MONITOR_MODE_SUPPORT_INTERSECTION: HRESULT = 0xC0262325u32 as HRESULT;
pub const ERROR_GRAPHICS_VIDEO_PRESENT_TARGETS_LESS_THAN_SOURCES: HRESULT = 0xC0262326u32 as HRESULT;
pub const ERROR_GRAPHICS_PATH_NOT_IN_TOPOLOGY: HRESULT = 0xC0262327u32 as HRESULT;
pub const ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_SOURCE: HRESULT = 0xC0262328u32 as HRESULT;
pub const ERROR_GRAPHICS_ADAPTER_MUST_HAVE_AT_LEAST_ONE_TARGET: HRESULT = 0xC0262329u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITORDESCRIPTORSET: HRESULT = 0xC026232Au32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITORDESCRIPTOR: HRESULT = 0xC026232Bu32 as HRESULT;
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_NOT_IN_SET: HRESULT = 0xC026232Cu32 as HRESULT;
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_ALREADY_IN_SET: HRESULT = 0xC026232Du32 as HRESULT;
pub const ERROR_GRAPHICS_MONITORDESCRIPTOR_ID_MUST_BE_UNIQUE: HRESULT = 0xC026232Eu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VIDPN_TARGET_SUBSET_TYPE: HRESULT = 0xC026232Fu32 as HRESULT;
pub const ERROR_GRAPHICS_RESOURCES_NOT_RELATED: HRESULT = 0xC0262330u32 as HRESULT;
pub const ERROR_GRAPHICS_SOURCE_ID_MUST_BE_UNIQUE: HRESULT = 0xC0262331u32 as HRESULT;
pub const ERROR_GRAPHICS_TARGET_ID_MUST_BE_UNIQUE: HRESULT = 0xC0262332u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_AVAILABLE_VIDPN_TARGET: HRESULT = 0xC0262333u32 as HRESULT;
pub const ERROR_GRAPHICS_MONITOR_COULD_NOT_BE_ASSOCIATED_WITH_ADAPTER: HRESULT = 0xC0262334u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_VIDPNMGR: HRESULT = 0xC0262335u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_ACTIVE_VIDPN: HRESULT = 0xC0262336u32 as HRESULT;
pub const ERROR_GRAPHICS_STALE_VIDPN_TOPOLOGY: HRESULT = 0xC0262337u32 as HRESULT;
pub const ERROR_GRAPHICS_MONITOR_NOT_CONNECTED: HRESULT = 0xC0262338u32 as HRESULT;
pub const ERROR_GRAPHICS_SOURCE_NOT_IN_TOPOLOGY: HRESULT = 0xC0262339u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PRIMARYSURFACE_SIZE: HRESULT = 0xC026233Au32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_VISIBLEREGION_SIZE: HRESULT = 0xC026233Bu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_STRIDE: HRESULT = 0xC026233Cu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PIXELFORMAT: HRESULT = 0xC026233Du32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_COLORBASIS: HRESULT = 0xC026233Eu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PIXELVALUEACCESSMODE: HRESULT = 0xC026233Fu32 as HRESULT;
pub const ERROR_GRAPHICS_TARGET_NOT_IN_TOPOLOGY: HRESULT = 0xC0262340u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_DISPLAY_MODE_MANAGEMENT_SUPPORT: HRESULT = 0xC0262341u32 as HRESULT;
pub const ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE: HRESULT = 0xC0262342u32 as HRESULT;
pub const ERROR_GRAPHICS_CANT_ACCESS_ACTIVE_VIDPN: HRESULT = 0xC0262343u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PATH_IMPORTANCE_ORDINAL: HRESULT = 0xC0262344u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PATH_CONTENT_GEOMETRY_TRANSFORMATION: HRESULT = 0xC0262345u32 as HRESULT;
pub const ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_SUPPORTED: HRESULT = 0xC0262346u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_GAMMA_RAMP: HRESULT = 0xC0262347u32 as HRESULT;
pub const ERROR_GRAPHICS_GAMMA_RAMP_NOT_SUPPORTED: HRESULT = 0xC0262348u32 as HRESULT;
pub const ERROR_GRAPHICS_MULTISAMPLING_NOT_SUPPORTED: HRESULT = 0xC0262349u32 as HRESULT;
pub const ERROR_GRAPHICS_MODE_NOT_IN_MODESET: HRESULT = 0xC026234Au32 as HRESULT;
pub const ERROR_GRAPHICS_DATASET_IS_EMPTY: HRESULT = 0x0026234B;
pub const ERROR_GRAPHICS_NO_MORE_ELEMENTS_IN_DATASET: HRESULT = 0x0026234C;
pub const ERROR_GRAPHICS_INVALID_VIDPN_TOPOLOGY_RECOMMENDATION_REASON: HRESULT = 0xC026234Du32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PATH_CONTENT_TYPE: HRESULT = 0xC026234Eu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_COPYPROTECTION_TYPE: HRESULT = 0xC026234Fu32 as HRESULT;
pub const ERROR_GRAPHICS_UNASSIGNED_MODESET_ALREADY_EXISTS: HRESULT = 0xC0262350u32 as HRESULT;
pub const ERROR_GRAPHICS_PATH_CONTENT_GEOMETRY_TRANSFORMATION_NOT_PINNED: HRESULT = 0x00262351;
pub const ERROR_GRAPHICS_INVALID_SCANLINE_ORDERING: HRESULT = 0xC0262352u32 as HRESULT;
pub const ERROR_GRAPHICS_TOPOLOGY_CHANGES_NOT_ALLOWED: HRESULT = 0xC0262353u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_AVAILABLE_IMPORTANCE_ORDINALS: HRESULT = 0xC0262354u32 as HRESULT;
pub const ERROR_GRAPHICS_INCOMPATIBLE_PRIVATE_FORMAT: HRESULT = 0xC0262355u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MODE_PRUNING_ALGORITHM: HRESULT = 0xC0262356u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_CAPABILITY_ORIGIN: HRESULT = 0xC0262357u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_MONITOR_FREQUENCYRANGE_CONSTRAINT: HRESULT = 0xC0262358u32 as HRESULT;
pub const ERROR_GRAPHICS_MAX_NUM_PATHS_REACHED: HRESULT = 0xC0262359u32 as HRESULT;
pub const ERROR_GRAPHICS_CANCEL_VIDPN_TOPOLOGY_AUGMENTATION: HRESULT = 0xC026235Au32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_CLIENT_TYPE: HRESULT = 0xC026235Bu32 as HRESULT;
pub const ERROR_GRAPHICS_CLIENTVIDPN_NOT_SET: HRESULT = 0xC026235Cu32 as HRESULT;
pub const ERROR_GRAPHICS_SPECIFIED_CHILD_ALREADY_CONNECTED: HRESULT = 0xC0262400u32 as HRESULT;
pub const ERROR_GRAPHICS_CHILD_DESCRIPTOR_NOT_SUPPORTED: HRESULT = 0xC0262401u32 as HRESULT;
pub const ERROR_GRAPHICS_UNKNOWN_CHILD_STATUS: HRESULT = 0x4026242F;
pub const ERROR_GRAPHICS_NOT_A_LINKED_ADAPTER: HRESULT = 0xC0262430u32 as HRESULT;
pub const ERROR_GRAPHICS_LEADLINK_NOT_ENUMERATED: HRESULT = 0xC0262431u32 as HRESULT;
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_ENUMERATED: HRESULT = 0xC0262432u32 as HRESULT;
pub const ERROR_GRAPHICS_ADAPTER_CHAIN_NOT_READY: HRESULT = 0xC0262433u32 as HRESULT;
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_STARTED: HRESULT = 0xC0262434u32 as HRESULT;
pub const ERROR_GRAPHICS_CHAINLINKS_NOT_POWERED_ON: HRESULT = 0xC0262435u32 as HRESULT;
pub const ERROR_GRAPHICS_INCONSISTENT_DEVICE_LINK_STATE: HRESULT = 0xC0262436u32 as HRESULT;
pub const ERROR_GRAPHICS_LEADLINK_START_DEFERRED: HRESULT = 0x40262437;
pub const ERROR_GRAPHICS_NOT_POST_DEVICE_DRIVER: HRESULT = 0xC0262438u32 as HRESULT;
pub const ERROR_GRAPHICS_POLLING_TOO_FREQUENTLY: HRESULT = 0x40262439;
pub const ERROR_GRAPHICS_START_DEFERRED: HRESULT = 0x4026243A;
pub const ERROR_GRAPHICS_ADAPTER_ACCESS_NOT_EXCLUDED: HRESULT = 0xC026243Bu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_NOT_SUPPORTED: HRESULT = 0xC0262500u32 as HRESULT;
pub const ERROR_GRAPHICS_COPP_NOT_SUPPORTED: HRESULT = 0xC0262501u32 as HRESULT;
pub const ERROR_GRAPHICS_UAB_NOT_SUPPORTED: HRESULT = 0xC0262502u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INVALID_ENCRYPTED_PARAMETERS: HRESULT = 0xC0262503u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_NO_VIDEO_OUTPUTS_EXIST: HRESULT = 0xC0262505u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INTERNAL_ERROR: HRESULT = 0xC026250Bu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INVALID_HANDLE: HRESULT = 0xC026250Cu32 as HRESULT;
pub const ERROR_GRAPHICS_PVP_INVALID_CERTIFICATE_LENGTH: HRESULT = 0xC026250Eu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_SPANNING_MODE_ENABLED: HRESULT = 0xC026250Fu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_THEATER_MODE_ENABLED: HRESULT = 0xC0262510u32 as HRESULT;
pub const ERROR_GRAPHICS_PVP_HFS_FAILED: HRESULT = 0xC0262511u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INVALID_SRM: HRESULT = 0xC0262512u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_HDCP: HRESULT = 0xC0262513u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_ACP: HRESULT = 0xC0262514u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_OUTPUT_DOES_NOT_SUPPORT_CGMSA: HRESULT = 0xC0262515u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_HDCP_SRM_NEVER_SET: HRESULT = 0xC0262516u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_RESOLUTION_TOO_HIGH: HRESULT = 0xC0262517u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_ALL_HDCP_HARDWARE_ALREADY_IN_USE: HRESULT = 0xC0262518u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_NO_LONGER_EXISTS: HRESULT = 0xC026251Au32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_SESSION_TYPE_CHANGE_IN_PROGRESS: HRESULT = 0xC026251Bu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_COPP_SEMANTICS: HRESULT = 0xC026251Cu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INVALID_INFORMATION_REQUEST: HRESULT = 0xC026251Du32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_DRIVER_INTERNAL_ERROR: HRESULT = 0xC026251Eu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_VIDEO_OUTPUT_DOES_NOT_HAVE_OPM_SEMANTICS: HRESULT = 0xC026251Fu32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_SIGNALING_NOT_SUPPORTED: HRESULT = 0xC0262520u32 as HRESULT;
pub const ERROR_GRAPHICS_OPM_INVALID_CONFIGURATION_REQUEST: HRESULT = 0xC0262521u32 as HRESULT;
pub const ERROR_GRAPHICS_I2C_NOT_SUPPORTED: HRESULT = 0xC0262580u32 as HRESULT;
pub const ERROR_GRAPHICS_I2C_DEVICE_DOES_NOT_EXIST: HRESULT = 0xC0262581u32 as HRESULT;
pub const ERROR_GRAPHICS_I2C_ERROR_TRANSMITTING_DATA: HRESULT = 0xC0262582u32 as HRESULT;
pub const ERROR_GRAPHICS_I2C_ERROR_RECEIVING_DATA: HRESULT = 0xC0262583u32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_VCP_NOT_SUPPORTED: HRESULT = 0xC0262584u32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_INVALID_DATA: HRESULT = 0xC0262585u32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_MONITOR_RETURNED_INVALID_TIMING_STATUS_BYTE: HRESULT = 0xC0262586u32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_INVALID_CAPABILITIES_STRING: HRESULT = 0xC0262587u32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_INTERNAL_ERROR: HRESULT = 0xC0262588u32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_COMMAND: HRESULT = 0xC0262589u32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_LENGTH: HRESULT = 0xC026258Au32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_INVALID_MESSAGE_CHECKSUM: HRESULT = 0xC026258Bu32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_PHYSICAL_MONITOR_HANDLE: HRESULT = 0xC026258Cu32 as HRESULT;
pub const ERROR_GRAPHICS_MONITOR_NO_LONGER_EXISTS: HRESULT = 0xC026258Du32 as HRESULT;
pub const ERROR_GRAPHICS_DDCCI_CURRENT_CURRENT_VALUE_GREATER_THAN_MAXIMUM_VALUE: HRESULT = 0xC02625D8u32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_INVALID_VCP_VERSION: HRESULT = 0xC02625D9u32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_MONITOR_VIOLATES_MCCS_SPECIFICATION: HRESULT = 0xC02625DAu32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_MCCS_VERSION_MISMATCH: HRESULT = 0xC02625DBu32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_UNSUPPORTED_MCCS_VERSION: HRESULT = 0xC02625DCu32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_INVALID_TECHNOLOGY_TYPE_RETURNED: HRESULT = 0xC02625DEu32 as HRESULT;
pub const ERROR_GRAPHICS_MCA_UNSUPPORTED_COLOR_TEMPERATURE: HRESULT = 0xC02625DFu32 as HRESULT;
pub const ERROR_GRAPHICS_ONLY_CONSOLE_SESSION_SUPPORTED: HRESULT = 0xC02625E0u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_DISPLAY_DEVICE_CORRESPONDS_TO_NAME: HRESULT = 0xC02625E1u32 as HRESULT;
pub const ERROR_GRAPHICS_DISPLAY_DEVICE_NOT_ATTACHED_TO_DESKTOP: HRESULT = 0xC02625E2u32 as HRESULT;
pub const ERROR_GRAPHICS_MIRRORING_DEVICES_NOT_SUPPORTED: HRESULT = 0xC02625E3u32 as HRESULT;
pub const ERROR_GRAPHICS_INVALID_POINTER: HRESULT = 0xC02625E4u32 as HRESULT;
pub const ERROR_GRAPHICS_NO_MONITORS_CORRESPOND_TO_DISPLAY_DEVICE: HRESULT = 0xC02625E5u32 as HRESULT;
pub const ERROR_GRAPHICS_PARAMETER_ARRAY_TOO_SMALL: HRESULT = 0xC02625E6u32 as HRESULT;
pub const ERROR_GRAPHICS_INTERNAL_ERROR: HRESULT = 0xC02625E7u32 as HRESULT;
pub const ERROR_GRAPHICS_SESSION_TYPE_CHANGE_IN_PROGRESS: HRESULT = 0xC02605E8u32 as HRESULT;
pub const NAP_E_INVALID_PACKET: HRESULT = 0x80270001u32 as HRESULT;
pub const NAP_E_MISSING_SOH: HRESULT = 0x80270002u32 as HRESULT;
pub const NAP_E_CONFLICTING_ID: HRESULT = 0x80270003u32 as HRESULT;
pub const NAP_E_NO_CACHED_SOH: HRESULT = 0x80270004u32 as HRESULT;
pub const NAP_E_STILL_BOUND: HRESULT = 0x80270005u32 as HRESULT;
pub const NAP_E_NOT_REGISTERED: HRESULT = 0x80270006u32 as HRESULT;
pub const NAP_E_NOT_INITIALIZED: HRESULT = 0x80270007u32 as HRESULT;
pub const NAP_E_MISMATCHED_ID: HRESULT = 0x80270008u32 as HRESULT;
pub const NAP_E_NOT_PENDING: HRESULT = 0x80270009u32 as HRESULT;
pub const NAP_E_ID_NOT_FOUND: HRESULT = 0x8027000Au32 as HRESULT;
pub const NAP_E_MAXSIZE_TOO_SMALL: HRESULT = 0x8027000Bu32 as HRESULT;
pub const NAP_E_SERVICE_NOT_RUNNING: HRESULT = 0x8027000Cu32 as HRESULT;
pub const NAP_S_CERT_ALREADY_PRESENT: HRESULT = 0x0027000D;
pub const NAP_E_ENTITY_DISABLED: HRESULT = 0x8027000Eu32 as HRESULT;
pub const NAP_E_NETSH_GROUPPOLICY_ERROR: HRESULT = 0x8027000Fu32 as HRESULT;
pub const NAP_E_TOO_MANY_CALLS: HRESULT = 0x80270010u32 as HRESULT;
pub const NAP_E_SHV_CONFIG_EXISTED: HRESULT = 0x80270011u32 as HRESULT;
pub const NAP_E_SHV_CONFIG_NOT_FOUND: HRESULT = 0x80270012u32 as HRESULT;
pub const NAP_E_SHV_TIMEOUT: HRESULT = 0x80270013u32 as HRESULT;
pub const TPM_E_ERROR_MASK: HRESULT = 0x80280000u32 as HRESULT;
pub const TPM_E_AUTHFAIL: HRESULT = 0x80280001u32 as HRESULT;
pub const TPM_E_BADINDEX: HRESULT = 0x80280002u32 as HRESULT;
pub const TPM_E_BAD_PARAMETER: HRESULT = 0x80280003u32 as HRESULT;
pub const TPM_E_AUDITFAILURE: HRESULT = 0x80280004u32 as HRESULT;
pub const TPM_E_CLEAR_DISABLED: HRESULT = 0x80280005u32 as HRESULT;
pub const TPM_E_DEACTIVATED: HRESULT = 0x80280006u32 as HRESULT;
pub const TPM_E_DISABLED: HRESULT = 0x80280007u32 as HRESULT;
pub const TPM_E_DISABLED_CMD: HRESULT = 0x80280008u32 as HRESULT;
pub const TPM_E_FAIL: HRESULT = 0x80280009u32 as HRESULT;
pub const TPM_E_BAD_ORDINAL: HRESULT = 0x8028000Au32 as HRESULT;
pub const TPM_E_INSTALL_DISABLED: HRESULT = 0x8028000Bu32 as HRESULT;
pub const TPM_E_INVALID_KEYHANDLE: HRESULT = 0x8028000Cu32 as HRESULT;
pub const TPM_E_KEYNOTFOUND: HRESULT = 0x8028000Du32 as HRESULT;
pub const TPM_E_INAPPROPRIATE_ENC: HRESULT = 0x8028000Eu32 as HRESULT;
pub const TPM_E_MIGRATEFAIL: HRESULT = 0x8028000Fu32 as HRESULT;
pub const TPM_E_INVALID_PCR_INFO: HRESULT = 0x80280010u32 as HRESULT;
pub const TPM_E_NOSPACE: HRESULT = 0x80280011u32 as HRESULT;
pub const TPM_E_NOSRK: HRESULT = 0x80280012u32 as HRESULT;
pub const TPM_E_NOTSEALED_BLOB: HRESULT = 0x80280013u32 as HRESULT;
pub const TPM_E_OWNER_SET: HRESULT = 0x80280014u32 as HRESULT;
pub const TPM_E_RESOURCES: HRESULT = 0x80280015u32 as HRESULT;
pub const TPM_E_SHORTRANDOM: HRESULT = 0x80280016u32 as HRESULT;
pub const TPM_E_SIZE: HRESULT = 0x80280017u32 as HRESULT;
pub const TPM_E_WRONGPCRVAL: HRESULT = 0x80280018u32 as HRESULT;
pub const TPM_E_BAD_PARAM_SIZE: HRESULT = 0x80280019u32 as HRESULT;
pub const TPM_E_SHA_THREAD: HRESULT = 0x8028001Au32 as HRESULT;
pub const TPM_E_SHA_ERROR: HRESULT = 0x8028001Bu32 as HRESULT;
pub const TPM_E_FAILEDSELFTEST: HRESULT = 0x8028001Cu32 as HRESULT;
pub const TPM_E_AUTH2FAIL: HRESULT = 0x8028001Du32 as HRESULT;
pub const TPM_E_BADTAG: HRESULT = 0x8028001Eu32 as HRESULT;
pub const TPM_E_IOERROR: HRESULT = 0x8028001Fu32 as HRESULT;
pub const TPM_E_ENCRYPT_ERROR: HRESULT = 0x80280020u32 as HRESULT;
pub const TPM_E_DECRYPT_ERROR: HRESULT = 0x80280021u32 as HRESULT;
pub const TPM_E_INVALID_AUTHHANDLE: HRESULT = 0x80280022u32 as HRESULT;
pub const TPM_E_NO_ENDORSEMENT: HRESULT = 0x80280023u32 as HRESULT;
pub const TPM_E_INVALID_KEYUSAGE: HRESULT = 0x80280024u32 as HRESULT;
pub const TPM_E_WRONG_ENTITYTYPE: HRESULT = 0x80280025u32 as HRESULT;
pub const TPM_E_INVALID_POSTINIT: HRESULT = 0x80280026u32 as HRESULT;
pub const TPM_E_INAPPROPRIATE_SIG: HRESULT = 0x80280027u32 as HRESULT;
pub const TPM_E_BAD_KEY_PROPERTY: HRESULT = 0x80280028u32 as HRESULT;
pub const TPM_E_BAD_MIGRATION: HRESULT = 0x80280029u32 as HRESULT;
pub const TPM_E_BAD_SCHEME: HRESULT = 0x8028002Au32 as HRESULT;
pub const TPM_E_BAD_DATASIZE: HRESULT = 0x8028002Bu32 as HRESULT;
pub const TPM_E_BAD_MODE: HRESULT = 0x8028002Cu32 as HRESULT;
pub const TPM_E_BAD_PRESENCE: HRESULT = 0x8028002Du32 as HRESULT;
pub const TPM_E_BAD_VERSION: HRESULT = 0x8028002Eu32 as HRESULT;
pub const TPM_E_NO_WRAP_TRANSPORT: HRESULT = 0x8028002Fu32 as HRESULT;
pub const TPM_E_AUDITFAIL_UNSUCCESSFUL: HRESULT = 0x80280030u32 as HRESULT;
pub const TPM_E_AUDITFAIL_SUCCESSFUL: HRESULT = 0x80280031u32 as HRESULT;
pub const TPM_E_NOTRESETABLE: HRESULT = 0x80280032u32 as HRESULT;
pub const TPM_E_NOTLOCAL: HRESULT = 0x80280033u32 as HRESULT;
pub const TPM_E_BAD_TYPE: HRESULT = 0x80280034u32 as HRESULT;
pub const TPM_E_INVALID_RESOURCE: HRESULT = 0x80280035u32 as HRESULT;
pub const TPM_E_NOTFIPS: HRESULT = 0x80280036u32 as HRESULT;
pub const TPM_E_INVALID_FAMILY: HRESULT = 0x80280037u32 as HRESULT;
pub const TPM_E_NO_NV_PERMISSION: HRESULT = 0x80280038u32 as HRESULT;
pub const TPM_E_REQUIRES_SIGN: HRESULT = 0x80280039u32 as HRESULT;
pub const TPM_E_KEY_NOTSUPPORTED: HRESULT = 0x8028003Au32 as HRESULT;
pub const TPM_E_AUTH_CONFLICT: HRESULT = 0x8028003Bu32 as HRESULT;
pub const TPM_E_AREA_LOCKED: HRESULT = 0x8028003Cu32 as HRESULT;
pub const TPM_E_BAD_LOCALITY: HRESULT = 0x8028003Du32 as HRESULT;
pub const TPM_E_READ_ONLY: HRESULT = 0x8028003Eu32 as HRESULT;
pub const TPM_E_PER_NOWRITE: HRESULT = 0x8028003Fu32 as HRESULT;
pub const TPM_E_FAMILYCOUNT: HRESULT = 0x80280040u32 as HRESULT;
pub const TPM_E_WRITE_LOCKED: HRESULT = 0x80280041u32 as HRESULT;
pub const TPM_E_BAD_ATTRIBUTES: HRESULT = 0x80280042u32 as HRESULT;
pub const TPM_E_INVALID_STRUCTURE: HRESULT = 0x80280043u32 as HRESULT;
pub const TPM_E_KEY_OWNER_CONTROL: HRESULT = 0x80280044u32 as HRESULT;
pub const TPM_E_BAD_COUNTER: HRESULT = 0x80280045u32 as HRESULT;
pub const TPM_E_NOT_FULLWRITE: HRESULT = 0x80280046u32 as HRESULT;
pub const TPM_E_CONTEXT_GAP: HRESULT = 0x80280047u32 as HRESULT;
pub const TPM_E_MAXNVWRITES: HRESULT = 0x80280048u32 as HRESULT;
pub const TPM_E_NOOPERATOR: HRESULT = 0x80280049u32 as HRESULT;
pub const TPM_E_RESOURCEMISSING: HRESULT = 0x8028004Au32 as HRESULT;
pub const TPM_E_DELEGATE_LOCK: HRESULT = 0x8028004Bu32 as HRESULT;
pub const TPM_E_DELEGATE_FAMILY: HRESULT = 0x8028004Cu32 as HRESULT;
pub const TPM_E_DELEGATE_ADMIN: HRESULT = 0x8028004Du32 as HRESULT;
pub const TPM_E_TRANSPORT_NOTEXCLUSIVE: HRESULT = 0x8028004Eu32 as HRESULT;
pub const TPM_E_OWNER_CONTROL: HRESULT = 0x8028004Fu32 as HRESULT;
pub const TPM_E_DAA_RESOURCES: HRESULT = 0x80280050u32 as HRESULT;
pub const TPM_E_DAA_INPUT_DATA0: HRESULT = 0x80280051u32 as HRESULT;
pub const TPM_E_DAA_INPUT_DATA1: HRESULT = 0x80280052u32 as HRESULT;
pub const TPM_E_DAA_ISSUER_SETTINGS: HRESULT = 0x80280053u32 as HRESULT;
pub const TPM_E_DAA_TPM_SETTINGS: HRESULT = 0x80280054u32 as HRESULT;
pub const TPM_E_DAA_STAGE: HRESULT = 0x80280055u32 as HRESULT;
pub const TPM_E_DAA_ISSUER_VALIDITY: HRESULT = 0x80280056u32 as HRESULT;
pub const TPM_E_DAA_WRONG_W: HRESULT = 0x80280057u32 as HRESULT;
pub const TPM_E_BAD_HANDLE: HRESULT = 0x80280058u32 as HRESULT;
pub const TPM_E_BAD_DELEGATE: HRESULT = 0x80280059u32 as HRESULT;
pub const TPM_E_BADCONTEXT: HRESULT = 0x8028005Au32 as HRESULT;
pub const TPM_E_TOOMANYCONTEXTS: HRESULT = 0x8028005Bu32 as HRESULT;
pub const TPM_E_MA_TICKET_SIGNATURE: HRESULT = 0x8028005Cu32 as HRESULT;
pub const TPM_E_MA_DESTINATION: HRESULT = 0x8028005Du32 as HRESULT;
pub const TPM_E_MA_SOURCE: HRESULT = 0x8028005Eu32 as HRESULT;
pub const TPM_E_MA_AUTHORITY: HRESULT = 0x8028005Fu32 as HRESULT;
pub const TPM_E_PERMANENTEK: HRESULT = 0x80280061u32 as HRESULT;
pub const TPM_E_BAD_SIGNATURE: HRESULT = 0x80280062u32 as HRESULT;
pub const TPM_E_NOCONTEXTSPACE: HRESULT = 0x80280063u32 as HRESULT;
pub const TPM_E_COMMAND_BLOCKED: HRESULT = 0x80280400u32 as HRESULT;
pub const TPM_E_INVALID_HANDLE: HRESULT = 0x80280401u32 as HRESULT;
pub const TPM_E_DUPLICATE_VHANDLE: HRESULT = 0x80280402u32 as HRESULT;
pub const TPM_E_EMBEDDED_COMMAND_BLOCKED: HRESULT = 0x80280403u32 as HRESULT;
pub const TPM_E_EMBEDDED_COMMAND_UNSUPPORTED: HRESULT = 0x80280404u32 as HRESULT;
pub const TPM_E_RETRY: HRESULT = 0x80280800u32 as HRESULT;
pub const TPM_E_NEEDS_SELFTEST: HRESULT = 0x80280801u32 as HRESULT;
pub const TPM_E_DOING_SELFTEST: HRESULT = 0x80280802u32 as HRESULT;
pub const TPM_E_DEFEND_LOCK_RUNNING: HRESULT = 0x80280803u32 as HRESULT;
pub const TBS_E_INTERNAL_ERROR: HRESULT = 0x80284001u32 as HRESULT;
pub const TBS_E_BAD_PARAMETER: HRESULT = 0x80284002u32 as HRESULT;
pub const TBS_E_INVALID_OUTPUT_POINTER: HRESULT = 0x80284003u32 as HRESULT;
pub const TBS_E_INVALID_CONTEXT: HRESULT = 0x80284004u32 as HRESULT;
pub const TBS_E_INSUFFICIENT_BUFFER: HRESULT = 0x80284005u32 as HRESULT;
pub const TBS_E_IOERROR: HRESULT = 0x80284006u32 as HRESULT;
pub const TBS_E_INVALID_CONTEXT_PARAM: HRESULT = 0x80284007u32 as HRESULT;
pub const TBS_E_SERVICE_NOT_RUNNING: HRESULT = 0x80284008u32 as HRESULT;
pub const TBS_E_TOO_MANY_TBS_CONTEXTS: HRESULT = 0x80284009u32 as HRESULT;
pub const TBS_E_TOO_MANY_RESOURCES: HRESULT = 0x8028400Au32 as HRESULT;
pub const TBS_E_SERVICE_START_PENDING: HRESULT = 0x8028400Bu32 as HRESULT;
pub const TBS_E_PPI_NOT_SUPPORTED: HRESULT = 0x8028400Cu32 as HRESULT;
pub const TBS_E_COMMAND_CANCELED: HRESULT = 0x8028400Du32 as HRESULT;
pub const TBS_E_BUFFER_TOO_LARGE: HRESULT = 0x8028400Eu32 as HRESULT;
pub const TBS_E_TPM_NOT_FOUND: HRESULT = 0x8028400Fu32 as HRESULT;
pub const TBS_E_SERVICE_DISABLED: HRESULT = 0x80284010u32 as HRESULT;
pub const TBS_E_NO_EVENT_LOG: HRESULT = 0x80284011u32 as HRESULT;
pub const TBS_E_ACCESS_DENIED: HRESULT = 0x80284012u32 as HRESULT;
pub const TBS_E_PROVISIONING_NOT_ALLOWED: HRESULT = 0x80284013u32 as HRESULT;
pub const TBS_E_PPI_FUNCTION_UNSUPPORTED: HRESULT = 0x80284014u32 as HRESULT;
pub const TBS_E_OWNERAUTH_NOT_FOUND: HRESULT = 0x80284015u32 as HRESULT;
pub const TBS_E_PROVISIONING_INCOMPLETE: HRESULT = 0x80284016u32 as HRESULT;
pub const TPMAPI_E_INVALID_STATE: HRESULT = 0x80290100u32 as HRESULT;
pub const TPMAPI_E_NOT_ENOUGH_DATA: HRESULT = 0x80290101u32 as HRESULT;
pub const TPMAPI_E_TOO_MUCH_DATA: HRESULT = 0x80290102u32 as HRESULT;
pub const TPMAPI_E_INVALID_OUTPUT_POINTER: HRESULT = 0x80290103u32 as HRESULT;
pub const TPMAPI_E_INVALID_PARAMETER: HRESULT = 0x80290104u32 as HRESULT;
pub const TPMAPI_E_OUT_OF_MEMORY: HRESULT = 0x80290105u32 as HRESULT;
pub const TPMAPI_E_BUFFER_TOO_SMALL: HRESULT = 0x80290106u32 as HRESULT;
pub const TPMAPI_E_INTERNAL_ERROR: HRESULT = 0x80290107u32 as HRESULT;
pub const TPMAPI_E_ACCESS_DENIED: HRESULT = 0x80290108u32 as HRESULT;
pub const TPMAPI_E_AUTHORIZATION_FAILED: HRESULT = 0x80290109u32 as HRESULT;
pub const TPMAPI_E_INVALID_CONTEXT_HANDLE: HRESULT = 0x8029010Au32 as HRESULT;
pub const TPMAPI_E_TBS_COMMUNICATION_ERROR: HRESULT = 0x8029010Bu32 as HRESULT;
pub const TPMAPI_E_TPM_COMMAND_ERROR: HRESULT = 0x8029010Cu32 as HRESULT;
pub const TPMAPI_E_MESSAGE_TOO_LARGE: HRESULT = 0x8029010Du32 as HRESULT;
pub const TPMAPI_E_INVALID_ENCODING: HRESULT = 0x8029010Eu32 as HRESULT;
pub const TPMAPI_E_INVALID_KEY_SIZE: HRESULT = 0x8029010Fu32 as HRESULT;
pub const TPMAPI_E_ENCRYPTION_FAILED: HRESULT = 0x80290110u32 as HRESULT;
pub const TPMAPI_E_INVALID_KEY_PARAMS: HRESULT = 0x80290111u32 as HRESULT;
pub const TPMAPI_E_INVALID_MIGRATION_AUTHORIZATION_BLOB: HRESULT = 0x80290112u32 as HRESULT;
pub const TPMAPI_E_INVALID_PCR_INDEX: HRESULT = 0x80290113u32 as HRESULT;
pub const TPMAPI_E_INVALID_DELEGATE_BLOB: HRESULT = 0x80290114u32 as HRESULT;
pub const TPMAPI_E_INVALID_CONTEXT_PARAMS: HRESULT = 0x80290115u32 as HRESULT;
pub const TPMAPI_E_INVALID_KEY_BLOB: HRESULT = 0x80290116u32 as HRESULT;
pub const TPMAPI_E_INVALID_PCR_DATA: HRESULT = 0x80290117u32 as HRESULT;
pub const TPMAPI_E_INVALID_OWNER_AUTH: HRESULT = 0x80290118u32 as HRESULT;
pub const TPMAPI_E_FIPS_RNG_CHECK_FAILED: HRESULT = 0x80290119u32 as HRESULT;
pub const TPMAPI_E_EMPTY_TCG_LOG: HRESULT = 0x8029011Au32 as HRESULT;
pub const TPMAPI_E_INVALID_TCG_LOG_ENTRY: HRESULT = 0x8029011Bu32 as HRESULT;
pub const TPMAPI_E_TCG_SEPARATOR_ABSENT: HRESULT = 0x8029011Cu32 as HRESULT;
pub const TPMAPI_E_TCG_INVALID_DIGEST_ENTRY: HRESULT = 0x8029011Du32 as HRESULT;
pub const TPMAPI_E_POLICY_DENIES_OPERATION: HRESULT = 0x8029011Eu32 as HRESULT;
pub const TBSIMP_E_BUFFER_TOO_SMALL: HRESULT = 0x80290200u32 as HRESULT;
pub const TBSIMP_E_CLEANUP_FAILED: HRESULT = 0x80290201u32 as HRESULT;
pub const TBSIMP_E_INVALID_CONTEXT_HANDLE: HRESULT = 0x80290202u32 as HRESULT;
pub const TBSIMP_E_INVALID_CONTEXT_PARAM: HRESULT = 0x80290203u32 as HRESULT;
pub const TBSIMP_E_TPM_ERROR: HRESULT = 0x80290204u32 as HRESULT;
pub const TBSIMP_E_HASH_BAD_KEY: HRESULT = 0x80290205u32 as HRESULT;
pub const TBSIMP_E_DUPLICATE_VHANDLE: HRESULT = 0x80290206u32 as HRESULT;
pub const TBSIMP_E_INVALID_OUTPUT_POINTER: HRESULT = 0x80290207u32 as HRESULT;
pub const TBSIMP_E_INVALID_PARAMETER: HRESULT = 0x80290208u32 as HRESULT;
pub const TBSIMP_E_RPC_INIT_FAILED: HRESULT = 0x80290209u32 as HRESULT;
pub const TBSIMP_E_SCHEDULER_NOT_RUNNING: HRESULT = 0x8029020Au32 as HRESULT;
pub const TBSIMP_E_COMMAND_CANCELED: HRESULT = 0x8029020Bu32 as HRESULT;
pub const TBSIMP_E_OUT_OF_MEMORY: HRESULT = 0x8029020Cu32 as HRESULT;
pub const TBSIMP_E_LIST_NO_MORE_ITEMS: HRESULT = 0x8029020Du32 as HRESULT;
pub const TBSIMP_E_LIST_NOT_FOUND: HRESULT = 0x8029020Eu32 as HRESULT;
pub const TBSIMP_E_NOT_ENOUGH_SPACE: HRESULT = 0x8029020Fu32 as HRESULT;
pub const TBSIMP_E_NOT_ENOUGH_TPM_CONTEXTS: HRESULT = 0x80290210u32 as HRESULT;
pub const TBSIMP_E_COMMAND_FAILED: HRESULT = 0x80290211u32 as HRESULT;
pub const TBSIMP_E_UNKNOWN_ORDINAL: HRESULT = 0x80290212u32 as HRESULT;
pub const TBSIMP_E_RESOURCE_EXPIRED: HRESULT = 0x80290213u32 as HRESULT;
pub const TBSIMP_E_INVALID_RESOURCE: HRESULT = 0x80290214u32 as HRESULT;
pub const TBSIMP_E_NOTHING_TO_UNLOAD: HRESULT = 0x80290215u32 as HRESULT;
pub const TBSIMP_E_HASH_TABLE_FULL: HRESULT = 0x80290216u32 as HRESULT;
pub const TBSIMP_E_TOO_MANY_TBS_CONTEXTS: HRESULT = 0x80290217u32 as HRESULT;
pub const TBSIMP_E_TOO_MANY_RESOURCES: HRESULT = 0x80290218u32 as HRESULT;
pub const TBSIMP_E_PPI_NOT_SUPPORTED: HRESULT = 0x80290219u32 as HRESULT;
pub const TBSIMP_E_TPM_INCOMPATIBLE: HRESULT = 0x8029021Au32 as HRESULT;
pub const TBSIMP_E_NO_EVENT_LOG: HRESULT = 0x8029021Bu32 as HRESULT;
pub const TPM_E_PPI_ACPI_FAILURE: HRESULT = 0x80290300u32 as HRESULT;
pub const TPM_E_PPI_USER_ABORT: HRESULT = 0x80290301u32 as HRESULT;
pub const TPM_E_PPI_BIOS_FAILURE: HRESULT = 0x80290302u32 as HRESULT;
pub const TPM_E_PPI_NOT_SUPPORTED: HRESULT = 0x80290303u32 as HRESULT;
pub const TPM_E_PPI_BLOCKED_IN_BIOS: HRESULT = 0x80290304u32 as HRESULT;
pub const TPM_E_PCP_ERROR_MASK: HRESULT = 0x80290400u32 as HRESULT;
pub const TPM_E_PCP_DEVICE_NOT_READY: HRESULT = 0x80290401u32 as HRESULT;
pub const TPM_E_PCP_INVALID_HANDLE: HRESULT = 0x80290402u32 as HRESULT;
pub const TPM_E_PCP_INVALID_PARAMETER: HRESULT = 0x80290403u32 as HRESULT;
pub const TPM_E_PCP_FLAG_NOT_SUPPORTED: HRESULT = 0x80290404u32 as HRESULT;
pub const TPM_E_PCP_NOT_SUPPORTED: HRESULT = 0x80290405u32 as HRESULT;
pub const TPM_E_PCP_BUFFER_TOO_SMALL: HRESULT = 0x80290406u32 as HRESULT;
pub const TPM_E_PCP_INTERNAL_ERROR: HRESULT = 0x80290407u32 as HRESULT;
pub const TPM_E_PCP_AUTHENTICATION_FAILED: HRESULT = 0x80290408u32 as HRESULT;
pub const TPM_E_PCP_AUTHENTICATION_IGNORED: HRESULT = 0x80290409u32 as HRESULT;
pub const TPM_E_PCP_POLICY_NOT_FOUND: HRESULT = 0x8029040Au32 as HRESULT;
pub const TPM_E_PCP_PROFILE_NOT_FOUND: HRESULT = 0x8029040Bu32 as HRESULT;
pub const TPM_E_PCP_VALIDATION_FAILED: HRESULT = 0x8029040Cu32 as HRESULT;
pub const PLA_E_DCS_NOT_FOUND: HRESULT = 0x80300002u32 as HRESULT;
pub const PLA_E_DCS_IN_USE: HRESULT = 0x803000AAu32 as HRESULT;
pub const PLA_E_TOO_MANY_FOLDERS: HRESULT = 0x80300045u32 as HRESULT;
pub const PLA_E_NO_MIN_DISK: HRESULT = 0x80300070u32 as HRESULT;
pub const PLA_E_DCS_ALREADY_EXISTS: HRESULT = 0x803000B7u32 as HRESULT;
pub const PLA_S_PROPERTY_IGNORED: HRESULT = 0x00300100;
pub const PLA_E_PROPERTY_CONFLICT: HRESULT = 0x80300101u32 as HRESULT;
pub const PLA_E_DCS_SINGLETON_REQUIRED: HRESULT = 0x80300102u32 as HRESULT;
pub const PLA_E_CREDENTIALS_REQUIRED: HRESULT = 0x80300103u32 as HRESULT;
pub const PLA_E_DCS_NOT_RUNNING: HRESULT = 0x80300104u32 as HRESULT;
pub const PLA_E_CONFLICT_INCL_EXCL_API: HRESULT = 0x80300105u32 as HRESULT;
pub const PLA_E_NETWORK_EXE_NOT_VALID: HRESULT = 0x80300106u32 as HRESULT;
pub const PLA_E_EXE_ALREADY_CONFIGURED: HRESULT = 0x80300107u32 as HRESULT;
pub const PLA_E_EXE_PATH_NOT_VALID: HRESULT = 0x80300108u32 as HRESULT;
pub const PLA_E_DC_ALREADY_EXISTS: HRESULT = 0x80300109u32 as HRESULT;
pub const PLA_E_DCS_START_WAIT_TIMEOUT: HRESULT = 0x8030010Au32 as HRESULT;
pub const PLA_E_DC_START_WAIT_TIMEOUT: HRESULT = 0x8030010Bu32 as HRESULT;
pub const PLA_E_REPORT_WAIT_TIMEOUT: HRESULT = 0x8030010Cu32 as HRESULT;
pub const PLA_E_NO_DUPLICATES: HRESULT = 0x8030010Du32 as HRESULT;
pub const PLA_E_EXE_FULL_PATH_REQUIRED: HRESULT = 0x8030010Eu32 as HRESULT;
pub const PLA_E_INVALID_SESSION_NAME: HRESULT = 0x8030010Fu32 as HRESULT;
pub const PLA_E_PLA_CHANNEL_NOT_ENABLED: HRESULT = 0x80300110u32 as HRESULT;
pub const PLA_E_TASKSCHED_CHANNEL_NOT_ENABLED: HRESULT = 0x80300111u32 as HRESULT;
pub const PLA_E_RULES_MANAGER_FAILED: HRESULT = 0x80300112u32 as HRESULT;
pub const PLA_E_CABAPI_FAILURE: HRESULT = 0x80300113u32 as HRESULT;
pub const FVE_E_LOCKED_VOLUME: HRESULT = 0x80310000u32 as HRESULT;
pub const FVE_E_NOT_ENCRYPTED: HRESULT = 0x80310001u32 as HRESULT;
pub const FVE_E_NO_TPM_BIOS: HRESULT = 0x80310002u32 as HRESULT;
pub const FVE_E_NO_MBR_METRIC: HRESULT = 0x80310003u32 as HRESULT;
pub const FVE_E_NO_BOOTSECTOR_METRIC: HRESULT = 0x80310004u32 as HRESULT;
pub const FVE_E_NO_BOOTMGR_METRIC: HRESULT = 0x80310005u32 as HRESULT;
pub const FVE_E_WRONG_BOOTMGR: HRESULT = 0x80310006u32 as HRESULT;
pub const FVE_E_SECURE_KEY_REQUIRED: HRESULT = 0x80310007u32 as HRESULT;
pub const FVE_E_NOT_ACTIVATED: HRESULT = 0x80310008u32 as HRESULT;
pub const FVE_E_ACTION_NOT_ALLOWED: HRESULT = 0x80310009u32 as HRESULT;
pub const FVE_E_AD_SCHEMA_NOT_INSTALLED: HRESULT = 0x8031000Au32 as HRESULT;
pub const FVE_E_AD_INVALID_DATATYPE: HRESULT = 0x8031000Bu32 as HRESULT;
pub const FVE_E_AD_INVALID_DATASIZE: HRESULT = 0x8031000Cu32 as HRESULT;
pub const FVE_E_AD_NO_VALUES: HRESULT = 0x8031000Du32 as HRESULT;
pub const FVE_E_AD_ATTR_NOT_SET: HRESULT = 0x8031000Eu32 as HRESULT;
pub const FVE_E_AD_GUID_NOT_FOUND: HRESULT = 0x8031000Fu32 as HRESULT;
pub const FVE_E_BAD_INFORMATION: HRESULT = 0x80310010u32 as HRESULT;
pub const FVE_E_TOO_SMALL: HRESULT = 0x80310011u32 as HRESULT;
pub const FVE_E_SYSTEM_VOLUME: HRESULT = 0x80310012u32 as HRESULT;
pub const FVE_E_FAILED_WRONG_FS: HRESULT = 0x80310013u32 as HRESULT;
pub const FVE_E_BAD_PARTITION_SIZE: HRESULT = 0x80310014u32 as HRESULT;
pub const FVE_E_NOT_SUPPORTED: HRESULT = 0x80310015u32 as HRESULT;
pub const FVE_E_BAD_DATA: HRESULT = 0x80310016u32 as HRESULT;
pub const FVE_E_VOLUME_NOT_BOUND: HRESULT = 0x80310017u32 as HRESULT;
pub const FVE_E_TPM_NOT_OWNED: HRESULT = 0x80310018u32 as HRESULT;
pub const FVE_E_NOT_DATA_VOLUME: HRESULT = 0x80310019u32 as HRESULT;
pub const FVE_E_AD_INSUFFICIENT_BUFFER: HRESULT = 0x8031001Au32 as HRESULT;
pub const FVE_E_CONV_READ: HRESULT = 0x8031001Bu32 as HRESULT;
pub const FVE_E_CONV_WRITE: HRESULT = 0x8031001Cu32 as HRESULT;
pub const FVE_E_KEY_REQUIRED: HRESULT = 0x8031001Du32 as HRESULT;
pub const FVE_E_CLUSTERING_NOT_SUPPORTED: HRESULT = 0x8031001Eu32 as HRESULT;
pub const FVE_E_VOLUME_BOUND_ALREADY: HRESULT = 0x8031001Fu32 as HRESULT;
pub const FVE_E_OS_NOT_PROTECTED: HRESULT = 0x80310020u32 as HRESULT;
pub const FVE_E_PROTECTION_DISABLED: HRESULT = 0x80310021u32 as HRESULT;
pub const FVE_E_RECOVERY_KEY_REQUIRED: HRESULT = 0x80310022u32 as HRESULT;
pub const FVE_E_FOREIGN_VOLUME: HRESULT = 0x80310023u32 as HRESULT;
pub const FVE_E_OVERLAPPED_UPDATE: HRESULT = 0x80310024u32 as HRESULT;
pub const FVE_E_TPM_SRK_AUTH_NOT_ZERO: HRESULT = 0x80310025u32 as HRESULT;
pub const FVE_E_FAILED_SECTOR_SIZE: HRESULT = 0x80310026u32 as HRESULT;
pub const FVE_E_FAILED_AUTHENTICATION: HRESULT = 0x80310027u32 as HRESULT;
pub const FVE_E_NOT_OS_VOLUME: HRESULT = 0x80310028u32 as HRESULT;
pub const FVE_E_AUTOUNLOCK_ENABLED: HRESULT = 0x80310029u32 as HRESULT;
pub const FVE_E_WRONG_BOOTSECTOR: HRESULT = 0x8031002Au32 as HRESULT;
pub const FVE_E_WRONG_SYSTEM_FS: HRESULT = 0x8031002Bu32 as HRESULT;
pub const FVE_E_POLICY_PASSWORD_REQUIRED: HRESULT = 0x8031002Cu32 as HRESULT;
pub const FVE_E_CANNOT_SET_FVEK_ENCRYPTED: HRESULT = 0x8031002Du32 as HRESULT;
pub const FVE_E_CANNOT_ENCRYPT_NO_KEY: HRESULT = 0x8031002Eu32 as HRESULT;
pub const FVE_E_BOOTABLE_CDDVD: HRESULT = 0x80310030u32 as HRESULT;
pub const FVE_E_PROTECTOR_EXISTS: HRESULT = 0x80310031u32 as HRESULT;
pub const FVE_E_RELATIVE_PATH: HRESULT = 0x80310032u32 as HRESULT;
pub const FVE_E_PROTECTOR_NOT_FOUND: HRESULT = 0x80310033u32 as HRESULT;
pub const FVE_E_INVALID_KEY_FORMAT: HRESULT = 0x80310034u32 as HRESULT;
pub const FVE_E_INVALID_PASSWORD_FORMAT: HRESULT = 0x80310035u32 as HRESULT;
pub const FVE_E_FIPS_RNG_CHECK_FAILED: HRESULT = 0x80310036u32 as HRESULT;
pub const FVE_E_FIPS_PREVENTS_RECOVERY_PASSWORD: HRESULT = 0x80310037u32 as HRESULT;
pub const FVE_E_FIPS_PREVENTS_EXTERNAL_KEY_EXPORT: HRESULT = 0x80310038u32 as HRESULT;
pub const FVE_E_NOT_DECRYPTED: HRESULT = 0x80310039u32 as HRESULT;
pub const FVE_E_INVALID_PROTECTOR_TYPE: HRESULT = 0x8031003Au32 as HRESULT;
pub const FVE_E_NO_PROTECTORS_TO_TEST: HRESULT = 0x8031003Bu32 as HRESULT;
pub const FVE_E_KEYFILE_NOT_FOUND: HRESULT = 0x8031003Cu32 as HRESULT;
pub const FVE_E_KEYFILE_INVALID: HRESULT = 0x8031003Du32 as HRESULT;
pub const FVE_E_KEYFILE_NO_VMK: HRESULT = 0x8031003Eu32 as HRESULT;
pub const FVE_E_TPM_DISABLED: HRESULT = 0x8031003Fu32 as HRESULT;
pub const FVE_E_NOT_ALLOWED_IN_SAFE_MODE: HRESULT = 0x80310040u32 as HRESULT;
pub const FVE_E_TPM_INVALID_PCR: HRESULT = 0x80310041u32 as HRESULT;
pub const FVE_E_TPM_NO_VMK: HRESULT = 0x80310042u32 as HRESULT;
pub const FVE_E_PIN_INVALID: HRESULT = 0x80310043u32 as HRESULT;
pub const FVE_E_AUTH_INVALID_APPLICATION: HRESULT = 0x80310044u32 as HRESULT;
pub const FVE_E_AUTH_INVALID_CONFIG: HRESULT = 0x80310045u32 as HRESULT;
pub const FVE_E_FIPS_DISABLE_PROTECTION_NOT_ALLOWED: HRESULT = 0x80310046u32 as HRESULT;
pub const FVE_E_FS_NOT_EXTENDED: HRESULT = 0x80310047u32 as HRESULT;
pub const FVE_E_FIRMWARE_TYPE_NOT_SUPPORTED: HRESULT = 0x80310048u32 as HRESULT;
pub const FVE_E_NO_LICENSE: HRESULT = 0x80310049u32 as HRESULT;
pub const FVE_E_NOT_ON_STACK: HRESULT = 0x8031004Au32 as HRESULT;
pub const FVE_E_FS_MOUNTED: HRESULT = 0x8031004Bu32 as HRESULT;
pub const FVE_E_TOKEN_NOT_IMPERSONATED: HRESULT = 0x8031004Cu32 as HRESULT;
pub const FVE_E_DRY_RUN_FAILED: HRESULT = 0x8031004Du32 as HRESULT;
pub const FVE_E_REBOOT_REQUIRED: HRESULT = 0x8031004Eu32 as HRESULT;
pub const FVE_E_DEBUGGER_ENABLED: HRESULT = 0x8031004Fu32 as HRESULT;
pub const FVE_E_RAW_ACCESS: HRESULT = 0x80310050u32 as HRESULT;
pub const FVE_E_RAW_BLOCKED: HRESULT = 0x80310051u32 as HRESULT;
pub const FVE_E_BCD_APPLICATIONS_PATH_INCORRECT: HRESULT = 0x80310052u32 as HRESULT;
pub const FVE_E_NOT_ALLOWED_IN_VERSION: HRESULT = 0x80310053u32 as HRESULT;
pub const FVE_E_NO_AUTOUNLOCK_MASTER_KEY: HRESULT = 0x80310054u32 as HRESULT;
pub const FVE_E_MOR_FAILED: HRESULT = 0x80310055u32 as HRESULT;
pub const FVE_E_HIDDEN_VOLUME: HRESULT = 0x80310056u32 as HRESULT;
pub const FVE_E_TRANSIENT_STATE: HRESULT = 0x80310057u32 as HRESULT;
pub const FVE_E_PUBKEY_NOT_ALLOWED: HRESULT = 0x80310058u32 as HRESULT;
pub const FVE_E_VOLUME_HANDLE_OPEN: HRESULT = 0x80310059u32 as HRESULT;
pub const FVE_E_NO_FEATURE_LICENSE: HRESULT = 0x8031005Au32 as HRESULT;
pub const FVE_E_INVALID_STARTUP_OPTIONS: HRESULT = 0x8031005Bu32 as HRESULT;
pub const FVE_E_POLICY_RECOVERY_PASSWORD_NOT_ALLOWED: HRESULT = 0x8031005Cu32 as HRESULT;
pub const FVE_E_POLICY_RECOVERY_PASSWORD_REQUIRED: HRESULT = 0x8031005Du32 as HRESULT;
pub const FVE_E_POLICY_RECOVERY_KEY_NOT_ALLOWED: HRESULT = 0x8031005Eu32 as HRESULT;
pub const FVE_E_POLICY_RECOVERY_KEY_REQUIRED: HRESULT = 0x8031005Fu32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_PIN_NOT_ALLOWED: HRESULT = 0x80310060u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_PIN_REQUIRED: HRESULT = 0x80310061u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_KEY_NOT_ALLOWED: HRESULT = 0x80310062u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_KEY_REQUIRED: HRESULT = 0x80310063u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_PIN_KEY_NOT_ALLOWED: HRESULT = 0x80310064u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_PIN_KEY_REQUIRED: HRESULT = 0x80310065u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_TPM_NOT_ALLOWED: HRESULT = 0x80310066u32 as HRESULT;
pub const FVE_E_POLICY_STARTUP_TPM_REQUIRED: HRESULT = 0x80310067u32 as HRESULT;
pub const FVE_E_POLICY_INVALID_PIN_LENGTH: HRESULT = 0x80310068u32 as HRESULT;
pub const FVE_E_KEY_PROTECTOR_NOT_SUPPORTED: HRESULT = 0x80310069u32 as HRESULT;
pub const FVE_E_POLICY_PASSPHRASE_NOT_ALLOWED: HRESULT = 0x8031006Au32 as HRESULT;
pub const FVE_E_POLICY_PASSPHRASE_REQUIRED: HRESULT = 0x8031006Bu32 as HRESULT;
pub const FVE_E_FIPS_PREVENTS_PASSPHRASE: HRESULT = 0x8031006Cu32 as HRESULT;
pub const FVE_E_OS_VOLUME_PASSPHRASE_NOT_ALLOWED: HRESULT = 0x8031006Du32 as HRESULT;
pub const FVE_E_INVALID_BITLOCKER_OID: HRESULT = 0x8031006Eu32 as HRESULT;
pub const FVE_E_VOLUME_TOO_SMALL: HRESULT = 0x8031006Fu32 as HRESULT;
pub const FVE_E_DV_NOT_SUPPORTED_ON_FS: HRESULT = 0x80310070u32 as HRESULT;
pub const FVE_E_DV_NOT_ALLOWED_BY_GP: HRESULT = 0x80310071u32 as HRESULT;
pub const FVE_E_POLICY_USER_CERTIFICATE_NOT_ALLOWED: HRESULT = 0x80310072u32 as HRESULT;
pub const FVE_E_POLICY_USER_CERTIFICATE_REQUIRED: HRESULT = 0x80310073u32 as HRESULT;
pub const FVE_E_POLICY_USER_CERT_MUST_BE_HW: HRESULT = 0x80310074u32 as HRESULT;
pub const FVE_E_POLICY_USER_CONFIGURE_FDV_AUTOUNLOCK_NOT_ALLOWED: HRESULT = 0x80310075u32 as HRESULT;
pub const FVE_E_POLICY_USER_CONFIGURE_RDV_AUTOUNLOCK_NOT_ALLOWED: HRESULT = 0x80310076u32 as HRESULT;
pub const FVE_E_POLICY_USER_CONFIGURE_RDV_NOT_ALLOWED: HRESULT = 0x80310077u32 as HRESULT;
pub const FVE_E_POLICY_USER_ENABLE_RDV_NOT_ALLOWED: HRESULT = 0x80310078u32 as HRESULT;
pub const FVE_E_POLICY_USER_DISABLE_RDV_NOT_ALLOWED: HRESULT = 0x80310079u32 as HRESULT;
pub const FVE_E_POLICY_INVALID_PASSPHRASE_LENGTH: HRESULT = 0x80310080u32 as HRESULT;
pub const FVE_E_POLICY_PASSPHRASE_TOO_SIMPLE: HRESULT = 0x80310081u32 as HRESULT;
pub const FVE_E_RECOVERY_PARTITION: HRESULT = 0x80310082u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_FDV_RK_OFF_AUK_ON: HRESULT = 0x80310083u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_RDV_RK_OFF_AUK_ON: HRESULT = 0x80310084u32 as HRESULT;
pub const FVE_E_NON_BITLOCKER_OID: HRESULT = 0x80310085u32 as HRESULT;
pub const FVE_E_POLICY_PROHIBITS_SELFSIGNED: HRESULT = 0x80310086u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_RO_AND_STARTUP_KEY_REQUIRED: HRESULT = 0x80310087u32 as HRESULT;
pub const FVE_E_CONV_RECOVERY_FAILED: HRESULT = 0x80310088u32 as HRESULT;
pub const FVE_E_VIRTUALIZED_SPACE_TOO_BIG: HRESULT = 0x80310089u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_OSV_RP_OFF_ADB_ON: HRESULT = 0x80310090u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_FDV_RP_OFF_ADB_ON: HRESULT = 0x80310091u32 as HRESULT;
pub const FVE_E_POLICY_CONFLICT_RDV_RP_OFF_ADB_ON: HRESULT = 0x80310092u32 as HRESULT;
pub const FVE_E_NON_BITLOCKER_KU: HRESULT = 0x80310093u32 as HRESULT;
pub const FVE_E_PRIVATEKEY_AUTH_FAILED: HRESULT = 0x80310094u32 as HRESULT;
pub const FVE_E_REMOVAL_OF_DRA_FAILED: HRESULT = 0x80310095u32 as HRESULT;
pub const FVE_E_OPERATION_NOT_SUPPORTED_ON_VISTA_VOLUME: HRESULT = 0x80310096u32 as HRESULT;
pub const FVE_E_CANT_LOCK_AUTOUNLOCK_ENABLED_VOLUME: HRESULT = 0x80310097u32 as HRESULT;
pub const FVE_E_FIPS_HASH_KDF_NOT_ALLOWED: HRESULT = 0x80310098u32 as HRESULT;
pub const FVE_E_ENH_PIN_INVALID: HRESULT = 0x80310099u32 as HRESULT;
pub const FVE_E_INVALID_PIN_CHARS: HRESULT = 0x8031009Au32 as HRESULT;
pub const FVE_E_INVALID_DATUM_TYPE: HRESULT = 0x8031009Bu32 as HRESULT;
pub const FVE_E_EFI_ONLY: HRESULT = 0x8031009Cu32 as HRESULT;
pub const FVE_E_MULTIPLE_NKP_CERTS: HRESULT = 0x8031009Du32 as HRESULT;
pub const FVE_E_REMOVAL_OF_NKP_FAILED: HRESULT = 0x8031009Eu32 as HRESULT;
pub const FVE_E_INVALID_NKP_CERT: HRESULT = 0x8031009Fu32 as HRESULT;
pub const FVE_E_NO_EXISTING_PIN: HRESULT = 0x803100A0u32 as HRESULT;
pub const FVE_E_PROTECTOR_CHANGE_PIN_MISMATCH: HRESULT = 0x803100A1u32 as HRESULT;
pub const FVE_E_PIN_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED: HRESULT = 0x803100A2u32 as HRESULT;
pub const FVE_E_PROTECTOR_CHANGE_MAX_PIN_CHANGE_ATTEMPTS_REACHED: HRESULT = 0x803100A3u32 as HRESULT;
pub const FVE_E_POLICY_PASSPHRASE_REQUIRES_ASCII: HRESULT = 0x803100A4u32 as HRESULT;
pub const FVE_E_FULL_ENCRYPTION_NOT_ALLOWED_ON_TP_STORAGE: HRESULT = 0x803100A5u32 as HRESULT;
pub const FVE_E_WIPE_NOT_ALLOWED_ON_TP_STORAGE: HRESULT = 0x803100A6u32 as HRESULT;
pub const FVE_E_KEY_LENGTH_NOT_SUPPORTED_BY_EDRIVE: HRESULT = 0x803100A7u32 as HRESULT;
pub const FVE_E_NO_EXISTING_PASSPHRASE: HRESULT = 0x803100A8u32 as HRESULT;
pub const FVE_E_PROTECTOR_CHANGE_PASSPHRASE_MISMATCH: HRESULT = 0x803100A9u32 as HRESULT;
pub const FVE_E_PASSPHRASE_TOO_LONG: HRESULT = 0x803100AAu32 as HRESULT;
pub const FVE_E_NO_PASSPHRASE_WITH_TPM: HRESULT = 0x803100ABu32 as HRESULT;
pub const FVE_E_NO_TPM_WITH_PASSPHRASE: HRESULT = 0x803100ACu32 as HRESULT;
pub const FVE_E_NOT_ALLOWED_ON_CSV_STACK: HRESULT = 0x803100ADu32 as HRESULT;
pub const FVE_E_NOT_ALLOWED_ON_CLUSTER: HRESULT = 0x803100AEu32 as HRESULT;
pub const FVE_E_EDRIVE_NO_FAILOVER_TO_SW: HRESULT = 0x803100AFu32 as HRESULT;
pub const FVE_E_EDRIVE_BAND_IN_USE: HRESULT = 0x803100B0u32 as HRESULT;
pub const FVE_E_EDRIVE_DISALLOWED_BY_GP: HRESULT = 0x803100B1u32 as HRESULT;
pub const FVE_E_EDRIVE_INCOMPATIBLE_VOLUME: HRESULT = 0x803100B2u32 as HRESULT;
pub const FVE_E_NOT_ALLOWED_TO_UPGRADE_WHILE_CONVERTING: HRESULT = 0x803100B3u32 as HRESULT;
pub const FVE_E_EDRIVE_DV_NOT_SUPPORTED: HRESULT = 0x803100B4u32 as HRESULT;
pub const FVE_E_NO_PREBOOT_KEYBOARD_DETECTED: HRESULT = 0x803100B5u32 as HRESULT;
pub const FVE_E_NO_PREBOOT_KEYBOARD_OR_WINRE_DETECTED: HRESULT = 0x803100B6u32 as HRESULT;
pub const FVE_E_POLICY_REQUIRES_STARTUP_PIN_ON_TOUCH_DEVICE: HRESULT = 0x803100B7u32 as HRESULT;
pub const FVE_E_POLICY_REQUIRES_RECOVERY_PASSWORD_ON_TOUCH_DEVICE: HRESULT = 0x803100B8u32 as HRESULT;
pub const FVE_E_WIPE_CANCEL_NOT_APPLICABLE: HRESULT = 0x803100B9u32 as HRESULT;
pub const FVE_E_SECUREBOOT_DISABLED: HRESULT = 0x803100BAu32 as HRESULT;
pub const FVE_E_SECUREBOOT_CONFIGURATION_INVALID: HRESULT = 0x803100BBu32 as HRESULT;
pub const FVE_E_EDRIVE_DRY_RUN_FAILED: HRESULT = 0x803100BCu32 as HRESULT;
pub const FVE_E_SHADOW_COPY_PRESENT: HRESULT = 0x803100BDu32 as HRESULT;
pub const FVE_E_POLICY_INVALID_ENHANCED_BCD_SETTINGS: HRESULT = 0x803100BEu32 as HRESULT;
pub const FVE_E_EDRIVE_INCOMPATIBLE_FIRMWARE: HRESULT = 0x803100BFu32 as HRESULT;
pub const FVE_E_PROTECTOR_CHANGE_MAX_PASSPHRASE_CHANGE_ATTEMPTS_REACHED: HRESULT = 0x803100C0u32 as HRESULT;
pub const FVE_E_PASSPHRASE_PROTECTOR_CHANGE_BY_STD_USER_DISALLOWED: HRESULT = 0x803100C1u32 as HRESULT;
pub const FVE_E_LIVEID_ACCOUNT_SUSPENDED: HRESULT = 0x803100C2u32 as HRESULT;
pub const FVE_E_LIVEID_ACCOUNT_BLOCKED: HRESULT = 0x803100C3u32 as HRESULT;
pub const FVE_E_NOT_PROVISIONED_ON_ALL_VOLUMES: HRESULT = 0x803100C4u32 as HRESULT;
pub const FVE_E_DE_FIXED_DATA_NOT_SUPPORTED: HRESULT = 0x803100C5u32 as HRESULT;
pub const FVE_E_DE_HARDWARE_NOT_COMPLIANT: HRESULT = 0x803100C6u32 as HRESULT;
pub const FVE_E_DE_WINRE_NOT_CONFIGURED: HRESULT = 0x803100C7u32 as HRESULT;
pub const FVE_E_DE_PROTECTION_SUSPENDED: HRESULT = 0x803100C8u32 as HRESULT;
pub const FVE_E_DE_OS_VOLUME_NOT_PROTECTED: HRESULT = 0x803100C9u32 as HRESULT;
pub const FVE_E_DE_DEVICE_LOCKEDOUT: HRESULT = 0x803100CAu32 as HRESULT;
pub const FVE_E_DE_PROTECTION_NOT_YET_ENABLED: HRESULT = 0x803100CBu32 as HRESULT;
pub const FVE_E_INVALID_PIN_CHARS_DETAILED: HRESULT = 0x803100CCu32 as HRESULT;
pub const FVE_E_DEVICE_LOCKOUT_COUNTER_UNAVAILABLE: HRESULT = 0x803100CDu32 as HRESULT;
pub const FVE_E_DEVICELOCKOUT_COUNTER_MISMATCH: HRESULT = 0x803100CEu32 as HRESULT;
pub const FVE_E_BUFFER_TOO_LARGE: HRESULT = 0x803100CFu32 as HRESULT;
pub const FVE_E_NO_SUCH_CAPABILITY_ON_TARGET: HRESULT = 0x803100D0u32 as HRESULT;
pub const FVE_E_DE_PREVENTED_FOR_OS: HRESULT = 0x803100D1u32 as HRESULT;
pub const FVE_E_DE_VOLUME_OPTED_OUT: HRESULT = 0x803100D2u32 as HRESULT;
pub const FVE_E_DE_VOLUME_NOT_SUPPORTED: HRESULT = 0x803100D3u32 as HRESULT;
pub const FVE_E_EOW_NOT_SUPPORTED_IN_VERSION: HRESULT = 0x803100D4u32 as HRESULT;
pub const FVE_E_ADBACKUP_NOT_ENABLED: HRESULT = 0x803100D5u32 as HRESULT;
pub const FVE_E_VOLUME_EXTEND_PREVENTS_EOW_DECRYPT: HRESULT = 0x803100D6u32 as HRESULT;
pub const FVE_E_NOT_DE_VOLUME: HRESULT = 0x803100D7u32 as HRESULT;
pub const FVE_E_PROTECTION_CANNOT_BE_DISABLED: HRESULT = 0x803100D8u32 as HRESULT;
pub const FWP_E_CALLOUT_NOT_FOUND: HRESULT = 0x80320001u32 as HRESULT;
pub const FWP_E_CONDITION_NOT_FOUND: HRESULT = 0x80320002u32 as HRESULT;
pub const FWP_E_FILTER_NOT_FOUND: HRESULT = 0x80320003u32 as HRESULT;
pub const FWP_E_LAYER_NOT_FOUND: HRESULT = 0x80320004u32 as HRESULT;
pub const FWP_E_PROVIDER_NOT_FOUND: HRESULT = 0x80320005u32 as HRESULT;
pub const FWP_E_PROVIDER_CONTEXT_NOT_FOUND: HRESULT = 0x80320006u32 as HRESULT;
pub const FWP_E_SUBLAYER_NOT_FOUND: HRESULT = 0x80320007u32 as HRESULT;
pub const FWP_E_NOT_FOUND: HRESULT = 0x80320008u32 as HRESULT;
pub const FWP_E_ALREADY_EXISTS: HRESULT = 0x80320009u32 as HRESULT;
pub const FWP_E_IN_USE: HRESULT = 0x8032000Au32 as HRESULT;
pub const FWP_E_DYNAMIC_SESSION_IN_PROGRESS: HRESULT = 0x8032000Bu32 as HRESULT;
pub const FWP_E_WRONG_SESSION: HRESULT = 0x8032000Cu32 as HRESULT;
pub const FWP_E_NO_TXN_IN_PROGRESS: HRESULT = 0x8032000Du32 as HRESULT;
pub const FWP_E_TXN_IN_PROGRESS: HRESULT = 0x8032000Eu32 as HRESULT;
pub const FWP_E_TXN_ABORTED: HRESULT = 0x8032000Fu32 as HRESULT;
pub const FWP_E_SESSION_ABORTED: HRESULT = 0x80320010u32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_TXN: HRESULT = 0x80320011u32 as HRESULT;
pub const FWP_E_TIMEOUT: HRESULT = 0x80320012u32 as HRESULT;
pub const FWP_E_NET_EVENTS_DISABLED: HRESULT = 0x80320013u32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_LAYER: HRESULT = 0x80320014u32 as HRESULT;
pub const FWP_E_KM_CLIENTS_ONLY: HRESULT = 0x80320015u32 as HRESULT;
pub const FWP_E_LIFETIME_MISMATCH: HRESULT = 0x80320016u32 as HRESULT;
pub const FWP_E_BUILTIN_OBJECT: HRESULT = 0x80320017u32 as HRESULT;
pub const FWP_E_TOO_MANY_CALLOUTS: HRESULT = 0x80320018u32 as HRESULT;
pub const FWP_E_NOTIFICATION_DROPPED: HRESULT = 0x80320019u32 as HRESULT;
pub const FWP_E_TRAFFIC_MISMATCH: HRESULT = 0x8032001Au32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_SA_STATE: HRESULT = 0x8032001Bu32 as HRESULT;
pub const FWP_E_NULL_POINTER: HRESULT = 0x8032001Cu32 as HRESULT;
pub const FWP_E_INVALID_ENUMERATOR: HRESULT = 0x8032001Du32 as HRESULT;
pub const FWP_E_INVALID_FLAGS: HRESULT = 0x8032001Eu32 as HRESULT;
pub const FWP_E_INVALID_NET_MASK: HRESULT = 0x8032001Fu32 as HRESULT;
pub const FWP_E_INVALID_RANGE: HRESULT = 0x80320020u32 as HRESULT;
pub const FWP_E_INVALID_INTERVAL: HRESULT = 0x80320021u32 as HRESULT;
pub const FWP_E_ZERO_LENGTH_ARRAY: HRESULT = 0x80320022u32 as HRESULT;
pub const FWP_E_NULL_DISPLAY_NAME: HRESULT = 0x80320023u32 as HRESULT;
pub const FWP_E_INVALID_ACTION_TYPE: HRESULT = 0x80320024u32 as HRESULT;
pub const FWP_E_INVALID_WEIGHT: HRESULT = 0x80320025u32 as HRESULT;
pub const FWP_E_MATCH_TYPE_MISMATCH: HRESULT = 0x80320026u32 as HRESULT;
pub const FWP_E_TYPE_MISMATCH: HRESULT = 0x80320027u32 as HRESULT;
pub const FWP_E_OUT_OF_BOUNDS: HRESULT = 0x80320028u32 as HRESULT;
pub const FWP_E_RESERVED: HRESULT = 0x80320029u32 as HRESULT;
pub const FWP_E_DUPLICATE_CONDITION: HRESULT = 0x8032002Au32 as HRESULT;
pub const FWP_E_DUPLICATE_KEYMOD: HRESULT = 0x8032002Bu32 as HRESULT;
pub const FWP_E_ACTION_INCOMPATIBLE_WITH_LAYER: HRESULT = 0x8032002Cu32 as HRESULT;
pub const FWP_E_ACTION_INCOMPATIBLE_WITH_SUBLAYER: HRESULT = 0x8032002Du32 as HRESULT;
pub const FWP_E_CONTEXT_INCOMPATIBLE_WITH_LAYER: HRESULT = 0x8032002Eu32 as HRESULT;
pub const FWP_E_CONTEXT_INCOMPATIBLE_WITH_CALLOUT: HRESULT = 0x8032002Fu32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_AUTH_METHOD: HRESULT = 0x80320030u32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_DH_GROUP: HRESULT = 0x80320031u32 as HRESULT;
pub const FWP_E_EM_NOT_SUPPORTED: HRESULT = 0x80320032u32 as HRESULT;
pub const FWP_E_NEVER_MATCH: HRESULT = 0x80320033u32 as HRESULT;
pub const FWP_E_PROVIDER_CONTEXT_MISMATCH: HRESULT = 0x80320034u32 as HRESULT;
pub const FWP_E_INVALID_PARAMETER: HRESULT = 0x80320035u32 as HRESULT;
pub const FWP_E_TOO_MANY_SUBLAYERS: HRESULT = 0x80320036u32 as HRESULT;
pub const FWP_E_CALLOUT_NOTIFICATION_FAILED: HRESULT = 0x80320037u32 as HRESULT;
pub const FWP_E_INVALID_AUTH_TRANSFORM: HRESULT = 0x80320038u32 as HRESULT;
pub const FWP_E_INVALID_CIPHER_TRANSFORM: HRESULT = 0x80320039u32 as HRESULT;
pub const FWP_E_INCOMPATIBLE_CIPHER_TRANSFORM: HRESULT = 0x8032003Au32 as HRESULT;
pub const FWP_E_INVALID_TRANSFORM_COMBINATION: HRESULT = 0x8032003Bu32 as HRESULT;
pub const FWP_E_DUPLICATE_AUTH_METHOD: HRESULT = 0x8032003Cu32 as HRESULT;
pub const FWP_E_INVALID_TUNNEL_ENDPOINT: HRESULT = 0x8032003Du32 as HRESULT;
pub const FWP_E_L2_DRIVER_NOT_READY: HRESULT = 0x8032003Eu32 as HRESULT;
pub const FWP_E_KEY_DICTATOR_ALREADY_REGISTERED: HRESULT = 0x8032003Fu32 as HRESULT;
pub const FWP_E_KEY_DICTATION_INVALID_KEYING_MATERIAL: HRESULT = 0x80320040u32 as HRESULT;
pub const FWP_E_CONNECTIONS_DISABLED: HRESULT = 0x80320041u32 as HRESULT;
pub const FWP_E_INVALID_DNS_NAME: HRESULT = 0x80320042u32 as HRESULT;
pub const FWP_E_STILL_ON: HRESULT = 0x80320043u32 as HRESULT;
pub const FWP_E_IKEEXT_NOT_RUNNING: HRESULT = 0x80320044u32 as HRESULT;
pub const FWP_E_DROP_NOICMP: HRESULT = 0x80320104u32 as HRESULT;
pub const WS_S_ASYNC: HRESULT = 0x003D0000;
pub const WS_S_END: HRESULT = 0x003D0001;
pub const WS_E_INVALID_FORMAT: HRESULT = 0x803D0000u32 as HRESULT;
pub const WS_E_OBJECT_FAULTED: HRESULT = 0x803D0001u32 as HRESULT;
pub const WS_E_NUMERIC_OVERFLOW: HRESULT = 0x803D0002u32 as HRESULT;
pub const WS_E_INVALID_OPERATION: HRESULT = 0x803D0003u32 as HRESULT;
pub const WS_E_OPERATION_ABORTED: HRESULT = 0x803D0004u32 as HRESULT;
pub const WS_E_ENDPOINT_ACCESS_DENIED: HRESULT = 0x803D0005u32 as HRESULT;
pub const WS_E_OPERATION_TIMED_OUT: HRESULT = 0x803D0006u32 as HRESULT;
pub const WS_E_OPERATION_ABANDONED: HRESULT = 0x803D0007u32 as HRESULT;
pub const WS_E_QUOTA_EXCEEDED: HRESULT = 0x803D0008u32 as HRESULT;
pub const WS_E_NO_TRANSLATION_AVAILABLE: HRESULT = 0x803D0009u32 as HRESULT;
pub const WS_E_SECURITY_VERIFICATION_FAILURE: HRESULT = 0x803D000Au32 as HRESULT;
pub const WS_E_ADDRESS_IN_USE: HRESULT = 0x803D000Bu32 as HRESULT;
pub const WS_E_ADDRESS_NOT_AVAILABLE: HRESULT = 0x803D000Cu32 as HRESULT;
pub const WS_E_ENDPOINT_NOT_FOUND: HRESULT = 0x803D000Du32 as HRESULT;
pub const WS_E_ENDPOINT_NOT_AVAILABLE: HRESULT = 0x803D000Eu32 as HRESULT;
pub const WS_E_ENDPOINT_FAILURE: HRESULT = 0x803D000Fu32 as HRESULT;
pub const WS_E_ENDPOINT_UNREACHABLE: HRESULT = 0x803D0010u32 as HRESULT;
pub const WS_E_ENDPOINT_ACTION_NOT_SUPPORTED: HRESULT = 0x803D0011u32 as HRESULT;
pub const WS_E_ENDPOINT_TOO_BUSY: HRESULT = 0x803D0012u32 as HRESULT;
pub const WS_E_ENDPOINT_FAULT_RECEIVED: HRESULT = 0x803D0013u32 as HRESULT;
pub const WS_E_ENDPOINT_DISCONNECTED: HRESULT = 0x803D0014u32 as HRESULT;
pub const WS_E_PROXY_FAILURE: HRESULT = 0x803D0015u32 as HRESULT;
pub const WS_E_PROXY_ACCESS_DENIED: HRESULT = 0x803D0016u32 as HRESULT;
pub const WS_E_NOT_SUPPORTED: HRESULT = 0x803D0017u32 as HRESULT;
pub const WS_E_PROXY_REQUIRES_BASIC_AUTH: HRESULT = 0x803D0018u32 as HRESULT;
pub const WS_E_PROXY_REQUIRES_DIGEST_AUTH: HRESULT = 0x803D0019u32 as HRESULT;
pub const WS_E_PROXY_REQUIRES_NTLM_AUTH: HRESULT = 0x803D001Au32 as HRESULT;
pub const WS_E_PROXY_REQUIRES_NEGOTIATE_AUTH: HRESULT = 0x803D001Bu32 as HRESULT;
pub const WS_E_SERVER_REQUIRES_BASIC_AUTH: HRESULT = 0x803D001Cu32 as HRESULT;
pub const WS_E_SERVER_REQUIRES_DIGEST_AUTH: HRESULT = 0x803D001Du32 as HRESULT;
pub const WS_E_SERVER_REQUIRES_NTLM_AUTH: HRESULT = 0x803D001Eu32 as HRESULT;
pub const WS_E_SERVER_REQUIRES_NEGOTIATE_AUTH: HRESULT = 0x803D001Fu32 as HRESULT;
pub const WS_E_INVALID_ENDPOINT_URL: HRESULT = 0x803D0020u32 as HRESULT;
pub const WS_E_OTHER: HRESULT = 0x803D0021u32 as HRESULT;
pub const WS_E_SECURITY_TOKEN_EXPIRED: HRESULT = 0x803D0022u32 as HRESULT;
pub const WS_E_SECURITY_SYSTEM_FAILURE: HRESULT = 0x803D0023u32 as HRESULT;
pub const ERROR_NDIS_INTERFACE_CLOSING: HRESULT = 0x80340002u32 as HRESULT;
pub const ERROR_NDIS_BAD_VERSION: HRESULT = 0x80340004u32 as HRESULT;
pub const ERROR_NDIS_BAD_CHARACTERISTICS: HRESULT = 0x80340005u32 as HRESULT;
pub const ERROR_NDIS_ADAPTER_NOT_FOUND: HRESULT = 0x80340006u32 as HRESULT;
pub const ERROR_NDIS_OPEN_FAILED: HRESULT = 0x80340007u32 as HRESULT;
pub const ERROR_NDIS_DEVICE_FAILED: HRESULT = 0x80340008u32 as HRESULT;
pub const ERROR_NDIS_MULTICAST_FULL: HRESULT = 0x80340009u32 as HRESULT;
pub const ERROR_NDIS_MULTICAST_EXISTS: HRESULT = 0x8034000Au32 as HRESULT;
pub const ERROR_NDIS_MULTICAST_NOT_FOUND: HRESULT = 0x8034000Bu32 as HRESULT;
pub const ERROR_NDIS_REQUEST_ABORTED: HRESULT = 0x8034000Cu32 as HRESULT;
pub const ERROR_NDIS_RESET_IN_PROGRESS: HRESULT = 0x8034000Du32 as HRESULT;
pub const ERROR_NDIS_NOT_SUPPORTED: HRESULT = 0x803400BBu32 as HRESULT;
pub const ERROR_NDIS_INVALID_PACKET: HRESULT = 0x8034000Fu32 as HRESULT;
pub const ERROR_NDIS_ADAPTER_NOT_READY: HRESULT = 0x80340011u32 as HRESULT;
pub const ERROR_NDIS_INVALID_LENGTH: HRESULT = 0x80340014u32 as HRESULT;
pub const ERROR_NDIS_INVALID_DATA: HRESULT = 0x80340015u32 as HRESULT;
pub const ERROR_NDIS_BUFFER_TOO_SHORT: HRESULT = 0x80340016u32 as HRESULT;
pub const ERROR_NDIS_INVALID_OID: HRESULT = 0x80340017u32 as HRESULT;
pub const ERROR_NDIS_ADAPTER_REMOVED: HRESULT = 0x80340018u32 as HRESULT;
pub const ERROR_NDIS_UNSUPPORTED_MEDIA: HRESULT = 0x80340019u32 as HRESULT;
pub const ERROR_NDIS_GROUP_ADDRESS_IN_USE: HRESULT = 0x8034001Au32 as HRESULT;
pub const ERROR_NDIS_FILE_NOT_FOUND: HRESULT = 0x8034001Bu32 as HRESULT;
pub const ERROR_NDIS_ERROR_READING_FILE: HRESULT = 0x8034001Cu32 as HRESULT;
pub const ERROR_NDIS_ALREADY_MAPPED: HRESULT = 0x8034001Du32 as HRESULT;
pub const ERROR_NDIS_RESOURCE_CONFLICT: HRESULT = 0x8034001Eu32 as HRESULT;
pub const ERROR_NDIS_MEDIA_DISCONNECTED: HRESULT = 0x8034001Fu32 as HRESULT;
pub const ERROR_NDIS_INVALID_ADDRESS: HRESULT = 0x80340022u32 as HRESULT;
pub const ERROR_NDIS_INVALID_DEVICE_REQUEST: HRESULT = 0x80340010u32 as HRESULT;
pub const ERROR_NDIS_PAUSED: HRESULT = 0x8034002Au32 as HRESULT;
pub const ERROR_NDIS_INTERFACE_NOT_FOUND: HRESULT = 0x8034002Bu32 as HRESULT;
pub const ERROR_NDIS_UNSUPPORTED_REVISION: HRESULT = 0x8034002Cu32 as HRESULT;
pub const ERROR_NDIS_INVALID_PORT: HRESULT = 0x8034002Du32 as HRESULT;
pub const ERROR_NDIS_INVALID_PORT_STATE: HRESULT = 0x8034002Eu32 as HRESULT;
pub const ERROR_NDIS_LOW_POWER_STATE: HRESULT = 0x8034002Fu32 as HRESULT;
pub const ERROR_NDIS_REINIT_REQUIRED: HRESULT = 0x80340030u32 as HRESULT;
pub const ERROR_NDIS_DOT11_AUTO_CONFIG_ENABLED: HRESULT = 0x80342000u32 as HRESULT;
pub const ERROR_NDIS_DOT11_MEDIA_IN_USE: HRESULT = 0x80342001u32 as HRESULT;
pub const ERROR_NDIS_DOT11_POWER_STATE_INVALID: HRESULT = 0x80342002u32 as HRESULT;
pub const ERROR_NDIS_PM_WOL_PATTERN_LIST_FULL: HRESULT = 0x80342003u32 as HRESULT;
pub const ERROR_NDIS_PM_PROTOCOL_OFFLOAD_LIST_FULL: HRESULT = 0x80342004u32 as HRESULT;
pub const ERROR_NDIS_INDICATION_REQUIRED: HRESULT = 0x00340001;
pub const ERROR_NDIS_OFFLOAD_POLICY: HRESULT = 0xC034100Fu32 as HRESULT;
pub const ERROR_NDIS_OFFLOAD_CONNECTION_REJECTED: HRESULT = 0xC0341012u32 as HRESULT;
pub const ERROR_NDIS_OFFLOAD_PATH_REJECTED: HRESULT = 0xC0341013u32 as HRESULT;
pub const ERROR_HV_INVALID_HYPERCALL_CODE: HRESULT = 0xC0350002u32 as HRESULT;
pub const ERROR_HV_INVALID_HYPERCALL_INPUT: HRESULT = 0xC0350003u32 as HRESULT;
pub const ERROR_HV_INVALID_ALIGNMENT: HRESULT = 0xC0350004u32 as HRESULT;
pub const ERROR_HV_INVALID_PARAMETER: HRESULT = 0xC0350005u32 as HRESULT;
pub const ERROR_HV_ACCESS_DENIED: HRESULT = 0xC0350006u32 as HRESULT;
pub const ERROR_HV_INVALID_PARTITION_STATE: HRESULT = 0xC0350007u32 as HRESULT;
pub const ERROR_HV_OPERATION_DENIED: HRESULT = 0xC0350008u32 as HRESULT;
pub const ERROR_HV_UNKNOWN_PROPERTY: HRESULT = 0xC0350009u32 as HRESULT;
pub const ERROR_HV_PROPERTY_VALUE_OUT_OF_RANGE: HRESULT = 0xC035000Au32 as HRESULT;
pub const ERROR_HV_INSUFFICIENT_MEMORY: HRESULT = 0xC035000Bu32 as HRESULT;
pub const ERROR_HV_PARTITION_TOO_DEEP: HRESULT = 0xC035000Cu32 as HRESULT;
pub const ERROR_HV_INVALID_PARTITION_ID: HRESULT = 0xC035000Du32 as HRESULT;
pub const ERROR_HV_INVALID_VP_INDEX: HRESULT = 0xC035000Eu32 as HRESULT;
pub const ERROR_HV_INVALID_PORT_ID: HRESULT = 0xC0350011u32 as HRESULT;
pub const ERROR_HV_INVALID_CONNECTION_ID: HRESULT = 0xC0350012u32 as HRESULT;
pub const ERROR_HV_INSUFFICIENT_BUFFERS: HRESULT = 0xC0350013u32 as HRESULT;
pub const ERROR_HV_NOT_ACKNOWLEDGED: HRESULT = 0xC0350014u32 as HRESULT;
pub const ERROR_HV_ACKNOWLEDGED: HRESULT = 0xC0350016u32 as HRESULT;
pub const ERROR_HV_INVALID_SAVE_RESTORE_STATE: HRESULT = 0xC0350017u32 as HRESULT;
pub const ERROR_HV_INVALID_SYNIC_STATE: HRESULT = 0xC0350018u32 as HRESULT;
pub const ERROR_HV_OBJECT_IN_USE: HRESULT = 0xC0350019u32 as HRESULT;
pub const ERROR_HV_INVALID_PROXIMITY_DOMAIN_INFO: HRESULT = 0xC035001Au32 as HRESULT;
pub const ERROR_HV_NO_DATA: HRESULT = 0xC035001Bu32 as HRESULT;
pub const ERROR_HV_INACTIVE: HRESULT = 0xC035001Cu32 as HRESULT;
pub const ERROR_HV_NO_RESOURCES: HRESULT = 0xC035001Du32 as HRESULT;
pub const ERROR_HV_FEATURE_UNAVAILABLE: HRESULT = 0xC035001Eu32 as HRESULT;
pub const ERROR_HV_INSUFFICIENT_BUFFER: HRESULT = 0xC0350033u32 as HRESULT;
pub const ERROR_HV_INSUFFICIENT_DEVICE_DOMAINS: HRESULT = 0xC0350038u32 as HRESULT;
pub const ERROR_HV_INVALID_LP_INDEX: HRESULT = 0xC0350041u32 as HRESULT;
pub const ERROR_HV_NOT_PRESENT: HRESULT = 0xC0351000u32 as HRESULT;
pub const ERROR_VID_DUPLICATE_HANDLER: HRESULT = 0xC0370001u32 as HRESULT;
pub const ERROR_VID_TOO_MANY_HANDLERS: HRESULT = 0xC0370002u32 as HRESULT;
pub const ERROR_VID_QUEUE_FULL: HRESULT = 0xC0370003u32 as HRESULT;
pub const ERROR_VID_HANDLER_NOT_PRESENT: HRESULT = 0xC0370004u32 as HRESULT;
pub const ERROR_VID_INVALID_OBJECT_NAME: HRESULT = 0xC0370005u32 as HRESULT;
pub const ERROR_VID_PARTITION_NAME_TOO_LONG: HRESULT = 0xC0370006u32 as HRESULT;
pub const ERROR_VID_MESSAGE_QUEUE_NAME_TOO_LONG: HRESULT = 0xC0370007u32 as HRESULT;
pub const ERROR_VID_PARTITION_ALREADY_EXISTS: HRESULT = 0xC0370008u32 as HRESULT;
pub const ERROR_VID_PARTITION_DOES_NOT_EXIST: HRESULT = 0xC0370009u32 as HRESULT;
pub const ERROR_VID_PARTITION_NAME_NOT_FOUND: HRESULT = 0xC037000Au32 as HRESULT;
pub const ERROR_VID_MESSAGE_QUEUE_ALREADY_EXISTS: HRESULT = 0xC037000Bu32 as HRESULT;
pub const ERROR_VID_EXCEEDED_MBP_ENTRY_MAP_LIMIT: HRESULT = 0xC037000Cu32 as HRESULT;
pub const ERROR_VID_MB_STILL_REFERENCED: HRESULT = 0xC037000Du32 as HRESULT;
pub const ERROR_VID_CHILD_GPA_PAGE_SET_CORRUPTED: HRESULT = 0xC037000Eu32 as HRESULT;
pub const ERROR_VID_INVALID_NUMA_SETTINGS: HRESULT = 0xC037000Fu32 as HRESULT;
pub const ERROR_VID_INVALID_NUMA_NODE_INDEX: HRESULT = 0xC0370010u32 as HRESULT;
pub const ERROR_VID_NOTIFICATION_QUEUE_ALREADY_ASSOCIATED: HRESULT = 0xC0370011u32 as HRESULT;
pub const ERROR_VID_INVALID_MEMORY_BLOCK_HANDLE: HRESULT = 0xC0370012u32 as HRESULT;
pub const ERROR_VID_PAGE_RANGE_OVERFLOW: HRESULT = 0xC0370013u32 as HRESULT;
pub const ERROR_VID_INVALID_MESSAGE_QUEUE_HANDLE: HRESULT = 0xC0370014u32 as HRESULT;
pub const ERROR_VID_INVALID_GPA_RANGE_HANDLE: HRESULT = 0xC0370015u32 as HRESULT;
pub const ERROR_VID_NO_MEMORY_BLOCK_NOTIFICATION_QUEUE: HRESULT = 0xC0370016u32 as HRESULT;
pub const ERROR_VID_MEMORY_BLOCK_LOCK_COUNT_EXCEEDED: HRESULT = 0xC0370017u32 as HRESULT;
pub const ERROR_VID_INVALID_PPM_HANDLE: HRESULT = 0xC0370018u32 as HRESULT;
pub const ERROR_VID_MBPS_ARE_LOCKED: HRESULT = 0xC0370019u32 as HRESULT;
pub const ERROR_VID_MESSAGE_QUEUE_CLOSED: HRESULT = 0xC037001Au32 as HRESULT;
pub const ERROR_VID_VIRTUAL_PROCESSOR_LIMIT_EXCEEDED: HRESULT = 0xC037001Bu32 as HRESULT;
pub const ERROR_VID_STOP_PENDING: HRESULT = 0xC037001Cu32 as HRESULT;
pub const ERROR_VID_INVALID_PROCESSOR_STATE: HRESULT = 0xC037001Du32 as HRESULT;
pub const ERROR_VID_EXCEEDED_KM_CONTEXT_COUNT_LIMIT: HRESULT = 0xC037001Eu32 as HRESULT;
pub const ERROR_VID_KM_INTERFACE_ALREADY_INITIALIZED: HRESULT = 0xC037001Fu32 as HRESULT;
pub const ERROR_VID_MB_PROPERTY_ALREADY_SET_RESET: HRESULT = 0xC0370020u32 as HRESULT;
pub const ERROR_VID_MMIO_RANGE_DESTROYED: HRESULT = 0xC0370021u32 as HRESULT;
pub const ERROR_VID_INVALID_CHILD_GPA_PAGE_SET: HRESULT = 0xC0370022u32 as HRESULT;
pub const ERROR_VID_RESERVE_PAGE_SET_IS_BEING_USED: HRESULT = 0xC0370023u32 as HRESULT;
pub const ERROR_VID_RESERVE_PAGE_SET_TOO_SMALL: HRESULT = 0xC0370024u32 as HRESULT;
pub const ERROR_VID_MBP_ALREADY_LOCKED_USING_RESERVED_PAGE: HRESULT = 0xC0370025u32 as HRESULT;
pub const ERROR_VID_MBP_COUNT_EXCEEDED_LIMIT: HRESULT = 0xC0370026u32 as HRESULT;
pub const ERROR_VID_SAVED_STATE_CORRUPT: HRESULT = 0xC0370027u32 as HRESULT;
pub const ERROR_VID_SAVED_STATE_UNRECOGNIZED_ITEM: HRESULT = 0xC0370028u32 as HRESULT;
pub const ERROR_VID_SAVED_STATE_INCOMPATIBLE: HRESULT = 0xC0370029u32 as HRESULT;
pub const ERROR_VID_REMOTE_NODE_PARENT_GPA_PAGES_USED: HRESULT = 0x80370001u32 as HRESULT;
pub const ERROR_VOLMGR_INCOMPLETE_REGENERATION: HRESULT = 0x80380001u32 as HRESULT;
pub const ERROR_VOLMGR_INCOMPLETE_DISK_MIGRATION: HRESULT = 0x80380002u32 as HRESULT;
pub const ERROR_VOLMGR_DATABASE_FULL: HRESULT = 0xC0380001u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_CONFIGURATION_CORRUPTED: HRESULT = 0xC0380002u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_CONFIGURATION_NOT_IN_SYNC: HRESULT = 0xC0380003u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_CONFIG_UPDATE_FAILED: HRESULT = 0xC0380004u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_CONTAINS_NON_SIMPLE_VOLUME: HRESULT = 0xC0380005u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_DUPLICATE: HRESULT = 0xC0380006u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_DYNAMIC: HRESULT = 0xC0380007u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_ID_INVALID: HRESULT = 0xC0380008u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_INVALID: HRESULT = 0xC0380009u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAST_VOTER: HRESULT = 0xC038000Au32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_INVALID: HRESULT = 0xC038000Bu32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_NON_BASIC_BETWEEN_BASIC_PARTITIONS: HRESULT = 0xC038000Cu32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_NOT_CYLINDER_ALIGNED: HRESULT = 0xC038000Du32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_PARTITIONS_TOO_SMALL: HRESULT = 0xC038000Eu32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_PRIMARY_BETWEEN_LOGICAL_PARTITIONS: HRESULT = 0xC038000Fu32 as HRESULT;
pub const ERROR_VOLMGR_DISK_LAYOUT_TOO_MANY_PARTITIONS: HRESULT = 0xC0380010u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_MISSING: HRESULT = 0xC0380011u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_NOT_EMPTY: HRESULT = 0xC0380012u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_NOT_ENOUGH_SPACE: HRESULT = 0xC0380013u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_REVECTORING_FAILED: HRESULT = 0xC0380014u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_SECTOR_SIZE_INVALID: HRESULT = 0xC0380015u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_SET_NOT_CONTAINED: HRESULT = 0xC0380016u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_MEMBERS: HRESULT = 0xC0380017u32 as HRESULT;
pub const ERROR_VOLMGR_DISK_USED_BY_MULTIPLE_PLEXES: HRESULT = 0xC0380018u32 as HRESULT;
pub const ERROR_VOLMGR_DYNAMIC_DISK_NOT_SUPPORTED: HRESULT = 0xC0380019u32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_ALREADY_USED: HRESULT = 0xC038001Au32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_NOT_CONTIGUOUS: HRESULT = 0xC038001Bu32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_NOT_IN_PUBLIC_REGION: HRESULT = 0xC038001Cu32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_NOT_SECTOR_ALIGNED: HRESULT = 0xC038001Du32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_OVERLAPS_EBR_PARTITION: HRESULT = 0xC038001Eu32 as HRESULT;
pub const ERROR_VOLMGR_EXTENT_VOLUME_LENGTHS_DO_NOT_MATCH: HRESULT = 0xC038001Fu32 as HRESULT;
pub const ERROR_VOLMGR_FAULT_TOLERANT_NOT_SUPPORTED: HRESULT = 0xC0380020u32 as HRESULT;
pub const ERROR_VOLMGR_INTERLEAVE_LENGTH_INVALID: HRESULT = 0xC0380021u32 as HRESULT;
pub const ERROR_VOLMGR_MAXIMUM_REGISTERED_USERS: HRESULT = 0xC0380022u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_IN_SYNC: HRESULT = 0xC0380023u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_INDEX_DUPLICATE: HRESULT = 0xC0380024u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_INDEX_INVALID: HRESULT = 0xC0380025u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_MISSING: HRESULT = 0xC0380026u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_NOT_DETACHED: HRESULT = 0xC0380027u32 as HRESULT;
pub const ERROR_VOLMGR_MEMBER_REGENERATING: HRESULT = 0xC0380028u32 as HRESULT;
pub const ERROR_VOLMGR_ALL_DISKS_FAILED: HRESULT = 0xC0380029u32 as HRESULT;
pub const ERROR_VOLMGR_NO_REGISTERED_USERS: HRESULT = 0xC038002Au32 as HRESULT;
pub const ERROR_VOLMGR_NO_SUCH_USER: HRESULT = 0xC038002Bu32 as HRESULT;
pub const ERROR_VOLMGR_NOTIFICATION_RESET: HRESULT = 0xC038002Cu32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_MEMBERS_INVALID: HRESULT = 0xC038002Du32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_PLEXES_INVALID: HRESULT = 0xC038002Eu32 as HRESULT;
pub const ERROR_VOLMGR_PACK_DUPLICATE: HRESULT = 0xC038002Fu32 as HRESULT;
pub const ERROR_VOLMGR_PACK_ID_INVALID: HRESULT = 0xC0380030u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_INVALID: HRESULT = 0xC0380031u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_NAME_INVALID: HRESULT = 0xC0380032u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_OFFLINE: HRESULT = 0xC0380033u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_HAS_QUORUM: HRESULT = 0xC0380034u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_WITHOUT_QUORUM: HRESULT = 0xC0380035u32 as HRESULT;
pub const ERROR_VOLMGR_PARTITION_STYLE_INVALID: HRESULT = 0xC0380036u32 as HRESULT;
pub const ERROR_VOLMGR_PARTITION_UPDATE_FAILED: HRESULT = 0xC0380037u32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_IN_SYNC: HRESULT = 0xC0380038u32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_INDEX_DUPLICATE: HRESULT = 0xC0380039u32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_INDEX_INVALID: HRESULT = 0xC038003Au32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_LAST_ACTIVE: HRESULT = 0xC038003Bu32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_MISSING: HRESULT = 0xC038003Cu32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_REGENERATING: HRESULT = 0xC038003Du32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_TYPE_INVALID: HRESULT = 0xC038003Eu32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_NOT_RAID5: HRESULT = 0xC038003Fu32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_NOT_SIMPLE: HRESULT = 0xC0380040u32 as HRESULT;
pub const ERROR_VOLMGR_STRUCTURE_SIZE_INVALID: HRESULT = 0xC0380041u32 as HRESULT;
pub const ERROR_VOLMGR_TOO_MANY_NOTIFICATION_REQUESTS: HRESULT = 0xC0380042u32 as HRESULT;
pub const ERROR_VOLMGR_TRANSACTION_IN_PROGRESS: HRESULT = 0xC0380043u32 as HRESULT;
pub const ERROR_VOLMGR_UNEXPECTED_DISK_LAYOUT_CHANGE: HRESULT = 0xC0380044u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_CONTAINS_MISSING_DISK: HRESULT = 0xC0380045u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_ID_INVALID: HRESULT = 0xC0380046u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_LENGTH_INVALID: HRESULT = 0xC0380047u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_LENGTH_NOT_SECTOR_SIZE_MULTIPLE: HRESULT = 0xC0380048u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_NOT_MIRRORED: HRESULT = 0xC0380049u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_NOT_RETAINED: HRESULT = 0xC038004Au32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_OFFLINE: HRESULT = 0xC038004Bu32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_RETAINED: HRESULT = 0xC038004Cu32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_EXTENTS_INVALID: HRESULT = 0xC038004Du32 as HRESULT;
pub const ERROR_VOLMGR_DIFFERENT_SECTOR_SIZE: HRESULT = 0xC038004Eu32 as HRESULT;
pub const ERROR_VOLMGR_BAD_BOOT_DISK: HRESULT = 0xC038004Fu32 as HRESULT;
pub const ERROR_VOLMGR_PACK_CONFIG_OFFLINE: HRESULT = 0xC0380050u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_CONFIG_ONLINE: HRESULT = 0xC0380051u32 as HRESULT;
pub const ERROR_VOLMGR_NOT_PRIMARY_PACK: HRESULT = 0xC0380052u32 as HRESULT;
pub const ERROR_VOLMGR_PACK_LOG_UPDATE_FAILED: HRESULT = 0xC0380053u32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_PLEX_INVALID: HRESULT = 0xC0380054u32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_IN_MEMBER_INVALID: HRESULT = 0xC0380055u32 as HRESULT;
pub const ERROR_VOLMGR_VOLUME_MIRRORED: HRESULT = 0xC0380056u32 as HRESULT;
pub const ERROR_VOLMGR_PLEX_NOT_SIMPLE_SPANNED: HRESULT = 0xC0380057u32 as HRESULT;
pub const ERROR_VOLMGR_NO_VALID_LOG_COPIES: HRESULT = 0xC0380058u32 as HRESULT;
pub const ERROR_VOLMGR_PRIMARY_PACK_PRESENT: HRESULT = 0xC0380059u32 as HRESULT;
pub const ERROR_VOLMGR_NUMBER_OF_DISKS_INVALID: HRESULT = 0xC038005Au32 as HRESULT;
pub const ERROR_VOLMGR_MIRROR_NOT_SUPPORTED: HRESULT = 0xC038005Bu32 as HRESULT;
pub const ERROR_VOLMGR_RAID5_NOT_SUPPORTED: HRESULT = 0xC038005Cu32 as HRESULT;
pub const ERROR_BCD_NOT_ALL_ENTRIES_IMPORTED: HRESULT = 0x80390001u32 as HRESULT;
pub const ERROR_BCD_TOO_MANY_ELEMENTS: HRESULT = 0xC0390002u32 as HRESULT;
pub const ERROR_BCD_NOT_ALL_ENTRIES_SYNCHRONIZED: HRESULT = 0x80390003u32 as HRESULT;
pub const ERROR_VHD_DRIVE_FOOTER_MISSING: HRESULT = 0xC03A0001u32 as HRESULT;
pub const ERROR_VHD_DRIVE_FOOTER_CHECKSUM_MISMATCH: HRESULT = 0xC03A0002u32 as HRESULT;
pub const ERROR_VHD_DRIVE_FOOTER_CORRUPT: HRESULT = 0xC03A0003u32 as HRESULT;
pub const ERROR_VHD_FORMAT_UNKNOWN: HRESULT = 0xC03A0004u32 as HRESULT;
pub const ERROR_VHD_FORMAT_UNSUPPORTED_VERSION: HRESULT = 0xC03A0005u32 as HRESULT;
pub const ERROR_VHD_SPARSE_HEADER_CHECKSUM_MISMATCH: HRESULT = 0xC03A0006u32 as HRESULT;
pub const ERROR_VHD_SPARSE_HEADER_UNSUPPORTED_VERSION: HRESULT = 0xC03A0007u32 as HRESULT;
pub const ERROR_VHD_SPARSE_HEADER_CORRUPT: HRESULT = 0xC03A0008u32 as HRESULT;
pub const ERROR_VHD_BLOCK_ALLOCATION_FAILURE: HRESULT = 0xC03A0009u32 as HRESULT;
pub const ERROR_VHD_BLOCK_ALLOCATION_TABLE_CORRUPT: HRESULT = 0xC03A000Au32 as HRESULT;
pub const ERROR_VHD_INVALID_BLOCK_SIZE: HRESULT = 0xC03A000Bu32 as HRESULT;
pub const ERROR_VHD_BITMAP_MISMATCH: HRESULT = 0xC03A000Cu32 as HRESULT;
pub const ERROR_VHD_PARENT_VHD_NOT_FOUND: HRESULT = 0xC03A000Du32 as HRESULT;
pub const ERROR_VHD_CHILD_PARENT_ID_MISMATCH: HRESULT = 0xC03A000Eu32 as HRESULT;
pub const ERROR_VHD_CHILD_PARENT_TIMESTAMP_MISMATCH: HRESULT = 0xC03A000Fu32 as HRESULT;
pub const ERROR_VHD_METADATA_READ_FAILURE: HRESULT = 0xC03A0010u32 as HRESULT;
pub const ERROR_VHD_METADATA_WRITE_FAILURE: HRESULT = 0xC03A0011u32 as HRESULT;
pub const ERROR_VHD_INVALID_SIZE: HRESULT = 0xC03A0012u32 as HRESULT;
pub const ERROR_VHD_INVALID_FILE_SIZE: HRESULT = 0xC03A0013u32 as HRESULT;
pub const ERROR_VIRTDISK_PROVIDER_NOT_FOUND: HRESULT = 0xC03A0014u32 as HRESULT;
pub const ERROR_VIRTDISK_NOT_VIRTUAL_DISK: HRESULT = 0xC03A0015u32 as HRESULT;
pub const ERROR_VHD_PARENT_VHD_ACCESS_DENIED: HRESULT = 0xC03A0016u32 as HRESULT;
pub const ERROR_VHD_CHILD_PARENT_SIZE_MISMATCH: HRESULT = 0xC03A0017u32 as HRESULT;
pub const ERROR_VHD_DIFFERENCING_CHAIN_CYCLE_DETECTED: HRESULT = 0xC03A0018u32 as HRESULT;
pub const ERROR_VHD_DIFFERENCING_CHAIN_ERROR_IN_PARENT: HRESULT = 0xC03A0019u32 as HRESULT;
pub const ERROR_VIRTUAL_DISK_LIMITATION: HRESULT = 0xC03A001Au32 as HRESULT;
pub const ERROR_VHD_INVALID_TYPE: HRESULT = 0xC03A001Bu32 as HRESULT;
pub const ERROR_VHD_INVALID_STATE: HRESULT = 0xC03A001Cu32 as HRESULT;
pub const ERROR_VIRTDISK_UNSUPPORTED_DISK_SECTOR_SIZE: HRESULT = 0xC03A001Du32 as HRESULT;
pub const ERROR_VIRTDISK_DISK_ALREADY_OWNED: HRESULT = 0xC03A001Eu32 as HRESULT;
pub const ERROR_VIRTDISK_DISK_ONLINE_AND_WRITABLE: HRESULT = 0xC03A001Fu32 as HRESULT;
pub const ERROR_CTLOG_TRACKING_NOT_INITIALIZED: HRESULT = 0xC03A0020u32 as HRESULT;
pub const ERROR_CTLOG_LOGFILE_SIZE_EXCEEDED_MAXSIZE: HRESULT = 0xC03A0021u32 as HRESULT;
pub const ERROR_CTLOG_VHD_CHANGED_OFFLINE: HRESULT = 0xC03A0022u32 as HRESULT;
pub const ERROR_CTLOG_INVALID_TRACKING_STATE: HRESULT = 0xC03A0023u32 as HRESULT;
pub const ERROR_CTLOG_INCONSISTENT_TRACKING_FILE: HRESULT = 0xC03A0024u32 as HRESULT;
pub const ERROR_VHD_RESIZE_WOULD_TRUNCATE_DATA: HRESULT = 0xC03A0025u32 as HRESULT;
pub const ERROR_VHD_COULD_NOT_COMPUTE_MINIMUM_VIRTUAL_SIZE: HRESULT = 0xC03A0026u32 as HRESULT;
pub const ERROR_VHD_ALREADY_AT_OR_BELOW_MINIMUM_VIRTUAL_SIZE: HRESULT = 0xC03A0027u32 as HRESULT;
pub const ERROR_VHD_METADATA_FULL: HRESULT = 0xC03A0028u32 as HRESULT;
pub const ERROR_QUERY_STORAGE_ERROR: HRESULT = 0x803A0001u32 as HRESULT;
pub const SDIAG_E_CANCELLED: HRESULT = 0x803C0100u32 as HRESULT;
pub const SDIAG_E_SCRIPT: HRESULT = 0x803C0101u32 as HRESULT;
pub const SDIAG_E_POWERSHELL: HRESULT = 0x803C0102u32 as HRESULT;
pub const SDIAG_E_MANAGEDHOST: HRESULT = 0x803C0103u32 as HRESULT;
pub const SDIAG_E_NOVERIFIER: HRESULT = 0x803C0104u32 as HRESULT;
pub const SDIAG_S_CANNOTRUN: HRESULT = 0x003C0105;
pub const SDIAG_E_DISABLED: HRESULT = 0x803C0106u32 as HRESULT;
pub const SDIAG_E_TRUST: HRESULT = 0x803C0107u32 as HRESULT;
pub const SDIAG_E_CANNOTRUN: HRESULT = 0x803C0108u32 as HRESULT;
pub const SDIAG_E_VERSION: HRESULT = 0x803C0109u32 as HRESULT;
pub const SDIAG_E_RESOURCE: HRESULT = 0x803C010Au32 as HRESULT;
pub const SDIAG_E_ROOTCAUSE: HRESULT = 0x803C010Bu32 as HRESULT;
pub const WPN_E_CHANNEL_CLOSED: HRESULT = 0x803E0100u32 as HRESULT;
pub const WPN_E_CHANNEL_REQUEST_NOT_COMPLETE: HRESULT = 0x803E0101u32 as HRESULT;
pub const WPN_E_INVALID_APP: HRESULT = 0x803E0102u32 as HRESULT;
pub const WPN_E_OUTSTANDING_CHANNEL_REQUEST: HRESULT = 0x803E0103u32 as HRESULT;
pub const WPN_E_DUPLICATE_CHANNEL: HRESULT = 0x803E0104u32 as HRESULT;
pub const WPN_E_PLATFORM_UNAVAILABLE: HRESULT = 0x803E0105u32 as HRESULT;
pub const WPN_E_NOTIFICATION_POSTED: HRESULT = 0x803E0106u32 as HRESULT;
pub const WPN_E_NOTIFICATION_HIDDEN: HRESULT = 0x803E0107u32 as HRESULT;
pub const WPN_E_NOTIFICATION_NOT_POSTED: HRESULT = 0x803E0108u32 as HRESULT;
pub const WPN_E_CLOUD_DISABLED: HRESULT = 0x803E0109u32 as HRESULT;
pub const WPN_E_CLOUD_INCAPABLE: HRESULT = 0x803E0110u32 as HRESULT;
pub const WPN_E_CLOUD_AUTH_UNAVAILABLE: HRESULT = 0x803E011Au32 as HRESULT;
pub const WPN_E_CLOUD_SERVICE_UNAVAILABLE: HRESULT = 0x803E011Bu32 as HRESULT;
pub const WPN_E_FAILED_LOCK_SCREEN_UPDATE_INTIALIZATION: HRESULT = 0x803E011Cu32 as HRESULT;
pub const WPN_E_NOTIFICATION_DISABLED: HRESULT = 0x803E0111u32 as HRESULT;
pub const WPN_E_NOTIFICATION_INCAPABLE: HRESULT = 0x803E0112u32 as HRESULT;
pub const WPN_E_INTERNET_INCAPABLE: HRESULT = 0x803E0113u32 as HRESULT;
pub const WPN_E_NOTIFICATION_TYPE_DISABLED: HRESULT = 0x803E0114u32 as HRESULT;
pub const WPN_E_NOTIFICATION_SIZE: HRESULT = 0x803E0115u32 as HRESULT;
pub const WPN_E_TAG_SIZE: HRESULT = 0x803E0116u32 as HRESULT;
pub const WPN_E_ACCESS_DENIED: HRESULT = 0x803E0117u32 as HRESULT;
pub const WPN_E_DUPLICATE_REGISTRATION: HRESULT = 0x803E0118u32 as HRESULT;
pub const WPN_E_PUSH_NOTIFICATION_INCAPABLE: HRESULT = 0x803E0119u32 as HRESULT;
pub const WPN_E_DEV_ID_SIZE: HRESULT = 0x803E0120u32 as HRESULT;
pub const WPN_E_TAG_ALPHANUMERIC: HRESULT = 0x803E012Au32 as HRESULT;
pub const WPN_E_INVALID_HTTP_STATUS_CODE: HRESULT = 0x803E012Bu32 as HRESULT;
pub const WPN_E_OUT_OF_SESSION: HRESULT = 0x803E0200u32 as HRESULT;
pub const WPN_E_POWER_SAVE: HRESULT = 0x803E0201u32 as HRESULT;
pub const WPN_E_IMAGE_NOT_FOUND_IN_CACHE: HRESULT = 0x803E0202u32 as HRESULT;
pub const WPN_E_ALL_URL_NOT_COMPLETED: HRESULT = 0x803E0203u32 as HRESULT;
pub const WPN_E_INVALID_CLOUD_IMAGE: HRESULT = 0x803E0204u32 as HRESULT;
pub const WPN_E_NOTIFICATION_ID_MATCHED: HRESULT = 0x803E0205u32 as HRESULT;
pub const WPN_E_CALLBACK_ALREADY_REGISTERED: HRESULT = 0x803E0206u32 as HRESULT;
pub const WPN_E_TOAST_NOTIFICATION_DROPPED: HRESULT = 0x803E0207u32 as HRESULT;
pub const WPN_E_STORAGE_LOCKED: HRESULT = 0x803E0208u32 as HRESULT;
pub const E_MBN_CONTEXT_NOT_ACTIVATED: HRESULT = 0x80548201u32 as HRESULT;
pub const E_MBN_BAD_SIM: HRESULT = 0x80548202u32 as HRESULT;
pub const E_MBN_DATA_CLASS_NOT_AVAILABLE: HRESULT = 0x80548203u32 as HRESULT;
pub const E_MBN_INVALID_ACCESS_STRING: HRESULT = 0x80548204u32 as HRESULT;
pub const E_MBN_MAX_ACTIVATED_CONTEXTS: HRESULT = 0x80548205u32 as HRESULT;
pub const E_MBN_PACKET_SVC_DETACHED: HRESULT = 0x80548206u32 as HRESULT;
pub const E_MBN_PROVIDER_NOT_VISIBLE: HRESULT = 0x80548207u32 as HRESULT;
pub const E_MBN_RADIO_POWER_OFF: HRESULT = 0x80548208u32 as HRESULT;
pub const E_MBN_SERVICE_NOT_ACTIVATED: HRESULT = 0x80548209u32 as HRESULT;
pub const E_MBN_SIM_NOT_INSERTED: HRESULT = 0x8054820Au32 as HRESULT;
pub const E_MBN_VOICE_CALL_IN_PROGRESS: HRESULT = 0x8054820Bu32 as HRESULT;
pub const E_MBN_INVALID_CACHE: HRESULT = 0x8054820Cu32 as HRESULT;
pub const E_MBN_NOT_REGISTERED: HRESULT = 0x8054820Du32 as HRESULT;
pub const E_MBN_PROVIDERS_NOT_FOUND: HRESULT = 0x8054820Eu32 as HRESULT;
pub const E_MBN_PIN_NOT_SUPPORTED: HRESULT = 0x8054820Fu32 as HRESULT;
pub const E_MBN_PIN_REQUIRED: HRESULT = 0x80548210u32 as HRESULT;
pub const E_MBN_PIN_DISABLED: HRESULT = 0x80548211u32 as HRESULT;
pub const E_MBN_FAILURE: HRESULT = 0x80548212u32 as HRESULT;
pub const E_MBN_INVALID_PROFILE: HRESULT = 0x80548218u32 as HRESULT;
pub const E_MBN_DEFAULT_PROFILE_EXIST: HRESULT = 0x80548219u32 as HRESULT;
pub const E_MBN_SMS_ENCODING_NOT_SUPPORTED: HRESULT = 0x80548220u32 as HRESULT;
pub const E_MBN_SMS_FILTER_NOT_SUPPORTED: HRESULT = 0x80548221u32 as HRESULT;
pub const E_MBN_SMS_INVALID_MEMORY_INDEX: HRESULT = 0x80548222u32 as HRESULT;
pub const E_MBN_SMS_LANG_NOT_SUPPORTED: HRESULT = 0x80548223u32 as HRESULT;
pub const E_MBN_SMS_MEMORY_FAILURE: HRESULT = 0x80548224u32 as HRESULT;
pub const E_MBN_SMS_NETWORK_TIMEOUT: HRESULT = 0x80548225u32 as HRESULT;
pub const E_MBN_SMS_UNKNOWN_SMSC_ADDRESS: HRESULT = 0x80548226u32 as HRESULT;
pub const E_MBN_SMS_FORMAT_NOT_SUPPORTED: HRESULT = 0x80548227u32 as HRESULT;
pub const E_MBN_SMS_OPERATION_NOT_ALLOWED: HRESULT = 0x80548228u32 as HRESULT;
pub const E_MBN_SMS_MEMORY_FULL: HRESULT = 0x80548229u32 as HRESULT;
pub const PEER_E_IPV6_NOT_INSTALLED: HRESULT = 0x80630001u32 as HRESULT;
pub const PEER_E_NOT_INITIALIZED: HRESULT = 0x80630002u32 as HRESULT;
pub const PEER_E_CANNOT_START_SERVICE: HRESULT = 0x80630003u32 as HRESULT;
pub const PEER_E_NOT_LICENSED: HRESULT = 0x80630004u32 as HRESULT;
pub const PEER_E_INVALID_GRAPH: HRESULT = 0x80630010u32 as HRESULT;
pub const PEER_E_DBNAME_CHANGED: HRESULT = 0x80630011u32 as HRESULT;
pub const PEER_E_DUPLICATE_GRAPH: HRESULT = 0x80630012u32 as HRESULT;
pub const PEER_E_GRAPH_NOT_READY: HRESULT = 0x80630013u32 as HRESULT;
pub const PEER_E_GRAPH_SHUTTING_DOWN: HRESULT = 0x80630014u32 as HRESULT;
pub const PEER_E_GRAPH_IN_USE: HRESULT = 0x80630015u32 as HRESULT;
pub const PEER_E_INVALID_DATABASE: HRESULT = 0x80630016u32 as HRESULT;
pub const PEER_E_TOO_MANY_ATTRIBUTES: HRESULT = 0x80630017u32 as HRESULT;
pub const PEER_E_CONNECTION_NOT_FOUND: HRESULT = 0x80630103u32 as HRESULT;
pub const PEER_E_CONNECT_SELF: HRESULT = 0x80630106u32 as HRESULT;
pub const PEER_E_ALREADY_LISTENING: HRESULT = 0x80630107u32 as HRESULT;
pub const PEER_E_NODE_NOT_FOUND: HRESULT = 0x80630108u32 as HRESULT;
pub const PEER_E_CONNECTION_FAILED: HRESULT = 0x80630109u32 as HRESULT;
pub const PEER_E_CONNECTION_NOT_AUTHENTICATED: HRESULT = 0x8063010Au32 as HRESULT;
pub const PEER_E_CONNECTION_REFUSED: HRESULT = 0x8063010Bu32 as HRESULT;
pub const PEER_E_CLASSIFIER_TOO_LONG: HRESULT = 0x80630201u32 as HRESULT;
pub const PEER_E_TOO_MANY_IDENTITIES: HRESULT = 0x80630202u32 as HRESULT;
pub const PEER_E_NO_KEY_ACCESS: HRESULT = 0x80630203u32 as HRESULT;
pub const PEER_E_GROUPS_EXIST: HRESULT = 0x80630204u32 as HRESULT;
pub const PEER_E_RECORD_NOT_FOUND: HRESULT = 0x80630301u32 as HRESULT;
pub const PEER_E_DATABASE_ACCESSDENIED: HRESULT = 0x80630302u32 as HRESULT;
pub const PEER_E_DBINITIALIZATION_FAILED: HRESULT = 0x80630303u32 as HRESULT;
pub const PEER_E_MAX_RECORD_SIZE_EXCEEDED: HRESULT = 0x80630304u32 as HRESULT;
pub const PEER_E_DATABASE_ALREADY_PRESENT: HRESULT = 0x80630305u32 as HRESULT;
pub const PEER_E_DATABASE_NOT_PRESENT: HRESULT = 0x80630306u32 as HRESULT;
pub const PEER_E_IDENTITY_NOT_FOUND: HRESULT = 0x80630401u32 as HRESULT;
pub const PEER_E_EVENT_HANDLE_NOT_FOUND: HRESULT = 0x80630501u32 as HRESULT;
pub const PEER_E_INVALID_SEARCH: HRESULT = 0x80630601u32 as HRESULT;
pub const PEER_E_INVALID_ATTRIBUTES: HRESULT = 0x80630602u32 as HRESULT;
pub const PEER_E_INVITATION_NOT_TRUSTED: HRESULT = 0x80630701u32 as HRESULT;
pub const PEER_E_CHAIN_TOO_LONG: HRESULT = 0x80630703u32 as HRESULT;
pub const PEER_E_INVALID_TIME_PERIOD: HRESULT = 0x80630705u32 as HRESULT;
pub const PEER_E_CIRCULAR_CHAIN_DETECTED: HRESULT = 0x80630706u32 as HRESULT;
pub const PEER_E_CERT_STORE_CORRUPTED: HRESULT = 0x80630801u32 as HRESULT;
pub const PEER_E_NO_CLOUD: HRESULT = 0x80631001u32 as HRESULT;
pub const PEER_E_CLOUD_NAME_AMBIGUOUS: HRESULT = 0x80631005u32 as HRESULT;
pub const PEER_E_INVALID_RECORD: HRESULT = 0x80632010u32 as HRESULT;
pub const PEER_E_NOT_AUTHORIZED: HRESULT = 0x80632020u32 as HRESULT;
pub const PEER_E_PASSWORD_DOES_NOT_MEET_POLICY: HRESULT = 0x80632021u32 as HRESULT;
pub const PEER_E_DEFERRED_VALIDATION: HRESULT = 0x80632030u32 as HRESULT;
pub const PEER_E_INVALID_GROUP_PROPERTIES: HRESULT = 0x80632040u32 as HRESULT;
pub const PEER_E_INVALID_PEER_NAME: HRESULT = 0x80632050u32 as HRESULT;
pub const PEER_E_INVALID_CLASSIFIER: HRESULT = 0x80632060u32 as HRESULT;
pub const PEER_E_INVALID_FRIENDLY_NAME: HRESULT = 0x80632070u32 as HRESULT;
pub const PEER_E_INVALID_ROLE_PROPERTY: HRESULT = 0x80632071u32 as HRESULT;
pub const PEER_E_INVALID_CLASSIFIER_PROPERTY: HRESULT = 0x80632072u32 as HRESULT;
pub const PEER_E_INVALID_RECORD_EXPIRATION: HRESULT = 0x80632080u32 as HRESULT;
pub const PEER_E_INVALID_CREDENTIAL_INFO: HRESULT = 0x80632081u32 as HRESULT;
pub const PEER_E_INVALID_CREDENTIAL: HRESULT = 0x80632082u32 as HRESULT;
pub const PEER_E_INVALID_RECORD_SIZE: HRESULT = 0x80632083u32 as HRESULT;
pub const PEER_E_UNSUPPORTED_VERSION: HRESULT = 0x80632090u32 as HRESULT;
pub const PEER_E_GROUP_NOT_READY: HRESULT = 0x80632091u32 as HRESULT;
pub const PEER_E_GROUP_IN_USE: HRESULT = 0x80632092u32 as HRESULT;
pub const PEER_E_INVALID_GROUP: HRESULT = 0x80632093u32 as HRESULT;
pub const PEER_E_NO_MEMBERS_FOUND: HRESULT = 0x80632094u32 as HRESULT;
pub const PEER_E_NO_MEMBER_CONNECTIONS: HRESULT = 0x80632095u32 as HRESULT;
pub const PEER_E_UNABLE_TO_LISTEN: HRESULT = 0x80632096u32 as HRESULT;
pub const PEER_E_IDENTITY_DELETED: HRESULT = 0x806320A0u32 as HRESULT;
pub const PEER_E_SERVICE_NOT_AVAILABLE: HRESULT = 0x806320A1u32 as HRESULT;
pub const PEER_E_CONTACT_NOT_FOUND: HRESULT = 0x80636001u32 as HRESULT;
pub const PEER_S_GRAPH_DATA_CREATED: HRESULT = 0x00630001;
pub const PEER_S_NO_EVENT_DATA: HRESULT = 0x00630002;
pub const PEER_S_ALREADY_CONNECTED: HRESULT = 0x00632000;
pub const PEER_S_SUBSCRIPTION_EXISTS: HRESULT = 0x00636000;
pub const PEER_S_NO_CONNECTIVITY: HRESULT = 0x00630005;
pub const PEER_S_ALREADY_A_MEMBER: HRESULT = 0x00630006;
pub const PEER_E_CANNOT_CONVERT_PEER_NAME: HRESULT = 0x80634001u32 as HRESULT;
pub const PEER_E_INVALID_PEER_HOST_NAME: HRESULT = 0x80634002u32 as HRESULT;
pub const PEER_E_NO_MORE: HRESULT = 0x80634003u32 as HRESULT;
pub const PEER_E_PNRP_DUPLICATE_PEER_NAME: HRESULT = 0x80634005u32 as HRESULT;
pub const PEER_E_INVITE_CANCELLED: HRESULT = 0x80637000u32 as HRESULT;
pub const PEER_E_INVITE_RESPONSE_NOT_AVAILABLE: HRESULT = 0x80637001u32 as HRESULT;
pub const PEER_E_NOT_SIGNED_IN: HRESULT = 0x80637003u32 as HRESULT;
pub const PEER_E_PRIVACY_DECLINED: HRESULT = 0x80637004u32 as HRESULT;
pub const PEER_E_TIMEOUT: HRESULT = 0x80637005u32 as HRESULT;
pub const PEER_E_INVALID_ADDRESS: HRESULT = 0x80637007u32 as HRESULT;
pub const PEER_E_FW_EXCEPTION_DISABLED: HRESULT = 0x80637008u32 as HRESULT;
pub const PEER_E_FW_BLOCKED_BY_POLICY: HRESULT = 0x80637009u32 as HRESULT;
pub const PEER_E_FW_BLOCKED_BY_SHIELDS_UP: HRESULT = 0x8063700Au32 as HRESULT;
pub const PEER_E_FW_DECLINED: HRESULT = 0x8063700Bu32 as HRESULT;
pub const UI_E_CREATE_FAILED: HRESULT = 0x802A0001u32 as HRESULT;
pub const UI_E_SHUTDOWN_CALLED: HRESULT = 0x802A0002u32 as HRESULT;
pub const UI_E_ILLEGAL_REENTRANCY: HRESULT = 0x802A0003u32 as HRESULT;
pub const UI_E_OBJECT_SEALED: HRESULT = 0x802A0004u32 as HRESULT;
pub const UI_E_VALUE_NOT_SET: HRESULT = 0x802A0005u32 as HRESULT;
pub const UI_E_VALUE_NOT_DETERMINED: HRESULT = 0x802A0006u32 as HRESULT;
pub const UI_E_INVALID_OUTPUT: HRESULT = 0x802A0007u32 as HRESULT;
pub const UI_E_BOOLEAN_EXPECTED: HRESULT = 0x802A0008u32 as HRESULT;
pub const UI_E_DIFFERENT_OWNER: HRESULT = 0x802A0009u32 as HRESULT;
pub const UI_E_AMBIGUOUS_MATCH: HRESULT = 0x802A000Au32 as HRESULT;
pub const UI_E_FP_OVERFLOW: HRESULT = 0x802A000Bu32 as HRESULT;
pub const UI_E_WRONG_THREAD: HRESULT = 0x802A000Cu32 as HRESULT;
pub const UI_E_STORYBOARD_ACTIVE: HRESULT = 0x802A0101u32 as HRESULT;
pub const UI_E_STORYBOARD_NOT_PLAYING: HRESULT = 0x802A0102u32 as HRESULT;
pub const UI_E_START_KEYFRAME_AFTER_END: HRESULT = 0x802A0103u32 as HRESULT;
pub const UI_E_END_KEYFRAME_NOT_DETERMINED: HRESULT = 0x802A0104u32 as HRESULT;
pub const UI_E_LOOPS_OVERLAP: HRESULT = 0x802A0105u32 as HRESULT;
pub const UI_E_TRANSITION_ALREADY_USED: HRESULT = 0x802A0106u32 as HRESULT;
pub const UI_E_TRANSITION_NOT_IN_STORYBOARD: HRESULT = 0x802A0107u32 as HRESULT;
pub const UI_E_TRANSITION_ECLIPSED: HRESULT = 0x802A0108u32 as HRESULT;
pub const UI_E_TIME_BEFORE_LAST_UPDATE: HRESULT = 0x802A0109u32 as HRESULT;
pub const UI_E_TIMER_CLIENT_ALREADY_CONNECTED: HRESULT = 0x802A010Au32 as HRESULT;
pub const UI_E_INVALID_DIMENSION: HRESULT = 0x802A010Bu32 as HRESULT;
pub const UI_E_PRIMITIVE_OUT_OF_BOUNDS: HRESULT = 0x802A010Cu32 as HRESULT;
pub const UI_E_WINDOW_CLOSED: HRESULT = 0x802A0201u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INVALID_HANDLE: HRESULT = 0x80650001u32 as HRESULT;
pub const E_BLUETOOTH_ATT_READ_NOT_PERMITTED: HRESULT = 0x80650002u32 as HRESULT;
pub const E_BLUETOOTH_ATT_WRITE_NOT_PERMITTED: HRESULT = 0x80650003u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INVALID_PDU: HRESULT = 0x80650004u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INSUFFICIENT_AUTHENTICATION: HRESULT = 0x80650005u32 as HRESULT;
pub const E_BLUETOOTH_ATT_REQUEST_NOT_SUPPORTED: HRESULT = 0x80650006u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INVALID_OFFSET: HRESULT = 0x80650007u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INSUFFICIENT_AUTHORIZATION: HRESULT = 0x80650008u32 as HRESULT;
pub const E_BLUETOOTH_ATT_PREPARE_QUEUE_FULL: HRESULT = 0x80650009u32 as HRESULT;
pub const E_BLUETOOTH_ATT_ATTRIBUTE_NOT_FOUND: HRESULT = 0x8065000Au32 as HRESULT;
pub const E_BLUETOOTH_ATT_ATTRIBUTE_NOT_LONG: HRESULT = 0x8065000Bu32 as HRESULT;
pub const E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION_KEY_SIZE: HRESULT = 0x8065000Cu32 as HRESULT;
pub const E_BLUETOOTH_ATT_INVALID_ATTRIBUTE_VALUE_LENGTH: HRESULT = 0x8065000Du32 as HRESULT;
pub const E_BLUETOOTH_ATT_UNLIKELY: HRESULT = 0x8065000Eu32 as HRESULT;
pub const E_BLUETOOTH_ATT_INSUFFICIENT_ENCRYPTION: HRESULT = 0x8065000Fu32 as HRESULT;
pub const E_BLUETOOTH_ATT_UNSUPPORTED_GROUP_TYPE: HRESULT = 0x80650010u32 as HRESULT;
pub const E_BLUETOOTH_ATT_INSUFFICIENT_RESOURCES: HRESULT = 0x80650011u32 as HRESULT;
pub const E_BLUETOOTH_ATT_UNKNOWN_ERROR: HRESULT = 0x80651000u32 as HRESULT;
pub const E_AUDIO_ENGINE_NODE_NOT_FOUND: HRESULT = 0x80660001u32 as HRESULT;
pub const E_HDAUDIO_EMPTY_CONNECTION_LIST: HRESULT = 0x80660002u32 as HRESULT;
pub const E_HDAUDIO_CONNECTION_LIST_NOT_SUPPORTED: HRESULT = 0x80660003u32 as HRESULT;
pub const E_HDAUDIO_NO_LOGICAL_DEVICES_CREATED: HRESULT = 0x80660004u32 as HRESULT;
pub const E_HDAUDIO_NULL_LINKED_LIST_ENTRY: HRESULT = 0x80660005u32 as HRESULT;
pub const ERROR_SPACES_POOL_WAS_DELETED: HRESULT = 0x00E70001;
pub const ERROR_SPACES_RESILIENCY_TYPE_INVALID: HRESULT = 0x80E70003u32 as HRESULT;
pub const ERROR_SPACES_DRIVE_SECTOR_SIZE_INVALID: HRESULT = 0x80E70004u32 as HRESULT;
pub const ERROR_SPACES_DRIVE_REDUNDANCY_INVALID: HRESULT = 0x80E70006u32 as HRESULT;
pub const ERROR_SPACES_NUMBER_OF_DATA_COPIES_INVALID: HRESULT = 0x80E70007u32 as HRESULT;
pub const ERROR_SPACES_PARITY_LAYOUT_INVALID: HRESULT = 0x80E70008u32 as HRESULT;
pub const ERROR_SPACES_INTERLEAVE_LENGTH_INVALID: HRESULT = 0x80E70009u32 as HRESULT;
pub const ERROR_SPACES_NUMBER_OF_COLUMNS_INVALID: HRESULT = 0x80E7000Au32 as HRESULT;
pub const ERROR_SPACES_NOT_ENOUGH_DRIVES: HRESULT = 0x80E7000Bu32 as HRESULT;
pub const ERROR_VOLSNAP_BOOTFILE_NOT_VALID: HRESULT = 0x80820001u32 as HRESULT;
pub const ERROR_TIERING_NOT_SUPPORTED_ON_VOLUME: HRESULT = 0x80830001u32 as HRESULT;
pub const ERROR_TIERING_VOLUME_DISMOUNT_IN_PROGRESS: HRESULT = 0x80830002u32 as HRESULT;
pub const ERROR_TIERING_STORAGE_TIER_NOT_FOUND: HRESULT = 0x80830003u32 as HRESULT;
pub const ERROR_TIERING_INVALID_FILE_ID: HRESULT = 0x80830004u32 as HRESULT;
pub const ERROR_TIERING_WRONG_CLUSTER_NODE: HRESULT = 0x80830005u32 as HRESULT;
pub const ERROR_TIERING_ALREADY_PROCESSING: HRESULT = 0x80830006u32 as HRESULT;
pub const ERROR_TIERING_CANNOT_PIN_OBJECT: HRESULT = 0x80830007u32 as HRESULT;
pub const DXGI_STATUS_OCCLUDED: HRESULT = 0x087A0001;
pub const DXGI_STATUS_CLIPPED: HRESULT = 0x087A0002;
pub const DXGI_STATUS_NO_REDIRECTION: HRESULT = 0x087A0004;
pub const DXGI_STATUS_NO_DESKTOP_ACCESS: HRESULT = 0x087A0005;
pub const DXGI_STATUS_GRAPHICS_VIDPN_SOURCE_IN_USE: HRESULT = 0x087A0006;
pub const DXGI_STATUS_MODE_CHANGED: HRESULT = 0x087A0007;
pub const DXGI_STATUS_MODE_CHANGE_IN_PROGRESS: HRESULT = 0x087A0008;
pub const DXGI_ERROR_INVALID_CALL: HRESULT = 0x887A0001u32 as HRESULT;
pub const DXGI_ERROR_NOT_FOUND: HRESULT = 0x887A0002u32 as HRESULT;
pub const DXGI_ERROR_MORE_DATA: HRESULT = 0x887A0003u32 as HRESULT;
pub const DXGI_ERROR_UNSUPPORTED: HRESULT = 0x887A0004u32 as HRESULT;
pub const DXGI_ERROR_DEVICE_REMOVED: HRESULT = 0x887A0005u32 as HRESULT;
pub const DXGI_ERROR_DEVICE_HUNG: HRESULT = 0x887A0006u32 as HRESULT;
pub const DXGI_ERROR_DEVICE_RESET: HRESULT = 0x887A0007u32 as HRESULT;
pub const DXGI_ERROR_WAS_STILL_DRAWING: HRESULT = 0x887A000Au32 as HRESULT;
pub const DXGI_ERROR_FRAME_STATISTICS_DISJOINT: HRESULT = 0x887A000Bu32 as HRESULT;
pub const DXGI_ERROR_GRAPHICS_VIDPN_SOURCE_IN_USE: HRESULT = 0x887A000Cu32 as HRESULT;
pub const DXGI_ERROR_DRIVER_INTERNAL_ERROR: HRESULT = 0x887A0020u32 as HRESULT;
pub const DXGI_ERROR_NONEXCLUSIVE: HRESULT = 0x887A0021u32 as HRESULT;
pub const DXGI_ERROR_NOT_CURRENTLY_AVAILABLE: HRESULT = 0x887A0022u32 as HRESULT;
pub const DXGI_ERROR_REMOTE_CLIENT_DISCONNECTED: HRESULT = 0x887A0023u32 as HRESULT;
pub const DXGI_ERROR_REMOTE_OUTOFMEMORY: HRESULT = 0x887A0024u32 as HRESULT;
pub const DXGI_ERROR_ACCESS_LOST: HRESULT = 0x887A0026u32 as HRESULT;
pub const DXGI_ERROR_WAIT_TIMEOUT: HRESULT = 0x887A0027u32 as HRESULT;
pub const DXGI_ERROR_SESSION_DISCONNECTED: HRESULT = 0x887A0028u32 as HRESULT;
pub const DXGI_ERROR_RESTRICT_TO_OUTPUT_STALE: HRESULT = 0x887A0029u32 as HRESULT;
pub const DXGI_ERROR_CANNOT_PROTECT_CONTENT: HRESULT = 0x887A002Au32 as HRESULT;
pub const DXGI_ERROR_ACCESS_DENIED: HRESULT = 0x887A002Bu32 as HRESULT;
pub const DXGI_ERROR_NAME_ALREADY_EXISTS: HRESULT = 0x887A002Cu32 as HRESULT;
pub const DXGI_ERROR_SDK_COMPONENT_MISSING: HRESULT = 0x887A002Du32 as HRESULT;
pub const DXGI_STATUS_UNOCCLUDED: HRESULT = 0x087A0009;
pub const DXGI_STATUS_DDA_WAS_STILL_DRAWING: HRESULT = 0x087A000A;
pub const DXGI_ERROR_MODE_CHANGE_IN_PROGRESS: HRESULT = 0x887A0025u32 as HRESULT;
pub const DXGI_DDI_ERR_WASSTILLDRAWING: HRESULT = 0x887B0001u32 as HRESULT;
pub const DXGI_DDI_ERR_UNSUPPORTED: HRESULT = 0x887B0002u32 as HRESULT;
pub const DXGI_DDI_ERR_NONEXCLUSIVE: HRESULT = 0x887B0003u32 as HRESULT;
pub const D3D10_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: HRESULT = 0x88790001u32 as HRESULT;
pub const D3D10_ERROR_FILE_NOT_FOUND: HRESULT = 0x88790002u32 as HRESULT;
pub const D3D11_ERROR_TOO_MANY_UNIQUE_STATE_OBJECTS: HRESULT = 0x887C0001u32 as HRESULT;
pub const D3D11_ERROR_FILE_NOT_FOUND: HRESULT = 0x887C0002u32 as HRESULT;
pub const D3D11_ERROR_TOO_MANY_UNIQUE_VIEW_OBJECTS: HRESULT = 0x887C0003u32 as HRESULT;
pub const D3D11_ERROR_DEFERRED_CONTEXT_MAP_WITHOUT_INITIAL_DISCARD: HRESULT = 0x887C0004u32 as HRESULT;
pub const D2DERR_WRONG_STATE: HRESULT = 0x88990001u32 as HRESULT;
pub const D2DERR_NOT_INITIALIZED: HRESULT = 0x88990002u32 as HRESULT;
pub const D2DERR_UNSUPPORTED_OPERATION: HRESULT = 0x88990003u32 as HRESULT;
pub const D2DERR_SCANNER_FAILED: HRESULT = 0x88990004u32 as HRESULT;
pub const D2DERR_SCREEN_ACCESS_DENIED: HRESULT = 0x88990005u32 as HRESULT;
pub const D2DERR_DISPLAY_STATE_INVALID: HRESULT = 0x88990006u32 as HRESULT;
pub const D2DERR_ZERO_VECTOR: HRESULT = 0x88990007u32 as HRESULT;
pub const D2DERR_INTERNAL_ERROR: HRESULT = 0x88990008u32 as HRESULT;
pub const D2DERR_DISPLAY_FORMAT_NOT_SUPPORTED: HRESULT = 0x88990009u32 as HRESULT;
pub const D2DERR_INVALID_CALL: HRESULT = 0x8899000Au32 as HRESULT;
pub const D2DERR_NO_HARDWARE_DEVICE: HRESULT = 0x8899000Bu32 as HRESULT;
pub const D2DERR_RECREATE_TARGET: HRESULT = 0x8899000Cu32 as HRESULT;
pub const D2DERR_TOO_MANY_SHADER_ELEMENTS: HRESULT = 0x8899000Du32 as HRESULT;
pub const D2DERR_SHADER_COMPILE_FAILED: HRESULT = 0x8899000Eu32 as HRESULT;
pub const D2DERR_MAX_TEXTURE_SIZE_EXCEEDED: HRESULT = 0x8899000Fu32 as HRESULT;
pub const D2DERR_UNSUPPORTED_VERSION: HRESULT = 0x88990010u32 as HRESULT;
pub const D2DERR_BAD_NUMBER: HRESULT = 0x88990011u32 as HRESULT;
pub const D2DERR_WRONG_FACTORY: HRESULT = 0x88990012u32 as HRESULT;
pub const D2DERR_LAYER_ALREADY_IN_USE: HRESULT = 0x88990013u32 as HRESULT;
pub const D2DERR_POP_CALL_DID_NOT_MATCH_PUSH: HRESULT = 0x88990014u32 as HRESULT;
pub const D2DERR_WRONG_RESOURCE_DOMAIN: HRESULT = 0x88990015u32 as HRESULT;
pub const D2DERR_PUSH_POP_UNBALANCED: HRESULT = 0x88990016u32 as HRESULT;
pub const D2DERR_RENDER_TARGET_HAS_LAYER_OR_CLIPRECT: HRESULT = 0x88990017u32 as HRESULT;
pub const D2DERR_INCOMPATIBLE_BRUSH_TYPES: HRESULT = 0x88990018u32 as HRESULT;
pub const D2DERR_WIN32_ERROR: HRESULT = 0x88990019u32 as HRESULT;
pub const D2DERR_TARGET_NOT_GDI_COMPATIBLE: HRESULT = 0x8899001Au32 as HRESULT;
pub const D2DERR_TEXT_EFFECT_IS_WRONG_TYPE: HRESULT = 0x8899001Bu32 as HRESULT;
pub const D2DERR_TEXT_RENDERER_NOT_RELEASED: HRESULT = 0x8899001Cu32 as HRESULT;
pub const D2DERR_EXCEEDS_MAX_BITMAP_SIZE: HRESULT = 0x8899001Du32 as HRESULT;
pub const D2DERR_INVALID_GRAPH_CONFIGURATION: HRESULT = 0x8899001Eu32 as HRESULT;
pub const D2DERR_INVALID_INTERNAL_GRAPH_CONFIGURATION: HRESULT = 0x8899001Fu32 as HRESULT;
pub const D2DERR_CYCLIC_GRAPH: HRESULT = 0x88990020u32 as HRESULT;
pub const D2DERR_BITMAP_CANNOT_DRAW: HRESULT = 0x88990021u32 as HRESULT;
pub const D2DERR_OUTSTANDING_BITMAP_REFERENCES: HRESULT = 0x88990022u32 as HRESULT;
pub const D2DERR_ORIGINAL_TARGET_NOT_BOUND: HRESULT = 0x88990023u32 as HRESULT;
pub const D2DERR_INVALID_TARGET: HRESULT = 0x88990024u32 as HRESULT;
pub const D2DERR_BITMAP_BOUND_AS_TARGET: HRESULT = 0x88990025u32 as HRESULT;
pub const D2DERR_INSUFFICIENT_DEVICE_CAPABILITIES: HRESULT = 0x88990026u32 as HRESULT;
pub const D2DERR_INTERMEDIATE_TOO_LARGE: HRESULT = 0x88990027u32 as HRESULT;
pub const D2DERR_EFFECT_IS_NOT_REGISTERED: HRESULT = 0x88990028u32 as HRESULT;
pub const D2DERR_INVALID_PROPERTY: HRESULT = 0x88990029u32 as HRESULT;
pub const D2DERR_NO_SUBPROPERTIES: HRESULT = 0x8899002Au32 as HRESULT;
pub const D2DERR_PRINT_JOB_CLOSED: HRESULT = 0x8899002Bu32 as HRESULT;
pub const D2DERR_PRINT_FORMAT_NOT_SUPPORTED: HRESULT = 0x8899002Cu32 as HRESULT;
pub const D2DERR_TOO_MANY_TRANSFORM_INPUTS: HRESULT = 0x8899002Du32 as HRESULT;
pub const DWRITE_E_FILEFORMAT: HRESULT = 0x88985000u32 as HRESULT;
pub const DWRITE_E_UNEXPECTED: HRESULT = 0x88985001u32 as HRESULT;
pub const DWRITE_E_NOFONT: HRESULT = 0x88985002u32 as HRESULT;
pub const DWRITE_E_FILENOTFOUND: HRESULT = 0x88985003u32 as HRESULT;
pub const DWRITE_E_FILEACCESS: HRESULT = 0x88985004u32 as HRESULT;
pub const DWRITE_E_FONTCOLLECTIONOBSOLETE: HRESULT = 0x88985005u32 as HRESULT;
pub const DWRITE_E_ALREADYREGISTERED: HRESULT = 0x88985006u32 as HRESULT;
pub const DWRITE_E_CACHEFORMAT: HRESULT = 0x88985007u32 as HRESULT;
pub const DWRITE_E_CACHEVERSION: HRESULT = 0x88985008u32 as HRESULT;
pub const DWRITE_E_UNSUPPORTEDOPERATION: HRESULT = 0x88985009u32 as HRESULT;
pub const DWRITE_E_TEXTRENDERERINCOMPATIBLE: HRESULT = 0x8898500Au32 as HRESULT;
pub const DWRITE_E_FLOWDIRECTIONCONFLICTS: HRESULT = 0x8898500Bu32 as HRESULT;
pub const DWRITE_E_NOCOLOR: HRESULT = 0x8898500Cu32 as HRESULT;
pub const WINCODEC_ERR_WRONGSTATE: HRESULT = 0x88982F04u32 as HRESULT;
pub const WINCODEC_ERR_VALUEOUTOFRANGE: HRESULT = 0x88982F05u32 as HRESULT;
pub const WINCODEC_ERR_UNKNOWNIMAGEFORMAT: HRESULT = 0x88982F07u32 as HRESULT;
pub const WINCODEC_ERR_UNSUPPORTEDVERSION: HRESULT = 0x88982F0Bu32 as HRESULT;
pub const WINCODEC_ERR_NOTINITIALIZED: HRESULT = 0x88982F0Cu32 as HRESULT;
pub const WINCODEC_ERR_ALREADYLOCKED: HRESULT = 0x88982F0Du32 as HRESULT;
pub const WINCODEC_ERR_PROPERTYNOTFOUND: HRESULT = 0x88982F40u32 as HRESULT;
pub const WINCODEC_ERR_PROPERTYNOTSUPPORTED: HRESULT = 0x88982F41u32 as HRESULT;
pub const WINCODEC_ERR_PROPERTYSIZE: HRESULT = 0x88982F42u32 as HRESULT;
pub const WINCODEC_ERR_CODECPRESENT: HRESULT = 0x88982F43u32 as HRESULT;
pub const WINCODEC_ERR_CODECNOTHUMBNAIL: HRESULT = 0x88982F44u32 as HRESULT;
pub const WINCODEC_ERR_PALETTEUNAVAILABLE: HRESULT = 0x88982F45u32 as HRESULT;
pub const WINCODEC_ERR_CODECTOOMANYSCANLINES: HRESULT = 0x88982F46u32 as HRESULT;
pub const WINCODEC_ERR_INTERNALERROR: HRESULT = 0x88982F48u32 as HRESULT;
pub const WINCODEC_ERR_SOURCERECTDOESNOTMATCHDIMENSIONS: HRESULT = 0x88982F49u32 as HRESULT;
pub const WINCODEC_ERR_COMPONENTNOTFOUND: HRESULT = 0x88982F50u32 as HRESULT;
pub const WINCODEC_ERR_IMAGESIZEOUTOFRANGE: HRESULT = 0x88982F51u32 as HRESULT;
pub const WINCODEC_ERR_TOOMUCHMETADATA: HRESULT = 0x88982F52u32 as HRESULT;
pub const WINCODEC_ERR_BADIMAGE: HRESULT = 0x88982F60u32 as HRESULT;
pub const WINCODEC_ERR_BADHEADER: HRESULT = 0x88982F61u32 as HRESULT;
pub const WINCODEC_ERR_FRAMEMISSING: HRESULT = 0x88982F62u32 as HRESULT;
pub const WINCODEC_ERR_BADMETADATAHEADER: HRESULT = 0x88982F63u32 as HRESULT;
pub const WINCODEC_ERR_BADSTREAMDATA: HRESULT = 0x88982F70u32 as HRESULT;
pub const WINCODEC_ERR_STREAMWRITE: HRESULT = 0x88982F71u32 as HRESULT;
pub const WINCODEC_ERR_STREAMREAD: HRESULT = 0x88982F72u32 as HRESULT;
pub const WINCODEC_ERR_STREAMNOTAVAILABLE: HRESULT = 0x88982F73u32 as HRESULT;
pub const WINCODEC_ERR_UNSUPPORTEDPIXELFORMAT: HRESULT = 0x88982F80u32 as HRESULT;
pub const WINCODEC_ERR_UNSUPPORTEDOPERATION: HRESULT = 0x88982F81u32 as HRESULT;
pub const WINCODEC_ERR_INVALIDREGISTRATION: HRESULT = 0x88982F8Au32 as HRESULT;
pub const WINCODEC_ERR_COMPONENTINITIALIZEFAILURE: HRESULT = 0x88982F8Bu32 as HRESULT;
pub const WINCODEC_ERR_INSUFFICIENTBUFFER: HRESULT = 0x88982F8Cu32 as HRESULT;
pub const WINCODEC_ERR_DUPLICATEMETADATAPRESENT: HRESULT = 0x88982F8Du32 as HRESULT;
pub const WINCODEC_ERR_PROPERTYUNEXPECTEDTYPE: HRESULT = 0x88982F8Eu32 as HRESULT;
pub const WINCODEC_ERR_UNEXPECTEDSIZE: HRESULT = 0x88982F8Fu32 as HRESULT;
pub const WINCODEC_ERR_INVALIDQUERYREQUEST: HRESULT = 0x88982F90u32 as HRESULT;
pub const WINCODEC_ERR_UNEXPECTEDMETADATATYPE: HRESULT = 0x88982F91u32 as HRESULT;
pub const WINCODEC_ERR_REQUESTONLYVALIDATMETADATAROOT: HRESULT = 0x88982F92u32 as HRESULT;
pub const WINCODEC_ERR_INVALIDQUERYCHARACTER: HRESULT = 0x88982F93u32 as HRESULT;
pub const WINCODEC_ERR_WIN32ERROR: HRESULT = 0x88982F94u32 as HRESULT;
pub const WINCODEC_ERR_INVALIDPROGRESSIVELEVEL: HRESULT = 0x88982F95u32 as HRESULT;
pub const MILERR_OBJECTBUSY: HRESULT = 0x88980001u32 as HRESULT;
pub const MILERR_INSUFFICIENTBUFFER: HRESULT = 0x88980002u32 as HRESULT;
pub const MILERR_WIN32ERROR: HRESULT = 0x88980003u32 as HRESULT;
pub const MILERR_SCANNER_FAILED: HRESULT = 0x88980004u32 as HRESULT;
pub const MILERR_SCREENACCESSDENIED: HRESULT = 0x88980005u32 as HRESULT;
pub const MILERR_DISPLAYSTATEINVALID: HRESULT = 0x88980006u32 as HRESULT;
pub const MILERR_NONINVERTIBLEMATRIX: HRESULT = 0x88980007u32 as HRESULT;
pub const MILERR_ZEROVECTOR: HRESULT = 0x88980008u32 as HRESULT;
pub const MILERR_TERMINATED: HRESULT = 0x88980009u32 as HRESULT;
pub const MILERR_BADNUMBER: HRESULT = 0x8898000Au32 as HRESULT;
pub const MILERR_INTERNALERROR: HRESULT = 0x88980080u32 as HRESULT;
pub const MILERR_DISPLAYFORMATNOTSUPPORTED: HRESULT = 0x88980084u32 as HRESULT;
pub const MILERR_INVALIDCALL: HRESULT = 0x88980085u32 as HRESULT;
pub const MILERR_ALREADYLOCKED: HRESULT = 0x88980086u32 as HRESULT;
pub const MILERR_NOTLOCKED: HRESULT = 0x88980087u32 as HRESULT;
pub const MILERR_DEVICECANNOTRENDERTEXT: HRESULT = 0x88980088u32 as HRESULT;
pub const MILERR_GLYPHBITMAPMISSED: HRESULT = 0x88980089u32 as HRESULT;
pub const MILERR_MALFORMEDGLYPHCACHE: HRESULT = 0x8898008Au32 as HRESULT;
pub const MILERR_GENERIC_IGNORE: HRESULT = 0x8898008Bu32 as HRESULT;
pub const MILERR_MALFORMED_GUIDELINE_DATA: HRESULT = 0x8898008Cu32 as HRESULT;
pub const MILERR_NO_HARDWARE_DEVICE: HRESULT = 0x8898008Du32 as HRESULT;
pub const MILERR_NEED_RECREATE_AND_PRESENT: HRESULT = 0x8898008Eu32 as HRESULT;
pub const MILERR_ALREADY_INITIALIZED: HRESULT = 0x8898008Fu32 as HRESULT;
pub const MILERR_MISMATCHED_SIZE: HRESULT = 0x88980090u32 as HRESULT;
pub const MILERR_NO_REDIRECTION_SURFACE_AVAILABLE: HRESULT = 0x88980091u32 as HRESULT;
pub const MILERR_REMOTING_NOT_SUPPORTED: HRESULT = 0x88980092u32 as HRESULT;
pub const MILERR_QUEUED_PRESENT_NOT_SUPPORTED: HRESULT = 0x88980093u32 as HRESULT;
pub const MILERR_NOT_QUEUING_PRESENTS: HRESULT = 0x88980094u32 as HRESULT;
pub const MILERR_NO_REDIRECTION_SURFACE_RETRY_LATER: HRESULT = 0x88980095u32 as HRESULT;
pub const MILERR_TOOMANYSHADERELEMNTS: HRESULT = 0x88980096u32 as HRESULT;
pub const MILERR_MROW_READLOCK_FAILED: HRESULT = 0x88980097u32 as HRESULT;
pub const MILERR_MROW_UPDATE_FAILED: HRESULT = 0x88980098u32 as HRESULT;
pub const MILERR_SHADER_COMPILE_FAILED: HRESULT = 0x88980099u32 as HRESULT;
pub const MILERR_MAX_TEXTURE_SIZE_EXCEEDED: HRESULT = 0x8898009Au32 as HRESULT;
pub const MILERR_QPC_TIME_WENT_BACKWARD: HRESULT = 0x8898009Bu32 as HRESULT;
pub const MILERR_DXGI_ENUMERATION_OUT_OF_SYNC: HRESULT = 0x8898009Du32 as HRESULT;
pub const MILERR_ADAPTER_NOT_FOUND: HRESULT = 0x8898009Eu32 as HRESULT;
pub const MILERR_COLORSPACE_NOT_SUPPORTED: HRESULT = 0x8898009Fu32 as HRESULT;
pub const MILERR_PREFILTER_NOT_SUPPORTED: HRESULT = 0x889800A0u32 as HRESULT;
pub const MILERR_DISPLAYID_ACCESS_DENIED: HRESULT = 0x889800A1u32 as HRESULT;
pub const UCEERR_INVALIDPACKETHEADER: HRESULT = 0x88980400u32 as HRESULT;
pub const UCEERR_UNKNOWNPACKET: HRESULT = 0x88980401u32 as HRESULT;
pub const UCEERR_ILLEGALPACKET: HRESULT = 0x88980402u32 as HRESULT;
pub const UCEERR_MALFORMEDPACKET: HRESULT = 0x88980403u32 as HRESULT;
pub const UCEERR_ILLEGALHANDLE: HRESULT = 0x88980404u32 as HRESULT;
pub const UCEERR_HANDLELOOKUPFAILED: HRESULT = 0x88980405u32 as HRESULT;
pub const UCEERR_RENDERTHREADFAILURE: HRESULT = 0x88980406u32 as HRESULT;
pub const UCEERR_CTXSTACKFRSTTARGETNULL: HRESULT = 0x88980407u32 as HRESULT;
pub const UCEERR_CONNECTIONIDLOOKUPFAILED: HRESULT = 0x88980408u32 as HRESULT;
pub const UCEERR_BLOCKSFULL: HRESULT = 0x88980409u32 as HRESULT;
pub const UCEERR_MEMORYFAILURE: HRESULT = 0x8898040Au32 as HRESULT;
pub const UCEERR_PACKETRECORDOUTOFRANGE: HRESULT = 0x8898040Bu32 as HRESULT;
pub const UCEERR_ILLEGALRECORDTYPE: HRESULT = 0x8898040Cu32 as HRESULT;
pub const UCEERR_OUTOFHANDLES: HRESULT = 0x8898040Du32 as HRESULT;
pub const UCEERR_UNCHANGABLE_UPDATE_ATTEMPTED: HRESULT = 0x8898040Eu32 as HRESULT;
pub const UCEERR_NO_MULTIPLE_WORKER_THREADS: HRESULT = 0x8898040Fu32 as HRESULT;
pub const UCEERR_REMOTINGNOTSUPPORTED: HRESULT = 0x88980410u32 as HRESULT;
pub const UCEERR_MISSINGENDCOMMAND: HRESULT = 0x88980411u32 as HRESULT;
pub const UCEERR_MISSINGBEGINCOMMAND: HRESULT = 0x88980412u32 as HRESULT;
pub const UCEERR_CHANNELSYNCTIMEDOUT: HRESULT = 0x88980413u32 as HRESULT;
pub const UCEERR_CHANNELSYNCABANDONED: HRESULT = 0x88980414u32 as HRESULT;
pub const UCEERR_UNSUPPORTEDTRANSPORTVERSION: HRESULT = 0x88980415u32 as HRESULT;
pub const UCEERR_TRANSPORTUNAVAILABLE: HRESULT = 0x88980416u32 as HRESULT;
pub const UCEERR_FEEDBACK_UNSUPPORTED: HRESULT = 0x88980417u32 as HRESULT;
pub const UCEERR_COMMANDTRANSPORTDENIED: HRESULT = 0x88980418u32 as HRESULT;
pub const UCEERR_GRAPHICSSTREAMUNAVAILABLE: HRESULT = 0x88980419u32 as HRESULT;
pub const UCEERR_GRAPHICSSTREAMALREADYOPEN: HRESULT = 0x88980420u32 as HRESULT;
pub const UCEERR_TRANSPORTDISCONNECTED: HRESULT = 0x88980421u32 as HRESULT;
pub const UCEERR_TRANSPORTOVERLOADED: HRESULT = 0x88980422u32 as HRESULT;
pub const UCEERR_PARTITION_ZOMBIED: HRESULT = 0x88980423u32 as HRESULT;
pub const MILAVERR_NOCLOCK: HRESULT = 0x88980500u32 as HRESULT;
pub const MILAVERR_NOMEDIATYPE: HRESULT = 0x88980501u32 as HRESULT;
pub const MILAVERR_NOVIDEOMIXER: HRESULT = 0x88980502u32 as HRESULT;
pub const MILAVERR_NOVIDEOPRESENTER: HRESULT = 0x88980503u32 as HRESULT;
pub const MILAVERR_NOREADYFRAMES: HRESULT = 0x88980504u32 as HRESULT;
pub const MILAVERR_MODULENOTLOADED: HRESULT = 0x88980505u32 as HRESULT;
pub const MILAVERR_WMPFACTORYNOTREGISTERED: HRESULT = 0x88980506u32 as HRESULT;
pub const MILAVERR_INVALIDWMPVERSION: HRESULT = 0x88980507u32 as HRESULT;
pub const MILAVERR_INSUFFICIENTVIDEORESOURCES: HRESULT = 0x88980508u32 as HRESULT;
pub const MILAVERR_VIDEOACCELERATIONNOTAVAILABLE: HRESULT = 0x88980509u32 as HRESULT;
pub const MILAVERR_REQUESTEDTEXTURETOOBIG: HRESULT = 0x8898050Au32 as HRESULT;
pub const MILAVERR_SEEKFAILED: HRESULT = 0x8898050Bu32 as HRESULT;
pub const MILAVERR_UNEXPECTEDWMPFAILURE: HRESULT = 0x8898050Cu32 as HRESULT;
pub const MILAVERR_MEDIAPLAYERCLOSED: HRESULT = 0x8898050Du32 as HRESULT;
pub const MILAVERR_UNKNOWNHARDWAREERROR: HRESULT = 0x8898050Eu32 as HRESULT;
pub const MILEFFECTSERR_UNKNOWNPROPERTY: HRESULT = 0x8898060Eu32 as HRESULT;
pub const MILEFFECTSERR_EFFECTNOTPARTOFGROUP: HRESULT = 0x8898060Fu32 as HRESULT;
pub const MILEFFECTSERR_NOINPUTSOURCEATTACHED: HRESULT = 0x88980610u32 as HRESULT;
pub const MILEFFECTSERR_CONNECTORNOTCONNECTED: HRESULT = 0x88980611u32 as HRESULT;
pub const MILEFFECTSERR_CONNECTORNOTASSOCIATEDWITHEFFECT: HRESULT = 0x88980612u32 as HRESULT;
pub const MILEFFECTSERR_RESERVED: HRESULT = 0x88980613u32 as HRESULT;
pub const MILEFFECTSERR_CYCLEDETECTED: HRESULT = 0x88980614u32 as HRESULT;
pub const MILEFFECTSERR_EFFECTINMORETHANONEGRAPH: HRESULT = 0x88980615u32 as HRESULT;
pub const MILEFFECTSERR_EFFECTALREADYINAGRAPH: HRESULT = 0x88980616u32 as HRESULT;
pub const MILEFFECTSERR_EFFECTHASNOCHILDREN: HRESULT = 0x88980617u32 as HRESULT;
pub const MILEFFECTSERR_ALREADYATTACHEDTOLISTENER: HRESULT = 0x88980618u32 as HRESULT;
pub const MILEFFECTSERR_NOTAFFINETRANSFORM: HRESULT = 0x88980619u32 as HRESULT;
pub const MILEFFECTSERR_EMPTYBOUNDS: HRESULT = 0x8898061Au32 as HRESULT;
pub const MILEFFECTSERR_OUTPUTSIZETOOLARGE: HRESULT = 0x8898061Bu32 as HRESULT;
pub const DWMERR_STATE_TRANSITION_FAILED: HRESULT = 0x88980700u32 as HRESULT;
pub const DWMERR_THEME_FAILED: HRESULT = 0x88980701u32 as HRESULT;
pub const DWMERR_CATASTROPHIC_FAILURE: HRESULT = 0x88980702u32 as HRESULT;
pub const DCOMPOSITION_ERROR_WINDOW_ALREADY_COMPOSED: HRESULT = 0x88980800u32 as HRESULT;
pub const DCOMPOSITION_ERROR_SURFACE_BEING_RENDERED: HRESULT = 0x88980801u32 as HRESULT;
pub const DCOMPOSITION_ERROR_SURFACE_NOT_BEING_RENDERED: HRESULT = 0x88980802u32 as HRESULT;
pub const ONL_E_INVALID_AUTHENTICATION_TARGET: HRESULT = 0x80860001u32 as HRESULT;
pub const ONL_E_ACCESS_DENIED_BY_TOU: HRESULT = 0x80860002u32 as HRESULT;
pub const ONL_E_INVALID_APPLICATION: HRESULT = 0x80860003u32 as HRESULT;
pub const ONL_E_PASSWORD_UPDATE_REQUIRED: HRESULT = 0x80860004u32 as HRESULT;
pub const ONL_E_ACCOUNT_UPDATE_REQUIRED: HRESULT = 0x80860005u32 as HRESULT;
pub const ONL_E_FORCESIGNIN: HRESULT = 0x80860006u32 as HRESULT;
pub const ONL_E_ACCOUNT_LOCKED: HRESULT = 0x80860007u32 as HRESULT;
pub const ONL_E_PARENTAL_CONSENT_REQUIRED: HRESULT = 0x80860008u32 as HRESULT;
pub const ONL_E_EMAIL_VERIFICATION_REQUIRED: HRESULT = 0x80860009u32 as HRESULT;
pub const ONL_E_ACCOUNT_SUSPENDED_COMPROIMISE: HRESULT = 0x8086000Au32 as HRESULT;
pub const ONL_E_ACCOUNT_SUSPENDED_ABUSE: HRESULT = 0x8086000Bu32 as HRESULT;
pub const ONL_E_ACTION_REQUIRED: HRESULT = 0x8086000Cu32 as HRESULT;
pub const ONL_CONNECTION_COUNT_LIMIT: HRESULT = 0x8086000Du32 as HRESULT;
pub const ONL_E_CONNECTED_ACCOUNT_CAN_NOT_SIGNOUT: HRESULT = 0x8086000Eu32 as HRESULT;
pub const ONL_E_USER_AUTHENTICATION_REQUIRED: HRESULT = 0x8086000Fu32 as HRESULT;
pub const ONL_E_REQUEST_THROTTLED: HRESULT = 0x80860010u32 as HRESULT;
pub const FA_E_MAX_PERSISTED_ITEMS_REACHED: HRESULT = 0x80270220u32 as HRESULT;
pub const FA_E_HOMEGROUP_NOT_AVAILABLE: HRESULT = 0x80270222u32 as HRESULT;
pub const E_MONITOR_RESOLUTION_TOO_LOW: HRESULT = 0x80270250u32 as HRESULT;
pub const E_ELEVATED_ACTIVATION_NOT_SUPPORTED: HRESULT = 0x80270251u32 as HRESULT;
pub const E_UAC_DISABLED: HRESULT = 0x80270252u32 as HRESULT;
pub const E_FULL_ADMIN_NOT_SUPPORTED: HRESULT = 0x80270253u32 as HRESULT;
pub const E_APPLICATION_NOT_REGISTERED: HRESULT = 0x80270254u32 as HRESULT;
pub const E_MULTIPLE_EXTENSIONS_FOR_APPLICATION: HRESULT = 0x80270255u32 as HRESULT;
pub const E_MULTIPLE_PACKAGES_FOR_FAMILY: HRESULT = 0x80270256u32 as HRESULT;
pub const E_APPLICATION_MANAGER_NOT_RUNNING: HRESULT = 0x80270257u32 as HRESULT;
pub const S_STORE_LAUNCHED_FOR_REMEDIATION: HRESULT = 0x00270258;
pub const S_APPLICATION_ACTIVATION_ERROR_HANDLED_BY_DIALOG: HRESULT = 0x00270259;
pub const E_APPLICATION_ACTIVATION_TIMED_OUT: HRESULT = 0x8027025Au32 as HRESULT;
pub const E_APPLICATION_ACTIVATION_EXEC_FAILURE: HRESULT = 0x8027025Bu32 as HRESULT;
pub const E_APPLICATION_TEMPORARY_LICENSE_ERROR: HRESULT = 0x8027025Cu32 as HRESULT;
pub const E_APPLICATION_TRIAL_LICENSE_EXPIRED: HRESULT = 0x8027025Du32 as HRESULT;
pub const E_SKYDRIVE_ROOT_TARGET_FILE_SYSTEM_NOT_SUPPORTED: HRESULT = 0x80270260u32 as HRESULT;
pub const E_SKYDRIVE_ROOT_TARGET_OVERLAP: HRESULT = 0x80270261u32 as HRESULT;
pub const E_SKYDRIVE_ROOT_TARGET_CANNOT_INDEX: HRESULT = 0x80270262u32 as HRESULT;
pub const E_SKYDRIVE_FILE_NOT_UPLOADED: HRESULT = 0x80270263u32 as HRESULT;
pub const E_SKYDRIVE_UPDATE_AVAILABILITY_FAIL: HRESULT = 0x80270264u32 as HRESULT;
pub const E_SKYDRIVE_ROOT_TARGET_VOLUME_ROOT_NOT_SUPPORTED: HRESULT = 0x80270265u32 as HRESULT;
pub const E_SYNCENGINE_FILE_SIZE_OVER_LIMIT: HRESULT = 0x8802B001u32 as HRESULT;
pub const E_SYNCENGINE_FILE_SIZE_EXCEEDS_REMAINING_QUOTA: HRESULT = 0x8802B002u32 as HRESULT;
pub const E_SYNCENGINE_UNSUPPORTED_FILE_NAME: HRESULT = 0x8802B003u32 as HRESULT;
pub const E_SYNCENGINE_FOLDER_ITEM_COUNT_LIMIT_EXCEEDED: HRESULT = 0x8802B004u32 as HRESULT;
pub const E_SYNCENGINE_FILE_SYNC_PARTNER_ERROR: HRESULT = 0x8802B005u32 as HRESULT;
pub const E_SYNCENGINE_SYNC_PAUSED_BY_SERVICE: HRESULT = 0x8802B006u32 as HRESULT;
pub const E_SYNCENGINE_FILE_IDENTIFIER_UNKNOWN: HRESULT = 0x8802C002u32 as HRESULT;
pub const E_SYNCENGINE_SERVICE_AUTHENTICATION_FAILED: HRESULT = 0x8802C003u32 as HRESULT;
pub const E_SYNCENGINE_UNKNOWN_SERVICE_ERROR: HRESULT = 0x8802C004u32 as HRESULT;
pub const E_SYNCENGINE_SERVICE_RETURNED_UNEXPECTED_SIZE: HRESULT = 0x8802C005u32 as HRESULT;
pub const E_SYNCENGINE_REQUEST_BLOCKED_BY_SERVICE: HRESULT = 0x8802C006u32 as HRESULT;
pub const E_SYNCENGINE_REQUEST_BLOCKED_DUE_TO_CLIENT_ERROR: HRESULT = 0x8802C007u32 as HRESULT;
pub const E_SYNCENGINE_FOLDER_INACCESSIBLE: HRESULT = 0x8802D001u32 as HRESULT;
pub const E_SYNCENGINE_UNSUPPORTED_FOLDER_NAME: HRESULT = 0x8802D002u32 as HRESULT;
pub const E_SYNCENGINE_UNSUPPORTED_MARKET: HRESULT = 0x8802D003u32 as HRESULT;
pub const E_SYNCENGINE_PATH_LENGTH_LIMIT_EXCEEDED: HRESULT = 0x8802D004u32 as HRESULT;
pub const E_SYNCENGINE_REMOTE_PATH_LENGTH_LIMIT_EXCEEDED: HRESULT = 0x8802D005u32 as HRESULT;
pub const E_SYNCENGINE_CLIENT_UPDATE_NEEDED: HRESULT = 0x8802D006u32 as HRESULT;
pub const E_SYNCENGINE_PROXY_AUTHENTICATION_REQUIRED: HRESULT = 0x8802D007u32 as HRESULT;
pub const E_SYNCENGINE_STORAGE_SERVICE_PROVISIONING_FAILED: HRESULT = 0x8802D008u32 as HRESULT;
pub const E_SYNCENGINE_UNSUPPORTED_REPARSE_POINT: HRESULT = 0x8802D009u32 as HRESULT;
pub const E_SYNCENGINE_STORAGE_SERVICE_BLOCKED: HRESULT = 0x8802D00Au32 as HRESULT;
pub const E_SYNCENGINE_FOLDER_IN_REDIRECTION: HRESULT = 0x8802D00Bu32 as HRESULT;
pub const EAS_E_POLICY_NOT_MANAGED_BY_OS: HRESULT = 0x80550001u32 as HRESULT;
pub const EAS_E_POLICY_COMPLIANT_WITH_ACTIONS: HRESULT = 0x80550002u32 as HRESULT;
pub const EAS_E_REQUESTED_POLICY_NOT_ENFORCEABLE: HRESULT = 0x80550003u32 as HRESULT;
pub const EAS_E_CURRENT_USER_HAS_BLANK_PASSWORD: HRESULT = 0x80550004u32 as HRESULT;
pub const EAS_E_REQUESTED_POLICY_PASSWORD_EXPIRATION_INCOMPATIBLE: HRESULT = 0x80550005u32 as HRESULT;
pub const EAS_E_USER_CANNOT_CHANGE_PASSWORD: HRESULT = 0x80550006u32 as HRESULT;
pub const EAS_E_ADMINS_HAVE_BLANK_PASSWORD: HRESULT = 0x80550007u32 as HRESULT;
pub const EAS_E_ADMINS_CANNOT_CHANGE_PASSWORD: HRESULT = 0x80550008u32 as HRESULT;
pub const EAS_E_LOCAL_CONTROLLED_USERS_CANNOT_CHANGE_PASSWORD: HRESULT = 0x80550009u32 as HRESULT;
pub const EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CONNECTED_ADMINS: HRESULT = 0x8055000Au32 as HRESULT;
pub const EAS_E_CONNECTED_ADMINS_NEED_TO_CHANGE_PASSWORD: HRESULT = 0x8055000Bu32 as HRESULT;
pub const EAS_E_PASSWORD_POLICY_NOT_ENFORCEABLE_FOR_CURRENT_CONNECTED_USER: HRESULT = 0x8055000Cu32 as HRESULT;
pub const EAS_E_CURRENT_CONNECTED_USER_NEED_TO_CHANGE_PASSWORD: HRESULT = 0x8055000Du32 as HRESULT;
pub const WEB_E_UNSUPPORTED_FORMAT: HRESULT = 0x83750001u32 as HRESULT;
pub const WEB_E_INVALID_XML: HRESULT = 0x83750002u32 as HRESULT;
pub const WEB_E_MISSING_REQUIRED_ELEMENT: HRESULT = 0x83750003u32 as HRESULT;
pub const WEB_E_MISSING_REQUIRED_ATTRIBUTE: HRESULT = 0x83750004u32 as HRESULT;
pub const WEB_E_UNEXPECTED_CONTENT: HRESULT = 0x83750005u32 as HRESULT;
pub const WEB_E_RESOURCE_TOO_LARGE: HRESULT = 0x83750006u32 as HRESULT;
pub const WEB_E_INVALID_JSON_STRING: HRESULT = 0x83750007u32 as HRESULT;
pub const WEB_E_INVALID_JSON_NUMBER: HRESULT = 0x83750008u32 as HRESULT;
pub const WEB_E_JSON_VALUE_NOT_FOUND: HRESULT = 0x83750009u32 as HRESULT;
pub const HTTP_E_STATUS_UNEXPECTED: HRESULT = 0x80190001u32 as HRESULT;
pub const HTTP_E_STATUS_UNEXPECTED_REDIRECTION: HRESULT = 0x80190003u32 as HRESULT;
pub const HTTP_E_STATUS_UNEXPECTED_CLIENT_ERROR: HRESULT = 0x80190004u32 as HRESULT;
pub const HTTP_E_STATUS_UNEXPECTED_SERVER_ERROR: HRESULT = 0x80190005u32 as HRESULT;
pub const HTTP_E_STATUS_AMBIGUOUS: HRESULT = 0x8019012Cu32 as HRESULT;
pub const HTTP_E_STATUS_MOVED: HRESULT = 0x8019012Du32 as HRESULT;
pub const HTTP_E_STATUS_REDIRECT: HRESULT = 0x8019012Eu32 as HRESULT;
pub const HTTP_E_STATUS_REDIRECT_METHOD: HRESULT = 0x8019012Fu32 as HRESULT;
pub const HTTP_E_STATUS_NOT_MODIFIED: HRESULT = 0x80190130u32 as HRESULT;
pub const HTTP_E_STATUS_USE_PROXY: HRESULT = 0x80190131u32 as HRESULT;
pub const HTTP_E_STATUS_REDIRECT_KEEP_VERB: HRESULT = 0x80190133u32 as HRESULT;
pub const HTTP_E_STATUS_BAD_REQUEST: HRESULT = 0x80190190u32 as HRESULT;
pub const HTTP_E_STATUS_DENIED: HRESULT = 0x80190191u32 as HRESULT;
pub const HTTP_E_STATUS_PAYMENT_REQ: HRESULT = 0x80190192u32 as HRESULT;
pub const HTTP_E_STATUS_FORBIDDEN: HRESULT = 0x80190193u32 as HRESULT;
pub const HTTP_E_STATUS_NOT_FOUND: HRESULT = 0x80190194u32 as HRESULT;
pub const HTTP_E_STATUS_BAD_METHOD: HRESULT = 0x80190195u32 as HRESULT;
pub const HTTP_E_STATUS_NONE_ACCEPTABLE: HRESULT = 0x80190196u32 as HRESULT;
pub const HTTP_E_STATUS_PROXY_AUTH_REQ: HRESULT = 0x80190197u32 as HRESULT;
pub const HTTP_E_STATUS_REQUEST_TIMEOUT: HRESULT = 0x80190198u32 as HRESULT;
pub const HTTP_E_STATUS_CONFLICT: HRESULT = 0x80190199u32 as HRESULT;
pub const HTTP_E_STATUS_GONE: HRESULT = 0x8019019Au32 as HRESULT;
pub const HTTP_E_STATUS_LENGTH_REQUIRED: HRESULT = 0x8019019Bu32 as HRESULT;
pub const HTTP_E_STATUS_PRECOND_FAILED: HRESULT = 0x8019019Cu32 as HRESULT;
pub const HTTP_E_STATUS_REQUEST_TOO_LARGE: HRESULT = 0x8019019Du32 as HRESULT;
pub const HTTP_E_STATUS_URI_TOO_LONG: HRESULT = 0x8019019Eu32 as HRESULT;
pub const HTTP_E_STATUS_UNSUPPORTED_MEDIA: HRESULT = 0x8019019Fu32 as HRESULT;
pub const HTTP_E_STATUS_RANGE_NOT_SATISFIABLE: HRESULT = 0x801901A0u32 as HRESULT;
pub const HTTP_E_STATUS_EXPECTATION_FAILED: HRESULT = 0x801901A1u32 as HRESULT;
pub const HTTP_E_STATUS_SERVER_ERROR: HRESULT = 0x801901F4u32 as HRESULT;
pub const HTTP_E_STATUS_NOT_SUPPORTED: HRESULT = 0x801901F5u32 as HRESULT;
pub const HTTP_E_STATUS_BAD_GATEWAY: HRESULT = 0x801901F6u32 as HRESULT;
pub const HTTP_E_STATUS_SERVICE_UNAVAIL: HRESULT = 0x801901F7u32 as HRESULT;
pub const HTTP_E_STATUS_GATEWAY_TIMEOUT: HRESULT = 0x801901F8u32 as HRESULT;
pub const HTTP_E_STATUS_VERSION_NOT_SUP: HRESULT = 0x801901F9u32 as HRESULT;
pub const E_INVALID_PROTOCOL_OPERATION: HRESULT = 0x83760001u32 as HRESULT;
pub const E_INVALID_PROTOCOL_FORMAT: HRESULT = 0x83760002u32 as HRESULT;
pub const E_PROTOCOL_EXTENSIONS_NOT_SUPPORTED: HRESULT = 0x83760003u32 as HRESULT;
pub const E_SUBPROTOCOL_NOT_SUPPORTED: HRESULT = 0x83760004u32 as HRESULT;
pub const E_PROTOCOL_VERSION_NOT_SUPPORTED: HRESULT = 0x83760005u32 as HRESULT;
pub const INPUT_E_OUT_OF_ORDER: HRESULT = 0x80400000u32 as HRESULT;
pub const INPUT_E_REENTRANCY: HRESULT = 0x80400001u32 as HRESULT;
pub const INPUT_E_MULTIMODAL: HRESULT = 0x80400002u32 as HRESULT;
pub const INPUT_E_PACKET: HRESULT = 0x80400003u32 as HRESULT;
pub const INPUT_E_FRAME: HRESULT = 0x80400004u32 as HRESULT;
pub const INPUT_E_HISTORY: HRESULT = 0x80400005u32 as HRESULT;
pub const INPUT_E_DEVICE_INFO: HRESULT = 0x80400006u32 as HRESULT;
pub const INPUT_E_TRANSFORM: HRESULT = 0x80400007u32 as HRESULT;
pub const INPUT_E_DEVICE_PROPERTY: HRESULT = 0x80400008u32 as HRESULT;
pub const INET_E_INVALID_URL: HRESULT = 0x800C0002u32 as HRESULT;
pub const INET_E_NO_SESSION: HRESULT = 0x800C0003u32 as HRESULT;
pub const INET_E_CANNOT_CONNECT: HRESULT = 0x800C0004u32 as HRESULT;
pub const INET_E_RESOURCE_NOT_FOUND: HRESULT = 0x800C0005u32 as HRESULT;
pub const INET_E_OBJECT_NOT_FOUND: HRESULT = 0x800C0006u32 as HRESULT;
pub const INET_E_DATA_NOT_AVAILABLE: HRESULT = 0x800C0007u32 as HRESULT;
pub const INET_E_DOWNLOAD_FAILURE: HRESULT = 0x800C0008u32 as HRESULT;
pub const INET_E_AUTHENTICATION_REQUIRED: HRESULT = 0x800C0009u32 as HRESULT;
pub const INET_E_NO_VALID_MEDIA: HRESULT = 0x800C000Au32 as HRESULT;
pub const INET_E_CONNECTION_TIMEOUT: HRESULT = 0x800C000Bu32 as HRESULT;
pub const INET_E_INVALID_REQUEST: HRESULT = 0x800C000Cu32 as HRESULT;
pub const INET_E_UNKNOWN_PROTOCOL: HRESULT = 0x800C000Du32 as HRESULT;
pub const INET_E_SECURITY_PROBLEM: HRESULT = 0x800C000Eu32 as HRESULT;
pub const INET_E_CANNOT_LOAD_DATA: HRESULT = 0x800C000Fu32 as HRESULT;
pub const INET_E_CANNOT_INSTANTIATE_OBJECT: HRESULT = 0x800C0010u32 as HRESULT;
pub const INET_E_INVALID_CERTIFICATE: HRESULT = 0x800C0019u32 as HRESULT;
pub const INET_E_REDIRECT_FAILED: HRESULT = 0x800C0014u32 as HRESULT;
pub const INET_E_REDIRECT_TO_DIR: HRESULT = 0x800C0015u32 as HRESULT;
pub const ERROR_DBG_CREATE_PROCESS_FAILURE_LOCKDOWN: HRESULT = 0x80B00001u32 as HRESULT;
pub const ERROR_DBG_ATTACH_PROCESS_FAILURE_LOCKDOWN: HRESULT = 0x80B00002u32 as HRESULT;
pub const ERROR_DBG_CONNECT_SERVER_FAILURE_LOCKDOWN: HRESULT = 0x80B00003u32 as HRESULT;
pub const ERROR_DBG_START_SERVER_FAILURE_LOCKDOWN: HRESULT = 0x80B00004u32 as HRESULT;
pub const ERROR_IO_PREEMPTED: HRESULT = 0x89010001u32 as HRESULT;
pub const JSCRIPT_E_CANTEXECUTE: HRESULT = 0x89020001u32 as HRESULT;
pub const WEP_E_NOT_PROVISIONED_ON_ALL_VOLUMES: HRESULT = 0x88010001u32 as HRESULT;
pub const WEP_E_FIXED_DATA_NOT_SUPPORTED: HRESULT = 0x88010002u32 as HRESULT;
pub const WEP_E_HARDWARE_NOT_COMPLIANT: HRESULT = 0x88010003u32 as HRESULT;
pub const WEP_E_LOCK_NOT_CONFIGURED: HRESULT = 0x88010004u32 as HRESULT;
pub const WEP_E_PROTECTION_SUSPENDED: HRESULT = 0x88010005u32 as HRESULT;
pub const WEP_E_NO_LICENSE: HRESULT = 0x88010006u32 as HRESULT;
pub const WEP_E_OS_NOT_PROTECTED: HRESULT = 0x88010007u32 as HRESULT;
pub const WEP_E_UNEXPECTED_FAIL: HRESULT = 0x88010008u32 as HRESULT;
pub const WEP_E_BUFFER_TOO_LARGE: HRESULT = 0x88010009u32 as HRESULT;
pub const ERROR_SVHDX_ERROR_STORED: HRESULT = 0xC05C0000u32 as HRESULT;
pub const ERROR_SVHDX_ERROR_NOT_AVAILABLE: HRESULT = 0xC05CFF00u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_AVAILABLE: HRESULT = 0xC05CFF01u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_CAPACITY_DATA_CHANGED: HRESULT = 0xC05CFF02u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_PREEMPTED: HRESULT = 0xC05CFF03u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_RESERVATIONS_RELEASED: HRESULT = 0xC05CFF04u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_REGISTRATIONS_PREEMPTED: HRESULT = 0xC05CFF05u32 as HRESULT;
pub const ERROR_SVHDX_UNIT_ATTENTION_OPERATING_DEFINITION_CHANGED: HRESULT = 0xC05CFF06u32 as HRESULT;
pub const ERROR_SVHDX_RESERVATION_CONFLICT: HRESULT = 0xC05CFF07u32 as HRESULT;
pub const ERROR_SVHDX_WRONG_FILE_TYPE: HRESULT = 0xC05CFF08u32 as HRESULT;
pub const ERROR_SVHDX_VERSION_MISMATCH: HRESULT = 0xC05CFF09u32 as HRESULT;
pub const ERROR_VHD_SHARED: HRESULT = 0xC05CFF0Au32 as HRESULT;
pub const WININET_E_OUT_OF_HANDLES: HRESULT = 0x80072EE1u32 as HRESULT;
pub const WININET_E_TIMEOUT: HRESULT = 0x80072EE2u32 as HRESULT;
pub const WININET_E_EXTENDED_ERROR: HRESULT = 0x80072EE3u32 as HRESULT;
pub const WININET_E_INTERNAL_ERROR: HRESULT = 0x80072EE4u32 as HRESULT;
pub const WININET_E_INVALID_URL: HRESULT = 0x80072EE5u32 as HRESULT;
pub const WININET_E_UNRECOGNIZED_SCHEME: HRESULT = 0x80072EE6u32 as HRESULT;
pub const WININET_E_NAME_NOT_RESOLVED: HRESULT = 0x80072EE7u32 as HRESULT;
pub const WININET_E_PROTOCOL_NOT_FOUND: HRESULT = 0x80072EE8u32 as HRESULT;
pub const WININET_E_INVALID_OPTION: HRESULT = 0x80072EE9u32 as HRESULT;
pub const WININET_E_BAD_OPTION_LENGTH: HRESULT = 0x80072EEAu32 as HRESULT;
pub const WININET_E_OPTION_NOT_SETTABLE: HRESULT = 0x80072EEBu32 as HRESULT;
pub const WININET_E_SHUTDOWN: HRESULT = 0x80072EECu32 as HRESULT;
pub const WININET_E_INCORRECT_USER_NAME: HRESULT = 0x80072EEDu32 as HRESULT;
pub const WININET_E_INCORRECT_PASSWORD: HRESULT = 0x80072EEEu32 as HRESULT;
pub const WININET_E_LOGIN_FAILURE: HRESULT = 0x80072EEFu32 as HRESULT;
pub const WININET_E_INVALID_OPERATION: HRESULT = 0x80072EF0u32 as HRESULT;
pub const WININET_E_OPERATION_CANCELLED: HRESULT = 0x80072EF1u32 as HRESULT;
pub const WININET_E_INCORRECT_HANDLE_TYPE: HRESULT = 0x80072EF2u32 as HRESULT;
pub const WININET_E_INCORRECT_HANDLE_STATE: HRESULT = 0x80072EF3u32 as HRESULT;
pub const WININET_E_NOT_PROXY_REQUEST: HRESULT = 0x80072EF4u32 as HRESULT;
pub const WININET_E_REGISTRY_VALUE_NOT_FOUND: HRESULT = 0x80072EF5u32 as HRESULT;
pub const WININET_E_BAD_REGISTRY_PARAMETER: HRESULT = 0x80072EF6u32 as HRESULT;
pub const WININET_E_NO_DIRECT_ACCESS: HRESULT = 0x80072EF7u32 as HRESULT;
pub const WININET_E_NO_CONTEXT: HRESULT = 0x80072EF8u32 as HRESULT;
pub const WININET_E_NO_CALLBACK: HRESULT = 0x80072EF9u32 as HRESULT;
pub const WININET_E_REQUEST_PENDING: HRESULT = 0x80072EFAu32 as HRESULT;
pub const WININET_E_INCORRECT_FORMAT: HRESULT = 0x80072EFBu32 as HRESULT;
pub const WININET_E_ITEM_NOT_FOUND: HRESULT = 0x80072EFCu32 as HRESULT;
pub const WININET_E_CANNOT_CONNECT: HRESULT = 0x80072EFDu32 as HRESULT;
pub const WININET_E_CONNECTION_ABORTED: HRESULT = 0x80072EFEu32 as HRESULT;
pub const WININET_E_CONNECTION_RESET: HRESULT = 0x80072EFFu32 as HRESULT;
pub const WININET_E_FORCE_RETRY: HRESULT = 0x80072F00u32 as HRESULT;
pub const WININET_E_INVALID_PROXY_REQUEST: HRESULT = 0x80072F01u32 as HRESULT;
pub const WININET_E_NEED_UI: HRESULT = 0x80072F02u32 as HRESULT;
pub const WININET_E_HANDLE_EXISTS: HRESULT = 0x80072F04u32 as HRESULT;
pub const WININET_E_SEC_CERT_DATE_INVALID: HRESULT = 0x80072F05u32 as HRESULT;
pub const WININET_E_SEC_CERT_CN_INVALID: HRESULT = 0x80072F06u32 as HRESULT;
pub const WININET_E_HTTP_TO_HTTPS_ON_REDIR: HRESULT = 0x80072F07u32 as HRESULT;
pub const WININET_E_HTTPS_TO_HTTP_ON_REDIR: HRESULT = 0x80072F08u32 as HRESULT;
pub const WININET_E_MIXED_SECURITY: HRESULT = 0x80072F09u32 as HRESULT;
pub const WININET_E_CHG_POST_IS_NON_SECURE: HRESULT = 0x80072F0Au32 as HRESULT;
pub const WININET_E_POST_IS_NON_SECURE: HRESULT = 0x80072F0Bu32 as HRESULT;
pub const WININET_E_CLIENT_AUTH_CERT_NEEDED: HRESULT = 0x80072F0Cu32 as HRESULT;
pub const WININET_E_INVALID_CA: HRESULT = 0x80072F0Du32 as HRESULT;
pub const WININET_E_CLIENT_AUTH_NOT_SETUP: HRESULT = 0x80072F0Eu32 as HRESULT;
pub const WININET_E_ASYNC_THREAD_FAILED: HRESULT = 0x80072F0Fu32 as HRESULT;
pub const WININET_E_REDIRECT_SCHEME_CHANGE: HRESULT = 0x80072F10u32 as HRESULT;
pub const WININET_E_DIALOG_PENDING: HRESULT = 0x80072F11u32 as HRESULT;
pub const WININET_E_RETRY_DIALOG: HRESULT = 0x80072F12u32 as HRESULT;
pub const WININET_E_NO_NEW_CONTAINERS: HRESULT = 0x80072F13u32 as HRESULT;
pub const WININET_E_HTTPS_HTTP_SUBMIT_REDIR: HRESULT = 0x80072F14u32 as HRESULT;
pub const WININET_E_SEC_CERT_ERRORS: HRESULT = 0x80072F17u32 as HRESULT;
pub const WININET_E_SEC_CERT_REV_FAILED: HRESULT = 0x80072F19u32 as HRESULT;
pub const WININET_E_HEADER_NOT_FOUND: HRESULT = 0x80072F76u32 as HRESULT;
pub const WININET_E_DOWNLEVEL_SERVER: HRESULT = 0x80072F77u32 as HRESULT;
pub const WININET_E_INVALID_SERVER_RESPONSE: HRESULT = 0x80072F78u32 as HRESULT;
pub const WININET_E_INVALID_HEADER: HRESULT = 0x80072F79u32 as HRESULT;
pub const WININET_E_INVALID_QUERY_REQUEST: HRESULT = 0x80072F7Au32 as HRESULT;
pub const WININET_E_HEADER_ALREADY_EXISTS: HRESULT = 0x80072F7Bu32 as HRESULT;
pub const WININET_E_REDIRECT_FAILED: HRESULT = 0x80072F7Cu32 as HRESULT;
pub const WININET_E_SECURITY_CHANNEL_ERROR: HRESULT = 0x80072F7Du32 as HRESULT;
pub const WININET_E_UNABLE_TO_CACHE_FILE: HRESULT = 0x80072F7Eu32 as HRESULT;
pub const WININET_E_TCPIP_NOT_INSTALLED: HRESULT = 0x80072F7Fu32 as HRESULT;
pub const WININET_E_DISCONNECTED: HRESULT = 0x80072F83u32 as HRESULT;
pub const WININET_E_SERVER_UNREACHABLE: HRESULT = 0x80072F84u32 as HRESULT;
pub const WININET_E_PROXY_SERVER_UNREACHABLE: HRESULT = 0x80072F85u32 as HRESULT;
pub const WININET_E_BAD_AUTO_PROXY_SCRIPT: HRESULT = 0x80072F86u32 as HRESULT;
pub const WININET_E_UNABLE_TO_DOWNLOAD_SCRIPT: HRESULT = 0x80072F87u32 as HRESULT;
pub const WININET_E_SEC_INVALID_CERT: HRESULT = 0x80072F89u32 as HRESULT;
pub const WININET_E_SEC_CERT_REVOKED: HRESULT = 0x80072F8Au32 as HRESULT;
pub const WININET_E_FAILED_DUETOSECURITYCHECK: HRESULT = 0x80072F8Bu32 as HRESULT;
pub const WININET_E_NOT_INITIALIZED: HRESULT = 0x80072F8Cu32 as HRESULT;
pub const WININET_E_LOGIN_FAILURE_DISPLAY_ENTITY_BODY: HRESULT = 0x80072F8Eu32 as HRESULT;
pub const WININET_E_DECODING_FAILED: HRESULT = 0x80072F8Fu32 as HRESULT;
pub const WININET_E_NOT_REDIRECTED: HRESULT = 0x80072F80u32 as HRESULT;
pub const WININET_E_COOKIE_NEEDS_CONFIRMATION: HRESULT = 0x80072F81u32 as HRESULT;
pub const WININET_E_COOKIE_DECLINED: HRESULT = 0x80072F82u32 as HRESULT;
pub const WININET_E_REDIRECT_NEEDS_CONFIRMATION: HRESULT = 0x80072F88u32 as HRESULT;
