# winapi-rs [![Build status](https://ci.appveyor.com/api/projects/status/i47oonf5e7qm5utq/branch/master?svg=true)](https://ci.appveyor.com/project/retep998/winapi-rs/branch/master) [![Build Status](https://travis-ci.org/retep998/winapi-rs.svg?branch=master)](https://travis-ci.org/retep998/winapi-rs) [![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/retep998/winapi-rs) [![Crates.io](https://img.shields.io/crates/v/winapi.svg)](https://crates.io/crates/winapi) #

[Documentation](https://retep998.github.io/doc/winapi/)

This crate provides types and constants for WinAPI FFI bindings. They are gathered by hand using the very latest official SDK from Microsoft. I aim to replace all existing Windows FFI in other crates with this set of crates through the "[Embrace, extend, and extinguish](http://en.wikipedia.org/wiki/Embrace,_extend_and_extinguish)" technique.

If this crate is missing something you need, feel free to create an issue, open a pull request, or contact me via [other means](http://www.rustaceans.org/retep998).

## Example ##

Cargo.toml:
```toml
[dependencies]
winapi = "*"
winmm-sys = "*"
```
example.rs:
```Rust
extern crate winapi;
extern crate winmm;
fn func() {
    winmm::PlaySoundA(...);
}
```

## Functions ##

Bindings to library functions are in separate crates. The source to each crate is in the relevant subdirectory under the `lib` directory.

### Usable crates ###
These are the ones that actually have functions in them:
* [advapi32-sys ![Crates.io](https://img.shields.io/crates/v/advapi32-sys.svg)](https://crates.io/crates/advapi32-sys)
* [d3d9-sys ![Crates.io](https://img.shields.io/crates/v/d3d9-sys.svg)](https://crates.io/crates/d3d9-sys)
* [dbghelp-sys ![Crates.io](https://img.shields.io/crates/v/dbghelp-sys.svg)](https://crates.io/crates/dbghelp-sys)
* [dwmapi-sys ![Crates.io](https://img.shields.io/crates/v/dwmapi-sys.svg)](https://crates.io/crates/dwmapi-sys)
* [gdi32-sys ![Crates.io](https://img.shields.io/crates/v/gdi32-sys.svg)](https://crates.io/crates/gdi32-sys)
* [kernel32-sys ![Crates.io](https://img.shields.io/crates/v/kernel32-sys.svg)](https://crates.io/crates/kernel32-sys)
* [ktmw32-sys ![Crates.io](https://img.shields.io/crates/v/ktmw32-sys.svg)](https://crates.io/crates/ktmw32-sys)
* [mpr-sys ![Crates.io](https://img.shields.io/crates/v/mpr-sys.svg)](https://crates.io/crates/mpr-sys)
* [ole32-sys ![Crates.io](https://img.shields.io/crates/v/ole32-sys.svg)](https://crates.io/crates/ole32-sys)
* [opengl32-sys ![Crates.io](https://img.shields.io/crates/v/opengl32-sys.svg)](https://crates.io/crates/opengl32-sys)
* [psapi-sys ![Crates.io](https://img.shields.io/crates/v/psapi-sys.svg)](https://crates.io/crates/psapi-sys)
* [shell32-sys ![Crates.io](https://img.shields.io/crates/v/shell32-sys.svg)](https://crates.io/crates/shell32-sys)
* [user32-sys ![Crates.io](https://img.shields.io/crates/v/user32-sys.svg)](https://crates.io/crates/user32-sys)
* [uuid-sys ![Crates.io](https://img.shields.io/crates/v/uuid-sys.svg)](https://crates.io/crates/uuid-sys)
* [winmm-sys ![Crates.io](https://img.shields.io/crates/v/winmm-sys.svg)](https://crates.io/crates/winmm-sys)

### Reserved crates ###
These are the ones that are reserved for future use:
* [aclui-sys ![Crates.io](https://img.shields.io/crates/v/aclui-sys.svg)](https://crates.io/crates/aclui-sys)
* [activeds-sys ![Crates.io](https://img.shields.io/crates/v/activeds-sys.svg)](https://crates.io/crates/activeds-sys)
* [adsiid-sys ![Crates.io](https://img.shields.io/crates/v/adsiid-sys.svg)](https://crates.io/crates/adsiid-sys)
* [advpack-sys ![Crates.io](https://img.shields.io/crates/v/advpack-sys.svg)](https://crates.io/crates/advpack-sys)
* [ahadmin-sys ![Crates.io](https://img.shields.io/crates/v/ahadmin-sys.svg)](https://crates.io/crates/ahadmin-sys)
* [alink-sys ![Crates.io](https://img.shields.io/crates/v/alink-sys.svg)](https://crates.io/crates/alink-sys)
* [amstrmid-sys ![Crates.io](https://img.shields.io/crates/v/amstrmid-sys.svg)](https://crates.io/crates/amstrmid-sys)
* [api-ms-win-net-isolation-l1-1-0-sys ![Crates.io](https://img.shields.io/crates/v/api-ms-win-net-isolation-l1-1-0-sys.svg)](https://crates.io/crates/api-ms-win-net-isolation-l1-1-0-sys)
* [apidll-sys ![Crates.io](https://img.shields.io/crates/v/apidll-sys.svg)](https://crates.io/crates/apidll-sys)
* [appmgmts-sys ![Crates.io](https://img.shields.io/crates/v/appmgmts-sys.svg)](https://crates.io/crates/appmgmts-sys)
* [appmgr-sys ![Crates.io](https://img.shields.io/crates/v/appmgr-sys.svg)](https://crates.io/crates/appmgr-sys)
* [appnotify-sys ![Crates.io](https://img.shields.io/crates/v/appnotify-sys.svg)](https://crates.io/crates/appnotify-sys)
* [asycfilt-sys ![Crates.io](https://img.shields.io/crates/v/asycfilt-sys.svg)](https://crates.io/crates/asycfilt-sys)
* [audiobaseprocessingobject-sys ![Crates.io](https://img.shields.io/crates/v/audiobaseprocessingobject-sys.svg)](https://crates.io/crates/audiobaseprocessingobject-sys)
* [audioeng-sys ![Crates.io](https://img.shields.io/crates/v/audioeng-sys.svg)](https://crates.io/crates/audioeng-sys)
* [audiomediatypecrt-sys ![Crates.io](https://img.shields.io/crates/v/audiomediatypecrt-sys.svg)](https://crates.io/crates/audiomediatypecrt-sys)
* [authz-sys ![Crates.io](https://img.shields.io/crates/v/authz-sys.svg)](https://crates.io/crates/authz-sys)
* [aux_ulib-sys ![Crates.io](https://img.shields.io/crates/v/aux_ulib-sys.svg)](https://crates.io/crates/aux_ulib-sys)
* [avifil32-sys ![Crates.io](https://img.shields.io/crates/v/avifil32-sys.svg)](https://crates.io/crates/avifil32-sys)
* [avrt-sys ![Crates.io](https://img.shields.io/crates/v/avrt-sys.svg)](https://crates.io/crates/avrt-sys)
* [basesrv-sys ![Crates.io](https://img.shields.io/crates/v/basesrv-sys.svg)](https://crates.io/crates/basesrv-sys)
* [bcrypt-sys ![Crates.io](https://img.shields.io/crates/v/bcrypt-sys.svg)](https://crates.io/crates/bcrypt-sys)
* [bits-sys ![Crates.io](https://img.shields.io/crates/v/bits-sys.svg)](https://crates.io/crates/bits-sys)
* [bluetoothapis-sys ![Crates.io](https://img.shields.io/crates/v/bluetoothapis-sys.svg)](https://crates.io/crates/bluetoothapis-sys)
* [bthprops-sys ![Crates.io](https://img.shields.io/crates/v/bthprops-sys.svg)](https://crates.io/crates/bthprops-sys)
* [bufferoverflow-sys ![Crates.io](https://img.shields.io/crates/v/bufferoverflow-sys.svg)](https://crates.io/crates/bufferoverflow-sys)
* [bufferoverflowu-sys ![Crates.io](https://img.shields.io/crates/v/bufferoverflowu-sys.svg)](https://crates.io/crates/bufferoverflowu-sys)
* [cabinet-sys ![Crates.io](https://img.shields.io/crates/v/cabinet-sys.svg)](https://crates.io/crates/cabinet-sys)
* [certadm-sys ![Crates.io](https://img.shields.io/crates/v/certadm-sys.svg)](https://crates.io/crates/certadm-sys)
* [certca-sys ![Crates.io](https://img.shields.io/crates/v/certca-sys.svg)](https://crates.io/crates/certca-sys)
* [certcli-sys ![Crates.io](https://img.shields.io/crates/v/certcli-sys.svg)](https://crates.io/crates/certcli-sys)
* [certidl-sys ![Crates.io](https://img.shields.io/crates/v/certidl-sys.svg)](https://crates.io/crates/certidl-sys)
* [certpoleng-sys ![Crates.io](https://img.shields.io/crates/v/certpoleng-sys.svg)](https://crates.io/crates/certpoleng-sys)
* [cfgmgr32-sys ![Crates.io](https://img.shields.io/crates/v/cfgmgr32-sys.svg)](https://crates.io/crates/cfgmgr32-sys)
* [clfsmgmt-sys ![Crates.io](https://img.shields.io/crates/v/clfsmgmt-sys.svg)](https://crates.io/crates/clfsmgmt-sys)
* [clfsw32-sys ![Crates.io](https://img.shields.io/crates/v/clfsw32-sys.svg)](https://crates.io/crates/clfsw32-sys)
* [clusapi-sys ![Crates.io](https://img.shields.io/crates/v/clusapi-sys.svg)](https://crates.io/crates/clusapi-sys)
* [comctl32-sys ![Crates.io](https://img.shields.io/crates/v/comctl32-sys.svg)](https://crates.io/crates/comctl32-sys)
* [comdlg32-sys ![Crates.io](https://img.shields.io/crates/v/comdlg32-sys.svg)](https://crates.io/crates/comdlg32-sys)
* [comppkgsup-sys ![Crates.io](https://img.shields.io/crates/v/comppkgsup-sys.svg)](https://crates.io/crates/comppkgsup-sys)
* [compstui-sys ![Crates.io](https://img.shields.io/crates/v/compstui-sys.svg)](https://crates.io/crates/compstui-sys)
* [comsvcs-sys ![Crates.io](https://img.shields.io/crates/v/comsvcs-sys.svg)](https://crates.io/crates/comsvcs-sys)
* [corguids-sys ![Crates.io](https://img.shields.io/crates/v/corguids-sys.svg)](https://crates.io/crates/corguids-sys)
* [correngine-sys ![Crates.io](https://img.shields.io/crates/v/correngine-sys.svg)](https://crates.io/crates/correngine-sys)
* [credui-sys ![Crates.io](https://img.shields.io/crates/v/credui-sys.svg)](https://crates.io/crates/credui-sys)
* [crypt32-sys ![Crates.io](https://img.shields.io/crates/v/crypt32-sys.svg)](https://crates.io/crates/crypt32-sys)
* [cryptdll-sys ![Crates.io](https://img.shields.io/crates/v/cryptdll-sys.svg)](https://crates.io/crates/cryptdll-sys)
* [cryptnet-sys ![Crates.io](https://img.shields.io/crates/v/cryptnet-sys.svg)](https://crates.io/crates/cryptnet-sys)
* [cryptui-sys ![Crates.io](https://img.shields.io/crates/v/cryptui-sys.svg)](https://crates.io/crates/cryptui-sys)
* [cryptxml-sys ![Crates.io](https://img.shields.io/crates/v/cryptxml-sys.svg)](https://crates.io/crates/cryptxml-sys)
* [cscapi-sys ![Crates.io](https://img.shields.io/crates/v/cscapi-sys.svg)](https://crates.io/crates/cscapi-sys)
* [cscdll-sys ![Crates.io](https://img.shields.io/crates/v/cscdll-sys.svg)](https://crates.io/crates/cscdll-sys)
* [d2d1-sys ![Crates.io](https://img.shields.io/crates/v/d2d1-sys.svg)](https://crates.io/crates/d2d1-sys)
* [d3d10-sys ![Crates.io](https://img.shields.io/crates/v/d3d10-sys.svg)](https://crates.io/crates/d3d10-sys)
* [d3d10_1-sys ![Crates.io](https://img.shields.io/crates/v/d3d10_1-sys.svg)](https://crates.io/crates/d3d10_1-sys)
* [d3d11-sys ![Crates.io](https://img.shields.io/crates/v/d3d11-sys.svg)](https://crates.io/crates/d3d11-sys)
* [d3dcompiler-sys ![Crates.io](https://img.shields.io/crates/v/d3dcompiler-sys.svg)](https://crates.io/crates/d3dcompiler-sys)
* [d3dcsx-sys ![Crates.io](https://img.shields.io/crates/v/d3dcsx-sys.svg)](https://crates.io/crates/d3dcsx-sys)
* [d3dcsxd-sys ![Crates.io](https://img.shields.io/crates/v/d3dcsxd-sys.svg)](https://crates.io/crates/d3dcsxd-sys)
* [davclnt-sys ![Crates.io](https://img.shields.io/crates/v/davclnt-sys.svg)](https://crates.io/crates/davclnt-sys)
* [dbgeng-sys ![Crates.io](https://img.shields.io/crates/v/dbgeng-sys.svg)](https://crates.io/crates/dbgeng-sys)
* [dciman32-sys ![Crates.io](https://img.shields.io/crates/v/dciman32-sys.svg)](https://crates.io/crates/dciman32-sys)
* [dcomp-sys ![Crates.io](https://img.shields.io/crates/v/dcomp-sys.svg)](https://crates.io/crates/dcomp-sys)
* [ddraw-sys ![Crates.io](https://img.shields.io/crates/v/ddraw-sys.svg)](https://crates.io/crates/ddraw-sys)
* [devenum-sys ![Crates.io](https://img.shields.io/crates/v/devenum-sys.svg)](https://crates.io/crates/devenum-sys)
* [deviceaccess-sys ![Crates.io](https://img.shields.io/crates/v/deviceaccess-sys.svg)](https://crates.io/crates/deviceaccess-sys)
* [devmgr-sys ![Crates.io](https://img.shields.io/crates/v/devmgr-sys.svg)](https://crates.io/crates/devmgr-sys)
* [dflayout-sys ![Crates.io](https://img.shields.io/crates/v/dflayout-sys.svg)](https://crates.io/crates/dflayout-sys)
* [dhcpcsvc-sys ![Crates.io](https://img.shields.io/crates/v/dhcpcsvc-sys.svg)](https://crates.io/crates/dhcpcsvc-sys)
* [dhcpcsvc6-sys ![Crates.io](https://img.shields.io/crates/v/dhcpcsvc6-sys.svg)](https://crates.io/crates/dhcpcsvc6-sys)
* [dhcpsapi-sys ![Crates.io](https://img.shields.io/crates/v/dhcpsapi-sys.svg)](https://crates.io/crates/dhcpsapi-sys)
* [difxapi-sys ![Crates.io](https://img.shields.io/crates/v/difxapi-sys.svg)](https://crates.io/crates/difxapi-sys)
* [dinput8-sys ![Crates.io](https://img.shields.io/crates/v/dinput8-sys.svg)](https://crates.io/crates/dinput8-sys)
* [dloadhelper-sys ![Crates.io](https://img.shields.io/crates/v/dloadhelper-sys.svg)](https://crates.io/crates/dloadhelper-sys)
* [dmoguids-sys ![Crates.io](https://img.shields.io/crates/v/dmoguids-sys.svg)](https://crates.io/crates/dmoguids-sys)
* [dnsapi-sys ![Crates.io](https://img.shields.io/crates/v/dnsapi-sys.svg)](https://crates.io/crates/dnsapi-sys)
* [dnscrcli-sys ![Crates.io](https://img.shields.io/crates/v/dnscrcli-sys.svg)](https://crates.io/crates/dnscrcli-sys)
* [dnslib-sys ![Crates.io](https://img.shields.io/crates/v/dnslib-sys.svg)](https://crates.io/crates/dnslib-sys)
* [dnsperf-sys ![Crates.io](https://img.shields.io/crates/v/dnsperf-sys.svg)](https://crates.io/crates/dnsperf-sys)
* [dnsrpc-sys ![Crates.io](https://img.shields.io/crates/v/dnsrpc-sys.svg)](https://crates.io/crates/dnsrpc-sys)
* [dnsrslvr-sys ![Crates.io](https://img.shields.io/crates/v/dnsrslvr-sys.svg)](https://crates.io/crates/dnsrslvr-sys)
* [dpx-sys ![Crates.io](https://img.shields.io/crates/v/dpx-sys.svg)](https://crates.io/crates/dpx-sys)
* [drt-sys ![Crates.io](https://img.shields.io/crates/v/drt-sys.svg)](https://crates.io/crates/drt-sys)
* [drtprov-sys ![Crates.io](https://img.shields.io/crates/v/drtprov-sys.svg)](https://crates.io/crates/drtprov-sys)
* [drttransport-sys ![Crates.io](https://img.shields.io/crates/v/drttransport-sys.svg)](https://crates.io/crates/drttransport-sys)
* [dsound-sys ![Crates.io](https://img.shields.io/crates/v/dsound-sys.svg)](https://crates.io/crates/dsound-sys)
* [dsprop-sys ![Crates.io](https://img.shields.io/crates/v/dsprop-sys.svg)](https://crates.io/crates/dsprop-sys)
* [dssec-sys ![Crates.io](https://img.shields.io/crates/v/dssec-sys.svg)](https://crates.io/crates/dssec-sys)
* [dststlog-sys ![Crates.io](https://img.shields.io/crates/v/dststlog-sys.svg)](https://crates.io/crates/dststlog-sys)
* [dsuiext-sys ![Crates.io](https://img.shields.io/crates/v/dsuiext-sys.svg)](https://crates.io/crates/dsuiext-sys)
* [dtchelp-sys ![Crates.io](https://img.shields.io/crates/v/dtchelp-sys.svg)](https://crates.io/crates/dtchelp-sys)
* [dwrite-sys ![Crates.io](https://img.shields.io/crates/v/dwrite-sys.svg)](https://crates.io/crates/dwrite-sys)
* [dxgi-sys ![Crates.io](https://img.shields.io/crates/v/dxgi-sys.svg)](https://crates.io/crates/dxgi-sys)
* [dxguid-sys ![Crates.io](https://img.shields.io/crates/v/dxguid-sys.svg)](https://crates.io/crates/dxguid-sys)
* [dxtmsft-sys ![Crates.io](https://img.shields.io/crates/v/dxtmsft-sys.svg)](https://crates.io/crates/dxtmsft-sys)
* [dxtrans-sys ![Crates.io](https://img.shields.io/crates/v/dxtrans-sys.svg)](https://crates.io/crates/dxtrans-sys)
* [dxva2-sys ![Crates.io](https://img.shields.io/crates/v/dxva2-sys.svg)](https://crates.io/crates/dxva2-sys)
* [eappcfg-sys ![Crates.io](https://img.shields.io/crates/v/eappcfg-sys.svg)](https://crates.io/crates/eappcfg-sys)
* [eappprxy-sys ![Crates.io](https://img.shields.io/crates/v/eappprxy-sys.svg)](https://crates.io/crates/eappprxy-sys)
* [easregprov-sys ![Crates.io](https://img.shields.io/crates/v/easregprov-sys.svg)](https://crates.io/crates/easregprov-sys)
* [efswrt-sys ![Crates.io](https://img.shields.io/crates/v/efswrt-sys.svg)](https://crates.io/crates/efswrt-sys)
* [ehstorguids-sys ![Crates.io](https://img.shields.io/crates/v/ehstorguids-sys.svg)](https://crates.io/crates/ehstorguids-sys)
* [elfapi-sys ![Crates.io](https://img.shields.io/crates/v/elfapi-sys.svg)](https://crates.io/crates/elfapi-sys)
* [els-sys ![Crates.io](https://img.shields.io/crates/v/els-sys.svg)](https://crates.io/crates/els-sys)
* [elscore-sys ![Crates.io](https://img.shields.io/crates/v/elscore-sys.svg)](https://crates.io/crates/elscore-sys)
* [esent-sys ![Crates.io](https://img.shields.io/crates/v/esent-sys.svg)](https://crates.io/crates/esent-sys)
* [evr-sys ![Crates.io](https://img.shields.io/crates/v/evr-sys.svg)](https://crates.io/crates/evr-sys)
* [evr_vista-sys ![Crates.io](https://img.shields.io/crates/v/evr_vista-sys.svg)](https://crates.io/crates/evr_vista-sys)
* [faultrep-sys ![Crates.io](https://img.shields.io/crates/v/faultrep-sys.svg)](https://crates.io/crates/faultrep-sys)
* [feclient-sys ![Crates.io](https://img.shields.io/crates/v/feclient-sys.svg)](https://crates.io/crates/feclient-sys)
* [fhsvcctl-sys ![Crates.io](https://img.shields.io/crates/v/fhsvcctl-sys.svg)](https://crates.io/crates/fhsvcctl-sys)
* [fileextd-sys ![Crates.io](https://img.shields.io/crates/v/fileextd-sys.svg)](https://crates.io/crates/fileextd-sys)
* [fltlib-sys ![Crates.io](https://img.shields.io/crates/v/fltlib-sys.svg)](https://crates.io/crates/fltlib-sys)
* [fontsub-sys ![Crates.io](https://img.shields.io/crates/v/fontsub-sys.svg)](https://crates.io/crates/fontsub-sys)
* [format-sys ![Crates.io](https://img.shields.io/crates/v/format-sys.svg)](https://crates.io/crates/format-sys)
* [framedyd-sys ![Crates.io](https://img.shields.io/crates/v/framedyd-sys.svg)](https://crates.io/crates/framedyd-sys)
* [framedyn-sys ![Crates.io](https://img.shields.io/crates/v/framedyn-sys.svg)](https://crates.io/crates/framedyn-sys)
* [fwpuclnt-sys ![Crates.io](https://img.shields.io/crates/v/fwpuclnt-sys.svg)](https://crates.io/crates/fwpuclnt-sys)
* [fxsutility-sys ![Crates.io](https://img.shields.io/crates/v/fxsutility-sys.svg)](https://crates.io/crates/fxsutility-sys)
* [gdiplus-sys ![Crates.io](https://img.shields.io/crates/v/gdiplus-sys.svg)](https://crates.io/crates/gdiplus-sys)
* [glmf32-sys ![Crates.io](https://img.shields.io/crates/v/glmf32-sys.svg)](https://crates.io/crates/glmf32-sys)
* [glu32-sys ![Crates.io](https://img.shields.io/crates/v/glu32-sys.svg)](https://crates.io/crates/glu32-sys)
* [gpedit-sys ![Crates.io](https://img.shields.io/crates/v/gpedit-sys.svg)](https://crates.io/crates/gpedit-sys)
* [gpmuuid-sys ![Crates.io](https://img.shields.io/crates/v/gpmuuid-sys.svg)](https://crates.io/crates/gpmuuid-sys)
* [hbaapi-sys ![Crates.io](https://img.shields.io/crates/v/hbaapi-sys.svg)](https://crates.io/crates/hbaapi-sys)
* [hhsetup-sys ![Crates.io](https://img.shields.io/crates/v/hhsetup-sys.svg)](https://crates.io/crates/hhsetup-sys)
* [hid-sys ![Crates.io](https://img.shields.io/crates/v/hid-sys.svg)](https://crates.io/crates/hid-sys)
* [hlink-sys ![Crates.io](https://img.shields.io/crates/v/hlink-sys.svg)](https://crates.io/crates/hlink-sys)
* [htmlhelp-sys ![Crates.io](https://img.shields.io/crates/v/htmlhelp-sys.svg)](https://crates.io/crates/htmlhelp-sys)
* [httpapi-sys ![Crates.io](https://img.shields.io/crates/v/httpapi-sys.svg)](https://crates.io/crates/httpapi-sys)
* [iashlpr-sys ![Crates.io](https://img.shields.io/crates/v/iashlpr-sys.svg)](https://crates.io/crates/iashlpr-sys)
* [icm32-sys ![Crates.io](https://img.shields.io/crates/v/icm32-sys.svg)](https://crates.io/crates/icm32-sys)
* [icmui-sys ![Crates.io](https://img.shields.io/crates/v/icmui-sys.svg)](https://crates.io/crates/icmui-sys)
* [iepmapi-sys ![Crates.io](https://img.shields.io/crates/v/iepmapi-sys.svg)](https://crates.io/crates/iepmapi-sys)
* [iesetup-sys ![Crates.io](https://img.shields.io/crates/v/iesetup-sys.svg)](https://crates.io/crates/iesetup-sys)
* [imagehlp-sys ![Crates.io](https://img.shields.io/crates/v/imagehlp-sys.svg)](https://crates.io/crates/imagehlp-sys)
* [imgutil-sys ![Crates.io](https://img.shields.io/crates/v/imgutil-sys.svg)](https://crates.io/crates/imgutil-sys)
* [imm32-sys ![Crates.io](https://img.shields.io/crates/v/imm32-sys.svg)](https://crates.io/crates/imm32-sys)
* [infocardapi-sys ![Crates.io](https://img.shields.io/crates/v/infocardapi-sys.svg)](https://crates.io/crates/infocardapi-sys)
* [inseng-sys ![Crates.io](https://img.shields.io/crates/v/inseng-sys.svg)](https://crates.io/crates/inseng-sys)
* [int64-sys ![Crates.io](https://img.shields.io/crates/v/int64-sys.svg)](https://crates.io/crates/int64-sys)
* [iphlpapi-sys ![Crates.io](https://img.shields.io/crates/v/iphlpapi-sys.svg)](https://crates.io/crates/iphlpapi-sys)
* [iprop-sys ![Crates.io](https://img.shields.io/crates/v/iprop-sys.svg)](https://crates.io/crates/iprop-sys)
* [irprops-sys ![Crates.io](https://img.shields.io/crates/v/irprops-sys.svg)](https://crates.io/crates/irprops-sys)
* [iscsidsc-sys ![Crates.io](https://img.shields.io/crates/v/iscsidsc-sys.svg)](https://crates.io/crates/iscsidsc-sys)
* [jetoledb-sys ![Crates.io](https://img.shields.io/crates/v/jetoledb-sys.svg)](https://crates.io/crates/jetoledb-sys)
* [jsrt-sys ![Crates.io](https://img.shields.io/crates/v/jsrt-sys.svg)](https://crates.io/crates/jsrt-sys)
* [kerbcli-sys ![Crates.io](https://img.shields.io/crates/v/kerbcli-sys.svg)](https://crates.io/crates/kerbcli-sys)
* [ksproxy-sys ![Crates.io](https://img.shields.io/crates/v/ksproxy-sys.svg)](https://crates.io/crates/ksproxy-sys)
* [ksuser-sys ![Crates.io](https://img.shields.io/crates/v/ksuser-sys.svg)](https://crates.io/crates/ksuser-sys)
* [loadperf-sys ![Crates.io](https://img.shields.io/crates/v/loadperf-sys.svg)](https://crates.io/crates/loadperf-sys)
* [locationapi-sys ![Crates.io](https://img.shields.io/crates/v/locationapi-sys.svg)](https://crates.io/crates/locationapi-sys)
* [lz32-sys ![Crates.io](https://img.shields.io/crates/v/lz32-sys.svg)](https://crates.io/crates/lz32-sys)
* [magnification-sys ![Crates.io](https://img.shields.io/crates/v/magnification-sys.svg)](https://crates.io/crates/magnification-sys)
* [mapi32-sys ![Crates.io](https://img.shields.io/crates/v/mapi32-sys.svg)](https://crates.io/crates/mapi32-sys)
* [mbnapi_uuid-sys ![Crates.io](https://img.shields.io/crates/v/mbnapi_uuid-sys.svg)](https://crates.io/crates/mbnapi_uuid-sys)
* [mciole32-sys ![Crates.io](https://img.shields.io/crates/v/mciole32-sys.svg)](https://crates.io/crates/mciole32-sys)
* [mdmregistration-sys ![Crates.io](https://img.shields.io/crates/v/mdmregistration-sys.svg)](https://crates.io/crates/mdmregistration-sys)
* [mf-sys ![Crates.io](https://img.shields.io/crates/v/mf-sys.svg)](https://crates.io/crates/mf-sys)
* [mf_vista-sys ![Crates.io](https://img.shields.io/crates/v/mf_vista-sys.svg)](https://crates.io/crates/mf_vista-sys)
* [mfcore-sys ![Crates.io](https://img.shields.io/crates/v/mfcore-sys.svg)](https://crates.io/crates/mfcore-sys)
* [mfplat-sys ![Crates.io](https://img.shields.io/crates/v/mfplat-sys.svg)](https://crates.io/crates/mfplat-sys)
* [mfplat_vista-sys ![Crates.io](https://img.shields.io/crates/v/mfplat_vista-sys.svg)](https://crates.io/crates/mfplat_vista-sys)
* [mfplay-sys ![Crates.io](https://img.shields.io/crates/v/mfplay-sys.svg)](https://crates.io/crates/mfplay-sys)
* [mfreadwrite-sys ![Crates.io](https://img.shields.io/crates/v/mfreadwrite-sys.svg)](https://crates.io/crates/mfreadwrite-sys)
* [mfsrcsnk-sys ![Crates.io](https://img.shields.io/crates/v/mfsrcsnk-sys.svg)](https://crates.io/crates/mfsrcsnk-sys)
* [mfuuid-sys ![Crates.io](https://img.shields.io/crates/v/mfuuid-sys.svg)](https://crates.io/crates/mfuuid-sys)
* [mgmtapi-sys ![Crates.io](https://img.shields.io/crates/v/mgmtapi-sys.svg)](https://crates.io/crates/mgmtapi-sys)
* [mi-sys ![Crates.io](https://img.shields.io/crates/v/mi-sys.svg)](https://crates.io/crates/mi-sys)
* [mincore-sys ![Crates.io](https://img.shields.io/crates/v/mincore-sys.svg)](https://crates.io/crates/mincore-sys)
* [mincore_downlevel-sys ![Crates.io](https://img.shields.io/crates/v/mincore_downlevel-sys.svg)](https://crates.io/crates/mincore_downlevel-sys)
* [mmc-sys ![Crates.io](https://img.shields.io/crates/v/mmc-sys.svg)](https://crates.io/crates/mmc-sys)
* [mmdevapi-sys ![Crates.io](https://img.shields.io/crates/v/mmdevapi-sys.svg)](https://crates.io/crates/mmdevapi-sys)
* [mprapi-sys ![Crates.io](https://img.shields.io/crates/v/mprapi-sys.svg)](https://crates.io/crates/mprapi-sys)
* [mprsnap-sys ![Crates.io](https://img.shields.io/crates/v/mprsnap-sys.svg)](https://crates.io/crates/mprsnap-sys)
* [mqoa-sys ![Crates.io](https://img.shields.io/crates/v/mqoa-sys.svg)](https://crates.io/crates/mqoa-sys)
* [mqrt-sys ![Crates.io](https://img.shields.io/crates/v/mqrt-sys.svg)](https://crates.io/crates/mqrt-sys)
* [msaatext-sys ![Crates.io](https://img.shields.io/crates/v/msaatext-sys.svg)](https://crates.io/crates/msaatext-sys)
* [msacm32-sys ![Crates.io](https://img.shields.io/crates/v/msacm32-sys.svg)](https://crates.io/crates/msacm32-sys)
* [mscms-sys ![Crates.io](https://img.shields.io/crates/v/mscms-sys.svg)](https://crates.io/crates/mscms-sys)
* [mscoree-sys ![Crates.io](https://img.shields.io/crates/v/mscoree-sys.svg)](https://crates.io/crates/mscoree-sys)
* [mscorsn-sys ![Crates.io](https://img.shields.io/crates/v/mscorsn-sys.svg)](https://crates.io/crates/mscorsn-sys)
* [msctfmonitor-sys ![Crates.io](https://img.shields.io/crates/v/msctfmonitor-sys.svg)](https://crates.io/crates/msctfmonitor-sys)
* [msdasc-sys ![Crates.io](https://img.shields.io/crates/v/msdasc-sys.svg)](https://crates.io/crates/msdasc-sys)
* [msdelta-sys ![Crates.io](https://img.shields.io/crates/v/msdelta-sys.svg)](https://crates.io/crates/msdelta-sys)
* [msdmo-sys ![Crates.io](https://img.shields.io/crates/v/msdmo-sys.svg)](https://crates.io/crates/msdmo-sys)
* [msdrm-sys ![Crates.io](https://img.shields.io/crates/v/msdrm-sys.svg)](https://crates.io/crates/msdrm-sys)
* [msi-sys ![Crates.io](https://img.shields.io/crates/v/msi-sys.svg)](https://crates.io/crates/msi-sys)
* [msimg32-sys ![Crates.io](https://img.shields.io/crates/v/msimg32-sys.svg)](https://crates.io/crates/msimg32-sys)
* [mspatcha-sys ![Crates.io](https://img.shields.io/crates/v/mspatcha-sys.svg)](https://crates.io/crates/mspatcha-sys)
* [mspatchc-sys ![Crates.io](https://img.shields.io/crates/v/mspatchc-sys.svg)](https://crates.io/crates/mspatchc-sys)
* [mspbase-sys ![Crates.io](https://img.shields.io/crates/v/mspbase-sys.svg)](https://crates.io/crates/mspbase-sys)
* [msports-sys ![Crates.io](https://img.shields.io/crates/v/msports-sys.svg)](https://crates.io/crates/msports-sys)
* [msrating-sys ![Crates.io](https://img.shields.io/crates/v/msrating-sys.svg)](https://crates.io/crates/msrating-sys)
* [mstask-sys ![Crates.io](https://img.shields.io/crates/v/mstask-sys.svg)](https://crates.io/crates/mstask-sys)
* [msv1_0-sys ![Crates.io](https://img.shields.io/crates/v/msv1_0-sys.svg)](https://crates.io/crates/msv1_0-sys)
* [msvfw32-sys ![Crates.io](https://img.shields.io/crates/v/msvfw32-sys.svg)](https://crates.io/crates/msvfw32-sys)
* [mswsock-sys ![Crates.io](https://img.shields.io/crates/v/mswsock-sys.svg)](https://crates.io/crates/mswsock-sys)
* [msxml2-sys ![Crates.io](https://img.shields.io/crates/v/msxml2-sys.svg)](https://crates.io/crates/msxml2-sys)
* [msxml6-sys ![Crates.io](https://img.shields.io/crates/v/msxml6-sys.svg)](https://crates.io/crates/msxml6-sys)
* [mtx-sys ![Crates.io](https://img.shields.io/crates/v/mtx-sys.svg)](https://crates.io/crates/mtx-sys)
* [mtxdm-sys ![Crates.io](https://img.shields.io/crates/v/mtxdm-sys.svg)](https://crates.io/crates/mtxdm-sys)
* [muiload-sys ![Crates.io](https://img.shields.io/crates/v/muiload-sys.svg)](https://crates.io/crates/muiload-sys)
* [ncrypt-sys ![Crates.io](https://img.shields.io/crates/v/ncrypt-sys.svg)](https://crates.io/crates/ncrypt-sys)
* [nddeapi-sys ![Crates.io](https://img.shields.io/crates/v/nddeapi-sys.svg)](https://crates.io/crates/nddeapi-sys)
* [ndfapi-sys ![Crates.io](https://img.shields.io/crates/v/ndfapi-sys.svg)](https://crates.io/crates/ndfapi-sys)
* [ndproxystub-sys ![Crates.io](https://img.shields.io/crates/v/ndproxystub-sys.svg)](https://crates.io/crates/ndproxystub-sys)
* [netapi32-sys ![Crates.io](https://img.shields.io/crates/v/netapi32-sys.svg)](https://crates.io/crates/netapi32-sys)
* [netlib-sys ![Crates.io](https://img.shields.io/crates/v/netlib-sys.svg)](https://crates.io/crates/netlib-sys)
* [netsh-sys ![Crates.io](https://img.shields.io/crates/v/netsh-sys.svg)](https://crates.io/crates/netsh-sys)
* [newdev-sys ![Crates.io](https://img.shields.io/crates/v/newdev-sys.svg)](https://crates.io/crates/newdev-sys)
* [ninput-sys ![Crates.io](https://img.shields.io/crates/v/ninput-sys.svg)](https://crates.io/crates/ninput-sys)
* [normaliz-sys ![Crates.io](https://img.shields.io/crates/v/normaliz-sys.svg)](https://crates.io/crates/normaliz-sys)
* [nt-sys ![Crates.io](https://img.shields.io/crates/v/nt-sys.svg)](https://crates.io/crates/nt-sys)
* [ntdll-sys ![Crates.io](https://img.shields.io/crates/v/ntdll-sys.svg)](https://crates.io/crates/ntdll-sys)
* [ntdsa-sys ![Crates.io](https://img.shields.io/crates/v/ntdsa-sys.svg)](https://crates.io/crates/ntdsa-sys)
* [ntdsapi-sys ![Crates.io](https://img.shields.io/crates/v/ntdsapi-sys.svg)](https://crates.io/crates/ntdsapi-sys)
* [ntdsatq-sys ![Crates.io](https://img.shields.io/crates/v/ntdsatq-sys.svg)](https://crates.io/crates/ntdsatq-sys)
* [ntdsetup-sys ![Crates.io](https://img.shields.io/crates/v/ntdsetup-sys.svg)](https://crates.io/crates/ntdsetup-sys)
* [ntfrsapi-sys ![Crates.io](https://img.shields.io/crates/v/ntfrsapi-sys.svg)](https://crates.io/crates/ntfrsapi-sys)
* [ntlanman-sys ![Crates.io](https://img.shields.io/crates/v/ntlanman-sys.svg)](https://crates.io/crates/ntlanman-sys)
* [ntmarta-sys ![Crates.io](https://img.shields.io/crates/v/ntmarta-sys.svg)](https://crates.io/crates/ntmarta-sys)
* [ntquery-sys ![Crates.io](https://img.shields.io/crates/v/ntquery-sys.svg)](https://crates.io/crates/ntquery-sys)
* [ntstc_libcmt-sys ![Crates.io](https://img.shields.io/crates/v/ntstc_libcmt-sys.svg)](https://crates.io/crates/ntstc_libcmt-sys)
* [ntstc_msvcrt-sys ![Crates.io](https://img.shields.io/crates/v/ntstc_msvcrt-sys.svg)](https://crates.io/crates/ntstc_msvcrt-sys)
* [ntvdm-sys ![Crates.io](https://img.shields.io/crates/v/ntvdm-sys.svg)](https://crates.io/crates/ntvdm-sys)
* [objsel-sys ![Crates.io](https://img.shields.io/crates/v/objsel-sys.svg)](https://crates.io/crates/objsel-sys)
* [odbc32-sys ![Crates.io](https://img.shields.io/crates/v/odbc32-sys.svg)](https://crates.io/crates/odbc32-sys)
* [odbcbcp-sys ![Crates.io](https://img.shields.io/crates/v/odbcbcp-sys.svg)](https://crates.io/crates/odbcbcp-sys)
* [odbccp32-sys ![Crates.io](https://img.shields.io/crates/v/odbccp32-sys.svg)](https://crates.io/crates/odbccp32-sys)
* [oemlicense-sys ![Crates.io](https://img.shields.io/crates/v/oemlicense-sys.svg)](https://crates.io/crates/oemlicense-sys)
* [oleacc-sys ![Crates.io](https://img.shields.io/crates/v/oleacc-sys.svg)](https://crates.io/crates/oleacc-sys)
* [oleaut32-sys ![Crates.io](https://img.shields.io/crates/v/oleaut32-sys.svg)](https://crates.io/crates/oleaut32-sys)
* [olecli32-sys ![Crates.io](https://img.shields.io/crates/v/olecli32-sys.svg)](https://crates.io/crates/olecli32-sys)
* [oledb-sys ![Crates.io](https://img.shields.io/crates/v/oledb-sys.svg)](https://crates.io/crates/oledb-sys)
* [oledlg-sys ![Crates.io](https://img.shields.io/crates/v/oledlg-sys.svg)](https://crates.io/crates/oledlg-sys)
* [olepro32-sys ![Crates.io](https://img.shields.io/crates/v/olepro32-sys.svg)](https://crates.io/crates/olepro32-sys)
* [olesvr32-sys ![Crates.io](https://img.shields.io/crates/v/olesvr32-sys.svg)](https://crates.io/crates/olesvr32-sys)
* [ondemandconnroutehelper-sys ![Crates.io](https://img.shields.io/crates/v/ondemandconnroutehelper-sys.svg)](https://crates.io/crates/ondemandconnroutehelper-sys)
* [osptk-sys ![Crates.io](https://img.shields.io/crates/v/osptk-sys.svg)](https://crates.io/crates/osptk-sys)
* [p2p-sys ![Crates.io](https://img.shields.io/crates/v/p2p-sys.svg)](https://crates.io/crates/p2p-sys)
* [p2pgraph-sys ![Crates.io](https://img.shields.io/crates/v/p2pgraph-sys.svg)](https://crates.io/crates/p2pgraph-sys)
* [patchwiz-sys ![Crates.io](https://img.shields.io/crates/v/patchwiz-sys.svg)](https://crates.io/crates/patchwiz-sys)
* [pathcch-sys ![Crates.io](https://img.shields.io/crates/v/pathcch-sys.svg)](https://crates.io/crates/pathcch-sys)
* [pdh-sys ![Crates.io](https://img.shields.io/crates/v/pdh-sys.svg)](https://crates.io/crates/pdh-sys)
* [peerdist-sys ![Crates.io](https://img.shields.io/crates/v/peerdist-sys.svg)](https://crates.io/crates/peerdist-sys)
* [photoacquireuid-sys ![Crates.io](https://img.shields.io/crates/v/photoacquireuid-sys.svg)](https://crates.io/crates/photoacquireuid-sys)
* [portabledeviceguids-sys ![Crates.io](https://img.shields.io/crates/v/portabledeviceguids-sys.svg)](https://crates.io/crates/portabledeviceguids-sys)
* [powrprof-sys ![Crates.io](https://img.shields.io/crates/v/powrprof-sys.svg)](https://crates.io/crates/powrprof-sys)
* [prntvpt-sys ![Crates.io](https://img.shields.io/crates/v/prntvpt-sys.svg)](https://crates.io/crates/prntvpt-sys)
* [propsys-sys ![Crates.io](https://img.shields.io/crates/v/propsys-sys.svg)](https://crates.io/crates/propsys-sys)
* [quartz-sys ![Crates.io](https://img.shields.io/crates/v/quartz-sys.svg)](https://crates.io/crates/quartz-sys)
* [query-sys ![Crates.io](https://img.shields.io/crates/v/query-sys.svg)](https://crates.io/crates/query-sys)
* [qutil-sys ![Crates.io](https://img.shields.io/crates/v/qutil-sys.svg)](https://crates.io/crates/qutil-sys)
* [qwave-sys ![Crates.io](https://img.shields.io/crates/v/qwave-sys.svg)](https://crates.io/crates/qwave-sys)
* [rasapi32-sys ![Crates.io](https://img.shields.io/crates/v/rasapi32-sys.svg)](https://crates.io/crates/rasapi32-sys)
* [rasdlg-sys ![Crates.io](https://img.shields.io/crates/v/rasdlg-sys.svg)](https://crates.io/crates/rasdlg-sys)
* [rasuser-sys ![Crates.io](https://img.shields.io/crates/v/rasuser-sys.svg)](https://crates.io/crates/rasuser-sys)
* [resutils-sys ![Crates.io](https://img.shields.io/crates/v/resutils-sys.svg)](https://crates.io/crates/resutils-sys)
* [rometadata-sys ![Crates.io](https://img.shields.io/crates/v/rometadata-sys.svg)](https://crates.io/crates/rometadata-sys)
* [rpcexts-sys ![Crates.io](https://img.shields.io/crates/v/rpcexts-sys.svg)](https://crates.io/crates/rpcexts-sys)
* [rpcns4-sys ![Crates.io](https://img.shields.io/crates/v/rpcns4-sys.svg)](https://crates.io/crates/rpcns4-sys)
* [rpcproxy-sys ![Crates.io](https://img.shields.io/crates/v/rpcproxy-sys.svg)](https://crates.io/crates/rpcproxy-sys)
* [rpcrt4-sys ![Crates.io](https://img.shields.io/crates/v/rpcrt4-sys.svg)](https://crates.io/crates/rpcrt4-sys)
* [rpcutil-sys ![Crates.io](https://img.shields.io/crates/v/rpcutil-sys.svg)](https://crates.io/crates/rpcutil-sys)
* [rstrtmgr-sys ![Crates.io](https://img.shields.io/crates/v/rstrtmgr-sys.svg)](https://crates.io/crates/rstrtmgr-sys)
* [rtm-sys ![Crates.io](https://img.shields.io/crates/v/rtm-sys.svg)](https://crates.io/crates/rtm-sys)
* [rtutils-sys ![Crates.io](https://img.shields.io/crates/v/rtutils-sys.svg)](https://crates.io/crates/rtutils-sys)
* [rtworkq-sys ![Crates.io](https://img.shields.io/crates/v/rtworkq-sys.svg)](https://crates.io/crates/rtworkq-sys)
* [runtimeobject-sys ![Crates.io](https://img.shields.io/crates/v/runtimeobject-sys.svg)](https://crates.io/crates/runtimeobject-sys)
* [samlib-sys ![Crates.io](https://img.shields.io/crates/v/samlib-sys.svg)](https://crates.io/crates/samlib-sys)
* [samsrv-sys ![Crates.io](https://img.shields.io/crates/v/samsrv-sys.svg)](https://crates.io/crates/samsrv-sys)
* [sapi-sys ![Crates.io](https://img.shields.io/crates/v/sapi-sys.svg)](https://crates.io/crates/sapi-sys)
* [sas-sys ![Crates.io](https://img.shields.io/crates/v/sas-sys.svg)](https://crates.io/crates/sas-sys)
* [sbtsv-sys ![Crates.io](https://img.shields.io/crates/v/sbtsv-sys.svg)](https://crates.io/crates/sbtsv-sys)
* [scarddlg-sys ![Crates.io](https://img.shields.io/crates/v/scarddlg-sys.svg)](https://crates.io/crates/scarddlg-sys)
* [scecli-sys ![Crates.io](https://img.shields.io/crates/v/scecli-sys.svg)](https://crates.io/crates/scecli-sys)
* [scesrv-sys ![Crates.io](https://img.shields.io/crates/v/scesrv-sys.svg)](https://crates.io/crates/scesrv-sys)
* [schannel-sys ![Crates.io](https://img.shields.io/crates/v/schannel-sys.svg)](https://crates.io/crates/schannel-sys)
* [scrnsave-sys ![Crates.io](https://img.shields.io/crates/v/scrnsave-sys.svg)](https://crates.io/crates/scrnsave-sys)
* [scrnsavw-sys ![Crates.io](https://img.shields.io/crates/v/scrnsavw-sys.svg)](https://crates.io/crates/scrnsavw-sys)
* [searchsdk-sys ![Crates.io](https://img.shields.io/crates/v/searchsdk-sys.svg)](https://crates.io/crates/searchsdk-sys)
* [secur32-sys ![Crates.io](https://img.shields.io/crates/v/secur32-sys.svg)](https://crates.io/crates/secur32-sys)
* [security-sys ![Crates.io](https://img.shields.io/crates/v/security-sys.svg)](https://crates.io/crates/security-sys)
* [sens-sys ![Crates.io](https://img.shields.io/crates/v/sens-sys.svg)](https://crates.io/crates/sens-sys)
* [sensapi-sys ![Crates.io](https://img.shields.io/crates/v/sensapi-sys.svg)](https://crates.io/crates/sensapi-sys)
* [sensorsapi-sys ![Crates.io](https://img.shields.io/crates/v/sensorsapi-sys.svg)](https://crates.io/crates/sensorsapi-sys)
* [setupapi-sys ![Crates.io](https://img.shields.io/crates/v/setupapi-sys.svg)](https://crates.io/crates/setupapi-sys)
* [sfc-sys ![Crates.io](https://img.shields.io/crates/v/sfc-sys.svg)](https://crates.io/crates/sfc-sys)
* [shcore-sys ![Crates.io](https://img.shields.io/crates/v/shcore-sys.svg)](https://crates.io/crates/shcore-sys)
* [shdocvw-sys ![Crates.io](https://img.shields.io/crates/v/shdocvw-sys.svg)](https://crates.io/crates/shdocvw-sys)
* [shfolder-sys ![Crates.io](https://img.shields.io/crates/v/shfolder-sys.svg)](https://crates.io/crates/shfolder-sys)
* [shlwapi-sys ![Crates.io](https://img.shields.io/crates/v/shlwapi-sys.svg)](https://crates.io/crates/shlwapi-sys)
* [sisbkup-sys ![Crates.io](https://img.shields.io/crates/v/sisbkup-sys.svg)](https://crates.io/crates/sisbkup-sys)
* [slc-sys ![Crates.io](https://img.shields.io/crates/v/slc-sys.svg)](https://crates.io/crates/slc-sys)
* [slcext-sys ![Crates.io](https://img.shields.io/crates/v/slcext-sys.svg)](https://crates.io/crates/slcext-sys)
* [slwga-sys ![Crates.io](https://img.shields.io/crates/v/slwga-sys.svg)](https://crates.io/crates/slwga-sys)
* [snmpapi-sys ![Crates.io](https://img.shields.io/crates/v/snmpapi-sys.svg)](https://crates.io/crates/snmpapi-sys)
* [spoolss-sys ![Crates.io](https://img.shields.io/crates/v/spoolss-sys.svg)](https://crates.io/crates/spoolss-sys)
* [sporder-sys ![Crates.io](https://img.shields.io/crates/v/sporder-sys.svg)](https://crates.io/crates/sporder-sys)
* [srclient-sys ![Crates.io](https://img.shields.io/crates/v/srclient-sys.svg)](https://crates.io/crates/srclient-sys)
* [ssdpapi-sys ![Crates.io](https://img.shields.io/crates/v/ssdpapi-sys.svg)](https://crates.io/crates/ssdpapi-sys)
* [sti-sys ![Crates.io](https://img.shields.io/crates/v/sti-sys.svg)](https://crates.io/crates/sti-sys)
* [strmbase-sys ![Crates.io](https://img.shields.io/crates/v/strmbase-sys.svg)](https://crates.io/crates/strmbase-sys)
* [strmiids-sys ![Crates.io](https://img.shields.io/crates/v/strmiids-sys.svg)](https://crates.io/crates/strmiids-sys)
* [strsafe-sys ![Crates.io](https://img.shields.io/crates/v/strsafe-sys.svg)](https://crates.io/crates/strsafe-sys)
* [structuredquery-sys ![Crates.io](https://img.shields.io/crates/v/structuredquery-sys.svg)](https://crates.io/crates/structuredquery-sys)
* [svcguid-sys ![Crates.io](https://img.shields.io/crates/v/svcguid-sys.svg)](https://crates.io/crates/svcguid-sys)
* [swdevice-sys ![Crates.io](https://img.shields.io/crates/v/swdevice-sys.svg)](https://crates.io/crates/swdevice-sys)
* [synchronization-sys ![Crates.io](https://img.shields.io/crates/v/synchronization-sys.svg)](https://crates.io/crates/synchronization-sys)
* [t2embed-sys ![Crates.io](https://img.shields.io/crates/v/t2embed-sys.svg)](https://crates.io/crates/t2embed-sys)
* [tapi32-sys ![Crates.io](https://img.shields.io/crates/v/tapi32-sys.svg)](https://crates.io/crates/tapi32-sys)
* [tapi32l-sys ![Crates.io](https://img.shields.io/crates/v/tapi32l-sys.svg)](https://crates.io/crates/tapi32l-sys)
* [taskschd-sys ![Crates.io](https://img.shields.io/crates/v/taskschd-sys.svg)](https://crates.io/crates/taskschd-sys)
* [tbs-sys ![Crates.io](https://img.shields.io/crates/v/tbs-sys.svg)](https://crates.io/crates/tbs-sys)
* [tdh-sys ![Crates.io](https://img.shields.io/crates/v/tdh-sys.svg)](https://crates.io/crates/tdh-sys)
* [thunk32-sys ![Crates.io](https://img.shields.io/crates/v/thunk32-sys.svg)](https://crates.io/crates/thunk32-sys)
* [tlbref-sys ![Crates.io](https://img.shields.io/crates/v/tlbref-sys.svg)](https://crates.io/crates/tlbref-sys)
* [traffic-sys ![Crates.io](https://img.shields.io/crates/v/traffic-sys.svg)](https://crates.io/crates/traffic-sys)
* [transcodeimageuid-sys ![Crates.io](https://img.shields.io/crates/v/transcodeimageuid-sys.svg)](https://crates.io/crates/transcodeimageuid-sys)
* [tsec-sys ![Crates.io](https://img.shields.io/crates/v/tsec-sys.svg)](https://crates.io/crates/tsec-sys)
* [tspubplugincom-sys ![Crates.io](https://img.shields.io/crates/v/tspubplugincom-sys.svg)](https://crates.io/crates/tspubplugincom-sys)
* [twain_32-sys ![Crates.io](https://img.shields.io/crates/v/twain_32-sys.svg)](https://crates.io/crates/twain_32-sys)
* [twinapi-sys ![Crates.io](https://img.shields.io/crates/v/twinapi-sys.svg)](https://crates.io/crates/twinapi-sys)
* [txfw32-sys ![Crates.io](https://img.shields.io/crates/v/txfw32-sys.svg)](https://crates.io/crates/txfw32-sys)
* [ualapi-sys ![Crates.io](https://img.shields.io/crates/v/ualapi-sys.svg)](https://crates.io/crates/ualapi-sys)
* [uiautomationcore-sys ![Crates.io](https://img.shields.io/crates/v/uiautomationcore-sys.svg)](https://crates.io/crates/uiautomationcore-sys)
* [umpdddi-sys ![Crates.io](https://img.shields.io/crates/v/umpdddi-sys.svg)](https://crates.io/crates/umpdddi-sys)
* [unicows-sys ![Crates.io](https://img.shields.io/crates/v/unicows-sys.svg)](https://crates.io/crates/unicows-sys)
* [urlmon-sys ![Crates.io](https://img.shields.io/crates/v/urlmon-sys.svg)](https://crates.io/crates/urlmon-sys)
* [userenv-sys ![Crates.io](https://img.shields.io/crates/v/userenv-sys.svg)](https://crates.io/crates/userenv-sys)
* [usp10-sys ![Crates.io](https://img.shields.io/crates/v/usp10-sys.svg)](https://crates.io/crates/usp10-sys)
* [uxtheme-sys ![Crates.io](https://img.shields.io/crates/v/uxtheme-sys.svg)](https://crates.io/crates/uxtheme-sys)
* [vccomsup-sys ![Crates.io](https://img.shields.io/crates/v/vccomsup-sys.svg)](https://crates.io/crates/vccomsup-sys)
* [vdmdbg-sys ![Crates.io](https://img.shields.io/crates/v/vdmdbg-sys.svg)](https://crates.io/crates/vdmdbg-sys)
* [vds_uuid-sys ![Crates.io](https://img.shields.io/crates/v/vds_uuid-sys.svg)](https://crates.io/crates/vds_uuid-sys)
* [version-sys ![Crates.io](https://img.shields.io/crates/v/version-sys.svg)](https://crates.io/crates/version-sys)
* [vfw32-sys ![Crates.io](https://img.shields.io/crates/v/vfw32-sys.svg)](https://crates.io/crates/vfw32-sys)
* [virtdisk-sys ![Crates.io](https://img.shields.io/crates/v/virtdisk-sys.svg)](https://crates.io/crates/virtdisk-sys)
* [vscmgr-sys ![Crates.io](https://img.shields.io/crates/v/vscmgr-sys.svg)](https://crates.io/crates/vscmgr-sys)
* [vss_uuid-sys ![Crates.io](https://img.shields.io/crates/v/vss_uuid-sys.svg)](https://crates.io/crates/vss_uuid-sys)
* [vssapi-sys ![Crates.io](https://img.shields.io/crates/v/vssapi-sys.svg)](https://crates.io/crates/vssapi-sys)
* [vstorinterface-sys ![Crates.io](https://img.shields.io/crates/v/vstorinterface-sys.svg)](https://crates.io/crates/vstorinterface-sys)
* [wbemuuid-sys ![Crates.io](https://img.shields.io/crates/v/wbemuuid-sys.svg)](https://crates.io/crates/wbemuuid-sys)
* [wcmapi-sys ![Crates.io](https://img.shields.io/crates/v/wcmapi-sys.svg)](https://crates.io/crates/wcmapi-sys)
* [wcmguid-sys ![Crates.io](https://img.shields.io/crates/v/wcmguid-sys.svg)](https://crates.io/crates/wcmguid-sys)
* [wdsbp-sys ![Crates.io](https://img.shields.io/crates/v/wdsbp-sys.svg)](https://crates.io/crates/wdsbp-sys)
* [wdsclientapi-sys ![Crates.io](https://img.shields.io/crates/v/wdsclientapi-sys.svg)](https://crates.io/crates/wdsclientapi-sys)
* [wdsmc-sys ![Crates.io](https://img.shields.io/crates/v/wdsmc-sys.svg)](https://crates.io/crates/wdsmc-sys)
* [wdspxe-sys ![Crates.io](https://img.shields.io/crates/v/wdspxe-sys.svg)](https://crates.io/crates/wdspxe-sys)
* [wdstptc-sys ![Crates.io](https://img.shields.io/crates/v/wdstptc-sys.svg)](https://crates.io/crates/wdstptc-sys)
* [webservices-sys ![Crates.io](https://img.shields.io/crates/v/webservices-sys.svg)](https://crates.io/crates/webservices-sys)
* [websocket-sys ![Crates.io](https://img.shields.io/crates/v/websocket-sys.svg)](https://crates.io/crates/websocket-sys)
* [wecapi-sys ![Crates.io](https://img.shields.io/crates/v/wecapi-sys.svg)](https://crates.io/crates/wecapi-sys)
* [wer-sys ![Crates.io](https://img.shields.io/crates/v/wer-sys.svg)](https://crates.io/crates/wer-sys)
* [wevtapi-sys ![Crates.io](https://img.shields.io/crates/v/wevtapi-sys.svg)](https://crates.io/crates/wevtapi-sys)
* [wiaguid-sys ![Crates.io](https://img.shields.io/crates/v/wiaguid-sys.svg)](https://crates.io/crates/wiaguid-sys)
* [wiaservc-sys ![Crates.io](https://img.shields.io/crates/v/wiaservc-sys.svg)](https://crates.io/crates/wiaservc-sys)
* [wiautil-sys ![Crates.io](https://img.shields.io/crates/v/wiautil-sys.svg)](https://crates.io/crates/wiautil-sys)
* [winbio-sys ![Crates.io](https://img.shields.io/crates/v/winbio-sys.svg)](https://crates.io/crates/winbio-sys)
* [windows-data-pdf-sys ![Crates.io](https://img.shields.io/crates/v/windows-data-pdf-sys.svg)](https://crates.io/crates/windows-data-pdf-sys)
* [windows-networking-sys ![Crates.io](https://img.shields.io/crates/v/windows-networking-sys.svg)](https://crates.io/crates/windows-networking-sys)
* [windows-ui-sys ![Crates.io](https://img.shields.io/crates/v/windows-ui-sys.svg)](https://crates.io/crates/windows-ui-sys)
* [windowscodecs-sys ![Crates.io](https://img.shields.io/crates/v/windowscodecs-sys.svg)](https://crates.io/crates/windowscodecs-sys)
* [windowssideshowguids-sys ![Crates.io](https://img.shields.io/crates/v/windowssideshowguids-sys.svg)](https://crates.io/crates/windowssideshowguids-sys)
* [winfax-sys ![Crates.io](https://img.shields.io/crates/v/winfax-sys.svg)](https://crates.io/crates/winfax-sys)
* [winhttp-sys ![Crates.io](https://img.shields.io/crates/v/winhttp-sys.svg)](https://crates.io/crates/winhttp-sys)
* [wininet-sys ![Crates.io](https://img.shields.io/crates/v/wininet-sys.svg)](https://crates.io/crates/wininet-sys)
* [winsatapi-sys ![Crates.io](https://img.shields.io/crates/v/winsatapi-sys.svg)](https://crates.io/crates/winsatapi-sys)
* [winscard-sys ![Crates.io](https://img.shields.io/crates/v/winscard-sys.svg)](https://crates.io/crates/winscard-sys)
* [winspool-sys ![Crates.io](https://img.shields.io/crates/v/winspool-sys.svg)](https://crates.io/crates/winspool-sys)
* [winsta-sys ![Crates.io](https://img.shields.io/crates/v/winsta-sys.svg)](https://crates.io/crates/winsta-sys)
* [winstrm-sys ![Crates.io](https://img.shields.io/crates/v/winstrm-sys.svg)](https://crates.io/crates/winstrm-sys)
* [wintrust-sys ![Crates.io](https://img.shields.io/crates/v/wintrust-sys.svg)](https://crates.io/crates/wintrust-sys)
* [winusb-sys ![Crates.io](https://img.shields.io/crates/v/winusb-sys.svg)](https://crates.io/crates/winusb-sys)
* [wlanapi-sys ![Crates.io](https://img.shields.io/crates/v/wlanapi-sys.svg)](https://crates.io/crates/wlanapi-sys)
* [wlanui-sys ![Crates.io](https://img.shields.io/crates/v/wlanui-sys.svg)](https://crates.io/crates/wlanui-sys)
* [wldap32-sys ![Crates.io](https://img.shields.io/crates/v/wldap32-sys.svg)](https://crates.io/crates/wldap32-sys)
* [wmcodecdspuuid-sys ![Crates.io](https://img.shields.io/crates/v/wmcodecdspuuid-sys.svg)](https://crates.io/crates/wmcodecdspuuid-sys)
* [wmdrmsdk-sys ![Crates.io](https://img.shields.io/crates/v/wmdrmsdk-sys.svg)](https://crates.io/crates/wmdrmsdk-sys)
* [wmip-sys ![Crates.io](https://img.shields.io/crates/v/wmip-sys.svg)](https://crates.io/crates/wmip-sys)
* [wmiutils-sys ![Crates.io](https://img.shields.io/crates/v/wmiutils-sys.svg)](https://crates.io/crates/wmiutils-sys)
* [wmvcore-sys ![Crates.io](https://img.shields.io/crates/v/wmvcore-sys.svg)](https://crates.io/crates/wmvcore-sys)
* [wnvapi-sys ![Crates.io](https://img.shields.io/crates/v/wnvapi-sys.svg)](https://crates.io/crates/wnvapi-sys)
* [workspaceax-sys ![Crates.io](https://img.shields.io/crates/v/workspaceax-sys.svg)](https://crates.io/crates/workspaceax-sys)
* [wow32-sys ![Crates.io](https://img.shields.io/crates/v/wow32-sys.svg)](https://crates.io/crates/wow32-sys)
* [ws2_32-sys ![Crates.io](https://img.shields.io/crates/v/ws2_32-sys.svg)](https://crates.io/crates/ws2_32-sys)
* [wsbapp_uuid-sys ![Crates.io](https://img.shields.io/crates/v/wsbapp_uuid-sys.svg)](https://crates.io/crates/wsbapp_uuid-sys)
* [wsbonline-sys ![Crates.io](https://img.shields.io/crates/v/wsbonline-sys.svg)](https://crates.io/crates/wsbonline-sys)
* [wscapi-sys ![Crates.io](https://img.shields.io/crates/v/wscapi-sys.svg)](https://crates.io/crates/wscapi-sys)
* [wsclient-sys ![Crates.io](https://img.shields.io/crates/v/wsclient-sys.svg)](https://crates.io/crates/wsclient-sys)
* [wsdapi-sys ![Crates.io](https://img.shields.io/crates/v/wsdapi-sys.svg)](https://crates.io/crates/wsdapi-sys)
* [wsmsvc-sys ![Crates.io](https://img.shields.io/crates/v/wsmsvc-sys.svg)](https://crates.io/crates/wsmsvc-sys)
* [wsnmp32-sys ![Crates.io](https://img.shields.io/crates/v/wsnmp32-sys.svg)](https://crates.io/crates/wsnmp32-sys)
* [wsock32-sys ![Crates.io](https://img.shields.io/crates/v/wsock32-sys.svg)](https://crates.io/crates/wsock32-sys)
* [wtsapi32-sys ![Crates.io](https://img.shields.io/crates/v/wtsapi32-sys.svg)](https://crates.io/crates/wtsapi32-sys)
* [wuguid-sys ![Crates.io](https://img.shields.io/crates/v/wuguid-sys.svg)](https://crates.io/crates/wuguid-sys)
* [xapobase-sys ![Crates.io](https://img.shields.io/crates/v/xapobase-sys.svg)](https://crates.io/crates/xapobase-sys)
* [xaswitch-sys ![Crates.io](https://img.shields.io/crates/v/xaswitch-sys.svg)](https://crates.io/crates/xaswitch-sys)
* [xaudio2-sys ![Crates.io](https://img.shields.io/crates/v/xaudio2-sys.svg)](https://crates.io/crates/xaudio2-sys)
* [xinput-sys ![Crates.io](https://img.shields.io/crates/v/xinput-sys.svg)](https://crates.io/crates/xinput-sys)
* [xinput9_1_0-sys ![Crates.io](https://img.shields.io/crates/v/xinput9_1_0-sys.svg)](https://crates.io/crates/xinput9_1_0-sys)
* [xmllite-sys ![Crates.io](https://img.shields.io/crates/v/xmllite-sys.svg)](https://crates.io/crates/xmllite-sys)
* [xolehlp-sys ![Crates.io](https://img.shields.io/crates/v/xolehlp-sys.svg)](https://crates.io/crates/xolehlp-sys)
* [xpsprint-sys ![Crates.io](https://img.shields.io/crates/v/xpsprint-sys.svg)](https://crates.io/crates/xpsprint-sys)
