// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
#![cfg(windows)]
extern crate kernel32;
use kernel32::*;
#[inline(never)] fn bb<T>(_: T) {}
#[test] #[cfg(target_arch="x86")]
fn functions_x86() {
    bb(InterlockedCompareExchange);
    bb(InterlockedCompareExchange64);
    bb(InterlockedDecrement);
    bb(InterlockedExchange);
    bb(InterlockedExchangeAdd);
    bb(InterlockedIncrement);
}
#[test] #[cfg(target_arch="x86_64")]
fn functions_x64() {
    bb(CreateUmsCompletionList);
    bb(CreateUmsThreadContext);
    bb(DeleteUmsCompletionList);
    bb(DeleteUmsThreadContext);
    bb(DequeueUmsCompletionListItems);
    bb(EnterUmsSchedulingMode);
    bb(ExecuteUmsThread);
    bb(GetCurrentUmsThread);
    bb(GetNextUmsListItem);
    bb(GetUmsCompletionListEvent);
    bb(QueryUmsThreadInformation);
    bb(RtlAddFunctionTable);
    bb(RtlDeleteFunctionTable);
    bb(RtlInstallFunctionTableCallback);
    bb(RtlLookupFunctionEntry);
    bb(RtlRestoreContext);
    bb(RtlUnwindEx);
    bb(RtlVirtualUnwind);
    bb(SetUmsThreadInformation);
    bb(UmsThreadYield);
    bb(uaw_lstrcmpW);
    bb(uaw_lstrcmpiW);
    bb(uaw_lstrlenW);
    bb(uaw_wcschr);
    bb(uaw_wcscpy);
    bb(uaw_wcsicmp);
    bb(uaw_wcslen);
    bb(uaw_wcsrchr);
}
#[test] #[cfg(target_arch="x86_64")] #[cfg(target_env = "msvc")]
fn functions_x64_msvc() {
    bb(GetEnabledXStateFeatures);
    bb(GetUmsSystemThreadInformation);
    bb(GetXStateFeaturesMask);
    bb(LocateXStateFeature);
    bb(SetXStateFeaturesMask);
}
#[test] #[cfg(any(target_arch="x86_64", target_arch="arm"))] #[cfg(target_env = "msvc")]
fn functions_x64_arm_msvc() {
    bb(RtlCompareMemory);
    bb(RtlCopyMemory);
}
#[test] #[cfg(target_arch="arm")]
fn functions_arm() {
    bb(RtlAddFunctionTable);
    bb(RtlDeleteFunctionTable);
    bb(RtlInstallFunctionTableCallback);
    bb(RtlLookupFunctionEntry);
    bb(RtlRestoreContext);
    bb(RtlUnwindEx);
    bb(RtlVirtualUnwind);
    bb(uaw_lstrcmpW);
    bb(uaw_lstrcmpiW);
    bb(uaw_lstrlenW);
    bb(uaw_wcschr);
    bb(uaw_wcscpy);
    bb(uaw_wcsicmp);
    bb(uaw_wcslen);
    bb(uaw_wcsrchr);
}
#[test] #[cfg(target_env = "msvc")]
fn functions_msvc() {
    bb(AddDllDirectory);
    bb(AddResourceAttributeAce);
    bb(AddScopedPolicyIDAce);
    //bb(CalloutOnFiberStack);
    bb(CeipIsOptedIn);
    bb(CheckTokenCapability);
    bb(CheckTokenMembershipEx);
    bb(CopyContext);
    bb(CopyFile2);
    bb(CreateFile2);
    bb(CreateFileMappingFromApp);
    bb(CreateRemoteThreadEx);
    bb(DeleteSynchronizationBarrier);
    bb(DisableThreadProfiling);
    bb(DnsHostnameToComputerNameExW);
    bb(EnableThreadProfiling);
    bb(EnterSynchronizationBarrier);
    bb(ExitThread);
    bb(GetAppContainerAce);
    bb(GetAppContainerNamedObjectPath);
    bb(GetCachedSigningLevel);
    bb(GetCurrentThreadStackLimits);
    bb(GetEnabledXStateFeatures);
    bb(GetFileMUIPath);
    bb(GetFirmwareEnvironmentVariableExA);
    bb(GetFirmwareEnvironmentVariableExW);
    bb(GetFirmwareType);
    bb(GetLogicalProcessorInformationEx);
    bb(GetMemoryErrorHandlingCapabilities);
    bb(GetOverlappedResultEx);
    bb(GetProcessInformation);
    bb(GetProcessMitigationPolicy);
    bb(GetSystemTimePreciseAsFileTime);
    bb(GetThreadInformation);
    bb(GetXStateFeaturesMask);
    bb(GlobalAddAtomExA);
    bb(GlobalAddAtomExW);
    bb(InitializeContext);
    bb(InitializeSynchronizationBarrier);
    bb(InstallELAMCertificateInfo);
    bb(InterlockedPushListSListEx);
    bb(IsNativeVhdBoot);
    bb(IsProcessCritical);
    bb(IsValidNLSVersion);
    bb(K32EmptyWorkingSet);
    bb(K32EnumDeviceDrivers);
    bb(K32EnumPageFilesA);
    bb(K32EnumPageFilesW);
    bb(K32EnumProcessModules);
    bb(K32EnumProcessModulesEx);
    bb(K32EnumProcesses);
    bb(K32GetDeviceDriverBaseNameA);
    bb(K32GetDeviceDriverBaseNameW);
    bb(K32GetDeviceDriverFileNameA);
    bb(K32GetDeviceDriverFileNameW);
    bb(K32GetMappedFileNameA);
    bb(K32GetMappedFileNameW);
    bb(K32GetModuleBaseNameA);
    bb(K32GetModuleBaseNameW);
    bb(K32GetModuleFileNameExA);
    bb(K32GetModuleFileNameExW);
    bb(K32GetModuleInformation);
    bb(K32GetPerformanceInfo);
    bb(K32GetProcessImageFileNameA);
    bb(K32GetProcessImageFileNameW);
    bb(K32GetProcessMemoryInfo);
    bb(K32GetWsChanges);
    bb(K32GetWsChangesEx);
    bb(K32InitializeProcessForWsWatch);
    bb(K32QueryWorkingSet);
    bb(K32QueryWorkingSetEx);
    bb(LoadPackagedLibrary);
    bb(LocateXStateFeature);
    bb(MapViewOfFileFromApp);
    bb(PowerSetRequest);
    bb(PrefetchVirtualMemory);
    bb(PssCaptureSnapshot);
    bb(PssDuplicateSnapshot);
    bb(PssFreeSnapshot);
    bb(PssQuerySnapshot);
    bb(PssWalkMarkerCreate);
    bb(PssWalkMarkerFree);
    bb(PssWalkMarkerGetPosition);
    bb(PssWalkMarkerSeekToBeginning);
    bb(PssWalkMarkerSetPosition);
    bb(PssWalkSnapshot);
    bb(QueryProtectedPolicy);
    bb(RegisterBadMemoryNotification);
    bb(RemoveDllDirectory);
    bb(SetCachedSigningLevel);
    bb(SetComputerNameEx2W);
    bb(SetDefaultDllDirectories);
    bb(SetFirmwareEnvironmentVariableExA);
    bb(SetFirmwareEnvironmentVariableExW);
    bb(SetProcessInformation);
    bb(SetProcessMitigationPolicy);
    bb(SetProtectedPolicy);
    bb(SetThreadInformation);
    bb(SetThreadpoolStackInformation);
    bb(SetThreadpoolTimerEx);
    bb(SetThreadpoolWaitEx);
    bb(SetWaitableTimerEx);
    bb(SetXStateFeaturesMask);
    bb(SystemTimeToTzSpecificLocalTimeEx);
    bb(TzSpecificLocalTimeToSystemTimeEx);
    bb(UnregisterBadMemoryNotification);
}
#[test]
fn functions() {
    bb(AcquireSRWLockExclusive);
    bb(AcquireSRWLockShared);
    bb(ActivateActCtx);
    bb(AddAtomA);
    bb(AddAtomW);
    bb(AddConsoleAliasA);
    bb(AddConsoleAliasW);
    bb(AddIntegrityLabelToBoundaryDescriptor);
    bb(AddRefActCtx);
    bb(AddSIDToBoundaryDescriptor);
    bb(AddSecureMemoryCacheCallback);
    bb(AddVectoredContinueHandler);
    bb(AddVectoredExceptionHandler);
    bb(AllocConsole);
    bb(AllocateUserPhysicalPages);
    bb(AllocateUserPhysicalPagesNuma);
    bb(ApplicationRecoveryFinished);
    bb(ApplicationRecoveryInProgress);
    bb(BackupRead);
    bb(BackupSeek);
    bb(BackupWrite);
    bb(BeginUpdateResourceA);
    bb(BeginUpdateResourceW);
    bb(BindIoCompletionCallback);
    bb(BuildCommDCBA);
    bb(BuildCommDCBAndTimeoutsA);
    bb(BuildCommDCBAndTimeoutsW);
    bb(BuildCommDCBW);
    bb(CallNamedPipeA);
    bb(CallNamedPipeW);
    bb(CallbackMayRunLong);
    bb(CancelDeviceWakeupRequest);
    bb(CancelIo);
    bb(CancelIoEx);
    bb(CancelSynchronousIo);
    bb(CancelThreadpoolIo);
    bb(CancelTimerQueueTimer);
    bb(CancelWaitableTimer);
    bb(ChangeTimerQueueTimer);
    bb(CheckNameLegalDOS8Dot3A);
    bb(CheckNameLegalDOS8Dot3W);
    bb(CheckRemoteDebuggerPresent);
    bb(ClearCommBreak);
    bb(ClearCommError);
    bb(CloseHandle);
    bb(ClosePrivateNamespace);
    bb(CloseThreadpool);
    bb(CloseThreadpoolCleanupGroup);
    bb(CloseThreadpoolCleanupGroupMembers);
    bb(CloseThreadpoolIo);
    bb(CloseThreadpoolTimer);
    bb(CloseThreadpoolWait);
    bb(CloseThreadpoolWork);
    bb(CommConfigDialogA);
    bb(CommConfigDialogW);
    bb(CompareFileTime);
    bb(CompareStringA);
    bb(CompareStringEx);
    bb(CompareStringOrdinal);
    bb(CompareStringW);
    bb(ConnectNamedPipe);
    bb(ContinueDebugEvent);
    bb(ConvertDefaultLocale);
    bb(ConvertFiberToThread);
    bb(ConvertThreadToFiber);
    bb(ConvertThreadToFiberEx);
    bb(CopyFileA);
    bb(CopyFileExA);
    bb(CopyFileExW);
    bb(CopyFileTransactedA);
    bb(CopyFileTransactedW);
    bb(CopyFileW);
    bb(CreateActCtxA);
    bb(CreateActCtxW);
    bb(CreateBoundaryDescriptorA);
    bb(CreateBoundaryDescriptorW);
    bb(CreateConsoleScreenBuffer);
    bb(CreateDirectoryA);
    bb(CreateDirectoryExA);
    bb(CreateDirectoryExW);
    bb(CreateDirectoryTransactedA);
    bb(CreateDirectoryTransactedW);
    bb(CreateDirectoryW);
    bb(CreateEventA);
    bb(CreateEventW);
    bb(CreateEventExA);
    bb(CreateEventExW);
    bb(CreateFiber);
    bb(CreateFiberEx);
    bb(CreateFileA);
    bb(CreateFileMappingA);
    bb(CreateFileMappingNumaA);
    bb(CreateFileMappingNumaW);
    bb(CreateFileMappingW);
    bb(CreateFileTransactedA);
    bb(CreateFileTransactedW);
    bb(CreateFileW);
    bb(CreateHardLinkA);
    bb(CreateHardLinkTransactedA);
    bb(CreateHardLinkTransactedW);
    bb(CreateHardLinkW);
    bb(CreateIoCompletionPort);
    bb(CreateJobObjectA);
    bb(CreateJobObjectW);
    bb(CreateJobSet);
    bb(CreateMailslotA);
    bb(CreateMailslotW);
    bb(CreateMemoryResourceNotification);
    bb(CreateMutexA);
    bb(CreateMutexExA);
    bb(CreateMutexExW);
    bb(CreateMutexW);
    bb(CreateNamedPipeA);
    bb(CreateNamedPipeW);
    bb(CreatePipe);
    bb(CreatePrivateNamespaceA);
    bb(CreatePrivateNamespaceW);
    bb(CreateProcessA);
    bb(CreateProcessW);
    bb(CreateRemoteThread);
    bb(CreateSemaphoreA);
    bb(CreateSemaphoreExA);
    bb(CreateSemaphoreExW);
    bb(CreateSemaphoreW);
    bb(CreateSymbolicLinkA);
    bb(CreateSymbolicLinkTransactedA);
    bb(CreateSymbolicLinkTransactedW);
    bb(CreateSymbolicLinkW);
    bb(CreateTapePartition);
    bb(CreateThread);
    bb(CreateThreadpool);
    bb(CreateThreadpoolCleanupGroup);
    bb(CreateThreadpoolIo);
    bb(CreateThreadpoolTimer);
    bb(CreateThreadpoolWait);
    bb(CreateThreadpoolWork);
    bb(CreateTimerQueue);
    bb(CreateTimerQueueTimer);
    bb(CreateToolhelp32Snapshot);
    bb(CreateWaitableTimerA);
    bb(CreateWaitableTimerExA);
    bb(CreateWaitableTimerExW);
    bb(CreateWaitableTimerW);
    bb(DeactivateActCtx);
    bb(DebugActiveProcess);
    bb(DebugActiveProcessStop);
    bb(DebugBreak);
    bb(DebugBreakProcess);
    bb(DebugSetProcessKillOnExit);
    bb(DecodePointer);
    bb(DecodeSystemPointer);
    bb(DefineDosDeviceA);
    bb(DefineDosDeviceW);
    bb(DelayLoadFailureHook);
    bb(DeleteAtom);
    bb(DeleteBoundaryDescriptor);
    bb(DeleteCriticalSection);
    bb(DeleteFiber);
    bb(DeleteFileA);
    bb(DeleteFileTransactedA);
    bb(DeleteFileTransactedW);
    bb(DeleteFileW);
    bb(DeleteProcThreadAttributeList);
    bb(DeleteTimerQueue);
    bb(DeleteTimerQueueEx);
    bb(DeleteTimerQueueTimer);
    bb(DeleteVolumeMountPointA);
    bb(DeleteVolumeMountPointW);
    bb(DeviceIoControl);
    bb(DisableThreadLibraryCalls);
    bb(DisassociateCurrentThreadFromCallback);
    bb(DisconnectNamedPipe);
    bb(DnsHostnameToComputerNameA);
    bb(DnsHostnameToComputerNameW);
    bb(DosDateTimeToFileTime);
    bb(DuplicateHandle);
    bb(EncodePointer);
    bb(EncodeSystemPointer);
    bb(EndUpdateResourceA);
    bb(EndUpdateResourceW);
    bb(EnumCalendarInfoA);
    bb(EnumCalendarInfoExA);
    bb(EnumCalendarInfoExEx);
    bb(EnumCalendarInfoExW);
    bb(EnumCalendarInfoW);
    bb(EnumDateFormatsA);
    bb(EnumDateFormatsExA);
    bb(EnumDateFormatsExEx);
    bb(EnumDateFormatsExW);
    bb(EnumDateFormatsW);
    bb(EnumLanguageGroupLocalesA);
    bb(EnumLanguageGroupLocalesW);
    bb(EnumResourceLanguagesA);
    bb(EnumResourceLanguagesExA);
    bb(EnumResourceLanguagesExW);
    bb(EnumResourceLanguagesW);
    bb(EnumResourceNamesA);
    bb(EnumResourceNamesExA);
    bb(EnumResourceNamesExW);
    bb(EnumResourceNamesW);
    bb(EnumResourceTypesA);
    bb(EnumResourceTypesExA);
    bb(EnumResourceTypesExW);
    bb(EnumResourceTypesW);
    bb(EnumSystemCodePagesA);
    bb(EnumSystemCodePagesW);
    bb(EnumSystemFirmwareTables);
    bb(EnumSystemGeoID);
    bb(EnumSystemLanguageGroupsA);
    bb(EnumSystemLanguageGroupsW);
    bb(EnumSystemLocalesA);
    bb(EnumSystemLocalesEx);
    bb(EnumSystemLocalesW);
    bb(EnumTimeFormatsA);
    bb(EnumTimeFormatsEx);
    bb(EnumTimeFormatsW);
    bb(EnumUILanguagesA);
    bb(EnumUILanguagesW);
    bb(EraseTape);
    bb(EscapeCommFunction);
    bb(ExitProcess);
    bb(ExpandEnvironmentStringsA);
    bb(ExpandEnvironmentStringsW);
    bb(FatalAppExitA);
    bb(FatalAppExitW);
    bb(FatalExit);
    bb(FileTimeToDosDateTime);
    bb(FileTimeToLocalFileTime);
    bb(FileTimeToSystemTime);
    bb(FillConsoleOutputAttribute);
    bb(FillConsoleOutputCharacterA);
    bb(FillConsoleOutputCharacterW);
    bb(FindActCtxSectionGuid);
    bb(FindActCtxSectionStringA);
    bb(FindActCtxSectionStringW);
    bb(FindAtomA);
    bb(FindAtomW);
    bb(FindClose);
    bb(FindCloseChangeNotification);
    bb(FindFirstChangeNotificationA);
    bb(FindFirstChangeNotificationW);
    bb(FindFirstFileA);
    bb(FindFirstFileExA);
    bb(FindFirstFileExW);
    bb(FindFirstFileNameTransactedW);
    bb(FindFirstFileNameW);
    bb(FindFirstFileTransactedA);
    bb(FindFirstFileTransactedW);
    bb(FindFirstFileW);
    bb(FindFirstStreamTransactedW);
    bb(FindFirstStreamW);
    bb(FindFirstVolumeA);
    bb(FindFirstVolumeMountPointA);
    bb(FindFirstVolumeMountPointW);
    bb(FindFirstVolumeW);
    bb(FindNLSString);
    bb(FindNLSStringEx);
    bb(FindNextChangeNotification);
    bb(FindNextFileA);
    bb(FindNextFileNameW);
    bb(FindNextFileW);
    bb(FindNextStreamW);
    bb(FindNextVolumeA);
    bb(FindNextVolumeMountPointA);
    bb(FindNextVolumeMountPointW);
    bb(FindNextVolumeW);
    bb(FindResourceA);
    bb(FindResourceExA);
    bb(FindResourceExW);
    bb(FindResourceW);
    bb(FindStringOrdinal);
    bb(FindVolumeClose);
    bb(FindVolumeMountPointClose);
    bb(FlsAlloc);
    bb(FlsFree);
    bb(FlsGetValue);
    bb(FlsSetValue);
    bb(FlushConsoleInputBuffer);
    bb(FlushFileBuffers);
    bb(FlushInstructionCache);
    bb(FlushProcessWriteBuffers);
    bb(FlushViewOfFile);
    bb(FoldStringA);
    bb(FoldStringW);
    bb(FormatMessageA);
    bb(FormatMessageW);
    bb(FreeConsole);
    bb(FreeEnvironmentStringsA);
    bb(FreeEnvironmentStringsW);
    bb(FreeLibrary);
    bb(FreeLibraryAndExitThread);
    bb(FreeLibraryWhenCallbackReturns);
    bb(FreeResource);
    bb(FreeUserPhysicalPages);
    bb(GenerateConsoleCtrlEvent);
    bb(GetACP);
    bb(GetActiveProcessorCount);
    bb(GetActiveProcessorGroupCount);
    bb(GetApplicationRecoveryCallback);
    bb(GetApplicationRestartSettings);
    bb(GetAtomNameA);
    bb(GetAtomNameW);
    bb(GetBinaryTypeA);
    bb(GetBinaryTypeW);
    bb(GetCPInfo);
    bb(GetCPInfoExA);
    bb(GetCPInfoExW);
    bb(GetCalendarInfoA);
    bb(GetCalendarInfoEx);
    bb(GetCalendarInfoW);
    bb(GetCommConfig);
    bb(GetCommMask);
    bb(GetCommModemStatus);
    bb(GetCommProperties);
    bb(GetCommState);
    bb(GetCommTimeouts);
    bb(GetCommandLineA);
    bb(GetCommandLineW);
    bb(GetCompressedFileSizeA);
    bb(GetCompressedFileSizeTransactedA);
    bb(GetCompressedFileSizeTransactedW);
    bb(GetCompressedFileSizeW);
    bb(GetComputerNameA);
    bb(GetComputerNameExA);
    bb(GetComputerNameExW);
    bb(GetComputerNameW);
    bb(GetConsoleAliasA);
    bb(GetConsoleAliasExesA);
    bb(GetConsoleAliasExesLengthA);
    bb(GetConsoleAliasExesLengthW);
    bb(GetConsoleAliasExesW);
    bb(GetConsoleAliasW);
    bb(GetConsoleAliasesA);
    bb(GetConsoleAliasesLengthA);
    bb(GetConsoleAliasesLengthW);
    bb(GetConsoleAliasesW);
    bb(GetConsoleCP);
    bb(GetConsoleCursorInfo);
    bb(GetConsoleDisplayMode);
    bb(GetConsoleFontSize);
    bb(GetConsoleHistoryInfo);
    bb(GetConsoleMode);
    bb(GetConsoleOriginalTitleA);
    bb(GetConsoleOriginalTitleW);
    bb(GetConsoleOutputCP);
    bb(GetConsoleProcessList);
    bb(GetConsoleScreenBufferInfo);
    bb(GetConsoleScreenBufferInfoEx);
    bb(GetConsoleSelectionInfo);
    bb(GetConsoleTitleA);
    bb(GetConsoleTitleW);
    bb(GetConsoleWindow);
    bb(GetCurrencyFormatA);
    bb(GetCurrencyFormatEx);
    bb(GetCurrencyFormatW);
    bb(GetCurrentActCtx);
    bb(GetCurrentConsoleFont);
    bb(GetCurrentConsoleFontEx);
    bb(GetCurrentDirectoryA);
    bb(GetCurrentDirectoryW);
    bb(GetCurrentProcess);
    bb(GetCurrentProcessId);
    bb(GetCurrentProcessorNumber);
    bb(GetCurrentProcessorNumberEx);
    bb(GetCurrentThread);
    bb(GetCurrentThreadId);
    bb(GetDateFormatA);
    bb(GetDateFormatEx);
    bb(GetDateFormatW);
    bb(GetDefaultCommConfigA);
    bb(GetDefaultCommConfigW);
    bb(GetDevicePowerState);
    bb(GetDiskFreeSpaceA);
    bb(GetDiskFreeSpaceExA);
    bb(GetDiskFreeSpaceExW);
    bb(GetDiskFreeSpaceW);
    bb(GetDllDirectoryA);
    bb(GetDllDirectoryW);
    bb(GetDurationFormat);
    bb(GetDurationFormatEx);
    bb(GetDynamicTimeZoneInformation);
    bb(GetEnvironmentStrings);
    bb(GetEnvironmentStringsW);
    bb(GetEnvironmentVariableA);
    bb(GetEnvironmentVariableW);
    bb(GetErrorMode);
    bb(GetExitCodeProcess);
    bb(GetExitCodeThread);
    bb(GetFileAttributesA);
    bb(GetFileAttributesExA);
    bb(GetFileAttributesExW);
    bb(GetFileAttributesTransactedA);
    bb(GetFileAttributesTransactedW);
    bb(GetFileAttributesW);
    bb(GetFileBandwidthReservation);
    bb(GetFileInformationByHandle);
    bb(GetFileInformationByHandleEx);
    bb(GetFileMUIInfo);
    bb(GetFileSize);
    bb(GetFileSizeEx);
    bb(GetFileTime);
    bb(GetFileType);
    bb(GetFinalPathNameByHandleA);
    bb(GetFinalPathNameByHandleW);
    bb(GetFirmwareEnvironmentVariableA);
    bb(GetFirmwareEnvironmentVariableW);
    bb(GetFullPathNameA);
    bb(GetFullPathNameTransactedA);
    bb(GetFullPathNameTransactedW);
    bb(GetFullPathNameW);
    bb(GetGeoInfoA);
    bb(GetGeoInfoW);
    bb(GetHandleInformation);
    bb(GetLargePageMinimum);
    bb(GetLargestConsoleWindowSize);
    bb(GetLastError);
    bb(GetLocalTime);
    bb(GetLocaleInfoA);
    bb(GetLocaleInfoEx);
    bb(GetLocaleInfoW);
    bb(GetLogicalDriveStringsA);
    bb(GetLogicalDriveStringsW);
    bb(GetLogicalDrives);
    bb(GetLogicalProcessorInformation);
    bb(GetLongPathNameA);
    bb(GetLongPathNameTransactedA);
    bb(GetLongPathNameTransactedW);
    bb(GetLongPathNameW);
    bb(GetMailslotInfo);
    bb(GetMaximumProcessorCount);
    bb(GetMaximumProcessorGroupCount);
    bb(GetModuleFileNameA);
    bb(GetModuleFileNameW);
    bb(GetModuleHandleA);
    bb(GetModuleHandleExA);
    bb(GetModuleHandleExW);
    bb(GetModuleHandleW);
    bb(GetNLSVersion);
    bb(GetNLSVersionEx);
    bb(GetNamedPipeClientComputerNameA);
    bb(GetNamedPipeClientComputerNameW);
    bb(GetNamedPipeClientProcessId);
    bb(GetNamedPipeClientSessionId);
    bb(GetNamedPipeHandleStateA);
    bb(GetNamedPipeHandleStateW);
    bb(GetNamedPipeInfo);
    bb(GetNamedPipeServerProcessId);
    bb(GetNamedPipeServerSessionId);
    bb(GetNativeSystemInfo);
    bb(GetNumaAvailableMemoryNode);
    bb(GetNumaAvailableMemoryNodeEx);
    bb(GetNumaHighestNodeNumber);
    bb(GetNumaNodeNumberFromHandle);
    bb(GetNumaNodeProcessorMask);
    bb(GetNumaNodeProcessorMaskEx);
    bb(GetNumaProcessorNode);
    bb(GetNumaProcessorNodeEx);
    bb(GetNumaProximityNode);
    bb(GetNumaProximityNodeEx);
    bb(GetNumberFormatA);
    bb(GetNumberFormatEx);
    bb(GetNumberFormatW);
    bb(GetNumberOfConsoleInputEvents);
    bb(GetNumberOfConsoleMouseButtons);
    bb(GetOEMCP);
    bb(GetOverlappedResult);
    bb(GetPhysicallyInstalledSystemMemory);
    bb(GetPriorityClass);
    bb(GetPrivateProfileIntA);
    bb(GetPrivateProfileIntW);
    bb(GetPrivateProfileSectionA);
    bb(GetPrivateProfileSectionNamesA);
    bb(GetPrivateProfileSectionNamesW);
    bb(GetPrivateProfileSectionW);
    bb(GetPrivateProfileStringA);
    bb(GetPrivateProfileStringW);
    bb(GetPrivateProfileStructA);
    bb(GetPrivateProfileStructW);
    bb(GetProcAddress);
    bb(GetProcessAffinityMask);
    bb(GetProcessDEPPolicy);
    bb(GetProcessGroupAffinity);
    bb(GetProcessHandleCount);
    bb(GetProcessHeap);
    bb(GetProcessHeaps);
    bb(GetProcessId);
    bb(GetProcessIdOfThread);
    bb(GetProcessIoCounters);
    bb(GetProcessPreferredUILanguages);
    bb(GetProcessPriorityBoost);
    bb(GetProcessShutdownParameters);
    bb(GetProcessTimes);
    bb(GetProcessVersion);
    bb(GetProcessWorkingSetSize);
    bb(GetProcessWorkingSetSizeEx);
    bb(GetProcessorSystemCycleTime);
    bb(GetProductInfo);
    bb(GetProfileIntA);
    bb(GetProfileIntW);
    bb(GetProfileSectionA);
    bb(GetProfileSectionW);
    bb(GetProfileStringA);
    bb(GetProfileStringW);
    bb(GetQueuedCompletionStatus);
    bb(GetQueuedCompletionStatusEx);
    bb(GetShortPathNameA);
    bb(GetShortPathNameW);
    bb(GetStartupInfoA);
    bb(GetStartupInfoW);
    bb(GetStdHandle);
    bb(GetStringScripts);
    bb(GetStringTypeA);
    bb(GetStringTypeExA);
    bb(GetStringTypeExW);
    bb(GetStringTypeW);
    bb(GetSystemDEPPolicy);
    bb(GetSystemDefaultLCID);
    bb(GetSystemDefaultLangID);
    bb(GetSystemDefaultLocaleName);
    bb(GetSystemDefaultUILanguage);
    bb(GetSystemDirectoryA);
    bb(GetSystemDirectoryW);
    bb(GetSystemFileCacheSize);
    bb(GetSystemFirmwareTable);
    bb(GetSystemInfo);
    bb(GetSystemPowerStatus);
    bb(GetSystemPreferredUILanguages);
    bb(GetSystemRegistryQuota);
    bb(GetSystemTime);
    bb(GetSystemTimeAdjustment);
    bb(GetSystemTimeAsFileTime);
    bb(GetSystemTimes);
    bb(GetSystemWindowsDirectoryA);
    bb(GetSystemWindowsDirectoryW);
    bb(GetSystemWow64DirectoryA);
    bb(GetSystemWow64DirectoryW);
    bb(GetTapeParameters);
    bb(GetTapePosition);
    bb(GetTapeStatus);
    bb(GetTempFileNameA);
    bb(GetTempFileNameW);
    bb(GetTempPathA);
    bb(GetTempPathW);
    bb(GetThreadContext);
    bb(GetThreadErrorMode);
    bb(GetThreadGroupAffinity);
    bb(GetThreadIOPendingFlag);
    bb(GetThreadId);
    bb(GetThreadIdealProcessorEx);
    bb(GetThreadLocale);
    bb(GetThreadPreferredUILanguages);
    bb(GetThreadPriority);
    bb(GetThreadPriorityBoost);
    bb(GetThreadSelectorEntry);
    bb(GetThreadTimes);
    bb(GetThreadUILanguage);
    bb(GetTickCount);
    bb(GetTickCount64);
    bb(GetTimeFormatA);
    bb(GetTimeFormatEx);
    bb(GetTimeFormatW);
    bb(GetTimeZoneInformation);
    bb(GetTimeZoneInformationForYear);
    bb(GetUILanguageInfo);
    bb(GetUserDefaultLCID);
    bb(GetUserDefaultLangID);
    bb(GetUserDefaultLocaleName);
    bb(GetUserDefaultUILanguage);
    bb(GetUserGeoID);
    bb(GetUserPreferredUILanguages);
    bb(GetVersion);
    bb(GetVersionExA);
    bb(GetVersionExW);
    bb(GetVolumeInformationA);
    bb(GetVolumeInformationByHandleW);
    bb(GetVolumeInformationW);
    bb(GetVolumeNameForVolumeMountPointA);
    bb(GetVolumeNameForVolumeMountPointW);
    bb(GetVolumePathNameA);
    bb(GetVolumePathNameW);
    bb(GetVolumePathNamesForVolumeNameA);
    bb(GetVolumePathNamesForVolumeNameW);
    bb(GetWindowsDirectoryA);
    bb(GetWindowsDirectoryW);
    bb(GetWriteWatch);
    bb(GlobalAddAtomA);
    bb(GlobalAddAtomW);
    bb(GlobalAlloc);
    bb(GlobalCompact);
    bb(GlobalDeleteAtom);
    bb(GlobalFindAtomA);
    bb(GlobalFindAtomW);
    bb(GlobalFix);
    bb(GlobalFlags);
    bb(GlobalGetAtomNameA);
    bb(GlobalGetAtomNameW);
    bb(GlobalHandle);
    bb(GlobalLock);
    bb(GlobalMemoryStatus);
    bb(GlobalMemoryStatusEx);
    bb(GlobalReAlloc);
    bb(GlobalSize);
    bb(GlobalUnWire);
    bb(GlobalUnfix);
    bb(GlobalUnlock);
    bb(GlobalWire);
    bb(Heap32First);
    bb(Heap32ListFirst);
    bb(Heap32ListNext);
    bb(Heap32Next);
    bb(HeapAlloc);
    bb(HeapCompact);
    bb(HeapCreate);
    bb(HeapDestroy);
    bb(HeapFree);
    bb(HeapLock);
    bb(HeapQueryInformation);
    bb(HeapReAlloc);
    bb(HeapSetInformation);
    bb(HeapSize);
    bb(HeapSummary);
    bb(HeapUnlock);
    bb(HeapValidate);
    bb(HeapWalk);
    bb(InitAtomTable);
    bb(InitOnceBeginInitialize);
    bb(InitOnceComplete);
    bb(InitOnceExecuteOnce);
    bb(InitOnceInitialize);
    bb(InitializeConditionVariable);
    bb(InitializeCriticalSection);
    bb(InitializeCriticalSectionAndSpinCount);
    bb(InitializeCriticalSectionEx);
    bb(InitializeProcThreadAttributeList);
    bb(InitializeSListHead);
    bb(InitializeSRWLock);
    bb(InterlockedFlushSList);
    bb(InterlockedPopEntrySList);
    bb(IsBadCodePtr);
    bb(IsBadHugeReadPtr);
    bb(IsBadHugeWritePtr);
    bb(IsBadReadPtr);
    bb(IsBadStringPtrA);
    bb(IsBadStringPtrW);
    bb(IsBadWritePtr);
    bb(IsDBCSLeadByte);
    bb(IsDBCSLeadByteEx);
    bb(IsDebuggerPresent);
    bb(IsNLSDefinedString);
    bb(IsNormalizedString);
    bb(IsProcessInJob);
    bb(IsProcessorFeaturePresent);
    bb(IsSystemResumeAutomatic);
    bb(IsThreadAFiber);
    bb(IsThreadpoolTimerSet);
    bb(IsValidCodePage);
    bb(IsValidLanguageGroup);
    bb(IsValidLocale);
    bb(IsValidLocaleName);
    bb(IsWow64Process);
    bb(LCIDToLocaleName);
    bb(LCMapStringA);
    bb(LCMapStringEx);
    bb(LCMapStringW);
    bb(LeaveCriticalSection);
    bb(LeaveCriticalSectionWhenCallbackReturns);
    bb(LoadLibraryA);
    bb(LoadLibraryExA);
    bb(LoadLibraryExW);
    bb(LoadLibraryW);
    bb(LoadModule);
    bb(LoadResource);
    bb(LocalAlloc);
    bb(LocalCompact);
    bb(LocalFileTimeToFileTime);
    bb(LocalFlags);
    bb(LocalFree);
    bb(LocalHandle);
    bb(LocalLock);
    bb(LocalReAlloc);
    bb(LocalShrink);
    bb(LocalSize);
    bb(LocalUnlock);
    bb(LocaleNameToLCID);
    bb(LockFile);
    bb(LockFileEx);
    bb(LockResource);
    bb(MapUserPhysicalPages);
    bb(MapUserPhysicalPagesScatter);
    bb(MapViewOfFile);
    bb(MapViewOfFileEx);
    bb(MapViewOfFileExNuma);
    bb(Module32First);
    bb(Module32FirstW);
    bb(Module32Next);
    bb(Module32NextW);
    bb(MoveFileA);
    bb(MoveFileExA);
    bb(MoveFileExW);
    bb(MoveFileTransactedA);
    bb(MoveFileTransactedW);
    bb(MoveFileW);
    bb(MoveFileWithProgressA);
    bb(MoveFileWithProgressW);
    bb(MulDiv);
    bb(MultiByteToWideChar);
    bb(NeedCurrentDirectoryForExePathA);
    bb(NeedCurrentDirectoryForExePathW);
    bb(NormalizeString);
    bb(NotifyUILanguageChange);
    bb(OpenEventA);
    bb(OpenEventW);
    bb(OpenFile);
    bb(OpenFileById);
    bb(OpenFileMappingA);
    bb(OpenFileMappingW);
    bb(OpenJobObjectA);
    bb(OpenJobObjectW);
    bb(OpenMutexA);
    bb(OpenMutexW);
    bb(OpenPrivateNamespaceA);
    bb(OpenPrivateNamespaceW);
    bb(OpenProcess);
    bb(OpenSemaphoreA);
    bb(OpenSemaphoreW);
    bb(OpenThread);
    bb(OpenWaitableTimerA);
    bb(OpenWaitableTimerW);
    bb(OutputDebugStringA);
    bb(OutputDebugStringW);
    bb(PeekConsoleInputA);
    bb(PeekConsoleInputW);
    bb(PeekNamedPipe);
    bb(PostQueuedCompletionStatus);
    bb(PowerClearRequest);
    bb(PowerCreateRequest);
    bb(PrepareTape);
    bb(Process32First);
    bb(Process32FirstW);
    bb(Process32Next);
    bb(Process32NextW);
    bb(ProcessIdToSessionId);
    bb(PulseEvent);
    bb(PurgeComm);
    bb(QueryActCtxSettingsW);
    bb(QueryActCtxW);
    bb(QueryDepthSList);
    bb(QueryDosDeviceA);
    bb(QueryDosDeviceW);
    bb(QueryFullProcessImageNameA);
    bb(QueryFullProcessImageNameW);
    bb(QueryIdleProcessorCycleTime);
    bb(QueryIdleProcessorCycleTimeEx);
    bb(QueryInformationJobObject);
    bb(QueryPerformanceCounter);
    bb(QueryPerformanceFrequency);
    bb(QueryProcessAffinityUpdateMode);
    bb(QueryProcessCycleTime);
    bb(QueryThreadCycleTime);
    bb(QueryThreadProfiling);
    bb(QueryThreadpoolStackInformation);
    bb(QueryUnbiasedInterruptTime);
    bb(QueueUserAPC);
    bb(QueueUserWorkItem);
    bb(RaiseException);
    bb(RaiseFailFastException);
    bb(ReOpenFile);
    bb(ReadConsoleA);
    bb(ReadConsoleInputA);
    bb(ReadConsoleInputW);
    bb(ReadConsoleOutputA);
    bb(ReadConsoleOutputAttribute);
    bb(ReadConsoleOutputCharacterA);
    bb(ReadConsoleOutputCharacterW);
    bb(ReadConsoleOutputW);
    bb(ReadConsoleW);
    bb(ReadDirectoryChangesW);
    bb(ReadFile);
    bb(ReadFileEx);
    bb(ReadFileScatter);
    bb(ReadProcessMemory);
    bb(ReadThreadProfilingData);
    bb(RegisterApplicationRecoveryCallback);
    bb(RegisterApplicationRestart);
    bb(RegisterWaitForSingleObject);
    bb(RegisterWaitForSingleObjectEx);
    bb(ReleaseActCtx);
    bb(ReleaseMutex);
    bb(ReleaseMutexWhenCallbackReturns);
    bb(ReleaseSRWLockExclusive);
    bb(ReleaseSRWLockShared);
    bb(ReleaseSemaphore);
    bb(ReleaseSemaphoreWhenCallbackReturns);
    bb(RemoveDirectoryA);
    bb(RemoveDirectoryTransactedA);
    bb(RemoveDirectoryTransactedW);
    bb(RemoveDirectoryW);
    bb(RemoveSecureMemoryCacheCallback);
    bb(RemoveVectoredContinueHandler);
    bb(RemoveVectoredExceptionHandler);
    bb(ReplaceFileA);
    bb(ReplaceFileW);
    bb(ReplacePartitionUnit);
    bb(RequestDeviceWakeup);
    bb(RequestWakeupLatency);
    bb(ResetEvent);
    bb(ResetWriteWatch);
    bb(RestoreLastError);
    bb(ResumeThread);
    bb(RtlCaptureContext);
    bb(RtlCaptureStackBackTrace);
    bb(RtlUnwind);
    bb(ScrollConsoleScreenBufferA);
    bb(ScrollConsoleScreenBufferW);
    bb(SearchPathA);
    bb(SearchPathW);
    bb(SetCalendarInfoA);
    bb(SetCalendarInfoW);
    bb(SetCommBreak);
    bb(SetCommConfig);
    bb(SetCommMask);
    bb(SetCommState);
    bb(SetCommTimeouts);
    bb(SetComputerNameA);
    bb(SetComputerNameExA);
    bb(SetComputerNameExW);
    bb(SetComputerNameW);
    bb(SetConsoleActiveScreenBuffer);
    bb(SetConsoleCP);
    bb(SetConsoleCtrlHandler);
    bb(SetConsoleCursorInfo);
    bb(SetConsoleCursorPosition);
    bb(SetConsoleDisplayMode);
    bb(SetConsoleHistoryInfo);
    bb(SetConsoleMode);
    bb(SetConsoleOutputCP);
    bb(SetConsoleScreenBufferInfoEx);
    bb(SetConsoleScreenBufferSize);
    bb(SetConsoleTextAttribute);
    bb(SetConsoleTitleA);
    bb(SetConsoleTitleW);
    bb(SetConsoleWindowInfo);
    bb(SetCriticalSectionSpinCount);
    bb(SetCurrentConsoleFontEx);
    bb(SetCurrentDirectoryA);
    bb(SetCurrentDirectoryW);
    bb(SetDefaultCommConfigA);
    bb(SetDefaultCommConfigW);
    bb(SetDllDirectoryA);
    bb(SetDllDirectoryW);
    bb(SetDynamicTimeZoneInformation);
    bb(SetEndOfFile);
    bb(SetEnvironmentStringsA);
    bb(SetEnvironmentStringsW);
    bb(SetEnvironmentVariableA);
    bb(SetEnvironmentVariableW);
    bb(SetErrorMode);
    bb(SetEvent);
    bb(SetEventWhenCallbackReturns);
    bb(SetFileApisToANSI);
    bb(SetFileApisToOEM);
    bb(SetFileAttributesA);
    bb(SetFileAttributesTransactedA);
    bb(SetFileAttributesTransactedW);
    bb(SetFileAttributesW);
    bb(SetFileBandwidthReservation);
    bb(SetFileCompletionNotificationModes);
    bb(SetFileInformationByHandle);
    bb(SetFileIoOverlappedRange);
    bb(SetFilePointer);
    bb(SetFilePointerEx);
    bb(SetFileShortNameA);
    bb(SetFileShortNameW);
    bb(SetFileTime);
    bb(SetFileValidData);
    bb(SetFirmwareEnvironmentVariableA);
    bb(SetFirmwareEnvironmentVariableW);
    bb(SetHandleCount);
    bb(SetHandleInformation);
    bb(SetInformationJobObject);
    bb(SetLastError);
    bb(SetLocalTime);
    bb(SetLocaleInfoA);
    bb(SetLocaleInfoW);
    bb(SetMailslotInfo);
    bb(SetMessageWaitingIndicator);
    bb(SetNamedPipeAttribute);
    bb(SetNamedPipeHandleState);
    bb(SetPriorityClass);
    bb(SetProcessAffinityMask);
    bb(SetProcessAffinityUpdateMode);
    bb(SetProcessDEPPolicy);
    bb(SetProcessPreferredUILanguages);
    bb(SetProcessPriorityBoost);
    bb(SetProcessShutdownParameters);
    bb(SetProcessWorkingSetSize);
    bb(SetProcessWorkingSetSizeEx);
    bb(SetSearchPathMode);
    bb(SetStdHandle);
    bb(SetStdHandleEx);
    bb(SetSystemFileCacheSize);
    bb(SetSystemPowerState);
    bb(SetSystemTime);
    bb(SetSystemTimeAdjustment);
    bb(SetTapeParameters);
    bb(SetTapePosition);
    bb(SetThreadAffinityMask);
    bb(SetThreadContext);
    bb(SetThreadErrorMode);
    bb(SetThreadExecutionState);
    bb(SetThreadGroupAffinity);
    bb(SetThreadIdealProcessor);
    bb(SetThreadIdealProcessorEx);
    bb(SetThreadLocale);
    bb(SetThreadPreferredUILanguages);
    bb(SetThreadPriority);
    bb(SetThreadPriorityBoost);
    bb(SetThreadUILanguage);
    bb(SetThreadpoolThreadMaximum);
    bb(SetThreadpoolThreadMinimum);
    bb(SetThreadpoolTimer);
    bb(SetThreadpoolWait);
    bb(SetTimeZoneInformation);
    bb(SetTimerQueueTimer);
    bb(SetUnhandledExceptionFilter);
    bb(SetUserGeoID);
    bb(SetVolumeLabelA);
    bb(SetVolumeLabelW);
    bb(SetVolumeMountPointA);
    bb(SetVolumeMountPointW);
    bb(SetWaitableTimer);
    bb(SetupComm);
    bb(SignalObjectAndWait);
    bb(SizeofResource);
    bb(Sleep);
    bb(SleepConditionVariableCS);
    bb(SleepConditionVariableSRW);
    bb(SleepEx);
    bb(StartThreadpoolIo);
    bb(SubmitThreadpoolWork);
    bb(SuspendThread);
    bb(SwitchToFiber);
    bb(SwitchToThread);
    bb(SystemTimeToFileTime);
    bb(SystemTimeToTzSpecificLocalTime);
    bb(TerminateJobObject);
    bb(TerminateProcess);
    bb(TerminateThread);
    bb(Thread32First);
    bb(Thread32Next);
    bb(TlsAlloc);
    bb(TlsFree);
    bb(TlsGetValue);
    bb(TlsSetValue);
    bb(Toolhelp32ReadProcessMemory);
    bb(TransactNamedPipe);
    bb(TransmitCommChar);
    bb(TryAcquireSRWLockExclusive);
    bb(TryAcquireSRWLockShared);
    bb(TryEnterCriticalSection);
    bb(TrySubmitThreadpoolCallback);
    bb(TzSpecificLocalTimeToSystemTime);
    bb(UnhandledExceptionFilter);
    bb(UnlockFile);
    bb(UnlockFileEx);
    bb(UnmapViewOfFile);
    bb(UnregisterApplicationRecoveryCallback);
    bb(UnregisterApplicationRestart);
    bb(UnregisterWait);
    bb(UnregisterWaitEx);
    bb(UpdateProcThreadAttribute);
    bb(UpdateResourceA);
    bb(UpdateResourceW);
    bb(VerLanguageNameA);
    bb(VerLanguageNameW);
    bb(VerSetConditionMask);
    bb(VerifyScripts);
    bb(VerifyVersionInfoA);
    bb(VerifyVersionInfoW);
    bb(VirtualAlloc);
    bb(VirtualAllocEx);
    bb(VirtualAllocExNuma);
    bb(VirtualFree);
    bb(VirtualFreeEx);
    bb(VirtualLock);
    bb(VirtualProtect);
    bb(VirtualProtectEx);
    bb(VirtualQuery);
    bb(VirtualQueryEx);
    bb(VirtualUnlock);
    bb(WTSGetActiveConsoleSessionId);
    bb(WaitCommEvent);
    bb(WaitForDebugEvent);
    bb(WaitForMultipleObjects);
    bb(WaitForMultipleObjectsEx);
    bb(WaitForSingleObject);
    bb(WaitForSingleObjectEx);
    bb(WaitForThreadpoolIoCallbacks);
    bb(WaitForThreadpoolTimerCallbacks);
    bb(WaitForThreadpoolWaitCallbacks);
    bb(WaitNamedPipeA);
    bb(WaitNamedPipeW);
    bb(WakeAllConditionVariable);
    bb(WakeConditionVariable);
    bb(WerGetFlags);
    bb(WerRegisterFile);
    bb(WerRegisterMemoryBlock);
    bb(WerRegisterRuntimeExceptionModule);
    bb(WerSetFlags);
    bb(WerUnregisterFile);
    bb(WerUnregisterMemoryBlock);
    bb(WerUnregisterRuntimeExceptionModule);
    bb(WideCharToMultiByte);
    bb(WinExec);
    bb(Wow64DisableWow64FsRedirection);
    bb(Wow64EnableWow64FsRedirection);
    bb(Wow64GetThreadContext);
    bb(Wow64GetThreadSelectorEntry);
    bb(Wow64RevertWow64FsRedirection);
    bb(Wow64SetThreadContext);
    bb(Wow64SuspendThread);
    bb(WriteConsoleA);
    bb(WriteConsoleInputA);
    bb(WriteConsoleInputW);
    bb(WriteConsoleOutputA);
    bb(WriteConsoleOutputAttribute);
    bb(WriteConsoleOutputCharacterA);
    bb(WriteConsoleOutputCharacterW);
    bb(WriteConsoleOutputW);
    bb(WriteConsoleW);
    bb(WriteFile);
    bb(WriteFileEx);
    bb(WriteFileGather);
    bb(WritePrivateProfileSectionA);
    bb(WritePrivateProfileSectionW);
    bb(WritePrivateProfileStringA);
    bb(WritePrivateProfileStringW);
    bb(WritePrivateProfileStructA);
    bb(WritePrivateProfileStructW);
    bb(WriteProcessMemory);
    bb(WriteProfileSectionA);
    bb(WriteProfileSectionW);
    bb(WriteProfileStringA);
    bb(WriteProfileStringW);
    bb(WriteTapemark);
    bb(ZombifyActCtx);
    bb(_hread);
    bb(_hwrite);
    bb(_lclose);
    bb(_lcreat);
    bb(_llseek);
    bb(_lopen);
    bb(_lread);
    bb(_lwrite);
    bb(lstrcat);
    bb(lstrcatA);
    bb(lstrcatW);
    bb(lstrcmp);
    bb(lstrcmpA);
    bb(lstrcmpW);
    bb(lstrcmpi);
    bb(lstrcmpiA);
    bb(lstrcmpiW);
    bb(lstrcpy);
    bb(lstrcpyA);
    bb(lstrcpyW);
    bb(lstrcpyn);
    bb(lstrcpynA);
    bb(lstrcpynW);
    bb(lstrlen);
    bb(lstrlenA);
    bb(lstrlenW);
}
