dnl Check for proper location of QTDIR
AC_DEFUN([CHECK_QT],
[
  AC_ARG_WITH(qt,
    AC_HELP_STRING([--with-qt], [location of Qt library]),
    [ac_cv_qt_given=$withval],
    [ac_cv_qt_given=no])

  AC_CACHE_CHECK([location of Qt library],
    ac_cv_qt_lib,
    [
      if test "$ac_cv_qt_given" != "no"; then
        if test -e $ac_cv_qt_given/include/qglobal.h; then
          ac_cv_qt_lib=$ac_cv_qt_given;
        fi
      fi
      dnl Still empty... check a few known places
      if test -z "$ac_cv_qt_lib"; then
        for T in $QTDIR /usr/lib/qt /usr/lib/qt2 /usr/lib/qt3 /usr/local/lib/qt /usr/local/lib/qt2 /usr/local/lib/qt3; do
           if test "x$ac_cv_qt_lib" = "x"; then
             if test -e $T/include/qglobal.h; then
               ac_cv_qt_lib=$T;
             fi
           fi
        done
      fi
    ])

  if test -n "$ac_cv_qt_lib"; then
    QTDIR=$ac_cv_qt_lib
    AC_SUBST(QTDIR)
  else
    echo 'Qt library not found. Giving up...'
    exit 1
  fi
])

dnl Check if Qt is multithreaded
AC_DEFUN([CHECK_QT_MT], [
  AC_CACHE_CHECK([if Qt is multi-threaded],
    ac_cv_qt_mt,
    [
      ac_cv_qt_mt=no
      if test -e "$QTDIR/lib/libqt-mt.so"; then
        ac_cv_qt_mt=yes
      fi
      if test -e "$QTDIR/lib/libqt-mt3.a"; then
        ac_cv_qt_mt=yes
      fi
      if test -e "$QTDIR/lib/libqt-mt2.a"; then
        ac_cv_qt_mt=yes
      fi
    ]
  )
  if test "$ac_cv_qt_mt" = "yes"; then
    QTLIB_NAME="qt-mt"
    AC_DEFINE([_REENTRANT], [], [Multithreading requires this])
    AC_DEFINE([QT_THREAD_SUPPORT], [], [Qt multithreading requires this])
  else
    QTLIB_NAME="qt"
  fi
  AC_SUBST(QTLIB_NAME)
])

AC_DEFUN([FORCE_QT_MT],
[
  CHECK_QT_MT
  if test "$ac_cv_qt_mt" != "yes"; then
    echo "Qt is not multithreaded (or its name is wrong). You MUST have a multithreaded"
    echo "version of the Qt library installed or CamStream will simply not compile."
    exit
  fi
])

dnl Check for moc & uic
AC_DEFUN([CHECK_QT_PROGS],
[
  SPATH=$QTDIR/bin:$PATH:/usr/bin:/usr/X11R6/bin:/usr/lib/qt/bin:/usr/lib/qt2/bin:/usr/lib/qt3/bin:/usr/local/qt/bin:/usr/local/lib/qt/bin
  AC_PATH_PROG(MOC, moc, $QTDIR/bin/moc, $SPATH)
  AC_PATH_PROG(UIC, uic, $QTDIR/bin/uic, $SPATH)
])
