#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>

#include "tracer.h"

#include "AudioCollector.h"
#include "AudioSettingsDlg.h"
#include "AudioDisplayVolume.h"

TR_MODULE("AudioSettingsDlg");

CAudioSettingsDlg::CAudioSettingsDlg(QWidget *parent, const char *name, bool modal)
	: CAudioSettings(parent, name, modal)
{
   CAudioCollector *pCollector = CAudioCollector::Instance();
   CAudioDevice *pDev = 0;
   uint t;

   m_pCurrentDevice = 0;
   m_pCurrentReader = 0;
   /* Fill dropdown box with audio devices */
   DevicesComboBox->clear();
   DevicesComboBox->insertItem(tr("(no device)"));
   if (pCollector != 0)
   {
//     m_Dropdown2Device.resize(pCollector->NumberOfAudioDevices() + 1);
     for (t = 0; t < pCollector->NumberOfAudioDevices(); t++)
     {
        pDev = pCollector->GetAudioDevice(t);
        if (pDev == 0)
          continue;
        DevicesComboBox->insertItem(pDev->GetName(), t + 1);
     }
   }
}


void CAudioSettingsDlg::PresetDevice(CAudioDevice *dev)
{
   /* Search combo box for a matching name */
   CAudioCollector *pCollector = CAudioCollector::Instance();
   CAudioDevice *pDev = 0;
   uint t;

   if (dev == 0)
   {
     DevicesComboBox->setCurrentItem(0);
     MixerPushButton->setEnabled(false);
   }
   else
   {
     for (t = 0; t < pCollector->NumberOfAudioDevices(); t++)
     {
        pDev = pCollector->GetAudioDevice(t);
        if (pDev == dev)
        {
          DevicesComboBox->setCurrentItem(t + 1);
          MixerPushButton->setEnabled(true);
          break;
        }
     }
   }
   SetDevice(dev);
}



// protected

void CAudioSettingsDlg::ChangedSelection(int new_choice)
{
   CAudioDevice *pAudio = 0;

   MixerPushButton->setEnabled(new_choice > 0);
   if (new_choice > 0)
   {
     pAudio = CAudioCollector::Instance()->GetAudioDevice(new_choice - 1);
   }
   SetDevice(pAudio);
}


void CAudioSettingsDlg::MixerButtonClicked()
{
   int current;
   CAudioCollector *pCollector = CAudioCollector::Instance();
   CAudioDevice *pDev = 0;

   // Find current item, open mixer dialog
   current = DevicesComboBox->currentItem() - 1;
   if (current < 0)
     return;
   pDev = CAudioCollector::Instance()->GetAudioDevice(current);
   if (pDev == 0)
     return;
   pDev->ShowMixerControls();
}


void CAudioSettingsDlg::SamplerateChanged(int rate)
{

}

void CAudioSettingsDlg::BitdepthChanged(int bitdepth)
{

}


void CAudioSettingsDlg::ChannelsChanged(int channels)
{

}




// private

void CAudioSettingsDlg::SetDevice(CAudioDevice *dev)
{
   CAudioRingBufferReader *pAudioReader = 0;

   if (dev == m_pCurrentDevice)
     return;

   TR_ENTER();
   TR(1, "Setting new device: %s", dev->GetName().ascii());

   // Set new reader in our DisplayVolume thingie
   if (dev != 0)
   {
     pAudioReader = dev->CreateReader();
     if (pAudioReader == 0)
     {
       qWarning("CAudioSettingsDlg::SetDevice() Failed to create reader...");
     }
   }
   VolumeDisplay->SetReader(pAudioReader); // a NULL pointer is allowed.
   delete m_pCurrentReader; // clean up old one
   m_pCurrentReader = pAudioReader;

   m_pCurrentDevice = dev;

   SetGUIFromDevice();
   TR_LEAVE();
}

/*
  \brief Enables or disables all the audio GUI elements (dropdown, radiobuttons)
  \param do_enable Whether to enable or disable the GUI elements

  With this function you quickly enable or disable the Preset combobx,
  the sample rate combobox, the bit-depth radio buttons and channels
  radio buttons
*/

void CAudioSettingsDlg::EnableGUI(bool do_enable)
{
  SettingsGroupBox->setEnabled(do_enable);
}



/*
  \brief Set GUI buttons to settings from device (if any)

*/

void CAudioSettingsDlg::SetGUIFromDevice() const
{
   SoundAttributes Attrs;

   if (m_pCurrentDevice == 0)
     return;

   Attrs = m_pCurrentDevice->GetSoundAttributes();
   switch (Attrs.SampleRate / 1000) // to the nearest kHz
   {
     case 8:      SamplerateButtonGroup->setButton(0);  break;
     case 11:     SamplerateButtonGroup->setButton(1);  break;
     case 22:     SamplerateButtonGroup->setButton(2);  break;
     case 44:     SamplerateButtonGroup->setButton(3);  break;
     case 48:     SamplerateButtonGroup->setButton(4);  break;
     case 96:     SamplerateButtonGroup->setButton(5);  break;
     default:     SamplerateButtonGroup->setButton(-1); break;
   }
   switch (Attrs.SampleFormat)
   {
     case SoundAttributes::Signed8:
     case SoundAttributes::Unsigned8:
       BitdepthButtonGroup->setButton(0);
       break;
     case SoundAttributes::Signed16:
     case SoundAttributes::Unsigned16:
       BitdepthButtonGroup->setButton(1);
       break;
     case SoundAttributes::Signed24:
     case SoundAttributes::Unsigned24:
       BitdepthButtonGroup->setButton(2);
       break;
     default:
       BitdepthButtonGroup->setButton(-1);
       break;
   }
   switch (Attrs.Channels)
   {
     case 1:       ChannelsButtonGroup->setButton(0);  break;
     case 2:       ChannelsButtonGroup->setButton(1);  break;
     case 4:       ChannelsButtonGroup->setButton(2);  break;
     default:      ChannelsButtonGroup->setButton(-1); break;
   }
}
