(* $Id: uReStr.ml,v 1.3 2003/12/19 17:24:34 yori Exp $ *)
(* Copyright 2003 Yamagata Yoriyuki. distributed with LGPL *)

type regexp = URe.regexp

let regexp s =
  let lexbuf = Lexing.from_string s in
  UReStrParser.start UReStrLexer.token lexbuf

let quote s =
  let b = Buffer.create 8 in
  String.iter (fun c ->
    match c with
      '.' -> Buffer.add_string b "\\." 
    | '*' -> Buffer.add_string b "\\*"
    | '+' -> Buffer.add_string b "\\+"
    | '?' -> Buffer.add_string b "\\?"
    | '[' -> Buffer.add_string b "\\["
    | ']' -> Buffer.add_string b "\\]"
    | '^' -> Buffer.add_string b "\\^"
    | '$' -> Buffer.add_string b "\\$"
    | '\\' -> Buffer.add_string b "\\\\"
    | c -> Buffer.add_char b c)
    s;
  Buffer.contents b

let regexp_string s = 
  let b = ref [] in
  UTF8.iter (fun u -> b := u :: !b) s;
  `String (List.rev !b)

module type Type = URe.Type

module Make = URe.Make
