let print s = print_string s; flush stdout
module Camlmix =
struct
  let source = ref ""
  let line = ref 1
  let char = ref 1
  let printer = ref print
  let print_with f =
    let saved_printer = !printer in
    printer := (fun s -> f s; printer := saved_printer)
  let print_if test =
    if not test then print_with ignore
end
;;

# 1 "caml2html.html.mlx";;

let () =
  Camlmix.line := 1;
  Camlmix.char := 1;
  Camlmix.source := "caml2html.html.mlx"
;;

let () = !Camlmix.printer 
# 1 "caml2html.html.mlx";;
 "";;

let () =
  Camlmix.line := 1;
  Camlmix.char := 3;
  Camlmix.source := "caml2html.html.mlx"
;;

# 1 "caml2html.html.mlx";;
  
#use "topfind";;
#camlp4o;;
#require "netstring";;
#require "mikmatch_pcre";;
open Mikmatch;;


let () =
  Camlmix.line := 8;
  Camlmix.char := 1;
  Camlmix.source := "caml2html.html.mlx"
;;

let () = !Camlmix.printer 
# 8 "caml2html.html.mlx";;
 "<html>\n<head>\n  <title>How to use Caml2html</title>\n</head>\n\n<body style=\"font-family:sans-serif; background-color:white; color:black\">\n<center><h1>How to use Caml2html</h1></center>\n\n<p>\nMore information about Caml2html \n<a href=\"http://martin.jambon.free.fr/caml2html.html\">here</a>.\n\n<h2>Usage</h2>\n\n<pre>\n";;

let () =
  Camlmix.line := 23;
  Camlmix.char := 3;
  Camlmix.source := "caml2html.html.mlx"
;;

let () = !Camlmix.printer 
# 23 "caml2html.html.mlx";;
 (  Netencoding.Html.encode 
      ~in_enc:`Enc_iso88591 
      ~out_enc:`Enc_iso88591 () 
      (Text.file_contents "caml2html-help") 
 : string);;

let () =
  Camlmix.line := 27;
  Camlmix.char := 1;
  Camlmix.source := "caml2html.html.mlx"
;;

let () = !Camlmix.printer 
# 27 "caml2html.html.mlx";;
 "</pre>\n\n\n<h2>Examples</h2>\n\n<p>Process a single file <code>code.ml</code>:\n<pre>caml2html code.ml</pre>\n\n<p>Same thing with a title for the page:\n<pre>caml2html -t code.ml</pre>\n\n<p>Process a file with a title and line numbers:\n<pre>caml2html -t -ln code.ml</pre>\n\n<p>Process a file with a title, line numbers and replace tabs by 4 spaces:\n<pre>caml2html -t -ln -tab 4 code.ml</pre>\n\n<p>Process a file without footnotes (the most simple output):\n<pre>caml2html -nf code.ml</pre>\n\n<p>Process a file and use a css (style.css):\n<pre>caml2html -css code.ml</pre>\n\n<p>Process a file and use a specific css (http://blabla.com/style2.css):\n<pre>caml2html -css -cssurl http://blabla.com/style2.css code.ml</pre>\n\n<p>Read from stdin and output to stdout:\n<pre>caml2html</pre>\n\n<p>Process many files into a single file:\n<pre>caml2html -o result.html *.mli *.ml</pre>\n\n<p>Process many files, and create one HTML page for each file:\n<pre>caml2html *.ml</pre>\n\n<p>Same thing, but write result in the <code>html</code> directory:\n<pre>caml2html -d html *.ml</pre>\n\n<p>Same thing, but write result in the <code>html</code> directory:\n<pre>caml2html -d html *.ml</pre>\n\n<p>You can specify the character encoding with the -charset option:\n<pre>\ncaml2html -charset euc-jp input.ml -o output.html\n</pre>\n\n<p>You can write the comments in HTML. This lets you add simple\nformatting such as hyperlinks. Beware that one HTML tag cannot \nspan over several lines, and that the characters \n<code>&lt;</code>, <code>&gt;</code> and <code>&amp;</code>\nmust be written as <code>&amp;lt;</code>, <code>&amp;gt;</code> \nand <code>&amp;amp;</code>.\n<pre>\n(* This is file1.ml.\n   &lt;a href=\"#file2.ml\"&gt;This is a link to file2.ml&lt;/a&gt;. *)\n...\n</pre>\n<p>\nIn this case, use the <code>-hc</code> option:\n<pre>\ncaml2html -hc file1.ml file2.ml -o result.html\n</pre>\n\n\n\n<hr>\n<p>\n<em>This document was not generated by caml2html!</em>\n</body>\n</html>\n";;

