/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2023 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef ACTIONS_IN_ACTION_EXTENSION_H
#define ACTIONS_IN_ACTION_EXTENSION_H

#include <ActionExtension.h>

class HardCodedPipelineExtension : public camitk::ActionExtension {
    Q_OBJECT
    Q_INTERFACES(camitk::ActionExtension);
    Q_PLUGIN_METADATA(IID "fr.imag.camitk.tutorials.action.hardcodedpipeline")

public:
    /// Constructor
    HardCodedPipelineExtension() : ActionExtension() {};

    /// Destructor
    virtual ~HardCodedPipelineExtension() = default;

    /// Method returning the action extension name
    virtual QString getName() override {
        return "HardCodedPipelineExtension";
    };

    /// Method returning the action extension description
    virtual QString getDescription() override {
        return "Demo that apply two actions from another action";
    };

    /// initialize all the actions
    virtual void init() override;

};

#endif // ACTIONS_IN_ACTION_EXTENSION_H


