/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef VTK_MESH_COMPONENT_H
#define VTK_MESH_COMPONENT_H

#include <MeshComponent.h>

#include "VtkMeshComponentAPI.h"
#include "VtkMeshUtil.h"

#include <vtkSmartPointer.h>

class VtkMeshComponentProperties;
class vtkDoubleArray;
class vtkPointData;

/**
 *  @ingroup group_sdk_components_vtkmesh
 *
 *  @brief
 *  Features various Vtk mesh for CamiTK.
 *
 **/
class VTK_COMPONENT_API VtkMeshComponent : public camitk::MeshComponent {
    Q_OBJECT

public:
    /// default constructor
    VtkMeshComponent ( const QString& fileName ) throw (camitk::AbortException);

    /// the virtual destructor
    virtual ~VtkMeshComponent();

    /// reimplemented to visualize the picked points (demo)
    void pointPicked ( vtkIdType pointId, bool );

    /// reimplemented to visualize the picked cells (demo)
    void cellPicked ( vtkIdType cellId, bool );

    /// Export as MDL (see Geometry).
    bool exportMDL ( std::string filename );

    /// the vtk logo (for the explorer viewer)
    virtual QPixmap getIcon();

    /// two point data can be displayed here: the demo (used when picked) or the initial point data (read from the file)
    enum VTK_COMPONENT_POINT_DATA_TYPE {
        NONE,
        DEMO,
        INITIAL
    };

    /// set which point data are displayed
    void showPointData ( VTK_COMPONENT_POINT_DATA_TYPE );

    /// update a specific property
    virtual void updateProperty(QString name, QVariant value);

private:

    /// subtype of vtkPointSet
    VtkMeshUtil::VtkPointSetType whatIsIt;

    /// properties for vtk mesh type
    VtkMeshComponentProperties * myProperties;

    /// the vtk logo
    static QPixmap * myPixmap;

    /// the demo point data array (i.e the data value displayed when picked is the id of the point, in point picking, or the average of the point id, in cell picking)
    vtkSmartPointer<vtkDoubleArray> demoPointData;

    /// the initial/original point data that were read in the file
    vtkSmartPointer<vtkPointData> initialPointData;

    /// initialize the point data array
    void initPointData();

    // initialize the dynamic properties
    virtual void initDynamicProperties();

};




#endif
