/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef VTK_IMAGE_COMPONENT_H
#define VTK_IMAGE_COMPONENT_H

#include <vtkImageData.h>
#include <ImageComponent.h>


#include "VtkImageComponentAPI.h"
#include <QMetaProperty>
/**
 * @ingroup group_sdk_components_vtkimage
 *
 * @brief
 * This class manage vtk images, i.e images that can be loaded in CamiTK by using an VTK importer.
 *
 **/
class VTK_IMAGE_COMPONENT_API VtkImageComponent : public camitk::ImageComponent  {
    Q_OBJECT
public:
    /// default constructor: give it the name of the file containing the data
    VtkImageComponent(const QString&) throw (camitk::AbortException);

    /// needed for deleting
    virtual ~VtkImageComponent() {}

    /// actually create the component from the file
    virtual void createComponent(const QString&);

private:
    /**
     * Read the TranformMatrix tag (rotation of the image) from the input MHA/MHD image
     * @param fileName The input MHA / MHD file name to read the tag from.
     * @return A 4x4 homogenious matrix containing the Rotation information of the image
     */
    vtkSmartPointer<vtkMatrix4x4> readMetaImageTransformMatrix(const QString & fileName);
};



#endif // VTK_IMAGE_COMPONENT_H
