#! 
#! @ingroup group_sdk_cmake
#!
#! macro camitk_sub_project_validate validates the xml_subprojects variable by ending its xml tag
#! i.e. By adding the closing </Project> xml node, this will close the xml data
#! Then create the '${CMAKE_BINARY_DIR}/Project.xml file 
#! Use this file to send to the DashBoard to get the CEP and its subprojects definition
#!
#! Usage:
#! \code
#! camitk_sub_project_validate()
#! \endcode
#!
#! \param CEP_SET (optional)   should be added only if this is a CEP set validation
macro(camitk_sub_project_validate)
    parse_arguments(ADD_SUB_PROJECT_VALIDATE
            ""        # possible lists
            "CEP_SET" # possible options
            ${ARGN}
    )
    
    # if this a standalone CEP, then write the cdash xml report
    if(NOT CAMITK_EXTENSION_PROJECT_SET OR ADD_SUB_PROJECT_VALIDATE_CEP_SET)
        # Add the CDash dependencies in the correct order 
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_corelibraries})
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_libraries})
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_action_application})
        # Add application-testcomponents
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"application-testcomponents\"> ")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n    <Dependency name=\"library-camitkcore \"/>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n    <Dependency name=\"action-application \"/>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_components})
        # Add application-testactions
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"application-testactions\"> ")
        list(REMOVE_DUPLICATES CAMITK_COMPONENT_TARGETS) # avoid duplicates
        foreach(DEPENDENCY ${CAMITK_COMPONENT_TARGETS})
            set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n    <Dependency name=\"${DEPENDENCY}\"/>")
        endforeach()
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_actions})
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} ${xml_subproject_applications})
    
        # Add packaging source, packaging and api_doc target
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"package-source\">\n  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"package\">\n  </SubProject>")
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n  <SubProject name=\"apidoc\">\n  </SubProject>")
        
        # Write down the Project.xml file
        set(CAMITK_XML_PROJECT_DESCRIPTION ${CAMITK_XML_PROJECT_DESCRIPTION} "\n</Project>")
        set(filename "${CMAKE_BINARY_DIR}/Project.xml")
        file(WRITE ${filename} ${CAMITK_XML_PROJECT_DESCRIPTION})
        message(STATUS "Generated ${filename} for project description")

        # Write down subprojects.cmake filename
        list(REMOVE_DUPLICATES CAMITK_SUBPROJECTS)
        set(filename "${CMAKE_BINARY_DIR}/Subprojects.cmake")
        file(WRITE ${filename} "set(CAMITK_SUBPROJECTS ${CAMITK_SUBPROJECTS})")
        message(STATUS "Generated ${filename} for subprojects listing")
    endif()
endmacro()
