/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "ExportAsMDL.h"

// Qt includes
#include <QString>
#include <QMessageBox>
#include <QTextStream>
#include <Application.h>
#include <QFileDialog>
#include <VtkMeshComponent.h>
#include <QPushButton>
#include <QLayout>

// CamiTK includes
#include <ActionWidget.h>

using namespace camitk;


// --------------- Constructor -------------------
ExportAsMDL::ExportAsMDL(ActionExtension * extension) : Action(extension) {
    // Setting name, description and input component
    setName("ExportAsMDL");
    setDescription(tr("Export As MDL"));
    setComponent("VtkMeshComponent");

    // Setting classification family and tags
    setFamily("Mesh Processing");

    // DO NOT Put any GUI instanciation here,
    // If you need, do it in getWidget() method, using lazy instanciation
}

// --------------- destructor -------------------
ExportAsMDL::~ExportAsMDL() {
    // Do not do anything yet.
    // Delete stuff if you create stuff
    // (except if you use smart pointers of course !!)
}

void ExportAsMDL::outputMDL() {

    QString ofile = QFileDialog::getSaveFileName(NULL, tr("Save As MDL..."), QString(), tr("MDL format(*.mdl)"));

    if (!ofile.isEmpty()) {
        outputfile->setText(ofile);
    }
}
void ExportAsMDL::outputFileChanged(const QString& ofile) {

    cout << "output file" << ofile.toStdString() << endl;
    fn = ofile;
}

// --------------- apply -------------------
Action::ApplyStatus ExportAsMDL::apply() {

    foreach (Component *comp, getTargets()) {
        VtkMeshComponent * input = dynamic_cast<VtkMeshComponent *> (comp);
        process(input);
    }

    return SUCCESS;
}

// --------------- process -------------------
void ExportAsMDL::process(MeshComponent * comp) {

    cout << "Action ExportAsMDL called on " << comp->getName().toStdString()  << endl;

    if (!fn.isEmpty()) {
        VtkMeshComponent * input = dynamic_cast<VtkMeshComponent *> (comp);
        if (input) {
            // if the filename does not have the ".mdl" extension, add it
            QString extension = fn.right(4);
            QString txt(".mdl");
            if (extension.compare(txt) != 0) {
                // add the extension to the filename
                fn += txt;
            }
            input->exportMDL(fn.toStdString());
        }
    } else {
        cout << "Provide an output file name. " << endl;
    }
}

// --------------- getWidget -------------------
QWidget* ExportAsMDL::getWidget() {
    // Use lazy instanciation (instanciate only once and when needed)
    // We will return the default action widget with an additionnal button

    // build or update the widget
    if ( !actionWidget ) {
        // Setting the widget containing the parameters, using the default widget
        actionWidget = new ActionWidget ( this );

        QPushButton *outputbutton = new QPushButton("Output file");
        outputfile = new QLineEdit();

        actionWidget->layout()->addWidget(outputbutton);
        actionWidget->layout()->addWidget(outputfile);

        QObject::connect(outputbutton, SIGNAL(released()), SLOT(outputMDL()));
        QObject::connect(outputfile, SIGNAL(textChanged(const QString &)), this, SLOT(outputFileChanged(const QString &)));
    } else {
        // make sure the widget has updated targets
        dynamic_cast<ActionWidget*> ( actionWidget )->updateTargets();
    }

    return actionWidget;
}


