/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

// -- Core stuff
#include "ActionExtension.h"
#include "Action.h"

namespace camitk {

// -------------------- destructor --------------------
ActionExtension::~ActionExtension() {
    while (!actions.empty()) {
        Action *toDelete = actions.takeFirst();
        // do not delete the "Quit" action: it is the action that triggers this delete!
        if (toDelete->getName()!= "Quit")
            delete toDelete;
    }
}

// -------------------- registerAction --------------------
void ActionExtension::registerAction(Action* action) {
    // simply add the action in the list
    actions.append(action);
}

// -------------------- getActions --------------------
const camitk::ActionList& ActionExtension::getActions() {
    return actions;
}


}
