/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <MeshComponent.h>
#include <Log.h>
#include <Application.h>

#include <vtkUnstructuredGrid.h>
#include <vtkGeometryFilter.h>
#include <vtkCleanPolyData.h>
#include <vtkExtractEdges.h>

using namespace camitk;

#include "ExtractEdges.h"

ExtractEdges::ExtractEdges(ActionExtension* extension) : Action(extension) {
    this->setName("Extract Edges");
    this->setDescription("Extract edges from a mesh");
    this->setComponent("MeshComponent");
    this->setFamily("Mesh Processing");
    this->addTag("ExtractEdges");
}


Action::ApplyStatus ExtractEdges::apply() {
    CAMITK_INFO("ExtractEdges", "apply", "Extracting edges " << getTargets().last()->getName().toStdString());

    // set waiting cursor and status bar
    QApplication::setOverrideCursor ( QCursor ( Qt::WaitCursor ) );
    Application::showStatusBarMessage("Extracting edges...");
    Application::resetProgressBar();

    // use the last target
    MeshComponent *targetMesh = dynamic_cast<MeshComponent*>(getTargets().last());

    vtkSmartPointer<vtkExtractEdges> extractEdgesFilter = vtkSmartPointer<vtkExtractEdges>::New();
    extractEdgesFilter->SetInput(targetMesh->getPointSet());
    extractEdgesFilter->Update();
    
    // create a new mesh Component    
    new MeshComponent(extractEdgesFilter->GetOutput(), targetMesh->getName() + " edges");
    Application::refresh();    

    // restore the normal cursor and progress bar
    Application::resetProgressBar();
    Application::showStatusBarMessage("");
    QApplication::restoreOverrideCursor();
    return SUCCESS;
}
