/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef PHYSICALMODELDCPOPUP_H
#define PHYSICALMODELDCPOPUP_H

#include <ComponentPopupMenu.h>

class StructuralComponent;
class LoadsManager;
/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 * 
 *  @brief
 *  The popup menu of the Physical Manager data component.
 *  Allows one to do different things directly from the DC popup (right-clic on
 *  the object or action menu when the physical model is selected)
 * 
 * 
 **/
class PMManagerDCPopup : public camitk::ComponentPopupMenu {

    Q_OBJECT

  public:
    /// the popup constructor
    PMManagerDCPopup(camitk::Component *, QWidget*);

    /// check which menus are possible, and enable them, disable the others
    void updateMenuActions();

  public slots:
    /// This slot allows you open a impload file
    void openLoads();

    /// this slot allows you to save the current impload file
    void saveLoads();

    /// this slot allows you to save the current impload to another file
    void saveAsLoads();

    /// this slot allows you to close the current impload file
    void closeLoads();

    /// this slot allows you to see the preview
    void previewLoads();

    /// this slot allows you to edit the current list of loads
    void editLoads();

    /// show the loads in 3D
    void displayLoads();

    /// show one of the atom data display
    void atomDataDisplay(QAction *);

    /// open the reference PML file
    void openReferencePML();

    /// atom data scale min/max can be fixed by the user
    void setAtomDataScale();

    /// show the simulator widgets
    void simulation();

    /*TODO fix import/export
    /// import from vtk
    void vtkImport();
*/

    /// to manage the clic on a recent load
    void openRecentLoad();

  private:
    /// menus id
    QAction *save, *saveAs, *close, *preview, *edit, *showLoads, *hideAtomData, *showAddOnAtomData, *showDisplacements, *showDistances, *showRENError, *fixAtomDataScale;

    /// max nr of recent loads to keep
    unsigned int maxNrOfRecents;

    /// current nr of recent loads kept
    unsigned int nrOfRecents;

    /// the recent loads popup
    QMenu * recentLoads;

    /// update the recent loads popup
    void updateRecentLoads();

    /// the recent loads file names
    QStringList recentLoadFiles;

    /// add a recent document to the list
    void addRecentLoads(QString);

    /// save the recent loads file name in the settings
    void saveRecentLoads();

    /// open a given loads file
    void openLoads(QString);

    /// the load manager for this PML
    LoadsManager * myLM;
protected:
    void getSettings();
};


#endif
