# ------------------------------------------
# Project version / CamiTKConfig generation
# ------------------------------------------
# A non-white space unique name for the CEP
set(CEP_NAME "SDK")

# Description of this CEP in few lines
set(CEP_DESCRIPTION "CamiTK SDK (Software Development Kit) is the base of all CEP.
This CEP is the base of CamiTK and is required to do any development in CamiTK. It provides the CamiTK core library, some essential component and action extensions to support the basic mesh and medical image formats, as well camitk-imp, camitk-wizard and camitk-asm (the action state machine application). The SDK is based on VTK and Qt, and that's all. Additionally to CamiTK core, it provides three useful libraries: coreschema (the CamiTK Core XML data-binding library), qtpropertybrowser (to build GUI for Qt's meta-property) and qcustomplot (simple but powerful plot widget for Qt).")

# Default application to run (change this if this cep provide an application extensions you want to run by default on MSVC)
set(CEP_DEFAULT_APPLICATION "camitk-imp")

# Package copy the CamiTKVersion.h to the source tree
if(NOT EXISTS ${CMAKE_CURRENT_SOURCE_DIR}/libraries/core/CamiTKVersion.h)
  # In svn checkouted source tree.
  find_package(Subversion QUIET)
  if(Subversion_FOUND)
    Subversion_WC_INFO(${CMAKE_CURRENT_SOURCE_DIR}/CMakeLists.txt CAMITK_SVN)
    set (CAMITK_VERSION_PATCH "${CAMITK_VERSION_PATCH}.${CAMITK_SVN_WC_REVISION}")
  else()
    set (CAMITK_VERSION_PATCH "${CAMITK_VERSION_PATCH}.svn")
  endif()
endif()

# specific version string using the svn revision
set(CAMITK_VERSION_STRING "${CAMITK_PROJECT_NAME} ${CAMITK_VERSION_MAJOR}.${CAMITK_VERSION_MINOR}.${CAMITK_VERSION_PATCH}")

# prepare the CamiTKConfig.cmake for installation (first delete it to force regeneration)
execute_process(COMMAND ${CMAKE_COMMAND} -E remove -f ${CMAKE_BINARY_DIR}/share/${CAMITK_SHORT_VERSION_STRING}/cmake/CamiTKConfig.cmake)
configure_file(${CMAKE_CURRENT_SOURCE_DIR}/cmake/modules/CamiTKConfig.cmake.in ${CMAKE_BINARY_DIR}/share/${CAMITK_SHORT_VERSION_STRING}/cmake/CamiTKConfig.cmake @ONLY)

# postfix for MSVC debug version
set(CAMITK_DEBUG_POSTFIX "-debug")

# prepare the file for the camitk package source build
configure_file(${CMAKE_CURRENT_SOURCE_DIR}/libraries/core/CamiTKVersion.h.in ${CMAKE_BINARY_DIR}/CamiTKPackageVersion.h @ONLY)
# now create the correct version header
configure_file(${CMAKE_CURRENT_SOURCE_DIR}/libraries/core/CamiTKVersion.h.in ${CMAKE_CURRENT_BINARY_DIR}/libraries/core/CamiTKVersion.h)

set(CMAKE_MODULE_PATH ${CMAKE_MODULE_PATH} ${CMAKE_CURRENT_SOURCE_DIR})

message(STATUS "Welcome to ${CAMITK_VERSION_STRING} SDK compilation")
