/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file dataMonitoredList
 * @brief Create an object which contained mml data monitored from csv file 
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef DATAMONITOREDLIST_H
#define DATAMONITOREDLIST_H

#include <string>
#include <vector>

/**
 * Class which allows you to create an object which lists all data obtained in a csv file from mml2csv
 * @see mml2Csv
 */
class dataMonitoredList{

  public:
    /// constructor
    dataMonitoredList(std::string monitorName, std::vector<double> resultData);   
    /// constructor
    dataMonitoredList(std::string monitorName);
    /// destructor
    virtual ~dataMonitoredList();
    
    /// get the name of monitor
    std::string getMonitorName();
    
    /// get the list of result data
    std::vector<double> getResultData();
    
    /// method to add data in a std::vector
    void addResults(std::vector<double> results);
    
    /**
     * return the minimum of a std::vector @param resultData
     * @return the minimum in the std::vector
    */
    double getMin();
    
    /**
     * return the maximum of a std::vector @param resultData
     * @return the maximum in the std::vector
     */
    double getMax();
    /**
     * return the quartile separating values from 25% to 75% of a std::vector
     * @return the first quartile
     */
    double firstQuartile ();
    /**
     * return the median of a std::vector
     * @return the median
     */
    double median();
    /**
     * return the quartile separating values from 75% / 25%
     * @return the third quartile
     */
    double thirdQuartile();
    
    /**
     * return outliers from a std::vector
     * @return values that are considered as outliers (empiric)
     */
    std::vector<double> outliers();
  private:
    
    /// name of the monitored
    std::string monitorName;
    
    /// list of result data from monitored
    std::vector<double> resultData;    
    
};

#endif // DATAMONITOREDLIST_H