/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file csv2Sthing
 * @brief class to create dataMonitoredList
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#ifndef CSV2STHING_H
#define CSV2STHING_H

#include "../mml2Csv/dataMonitoredList.h"
#include <list>

/**
 * Generic class to construct objects from csv file.
 * @see csv2Stat
 * @see csv2Plot 
 */
class csv2Sthing {

public:
    /// constructor
    csv2Sthing(std::string file, std::list<std::string> item, std::list<dataMonitoredList> results);
    /// constructor
    csv2Sthing(std::string file, std::list<std::string> item);
    /// destructor
    virtual ~csv2Sthing();
    
    /**
     * Get data from a @class dataMonitoredList 
     */
    std::list<dataMonitoredList> getResultsData();

protected:
    std::list<std::string> item; 
    std::list<dataMonitoredList> results;
    std::string file;
    
    /// allows to create an object which contains results and associated items
    std::list< dataMonitoredList > createDataMonitoredList();
};

#endif // CSV2STHING_H
