/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2013 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
/**
 * @file csv2Sthing
 * @brief class to create dataMonitoredList
 * @author Johan Sarrazin
 * @date November 27 2012
 */

#include "csv2Sthing.h"
#include <iostream>
#include <fstream>
#include <complex>

//----------constructor----------------------------------------------------------------------------
csv2Sthing::csv2Sthing(std::string file, std::list< std::string, std::allocator< std::string > > item, std::list< dataMonitoredList, std::allocator< dataMonitoredList > > results)
{
    this->file=file;
    this->item=item;
    this->results=results;

}

//----------constructor------------------------------------------------------------------------------
csv2Sthing::csv2Sthing(std::string file, std::list< std::string, std::allocator< std::string > > item)
{
    this->file=file;
    this->item=item;
    this->results=createDataMonitoredList();
}

//----------destructor--
csv2Sthing::~csv2Sthing()
{

}

//------------------------------------getResultsData--------------------------------------------------
std::list< dataMonitoredList > csv2Sthing::getResultsData()
{
return results;
}


//-----------------------------------------------------------------------------createDataMonitoredList----
std::list< dataMonitoredList, std::allocator< dataMonitoredList > > csv2Sthing::createDataMonitoredList()
{
    std::stringstream stm;
    double d;
    std::string line;
    //open the csv file
    std::ifstream myfile (file.c_str());
    std::vector<double> tempResults;
    std::list<dataMonitoredList> list;
    std::string tempName ="";
    std::string parser="";
    if (myfile.is_open())
    {
        while ( myfile.good() )
        {
            //get the current line in the csv file
            std::getline (myfile,line);
            //get the name of the monitor
            if (line.length()!=0) {
                tempName = line.substr(0,line.find_first_of(","));
                //get values after the monitor
                parser=line.substr(line.find_first_of(",")+1);
                //search the next "," in the line
                std::size_t j=parser.find_first_of(",");

                while (j!=std::string::npos) {
                    stm.str(parser.substr(0,j));
                    stm >> d;
                    tempResults.push_back(d);
                    parser = parser.substr(j+1);
                    j=parser.find_first_of(",");

                    stm.clear();
                }
                //insert in a list of data with monitor name!
                list.push_back(dataMonitoredList(tempName,tempResults));
                tempResults.clear();
            }
        }
        myfile.close();
    }
    else {
        std::cerr<<"Warning: Cannot open the file !"<<std::endl;
    }
    return list;
}
